/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.transform;

import java.lang.reflect.Constructor;
import org.hibernate.QueryException;
import org.hibernate.transform.ResultTransformer;

public class AliasToBeanConstructorResultTransformer<T>
implements ResultTransformer<T> {
    private final Constructor<T> constructor;

    public AliasToBeanConstructorResultTransformer(Constructor<T> constructor) {
        this.constructor = constructor;
    }

    @Override
    public T transformTuple(Object[] tuple, String[] aliases) {
        try {
            return this.constructor.newInstance(tuple);
        }
        catch (Exception e) {
            throw new QueryException("could not instantiate class [" + this.constructor.getDeclaringClass().getName() + "] from tuple", e);
        }
    }

    public int hashCode() {
        return this.constructor.hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof AliasToBeanConstructorResultTransformer && this.constructor.equals(((AliasToBeanConstructorResultTransformer)other).constructor);
    }
}

