/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import jakarta.persistence.TemporalType;
import java.lang.reflect.Type;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Comparator;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.java.TemporalJavaType;
import org.hibernate.type.descriptor.java.VersionJavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.hibernate.type.spi.TypeConfiguration;
import org.jboss.logging.Logger;

@Deprecated
public class DbTimestampJavaType<T>
implements VersionJavaType<T>,
TemporalJavaType<T> {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)DbTimestampJavaType.class.getName());
    private final TemporalJavaType<T> delegate;

    public DbTimestampJavaType(TemporalJavaType<T> delegate) {
        this.delegate = delegate;
    }

    @Override
    public T next(T current, SharedSessionContractImplementor session) {
        return this.seed(session);
    }

    @Override
    public T seed(SharedSessionContractImplementor session) {
        if (session == null) {
            LOG.trace("Incoming session was null; using current jvm time");
            return ((VersionJavaType)((Object)this.delegate)).seed(null);
        }
        if (!session.getJdbcServices().getJdbcEnvironment().getDialect().supportsCurrentTimestampSelection()) {
            LOG.debug("Falling back to vm-based timestamp, as dialect does not support current timestamp selection");
            return ((VersionJavaType)((Object)this.delegate)).seed(session);
        }
        return this.getCurrentTimestamp(session);
    }

    private T getCurrentTimestamp(SharedSessionContractImplementor session) {
        Dialect dialect = session.getJdbcServices().getJdbcEnvironment().getDialect();
        String timestampSelectString = dialect.getCurrentTimestampSelectString();
        if (dialect.isCurrentTimestampSelectStringCallable()) {
            return this.useCallableStatement(timestampSelectString, session);
        }
        return this.usePreparedStatement(timestampSelectString, session);
    }

    private T usePreparedStatement(String timestampSelectString, SharedSessionContractImplementor session) {
        PreparedStatement ps = null;
        try {
            ps = session.getJdbcCoordinator().getStatementPreparer().prepareStatement(timestampSelectString, false);
            ResultSet rs = session.getJdbcCoordinator().getResultSetReturn().extract(ps);
            rs.next();
            Timestamp ts = rs.getTimestamp(1);
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Current timestamp retrieved from db : {0} (nanos={1}, time={2})", ts, ts.getNanos(), ts.getTime());
            }
            Object t = this.delegate.wrap(ts, session);
            return t;
        }
        catch (SQLException e) {
            throw session.getJdbcServices().getSqlExceptionHelper().convert(e, "could not select current db timestamp", timestampSelectString);
        }
        finally {
            if (ps != null) {
                session.getJdbcCoordinator().getLogicalConnection().getResourceRegistry().release(ps);
                session.getJdbcCoordinator().afterStatementExecution();
            }
        }
    }

    private T useCallableStatement(String callString, SharedSessionContractImplementor session) {
        CallableStatement cs = null;
        try {
            cs = (CallableStatement)session.getJdbcCoordinator().getStatementPreparer().prepareStatement(callString, true);
            cs.registerOutParameter(1, 93);
            session.getJdbcCoordinator().getResultSetReturn().execute(cs);
            Timestamp ts = cs.getTimestamp(1);
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Current timestamp retrieved from db : {0} (nanos={1}, time={2})", ts, ts.getNanos(), ts.getTime());
            }
            Object t = this.delegate.wrap(ts, session);
            return t;
        }
        catch (SQLException e) {
            throw session.getJdbcServices().getSqlExceptionHelper().convert(e, "could not call current db timestamp function", callString);
        }
        finally {
            if (cs != null) {
                session.getJdbcCoordinator().getLogicalConnection().getResourceRegistry().release(cs);
                session.getJdbcCoordinator().afterStatementExecution();
            }
        }
    }

    @Override
    public JdbcType getRecommendedJdbcType(JdbcTypeIndicators indicators) {
        return this.delegate.getRecommendedJdbcType(indicators);
    }

    @Override
    public T fromString(CharSequence string) {
        return this.delegate.fromString(string);
    }

    @Override
    public Type getJavaType() {
        return this.delegate.getJavaType();
    }

    @Override
    public MutabilityPlan<T> getMutabilityPlan() {
        return this.delegate.getMutabilityPlan();
    }

    @Override
    public long getDefaultSqlLength(Dialect dialect, JdbcType jdbcType) {
        return this.delegate.getDefaultSqlLength(dialect, jdbcType);
    }

    @Override
    public long getLongSqlLength() {
        return this.delegate.getLongSqlLength();
    }

    @Override
    public int getDefaultSqlPrecision(Dialect dialect, JdbcType jdbcType) {
        return this.delegate.getDefaultSqlPrecision(dialect, jdbcType);
    }

    @Override
    public int getDefaultSqlScale(Dialect dialect, JdbcType jdbcType) {
        return this.delegate.getDefaultSqlScale(dialect, jdbcType);
    }

    @Override
    public Comparator<T> getComparator() {
        return this.delegate.getComparator();
    }

    @Override
    public int extractHashCode(T value) {
        return this.delegate.extractHashCode(value);
    }

    @Override
    public boolean areEqual(T one, T another) {
        return this.delegate.areEqual(one, another);
    }

    @Override
    public String extractLoggableRepresentation(T value) {
        return this.delegate.extractLoggableRepresentation(value);
    }

    @Override
    public String toString(T value) {
        return this.delegate.toString(value);
    }

    @Override
    public <X> X unwrap(T value, Class<X> type, WrapperOptions options) {
        return this.delegate.unwrap(value, type, options);
    }

    @Override
    public <X> T wrap(X value, WrapperOptions options) {
        return this.delegate.wrap(value, options);
    }

    @Override
    public <X> T coerce(X value, JavaType.CoercionContext coercionContext) {
        return this.delegate.coerce(value, coercionContext);
    }

    @Override
    public Class<T> getJavaTypeClass() {
        return this.delegate.getJavaTypeClass();
    }

    @Override
    public String getCheckCondition(String columnName, JdbcType sqlType, Dialect dialect) {
        return this.delegate.getCheckCondition(columnName, sqlType, dialect);
    }

    @Override
    public TemporalType getPrecision() {
        return this.delegate.getPrecision();
    }

    @Override
    public <X> TemporalJavaType<X> resolveTypeForPrecision(TemporalType precision, TypeConfiguration typeConfiguration) {
        return this.delegate.resolveTypeForPrecision(precision, typeConfiguration);
    }
}

