/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.Duration;
import java.util.Locale;
import org.hibernate.dialect.Dialect;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractClassJavaType;
import org.hibernate.type.descriptor.java.ImmutableMutabilityPlan;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;

public class DurationJavaType
extends AbstractClassJavaType<Duration> {
    public static final DurationJavaType INSTANCE = new DurationJavaType();
    private static final DecimalFormatSymbols DECIMAL_FORMAT_SYMBOLS = DecimalFormatSymbols.getInstance(Locale.ENGLISH);
    private static final ThreadLocal<DecimalFormat> DECIMAL_FORMAT = new ThreadLocal<DecimalFormat>(){

        @Override
        protected DecimalFormat initialValue() {
            return new DecimalFormat("0.000000000", DECIMAL_FORMAT_SYMBOLS);
        }
    };

    public DurationJavaType() {
        super(Duration.class, ImmutableMutabilityPlan.instance());
    }

    @Override
    public JdbcType getRecommendedJdbcType(JdbcTypeIndicators context) {
        return context.getTypeConfiguration().getJdbcTypeRegistry().getDescriptor(3100);
    }

    @Override
    public String toString(Duration value) {
        if (value == null) {
            return null;
        }
        String seconds = String.valueOf(value.getSeconds());
        String nanos = String.valueOf(value.getNano());
        String zeros = StringHelper.repeat('0', 9 - nanos.length());
        return seconds + zeros + nanos;
    }

    @Override
    public Duration fromString(CharSequence string) {
        if (string == null) {
            return null;
        }
        int cutoff = string.length() - 9;
        return Duration.ofSeconds(Long.parseLong(string.subSequence(0, cutoff).toString()), Long.parseLong(string.subSequence(cutoff, string.length()).toString()));
    }

    @Override
    public <X> X unwrap(Duration duration, Class<X> type, WrapperOptions options) {
        if (duration == null) {
            return null;
        }
        if (Duration.class.isAssignableFrom(type)) {
            return (X)duration;
        }
        if (BigDecimal.class.isAssignableFrom(type)) {
            return (X)new BigDecimal(duration.getSeconds()).movePointRight(9).add(new BigDecimal(duration.getNano())).movePointLeft(9);
        }
        if (String.class.isAssignableFrom(type)) {
            return (X)duration.toString();
        }
        if (Long.class.isAssignableFrom(type)) {
            return (X)Long.valueOf(duration.toNanos());
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> Duration wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (value instanceof Duration) {
            return (Duration)value;
        }
        if (value instanceof BigDecimal) {
            return this.fromDecimal(value);
        }
        if (value instanceof Double) {
            return this.fromDecimal(value);
        }
        if (value instanceof Long) {
            return Duration.ofNanos((Long)value);
        }
        if (value instanceof String) {
            return Duration.parse((String)value);
        }
        throw this.unknownWrap(value.getClass());
    }

    private Duration fromDecimal(Object number) {
        String formatted = DECIMAL_FORMAT.get().format(number);
        int dotIndex = formatted.indexOf(46);
        if (dotIndex == -1) {
            return Duration.ofSeconds(Long.parseLong(formatted));
        }
        return Duration.ofSeconds(Long.parseLong(formatted.substring(0, dotIndex)), Long.parseLong(formatted.substring(dotIndex + 1)));
    }

    @Override
    public int getDefaultSqlPrecision(Dialect dialect, JdbcType jdbcType) {
        if (jdbcType.getDefaultSqlTypeCode() == 3100) {
            return 18;
        }
        return Math.min(21, dialect.getDefaultDecimalPrecision());
    }

    @Override
    public int getDefaultSqlScale(Dialect dialect, JdbcType jdbcType) {
        return 9;
    }
}

