/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.sql.spi;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.type.descriptor.sql.DdlType;
import org.hibernate.type.spi.TypeConfiguration;
import org.jboss.logging.Logger;

public class DdlTypeRegistry
implements Serializable {
    private static final Logger log = Logger.getLogger(DdlTypeRegistry.class);
    private final Map<Integer, DdlType> ddlTypes = new HashMap<Integer, DdlType>();

    public DdlTypeRegistry(TypeConfiguration typeConfiguration) {
    }

    public void addDescriptor(DdlType ddlType) {
        DdlType previous = this.ddlTypes.put(ddlType.getSqlTypeCode(), ddlType);
        if (previous != null && previous != ddlType) {
            log.debugf("addDescriptor(%s) replaced previous registration(%s)", (Object)ddlType, (Object)previous);
        }
    }

    public void addDescriptor(int sqlTypeCode, DdlType ddlType) {
        DdlType previous = this.ddlTypes.put(sqlTypeCode, ddlType);
        if (previous != null && previous != ddlType) {
            log.debugf("addDescriptor(%d, %s) replaced previous registration(%s)", sqlTypeCode, (Object)ddlType, (Object)previous);
        }
    }

    public void addDescriptorIfAbsent(DdlType jdbcType) {
        this.ddlTypes.putIfAbsent(jdbcType.getSqlTypeCode(), jdbcType);
    }

    public void addDescriptorIfAbsent(int sqlTypeCode, DdlType jdbcType) {
        this.ddlTypes.putIfAbsent(sqlTypeCode, jdbcType);
    }

    public DdlType getDescriptor(int sqlTypeCode) {
        DdlType ddlType = this.ddlTypes.get(sqlTypeCode);
        if (ddlType == null) {
            switch (sqlTypeCode) {
                case -1: {
                    return this.ddlTypes.get(12);
                }
                case -16: {
                    return this.ddlTypes.get(-9);
                }
                case -4: {
                    return this.ddlTypes.get(-3);
                }
            }
        }
        return ddlType;
    }

    public String getTypeName(int typeCode, Dialect dialect) {
        switch (typeCode) {
            case 2: 
            case 3: {
                return this.getTypeName(typeCode, Size.precision(dialect.getDefaultDecimalPrecision()));
            }
            case 6: 
            case 7: {
                return this.getTypeName(typeCode, Size.precision(dialect.getFloatPrecision()));
            }
            case 8: {
                return this.getTypeName(typeCode, Size.precision(dialect.getDoublePrecision()));
            }
            case 93: 
            case 2014: 
            case 3003: {
                return this.getTypeName(typeCode, Size.precision(dialect.getDefaultTimestampPrecision()));
            }
        }
        return this.getTypeName(typeCode, Size.nil());
    }

    public String getTypeName(int typeCode, Size size) {
        return this.getTypeName(typeCode, size.getLength(), size.getPrecision(), size.getScale());
    }

    public String getTypeName(int typeCode, Long size, Integer precision, Integer scale) {
        DdlType descriptor = this.getDescriptor(typeCode);
        if (descriptor == null) {
            throw new HibernateException(String.format("No type mapping for java.sql.Types code: %s", typeCode));
        }
        return descriptor.getTypeName(size, precision, scale);
    }

    public boolean isTypeNameRegistered(String typeName) {
        for (DdlType value : this.ddlTypes.values()) {
            if (!value.getRawTypeName().equals(typeName)) continue;
            return true;
        }
        return false;
    }
}

