/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.internal;

import java.io.Serializable;
import java.util.Comparator;
import org.hibernate.SharedSessionContract;
import org.hibernate.annotations.Immutable;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.ImmutableMutabilityPlan;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.java.MutabilityPlanExposer;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.hibernate.usertype.CompositeUserType;

public class CompositeUserTypeJavaTypeWrapper<J>
implements JavaType<J> {
    protected final CompositeUserType<J> userType;
    private final MutabilityPlan<J> mutabilityPlan;
    private final Comparator<J> comparator;

    public CompositeUserTypeJavaTypeWrapper(CompositeUserType<J> userType) {
        Class<J> jClass;
        this.userType = userType;
        MutabilityPlan resolvedMutabilityPlan = null;
        if (userType instanceof MutabilityPlanExposer) {
            resolvedMutabilityPlan = ((MutabilityPlanExposer)((Object)userType)).getExposedMutabilityPlan();
        }
        if (resolvedMutabilityPlan == null && (jClass = userType.returnedClass()) != null && jClass.getAnnotation(Immutable.class) != null) {
            resolvedMutabilityPlan = ImmutableMutabilityPlan.instance();
        }
        if (resolvedMutabilityPlan == null) {
            resolvedMutabilityPlan = new MutabilityPlanWrapper(userType);
        }
        this.mutabilityPlan = resolvedMutabilityPlan;
        this.comparator = userType instanceof Comparator ? (Comparator)((Object)userType) : this::compare;
    }

    private int compare(J first, J second) {
        if (this.userType.equals(first, second)) {
            return 0;
        }
        return Comparator.comparing(this.userType::hashCode).compare(first, second);
    }

    @Override
    public MutabilityPlan<J> getMutabilityPlan() {
        return this.mutabilityPlan;
    }

    @Override
    public JdbcType getRecommendedJdbcType(JdbcTypeIndicators context) {
        return null;
    }

    @Override
    public Comparator<J> getComparator() {
        return this.comparator;
    }

    @Override
    public int extractHashCode(J value) {
        return this.userType.hashCode(value);
    }

    @Override
    public boolean areEqual(J one, J another) {
        return this.userType.equals(one, another);
    }

    @Override
    public J fromString(CharSequence string) {
        throw new UnsupportedOperationException("No support for parsing UserType values from String: " + this.userType);
    }

    @Override
    public <X> X unwrap(J value, Class<X> type, WrapperOptions options) {
        assert (value == null || this.userType.returnedClass().isInstance(value));
        return (X)value;
    }

    @Override
    public <X> J wrap(X value, WrapperOptions options) {
        return (J)value;
    }

    @Override
    public Class<J> getJavaTypeClass() {
        return this.userType.returnedClass();
    }

    public static class MutabilityPlanWrapper<J>
    implements MutabilityPlan<J> {
        private final CompositeUserType<J> userType;

        public MutabilityPlanWrapper(CompositeUserType<J> userType) {
            this.userType = userType;
        }

        @Override
        public boolean isMutable() {
            return this.userType.isMutable();
        }

        @Override
        public J deepCopy(J value) {
            return (J)this.userType.deepCopy(value);
        }

        @Override
        public Serializable disassemble(J value, SharedSessionContract session) {
            return this.userType.disassemble(value);
        }

        @Override
        public J assemble(Serializable cached, SharedSessionContract session) {
            return (J)this.userType.disassemble(cached);
        }
    }
}

