/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.jdbc;

import jakarta.persistence.TemporalType;
import java.lang.reflect.Type;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Instant;
import java.time.OffsetDateTime;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.BasicJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.internal.JdbcLiteralFormatterTemporal;
import org.hibernate.type.spi.TypeConfiguration;

public class InstantAsTimestampWithTimeZoneJdbcType
implements JdbcType {
    public static final InstantAsTimestampWithTimeZoneJdbcType INSTANCE = new InstantAsTimestampWithTimeZoneJdbcType();

    @Override
    public int getJdbcTypeCode() {
        return 2014;
    }

    @Override
    public int getDefaultSqlTypeCode() {
        return 3003;
    }

    @Override
    public String getFriendlyName() {
        return "TIMESTAMP_UTC";
    }

    public String toString() {
        return "TimestampUtcDescriptor";
    }

    @Override
    public <T> BasicJavaType<T> getJdbcRecommendedJavaTypeMapping(Integer length, Integer scale, TypeConfiguration typeConfiguration) {
        return (BasicJavaType)typeConfiguration.getJavaTypeRegistry().getDescriptor((Type)((Object)Instant.class));
    }

    @Override
    public <T> JdbcLiteralFormatter<T> getJdbcLiteralFormatter(JavaType<T> javaType) {
        return new JdbcLiteralFormatterTemporal<T>(javaType, TemporalType.TIMESTAMP);
    }

    @Override
    public <X> ValueBinder<X> getBinder(final JavaType<X> javaType) {
        return new BasicBinder<X>(javaType, this){

            @Override
            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions wrapperOptions) throws SQLException {
                OffsetDateTime dateTime = javaType.unwrap(value, OffsetDateTime.class, wrapperOptions);
                st.setObject(index, (Object)dateTime, 2014);
            }

            @Override
            protected void doBind(CallableStatement st, X value, String name, WrapperOptions wrapperOptions) throws SQLException {
                OffsetDateTime dateTime = javaType.unwrap(value, OffsetDateTime.class, wrapperOptions);
                st.setObject(name, (Object)dateTime, 2014);
            }
        };
    }

    @Override
    public <X> ValueExtractor<X> getExtractor(final JavaType<X> javaType) {
        return new BasicExtractor<X>(javaType, this){

            @Override
            protected X doExtract(ResultSet rs, int position, WrapperOptions wrapperOptions) throws SQLException {
                return javaType.wrap(rs.getObject(position, OffsetDateTime.class), wrapperOptions);
            }

            @Override
            protected X doExtract(CallableStatement statement, int position, WrapperOptions wrapperOptions) throws SQLException {
                return javaType.wrap(statement.getObject(position, OffsetDateTime.class), wrapperOptions);
            }

            @Override
            protected X doExtract(CallableStatement statement, String name, WrapperOptions wrapperOptions) throws SQLException {
                return javaType.wrap(statement.getObject(name, OffsetDateTime.class), wrapperOptions);
            }
        };
    }
}

