/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.hibernate.MappingException;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.boot.model.source.internal.hbm.MappingDocument;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.id.CompositeNestedGeneratedValueGenerator;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.factory.IdentifierGeneratorFactory;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.internal.util.collections.JoinedIterator;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.MetaAttributable;
import org.hibernate.mapping.MetaAttribute;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.PrimaryKey;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.SortableValue;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.ValueVisitor;
import org.hibernate.metamodel.spi.EmbeddableInstantiator;
import org.hibernate.property.access.spi.Setter;
import org.hibernate.type.ComponentType;
import org.hibernate.type.EmbeddedComponentType;
import org.hibernate.type.Type;

public class Component
extends SimpleValue
implements MetaAttributable,
SortableValue {
    private final ArrayList<Property> properties = new ArrayList();
    private int[] originalPropertyOrder = ArrayHelper.EMPTY_INT_ARRAY;
    private String componentClassName;
    private boolean embedded;
    private String parentProperty;
    private PersistentClass owner;
    private boolean dynamic;
    private Map metaAttributes;
    private boolean isKey;
    private String roleName;
    private Class<? extends EmbeddableInstantiator> customInstantiator;
    private volatile Type type;
    private List<Selectable> cachedSelectables;
    private List<Column> cachedColumns;
    private IdentifierGenerator builtIdentifierGenerator;

    public Component(MetadataBuildingContext metadata, PersistentClass owner) throws MappingException {
        this(metadata, owner.getTable(), owner);
    }

    public Component(MetadataBuildingContext metadata, Component component) throws MappingException {
        this(metadata, component.getTable(), component.getOwner());
    }

    public Component(MetadataBuildingContext metadata, Join join) throws MappingException {
        this(metadata, join.getTable(), join.getPersistentClass());
    }

    public Component(MetadataBuildingContext metadata, Collection collection) throws MappingException {
        this(metadata, collection.getCollectionTable(), collection.getOwner());
    }

    public Component(MetadataBuildingContext metadata, Table table, PersistentClass owner) throws MappingException {
        super(metadata, table);
        this.owner = owner;
        metadata.getMetadataCollector().registerComponent(this);
    }

    private Component(Component original) {
        super(original);
        this.properties.addAll(original.properties);
        this.originalPropertyOrder = (int[])original.originalPropertyOrder.clone();
        this.componentClassName = original.componentClassName;
        this.embedded = original.embedded;
        this.parentProperty = original.parentProperty;
        this.owner = original.owner;
        this.dynamic = original.dynamic;
        this.metaAttributes = original.metaAttributes == null ? null : new HashMap(original.metaAttributes);
        this.isKey = original.isKey;
        this.roleName = original.roleName;
        this.customInstantiator = original.customInstantiator;
        this.type = original.type;
    }

    @Override
    public Component copy() {
        return new Component(this);
    }

    public int getPropertySpan() {
        return this.properties.size();
    }

    public Iterator<Property> getPropertyIterator() {
        return this.properties.iterator();
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public void addProperty(Property p) {
        this.properties.add(p);
        this.propertiesListModified();
    }

    private void propertiesListModified() {
        this.cachedSelectables = null;
        this.cachedColumns = null;
    }

    @Override
    public void addColumn(Column column) {
        throw new UnsupportedOperationException("Cant add a column to a component");
    }

    @Override
    public int getColumnSpan() {
        int n = 0;
        for (Property property : this.getProperties()) {
            n += property.getColumnSpan();
        }
        return n;
    }

    @Override
    @Deprecated
    public Iterator<Selectable> getColumnIterator() {
        Iterator[] iters = new Iterator[this.getPropertySpan()];
        int i = 0;
        for (Property property : this.getProperties()) {
            iters[i++] = property.getColumnIterator();
        }
        return new JoinedIterator<Selectable>(iters);
    }

    @Override
    public List<Selectable> getSelectables() {
        if (this.cachedSelectables != null) {
            return this.cachedSelectables;
        }
        this.cachedSelectables = this.properties.stream().flatMap(p -> p.getSelectables().stream()).collect(Collectors.toList());
        return this.cachedSelectables;
    }

    @Override
    public List<Column> getColumns() {
        if (this.cachedColumns != null) {
            return this.cachedColumns;
        }
        this.cachedColumns = this.properties.stream().flatMap(p -> p.getValue().getColumns().stream()).collect(Collectors.toList());
        return this.cachedColumns;
    }

    public boolean isEmbedded() {
        return this.embedded;
    }

    public String getComponentClassName() {
        return this.componentClassName;
    }

    public Class<?> getComponentClass() throws MappingException {
        ClassLoaderService classLoaderService = this.getMetadata().getMetadataBuildingOptions().getServiceRegistry().getService(ClassLoaderService.class);
        try {
            return classLoaderService.classForName(this.componentClassName);
        }
        catch (ClassLoadingException e) {
            throw new MappingException("component class not found: " + this.componentClassName, (Throwable)((Object)e));
        }
    }

    public PersistentClass getOwner() {
        return this.owner;
    }

    public String getParentProperty() {
        return this.parentProperty;
    }

    public void setComponentClassName(String componentClass) {
        this.componentClassName = componentClass;
    }

    public void setEmbedded(boolean embedded) {
        this.embedded = embedded;
    }

    public void setOwner(PersistentClass owner) {
        this.owner = owner;
    }

    public void setParentProperty(String parentProperty) {
        this.parentProperty = parentProperty;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Type getType() throws MappingException {
        Type localType = this.type;
        if (localType == null) {
            Component component = this;
            synchronized (component) {
                localType = this.type;
                if (localType == null) {
                    this.sortProperties(true);
                    this.type = localType = this.isEmbedded() ? new EmbeddedComponentType(this, this.originalPropertyOrder, this.getBuildingContext()) : new ComponentType(this, this.originalPropertyOrder, this.getBuildingContext());
                }
            }
        }
        return localType;
    }

    @Override
    public void setTypeUsingReflection(String className, String propertyName) throws MappingException {
    }

    @Override
    public Map getMetaAttributes() {
        return this.metaAttributes;
    }

    @Override
    public MetaAttribute getMetaAttribute(String attributeName) {
        return this.metaAttributes == null ? null : (MetaAttribute)this.metaAttributes.get(attributeName);
    }

    @Override
    public void setMetaAttributes(Map metas) {
        this.metaAttributes = metas;
    }

    @Override
    public Object accept(ValueVisitor visitor) {
        return visitor.accept(this);
    }

    @Override
    public boolean isSame(SimpleValue other) {
        return other instanceof Component && this.isSame((Component)other);
    }

    public boolean isSame(Component other) {
        return super.isSame(other) && Objects.equals(this.properties, other.properties) && Objects.equals(this.componentClassName, other.componentClassName) && this.embedded == other.embedded && Objects.equals(this.parentProperty, other.parentProperty) && Objects.equals(this.metaAttributes, other.metaAttributes);
    }

    @Override
    public boolean[] getColumnInsertability() {
        boolean[] result = new boolean[this.getColumnSpan()];
        int i = 0;
        for (Property prop : this.getProperties()) {
            boolean[] chunk = prop.getValue().getColumnInsertability();
            if (prop.isInsertable()) {
                System.arraycopy(chunk, 0, result, i, chunk.length);
            }
            i += chunk.length;
        }
        return result;
    }

    @Override
    public boolean hasAnyInsertableColumns() {
        for (int i = 0; i < this.properties.size(); ++i) {
            Property property = this.properties.get(i);
            if (!property.getValue().hasAnyInsertableColumns()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean[] getColumnUpdateability() {
        boolean[] result = new boolean[this.getColumnSpan()];
        int i = 0;
        for (Property prop : this.getProperties()) {
            boolean[] chunk = prop.getValue().getColumnUpdateability();
            if (prop.isUpdateable()) {
                System.arraycopy(chunk, 0, result, i, chunk.length);
            }
            i += chunk.length;
        }
        return result;
    }

    @Override
    public boolean hasAnyUpdatableColumns() {
        for (int i = 0; i < this.properties.size(); ++i) {
            Property property = this.properties.get(i);
            if (!property.getValue().hasAnyUpdatableColumns()) continue;
            return true;
        }
        return false;
    }

    public boolean isKey() {
        return this.isKey;
    }

    public void setKey(boolean isKey) {
        this.isKey = isKey;
    }

    public boolean hasPojoRepresentation() {
        return this.componentClassName != null;
    }

    public Property getProperty(int index) {
        return this.properties.get(index);
    }

    public Property getProperty(String propertyName) throws MappingException {
        for (Property prop : this.getProperties()) {
            if (!prop.getName().equals(propertyName)) continue;
            return prop;
        }
        throw new MappingException("component: " + this.componentClassName + " property not found: " + propertyName);
    }

    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "(" + this.properties.toString() + ")";
    }

    @Override
    public IdentifierGenerator createIdentifierGenerator(IdentifierGeneratorFactory identifierGeneratorFactory, Dialect dialect, String defaultCatalog, String defaultSchema, RootClass rootClass) throws MappingException {
        if (this.builtIdentifierGenerator == null) {
            this.builtIdentifierGenerator = this.buildIdentifierGenerator(identifierGeneratorFactory, dialect, defaultCatalog, defaultSchema, rootClass);
        }
        return this.builtIdentifierGenerator;
    }

    private IdentifierGenerator buildIdentifierGenerator(IdentifierGeneratorFactory identifierGeneratorFactory, Dialect dialect, String defaultCatalog, String defaultSchema, RootClass rootClass) throws MappingException {
        boolean hasCustomGenerator;
        boolean bl = hasCustomGenerator = !"assigned".equals(this.getIdentifierGeneratorStrategy());
        if (hasCustomGenerator) {
            return super.createIdentifierGenerator(identifierGeneratorFactory, dialect, defaultCatalog, defaultSchema, rootClass);
        }
        Class<?> entityClass = rootClass.getMappedClass();
        Class<?> attributeDeclarer = rootClass.getIdentifierMapper() != null ? this.resolveComponentClass() : (rootClass.getIdentifierProperty() != null ? this.resolveComponentClass() : entityClass);
        StandardGenerationContextLocator locator = new StandardGenerationContextLocator(rootClass.getEntityName());
        CompositeNestedGeneratedValueGenerator generator = new CompositeNestedGeneratedValueGenerator(locator);
        for (Property property : this.getProperties()) {
            SimpleValue value;
            if (!property.getValue().isSimpleValue() || "assigned".equals((value = (SimpleValue)property.getValue()).getIdentifierGeneratorStrategy())) continue;
            IdentifierGenerator valueGenerator = value.createIdentifierGenerator(identifierGeneratorFactory, dialect, defaultCatalog, defaultSchema, rootClass);
            generator.addGeneratedValuePlan(new ValueGenerationPlan(valueGenerator, this.injector(property, attributeDeclarer)));
        }
        return generator;
    }

    private Setter injector(Property property, Class<?> attributeDeclarer) {
        return property.getPropertyAccessStrategy(attributeDeclarer).buildPropertyAccess(attributeDeclarer, property.getName(), true).getSetter();
    }

    private Class<?> resolveComponentClass() {
        try {
            return this.getComponentClass();
        }
        catch (Exception e) {
            return null;
        }
    }

    public void prepareForMappingModel() {
        this.getType();
    }

    @Override
    public boolean isSorted() {
        return this.originalPropertyOrder != ArrayHelper.EMPTY_INT_ARRAY;
    }

    @Override
    public int[] sortProperties() {
        return this.sortProperties(false);
    }

    private int[] sortProperties(boolean forceRetainOriginalOrder) {
        PrimaryKey primaryKey;
        int[] originalPropertyOrder;
        if (this.originalPropertyOrder != ArrayHelper.EMPTY_INT_ARRAY) {
            return this.originalPropertyOrder;
        }
        if (forceRetainOriginalOrder || this.isAlternateUniqueKey() || this.isEmbedded() || this.getBuildingContext() instanceof MappingDocument) {
            Object[] originalProperties = this.properties.toArray();
            this.properties.sort(Comparator.comparing(Property::getName));
            originalPropertyOrder = new int[originalProperties.length];
            for (int j = 0; j < originalPropertyOrder.length; ++j) {
                originalPropertyOrder[j] = this.properties.indexOf(originalProperties[j]);
            }
        } else {
            this.properties.sort(Comparator.comparing(Property::getName));
            originalPropertyOrder = null;
        }
        if (this.isKey && (primaryKey = this.getOwner().getTable().getPrimaryKey()) != null) {
            List<Column> columns = primaryKey.getColumns();
            columns.clear();
            for (int i = 0; i < this.properties.size(); ++i) {
                for (Selectable selectable : this.properties.get(i).getSelectables()) {
                    if (!(selectable instanceof Column)) continue;
                    columns.add((Column)selectable);
                }
            }
        }
        this.propertiesListModified();
        this.originalPropertyOrder = originalPropertyOrder;
        return originalPropertyOrder;
    }

    public Class<? extends EmbeddableInstantiator> getCustomInstantiator() {
        return this.customInstantiator;
    }

    public void setCustomInstantiator(Class<? extends EmbeddableInstantiator> customInstantiator) {
        this.customInstantiator = customInstantiator;
    }

    public static class ValueGenerationPlan
    implements CompositeNestedGeneratedValueGenerator.GenerationPlan {
        private final IdentifierGenerator subGenerator;
        private final Setter injector;

        public ValueGenerationPlan(IdentifierGenerator subGenerator, Setter injector) {
            this.subGenerator = subGenerator;
            this.injector = injector;
        }

        @Override
        public void execute(SharedSessionContractImplementor session, Object incomingObject, Object injectionContext) {
            Object generatedValue = this.subGenerator.generate(session, incomingObject);
            this.injector.set(injectionContext, generatedValue);
        }

        @Override
        public void registerExportables(Database database) {
            this.subGenerator.registerExportables(database);
        }

        @Override
        public void initialize(SqlStringGenerationContext context) {
            this.subGenerator.initialize(context);
        }
    }

    public static class StandardGenerationContextLocator
    implements CompositeNestedGeneratedValueGenerator.GenerationContextLocator {
        private final String entityName;

        public StandardGenerationContextLocator(String entityName) {
            this.entityName = entityName;
        }

        @Override
        public Object locateGenerationContext(SharedSessionContractImplementor session, Object incomingObject) {
            return session.getEntityPersister(this.entityName, incomingObject).getIdentifier(incomingObject, session);
        }
    }
}

