/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spi;

import java.io.Serializable;
import java.util.Objects;
import org.hibernate.Incubating;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.spi.DotIdentifierSequence;
import org.hibernate.spi.EntityIdentifierNavigablePath;
import org.hibernate.spi.TreatedNavigablePath;

@Incubating
public class NavigablePath
implements DotIdentifierSequence,
Serializable {
    public static final String IDENTIFIER_MAPPER_PROPERTY = "_identifierMapper";
    private final NavigablePath parent;
    private final String localName;
    private final String alias;
    private final String identifierForTableGroup;
    private final FullPathCalculator fullPathCalculator;
    private final int hashCode;

    public NavigablePath(String localName) {
        this(localName, null);
    }

    public NavigablePath(String rootName, String alias) {
        this.parent = null;
        this.alias = alias = StringHelper.nullIfEmpty(alias);
        this.localName = rootName;
        this.identifierForTableGroup = rootName;
        this.fullPathCalculator = NavigablePath::calculateRootFullPath;
        this.hashCode = this.localName.hashCode() + (alias == null ? 0 : alias.hashCode());
    }

    public NavigablePath(NavigablePath parent, String navigableName) {
        this(parent, navigableName, null);
    }

    public NavigablePath(NavigablePath parent, String localName, String alias) {
        assert (parent != null);
        this.parent = parent;
        this.alias = alias = StringHelper.nullIfEmpty(alias);
        String aliasedLocalName = alias == null ? localName : localName + "(" + alias + ")";
        this.hashCode = parent.hashCode() + aliasedLocalName.hashCode();
        if (IDENTIFIER_MAPPER_PROPERTY.equals(localName)) {
            this.localName = "";
            this.identifierForTableGroup = parent.getFullPath();
            this.fullPathCalculator = NavigablePath::calculateIdMapperFullPath;
        } else {
            this.localName = localName;
            this.identifierForTableGroup = StringHelper.isEmpty(parent.getIdentifierForTableGroup()) ? aliasedLocalName : parent.getIdentifierForTableGroup() + "." + localName;
            this.fullPathCalculator = NavigablePath::calculateNormalFullPath;
        }
    }

    public NavigablePath(NavigablePath parent, String localName, String alias, String identifierForTableGroup, FullPathCalculator fullPathCalculator, int hashCode) {
        this.parent = parent;
        this.localName = localName;
        this.hashCode = hashCode;
        this.alias = StringHelper.nullIfEmpty(alias);
        this.identifierForTableGroup = identifierForTableGroup;
        this.fullPathCalculator = fullPathCalculator;
    }

    @Override
    public NavigablePath getParent() {
        return this.parent instanceof TreatedNavigablePath ? this.parent.getParent() : this.parent;
    }

    @Override
    public String getLocalName() {
        return this.localName;
    }

    public String getAlias() {
        return this.alias;
    }

    public boolean isAliased() {
        return this.alias != null;
    }

    public String getIdentifierForTableGroup() {
        return this.identifierForTableGroup;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        DotIdentifierSequence otherPath = (DotIdentifierSequence)other;
        if (!this.localNamesMatch(otherPath)) {
            return false;
        }
        if (otherPath instanceof NavigablePath) {
            NavigablePath otherNavigablePath = (NavigablePath)otherPath;
            if (!Objects.equals(this.getAlias(), otherNavigablePath.getAlias())) {
                return false;
            }
        }
        return Objects.equals(this.getParent(), otherPath.getParent());
    }

    protected boolean localNamesMatch(DotIdentifierSequence other) {
        if (other instanceof EntityIdentifierNavigablePath) {
            return this.localNamesMatch((EntityIdentifierNavigablePath)other);
        }
        return Objects.equals(this.getLocalName(), other.getLocalName());
    }

    protected boolean localNamesMatch(EntityIdentifierNavigablePath other) {
        return Objects.equals(this.getLocalName(), other.getLocalName()) || Objects.equals(this.getLocalName(), other.getIdentifierAttributeName());
    }

    @Override
    public NavigablePath append(String property) {
        return new NavigablePath(this, property);
    }

    public NavigablePath append(String property, String alias) {
        return new NavigablePath(this, property, alias);
    }

    public NavigablePath treatAs(String entityName) {
        return new TreatedNavigablePath(this, entityName);
    }

    public NavigablePath treatAs(String entityName, String alias) {
        return new TreatedNavigablePath(this, entityName, alias);
    }

    public NavigablePath getRealParent() {
        return this.parent;
    }

    public boolean isParent(NavigablePath navigablePath) {
        while (navigablePath != null) {
            if (this.equals(navigablePath.getParent())) {
                return true;
            }
            navigablePath = navigablePath.getParent();
        }
        return false;
    }

    public String relativize(NavigablePath base) {
        RelativePathCollector pathCollector = new RelativePathCollector();
        this.relativize(base, pathCollector);
        return pathCollector.resolve();
    }

    protected void relativize(NavigablePath base, RelativePathCollector collector) {
        if (this == base) {
            collector.matchedBase = true;
            return;
        }
        if (!collector.matchedBase && this.parent != null) {
            this.parent.relativize(base, collector);
        }
        collector.collectPath(this.getLocalName());
    }

    @Override
    public String getFullPath() {
        return this.fullPathCalculator.calculateFullPath(this.parent, this.localName, this.alias);
    }

    public String toString() {
        return this.getFullPath();
    }

    protected static String calculateRootFullPath(NavigablePath parent, String rootName, String alias) {
        assert (parent == null);
        return alias == null ? rootName : rootName + "(" + alias + ")";
    }

    private static String calculateNormalFullPath(NavigablePath parent, String localName, String alias) {
        assert (parent != null);
        String parentFullPath = parent.getFullPath();
        String baseFullPath = StringHelper.isEmpty(parentFullPath) ? localName : parentFullPath + "." + localName;
        return alias == null ? baseFullPath : baseFullPath + "(" + alias + ")";
    }

    protected static String calculateIdMapperFullPath(NavigablePath parent, String localName, String alias) {
        return parent != null ? parent.getFullPath() : "";
    }

    @FunctionalInterface
    protected static interface FullPathCalculator
    extends Serializable {
        public String calculateFullPath(NavigablePath var1, String var2, String var3);
    }

    protected static class RelativePathCollector {
        private boolean matchedBase;
        private StringBuilder buffer;

        protected RelativePathCollector() {
        }

        public void collectPath(String path) {
            if (!this.matchedBase) {
                return;
            }
            if (this.buffer == null) {
                this.buffer = new StringBuilder();
            } else {
                this.buffer.append('.');
            }
            this.buffer.append(path);
        }

        public String resolve() {
            if (this.buffer == null) {
                return null;
            }
            return this.buffer.toString();
        }
    }
}

