/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import jakarta.persistence.TemporalType;
import java.lang.reflect.Type;
import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.PessimisticLockException;
import org.hibernate.QueryTimeoutException;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.NationalizationSupport;
import org.hibernate.dialect.OracleDialect;
import org.hibernate.dialect.PostgreSQLDriverKind;
import org.hibernate.dialect.PostgreSQLInetJdbcType;
import org.hibernate.dialect.PostgreSQLIntervalSecondJdbcType;
import org.hibernate.dialect.PostgreSQLJsonbJdbcType;
import org.hibernate.dialect.PostgreSQLSqlAstTranslator;
import org.hibernate.dialect.Replacer;
import org.hibernate.dialect.RowLockStrategy;
import org.hibernate.dialect.SelectItemReferenceStrategy;
import org.hibernate.dialect.TimeZoneSupport;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.identity.PostgreSQLIdentityColumnSupport;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.LimitOffsetLimitHandler;
import org.hibernate.dialect.pagination.OffsetFetchLimitHandler;
import org.hibernate.dialect.sequence.PostgreSQLSequenceSupport;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.jdbc.env.spi.IdentifierCaseStrategy;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelper;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelperBuilder;
import org.hibernate.engine.jdbc.env.spi.NameQualifierSupport;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.exception.LockAcquisitionException;
import org.hibernate.exception.spi.SQLExceptionConversionDelegate;
import org.hibernate.exception.spi.TemplatedViolatedConstraintNameExtractor;
import org.hibernate.exception.spi.ViolatedConstraintNameExtractor;
import org.hibernate.internal.util.JdbcExceptionHelper;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.procedure.internal.PostgresCallableStatementSupport;
import org.hibernate.procedure.spi.CallableStatementSupport;
import org.hibernate.query.SemanticException;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.FetchClauseType;
import org.hibernate.query.sqm.IntervalType;
import org.hibernate.query.sqm.TemporalUnit;
import org.hibernate.query.sqm.mutation.internal.cte.CteInsertStrategy;
import org.hibernate.query.sqm.mutation.internal.cte.CteMutationStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableInsertStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableMutationStrategy;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.type.JavaObjectType;
import org.hibernate.type.descriptor.DateTimeUtils;
import org.hibernate.type.descriptor.java.PrimitiveByteArrayJavaType;
import org.hibernate.type.descriptor.jdbc.BlobJdbcType;
import org.hibernate.type.descriptor.jdbc.ClobJdbcType;
import org.hibernate.type.descriptor.jdbc.InstantAsTimestampWithTimeZoneJdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.ObjectNullAsBinaryTypeJdbcType;
import org.hibernate.type.descriptor.jdbc.UUIDJdbcType;
import org.hibernate.type.descriptor.jdbc.XmlJdbcType;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;
import org.hibernate.type.descriptor.sql.internal.DdlTypeImpl;
import org.hibernate.type.descriptor.sql.internal.Scale6IntervalSecondDdlType;
import org.hibernate.type.descriptor.sql.spi.DdlTypeRegistry;
import org.hibernate.type.spi.TypeConfiguration;

public class PostgreSQLDialect
extends Dialect {
    private static final PostgreSQLIdentityColumnSupport IDENTITY_COLUMN_SUPPORT = new PostgreSQLIdentityColumnSupport();
    private final PostgreSQLDriverKind driverKind;
    private static final ViolatedConstraintNameExtractor EXTRACTOR = new TemplatedViolatedConstraintNameExtractor(sqle -> {
        switch (Integer.parseInt(JdbcExceptionHelper.extractSqlState(sqle))) {
            case 23514: {
                return TemplatedViolatedConstraintNameExtractor.extractUsingTemplate("violates check constraint \"", "\"", sqle.getMessage());
            }
            case 23505: {
                return TemplatedViolatedConstraintNameExtractor.extractUsingTemplate("violates unique constraint \"", "\"", sqle.getMessage());
            }
            case 23503: {
                return TemplatedViolatedConstraintNameExtractor.extractUsingTemplate("violates foreign key constraint \"", "\"", sqle.getMessage());
            }
            case 23502: {
                return TemplatedViolatedConstraintNameExtractor.extractUsingTemplate("null value in column \"", "\" violates not-null constraint", sqle.getMessage());
            }
            case 23001: {
                return null;
            }
        }
        return null;
    });

    public PostgreSQLDialect() {
        this(DatabaseVersion.make(8, 0));
    }

    public PostgreSQLDialect(DialectResolutionInfo info) {
        super(info);
        this.driverKind = PostgreSQLDriverKind.determineKind(info);
    }

    public PostgreSQLDialect(DatabaseVersion version) {
        super(version);
        this.driverKind = PostgreSQLDriverKind.PG_JDBC;
    }

    public PostgreSQLDialect(DatabaseVersion version, PostgreSQLDriverKind driverKind) {
        super(version);
        this.driverKind = driverKind;
    }

    @Override
    public boolean getDefaultNonContextualLobCreation() {
        return true;
    }

    @Override
    protected String columnType(int sqlTypeCode) {
        switch (sqlTypeCode) {
            case -6: {
                return "smallint";
            }
            case -15: {
                return this.columnType(1);
            }
            case -9: {
                return this.columnType(12);
            }
            case 4001: 
            case 4002: {
                return "text";
            }
            case 2004: 
            case 2005: 
            case 2011: {
                return "oid";
            }
            case -3: 
            case -2: 
            case 4003: {
                return "bytea";
            }
            case 3003: {
                return this.columnType(2014);
            }
        }
        return super.columnType(sqlTypeCode);
    }

    @Override
    protected String castType(int sqlTypeCode) {
        switch (sqlTypeCode) {
            case -15: 
            case -9: 
            case 1: 
            case 12: 
            case 4001: 
            case 4002: {
                return "text";
            }
            case -3: 
            case -2: 
            case 4003: {
                return "bytea";
            }
        }
        return super.castType(sqlTypeCode);
    }

    @Override
    protected void registerColumnTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.registerColumnTypes(typeContributions, serviceRegistry);
        DdlTypeRegistry ddlTypeRegistry = typeContributions.getTypeConfiguration().getDdlTypeRegistry();
        ddlTypeRegistry.addDescriptor(new DdlTypeImpl(3002, "inet", this));
        ddlTypeRegistry.addDescriptor(new DdlTypeImpl(3200, "geometry", this));
        ddlTypeRegistry.addDescriptor(new DdlTypeImpl(3250, "geography", this));
        ddlTypeRegistry.addDescriptor(new Scale6IntervalSecondDdlType(this));
        ddlTypeRegistry.addDescriptor(new DdlTypeImpl(2009, "xml", this));
        if (this.getVersion().isSameOrAfter(8, 2)) {
            ddlTypeRegistry.addDescriptor(new DdlTypeImpl(3000, "uuid", this));
            if (this.getVersion().isSameOrAfter(9, 2)) {
                if (this.getVersion().isSameOrAfter(9, 4)) {
                    ddlTypeRegistry.addDescriptor(new DdlTypeImpl(3001, "jsonb", this));
                } else {
                    ddlTypeRegistry.addDescriptor(new DdlTypeImpl(3001, "json", this));
                }
            }
        }
    }

    @Override
    public int getMaxVarcharLength() {
        return 0xA00000;
    }

    @Override
    public int getMaxVarbinaryLength() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getDefaultStatementBatchSize() {
        return 15;
    }

    @Override
    public JdbcType resolveSqlTypeDescriptor(String columnTypeName, int jdbcTypeCode, int precision, int scale, JdbcTypeRegistry jdbcTypeRegistry) {
        if (jdbcTypeCode == 1111) {
            switch (columnTypeName) {
                case "uuid": {
                    jdbcTypeCode = 3000;
                    break;
                }
                case "json": 
                case "jsonb": {
                    jdbcTypeCode = 3001;
                    break;
                }
                case "xml": {
                    jdbcTypeCode = 2009;
                    break;
                }
                case "inet": {
                    jdbcTypeCode = 3002;
                    break;
                }
                case "geometry": {
                    jdbcTypeCode = 3200;
                    break;
                }
                case "geography": {
                    jdbcTypeCode = 3250;
                }
            }
        }
        return jdbcTypeRegistry.getDescriptor(jdbcTypeCode);
    }

    @Override
    public String currentTime() {
        return "localtime";
    }

    @Override
    public String currentTimestamp() {
        return "localtimestamp";
    }

    @Override
    public String currentTimestampWithTimeZone() {
        return "current_timestamp";
    }

    @Override
    public String extractPattern(TemporalUnit unit) {
        switch (unit) {
            case DAY_OF_WEEK: {
                return "(" + super.extractPattern(unit) + "+1)";
            }
        }
        return super.extractPattern(unit);
    }

    @Override
    public long getFractionalSecondPrecisionInNanos() {
        return 1000000000L;
    }

    @Override
    public String timestampaddPattern(TemporalUnit unit, TemporalType temporalType, IntervalType intervalType) {
        if (intervalType != null) {
            return "(?2+?3)";
        }
        switch (unit) {
            case NANOSECOND: {
                return "(?3+(?2)/1e3*interval '1 microsecond')";
            }
            case NATIVE: {
                return "(?3+(?2)*interval '1 second')";
            }
            case QUARTER: {
                return "(?3+(?2)*interval '3 month')";
            }
            case WEEK: {
                return "(?3+(?2)*interval '7 day')";
            }
        }
        return "(?3+(?2)*interval '1 ?1')";
    }

    @Override
    public String timestampdiffPattern(TemporalUnit unit, TemporalType fromTemporalType, TemporalType toTemporalType) {
        if (unit == null) {
            return "(?3-?2)";
        }
        if (toTemporalType != TemporalType.TIMESTAMP && fromTemporalType != TemporalType.TIMESTAMP && unit == TemporalUnit.DAY) {
            return "(?3-?2)";
        }
        StringBuilder pattern = new StringBuilder();
        switch (unit) {
            case YEAR: {
                this.extractField(pattern, TemporalUnit.YEAR, fromTemporalType, toTemporalType, unit);
                break;
            }
            case QUARTER: {
                pattern.append("(");
                this.extractField(pattern, TemporalUnit.YEAR, fromTemporalType, toTemporalType, unit);
                pattern.append("+");
                this.extractField(pattern, TemporalUnit.QUARTER, fromTemporalType, toTemporalType, unit);
                pattern.append(")");
                break;
            }
            case MONTH: {
                pattern.append("(");
                this.extractField(pattern, TemporalUnit.YEAR, fromTemporalType, toTemporalType, unit);
                pattern.append("+");
                this.extractField(pattern, TemporalUnit.MONTH, fromTemporalType, toTemporalType, unit);
                pattern.append(")");
                break;
            }
            case WEEK: 
            case DAY: {
                this.extractField(pattern, TemporalUnit.DAY, fromTemporalType, toTemporalType, unit);
                break;
            }
            case NANOSECOND: 
            case NATIVE: 
            case HOUR: 
            case MINUTE: 
            case SECOND: {
                this.extractField(pattern, TemporalUnit.EPOCH, fromTemporalType, toTemporalType, unit);
                break;
            }
            default: {
                throw new SemanticException("unrecognized field: " + unit);
            }
        }
        return pattern.toString();
    }

    protected void extractField(StringBuilder pattern, TemporalUnit unit, TemporalType fromTimestamp, TemporalType toTimestamp, TemporalUnit toUnit) {
        pattern.append("extract(");
        pattern.append(this.translateDurationField(unit));
        pattern.append(" from ");
        if (toTimestamp != TemporalType.TIMESTAMP && fromTimestamp != TemporalType.TIMESTAMP) {
            pattern.append("age(?3,?2)");
        } else {
            switch (unit) {
                case QUARTER: 
                case YEAR: 
                case MONTH: {
                    pattern.append("age(?3,?2)");
                    break;
                }
                case DAY: 
                case HOUR: 
                case MINUTE: 
                case SECOND: 
                case EPOCH: {
                    pattern.append("?3-?2");
                    break;
                }
                default: {
                    throw new SemanticException(unit + " is not a legal field");
                }
            }
        }
        pattern.append(")").append(unit.conversionFactor(toUnit, this));
    }

    @Override
    public TimeZoneSupport getTimeZoneSupport() {
        return TimeZoneSupport.NORMALIZE;
    }

    @Override
    public void initializeFunctionRegistry(QueryEngine queryEngine) {
        super.initializeFunctionRegistry(queryEngine);
        CommonFunctionFactory functionFactory = new CommonFunctionFactory(queryEngine);
        functionFactory.round_floor();
        functionFactory.cot();
        functionFactory.radians();
        functionFactory.degrees();
        functionFactory.trunc();
        functionFactory.log();
        if (this.getVersion().isSameOrAfter(12)) {
            functionFactory.log10();
        } else {
            queryEngine.getSqmFunctionRegistry().registerAlternateKey("log10", "log");
        }
        functionFactory.cbrt();
        functionFactory.trim2();
        functionFactory.repeat();
        functionFactory.md5();
        functionFactory.initcap();
        functionFactory.substr();
        functionFactory.substring_substr();
        functionFactory.translate();
        functionFactory.toCharNumberDateTimestamp();
        functionFactory.concat_pipeOperator("convert_from(lo_get(?1),pg_client_encoding())");
        functionFactory.localtimeLocaltimestamp();
        functionFactory.dateTrunc();
        functionFactory.length_characterLength_pattern("length(lo_get(?1),pg_client_encoding())");
        functionFactory.bitLength_pattern("bit_length(?1)", "length(lo_get(?1))*8");
        functionFactory.octetLength_pattern("octet_length(?1)", "length(lo_get(?1))");
        functionFactory.ascii();
        functionFactory.char_chr();
        functionFactory.position();
        functionFactory.bitandorxornot_operator();
        functionFactory.bitAndOr();
        functionFactory.everyAny_boolAndOr();
        functionFactory.median_percentileCont(false);
        functionFactory.stddev();
        functionFactory.stddevPopSamp();
        functionFactory.variance();
        functionFactory.varPopSamp();
        functionFactory.covarPopSamp();
        functionFactory.corr();
        functionFactory.regrLinearRegressionAggregates();
        functionFactory.insert_overlay();
        functionFactory.overlay();
        functionFactory.soundex();
        functionFactory.locate_positionSubstring();
        functionFactory.windowFunctions();
        functionFactory.listagg_stringAgg("varchar");
        if (this.getVersion().isSameOrAfter(9, 4)) {
            functionFactory.makeDateTimeTimestamp();
            functionFactory.inverseDistributionOrderedSetAggregates();
            functionFactory.hypotheticalOrderedSetAggregates();
        }
    }

    @Override
    public NameQualifierSupport getNameQualifierSupport() {
        return NameQualifierSupport.SCHEMA;
    }

    @Override
    public String getCurrentSchemaCommand() {
        return "select current_schema()";
    }

    @Override
    public boolean supportsIfExistsBeforeTableName() {
        return this.getVersion().isSameOrAfter(8, 2);
    }

    @Override
    public boolean supportsIfExistsBeforeConstraintName() {
        return this.getVersion().isSameOrAfter(9);
    }

    @Override
    public boolean supportsIfExistsAfterAlterTable() {
        return this.getVersion().isSameOrAfter(9, 2);
    }

    @Override
    public boolean supportsValuesList() {
        return this.getVersion().isSameOrAfter(8, 2);
    }

    @Override
    public boolean supportsPartitionBy() {
        return this.getVersion().isSameOrAfter(9, 1);
    }

    @Override
    public boolean supportsNonQueryWithCTE() {
        return this.getVersion().isSameOrAfter(9, 1);
    }

    @Override
    public SequenceSupport getSequenceSupport() {
        return this.getVersion().isBefore(8, 2) ? PostgreSQLSequenceSupport.LEGACY_INSTANCE : PostgreSQLSequenceSupport.INSTANCE;
    }

    @Override
    public String getCascadeConstraintsString() {
        return " cascade";
    }

    @Override
    public String getQuerySequencesString() {
        return "select * from information_schema.sequences";
    }

    @Override
    public LimitHandler getLimitHandler() {
        return this.getVersion().isBefore(8, 4) ? LimitOffsetLimitHandler.INSTANCE : OffsetFetchLimitHandler.INSTANCE;
    }

    @Override
    public String getForUpdateString(String aliases) {
        return this.getForUpdateString() + " of " + aliases;
    }

    @Override
    public String getForUpdateString(String aliases, LockOptions lockOptions) {
        LockMode lockMode;
        if (aliases.isEmpty()) {
            lockMode = lockOptions.getLockMode();
            Iterator<Map.Entry<String, LockMode>> itr = lockOptions.getAliasLockIterator();
            while (itr.hasNext()) {
                Map.Entry<String, LockMode> entry = itr.next();
                LockMode lm = entry.getValue();
                if (!lm.greaterThan(lockMode)) continue;
                aliases = entry.getKey();
            }
        }
        if ((lockMode = lockOptions.getAliasSpecificLockMode(aliases)) == null) {
            lockMode = lockOptions.getLockMode();
        }
        switch (lockMode) {
            case PESSIMISTIC_READ: {
                return this.getReadLockString(aliases, lockOptions.getTimeOut());
            }
            case PESSIMISTIC_WRITE: {
                return this.getWriteLockString(aliases, lockOptions.getTimeOut());
            }
            case UPGRADE_NOWAIT: 
            case PESSIMISTIC_FORCE_INCREMENT: {
                return this.getForUpdateNowaitString(aliases);
            }
            case UPGRADE_SKIPLOCKED: {
                return this.getForUpdateSkipLockedString(aliases);
            }
        }
        return "";
    }

    @Override
    public String getNoColumnsInsertString() {
        return "default values";
    }

    @Override
    public String getCaseInsensitiveLike() {
        return "ilike";
    }

    @Override
    public boolean supportsCaseInsensitiveLike() {
        return true;
    }

    @Override
    public String getNativeIdentifierGeneratorStrategy() {
        return "sequence";
    }

    @Override
    public boolean supportsOuterJoinForUpdate() {
        return false;
    }

    @Override
    public boolean useInputStreamToInsertBlob() {
        return false;
    }

    @Override
    public String getSelectClauseNullString(int sqlType, TypeConfiguration typeConfiguration) {
        return "null::" + typeConfiguration.getDdlTypeRegistry().getDescriptor(sqlType).getRawTypeName();
    }

    @Override
    public boolean supportsCommentOn() {
        return true;
    }

    @Override
    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    @Override
    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    @Override
    public String getCurrentTimestampSelectString() {
        return "select now()";
    }

    @Override
    public boolean supportsTupleCounts() {
        return true;
    }

    @Override
    public boolean requiresParensForTupleDistinctCounts() {
        return true;
    }

    @Override
    public void appendBooleanValueString(SqlAppender appender, boolean bool) {
        appender.appendSql(bool);
    }

    @Override
    public IdentifierHelper buildIdentifierHelper(IdentifierHelperBuilder builder, DatabaseMetaData dbMetaData) throws SQLException {
        if (dbMetaData == null) {
            builder.setUnquotedCaseStrategy(IdentifierCaseStrategy.LOWER);
            builder.setQuotedCaseStrategy(IdentifierCaseStrategy.MIXED);
        }
        return super.buildIdentifierHelper(builder, dbMetaData);
    }

    @Override
    public SqmMultiTableMutationStrategy getFallbackSqmMutationStrategy(EntityMappingType rootEntityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new CteMutationStrategy(rootEntityDescriptor, runtimeModelCreationContext);
    }

    @Override
    public SqmMultiTableInsertStrategy getFallbackSqmInsertStrategy(EntityMappingType rootEntityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new CteInsertStrategy(rootEntityDescriptor, runtimeModelCreationContext);
    }

    @Override
    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            @Override
            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
                return new PostgreSQLSqlAstTranslator(sessionFactory, statement);
            }
        };
    }

    @Override
    public ViolatedConstraintNameExtractor getViolatedConstraintNameExtractor() {
        return EXTRACTOR;
    }

    @Override
    public SQLExceptionConversionDelegate buildSQLExceptionConversionDelegate() {
        return (sqlException, message, sql) -> {
            switch (JdbcExceptionHelper.extractSqlState(sqlException)) {
                case "40P01": {
                    return new LockAcquisitionException(message, sqlException, sql);
                }
                case "55P03": {
                    return new PessimisticLockException(message, sqlException, sql);
                }
                case "57014": {
                    return new QueryTimeoutException(message, sqlException, sql);
                }
            }
            return null;
        };
    }

    @Override
    public int registerResultSetOutParameter(CallableStatement statement, int col) throws SQLException {
        statement.registerOutParameter(col++, 1111);
        return col;
    }

    @Override
    public ResultSet getResultSet(CallableStatement ps) throws SQLException {
        ps.execute();
        return (ResultSet)ps.getObject(1);
    }

    @Override
    public boolean supportsLobValueChangePropagation() {
        return false;
    }

    @Override
    public boolean supportsUnboundedLobLocatorMaterialization() {
        return false;
    }

    @Override
    public SelectItemReferenceStrategy getGroupBySelectItemReferenceStrategy() {
        return SelectItemReferenceStrategy.POSITION;
    }

    @Override
    public CallableStatementSupport getCallableStatementSupport() {
        return PostgresCallableStatementSupport.INSTANCE;
    }

    @Override
    public ResultSet getResultSet(CallableStatement statement, int position) throws SQLException {
        if (position != 1) {
            throw new UnsupportedOperationException("PostgreSQL only supports REF_CURSOR parameters as the first parameter");
        }
        return (ResultSet)statement.getObject(1);
    }

    @Override
    public ResultSet getResultSet(CallableStatement statement, String name) throws SQLException {
        throw new UnsupportedOperationException("PostgreSQL only supports accessing REF_CURSOR parameters by position");
    }

    @Override
    public boolean qualifyIndexName() {
        return false;
    }

    @Override
    public IdentityColumnSupport getIdentityColumnSupport() {
        return IDENTITY_COLUMN_SUPPORT;
    }

    @Override
    public NationalizationSupport getNationalizationSupport() {
        return NationalizationSupport.IMPLICIT;
    }

    @Override
    public int getMaxIdentifierLength() {
        return 63;
    }

    @Override
    public boolean supportsJdbcConnectionLobCreation(DatabaseMetaData databaseMetaData) {
        return false;
    }

    @Override
    public void appendDatetimeFormat(SqlAppender appender, String format) {
        appender.appendSql(this.datetimeFormat(format).result());
    }

    public Replacer datetimeFormat(String format) {
        return OracleDialect.datetimeFormat(format, true, false).replace("SSSSSS", "US").replace("SSSSS", "US").replace("SSSS", "US").replace("SSS", "MS").replace("SS", "MS").replace("S", "MS").replace("ee", "ID").replace("e", "fmID").replace("zzz", "TZ").replace("zz", "TZ").replace("z", "TZ").replace("xxx", "OF").replace("xx", "OF").replace("x", "OF");
    }

    @Override
    public String translateExtractField(TemporalUnit unit) {
        switch (unit) {
            case DAY_OF_MONTH: {
                return "day";
            }
            case DAY_OF_YEAR: {
                return "doy";
            }
            case DAY_OF_WEEK: {
                return "dow";
            }
        }
        return super.translateExtractField(unit);
    }

    @Override
    public void appendBinaryLiteral(SqlAppender appender, byte[] bytes) {
        appender.appendSql("bytea '\\x");
        PrimitiveByteArrayJavaType.INSTANCE.appendString(appender, bytes);
        appender.appendSql('\'');
    }

    @Override
    public void appendDateTimeLiteral(SqlAppender appender, TemporalAccessor temporalAccessor, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("date '");
                DateTimeUtils.appendAsDate(appender, temporalAccessor);
                appender.appendSql('\'');
                break;
            }
            case TIME: {
                appender.appendSql("time '");
                DateTimeUtils.appendAsTime(appender, temporalAccessor, this.supportsTemporalLiteralOffset(), jdbcTimeZone);
                appender.appendSql('\'');
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("timestamp with time zone '");
                DateTimeUtils.appendAsTimestampWithMicros(appender, temporalAccessor, this.supportsTemporalLiteralOffset(), jdbcTimeZone);
                appender.appendSql('\'');
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public void appendDateTimeLiteral(SqlAppender appender, Date date, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("date '");
                DateTimeUtils.appendAsDate(appender, date);
                appender.appendSql('\'');
                break;
            }
            case TIME: {
                appender.appendSql("time '");
                DateTimeUtils.appendAsTime(appender, date);
                appender.appendSql('\'');
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("timestamp with time zone '");
                DateTimeUtils.appendAsTimestampWithMicros(appender, date, jdbcTimeZone);
                appender.appendSql('\'');
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public void appendDateTimeLiteral(SqlAppender appender, Calendar calendar, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("date '");
                DateTimeUtils.appendAsDate(appender, calendar);
                appender.appendSql('\'');
                break;
            }
            case TIME: {
                appender.appendSql("time '");
                DateTimeUtils.appendAsTime(appender, calendar);
                appender.appendSql('\'');
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("timestamp with time zone '");
                DateTimeUtils.appendAsTimestampWithMicros(appender, calendar, jdbcTimeZone);
                appender.appendSql('\'');
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    private String withTimeout(String lockString, int timeout) {
        switch (timeout) {
            case 0: {
                return this.supportsNoWait() ? lockString + " nowait" : lockString;
            }
            case -2: {
                return this.supportsSkipLocked() ? lockString + " skip locked" : lockString;
            }
        }
        return lockString;
    }

    @Override
    public String getWriteLockString(int timeout) {
        return this.withTimeout(this.getForUpdateString(), timeout);
    }

    @Override
    public String getWriteLockString(String aliases, int timeout) {
        return this.withTimeout(this.getForUpdateString(aliases), timeout);
    }

    @Override
    public String getReadLockString(int timeout) {
        return this.withTimeout(" for share", timeout);
    }

    @Override
    public String getReadLockString(String aliases, int timeout) {
        return this.withTimeout(" for share of " + aliases, timeout);
    }

    @Override
    public String getForUpdateNowaitString() {
        return this.supportsNoWait() ? " for update nowait" : this.getForUpdateString();
    }

    @Override
    public String getForUpdateNowaitString(String aliases) {
        return this.supportsNoWait() ? " for update of " + aliases + " nowait" : this.getForUpdateString(aliases);
    }

    @Override
    public String getForUpdateSkipLockedString() {
        return this.supportsSkipLocked() ? " for update skip locked" : this.getForUpdateString();
    }

    @Override
    public String getForUpdateSkipLockedString(String aliases) {
        return this.supportsSkipLocked() ? " for update of " + aliases + " skip locked" : this.getForUpdateString(aliases);
    }

    @Override
    public boolean supportsNoWait() {
        return this.getVersion().isSameOrAfter(8, 1);
    }

    @Override
    public boolean supportsWait() {
        return false;
    }

    @Override
    public boolean supportsSkipLocked() {
        return this.getVersion().isSameOrAfter(9, 5);
    }

    @Override
    public boolean supportsOffsetInSubquery() {
        return true;
    }

    @Override
    public boolean supportsWindowFunctions() {
        return true;
    }

    @Override
    public boolean supportsLateral() {
        return this.getVersion().isSameOrAfter(9, 3);
    }

    @Override
    public boolean supportsFetchClause(FetchClauseType type) {
        switch (type) {
            case ROWS_ONLY: {
                return this.getVersion().isSameOrAfter(8, 4);
            }
            case PERCENT_ONLY: 
            case PERCENT_WITH_TIES: {
                return false;
            }
            case ROWS_WITH_TIES: {
                return this.getVersion().isSameOrAfter(13);
            }
        }
        return false;
    }

    @Override
    public RowLockStrategy getWriteRowLockStrategy() {
        return RowLockStrategy.TABLE;
    }

    @Override
    public void augmentRecognizedTableTypes(List<String> tableTypesList) {
        super.augmentRecognizedTableTypes(tableTypesList);
        if (this.getVersion().isSameOrAfter(9, 3)) {
            tableTypesList.add("MATERIALIZED VIEW");
            if (this.getVersion().isSameOrAfter(10)) {
                tableTypesList.add("PARTITIONED TABLE");
            }
        }
    }

    @Override
    public void contributeTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.contributeTypes(typeContributions, serviceRegistry);
        JdbcTypeRegistry jdbcTypeRegistry = typeContributions.getTypeConfiguration().getJdbcTypeRegistry();
        jdbcTypeRegistry.addDescriptor(2004, BlobJdbcType.BLOB_BINDING);
        jdbcTypeRegistry.addDescriptor(2005, ClobJdbcType.CLOB_BINDING);
        jdbcTypeRegistry.addDescriptor(3003, InstantAsTimestampWithTimeZoneJdbcType.INSTANCE);
        jdbcTypeRegistry.addDescriptor(XmlJdbcType.INSTANCE);
        if (this.driverKind == PostgreSQLDriverKind.PG_JDBC) {
            jdbcTypeRegistry.addDescriptorIfAbsent(PostgreSQLInetJdbcType.INSTANCE);
            jdbcTypeRegistry.addDescriptorIfAbsent(PostgreSQLIntervalSecondJdbcType.INSTANCE);
            if (this.getVersion().isSameOrAfter(8, 2)) {
                jdbcTypeRegistry.addDescriptorIfAbsent(UUIDJdbcType.INSTANCE);
                if (this.getVersion().isSameOrAfter(9, 2)) {
                    jdbcTypeRegistry.addDescriptorIfAbsent(PostgreSQLJsonbJdbcType.INSTANCE);
                }
            }
        }
        typeContributions.contributeJdbcType(ObjectNullAsBinaryTypeJdbcType.INSTANCE);
        typeContributions.contributeType(new JavaObjectType((JdbcType)ObjectNullAsBinaryTypeJdbcType.INSTANCE, typeContributions.getTypeConfiguration().getJavaTypeRegistry().getDescriptor((Type)((Object)Object.class))));
    }
}

