/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal.cte;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.id.BulkInsertionCapableIdentifierGenerator;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.OptimizableGenerator;
import org.hibernate.id.PostInsertIdentifierGenerator;
import org.hibernate.id.enhanced.Optimizer;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.internal.util.collections.Stack;
import org.hibernate.metamodel.mapping.BasicValuedMapping;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.metamodel.mapping.SqlExpressible;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.query.SemanticException;
import org.hibernate.query.results.TableGroupImpl;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.sqm.BinaryArithmeticOperator;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.query.sqm.SortOrder;
import org.hibernate.query.sqm.function.SelfRenderingFunctionSqlAstExpression;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.internal.SqmJdbcExecutionContextAdapter;
import org.hibernate.query.sqm.internal.SqmUtil;
import org.hibernate.query.sqm.mutation.internal.InsertHandler;
import org.hibernate.query.sqm.mutation.internal.MultiTableSqmMutationConverter;
import org.hibernate.query.sqm.spi.SqmParameterMappingModelResolutionAccess;
import org.hibernate.query.sqm.sql.BaseSqmToSqlAstConverter;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.cte.SqmCteTable;
import org.hibernate.query.sqm.tree.cte.SqmCteTableColumn;
import org.hibernate.query.sqm.tree.domain.AbstractSqmFrom;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.expression.SqmStar;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.insert.SqmInsertSelectStatement;
import org.hibernate.query.sqm.tree.insert.SqmInsertStatement;
import org.hibernate.query.sqm.tree.insert.SqmInsertValuesStatement;
import org.hibernate.query.sqm.tree.insert.SqmValues;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAstProcessingState;
import org.hibernate.sql.ast.tree.cte.CteColumn;
import org.hibernate.sql.ast.tree.cte.CteContainer;
import org.hibernate.sql.ast.tree.cte.CteMaterialization;
import org.hibernate.sql.ast.tree.cte.CteStatement;
import org.hibernate.sql.ast.tree.cte.CteTable;
import org.hibernate.sql.ast.tree.cte.CteTableGroup;
import org.hibernate.sql.ast.tree.expression.BinaryArithmeticExpression;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.expression.Over;
import org.hibernate.sql.ast.tree.expression.QueryLiteral;
import org.hibernate.sql.ast.tree.expression.SelfRenderingSqlFragmentExpression;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;
import org.hibernate.sql.ast.tree.from.UnionTableReference;
import org.hibernate.sql.ast.tree.from.ValuesTableGroup;
import org.hibernate.sql.ast.tree.insert.InsertStatement;
import org.hibernate.sql.ast.tree.insert.Values;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.ast.tree.select.SortSpecification;
import org.hibernate.sql.ast.tree.update.Assignable;
import org.hibernate.sql.ast.tree.update.Assignment;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcSelect;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.sql.results.internal.SqlSelectionImpl;
import org.hibernate.sql.results.spi.ListResultsConsumer;
import org.hibernate.type.BasicType;
import org.hibernate.type.spi.TypeConfiguration;

public class CteInsertHandler
implements InsertHandler {
    public static final String DML_RESULT_TABLE_NAME_PREFIX = "dml_cte_";
    public static final String CTE_TABLE_IDENTIFIER = "id";
    public static final String ROW_NUMBERS_WITH_SEQUENCE_VALUE = "rows_with_next_val";
    private final SqmInsertStatement<?> sqmStatement;
    private final SessionFactoryImplementor sessionFactory;
    private final EntityMappingType entityDescriptor;
    private final SqmCteTable cteTable;
    private final DomainParameterXref domainParameterXref;

    public CteInsertHandler(SqmCteTable cteTable, SqmInsertStatement<?> sqmStatement, DomainParameterXref domainParameterXref, SessionFactoryImplementor sessionFactory) {
        this.sqmStatement = sqmStatement;
        this.sessionFactory = sessionFactory;
        String entityName = ((SqmRoot)this.sqmStatement.getTarget()).getModel().getHibernateEntityName();
        this.entityDescriptor = sessionFactory.getRuntimeMetamodels().getEntityMappingType(entityName);
        this.cteTable = cteTable;
        this.domainParameterXref = domainParameterXref;
    }

    public SqmInsertStatement<?> getSqmStatement() {
        return this.sqmStatement;
    }

    public EntityMappingType getEntityDescriptor() {
        return this.entityDescriptor;
    }

    public SqmCteTable getCteTable() {
        return this.cteTable;
    }

    @Override
    public int execute(DomainQueryExecutionContext executionContext) {
        CteStatement entityCte;
        SelectStatement queryStatement;
        SqmInsertStatement<?> sqmInsertStatement = this.getSqmStatement();
        SessionFactoryImplementor factory = executionContext.getSession().getFactory();
        EntityPersister entityDescriptor = this.getEntityDescriptor().getEntityPersister();
        String explicitDmlTargetAlias = ((AbstractSqmFrom)((Object)sqmInsertStatement.getTarget())).getExplicitAlias() == null ? "dml_target" : ((AbstractSqmFrom)((Object)sqmInsertStatement.getTarget())).getExplicitAlias();
        MultiTableSqmMutationConverter sqmConverter = new MultiTableSqmMutationConverter(entityDescriptor, (SqmStatement<?>)sqmInsertStatement, (SqmRoot<?>)sqmInsertStatement.getTarget(), explicitDmlTargetAlias, this.domainParameterXref, executionContext.getQueryOptions(), executionContext.getSession().getLoadQueryInfluencers(), executionContext.getQueryParameterBindings(), factory);
        TableGroup insertingTableGroup = sqmConverter.getMutatingTableGroup();
        Map<SqmParameter<Object>, List<List<JdbcParameter>>> parameterResolutions = this.domainParameterXref.getSqmParameterCount() == 0 ? Collections.emptyMap() : new IdentityHashMap();
        int size = this.sqmStatement.getInsertionTargetPaths().size();
        ArrayList<Map.Entry<SqmCteTableColumn, Assignment>> targetPathColumns = new ArrayList<Map.Entry<SqmCteTableColumn, Assignment>>(size);
        ArrayList<SqmCteTableColumn> targetPathSqmCteColumns = new ArrayList<SqmCteTableColumn>(size);
        final LinkedHashMap paramTypeResolutions = new LinkedHashMap();
        NamedTableReference entityTableReference = new NamedTableReference(this.cteTable.getCteName(), "temptable_", true, this.sessionFactory);
        InsertStatement insertStatement = new InsertStatement(entityTableReference);
        BaseSqmToSqlAstConverter.AdditionalInsertValues additionalInsertValues = sqmConverter.visitInsertionTargetPaths((assignable, columnReferences) -> {
            for (SqmCteTableColumn column : this.cteTable.getColumns()) {
                if (column.getType() != ((Expression)((Object)assignable)).getExpressionType()) continue;
                insertStatement.addTargetColumnReferences((List<ColumnReference>)columnReferences);
                targetPathSqmCteColumns.add(column);
                targetPathColumns.add(new AbstractMap.SimpleEntry<SqmCteTableColumn, Assignment>(column, new Assignment((Assignable)assignable, (Expression)((Object)assignable))));
                return;
            }
            throw new IllegalStateException("Couldn't find matching cte column for: " + ((Expression)((Object)assignable)).getExpressionType());
        }, sqmInsertStatement, entityDescriptor, insertingTableGroup, (sqmParameter, mappingType, jdbcParameters) -> {
            parameterResolutions.computeIfAbsent(sqmParameter, k -> new ArrayList(1)).add(jdbcParameters);
            paramTypeResolutions.put(sqmParameter, mappingType);
        });
        boolean assignsId = targetPathSqmCteColumns.contains(this.cteTable.getColumns().get(0));
        Stack<SqlAstProcessingState> processingStateStack = sqmConverter.getProcessingStateStack();
        SqlAstProcessingState oldState = processingStateStack.pop();
        if (sqmInsertStatement instanceof SqmInsertSelectStatement) {
            Object queryPart = sqmConverter.visitQueryPart(((SqmInsertSelectStatement)sqmInsertStatement).getSelectQueryPart());
            ((QueryPart)queryPart).visitQuerySpecs(querySpec -> {
                if (additionalInsertValues.applySelections((QuerySpec)querySpec, this.sessionFactory)) {
                    SqmCteTableColumn rowNumberColumn = this.cteTable.getColumns().get(this.cteTable.getColumns().size() - 1);
                    ColumnReference columnReference = new ColumnReference((String)null, rowNumberColumn.getColumnName(), false, null, null, (JdbcMapping)((Object)rowNumberColumn.getType()), this.sessionFactory);
                    insertStatement.getTargetColumnReferences().set(insertStatement.getTargetColumnReferences().size() - 1, columnReference);
                    targetPathSqmCteColumns.set(targetPathSqmCteColumns.size() - 1, rowNumberColumn);
                }
                if (!assignsId && entityDescriptor.getIdentifierGenerator() instanceof PostInsertIdentifierGenerator) {
                    BasicType<Integer> rowNumberType = this.sessionFactory.getTypeConfiguration().getBasicTypeForJavaType(Integer.class);
                    querySpec.getSelectClause().addSqlSelection(new SqlSelectionImpl(1, 0, new Over(new SelfRenderingFunctionSqlAstExpression("row_number", (appender, args, walker) -> appender.appendSql("row_number()"), Collections.emptyList(), rowNumberType, rowNumberType), Collections.emptyList(), Collections.emptyList())));
                }
            });
            queryStatement = new SelectStatement((QueryPart)queryPart);
        } else {
            List<SqmValues> sqmValuesList = ((SqmInsertValuesStatement)sqmInsertStatement).getValuesList();
            ArrayList<Values> valuesList = new ArrayList<Values>(sqmValuesList.size());
            for (SqmValues sqmValues : sqmValuesList) {
                Values values = sqmConverter.visitValues(sqmValues);
                additionalInsertValues.applyValues(values);
                valuesList.add(values);
            }
            QuerySpec querySpec2 = new QuerySpec(true);
            NavigablePath navigablePath2 = new NavigablePath(entityDescriptor.getRootPathName());
            ArrayList<String> columnNames = new ArrayList<String>(targetPathColumns.size());
            String valuesAlias = insertingTableGroup.getPrimaryTableReference().getIdentificationVariable();
            for (Map.Entry entry : targetPathColumns) {
                for (ColumnReference columnReference : ((Assignment)entry.getValue()).getAssignable().getColumnReferences()) {
                    columnNames.add(columnReference.getColumnExpression());
                    querySpec2.getSelectClause().addSqlSelection(new SqlSelectionImpl(1, 0, columnReference.getQualifier().equals(valuesAlias) ? columnReference : new ColumnReference(valuesAlias, columnReference.getColumnExpression(), false, null, null, columnReference.getJdbcMapping(), null)));
                }
            }
            ValuesTableGroup valuesTableGroup = new ValuesTableGroup(navigablePath2, entityDescriptor.getEntityPersister(), valuesList, insertingTableGroup.getPrimaryTableReference().getIdentificationVariable(), columnNames, true, factory);
            querySpec2.getFromClause().addRoot(valuesTableGroup);
            queryStatement = new SelectStatement(querySpec2);
        }
        processingStateStack.push(oldState);
        sqmConverter.pruneTableGroupJoins();
        if (!assignsId && entityDescriptor.getIdentifierGenerator() instanceof PostInsertIdentifierGenerator) {
            SqmCteTableColumn rowNumberColumn = this.cteTable.getColumns().get(this.cteTable.getColumns().size() - 1);
            ColumnReference columnReference = new ColumnReference((String)null, rowNumberColumn.getColumnName(), false, null, null, (JdbcMapping)((Object)rowNumberColumn.getType()), this.sessionFactory);
            insertStatement.getTargetColumnReferences().add(columnReference);
            targetPathSqmCteColumns.add(rowNumberColumn);
        }
        CteTable entityCteTable = BaseSqmToSqlAstConverter.createCteTable(this.getCteTable(), targetPathSqmCteColumns, factory);
        QuerySpec querySpec3 = new QuerySpec(true, 1);
        ArrayList domainResults = new ArrayList(1);
        SelectStatement statement = new SelectStatement(querySpec3, domainResults);
        if (additionalInsertValues.requiresRowNumberIntermediate()) {
            CteTable finalEntityCteTable;
            CteTable fullEntityCteTable = BaseSqmToSqlAstConverter.createCteTable(this.getCteTable(), factory);
            String baseTableName = "base_" + entityCteTable.getTableExpression();
            CteStatement cteStatement = new CteStatement(entityCteTable.withName(baseTableName), queryStatement, CteMaterialization.MATERIALIZED);
            statement.addCteStatement(cteStatement);
            CteColumn rowNumberColumn = fullEntityCteTable.getCteColumns().get(fullEntityCteTable.getCteColumns().size() - 1);
            ColumnReference rowNumberColumnReference = new ColumnReference("e", rowNumberColumn.getColumnExpression(), false, null, null, rowNumberColumn.getJdbcMapping(), factory);
            CteColumn idColumn = fullEntityCteTable.getCteColumns().get(0);
            BasicValuedMapping idType = (BasicValuedMapping)((Object)idColumn.getJdbcMapping());
            Optimizer optimizer = ((OptimizableGenerator)entityDescriptor.getIdentifierGenerator()).getOptimizer();
            BasicValuedMapping integerType = (BasicValuedMapping)((Object)rowNumberColumn.getJdbcMapping());
            BinaryArithmeticExpression rowNumberMinusOneModuloIncrement = new BinaryArithmeticExpression(new BinaryArithmeticExpression(rowNumberColumnReference, BinaryArithmeticOperator.SUBTRACT, new QueryLiteral<Integer>(1, (BasicValuedMapping)((Object)rowNumberColumn.getJdbcMapping())), integerType), BinaryArithmeticOperator.MODULO, new QueryLiteral<Integer>(optimizer.getIncrementSize(), integerType), integerType);
            QuerySpec rowsWithSequenceQuery = new QuerySpec(true);
            rowsWithSequenceQuery.getFromClause().addRoot(new CteTableGroup(new NamedTableReference(baseTableName, "e", false, factory)));
            rowsWithSequenceQuery.getSelectClause().addSqlSelection(new SqlSelectionImpl(1, 0, rowNumberColumnReference));
            String fragment = ((BulkInsertionCapableIdentifierGenerator)entityDescriptor.getIdentifierGenerator()).determineBulkInsertionIdentifierGenerationSelectFragment(this.sessionFactory.getSqlStringGenerationContext());
            rowsWithSequenceQuery.getSelectClause().addSqlSelection(new SqlSelectionImpl(2, 1, new SelfRenderingSqlFragmentExpression(fragment)));
            rowsWithSequenceQuery.applyPredicate(new ComparisonPredicate(rowNumberMinusOneModuloIncrement, ComparisonOperator.EQUAL, new QueryLiteral<Integer>(0, integerType)));
            CteTable rowsWithSequenceCteTable = new CteTable(ROW_NUMBERS_WITH_SEQUENCE_VALUE, Arrays.asList(rowNumberColumn, idColumn), this.sessionFactory);
            SelectStatement rowsWithSequenceStatement = new SelectStatement(rowsWithSequenceQuery);
            CteStatement rowsWithSequenceCte = new CteStatement(rowsWithSequenceCteTable, rowsWithSequenceStatement, CteMaterialization.MATERIALIZED);
            statement.addCteStatement(rowsWithSequenceCte);
            QuerySpec entityQuery = new QuerySpec(true);
            NavigablePath navigablePath3 = new NavigablePath(baseTableName);
            TableGroupImpl baseTableGroup = new TableGroupImpl(navigablePath3, null, new NamedTableReference(baseTableName, "e", false, factory), null);
            CteTableGroup rowsWithSequenceTableGroup = new CteTableGroup(new NamedTableReference(ROW_NUMBERS_WITH_SEQUENCE_VALUE, "t", false, factory));
            baseTableGroup.addTableGroupJoin(new TableGroupJoin(rowsWithSequenceTableGroup.getNavigablePath(), SqlAstJoinType.LEFT, rowsWithSequenceTableGroup, new ComparisonPredicate(new BinaryArithmeticExpression(rowNumberColumnReference, BinaryArithmeticOperator.SUBTRACT, rowNumberMinusOneModuloIncrement, integerType), ComparisonOperator.EQUAL, new ColumnReference("t", rowNumberColumn.getColumnExpression(), false, null, null, rowNumberColumn.getJdbcMapping(), factory))));
            entityQuery.getFromClause().addRoot(baseTableGroup);
            entityQuery.getSelectClause().addSqlSelection(new SqlSelectionImpl(1, 0, new BinaryArithmeticExpression(new ColumnReference("t", idColumn.getColumnExpression(), false, null, null, idColumn.getJdbcMapping(), factory), BinaryArithmeticOperator.ADD, new BinaryArithmeticExpression(rowNumberColumnReference, BinaryArithmeticOperator.SUBTRACT, new ColumnReference("t", rowNumberColumn.getColumnExpression(), false, null, null, rowNumberColumn.getJdbcMapping(), factory), integerType), idType)));
            if (targetPathSqmCteColumns.contains(this.getCteTable().getColumns().get(0))) {
                finalEntityCteTable = entityCteTable;
            } else {
                targetPathSqmCteColumns.add(0, this.getCteTable().getColumns().get(0));
                finalEntityCteTable = BaseSqmToSqlAstConverter.createCteTable(this.getCteTable(), targetPathSqmCteColumns, factory);
            }
            List<CteColumn> cteColumns = finalEntityCteTable.getCteColumns();
            for (int i = 1; i < cteColumns.size(); ++i) {
                CteColumn cteColumn = cteColumns.get(i);
                entityQuery.getSelectClause().addSqlSelection(new SqlSelectionImpl(i + 1, i, new ColumnReference("e", cteColumn.getColumnExpression(), false, null, null, cteColumn.getJdbcMapping(), factory)));
            }
            SelectStatement entityStatement = new SelectStatement(entityQuery);
            entityCte = new CteStatement(finalEntityCteTable, entityStatement, CteMaterialization.MATERIALIZED);
            statement.addCteStatement(entityCte);
        } else if (!assignsId && entityDescriptor.getIdentifierGenerator() instanceof PostInsertIdentifierGenerator) {
            String baseTableName = "base_" + entityCteTable.getTableExpression();
            CteStatement baseEntityCte = new CteStatement(entityCteTable.withName(baseTableName), queryStatement, CteMaterialization.MATERIALIZED);
            statement.addCteStatement(baseEntityCte);
            targetPathSqmCteColumns.add(0, this.cteTable.getColumns().get(0));
            CteTable cteTable = BaseSqmToSqlAstConverter.createCteTable(this.getCteTable(), targetPathSqmCteColumns, factory);
            QuerySpec finalQuerySpec = new QuerySpec(true);
            SelectStatement finalQueryStatement = new SelectStatement(finalQuerySpec);
            entityCte = new CteStatement(cteTable, finalQueryStatement, CteMaterialization.MATERIALIZED);
        } else {
            entityCte = new CteStatement(entityCteTable, queryStatement, CteMaterialization.MATERIALIZED);
            statement.addCteStatement(entityCte);
        }
        String baseInsertCte = this.addDmlCtes(statement, entityCte, targetPathColumns, assignsId, sqmConverter, parameterResolutions, factory);
        Expression count = this.createCountStar(factory, sqmConverter);
        domainResults.add(new BasicResult(0, null, ((SqlExpressible)((Object)count)).getJdbcMapping().getJavaTypeDescriptor()));
        querySpec3.getSelectClause().addSqlSelection(new SqlSelectionImpl(1, 0, count));
        querySpec3.getFromClause().addRoot(new CteTableGroup(new NamedTableReference(baseInsertCte, CTE_TABLE_IDENTIFIER, false, factory)));
        JdbcServices jdbcServices = factory.getJdbcServices();
        SqlAstTranslator<JdbcSelect> translator = jdbcServices.getJdbcEnvironment().getSqlAstTranslatorFactory().buildSelectTranslator(factory, statement);
        JdbcParameterBindings jdbcParameterBindings = SqmUtil.createJdbcParameterBindings(executionContext.getQueryParameterBindings(), this.domainParameterXref, SqmUtil.generateJdbcParamsXref(this.domainParameterXref, sqmConverter), factory.getRuntimeMetamodels().getMappingMetamodel(), navigablePath -> sqmConverter.getMutatingTableGroup(), new SqmParameterMappingModelResolutionAccess(){

            @Override
            public <T> MappingModelExpressible<T> getResolvedMappingModelType(SqmParameter<T> parameter) {
                return (MappingModelExpressible)paramTypeResolutions.get(parameter);
            }
        }, executionContext.getSession());
        JdbcSelect select = translator.translate(jdbcParameterBindings, executionContext.getQueryOptions());
        executionContext.getSession().autoFlushIfRequired(select.getAffectedTableNames());
        List<Object> list = jdbcServices.getJdbcSelectExecutor().list(select, jdbcParameterBindings, SqmJdbcExecutionContextAdapter.omittingLockingAndPaging(executionContext), row -> row[0], ListResultsConsumer.UniqueSemantic.NONE);
        return ((Number)list.get(0)).intValue();
    }

    private Expression createCountStar(SessionFactoryImplementor factory, MultiTableSqmMutationConverter sqmConverter) {
        SqmStar arg = new SqmStar(factory.getNodeBuilder());
        TypeConfiguration typeConfiguration = factory.getJpaMetamodel().getTypeConfiguration();
        return factory.getQueryEngine().getSqmFunctionRegistry().findFunctionDescriptor("count").generateSqmExpression(arg, null, factory.getQueryEngine(), typeConfiguration).convertToSqlAst(sqmConverter);
    }

    protected String addDmlCtes(CteContainer statement, CteStatement queryCte, List<Map.Entry<SqmCteTableColumn, Assignment>> assignments, boolean assignsId, MultiTableSqmMutationConverter sqmConverter, Map<SqmParameter<?>, List<List<JdbcParameter>>> parameterResolutions, SessionFactoryImplementor factory) {
        TableGroup updatingTableGroup = sqmConverter.getMutatingTableGroup();
        EntityMappingType entityDescriptor = this.getEntityDescriptor();
        EntityPersister entityPersister = entityDescriptor.getEntityPersister();
        String rootEntityName = entityPersister.getRootEntityName();
        EntityPersister rootEntityDescriptor = factory.getRuntimeMetamodels().getMappingMetamodel().getEntityDescriptor(rootEntityName);
        String hierarchyRootTableName = ((Joinable)((Object)rootEntityDescriptor)).getTableName();
        TableReference hierarchyRootTableReference = updatingTableGroup.resolveTableReference(updatingTableGroup.getNavigablePath(), hierarchyRootTableName);
        assert (hierarchyRootTableReference != null);
        HashMap<String, TableReference> tableReferenceByAlias = CollectionHelper.mapOfSize(updatingTableGroup.getTableReferenceJoins().size() + 1);
        this.collectTableReference(updatingTableGroup.getPrimaryTableReference(), tableReferenceByAlias::put);
        for (int i = 0; i < updatingTableGroup.getTableReferenceJoins().size(); ++i) {
            this.collectTableReference(updatingTableGroup.getTableReferenceJoins().get(i), tableReferenceByAlias::put);
        }
        HashMap assignmentsByTable = CollectionHelper.mapOfSize(updatingTableGroup.getTableReferenceJoins().size() + 1);
        for (int i = 0; i < assignments.size(); ++i) {
            Map.Entry<SqmCteTableColumn, Assignment> entry = assignments.get(i);
            Assignment assignment = entry.getValue();
            List<ColumnReference> assignmentColumnRefs = assignment.getAssignable().getColumnReferences();
            TableReference assignmentTableReference = null;
            for (int c = 0; c < assignmentColumnRefs.size(); ++c) {
                ColumnReference columnReference = assignmentColumnRefs.get(c);
                TableReference tableReference = this.resolveTableReference(columnReference, updatingTableGroup, tableReferenceByAlias);
                if (assignmentTableReference != null && !assignmentTableReference.equals(tableReference)) {
                    throw new IllegalStateException("Assignment referred to columns from multiple tables");
                }
                assignmentTableReference = tableReference;
            }
            assert (assignmentTableReference != null);
            ArrayList<Map.Entry<SqmCteTableColumn, Assignment>> assignmentsForTable = (ArrayList<Map.Entry<SqmCteTableColumn, Assignment>>)assignmentsByTable.get(assignmentTableReference);
            if (assignmentsForTable == null) {
                assignmentsForTable = new ArrayList<Map.Entry<SqmCteTableColumn, Assignment>>();
                assignmentsByTable.put(assignmentTableReference, assignmentsForTable);
            }
            assignmentsForTable.add(entry);
        }
        AbstractEntityPersister persister = (AbstractEntityPersister)entityDescriptor.getEntityPersister();
        String rootTableName = persister.getTableName(0);
        TableReference rootTableReference = updatingTableGroup.getTableReference(updatingTableGroup.getNavigablePath(), rootTableName, true, true);
        IdentifierGenerator identifierGenerator = entityDescriptor.getEntityPersister().getIdentifierGenerator();
        List tableAssignments = (List)assignmentsByTable.get(rootTableReference);
        if ((tableAssignments == null || tableAssignments.isEmpty()) && !(identifierGenerator instanceof PostInsertIdentifierGenerator)) {
            throw new IllegalStateException("There must be at least a single root table assignment");
        }
        int tableSpan = persister.getTableSpan();
        String[] rootKeyColumns = persister.getKeyColumns(0);
        List<CteColumn> keyCteColumns = queryCte.getCteTable().getCteColumns().subList(0, rootKeyColumns.length);
        for (int i = 0; i < tableSpan; ++i) {
            List<ColumnReference> insertColumnReferences;
            CteTable dmlResultCte;
            String cteTableName;
            String tableExpression = persister.getTableName(i);
            TableReference updatingTableReference = updatingTableGroup.getTableReference(updatingTableGroup.getNavigablePath(), tableExpression, true, true);
            List assignmentList = (List)assignmentsByTable.get(updatingTableReference);
            NamedTableReference dmlTableReference = this.resolveUnionTableReference(updatingTableReference, tableExpression);
            String[] keyColumns = persister.getKeyColumns(i);
            ArrayList<ColumnReference> returningColumnReferences = new ArrayList<ColumnReference>(keyColumns.length + (assignmentList == null ? 0 : assignmentList.size()));
            QuerySpec insertSelectSpec = new QuerySpec(true);
            CteStatement finalCteStatement = null;
            if (i == 0 && !assignsId && identifierGenerator instanceof PostInsertIdentifierGenerator) {
                cteTableName = this.getCteTableName(tableExpression, "base_");
                if (statement.getCteStatement(cteTableName) != null) continue;
                String baseTableName = "base_" + queryCte.getCteTable().getTableExpression();
                insertSelectSpec.getFromClause().addRoot(new CteTableGroup(new NamedTableReference(baseTableName, "e", false, factory)));
                CteColumn rowNumberColumn = queryCte.getCteTable().getCteColumns().get(queryCte.getCteTable().getCteColumns().size() - 1);
                ColumnReference rowNumberColumnReference = new ColumnReference("e", rowNumberColumn.getColumnExpression(), false, null, null, rowNumberColumn.getJdbcMapping(), factory);
                insertSelectSpec.addSortSpecification(new SortSpecification(rowNumberColumnReference, SortOrder.ASCENDING));
                ArrayList<CteColumn> returningColumns = new ArrayList<CteColumn>(keyCteColumns.size() + 1);
                returningColumns.addAll(keyCteColumns);
                dmlResultCte = new CteTable(cteTableName, returningColumns, factory);
                for (int j = 0; j < keyColumns.length; ++j) {
                    returningColumnReferences.add(new ColumnReference(dmlTableReference, keyColumns[j], false, null, null, null, factory));
                }
                insertColumnReferences = Collections.emptyList();
                SelectStatement queryStatement = (SelectStatement)queryCte.getCteDefinition();
                QuerySpec querySpec = queryStatement.getQuerySpec();
                NavigablePath navigablePath = new NavigablePath(baseTableName);
                TableGroupImpl baseTableGroup = new TableGroupImpl(navigablePath, null, new NamedTableReference(baseTableName, "e", false, factory), null);
                CteTableGroup rootInsertCteTableGroup = new CteTableGroup(new NamedTableReference(this.getCteTableName(tableExpression), "t", false, factory));
                baseTableGroup.addTableGroupJoin(new TableGroupJoin(rootInsertCteTableGroup.getNavigablePath(), SqlAstJoinType.INNER, rootInsertCteTableGroup, new ComparisonPredicate(rowNumberColumnReference, ComparisonOperator.EQUAL, new ColumnReference("t", rowNumberColumn.getColumnExpression(), false, null, null, rowNumberColumn.getJdbcMapping(), factory))));
                querySpec.getFromClause().addRoot(baseTableGroup);
                List<CteColumn> cteColumns = queryCte.getCteTable().getCteColumns();
                CteColumn idCteColumn = cteColumns.get(0);
                querySpec.getSelectClause().addSqlSelection(new SqlSelectionImpl(1, 0, new ColumnReference("t", idCteColumn.getColumnExpression(), false, null, null, idCteColumn.getJdbcMapping(), factory)));
                for (int j = 1; j < cteColumns.size(); ++j) {
                    CteColumn cteColumn = cteColumns.get(j);
                    querySpec.getSelectClause().addSqlSelection(new SqlSelectionImpl(1, 0, new ColumnReference("e", cteColumn.getColumnExpression(), false, null, null, cteColumn.getJdbcMapping(), factory)));
                }
                ArrayList<CteColumn> finalReturningColumns = new ArrayList<CteColumn>(keyCteColumns.size() + 1);
                finalReturningColumns.addAll(keyCteColumns);
                finalReturningColumns.add(rowNumberColumn);
                CteTable finalResultCte = new CteTable(this.getCteTableName(tableExpression), finalReturningColumns, factory);
                QuerySpec finalResultQuery = new QuerySpec(true);
                finalResultQuery.getFromClause().addRoot(new CteTableGroup(new NamedTableReference(dmlResultCte.getTableExpression(), "e", false, factory)));
                ColumnReference idColumnReference = new ColumnReference("e", idCteColumn.getColumnExpression(), false, null, null, idCteColumn.getJdbcMapping(), factory);
                finalResultQuery.getSelectClause().addSqlSelection(new SqlSelectionImpl(1, 0, idColumnReference));
                BasicType<Integer> rowNumberType = this.sessionFactory.getTypeConfiguration().getBasicTypeForJavaType(Integer.class);
                finalResultQuery.getSelectClause().addSqlSelection(new SqlSelectionImpl(1, 0, new Over(new SelfRenderingFunctionSqlAstExpression("row_number", (appender, args, walker) -> appender.appendSql("row_number()"), Collections.emptyList(), rowNumberType, rowNumberType), Collections.emptyList(), Collections.emptyList())));
                finalResultQuery.addSortSpecification(new SortSpecification(idColumnReference, SortOrder.ASCENDING));
                SelectStatement finalResultStatement = new SelectStatement(finalResultQuery);
                finalCteStatement = new CteStatement(finalResultCte, finalResultStatement);
            } else {
                cteTableName = this.getCteTableName(tableExpression);
                if (statement.getCteStatement(cteTableName) != null) continue;
                insertSelectSpec.getFromClause().addRoot(new CteTableGroup(new NamedTableReference(queryCte.getCteTable().getTableExpression(), "e", false, factory)));
                dmlResultCte = new CteTable(cteTableName, keyCteColumns, factory);
                for (int j = 0; j < keyColumns.length; ++j) {
                    returningColumnReferences.add(new ColumnReference(dmlTableReference, keyColumns[j], false, null, null, null, factory));
                    insertSelectSpec.getSelectClause().addSqlSelection(new SqlSelectionImpl(1, 0, new ColumnReference("e", rootKeyColumns[j], false, null, null, null, factory)));
                }
                insertColumnReferences = returningColumnReferences;
            }
            InsertStatement dmlStatement = new InsertStatement(dmlTableReference, returningColumnReferences);
            dmlStatement.addTargetColumnReferences(insertColumnReferences);
            if (assignmentList != null) {
                for (Map.Entry entry : assignmentList) {
                    Assignment assignment = (Assignment)entry.getValue();
                    if (assignment.getAssignedValue().getExpressionType() instanceof EntityIdentifierMapping) continue;
                    List<ColumnReference> assignmentReferences = assignment.getAssignable().getColumnReferences();
                    dmlStatement.addTargetColumnReferences(assignmentReferences);
                    int size = assignmentReferences.size();
                    for (int j = 0; j < size; ++j) {
                        ColumnReference columnReference = assignmentReferences.get(j);
                        String columnName = size > 1 ? ((SqmCteTableColumn)entry.getKey()).getColumnName() + "_" + i : ((SqmCteTableColumn)entry.getKey()).getColumnName();
                        insertSelectSpec.getSelectClause().addSqlSelection(new SqlSelectionImpl(1, 0, new ColumnReference("e", columnName, columnReference.isColumnExpressionFormula(), null, null, columnReference.getJdbcMapping(), factory)));
                    }
                }
            }
            dmlStatement.setSourceSelectStatement(insertSelectSpec);
            statement.addCteStatement(new CteStatement(dmlResultCte, dmlStatement));
            if (finalCteStatement != null) {
                statement.addCteStatement(finalCteStatement);
            }
            if (i != 0 || assignsId || !(identifierGenerator instanceof PostInsertIdentifierGenerator)) continue;
            statement.addCteStatement(queryCte);
        }
        return this.getCteTableName(rootTableName);
    }

    protected NamedTableReference resolveUnionTableReference(TableReference tableReference, String tableExpression) {
        if (tableReference instanceof UnionTableReference) {
            return new NamedTableReference(tableExpression, tableReference.getIdentificationVariable(), tableReference.isOptional(), this.sessionFactory);
        }
        return (NamedTableReference)tableReference;
    }

    private void collectTableReference(TableReference tableReference, BiConsumer<String, TableReference> consumer) {
        consumer.accept(tableReference.getIdentificationVariable(), tableReference);
    }

    private void collectTableReference(TableReferenceJoin tableReferenceJoin, BiConsumer<String, TableReference> consumer) {
        this.collectTableReference(tableReferenceJoin.getJoinedTableReference(), consumer);
    }

    private TableReference resolveTableReference(ColumnReference columnReference, TableGroup updatingTableGroup, Map<String, TableReference> tableReferenceByAlias) {
        TableReference tableReferenceByQualifier = tableReferenceByAlias.get(columnReference.getQualifier());
        if (tableReferenceByQualifier != null) {
            return tableReferenceByQualifier;
        }
        throw new SemanticException("Assignment referred to column of a joined association: " + columnReference);
    }

    protected String getCteTableName(String tableExpression) {
        return this.getCteTableName(tableExpression, "");
    }

    protected String getCteTableName(String tableExpression, String subPrefix) {
        Dialect dialect = this.sessionFactory.getJdbcServices().getDialect();
        if (Identifier.isQuoted(tableExpression)) {
            tableExpression = tableExpression.substring(1, tableExpression.length() - 1);
        }
        return Identifier.toIdentifier(DML_RESULT_TABLE_NAME_PREFIX + subPrefix + tableExpression).render(dialect);
    }
}

