/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.spi;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.SqlTreeCreationLogger;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.jboss.logging.Logger;

public class SimpleFromClauseAccessImpl
implements FromClauseAccess {
    protected final FromClauseAccess parent;
    protected final Map<NavigablePath, TableGroup> tableGroupMap = new HashMap<NavigablePath, TableGroup>();

    public SimpleFromClauseAccessImpl() {
        this(null);
    }

    public SimpleFromClauseAccessImpl(FromClauseAccess parent) {
        this.parent = parent;
    }

    @Override
    public TableGroup findTableGroupOnParents(NavigablePath navigablePath) {
        TableGroup tableGroup = this.tableGroupMap.get(navigablePath);
        if (tableGroup == null && this.parent != null) {
            return this.parent.findTableGroupOnParents(navigablePath);
        }
        return tableGroup;
    }

    @Override
    public TableGroup findTableGroup(NavigablePath navigablePath) {
        return this.tableGroupMap.get(navigablePath);
    }

    @Override
    public void registerTableGroup(NavigablePath navigablePath, TableGroup tableGroup) {
        Logger logger2 = SqlTreeCreationLogger.LOGGER;
        boolean debugEnabled = logger2.isDebugEnabled();
        if (debugEnabled) {
            logger2.debugf("Registration of TableGroup [%s] with identifierForTableGroup [%s] for NavigablePath [%s] ", (Object)tableGroup, (Object)tableGroup.getNavigablePath().getIdentifierForTableGroup(), (Object)navigablePath.getIdentifierForTableGroup());
        }
        TableGroup previous = this.tableGroupMap.put(navigablePath, tableGroup);
        if (debugEnabled && previous != null) {
            logger2.debugf("Registration of TableGroup [%s] for NavigablePath [%s] overrode previous registration : %s", (Object)tableGroup, (Object)navigablePath, (Object)previous);
        }
    }
}

