/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import org.hibernate.metamodel.model.convert.spi.BasicValueConverter;
import org.hibernate.type.AbstractSingleColumnStandardBasicType;
import org.hibernate.type.AdjustableBasicType;
import org.hibernate.type.BasicPluralType;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.spi.BasicCollectionJavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.hibernate.type.spi.TypeConfiguration;

public class BasicCollectionType<C extends Collection<E>, E>
extends AbstractSingleColumnStandardBasicType<C>
implements AdjustableBasicType<C>,
BasicPluralType<C, E> {
    private final BasicType<E> baseDescriptor;
    private final String name;
    private final ValueBinder<C> jdbcValueBinder;
    private final ValueExtractor<C> jdbcValueExtractor;

    public BasicCollectionType(final BasicType<E> baseDescriptor, JdbcType arrayJdbcType, final BasicCollectionJavaType<C, E> collectionTypeDescriptor) {
        super(arrayJdbcType, collectionTypeDescriptor);
        this.baseDescriptor = baseDescriptor;
        this.name = BasicCollectionType.determineName(collectionTypeDescriptor, baseDescriptor);
        final ValueBinder jdbcValueBinder = super.getJdbcValueBinder();
        final ValueExtractor jdbcValueExtractor = super.getJdbcValueExtractor();
        final BasicValueConverter<E, ?> valueConverter = baseDescriptor.getValueConverter();
        if (valueConverter != null) {
            this.jdbcValueBinder = new ValueBinder<C>(){

                @Override
                public void bind(PreparedStatement st, C value, int index, WrapperOptions options) throws SQLException {
                    jdbcValueBinder.bind(st, this.getValue(value, valueConverter, options), index, options);
                }

                @Override
                public void bind(CallableStatement st, C value, String name, WrapperOptions options) throws SQLException {
                    jdbcValueBinder.bind(st, this.getValue(value, valueConverter, options), name, options);
                }

                private C getValue(C value, BasicValueConverter<E, Object> valueConverter2, WrapperOptions options) {
                    if (value == null) {
                        return null;
                    }
                    JdbcType elementJdbcType = baseDescriptor.getJdbcType();
                    TypeConfiguration typeConfiguration = options.getSessionFactory().getTypeConfiguration();
                    JdbcType underlyingJdbcType = typeConfiguration.getJdbcTypeRegistry().getDescriptor(elementJdbcType.getDefaultSqlTypeCode());
                    Class<?> preferredJavaTypeClass = underlyingJdbcType.getPreferredJavaTypeClass(options);
                    Class<Object> elementJdbcJavaTypeClass = preferredJavaTypeClass == null ? underlyingJdbcType.getJdbcRecommendedJavaTypeMapping(null, null, typeConfiguration).getJavaTypeClass() : preferredJavaTypeClass;
                    Collection converted = (Collection)collectionTypeDescriptor.getSemantics().instantiateRaw(value.size(), null);
                    for (Object element : value) {
                        converted.add(valueConverter2.getRelationalJavaType().unwrap(valueConverter2.toRelationalValue(element), elementJdbcJavaTypeClass, options));
                    }
                    return converted;
                }
            };
            this.jdbcValueExtractor = new ValueExtractor<C>(){

                @Override
                public C extract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                    return this.getValue((Collection)jdbcValueExtractor.extract(rs, paramIndex, options), valueConverter);
                }

                @Override
                public C extract(CallableStatement statement, int paramIndex, WrapperOptions options) throws SQLException {
                    return this.getValue((Collection)jdbcValueExtractor.extract(statement, paramIndex, options), valueConverter);
                }

                @Override
                public C extract(CallableStatement statement, String paramName, WrapperOptions options) throws SQLException {
                    return this.getValue((Collection)jdbcValueExtractor.extract(statement, paramName, options), valueConverter);
                }

                private C getValue(C value, BasicValueConverter<E, Object> valueConverter2) {
                    if (value == null) {
                        return null;
                    }
                    Collection converted = (Collection)collectionTypeDescriptor.getSemantics().instantiateRaw(value.size(), null);
                    for (Object element : value) {
                        converted.add(valueConverter2.toDomainValue(element));
                    }
                    return converted;
                }
            };
        } else {
            this.jdbcValueBinder = jdbcValueBinder;
            this.jdbcValueExtractor = jdbcValueExtractor;
        }
    }

    private static String determineName(BasicCollectionJavaType<?, ?> collectionTypeDescriptor, BasicType<?> baseDescriptor) {
        switch (collectionTypeDescriptor.getSemantics().getCollectionClassification()) {
            case BAG: 
            case ID_BAG: {
                return "Collection<" + baseDescriptor.getName() + ">";
            }
            case LIST: {
                return "List<" + baseDescriptor.getName() + ">";
            }
            case SET: {
                return "Set<" + baseDescriptor.getName() + ">";
            }
            case SORTED_SET: {
                return "SortedSet<" + baseDescriptor.getName() + ">";
            }
            case ORDERED_SET: {
                return "OrderedSet<" + baseDescriptor.getName() + ">";
            }
        }
        return null;
    }

    @Override
    public BasicType<E> getElementType() {
        return this.baseDescriptor;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    protected boolean registerUnderJavaType() {
        return true;
    }

    @Override
    public ValueExtractor<C> getJdbcValueExtractor() {
        return this.jdbcValueExtractor;
    }

    @Override
    public ValueBinder<C> getJdbcValueBinder() {
        return this.jdbcValueBinder;
    }

    @Override
    public <X> BasicType<X> resolveIndicatedType(JdbcTypeIndicators indicators, JavaType<X> domainJtd) {
        return this;
    }
}

