/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.jdbc;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.tool.schema.extract.spi.ColumnTypeInformation;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.BasicJavaType;
import org.hibernate.type.descriptor.java.BasicPluralJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.ObjectJdbcType;
import org.hibernate.type.descriptor.jdbc.internal.JdbcLiteralFormatterArray;
import org.hibernate.type.spi.TypeConfiguration;

public class ArrayJdbcType
implements JdbcType {
    public static final ArrayJdbcType INSTANCE = new ArrayJdbcType(ObjectJdbcType.INSTANCE);
    private static final ClassValue<Method> NAME_BINDER = new ClassValue<Method>(){

        @Override
        protected Method computeValue(Class<?> type) {
            try {
                return type.getMethod("setArray", String.class, java.sql.Array.class);
            }
            catch (Exception exception) {
                return null;
            }
        }
    };
    private final JdbcType elementJdbcType;

    public ArrayJdbcType(JdbcType elementJdbcType) {
        this.elementJdbcType = elementJdbcType;
    }

    public JdbcType resolveType(TypeConfiguration typeConfiguration, Dialect dialect, BasicType<?> elementType, ColumnTypeInformation columnTypeInformation) {
        return this.resolveType(typeConfiguration, dialect, elementType.getJdbcType(), columnTypeInformation);
    }

    public JdbcType resolveType(TypeConfiguration typeConfiguration, Dialect dialect, JdbcType elementType, ColumnTypeInformation columnTypeInformation) {
        return new ArrayJdbcType(elementType);
    }

    @Override
    public int getJdbcTypeCode() {
        return 2003;
    }

    public JdbcType getElementJdbcType() {
        return this.elementJdbcType;
    }

    @Override
    public <T> BasicJavaType<T> getJdbcRecommendedJavaTypeMapping(Integer precision, Integer scale, TypeConfiguration typeConfiguration) {
        BasicJavaType elementJavaType = this.elementJdbcType.getJdbcRecommendedJavaTypeMapping(precision, scale, typeConfiguration);
        return (BasicJavaType)typeConfiguration.getJavaTypeRegistry().resolveDescriptor(Array.newInstance(elementJavaType.getJavaTypeClass(), 0).getClass());
    }

    @Override
    public <T> JdbcLiteralFormatter<T> getJdbcLiteralFormatter(JavaType<T> javaTypeDescriptor) {
        BasicPluralJavaType basicPluralJavaType = (BasicPluralJavaType)((Object)javaTypeDescriptor);
        JdbcLiteralFormatter elementFormatter = this.elementJdbcType.getJdbcLiteralFormatter(basicPluralJavaType.getElementJavaType());
        return new JdbcLiteralFormatterArray<T>(javaTypeDescriptor, elementFormatter);
    }

    @Override
    public Class<?> getPreferredJavaTypeClass(WrapperOptions options) {
        return java.sql.Array.class;
    }

    @Override
    public <X> ValueBinder<X> getBinder(final JavaType<X> javaTypeDescriptor) {
        final BasicPluralJavaType containerJavaType = (BasicPluralJavaType)((Object)javaTypeDescriptor);
        return new BasicBinder<X>(javaTypeDescriptor, this){

            @Override
            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                java.sql.Array arr = this.getArray(value, containerJavaType, options);
                st.setArray(index, arr);
            }

            @Override
            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                java.sql.Array arr = this.getArray(value, containerJavaType, options);
                Method nameBinder = NAME_BINDER.get(st.getClass());
                if (nameBinder == null) {
                    try {
                        st.setObject(name, (Object)arr, 2003);
                        return;
                    }
                    catch (SQLException ex) {
                        throw new HibernateException("JDBC driver does not support named parameters for setArray. Use positional.", ex);
                    }
                }
                try {
                    nameBinder.invoke((Object)st, name, arr);
                }
                catch (Throwable t) {
                    throw new HibernateException(t);
                }
            }

            private java.sql.Array getArray(X value, BasicPluralJavaType<X> containerJavaType2, WrapperOptions options) throws SQLException {
                TypeConfiguration typeConfiguration = options.getSessionFactory().getTypeConfiguration();
                JdbcType underlyingJdbcType = typeConfiguration.getJdbcTypeRegistry().getDescriptor(ArrayJdbcType.this.elementJdbcType.getDefaultSqlTypeCode());
                Class<?> preferredJavaTypeClass = underlyingJdbcType.getPreferredJavaTypeClass(options);
                Class<Object> elementJdbcJavaTypeClass = preferredJavaTypeClass == null ? underlyingJdbcType.getJdbcRecommendedJavaTypeMapping(null, null, typeConfiguration).getJavaTypeClass() : preferredJavaTypeClass;
                Class<?> arrayClass = Array.newInstance(elementJdbcJavaTypeClass, 0).getClass();
                Object[] objects = (Object[])javaTypeDescriptor.unwrap(value, arrayClass, options);
                SharedSessionContractImplementor session = options.getSession();
                Size size = session.getJdbcServices().getDialect().getSizeStrategy().resolveSize(ArrayJdbcType.this.elementJdbcType, containerJavaType2.getElementJavaType(), null, null, null);
                String typeName = session.getTypeConfiguration().getDdlTypeRegistry().getDescriptor(ArrayJdbcType.this.elementJdbcType.getDefaultSqlTypeCode()).getTypeName(size);
                int cutIndex = typeName.indexOf(40);
                if (cutIndex > 0) {
                    typeName = typeName.substring(0, cutIndex);
                }
                return session.getJdbcCoordinator().getLogicalConnection().getPhysicalConnection().createArrayOf(typeName, objects);
            }
        };
    }

    @Override
    public <X> ValueExtractor<X> getExtractor(final JavaType<X> javaTypeDescriptor) {
        return new BasicExtractor<X>(javaTypeDescriptor, this){

            @Override
            protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                return javaTypeDescriptor.wrap(rs.getArray(paramIndex), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                return javaTypeDescriptor.wrap(statement.getArray(index), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                return javaTypeDescriptor.wrap(statement.getArray(name), options);
            }
        };
    }

    @Override
    public String getFriendlyName() {
        return "ARRAY";
    }

    public String toString() {
        return "ArrayTypeDescriptor(" + this.getFriendlyName() + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArrayJdbcType that = (ArrayJdbcType)o;
        return this.elementJdbcType.equals(that.elementJdbcType);
    }

    public int hashCode() {
        return this.elementJdbcType.hashCode();
    }
}

