
package org.hibernate.boot.jaxb.hbm.spi;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for FetchStyleWithSubselectEnum.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>
 * &lt;simpleType name="FetchStyleWithSubselectEnum"&gt;
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}token"&gt;
 *     &lt;enumeration value="join"/&gt;
 *     &lt;enumeration value="select"/&gt;
 *     &lt;enumeration value="subselect"/&gt;
 *   &lt;/restriction&gt;
 * &lt;/simpleType&gt;
 * </pre>
 * 
 */
@XmlType(name = "FetchStyleWithSubselectEnum", namespace = "http://www.hibernate.org/xsd/orm/hbm")
@XmlEnum
public enum JaxbHbmFetchStyleWithSubselectEnum {

    @XmlEnumValue("join")
    JOIN("join"),
    @XmlEnumValue("select")
    SELECT("select"),
    @XmlEnumValue("subselect")
    SUBSELECT("subselect");
    private final String value;

    JaxbHbmFetchStyleWithSubselectEnum(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static JaxbHbmFetchStyleWithSubselectEnum fromValue(String v) {
        for (JaxbHbmFetchStyleWithSubselectEnum c: JaxbHbmFetchStyleWithSubselectEnum.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
