
package org.hibernate.boot.jaxb.mapping;

import java.io.Serializable;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.hibernate.cache.spi.access.AccessType;


/**
 * 
 *                 Corresponds to the org.hibernate.annotations.Cache annotation.
 * 
 *                 Used to specify Hibernate-specific extra control over the caching
 *                 of entity and collection state.
 *             
 * 
 * <p>Java class for caching complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="caching"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;attribute name="include" type="{http://www.hibernate.org/xsd/orm/mapping}cache-inclusion-type" default="all" /&gt;
 *       &lt;attribute name="region" type="{http://www.w3.org/2001/XMLSchema}string" /&gt;
 *       &lt;attribute name="access" use="required" type="{http://www.hibernate.org/xsd/orm/mapping}cache-access-type" /&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "caching", namespace = "http://www.hibernate.org/xsd/orm/mapping")
public class JaxbCaching
    implements Serializable
{

    @XmlAttribute(name = "include")
    protected JaxbCacheInclusionType include;
    @XmlAttribute(name = "region")
    protected String region;
    @XmlAttribute(name = "access", required = true)
    @XmlJavaTypeAdapter(Adapter14 .class)
    protected AccessType access;

    /**
     * Gets the value of the include property.
     * 
     * @return
     *     possible object is
     *     {@link JaxbCacheInclusionType }
     *     
     */
    public JaxbCacheInclusionType getInclude() {
        if (include == null) {
            return JaxbCacheInclusionType.ALL;
        } else {
            return include;
        }
    }

    /**
     * Sets the value of the include property.
     * 
     * @param value
     *     allowed object is
     *     {@link JaxbCacheInclusionType }
     *     
     */
    public void setInclude(JaxbCacheInclusionType value) {
        this.include = value;
    }

    /**
     * Gets the value of the region property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getRegion() {
        return region;
    }

    /**
     * Sets the value of the region property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setRegion(String value) {
        this.region = value;
    }

    /**
     * Gets the value of the access property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public AccessType getAccess() {
        return access;
    }

    /**
     * Sets the value of the access property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setAccess(AccessType value) {
        this.access = value;
    }

}
