
/*
 * Hibernate, Relational Persistence for Idiomatic Java
 *
 * License: GNU Lesser General Public License (LGPL), version 2.1 or later.
 * See the lgpl.txt file in the root directory or <http://www.gnu.org/licenses/lgpl-2.1.html>.
 */
package org.hibernate.grammars.ordering;

/**
 * Grammar for parsing order-by fragments.
 *
 * @implNote While we could re-use the HQL lexer/parser for order fragment parsing, both the HQL lexer and parser
 * are way "heavier" than needed here.  So we use a simplified lexer and parser that defione just what is needed
 * to parse the order fragment
 */

import org.antlr.v4.runtime.atn.*;
import org.antlr.v4.runtime.dfa.DFA;
import org.antlr.v4.runtime.*;
import org.antlr.v4.runtime.misc.*;
import org.antlr.v4.runtime.tree.*;
import java.util.List;
import java.util.Iterator;
import java.util.ArrayList;

@SuppressWarnings({"all", "warnings", "unchecked", "unused", "cast"})
public class OrderingParser extends Parser {
	static { RuntimeMetaData.checkVersion("4.10", RuntimeMetaData.VERSION); }

	protected static final DFA[] _decisionToDFA;
	protected static final PredictionContextCache _sharedContextCache =
		new PredictionContextCache();
	public static final int
		WS=1, INTEGER_LITERAL=2, LONG_LITERAL=3, BIG_INTEGER_LITERAL=4, HEX_LITERAL=5, 
		OCTAL_LITERAL=6, FLOAT_LITERAL=7, DOUBLE_LITERAL=8, BIG_DECIMAL_LITERAL=9, 
		CHARACTER_LITERAL=10, STRING_LITERAL=11, COLLATE=12, NULLS=13, FIRST=14, 
		LAST=15, ASC=16, DESC=17, IDENTIFIER=18, QUOTED_IDENTIFIER=19, OPEN_PAREN=20, 
		CLOSE_PAREN=21, COMMA=22, DOT=23, PLUS=24, MINUS=25, MULTIPLY=26, DIVIDE=27, 
		MODULO=28;
	public static final int
		RULE_orderByFragment = 0, RULE_sortSpecification = 1, RULE_expression = 2, 
		RULE_function = 3, RULE_simpleFunction = 4, RULE_packagedFunction = 5, 
		RULE_functionArguments = 6, RULE_functionArgument = 7, RULE_literal = 8, 
		RULE_collationSpecification = 9, RULE_direction = 10, RULE_nullsPrecedence = 11, 
		RULE_identifier = 12, RULE_dotIdentifier = 13;
	private static String[] makeRuleNames() {
		return new String[] {
			"orderByFragment", "sortSpecification", "expression", "function", "simpleFunction", 
			"packagedFunction", "functionArguments", "functionArgument", "literal", 
			"collationSpecification", "direction", "nullsPrecedence", "identifier", 
			"dotIdentifier"
		};
	}
	public static final String[] ruleNames = makeRuleNames();

	private static String[] makeLiteralNames() {
		return new String[] {
			null, null, null, null, null, null, null, null, null, null, null, null, 
			null, null, null, null, null, null, null, null, "'('", "')'", "','", 
			"'.'", "'+'", "'-'", "'*'", "'/'", "'%'"
		};
	}
	private static final String[] _LITERAL_NAMES = makeLiteralNames();
	private static String[] makeSymbolicNames() {
		return new String[] {
			null, "WS", "INTEGER_LITERAL", "LONG_LITERAL", "BIG_INTEGER_LITERAL", 
			"HEX_LITERAL", "OCTAL_LITERAL", "FLOAT_LITERAL", "DOUBLE_LITERAL", "BIG_DECIMAL_LITERAL", 
			"CHARACTER_LITERAL", "STRING_LITERAL", "COLLATE", "NULLS", "FIRST", "LAST", 
			"ASC", "DESC", "IDENTIFIER", "QUOTED_IDENTIFIER", "OPEN_PAREN", "CLOSE_PAREN", 
			"COMMA", "DOT", "PLUS", "MINUS", "MULTIPLY", "DIVIDE", "MODULO"
		};
	}
	private static final String[] _SYMBOLIC_NAMES = makeSymbolicNames();
	public static final Vocabulary VOCABULARY = new VocabularyImpl(_LITERAL_NAMES, _SYMBOLIC_NAMES);

	/**
	 * @deprecated Use {@link #VOCABULARY} instead.
	 */
	@Deprecated
	public static final String[] tokenNames;
	static {
		tokenNames = new String[_SYMBOLIC_NAMES.length];
		for (int i = 0; i < tokenNames.length; i++) {
			tokenNames[i] = VOCABULARY.getLiteralName(i);
			if (tokenNames[i] == null) {
				tokenNames[i] = VOCABULARY.getSymbolicName(i);
			}

			if (tokenNames[i] == null) {
				tokenNames[i] = "<INVALID>";
			}
		}
	}

	@Override
	@Deprecated
	public String[] getTokenNames() {
		return tokenNames;
	}

	@Override

	public Vocabulary getVocabulary() {
		return VOCABULARY;
	}

	@Override
	public String getGrammarFileName() { return "OrderingParser.g4"; }

	@Override
	public String[] getRuleNames() { return ruleNames; }

	@Override
	public String getSerializedATN() { return _serializedATN; }

	@Override
	public ATN getATN() { return _ATN; }

	public OrderingParser(TokenStream input) {
		super(input);
		_interp = new ParserATNSimulator(this,_ATN,_decisionToDFA,_sharedContextCache);
	}

	public static class OrderByFragmentContext extends ParserRuleContext {
		public List<SortSpecificationContext> sortSpecification() {
			return getRuleContexts(SortSpecificationContext.class);
		}
		public SortSpecificationContext sortSpecification(int i) {
			return getRuleContext(SortSpecificationContext.class,i);
		}
		public List<TerminalNode> COMMA() { return getTokens(OrderingParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(OrderingParser.COMMA, i);
		}
		public OrderByFragmentContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_orderByFragment; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof OrderingParserListener ) ((OrderingParserListener)listener).enterOrderByFragment(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof OrderingParserListener ) ((OrderingParserListener)listener).exitOrderByFragment(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof OrderingParserVisitor ) return ((OrderingParserVisitor<? extends T>)visitor).visitOrderByFragment(this);
			else return visitor.visitChildren(this);
		}
	}

	public final OrderByFragmentContext orderByFragment() throws RecognitionException {
		OrderByFragmentContext _localctx = new OrderByFragmentContext(_ctx, getState());
		enterRule(_localctx, 0, RULE_orderByFragment);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(28);
			sortSpecification();
			setState(33);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==COMMA) {
				{
				{
				setState(29);
				match(COMMA);
				setState(30);
				sortSpecification();
				}
				}
				setState(35);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class SortSpecificationContext extends ParserRuleContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public CollationSpecificationContext collationSpecification() {
			return getRuleContext(CollationSpecificationContext.class,0);
		}
		public DirectionContext direction() {
			return getRuleContext(DirectionContext.class,0);
		}
		public NullsPrecedenceContext nullsPrecedence() {
			return getRuleContext(NullsPrecedenceContext.class,0);
		}
		public SortSpecificationContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_sortSpecification; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof OrderingParserListener ) ((OrderingParserListener)listener).enterSortSpecification(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof OrderingParserListener ) ((OrderingParserListener)listener).exitSortSpecification(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof OrderingParserVisitor ) return ((OrderingParserVisitor<? extends T>)visitor).visitSortSpecification(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SortSpecificationContext sortSpecification() throws RecognitionException {
		SortSpecificationContext _localctx = new SortSpecificationContext(_ctx, getState());
		enterRule(_localctx, 2, RULE_sortSpecification);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(36);
			expression();
			setState(38);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==COLLATE) {
				{
				setState(37);
				collationSpecification();
				}
			}

			setState(41);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==ASC || _la==DESC) {
				{
				setState(40);
				direction();
				}
			}

			setState(44);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==NULLS) {
				{
				setState(43);
				nullsPrecedence();
				}
			}

			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class ExpressionContext extends ParserRuleContext {
		public ExpressionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_expression; }
	 
		public ExpressionContext() { }
		public void copyFrom(ExpressionContext ctx) {
			super.copyFrom(ctx);
		}
	}
	public static class FunctionExpressionContext extends ExpressionContext {
		public FunctionContext function() {
			return getRuleContext(FunctionContext.class,0);
		}
		public FunctionExpressionContext(ExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof OrderingParserListener ) ((OrderingParserListener)listener).enterFunctionExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof OrderingParserListener ) ((OrderingParserListener)listener).exitFunctionExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof OrderingParserVisitor ) return ((OrderingParserVisitor<? extends T>)visitor).visitFunctionExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class DotIdentifierExpressionContext extends ExpressionContext {
		public DotIdentifierContext dotIdentifier() {
			return getRuleContext(DotIdentifierContext.class,0);
		}
		public DotIdentifierExpressionContext(ExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof OrderingParserListener ) ((OrderingParserListener)listener).enterDotIdentifierExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof OrderingParserListener ) ((OrderingParserListener)listener).exitDotIdentifierExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof OrderingParserVisitor ) return ((OrderingParserVisitor<? extends T>)visitor).visitDotIdentifierExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class IdentifierExpressionContext extends ExpressionContext {
		public IdentifierContext identifier() {
			return getRuleContext(IdentifierContext.class,0);
		}
		public IdentifierExpressionContext(ExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof OrderingParserListener ) ((OrderingParserListener)listener).enterIdentifierExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof OrderingParserListener ) ((OrderingParserListener)listener).exitIdentifierExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof OrderingParserVisitor ) return ((OrderingParserVisitor<? extends T>)visitor).visitIdentifierExpression(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ExpressionContext expression() throws RecognitionException {
		ExpressionContext _localctx = new ExpressionContext(_ctx, getState());
		enterRule(_localctx, 4, RULE_expression);
		try {
			setState(49);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,4,_ctx) ) {
			case 1:
				_localctx = new FunctionExpressionContext(_localctx);
				enterOuterAlt(_localctx, 1);
				{
				setState(46);
				function();
				}
				break;
			case 2:
				_localctx = new IdentifierExpressionContext(_localctx);
				enterOuterAlt(_localctx, 2);
				{
				setState(47);
				identifier();
				}
				break;
			case 3:
				_localctx = new DotIdentifierExpressionContext(_localctx);
				enterOuterAlt(_localctx, 3);
				{
				setState(48);
				dotIdentifier();
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class FunctionContext extends ParserRuleContext {
		public SimpleFunctionContext simpleFunction() {
			return getRuleContext(SimpleFunctionContext.class,0);
		}
		public PackagedFunctionContext packagedFunction() {
			return getRuleContext(PackagedFunctionContext.class,0);
		}
		public FunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_function; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof OrderingParserListener ) ((OrderingParserListener)listener).enterFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof OrderingParserListener ) ((OrderingParserListener)listener).exitFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof OrderingParserVisitor ) return ((OrderingParserVisitor<? extends T>)visitor).visitFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final FunctionContext function() throws RecognitionException {
		FunctionContext _localctx = new FunctionContext(_ctx, getState());
		enterRule(_localctx, 6, RULE_function);
		try {
			setState(53);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,5,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(51);
				simpleFunction();
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(52);
				packagedFunction();
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class SimpleFunctionContext extends ParserRuleContext {
		public IdentifierContext identifier() {
			return getRuleContext(IdentifierContext.class,0);
		}
		public FunctionArgumentsContext functionArguments() {
			return getRuleContext(FunctionArgumentsContext.class,0);
		}
		public SimpleFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_simpleFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof OrderingParserListener ) ((OrderingParserListener)listener).enterSimpleFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof OrderingParserListener ) ((OrderingParserListener)listener).exitSimpleFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof OrderingParserVisitor ) return ((OrderingParserVisitor<? extends T>)visitor).visitSimpleFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SimpleFunctionContext simpleFunction() throws RecognitionException {
		SimpleFunctionContext _localctx = new SimpleFunctionContext(_ctx, getState());
		enterRule(_localctx, 8, RULE_simpleFunction);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(55);
			identifier();
			setState(56);
			functionArguments();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class PackagedFunctionContext extends ParserRuleContext {
		public DotIdentifierContext dotIdentifier() {
			return getRuleContext(DotIdentifierContext.class,0);
		}
		public FunctionArgumentsContext functionArguments() {
			return getRuleContext(FunctionArgumentsContext.class,0);
		}
		public PackagedFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_packagedFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof OrderingParserListener ) ((OrderingParserListener)listener).enterPackagedFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof OrderingParserListener ) ((OrderingParserListener)listener).exitPackagedFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof OrderingParserVisitor ) return ((OrderingParserVisitor<? extends T>)visitor).visitPackagedFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final PackagedFunctionContext packagedFunction() throws RecognitionException {
		PackagedFunctionContext _localctx = new PackagedFunctionContext(_ctx, getState());
		enterRule(_localctx, 10, RULE_packagedFunction);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(58);
			dotIdentifier();
			setState(59);
			functionArguments();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class FunctionArgumentsContext extends ParserRuleContext {
		public TerminalNode OPEN_PAREN() { return getToken(OrderingParser.OPEN_PAREN, 0); }
		public TerminalNode CLOSE_PAREN() { return getToken(OrderingParser.CLOSE_PAREN, 0); }
		public List<FunctionArgumentContext> functionArgument() {
			return getRuleContexts(FunctionArgumentContext.class);
		}
		public FunctionArgumentContext functionArgument(int i) {
			return getRuleContext(FunctionArgumentContext.class,i);
		}
		public List<TerminalNode> COMMA() { return getTokens(OrderingParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(OrderingParser.COMMA, i);
		}
		public FunctionArgumentsContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_functionArguments; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof OrderingParserListener ) ((OrderingParserListener)listener).enterFunctionArguments(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof OrderingParserListener ) ((OrderingParserListener)listener).exitFunctionArguments(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof OrderingParserVisitor ) return ((OrderingParserVisitor<? extends T>)visitor).visitFunctionArguments(this);
			else return visitor.visitChildren(this);
		}
	}

	public final FunctionArgumentsContext functionArguments() throws RecognitionException {
		FunctionArgumentsContext _localctx = new FunctionArgumentsContext(_ctx, getState());
		enterRule(_localctx, 12, RULE_functionArguments);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(61);
			match(OPEN_PAREN);
			setState(70);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if ((((_la) & ~0x3f) == 0 && ((1L << _la) & ((1L << INTEGER_LITERAL) | (1L << LONG_LITERAL) | (1L << BIG_INTEGER_LITERAL) | (1L << HEX_LITERAL) | (1L << FLOAT_LITERAL) | (1L << DOUBLE_LITERAL) | (1L << BIG_DECIMAL_LITERAL) | (1L << STRING_LITERAL) | (1L << COLLATE) | (1L << FIRST) | (1L << LAST) | (1L << ASC) | (1L << DESC) | (1L << IDENTIFIER) | (1L << QUOTED_IDENTIFIER))) != 0)) {
				{
				setState(62);
				functionArgument();
				setState(67);
				_errHandler.sync(this);
				_la = _input.LA(1);
				while (_la==COMMA) {
					{
					{
					setState(63);
					match(COMMA);
					setState(64);
					functionArgument();
					}
					}
					setState(69);
					_errHandler.sync(this);
					_la = _input.LA(1);
				}
				}
			}

			setState(72);
			match(CLOSE_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class FunctionArgumentContext extends ParserRuleContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public LiteralContext literal() {
			return getRuleContext(LiteralContext.class,0);
		}
		public FunctionArgumentContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_functionArgument; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof OrderingParserListener ) ((OrderingParserListener)listener).enterFunctionArgument(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof OrderingParserListener ) ((OrderingParserListener)listener).exitFunctionArgument(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof OrderingParserVisitor ) return ((OrderingParserVisitor<? extends T>)visitor).visitFunctionArgument(this);
			else return visitor.visitChildren(this);
		}
	}

	public final FunctionArgumentContext functionArgument() throws RecognitionException {
		FunctionArgumentContext _localctx = new FunctionArgumentContext(_ctx, getState());
		enterRule(_localctx, 14, RULE_functionArgument);
		try {
			setState(76);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case COLLATE:
			case FIRST:
			case LAST:
			case ASC:
			case DESC:
			case IDENTIFIER:
			case QUOTED_IDENTIFIER:
				enterOuterAlt(_localctx, 1);
				{
				setState(74);
				expression();
				}
				break;
			case INTEGER_LITERAL:
			case LONG_LITERAL:
			case BIG_INTEGER_LITERAL:
			case HEX_LITERAL:
			case FLOAT_LITERAL:
			case DOUBLE_LITERAL:
			case BIG_DECIMAL_LITERAL:
			case STRING_LITERAL:
				enterOuterAlt(_localctx, 2);
				{
				setState(75);
				literal();
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class LiteralContext extends ParserRuleContext {
		public TerminalNode STRING_LITERAL() { return getToken(OrderingParser.STRING_LITERAL, 0); }
		public TerminalNode INTEGER_LITERAL() { return getToken(OrderingParser.INTEGER_LITERAL, 0); }
		public TerminalNode LONG_LITERAL() { return getToken(OrderingParser.LONG_LITERAL, 0); }
		public TerminalNode BIG_INTEGER_LITERAL() { return getToken(OrderingParser.BIG_INTEGER_LITERAL, 0); }
		public TerminalNode FLOAT_LITERAL() { return getToken(OrderingParser.FLOAT_LITERAL, 0); }
		public TerminalNode DOUBLE_LITERAL() { return getToken(OrderingParser.DOUBLE_LITERAL, 0); }
		public TerminalNode BIG_DECIMAL_LITERAL() { return getToken(OrderingParser.BIG_DECIMAL_LITERAL, 0); }
		public TerminalNode HEX_LITERAL() { return getToken(OrderingParser.HEX_LITERAL, 0); }
		public LiteralContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_literal; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof OrderingParserListener ) ((OrderingParserListener)listener).enterLiteral(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof OrderingParserListener ) ((OrderingParserListener)listener).exitLiteral(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof OrderingParserVisitor ) return ((OrderingParserVisitor<? extends T>)visitor).visitLiteral(this);
			else return visitor.visitChildren(this);
		}
	}

	public final LiteralContext literal() throws RecognitionException {
		LiteralContext _localctx = new LiteralContext(_ctx, getState());
		enterRule(_localctx, 16, RULE_literal);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(78);
			_la = _input.LA(1);
			if ( !((((_la) & ~0x3f) == 0 && ((1L << _la) & ((1L << INTEGER_LITERAL) | (1L << LONG_LITERAL) | (1L << BIG_INTEGER_LITERAL) | (1L << HEX_LITERAL) | (1L << FLOAT_LITERAL) | (1L << DOUBLE_LITERAL) | (1L << BIG_DECIMAL_LITERAL) | (1L << STRING_LITERAL))) != 0)) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class CollationSpecificationContext extends ParserRuleContext {
		public TerminalNode COLLATE() { return getToken(OrderingParser.COLLATE, 0); }
		public IdentifierContext identifier() {
			return getRuleContext(IdentifierContext.class,0);
		}
		public CollationSpecificationContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_collationSpecification; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof OrderingParserListener ) ((OrderingParserListener)listener).enterCollationSpecification(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof OrderingParserListener ) ((OrderingParserListener)listener).exitCollationSpecification(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof OrderingParserVisitor ) return ((OrderingParserVisitor<? extends T>)visitor).visitCollationSpecification(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CollationSpecificationContext collationSpecification() throws RecognitionException {
		CollationSpecificationContext _localctx = new CollationSpecificationContext(_ctx, getState());
		enterRule(_localctx, 18, RULE_collationSpecification);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(80);
			match(COLLATE);
			setState(81);
			identifier();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class DirectionContext extends ParserRuleContext {
		public TerminalNode ASC() { return getToken(OrderingParser.ASC, 0); }
		public TerminalNode DESC() { return getToken(OrderingParser.DESC, 0); }
		public DirectionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_direction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof OrderingParserListener ) ((OrderingParserListener)listener).enterDirection(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof OrderingParserListener ) ((OrderingParserListener)listener).exitDirection(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof OrderingParserVisitor ) return ((OrderingParserVisitor<? extends T>)visitor).visitDirection(this);
			else return visitor.visitChildren(this);
		}
	}

	public final DirectionContext direction() throws RecognitionException {
		DirectionContext _localctx = new DirectionContext(_ctx, getState());
		enterRule(_localctx, 20, RULE_direction);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(83);
			_la = _input.LA(1);
			if ( !(_la==ASC || _la==DESC) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class NullsPrecedenceContext extends ParserRuleContext {
		public TerminalNode NULLS() { return getToken(OrderingParser.NULLS, 0); }
		public TerminalNode FIRST() { return getToken(OrderingParser.FIRST, 0); }
		public TerminalNode LAST() { return getToken(OrderingParser.LAST, 0); }
		public NullsPrecedenceContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_nullsPrecedence; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof OrderingParserListener ) ((OrderingParserListener)listener).enterNullsPrecedence(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof OrderingParserListener ) ((OrderingParserListener)listener).exitNullsPrecedence(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof OrderingParserVisitor ) return ((OrderingParserVisitor<? extends T>)visitor).visitNullsPrecedence(this);
			else return visitor.visitChildren(this);
		}
	}

	public final NullsPrecedenceContext nullsPrecedence() throws RecognitionException {
		NullsPrecedenceContext _localctx = new NullsPrecedenceContext(_ctx, getState());
		enterRule(_localctx, 22, RULE_nullsPrecedence);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(85);
			match(NULLS);
			setState(86);
			_la = _input.LA(1);
			if ( !(_la==FIRST || _la==LAST) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class IdentifierContext extends ParserRuleContext {
		public TerminalNode IDENTIFIER() { return getToken(OrderingParser.IDENTIFIER, 0); }
		public TerminalNode QUOTED_IDENTIFIER() { return getToken(OrderingParser.QUOTED_IDENTIFIER, 0); }
		public TerminalNode FIRST() { return getToken(OrderingParser.FIRST, 0); }
		public TerminalNode LAST() { return getToken(OrderingParser.LAST, 0); }
		public TerminalNode ASC() { return getToken(OrderingParser.ASC, 0); }
		public TerminalNode DESC() { return getToken(OrderingParser.DESC, 0); }
		public TerminalNode COLLATE() { return getToken(OrderingParser.COLLATE, 0); }
		public IdentifierContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_identifier; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof OrderingParserListener ) ((OrderingParserListener)listener).enterIdentifier(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof OrderingParserListener ) ((OrderingParserListener)listener).exitIdentifier(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof OrderingParserVisitor ) return ((OrderingParserVisitor<? extends T>)visitor).visitIdentifier(this);
			else return visitor.visitChildren(this);
		}
	}

	public final IdentifierContext identifier() throws RecognitionException {
		IdentifierContext _localctx = new IdentifierContext(_ctx, getState());
		enterRule(_localctx, 24, RULE_identifier);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(88);
			_la = _input.LA(1);
			if ( !((((_la) & ~0x3f) == 0 && ((1L << _la) & ((1L << COLLATE) | (1L << FIRST) | (1L << LAST) | (1L << ASC) | (1L << DESC) | (1L << IDENTIFIER) | (1L << QUOTED_IDENTIFIER))) != 0)) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class DotIdentifierContext extends ParserRuleContext {
		public List<IdentifierContext> identifier() {
			return getRuleContexts(IdentifierContext.class);
		}
		public IdentifierContext identifier(int i) {
			return getRuleContext(IdentifierContext.class,i);
		}
		public List<TerminalNode> DOT() { return getTokens(OrderingParser.DOT); }
		public TerminalNode DOT(int i) {
			return getToken(OrderingParser.DOT, i);
		}
		public DotIdentifierContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_dotIdentifier; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof OrderingParserListener ) ((OrderingParserListener)listener).enterDotIdentifier(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof OrderingParserListener ) ((OrderingParserListener)listener).exitDotIdentifier(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof OrderingParserVisitor ) return ((OrderingParserVisitor<? extends T>)visitor).visitDotIdentifier(this);
			else return visitor.visitChildren(this);
		}
	}

	public final DotIdentifierContext dotIdentifier() throws RecognitionException {
		DotIdentifierContext _localctx = new DotIdentifierContext(_ctx, getState());
		enterRule(_localctx, 26, RULE_dotIdentifier);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(90);
			identifier();
			setState(93); 
			_errHandler.sync(this);
			_la = _input.LA(1);
			do {
				{
				{
				setState(91);
				match(DOT);
				setState(92);
				identifier();
				}
				}
				setState(95); 
				_errHandler.sync(this);
				_la = _input.LA(1);
			} while ( _la==DOT );
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static final String _serializedATN =
		"\u0004\u0001\u001cb\u0002\u0000\u0007\u0000\u0002\u0001\u0007\u0001\u0002"+
		"\u0002\u0007\u0002\u0002\u0003\u0007\u0003\u0002\u0004\u0007\u0004\u0002"+
		"\u0005\u0007\u0005\u0002\u0006\u0007\u0006\u0002\u0007\u0007\u0007\u0002"+
		"\b\u0007\b\u0002\t\u0007\t\u0002\n\u0007\n\u0002\u000b\u0007\u000b\u0002"+
		"\f\u0007\f\u0002\r\u0007\r\u0001\u0000\u0001\u0000\u0001\u0000\u0005\u0000"+
		" \b\u0000\n\u0000\f\u0000#\t\u0000\u0001\u0001\u0001\u0001\u0003\u0001"+
		"\'\b\u0001\u0001\u0001\u0003\u0001*\b\u0001\u0001\u0001\u0003\u0001-\b"+
		"\u0001\u0001\u0002\u0001\u0002\u0001\u0002\u0003\u00022\b\u0002\u0001"+
		"\u0003\u0001\u0003\u0003\u00036\b\u0003\u0001\u0004\u0001\u0004\u0001"+
		"\u0004\u0001\u0005\u0001\u0005\u0001\u0005\u0001\u0006\u0001\u0006\u0001"+
		"\u0006\u0001\u0006\u0005\u0006B\b\u0006\n\u0006\f\u0006E\t\u0006\u0003"+
		"\u0006G\b\u0006\u0001\u0006\u0001\u0006\u0001\u0007\u0001\u0007\u0003"+
		"\u0007M\b\u0007\u0001\b\u0001\b\u0001\t\u0001\t\u0001\t\u0001\n\u0001"+
		"\n\u0001\u000b\u0001\u000b\u0001\u000b\u0001\f\u0001\f\u0001\r\u0001\r"+
		"\u0001\r\u0004\r^\b\r\u000b\r\f\r_\u0001\r\u0000\u0000\u000e\u0000\u0002"+
		"\u0004\u0006\b\n\f\u000e\u0010\u0012\u0014\u0016\u0018\u001a\u0000\u0004"+
		"\u0003\u0000\u0002\u0005\u0007\t\u000b\u000b\u0001\u0000\u0010\u0011\u0001"+
		"\u0000\u000e\u000f\u0002\u0000\f\f\u000e\u0013^\u0000\u001c\u0001\u0000"+
		"\u0000\u0000\u0002$\u0001\u0000\u0000\u0000\u00041\u0001\u0000\u0000\u0000"+
		"\u00065\u0001\u0000\u0000\u0000\b7\u0001\u0000\u0000\u0000\n:\u0001\u0000"+
		"\u0000\u0000\f=\u0001\u0000\u0000\u0000\u000eL\u0001\u0000\u0000\u0000"+
		"\u0010N\u0001\u0000\u0000\u0000\u0012P\u0001\u0000\u0000\u0000\u0014S"+
		"\u0001\u0000\u0000\u0000\u0016U\u0001\u0000\u0000\u0000\u0018X\u0001\u0000"+
		"\u0000\u0000\u001aZ\u0001\u0000\u0000\u0000\u001c!\u0003\u0002\u0001\u0000"+
		"\u001d\u001e\u0005\u0016\u0000\u0000\u001e \u0003\u0002\u0001\u0000\u001f"+
		"\u001d\u0001\u0000\u0000\u0000 #\u0001\u0000\u0000\u0000!\u001f\u0001"+
		"\u0000\u0000\u0000!\"\u0001\u0000\u0000\u0000\"\u0001\u0001\u0000\u0000"+
		"\u0000#!\u0001\u0000\u0000\u0000$&\u0003\u0004\u0002\u0000%\'\u0003\u0012"+
		"\t\u0000&%\u0001\u0000\u0000\u0000&\'\u0001\u0000\u0000\u0000\')\u0001"+
		"\u0000\u0000\u0000(*\u0003\u0014\n\u0000)(\u0001\u0000\u0000\u0000)*\u0001"+
		"\u0000\u0000\u0000*,\u0001\u0000\u0000\u0000+-\u0003\u0016\u000b\u0000"+
		",+\u0001\u0000\u0000\u0000,-\u0001\u0000\u0000\u0000-\u0003\u0001\u0000"+
		"\u0000\u0000.2\u0003\u0006\u0003\u0000/2\u0003\u0018\f\u000002\u0003\u001a"+
		"\r\u00001.\u0001\u0000\u0000\u00001/\u0001\u0000\u0000\u000010\u0001\u0000"+
		"\u0000\u00002\u0005\u0001\u0000\u0000\u000036\u0003\b\u0004\u000046\u0003"+
		"\n\u0005\u000053\u0001\u0000\u0000\u000054\u0001\u0000\u0000\u00006\u0007"+
		"\u0001\u0000\u0000\u000078\u0003\u0018\f\u000089\u0003\f\u0006\u00009"+
		"\t\u0001\u0000\u0000\u0000:;\u0003\u001a\r\u0000;<\u0003\f\u0006\u0000"+
		"<\u000b\u0001\u0000\u0000\u0000=F\u0005\u0014\u0000\u0000>C\u0003\u000e"+
		"\u0007\u0000?@\u0005\u0016\u0000\u0000@B\u0003\u000e\u0007\u0000A?\u0001"+
		"\u0000\u0000\u0000BE\u0001\u0000\u0000\u0000CA\u0001\u0000\u0000\u0000"+
		"CD\u0001\u0000\u0000\u0000DG\u0001\u0000\u0000\u0000EC\u0001\u0000\u0000"+
		"\u0000F>\u0001\u0000\u0000\u0000FG\u0001\u0000\u0000\u0000GH\u0001\u0000"+
		"\u0000\u0000HI\u0005\u0015\u0000\u0000I\r\u0001\u0000\u0000\u0000JM\u0003"+
		"\u0004\u0002\u0000KM\u0003\u0010\b\u0000LJ\u0001\u0000\u0000\u0000LK\u0001"+
		"\u0000\u0000\u0000M\u000f\u0001\u0000\u0000\u0000NO\u0007\u0000\u0000"+
		"\u0000O\u0011\u0001\u0000\u0000\u0000PQ\u0005\f\u0000\u0000QR\u0003\u0018"+
		"\f\u0000R\u0013\u0001\u0000\u0000\u0000ST\u0007\u0001\u0000\u0000T\u0015"+
		"\u0001\u0000\u0000\u0000UV\u0005\r\u0000\u0000VW\u0007\u0002\u0000\u0000"+
		"W\u0017\u0001\u0000\u0000\u0000XY\u0007\u0003\u0000\u0000Y\u0019\u0001"+
		"\u0000\u0000\u0000Z]\u0003\u0018\f\u0000[\\\u0005\u0017\u0000\u0000\\"+
		"^\u0003\u0018\f\u0000][\u0001\u0000\u0000\u0000^_\u0001\u0000\u0000\u0000"+
		"_]\u0001\u0000\u0000\u0000_`\u0001\u0000\u0000\u0000`\u001b\u0001\u0000"+
		"\u0000\u0000\n!&),15CFL_";
	public static final ATN _ATN =
		new ATNDeserializer().deserialize(_serializedATN.toCharArray());
	static {
		_decisionToDFA = new DFA[_ATN.getNumberOfDecisions()];
		for (int i = 0; i < _ATN.getNumberOfDecisions(); i++) {
			_decisionToDFA[i] = new DFA(_ATN.getDecisionState(i), i);
		}
	}
}
