/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.process.internal;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.model.convert.spi.BasicValueConverter;
import org.hibernate.type.AbstractSingleColumnStandardBasicType;
import org.hibernate.type.ConvertedBasicType;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;

public class ValueConverterTypeAdapter<J>
extends AbstractSingleColumnStandardBasicType<J>
implements ConvertedBasicType<J> {
    private final String description;
    private final BasicValueConverter<J, Object> converter;
    private final ValueBinder<Object> valueBinder;

    public ValueConverterTypeAdapter(String description, BasicValueConverter<J, ?> converter, JdbcTypeIndicators indicators) {
        super(converter.getRelationalJavaType().getRecommendedJdbcType(indicators), converter.getRelationalJavaType());
        this.description = description;
        this.converter = converter;
        this.valueBinder = this.getJdbcType().getBinder(this.converter.getRelationalJavaType());
    }

    @Override
    public String getName() {
        return this.converter.getClass().getName();
    }

    @Override
    public void nullSafeSet(CallableStatement st, J value, String name, SharedSessionContractImplementor session) throws SQLException {
        Object converted = this.converter.toRelationalValue(value);
        this.valueBinder.bind(st, converted, name, (WrapperOptions)session);
    }

    @Override
    protected void nullSafeSet(PreparedStatement st, J value, int index, WrapperOptions options) throws SQLException {
        Object converted = this.converter.toRelationalValue(value);
        this.valueBinder.bind(st, converted, index, options);
    }

    @Override
    protected MutabilityPlan<J> getMutabilityPlan() {
        return this.converter.getDomainJavaType().getMutabilityPlan();
    }

    @Override
    public boolean isEqual(Object one, Object another) {
        return this.converter.getDomainJavaType().areEqual(one, another);
    }

    @Override
    public BasicValueConverter getValueConverter() {
        return this.converter;
    }

    public String toString() {
        return this.description;
    }
}

