/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.internal;

import jakarta.persistence.TemporalType;
import java.util.Collection;
import java.util.Iterator;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.BasicValuedMapping;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.query.BindableType;
import org.hibernate.query.QueryParameter;
import org.hibernate.query.internal.BindingTypeHelper;
import org.hibernate.query.spi.QueryParameterBinding;
import org.hibernate.query.spi.QueryParameterBindingValidator;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.type.descriptor.converter.AttributeConverterTypeAdapter;
import org.hibernate.type.descriptor.java.CoercionException;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.TemporalJavaType;
import org.hibernate.type.spi.TypeConfiguration;

public class QueryParameterBindingImpl<T>
implements QueryParameterBinding<T>,
JavaType.CoercionContext {
    private final QueryParameter<T> queryParameter;
    private final SessionFactoryImplementor sessionFactory;
    private boolean isBound;
    private boolean isMultiValued;
    private BindableType<? extends T> bindType;
    private MappingModelExpressible<T> type;
    private TemporalType explicitTemporalPrecision;
    private T bindValue;
    private Collection<? extends T> bindValues;

    protected QueryParameterBindingImpl(QueryParameter<T> queryParameter, SessionFactoryImplementor sessionFactory) {
        this.queryParameter = queryParameter;
        this.sessionFactory = sessionFactory;
        this.bindType = queryParameter.getHibernateType();
    }

    public QueryParameterBindingImpl(QueryParameter<T> queryParameter, SessionFactoryImplementor sessionFactory, BindableType<T> bindType) {
        this.queryParameter = queryParameter;
        this.sessionFactory = sessionFactory;
        this.bindType = bindType;
    }

    @Override
    public BindableType<? extends T> getBindType() {
        return this.bindType;
    }

    @Override
    public TemporalType getExplicitTemporalPrecision() {
        return this.explicitTemporalPrecision;
    }

    @Override
    public boolean isBound() {
        return this.isBound;
    }

    @Override
    public boolean isMultiValued() {
        return this.isMultiValued;
    }

    @Override
    public T getBindValue() {
        if (this.isMultiValued) {
            throw new IllegalStateException("Binding is multi-valued; illegal call to #getBindValue");
        }
        return this.bindValue;
    }

    @Override
    public void setBindValue(T value, boolean resolveJdbcTypeIfNecessary) {
        if (this.handleAsMultiValue(value, null)) {
            return;
        }
        if (!this.getTypeConfiguration().getSessionFactory().getJpaMetamodel().getJpaCompliance().isLoadByIdComplianceEnabled()) {
            try {
                if (this.bindType != null) {
                    value = this.coerce(value, this.bindType);
                } else if (this.queryParameter.getHibernateType() != null) {
                    value = this.coerce(value, this.queryParameter.getHibernateType());
                }
            }
            catch (CoercionException ce) {
                throw new IllegalArgumentException(String.format("Parameter value [%s] did not match expected type [%s ]", value, this.bindType), (Throwable)((Object)ce));
            }
        }
        this.validate(value);
        if (resolveJdbcTypeIfNecessary && this.bindType == null && value == null) {
            this.bindType = this.getTypeConfiguration().getBasicTypeRegistry().getRegisteredType("null");
        }
        this.bindValue(value);
    }

    private T coerce(T value, BindableType<? extends T> parameterType) {
        if (value == null) {
            return null;
        }
        SqmExpressible<T> sqmExpressible = parameterType.resolveExpressible(this.sessionFactory);
        assert (sqmExpressible != null);
        if (sqmExpressible instanceof AttributeConverterTypeAdapter) {
            return value;
        }
        return sqmExpressible.getExpressibleJavaType().coerce(value, this);
    }

    private boolean handleAsMultiValue(T value, BindableType<T> bindableType) {
        if (!this.queryParameter.allowsMultiValuedBinding()) {
            return false;
        }
        if (value == null) {
            return false;
        }
        if (value instanceof Collection && (bindableType != null && !bindableType.getBindableJavaType().isInstance(value) || bindableType == null && !this.isRegisteredAsBasicType(value.getClass()))) {
            this.setBindValues((Collection)value);
            return true;
        }
        return false;
    }

    private boolean isRegisteredAsBasicType(Class<?> valueClass) {
        return this.getTypeConfiguration().getBasicTypeForJavaType(valueClass) != null;
    }

    private void bindValue(T value) {
        this.isBound = true;
        this.bindValue = value;
        if (this.bindType == null && value != null) {
            this.bindType = this.sessionFactory.resolveParameterBindType(value);
        }
    }

    @Override
    public void setBindValue(T value, BindableType<T> clarifiedType) {
        if (this.handleAsMultiValue(value, clarifiedType)) {
            return;
        }
        if (clarifiedType != null) {
            this.bindType = clarifiedType;
        }
        if (this.bindType != null) {
            value = this.coerce(value, this.bindType);
        } else if (this.queryParameter.getHibernateType() != null) {
            value = this.coerce(value, this.queryParameter.getHibernateType());
        }
        this.validate(value, clarifiedType);
        this.bindValue(value);
    }

    @Override
    public void setBindValue(T value, TemporalType temporalTypePrecision) {
        if (this.handleAsMultiValue(value, null)) {
            return;
        }
        if (this.bindType == null) {
            this.bindType = this.queryParameter.getHibernateType();
        }
        if (!this.getTypeConfiguration().getSessionFactory().getJpaMetamodel().getJpaCompliance().isLoadByIdComplianceEnabled()) {
            if (this.bindType != null) {
                try {
                    value = this.coerce(value, this.bindType);
                }
                catch (CoercionException ex) {
                    throw new IllegalArgumentException(String.format("Parameter value [%s] did not match expected type [%s (%s)]", value, this.bindType, temporalTypePrecision == null ? "n/a" : temporalTypePrecision.name()), (Throwable)((Object)ex));
                }
            } else if (this.queryParameter.getHibernateType() != null) {
                value = this.coerce(value, this.queryParameter.getHibernateType());
            }
        }
        this.validate(value, temporalTypePrecision);
        this.bindValue(value);
        this.setExplicitTemporalPrecision(temporalTypePrecision);
    }

    @Override
    public Collection<? extends T> getBindValues() {
        if (!this.isMultiValued) {
            throw new IllegalStateException("Binding is not multi-valued; illegal call to #getBindValues");
        }
        return this.bindValues;
    }

    @Override
    public void setBindValues(Collection<? extends T> values) {
        this.isBound = true;
        this.isMultiValued = true;
        this.bindValue = null;
        this.bindValues = values;
        Iterator<T> iterator = values.iterator();
        Object value = null;
        while (value == null && iterator.hasNext()) {
            value = iterator.next();
        }
        if (this.bindType == null && value != null) {
            this.bindType = this.sessionFactory.resolveParameterBindType(value);
        }
    }

    @Override
    public void setBindValues(Collection<? extends T> values, BindableType<T> clarifiedType) {
        if (clarifiedType != null) {
            this.bindType = clarifiedType;
        }
        this.setBindValues(values);
    }

    @Override
    public void setBindValues(Collection<? extends T> values, TemporalType temporalTypePrecision, TypeConfiguration typeConfiguration) {
        this.setBindValues(values);
        this.setExplicitTemporalPrecision(temporalTypePrecision);
    }

    private void setExplicitTemporalPrecision(TemporalType temporalTypePrecision) {
        if (this.bindType == null || this.determineJavaType(this.bindType) instanceof TemporalJavaType) {
            this.bindType = BindingTypeHelper.INSTANCE.resolveTemporalPrecision(temporalTypePrecision, this.bindType, this.sessionFactory);
        }
        this.explicitTemporalPrecision = temporalTypePrecision;
    }

    private JavaType<? extends T> determineJavaType(BindableType<? extends T> bindType) {
        SqmExpressible<T> sqmExpressible = bindType.resolveExpressible(this.sessionFactory);
        assert (sqmExpressible != null);
        return sqmExpressible.getExpressibleJavaType();
    }

    @Override
    public MappingModelExpressible<T> getType() {
        return this.type;
    }

    @Override
    public boolean setType(MappingModelExpressible<T> type) {
        this.type = type;
        if (this.bindType == null || this.bindType.getBindableJavaType() == Object.class) {
            JdbcMapping jdbcMapping;
            if (type instanceof BindableType) {
                boolean changed = this.bindType != null && type != this.bindType;
                this.bindType = (BindableType)((Object)type);
                return changed;
            }
            if (type instanceof BasicValuedMapping && (jdbcMapping = ((BasicValuedMapping)type).getJdbcMapping()) instanceof BindableType) {
                boolean changed = this.bindType != null && jdbcMapping != this.bindType;
                this.bindType = (BindableType)((Object)jdbcMapping);
                return changed;
            }
        }
        return false;
    }

    private void validate(T value) {
        QueryParameterBindingValidator.INSTANCE.validate(this.getBindType(), value, this.sessionFactory);
    }

    private void validate(T value, BindableType<?> clarifiedType) {
        QueryParameterBindingValidator.INSTANCE.validate(clarifiedType, value, this.sessionFactory);
    }

    private void validate(T value, TemporalType clarifiedTemporalType) {
        QueryParameterBindingValidator.INSTANCE.validate(this.getBindType(), value, clarifiedTemporalType, this.sessionFactory);
    }

    @Override
    public TypeConfiguration getTypeConfiguration() {
        return this.sessionFactory.getTypeConfiguration();
    }
}

