/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.results.dynamic;

import jakarta.persistence.AttributeConverter;
import java.util.Objects;
import java.util.function.BiFunction;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.model.convert.internal.JpaAttributeConverterImpl;
import org.hibernate.metamodel.model.convert.spi.BasicValueConverter;
import org.hibernate.query.results.ResultSetMappingSqlSelection;
import org.hibernate.query.results.ResultsHelper;
import org.hibernate.query.results.dynamic.DynamicFetchBuilderLegacy;
import org.hibernate.query.results.dynamic.DynamicResultBuilderBasic;
import org.hibernate.resource.beans.spi.ManagedBean;
import org.hibernate.resource.beans.spi.ManagedBeanRegistry;
import org.hibernate.resource.beans.spi.ProvidedInstanceManagedBeanImpl;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.spi.JavaTypeRegistry;
import org.hibernate.type.spi.TypeConfiguration;

public class DynamicResultBuilderBasicConverted<O, R>
implements DynamicResultBuilderBasic {
    private final String columnAlias;
    private final BasicValueConverter<O, R> basicValueConverter;

    public DynamicResultBuilderBasicConverted(String columnAlias, Class<O> domainJavaType, Class<R> jdbcJavaType, AttributeConverter<O, R> converter, SessionFactoryImplementor sessionFactory) {
        TypeConfiguration typeConfiguration = sessionFactory.getTypeConfiguration();
        JavaTypeRegistry jtdRegistry = typeConfiguration.getJavaTypeRegistry();
        JavaType converterJtd = jtdRegistry.getDescriptor(converter.getClass());
        ProvidedInstanceManagedBeanImpl<AttributeConverter<O, R>> bean = new ProvidedInstanceManagedBeanImpl<AttributeConverter<O, R>>(converter);
        this.columnAlias = columnAlias;
        this.basicValueConverter = new JpaAttributeConverterImpl<O, R>(bean, converterJtd, jtdRegistry.getDescriptor(domainJavaType), jtdRegistry.getDescriptor(jdbcJavaType));
    }

    public DynamicResultBuilderBasicConverted(String columnAlias, Class<O> domainJavaType, Class<R> jdbcJavaType, Class<? extends AttributeConverter<O, R>> converterJavaType, SessionFactoryImplementor sessionFactory) {
        ManagedBeanRegistry beans = sessionFactory.getServiceRegistry().getService(ManagedBeanRegistry.class);
        TypeConfiguration typeConfiguration = sessionFactory.getTypeConfiguration();
        JavaTypeRegistry jtdRegistry = typeConfiguration.getJavaTypeRegistry();
        JavaType converterJtd = jtdRegistry.getDescriptor(converterJavaType);
        ManagedBean<? extends AttributeConverter<O, R>> bean = beans.getBean(converterJavaType);
        this.columnAlias = columnAlias;
        this.basicValueConverter = new JpaAttributeConverterImpl(bean, converterJtd, jtdRegistry.getDescriptor(domainJavaType), jtdRegistry.getDescriptor(jdbcJavaType));
    }

    @Override
    public Class<?> getJavaType() {
        return this.basicValueConverter.getDomainJavaType().getJavaTypeClass();
    }

    @Override
    public DynamicResultBuilderBasicConverted cacheKeyInstance() {
        return this;
    }

    @Override
    public BasicResult<?> buildResult(JdbcValuesMetadata jdbcResultsMetadata, int resultPosition, BiFunction<String, String, DynamicFetchBuilderLegacy> legacyFetchResolver, DomainResultCreationState domainResultCreationState) {
        TypeConfiguration typeConfiguration = domainResultCreationState.getSqlAstCreationState().getCreationContext().getSessionFactory().getTypeConfiguration();
        SqlExpressionResolver sqlExpressionResolver = domainResultCreationState.getSqlAstCreationState().getSqlExpressionResolver();
        SqlSelection sqlSelection = sqlExpressionResolver.resolveSqlSelection(sqlExpressionResolver.resolveSqlExpression(this.columnAlias, state -> {
            int currentJdbcPosition = resultPosition + 1;
            int jdbcPosition = this.columnAlias != null ? jdbcResultsMetadata.resolveColumnPosition(this.columnAlias) : currentJdbcPosition;
            BasicType<R> basicType = jdbcResultsMetadata.resolveType(jdbcPosition, this.basicValueConverter.getRelationalJavaType(), domainResultCreationState.getSqlAstCreationState().getCreationContext().getSessionFactory());
            int valuesArrayPosition = ResultsHelper.jdbcPositionToValuesArrayPosition(jdbcPosition);
            return new ResultSetMappingSqlSelection(valuesArrayPosition, basicType);
        }), this.basicValueConverter.getDomainJavaType(), null, typeConfiguration);
        return new BasicResult<O>(sqlSelection.getValuesArrayPosition(), this.columnAlias, this.basicValueConverter.getDomainJavaType(), this.basicValueConverter);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DynamicResultBuilderBasicConverted that = (DynamicResultBuilderBasicConverted)o;
        if (!Objects.equals(this.columnAlias, that.columnAlias)) {
            return false;
        }
        return this.basicValueConverter.equals(that.basicValueConverter);
    }

    public int hashCode() {
        int result = this.columnAlias != null ? this.columnAlias.hashCode() : 0;
        result = 31 * result + this.basicValueConverter.hashCode();
        return result;
    }
}

