/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.sql.internal;

import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.sql.internal.AbstractSqmPathInterpretation;
import org.hibernate.query.sqm.sql.internal.SqmPathInterpretation;
import org.hibernate.query.sqm.tree.domain.SqmPluralValuedSimplePath;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;

public class PluralValuedSimplePathInterpretation<T>
extends AbstractSqmPathInterpretation<T> {
    private final Expression sqlExpression;

    public static SqmPathInterpretation<?> from(SqmPluralValuedSimplePath<?> sqmPath, SqmToSqlAstConverter converter) {
        TableGroup tableGroup = converter.getFromClauseAccess().findTableGroup(sqmPath.getLhs().getNavigablePath());
        PluralAttributeMapping mapping = (PluralAttributeMapping)tableGroup.getModelPart().findSubPart(sqmPath.getReferencedPathSource().getPathName(), null);
        return new PluralValuedSimplePathInterpretation(null, sqmPath.getNavigablePath(), mapping, tableGroup);
    }

    private PluralValuedSimplePathInterpretation(Expression sqlExpression, NavigablePath navigablePath, PluralAttributeMapping mapping, TableGroup tableGroup) {
        super(navigablePath, mapping, tableGroup);
        this.sqlExpression = sqlExpression;
    }

    @Override
    public Expression getSqlExpression() {
        return this.sqlExpression;
    }

    @Override
    public DomainResult<T> createDomainResult(String resultVariable, DomainResultCreationState creationState) {
        return ((PluralAttributeMapping)this.getExpressionType()).getElementDescriptor().createDomainResult(this.getNavigablePath().append(CollectionPart.Nature.ELEMENT.getName()), this.getTableGroup(), resultVariable, creationState);
    }

    @Override
    public void accept(SqlAstWalker sqlTreeWalker) {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }
}

