/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.collection;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Consumer;
import org.hibernate.AssertionFailure;
import org.hibernate.FetchMode;
import org.hibernate.Filter;
import org.hibernate.HibernateException;
import org.hibernate.LockOptions;
import org.hibernate.MappingException;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.QueryException;
import org.hibernate.TransientObjectException;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.access.CollectionDataAccess;
import org.hibernate.cache.spi.entry.CacheEntryStructure;
import org.hibernate.cache.spi.entry.StructuredCollectionCacheEntry;
import org.hibernate.cache.spi.entry.StructuredMapCacheEntry;
import org.hibernate.cache.spi.entry.UnstructuredCacheEntry;
import org.hibernate.collection.spi.CollectionSemantics;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.batch.internal.BasicBatchKey;
import org.hibernate.engine.jdbc.spi.JdbcCoordinator;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.engine.profile.Fetch;
import org.hibernate.engine.profile.FetchProfile;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.ExecuteUpdateResultCheckStyle;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.SubselectFetch;
import org.hibernate.exception.spi.SQLExceptionConverter;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.FilterAliasGenerator;
import org.hibernate.internal.FilterHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.jdbc.Expectation;
import org.hibernate.jdbc.Expectations;
import org.hibernate.loader.ast.internal.CollectionElementLoaderByIndex;
import org.hibernate.loader.ast.internal.CollectionLoaderBatchKey;
import org.hibernate.loader.ast.internal.CollectionLoaderNamedQuery;
import org.hibernate.loader.ast.internal.CollectionLoaderSingleKey;
import org.hibernate.loader.ast.internal.CollectionLoaderSubSelectFetch;
import org.hibernate.loader.ast.internal.LoaderSqlAstCreationState;
import org.hibernate.loader.ast.spi.CollectionLoader;
import org.hibernate.mapping.Array;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Formula;
import org.hibernate.mapping.IdentifierCollection;
import org.hibernate.mapping.IndexedCollection;
import org.hibernate.mapping.List;
import org.hibernate.mapping.Map;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.Value;
import org.hibernate.metadata.CollectionMetadata;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationHelper;
import org.hibernate.metamodel.mapping.internal.PluralAttributeMappingImpl;
import org.hibernate.metamodel.model.convert.spi.BasicValueConverter;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.collection.CompositeElementPropertyMapping;
import org.hibernate.persister.collection.ElementPropertyMapping;
import org.hibernate.persister.collection.SQLLoadableCollection;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.persister.entity.PropertyMapping;
import org.hibernate.persister.internal.SqlFragmentPredicate;
import org.hibernate.persister.spi.PersisterCreationContext;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.query.named.NamedQueryMemento;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.Alias;
import org.hibernate.sql.Delete;
import org.hibernate.sql.Insert;
import org.hibernate.sql.SimpleSelect;
import org.hibernate.sql.Template;
import org.hibernate.sql.Update;
import org.hibernate.sql.ast.spi.SimpleFromClauseAccessImpl;
import org.hibernate.sql.ast.spi.SqlAliasBaseConstant;
import org.hibernate.sql.ast.spi.SqlAliasBaseManager;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.AliasedExpression;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectClause;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.results.internal.SqlSelectionImpl;
import org.hibernate.type.CollectionType;
import org.hibernate.type.CompositeType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

public abstract class AbstractCollectionPersister
implements CollectionMetadata,
SQLLoadableCollection,
PluralAttributeMappingImpl.Aware {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)AbstractCollectionPersister.class.getName());
    private final NavigableRole navigableRole;
    private final String sqlDeleteString;
    private final String sqlInsertRowString;
    private final String sqlUpdateRowString;
    private final String sqlDeleteRowString;
    private final String sqlSelectSizeString;
    private final String sqlDetectRowByIndexString;
    private final String sqlDetectRowByElementString;
    protected final boolean hasWhere;
    protected final String sqlWhereString;
    private final String sqlWhereStringTemplate;
    private final boolean hasOrder;
    private final boolean hasManyToManyOrder;
    private final int baseIndex;
    private final String mappedByProperty;
    protected final boolean indexContainsFormula;
    protected final boolean elementIsPureFormula;
    private final Type keyType;
    private final Type indexType;
    protected final Type elementType;
    private final Type identifierType;
    protected final String[] keyColumnNames;
    protected final String[] indexColumnNames;
    protected final String[] indexFormulaTemplates;
    protected final String[] indexFormulas;
    protected final boolean[] indexColumnIsGettable;
    protected final boolean[] indexColumnIsSettable;
    protected final String[] elementColumnNames;
    protected final String[] elementColumnWriters;
    protected final String[] elementColumnReaders;
    protected final String[] elementColumnReaderTemplates;
    protected final String[] elementFormulaTemplates;
    protected final String[] elementFormulas;
    protected final boolean[] elementColumnIsGettable;
    protected final boolean[] elementColumnIsSettable;
    protected final boolean[] elementColumnIsInPrimaryKey;
    protected final String[] indexColumnAliases;
    protected final String[] elementColumnAliases;
    protected final String[] keyColumnAliases;
    protected final String identifierColumnName;
    private final String identifierColumnAlias;
    protected final String qualifiedTableName;
    private final String queryLoaderName;
    private final boolean isPrimitiveArray;
    private final boolean isArray;
    protected final boolean hasIndex;
    protected final boolean hasIdentifier;
    private final boolean isLazy;
    private final boolean isExtraLazy;
    protected final boolean isInverse;
    private final boolean isMutable;
    private final boolean isVersioned;
    protected final int batchSize;
    private final FetchMode fetchMode;
    private final boolean hasOrphanDelete;
    private final boolean subselectLoadable;
    private final Class<?> elementClass;
    private final String entityName;
    private final Dialect dialect;
    protected final SqlExceptionHelper sqlExceptionHelper;
    private final SessionFactoryImplementor factory;
    private final EntityPersister ownerPersister;
    private final IdentifierGenerator identifierGenerator;
    private final PropertyMapping elementPropertyMapping;
    private final EntityPersister elementPersister;
    private final CollectionDataAccess cacheAccessStrategy;
    private final CollectionType collectionType;
    private final CacheEntryStructure cacheEntryStructure;
    private final FilterHelper filterHelper;
    private final FilterHelper manyToManyFilterHelper;
    private final String manyToManyWhereString;
    private final String manyToManyWhereTemplate;
    private final boolean insertCallable;
    private final boolean updateCallable;
    private final boolean deleteCallable;
    private final boolean deleteAllCallable;
    private final ExecuteUpdateResultCheckStyle insertCheckStyle;
    private final ExecuteUpdateResultCheckStyle updateCheckStyle;
    private final ExecuteUpdateResultCheckStyle deleteCheckStyle;
    private final ExecuteUpdateResultCheckStyle deleteAllCheckStyle;
    private final Serializable[] spaces;
    private final java.util.Map<String, String[]> collectionPropertyColumnAliases = new HashMap<String, String[]>();
    private final Comparator<?> comparator;
    private CollectionLoader collectionLoader;
    private volatile CollectionLoader standardCollectionLoader;
    private CollectionElementLoaderByIndex collectionElementLoaderByIndex;
    private final CollectionSemantics<?, ?> collectionSemantics;
    private BasicBatchKey removeBatchKey;
    protected BasicBatchKey recreateBatchKey;
    private BasicBatchKey deleteBatchKey;
    private BasicBatchKey insertBatchKey;
    private String[] indexFragments;
    private PluralAttributeMapping attributeMapping;

    @Deprecated(since="6.0")
    public AbstractCollectionPersister(Collection collectionBootDescriptor, CollectionDataAccess cacheAccessStrategy, PersisterCreationContext creationContext) throws MappingException, CacheException {
        this(collectionBootDescriptor, cacheAccessStrategy, (RuntimeModelCreationContext)creationContext);
    }

    public AbstractCollectionPersister(Collection collectionBootDescriptor, CollectionDataAccess cacheAccessStrategy, RuntimeModelCreationContext creationContext) throws MappingException, CacheException {
        NamedQueryMemento namedQueryMemento;
        Value elementBootDescriptor = collectionBootDescriptor.getElement();
        Value indexBootDescriptor = collectionBootDescriptor instanceof IndexedCollection ? ((IndexedCollection)collectionBootDescriptor).getIndex() : null;
        this.factory = creationContext.getSessionFactory();
        this.cacheAccessStrategy = cacheAccessStrategy;
        this.cacheEntryStructure = this.factory.getSessionFactoryOptions().isStructuredCacheEntriesEnabled() ? (collectionBootDescriptor.isMap() ? StructuredMapCacheEntry.INSTANCE : StructuredCollectionCacheEntry.INSTANCE) : UnstructuredCacheEntry.INSTANCE;
        this.dialect = this.factory.getJdbcServices().getDialect();
        this.sqlExceptionHelper = this.factory.getJdbcServices().getSqlExceptionHelper();
        this.collectionType = collectionBootDescriptor.getCollectionType();
        this.navigableRole = new NavigableRole(collectionBootDescriptor.getRole());
        this.entityName = collectionBootDescriptor.getOwnerEntityName();
        this.ownerPersister = creationContext.getDomainModel().getEntityDescriptor(this.entityName);
        this.queryLoaderName = collectionBootDescriptor.getLoaderName();
        this.isMutable = collectionBootDescriptor.isMutable();
        this.mappedByProperty = collectionBootDescriptor.getMappedByProperty();
        Table table = collectionBootDescriptor.getCollectionTable();
        this.fetchMode = elementBootDescriptor.getFetchMode();
        this.elementType = elementBootDescriptor.getType();
        this.isPrimitiveArray = collectionBootDescriptor.isPrimitiveArray();
        this.isArray = collectionBootDescriptor.isArray();
        this.subselectLoadable = collectionBootDescriptor.isSubselectLoadable();
        this.qualifiedTableName = this.determineTableName(table);
        int spacesSize = 1 + collectionBootDescriptor.getSynchronizedTables().size();
        this.spaces = new String[spacesSize];
        this.spaces[0] = this.qualifiedTableName;
        Iterator<String> tables = collectionBootDescriptor.getSynchronizedTables().iterator();
        for (int i = 1; i < spacesSize; ++i) {
            this.spaces[i] = (Serializable)((Object)tables.next());
        }
        if (StringHelper.isNotEmpty(collectionBootDescriptor.getWhere())) {
            this.hasWhere = true;
            this.sqlWhereString = "(" + collectionBootDescriptor.getWhere() + ") ";
            this.sqlWhereStringTemplate = Template.renderWhereStringTemplate(this.sqlWhereString, this.dialect, this.factory.getTypeConfiguration(), this.factory.getQueryEngine().getSqmFunctionRegistry());
        } else {
            this.hasWhere = false;
            this.sqlWhereString = null;
            this.sqlWhereStringTemplate = null;
        }
        this.hasOrphanDelete = collectionBootDescriptor.hasOrphanDelete();
        int batch = collectionBootDescriptor.getBatchSize();
        if (batch == -1) {
            batch = this.factory.getSessionFactoryOptions().getDefaultBatchFetchSize();
        }
        this.batchSize = batch;
        this.isVersioned = collectionBootDescriptor.isOptimisticLocked();
        this.keyType = collectionBootDescriptor.getKey().getType();
        int keySpan = collectionBootDescriptor.getKey().getColumnSpan();
        this.keyColumnNames = new String[keySpan];
        this.keyColumnAliases = new String[keySpan];
        int k = 0;
        for (Column column : collectionBootDescriptor.getKey().getColumns()) {
            this.keyColumnNames[k] = column.getQuotedName(this.dialect);
            this.keyColumnAliases[k] = column.getAlias(this.dialect, table);
            ++k;
        }
        if (this.elementType.isEntityType()) {
            String entityName = ((EntityType)this.elementType).getAssociatedEntityName();
            this.elementPersister = creationContext.getDomainModel().getEntityDescriptor(entityName);
        } else {
            this.elementPersister = null;
        }
        int elementSpan = elementBootDescriptor.getColumnSpan();
        this.elementColumnAliases = new String[elementSpan];
        this.elementColumnNames = new String[elementSpan];
        this.elementColumnWriters = new String[elementSpan];
        this.elementColumnReaders = new String[elementSpan];
        this.elementColumnReaderTemplates = new String[elementSpan];
        this.elementFormulaTemplates = new String[elementSpan];
        this.elementFormulas = new String[elementSpan];
        this.elementColumnIsSettable = new boolean[elementSpan];
        this.elementColumnIsGettable = new boolean[elementSpan];
        this.elementColumnIsInPrimaryKey = new boolean[elementSpan];
        boolean isPureFormula = true;
        boolean hasNotNullableColumns = false;
        boolean oneToMany = collectionBootDescriptor.isOneToMany();
        boolean[] columnInsertability = null;
        if (!oneToMany) {
            columnInsertability = elementBootDescriptor.getColumnInsertability();
        }
        int j = 0;
        for (Selectable selectable : elementBootDescriptor.getSelectables()) {
            this.elementColumnAliases[j] = selectable.getAlias(this.dialect, table);
            if (selectable.isFormula()) {
                Formula form = (Formula)selectable;
                this.elementFormulaTemplates[j] = form.getTemplate(this.dialect, this.factory.getTypeConfiguration(), this.factory.getQueryEngine().getSqmFunctionRegistry());
                this.elementFormulas[j] = form.getFormula();
            } else {
                Column col = (Column)selectable;
                this.elementColumnNames[j] = col.getQuotedName(this.dialect);
                this.elementColumnWriters[j] = col.getWriteExpr();
                this.elementColumnReaders[j] = col.getReadExpr(this.dialect);
                this.elementColumnReaderTemplates[j] = col.getTemplate(this.dialect, this.factory.getTypeConfiguration(), this.factory.getQueryEngine().getSqmFunctionRegistry());
                this.elementColumnIsGettable[j] = true;
                this.elementColumnIsSettable[j] = this.elementType.isComponentType() ? columnInsertability[j] : true;
                boolean bl = this.elementColumnIsInPrimaryKey[j] = !col.isNullable();
                if (!col.isNullable()) {
                    hasNotNullableColumns = true;
                }
                isPureFormula = false;
            }
            ++j;
        }
        this.elementIsPureFormula = isPureFormula;
        if (!hasNotNullableColumns) {
            Arrays.fill(this.elementColumnIsInPrimaryKey, true);
        }
        this.hasIndex = collectionBootDescriptor.isIndexed();
        if (this.hasIndex) {
            IndexedCollection indexedCollection = (IndexedCollection)collectionBootDescriptor;
            this.indexType = indexedCollection.getIndex().getType();
            int indexSpan = indexedCollection.getIndex().getColumnSpan();
            boolean[] indexColumnInsertability = indexedCollection.getIndex().getColumnInsertability();
            boolean[] indexColumnUpdatability = indexedCollection.getIndex().getColumnUpdateability();
            this.indexColumnNames = new String[indexSpan];
            this.indexFormulaTemplates = new String[indexSpan];
            this.indexFormulas = new String[indexSpan];
            this.indexColumnIsGettable = new boolean[indexSpan];
            this.indexColumnIsSettable = new boolean[indexSpan];
            this.indexColumnAliases = new String[indexSpan];
            int i = 0;
            boolean hasFormula = false;
            for (Selectable s : indexedCollection.getIndex().getSelectables()) {
                Column indexCol;
                this.indexColumnAliases[i] = s.getAlias(this.dialect);
                if (s.isFormula()) {
                    Formula indexForm = (Formula)s;
                    this.indexFormulaTemplates[i] = indexForm.getTemplate(this.dialect, this.factory.getTypeConfiguration(), this.factory.getQueryEngine().getSqmFunctionRegistry());
                    this.indexFormulas[i] = indexForm.getFormula();
                    hasFormula = true;
                } else if (indexedCollection instanceof Map && ((Map)indexedCollection).getMapKeyPropertyName() != null) {
                    indexCol = (Column)s;
                    this.indexFormulaTemplates[i] = "$PlaceHolder$" + indexCol.getQuotedName(this.dialect);
                    this.indexFormulas[i] = indexCol.getQuotedName(this.dialect);
                    hasFormula = true;
                } else {
                    indexCol = (Column)s;
                    this.indexColumnNames[i] = indexCol.getQuotedName(this.dialect);
                    this.indexColumnIsGettable[i] = true;
                    this.indexColumnIsSettable[i] = indexColumnInsertability[i] || indexColumnUpdatability[i];
                }
                ++i;
            }
            this.indexContainsFormula = hasFormula;
            this.baseIndex = indexedCollection.isList() ? ((List)indexedCollection).getBaseIndex() : 0;
        } else {
            this.indexContainsFormula = false;
            this.indexColumnIsGettable = null;
            this.indexColumnIsSettable = null;
            this.indexFormulaTemplates = null;
            this.indexFormulas = null;
            this.indexType = null;
            this.indexColumnNames = null;
            this.indexColumnAliases = null;
            this.baseIndex = 0;
        }
        this.hasIdentifier = collectionBootDescriptor.isIdentified();
        if (this.hasIdentifier) {
            if (collectionBootDescriptor.isOneToMany()) {
                throw new MappingException("one-to-many collections with identifiers are not supported");
            }
            IdentifierCollection idColl = (IdentifierCollection)collectionBootDescriptor;
            this.identifierType = idColl.getIdentifier().getType();
            Column col = idColl.getIdentifier().getColumns().get(0);
            this.identifierColumnName = col.getQuotedName(this.dialect);
            this.identifierColumnAlias = col.getAlias(this.dialect);
            this.identifierGenerator = idColl.getIdentifier().createIdentifierGenerator(creationContext.getBootstrapContext().getIdentifierGeneratorFactory(), this.factory.getJdbcServices().getDialect(), null);
            this.identifierGenerator.initialize(creationContext.getSessionFactory().getSqlStringGenerationContext());
        } else {
            this.identifierType = null;
            this.identifierColumnName = null;
            this.identifierColumnAlias = null;
            this.identifierGenerator = null;
        }
        if (collectionBootDescriptor.getCustomSQLInsert() == null) {
            this.sqlInsertRowString = this.generateInsertRowString();
            this.insertCallable = false;
            this.insertCheckStyle = ExecuteUpdateResultCheckStyle.COUNT;
        } else {
            this.sqlInsertRowString = collectionBootDescriptor.getCustomSQLInsert();
            this.insertCallable = collectionBootDescriptor.isCustomInsertCallable();
            ExecuteUpdateResultCheckStyle executeUpdateResultCheckStyle = this.insertCheckStyle = collectionBootDescriptor.getCustomSQLInsertCheckStyle() == null ? ExecuteUpdateResultCheckStyle.determineDefault(collectionBootDescriptor.getCustomSQLInsert(), this.insertCallable) : collectionBootDescriptor.getCustomSQLInsertCheckStyle();
        }
        if (collectionBootDescriptor.getCustomSQLUpdate() == null) {
            this.sqlUpdateRowString = this.generateUpdateRowString();
            this.updateCallable = false;
            this.updateCheckStyle = ExecuteUpdateResultCheckStyle.COUNT;
        } else {
            this.sqlUpdateRowString = collectionBootDescriptor.getCustomSQLUpdate();
            this.updateCallable = collectionBootDescriptor.isCustomUpdateCallable();
            ExecuteUpdateResultCheckStyle executeUpdateResultCheckStyle = this.updateCheckStyle = collectionBootDescriptor.getCustomSQLUpdateCheckStyle() == null ? ExecuteUpdateResultCheckStyle.determineDefault(collectionBootDescriptor.getCustomSQLUpdate(), this.insertCallable) : collectionBootDescriptor.getCustomSQLUpdateCheckStyle();
        }
        if (collectionBootDescriptor.getCustomSQLDelete() == null) {
            this.sqlDeleteRowString = this.generateDeleteRowString();
            this.deleteCallable = false;
            this.deleteCheckStyle = ExecuteUpdateResultCheckStyle.NONE;
        } else {
            this.sqlDeleteRowString = collectionBootDescriptor.getCustomSQLDelete();
            this.deleteCallable = collectionBootDescriptor.isCustomDeleteCallable();
            this.deleteCheckStyle = ExecuteUpdateResultCheckStyle.NONE;
        }
        if (collectionBootDescriptor.getCustomSQLDeleteAll() == null) {
            this.sqlDeleteString = this.generateDeleteString();
            this.deleteAllCallable = false;
            this.deleteAllCheckStyle = ExecuteUpdateResultCheckStyle.NONE;
        } else {
            this.sqlDeleteString = collectionBootDescriptor.getCustomSQLDeleteAll();
            this.deleteAllCallable = collectionBootDescriptor.isCustomDeleteAllCallable();
            this.deleteAllCheckStyle = ExecuteUpdateResultCheckStyle.NONE;
        }
        this.sqlSelectSizeString = this.generateSelectSizeString(collectionBootDescriptor.isIndexed() && !collectionBootDescriptor.isMap());
        this.sqlDetectRowByIndexString = this.generateDetectRowByIndexString();
        this.sqlDetectRowByElementString = this.generateDetectRowByElementString();
        this.logStaticSQL();
        this.isLazy = collectionBootDescriptor.isLazy();
        this.isExtraLazy = collectionBootDescriptor.isExtraLazy();
        this.isInverse = collectionBootDescriptor.isInverse();
        this.elementClass = collectionBootDescriptor.isArray() ? ((Array)collectionBootDescriptor).getElementClass() : null;
        this.elementPropertyMapping = this.elementType.isComponentType() ? new CompositeElementPropertyMapping(this.elementColumnNames, this.elementColumnReaders, this.elementColumnReaderTemplates, this.elementFormulaTemplates, (CompositeType)this.elementType, creationContext.getMetadata()) : (!this.elementType.isEntityType() ? new ElementPropertyMapping(this.elementColumnNames, this.elementType) : (this.elementPersister instanceof PropertyMapping ? (PropertyMapping)((Object)this.elementPersister) : new ElementPropertyMapping(this.elementColumnNames, this.elementType)));
        this.hasOrder = collectionBootDescriptor.getOrderBy() != null;
        this.hasManyToManyOrder = collectionBootDescriptor.getManyToManyOrdering() != null;
        this.filterHelper = collectionBootDescriptor.getFilters().isEmpty() ? null : new FilterHelper(collectionBootDescriptor.getFilters(), this.factory);
        this.manyToManyFilterHelper = collectionBootDescriptor.getManyToManyFilters().isEmpty() ? null : new FilterHelper(collectionBootDescriptor.getManyToManyFilters(), this.factory);
        if (StringHelper.isEmpty(collectionBootDescriptor.getManyToManyWhere())) {
            this.manyToManyWhereString = null;
            this.manyToManyWhereTemplate = null;
        } else {
            this.manyToManyWhereString = "( " + collectionBootDescriptor.getManyToManyWhere() + ")";
            this.manyToManyWhereTemplate = Template.renderWhereStringTemplate(this.manyToManyWhereString, this.factory.getJdbcServices().getDialect(), this.factory.getTypeConfiguration(), this.factory.getQueryEngine().getSqmFunctionRegistry());
        }
        this.comparator = collectionBootDescriptor.getComparator();
        this.initCollectionPropertyMap();
        this.collectionSemantics = creationContext.getBootstrapContext().getMetadataBuildingOptions().getPersistentCollectionRepresentationResolver().resolveRepresentation(collectionBootDescriptor);
        if (this.queryLoaderName != null && (namedQueryMemento = this.factory.getQueryEngine().getNamedObjectRepository().resolve(this.factory, collectionBootDescriptor.getMetadata(), this.queryLoaderName)) == null) {
            throw new IllegalArgumentException("Could not resolve named load-query [" + this.navigableRole + "] : " + this.queryLoaderName);
        }
    }

    @Override
    public Comparator<?> getSortingComparator() {
        return this.comparator;
    }

    protected String determineTableName(Table table) {
        return MappingModelCreationHelper.getTableIdentifierExpression(table, this.factory);
    }

    @Override
    public void postInstantiate() throws MappingException {
        if (this.queryLoaderName == null) {
            this.collectionLoader = this.createCollectionLoader(LoadQueryInfluencers.NONE);
        } else {
            NamedQueryMemento namedQueryMemento = this.factory.getQueryEngine().getNamedObjectRepository().resolve(this.factory, null, this.queryLoaderName);
            this.collectionLoader = new CollectionLoaderNamedQuery(this, namedQueryMemento);
        }
        if (this.attributeMapping.getIndexDescriptor() != null) {
            this.collectionElementLoaderByIndex = new CollectionElementLoaderByIndex(this.attributeMapping, this.baseIndex, LoadQueryInfluencers.NONE, this.getFactory());
        }
    }

    protected void logStaticSQL() {
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Static SQL for collection: %s", this.getRole());
            if (this.getSQLInsertRowString() != null) {
                LOG.debugf(" Row insert: %s", this.getSQLInsertRowString());
            }
            if (this.getSQLUpdateRowString() != null) {
                LOG.debugf(" Row update: %s", this.getSQLUpdateRowString());
            }
            if (this.getSQLDeleteRowString() != null) {
                LOG.debugf(" Row delete: %s", this.getSQLDeleteRowString());
            }
            if (this.getSQLDeleteString() != null) {
                LOG.debugf(" One-shot delete: %s", this.getSQLDeleteString());
            }
        }
    }

    @Override
    public void initialize(Object key, SharedSessionContractImplementor session) throws HibernateException {
        this.determineLoaderToUse(key, session).load(key, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CollectionLoader getStandardCollectionLoader() {
        CollectionLoader localCopy = this.standardCollectionLoader;
        if (localCopy == null) {
            AbstractCollectionPersister abstractCollectionPersister = this;
            synchronized (abstractCollectionPersister) {
                localCopy = this.standardCollectionLoader;
                if (localCopy == null) {
                    localCopy = this.queryLoaderName != null ? this.collectionLoader : this.createCollectionLoader(LoadQueryInfluencers.NONE);
                    this.standardCollectionLoader = localCopy;
                }
            }
        }
        return localCopy;
    }

    protected CollectionLoader determineLoaderToUse(Object key, SharedSessionContractImplementor session) {
        if (this.queryLoaderName != null) {
            return this.getStandardCollectionLoader();
        }
        CollectionLoader subSelectLoader = this.resolveSubSelectLoader(key, session);
        if (subSelectLoader != null) {
            return subSelectLoader;
        }
        if (!session.getLoadQueryInfluencers().hasEnabledFilters() && !this.isAffectedByEnabledFetchProfiles(session.getLoadQueryInfluencers())) {
            return this.getStandardCollectionLoader();
        }
        return this.createCollectionLoader(session.getLoadQueryInfluencers());
    }

    private CollectionLoader resolveSubSelectLoader(Object key, SharedSessionContractImplementor session) {
        if (!this.isSubselectLoadable()) {
            return null;
        }
        PersistenceContext persistenceContext = session.getPersistenceContextInternal();
        EntityKey ownerEntityKey = session.generateEntityKey(key, this.getOwnerEntityPersister());
        SubselectFetch subselect = persistenceContext.getBatchFetchQueue().getSubselect(ownerEntityKey);
        if (subselect == null) {
            return null;
        }
        subselect.getResultingEntityKeys().removeIf(o -> !persistenceContext.containsEntity((EntityKey)o));
        return this.createSubSelectLoader(subselect, session);
    }

    protected CollectionLoader createSubSelectLoader(SubselectFetch subselect, SharedSessionContractImplementor session) {
        return new CollectionLoaderSubSelectFetch(this.attributeMapping, null, subselect, session);
    }

    protected CollectionLoader createCollectionLoader(LoadQueryInfluencers loadQueryInfluencers) {
        int batchSize = this.getBatchSize();
        if (batchSize > 1) {
            return new CollectionLoaderBatchKey(this.attributeMapping, batchSize, loadQueryInfluencers, this.getFactory());
        }
        return new CollectionLoaderSingleKey(this.attributeMapping, loadQueryInfluencers, this.getFactory());
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.navigableRole;
    }

    @Override
    public CollectionDataAccess getCacheAccessStrategy() {
        return this.cacheAccessStrategy;
    }

    @Override
    public boolean hasCache() {
        return this.cacheAccessStrategy != null;
    }

    @Override
    public CollectionType getCollectionType() {
        return this.collectionType;
    }

    @Override
    public String getSQLOrderByString(String alias) {
        if (this.hasOrdering()) {
            throw new NotYetImplementedFor6Exception(this.getClass());
        }
        return "";
    }

    @Override
    public String getManyToManyOrderByString(String alias) {
        if (this.hasManyToManyOrdering()) {
            throw new NotYetImplementedFor6Exception(this.getClass());
        }
        return "";
    }

    @Override
    public FetchMode getFetchMode() {
        return this.fetchMode;
    }

    @Override
    public boolean hasOrdering() {
        return this.hasOrder;
    }

    @Override
    public boolean hasManyToManyOrdering() {
        return this.isManyToMany() && this.hasManyToManyOrder;
    }

    @Override
    public boolean hasWhere() {
        return this.hasWhere;
    }

    protected String getSQLDeleteString() {
        return this.sqlDeleteString;
    }

    protected String getSQLInsertRowString() {
        return this.sqlInsertRowString;
    }

    protected String getSQLUpdateRowString() {
        return this.sqlUpdateRowString;
    }

    protected String getSQLDeleteRowString() {
        return this.sqlDeleteRowString;
    }

    @Override
    public Type getKeyType() {
        return this.keyType;
    }

    @Override
    public Type getIndexType() {
        return this.indexType;
    }

    @Override
    public Type getElementType() {
        return this.elementType;
    }

    @Override
    public BasicValueConverter<?, ?> getElementConverter() {
        return this.elementType instanceof JdbcMapping ? ((JdbcMapping)((Object)this.elementType)).getValueConverter() : null;
    }

    @Override
    public BasicValueConverter<?, ?> getIndexConverter() {
        return this.indexType instanceof JdbcMapping ? ((JdbcMapping)((Object)this.indexType)).getValueConverter() : null;
    }

    @Override
    public Class<?> getElementClass() {
        return this.elementClass;
    }

    protected Object decrementIndexByBase(Object index) {
        if (this.baseIndex != 0) {
            index = (Integer)index - this.baseIndex;
        }
        return index;
    }

    protected int writeKey(PreparedStatement st, Object key, int i, SharedSessionContractImplementor session) throws HibernateException, SQLException {
        if (key == null) {
            throw new NullPointerException("null key for collection: " + this.navigableRole.getFullPath());
        }
        this.getKeyType().nullSafeSet(st, key, i, session);
        return i + this.keyColumnAliases.length;
    }

    protected int writeElement(PreparedStatement st, Object elt, int i, SharedSessionContractImplementor session) throws HibernateException, SQLException {
        this.getElementType().nullSafeSet(st, elt, i, this.elementColumnIsSettable, session);
        return i + ArrayHelper.countTrue(this.elementColumnIsSettable);
    }

    protected int writeIndex(PreparedStatement st, Object index, int i, SharedSessionContractImplementor session) throws HibernateException, SQLException {
        this.getIndexType().nullSafeSet(st, this.incrementIndexByBase(index), i, this.indexColumnIsSettable, session);
        return i + ArrayHelper.countTrue(this.indexColumnIsSettable);
    }

    protected Object incrementIndexByBase(Object index) {
        if (this.baseIndex != 0) {
            index = (Integer)index + this.baseIndex;
        }
        return index;
    }

    protected int writeElementToWhere(PreparedStatement st, Object elt, int i, SharedSessionContractImplementor session) throws HibernateException, SQLException {
        if (this.elementIsPureFormula) {
            throw new AssertionFailure("cannot use a formula-based element in the where condition");
        }
        this.getElementType().nullSafeSet(st, elt, i, this.elementColumnIsInPrimaryKey, session);
        return i + this.elementColumnAliases.length;
    }

    protected int writeIndexToWhere(PreparedStatement st, Object index, int i, SharedSessionContractImplementor session) throws HibernateException, SQLException {
        if (this.indexContainsFormula) {
            throw new AssertionFailure("cannot use a formula-based index in the where condition");
        }
        this.getIndexType().nullSafeSet(st, this.incrementIndexByBase(index), i, session);
        return i + this.indexColumnAliases.length;
    }

    public int writeIdentifier(PreparedStatement st, Object id, int i, SharedSessionContractImplementor session) throws HibernateException, SQLException {
        this.getIdentifierType().nullSafeSet(st, id, i, session);
        return i + 1;
    }

    @Override
    public boolean isPrimitiveArray() {
        return this.isPrimitiveArray;
    }

    @Override
    public boolean isArray() {
        return this.isArray;
    }

    @Override
    public String[] getKeyColumnAliases(String suffix) {
        return new Alias(suffix).toAliasStrings(this.keyColumnAliases);
    }

    @Override
    public String[] getElementColumnAliases(String suffix) {
        return new Alias(suffix).toAliasStrings(this.elementColumnAliases);
    }

    @Override
    public String[] getIndexColumnAliases(String suffix) {
        if (this.hasIndex) {
            return new Alias(suffix).toAliasStrings(this.indexColumnAliases);
        }
        return null;
    }

    @Override
    public String getIdentifierColumnAlias(String suffix) {
        if (this.hasIdentifier) {
            return new Alias(suffix).toAliasString(this.identifierColumnAlias);
        }
        return null;
    }

    @Override
    public String getIdentifierColumnName() {
        if (this.hasIdentifier) {
            return this.identifierColumnName;
        }
        return null;
    }

    @Override
    public String selectFragment(String alias, String columnSuffix) {
        PluralAttributeMapping attributeMapping = this.getAttributeMapping();
        QuerySpec rootQuerySpec = new QuerySpec(true);
        LoaderSqlAstCreationState sqlAstCreationState = new LoaderSqlAstCreationState(rootQuerySpec, new SqlAliasBaseManager(), new SimpleFromClauseAccessImpl(), LockOptions.NONE, (fetchParent, querySpec, creationState) -> new ArrayList(), true, this.getFactory());
        NavigablePath entityPath = new NavigablePath(attributeMapping.getRootPathName());
        TableGroup rootTableGroup = attributeMapping.createRootTableGroup(true, entityPath, null, () -> p -> {}, new SqlAliasBaseConstant(alias), sqlAstCreationState.getSqlExpressionResolver(), sqlAstCreationState.getFromClauseAccess(), this.getFactory());
        rootQuerySpec.getFromClause().addRoot(rootTableGroup);
        sqlAstCreationState.getFromClauseAccess().registerTableGroup(entityPath, rootTableGroup);
        attributeMapping.createDomainResult(entityPath, rootTableGroup, null, sqlAstCreationState);
        SelectClause selectClause = rootQuerySpec.getSelectClause();
        java.util.List<SqlSelection> sqlSelections = selectClause.getSqlSelections();
        int i = 0;
        for (String keyAlias : this.keyColumnAliases) {
            sqlSelections.set(i, new SqlSelectionImpl(i, i + 1, new AliasedExpression(sqlSelections.get(i).getExpression(), keyAlias + columnSuffix)));
            ++i;
        }
        if (this.hasIndex) {
            for (String indexAlias : this.indexColumnAliases) {
                sqlSelections.set(i, new SqlSelectionImpl(i, i + 1, new AliasedExpression(sqlSelections.get(i).getExpression(), indexAlias + columnSuffix)));
                ++i;
            }
        }
        if (this.hasIdentifier) {
            sqlSelections.set(i, new SqlSelectionImpl(i, i + 1, new AliasedExpression(sqlSelections.get(i).getExpression(), this.identifierColumnAlias + columnSuffix)));
            ++i;
        }
        int columnIndex = 0;
        while (i < sqlSelections.size()) {
            SqlSelection sqlSelection = sqlSelections.get(i);
            sqlSelections.set(i, new SqlSelectionImpl(sqlSelection.getValuesArrayPosition(), sqlSelection.getJdbcResultSetIndex(), new AliasedExpression(sqlSelection.getExpression(), this.elementColumnAliases[columnIndex] + columnSuffix)));
            ++i;
            ++columnIndex;
        }
        String sql = this.getFactory().getJdbcServices().getDialect().getSqlAstTranslatorFactory().buildSelectTranslator(this.getFactory(), new SelectStatement(rootQuerySpec)).translate(null, QueryOptions.NONE).getSql();
        int fromIndex = sql.lastIndexOf(" from");
        String expression = fromIndex != -1 ? sql.substring("select ".length(), fromIndex) : sql.substring("select ".length());
        return expression;
    }

    protected String generateSelectSizeString(boolean isIntegerIndexed) {
        String selectValue = isIntegerIndexed ? "max(" + this.getIndexColumnNames()[0] + ") + 1" : "count(" + this.getElementColumnNames()[0] + ")";
        return new SimpleSelect(this.dialect).setTableName(this.getTableName()).addCondition(this.getKeyColumnNames(), "=?").addWhereToken(this.sqlWhereString).addColumn(selectValue).toStatementString();
    }

    protected String generateDetectRowByIndexString() {
        if (!this.hasIndex()) {
            return null;
        }
        return new SimpleSelect(this.dialect).setTableName(this.getTableName()).addCondition(this.getKeyColumnNames(), "=?").addCondition(this.getIndexColumnNames(), "=?").addCondition(this.indexFormulas, "=?").addWhereToken(this.sqlWhereString).addColumn("1").toStatementString();
    }

    protected String generateDetectRowByElementString() {
        return new SimpleSelect(this.dialect).setTableName(this.getTableName()).addCondition(this.getKeyColumnNames(), "=?").addCondition(this.getElementColumnNames(), "=?").addCondition(this.elementFormulas, "=?").addWhereToken(this.sqlWhereString).addColumn("1").toStatementString();
    }

    @Override
    public String[] getIndexColumnNames() {
        return this.indexColumnNames;
    }

    @Override
    public String[] getIndexFormulas() {
        return this.indexFormulas;
    }

    @Override
    public String[] getIndexColumnNames(String alias) {
        return AbstractCollectionPersister.qualify(alias, this.indexColumnNames, this.indexFormulaTemplates);
    }

    @Override
    public String[] getElementColumnNames(String alias) {
        return AbstractCollectionPersister.qualify(alias, this.elementColumnNames, this.elementFormulaTemplates);
    }

    private static String[] qualify(String alias, String[] columnNames, String[] formulaTemplates) {
        int span = columnNames.length;
        String[] result = new String[span];
        for (int i = 0; i < span; ++i) {
            result[i] = columnNames[i] == null ? StringHelper.replace(formulaTemplates[i], "$PlaceHolder$", alias) : StringHelper.qualify(alias, columnNames[i]);
        }
        return result;
    }

    @Override
    public String[] getElementColumnNames() {
        return this.elementColumnNames;
    }

    @Override
    public String[] getKeyColumnNames() {
        return this.keyColumnNames;
    }

    @Override
    public boolean hasIndex() {
        return this.hasIndex;
    }

    @Override
    public boolean isLazy() {
        return this.isLazy;
    }

    @Override
    public boolean isInverse() {
        return this.isInverse;
    }

    @Override
    public String getTableName() {
        return this.qualifiedTableName;
    }

    @Override
    public void remove(Object id, SharedSessionContractImplementor session) throws HibernateException {
        if (!this.isInverse && this.isRowDeleteEnabled()) {
            if (LOG.isDebugEnabled()) {
                LOG.debugf("Deleting collection: %s", MessageHelper.collectionInfoString((CollectionPersister)this, id, this.getFactory()));
            }
            try {
                PreparedStatement st;
                int offset = 1;
                Expectation expectation = Expectations.appropriateExpectation(this.getDeleteAllCheckStyle());
                boolean callable = this.isDeleteAllCallable();
                boolean useBatch = expectation.canBeBatched();
                String sql = this.getSQLDeleteString();
                if (useBatch) {
                    if (this.removeBatchKey == null) {
                        this.removeBatchKey = new BasicBatchKey(this.getRole() + "#REMOVE", expectation);
                    }
                    st = session.getJdbcCoordinator().getBatch(this.removeBatchKey).getBatchStatement(sql, callable);
                } else {
                    st = session.getJdbcCoordinator().getStatementPreparer().prepareStatement(sql, callable);
                }
                try {
                    this.writeKey(st, id, offset += expectation.prepare(st), session);
                    if (useBatch) {
                        session.getJdbcCoordinator().getBatch(this.removeBatchKey).addToBatch();
                    } else {
                        expectation.verifyOutcome(session.getJdbcCoordinator().getResultSetReturn().executeUpdate(st), st, -1, sql);
                    }
                }
                catch (SQLException sqle) {
                    if (useBatch) {
                        session.getJdbcCoordinator().abortBatch();
                    }
                    throw sqle;
                }
                finally {
                    if (!useBatch) {
                        session.getJdbcCoordinator().getLogicalConnection().getResourceRegistry().release(st);
                        session.getJdbcCoordinator().afterStatementExecution();
                    }
                }
                LOG.debug("Done deleting collection");
            }
            catch (SQLException sqle) {
                throw this.sqlExceptionHelper.convert(sqle, "could not delete collection: " + MessageHelper.collectionInfoString((CollectionPersister)this, id, this.getFactory()), this.getSQLDeleteString());
            }
        }
    }

    @Override
    public void recreate(PersistentCollection<?> collection, Object id, SharedSessionContractImplementor session) throws HibernateException {
        block23: {
            if (this.isInverse) {
                return;
            }
            if (!this.isRowInsertEnabled()) {
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debugf("Inserting collection: %s", MessageHelper.collectionInfoString(this, collection, id, session));
            }
            try {
                Iterator<?> entries = collection.entries(this);
                JdbcCoordinator jdbcCoordinator = session.getJdbcCoordinator();
                if (entries.hasNext()) {
                    Expectation expectation = Expectations.appropriateExpectation(this.getInsertCheckStyle());
                    collection.preInsert(this);
                    int i = 0;
                    int count = 0;
                    while (entries.hasNext()) {
                        Object entry = entries.next();
                        if (collection.entryExists(entry, i)) {
                            PreparedStatement st;
                            int offset = 1;
                            boolean callable = this.isInsertCallable();
                            boolean useBatch = expectation.canBeBatched();
                            String sql = this.getSQLInsertRowString();
                            if (useBatch) {
                                if (this.recreateBatchKey == null) {
                                    this.recreateBatchKey = new BasicBatchKey(this.getRole() + "#RECREATE", expectation);
                                }
                                st = jdbcCoordinator.getBatch(this.recreateBatchKey).getBatchStatement(sql, callable);
                            } else {
                                st = jdbcCoordinator.getStatementPreparer().prepareStatement(sql, callable);
                            }
                            try {
                                int loc = this.writeKey(st, id, offset += expectation.prepare(st), session);
                                if (this.hasIdentifier) {
                                    loc = this.writeIdentifier(st, collection.getIdentifier(entry, i), loc, session);
                                }
                                if (this.hasIndex) {
                                    loc = this.writeIndex(st, collection.getIndex(entry, i, this), loc, session);
                                }
                                loc = this.writeElement(st, collection.getElement(entry), loc, session);
                                if (useBatch) {
                                    jdbcCoordinator.getBatch(this.recreateBatchKey).addToBatch();
                                } else {
                                    expectation.verifyOutcome(jdbcCoordinator.getResultSetReturn().executeUpdate(st), st, -1, sql);
                                }
                                collection.afterRowInsert(this, entry, i);
                                ++count;
                            }
                            catch (SQLException sqle) {
                                if (useBatch) {
                                    jdbcCoordinator.abortBatch();
                                }
                                throw sqle;
                            }
                            finally {
                                if (!useBatch) {
                                    jdbcCoordinator.getLogicalConnection().getResourceRegistry().release(st);
                                    jdbcCoordinator.afterStatementExecution();
                                }
                            }
                        }
                        ++i;
                    }
                    LOG.debugf("Done inserting collection: %s rows inserted", count);
                    break block23;
                }
                LOG.debug("Collection was empty");
            }
            catch (SQLException sqle) {
                throw this.sqlExceptionHelper.convert(sqle, "could not insert collection: " + MessageHelper.collectionInfoString(this, collection, id, session), this.getSQLInsertRowString());
            }
        }
    }

    protected boolean isRowDeleteEnabled() {
        return true;
    }

    @Override
    public void deleteRows(PersistentCollection<?> collection, Object id, SharedSessionContractImplementor session) throws HibernateException {
        block24: {
            if (this.isInverse) {
                return;
            }
            if (!this.isRowDeleteEnabled()) {
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debugf("Deleting rows of collection: %s", MessageHelper.collectionInfoString(this, collection, id, session));
            }
            boolean deleteByIndex = !this.isOneToMany() && this.hasIndex && !this.indexContainsFormula;
            Expectation expectation = Expectations.appropriateExpectation(this.getDeleteCheckStyle());
            try {
                Iterator<?> deletes = collection.getDeletes(this, !deleteByIndex);
                if (deletes.hasNext()) {
                    int offset = 1;
                    int count = 0;
                    while (deletes.hasNext()) {
                        PreparedStatement st;
                        boolean callable = this.isDeleteCallable();
                        boolean useBatch = expectation.canBeBatched();
                        String sql = this.getSQLDeleteRowString();
                        if (useBatch) {
                            if (this.deleteBatchKey == null) {
                                this.deleteBatchKey = new BasicBatchKey(this.getRole() + "#DELETE", expectation);
                            }
                            st = session.getJdbcCoordinator().getBatch(this.deleteBatchKey).getBatchStatement(sql, callable);
                        } else {
                            st = session.getJdbcCoordinator().getStatementPreparer().prepareStatement(sql, callable);
                        }
                        try {
                            expectation.prepare(st);
                            Object entry = deletes.next();
                            int loc = offset;
                            if (this.hasIdentifier) {
                                this.writeIdentifier(st, entry, loc, session);
                            } else {
                                loc = this.writeKey(st, id, loc, session);
                                if (deleteByIndex) {
                                    this.writeIndexToWhere(st, entry, loc, session);
                                } else {
                                    this.writeElementToWhere(st, entry, loc, session);
                                }
                            }
                            if (useBatch) {
                                session.getJdbcCoordinator().getBatch(this.deleteBatchKey).addToBatch();
                            } else {
                                expectation.verifyOutcome(session.getJdbcCoordinator().getResultSetReturn().executeUpdate(st), st, -1, sql);
                            }
                        }
                        catch (SQLException sqle) {
                            if (useBatch) {
                                session.getJdbcCoordinator().abortBatch();
                            }
                            throw sqle;
                        }
                        finally {
                            if (!useBatch) {
                                session.getJdbcCoordinator().getLogicalConnection().getResourceRegistry().release(st);
                                session.getJdbcCoordinator().afterStatementExecution();
                            }
                        }
                        LOG.debugf("Done deleting collection rows: %s deleted", ++count);
                    }
                    break block24;
                }
                LOG.debug("No rows to delete");
            }
            catch (SQLException sqle) {
                throw this.sqlExceptionHelper.convert(sqle, "could not delete collection rows: " + MessageHelper.collectionInfoString(this, collection, id, session), this.getSQLDeleteRowString());
            }
        }
    }

    protected boolean isRowInsertEnabled() {
        return true;
    }

    @Override
    public void insertRows(PersistentCollection<?> collection, Object id, SharedSessionContractImplementor session) throws HibernateException {
        if (this.isInverse) {
            return;
        }
        if (!this.isRowInsertEnabled()) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Inserting rows of collection: %s", MessageHelper.collectionInfoString(this, collection, id, session));
        }
        try {
            collection.preInsert(this);
            Iterator<?> entries = collection.entries(this);
            Expectation expectation = Expectations.appropriateExpectation(this.getInsertCheckStyle());
            boolean callable = this.isInsertCallable();
            boolean useBatch = expectation.canBeBatched();
            String sql = this.getSQLInsertRowString();
            int i = 0;
            int count = 0;
            while (entries.hasNext()) {
                int offset = 1;
                Object entry = entries.next();
                if (collection.needsInserting(entry, i, this.elementType)) {
                    PreparedStatement st;
                    if (useBatch) {
                        if (this.insertBatchKey == null) {
                            this.insertBatchKey = new BasicBatchKey(this.getRole() + "#INSERT", expectation);
                        }
                        st = session.getJdbcCoordinator().getBatch(this.insertBatchKey).getBatchStatement(sql, callable);
                    } else {
                        st = session.getJdbcCoordinator().getStatementPreparer().prepareStatement(sql, callable);
                    }
                    try {
                        offset += expectation.prepare(st);
                        offset = this.writeKey(st, id, offset, session);
                        if (this.hasIdentifier) {
                            offset = this.writeIdentifier(st, collection.getIdentifier(entry, i), offset, session);
                        }
                        if (this.hasIndex) {
                            offset = this.writeIndex(st, collection.getIndex(entry, i, this), offset, session);
                        }
                        this.writeElement(st, collection.getElement(entry), offset, session);
                        if (useBatch) {
                            session.getJdbcCoordinator().getBatch(this.insertBatchKey).addToBatch();
                        } else {
                            expectation.verifyOutcome(session.getJdbcCoordinator().getResultSetReturn().executeUpdate(st), st, -1, sql);
                        }
                        collection.afterRowInsert(this, entry, i);
                        ++count;
                    }
                    catch (SQLException sqle) {
                        if (useBatch) {
                            session.getJdbcCoordinator().abortBatch();
                        }
                        throw sqle;
                    }
                    finally {
                        if (!useBatch) {
                            session.getJdbcCoordinator().getLogicalConnection().getResourceRegistry().release(st);
                            session.getJdbcCoordinator().afterStatementExecution();
                        }
                    }
                }
                ++i;
            }
            LOG.debugf("Done inserting rows: %s inserted", count);
        }
        catch (SQLException sqle) {
            throw this.sqlExceptionHelper.convert(sqle, "could not insert collection rows: " + MessageHelper.collectionInfoString(this, collection, id, session), this.getSQLInsertRowString());
        }
    }

    @Override
    public String getRole() {
        return this.navigableRole.getFullPath();
    }

    public String getOwnerEntityName() {
        return this.entityName;
    }

    @Override
    public EntityPersister getOwnerEntityPersister() {
        return this.ownerPersister;
    }

    @Override
    public IdentifierGenerator getIdentifierGenerator() {
        return this.identifierGenerator;
    }

    @Override
    public Type getIdentifierType() {
        return this.identifierType;
    }

    @Override
    public boolean hasOrphanDelete() {
        return this.hasOrphanDelete;
    }

    @Override
    public Type toType(String propertyName) throws QueryException {
        if ("index".equals(propertyName)) {
            return this.indexType;
        }
        return this.elementPropertyMapping.toType(propertyName);
    }

    @Override
    public void applyBaseRestrictions(Consumer<Predicate> predicateConsumer, TableGroup tableGroup, boolean useQualifier, java.util.Map<String, Filter> enabledFilters, Set<String> treatAsDeclarations, SqlAstCreationState creationState) {
        this.applyFilterRestrictions(predicateConsumer, tableGroup, useQualifier, enabledFilters, creationState);
        this.applyWhereRestrictions(predicateConsumer, tableGroup, useQualifier, creationState);
    }

    @Override
    public void applyWhereRestrictions(Consumer<Predicate> predicateConsumer, TableGroup tableGroup, boolean useQualifier, SqlAstCreationState creationState) {
        TableReference tableReference = this.isManyToMany() ? tableGroup.getPrimaryTableReference() : (this.elementPersister instanceof Joinable ? tableGroup.getTableReference(tableGroup.getNavigablePath(), ((Joinable)((Object)this.elementPersister)).getTableName()) : tableGroup.getTableReference(tableGroup.getNavigablePath(), this.qualifiedTableName));
        String alias = tableReference == null ? null : (useQualifier && tableReference.getIdentificationVariable() != null ? tableReference.getIdentificationVariable() : tableReference.getTableId());
        this.applyWhereFragments(predicateConsumer, alias, tableGroup, creationState);
    }

    protected void applyWhereFragments(Consumer<Predicate> predicateConsumer, String alias, TableGroup tableGroup, SqlAstCreationState astCreationState) {
        AbstractCollectionPersister.applyWhereFragments(predicateConsumer, alias, this.sqlWhereStringTemplate);
    }

    private static void applyWhereFragments(Consumer<Predicate> predicateConsumer, String alias, String template) {
        if (template == null) {
            return;
        }
        String fragment = StringHelper.replace(template, "$PlaceHolder$", alias);
        if (StringHelper.isEmpty(fragment)) {
            return;
        }
        predicateConsumer.accept(new SqlFragmentPredicate(fragment));
    }

    @Override
    public void applyFilterRestrictions(Consumer<Predicate> predicateConsumer, TableGroup tableGroup, boolean useQualifier, java.util.Map<String, Filter> enabledFilters, SqlAstCreationState creationState) {
        if (this.filterHelper != null) {
            this.filterHelper.applyEnabledFilters(predicateConsumer, this.getFilterAliasGenerator(tableGroup), enabledFilters);
        }
    }

    @Override
    public abstract boolean isManyToMany();

    @Override
    public void applyBaseManyToManyRestrictions(Consumer<Predicate> predicateConsumer, TableGroup tableGroup, boolean useQualifier, java.util.Map<String, Filter> enabledFilters, Set<String> treatAsDeclarations, SqlAstCreationState creationState) {
        if (this.manyToManyFilterHelper == null && this.manyToManyWhereTemplate == null) {
            return;
        }
        if (this.manyToManyFilterHelper != null) {
            FilterAliasGenerator aliasGenerator = this.elementPersister.getFilterAliasGenerator(tableGroup);
            this.manyToManyFilterHelper.applyEnabledFilters(predicateConsumer, aliasGenerator, enabledFilters);
        }
        if (this.manyToManyWhereString != null) {
            TableReference tableReference = tableGroup.resolveTableReference(((Joinable)((Object)this.elementPersister)).getTableName());
            String alias = tableReference == null ? null : (useQualifier && tableReference.getIdentificationVariable() != null ? tableReference.getIdentificationVariable() : tableReference.getTableId());
            AbstractCollectionPersister.applyWhereFragments(predicateConsumer, alias, this.manyToManyWhereTemplate);
        }
    }

    @Override
    public String getManyToManyFilterFragment(TableGroup tableGroup, java.util.Map<String, Filter> enabledFilters) {
        StringBuilder fragment = new StringBuilder();
        if (this.manyToManyFilterHelper != null) {
            this.manyToManyFilterHelper.render(fragment, this.elementPersister.getFilterAliasGenerator(tableGroup), enabledFilters);
        }
        if (this.manyToManyWhereString != null) {
            if (fragment.length() > 0) {
                fragment.append(" and ");
            }
            assert (this.elementPersister instanceof Joinable);
            TableReference tableReference = tableGroup.resolveTableReference(((Joinable)((Object)this.elementPersister)).getTableName());
            fragment.append(StringHelper.replace(this.manyToManyWhereTemplate, "$PlaceHolder$", tableReference.getIdentificationVariable()));
        }
        return fragment.toString();
    }

    @Override
    public String[] toColumns(String propertyName) throws QueryException {
        if ("index".equals(propertyName)) {
            if (this.indexFragments == null) {
                String[] tmp = new String[this.indexColumnNames.length];
                for (int i = 0; i < this.indexColumnNames.length; ++i) {
                    tmp[i] = this.indexColumnNames[i] == null ? this.indexFormulas[i] : this.indexColumnNames[i];
                    this.indexFragments = tmp;
                }
            }
            return this.indexFragments;
        }
        return this.elementPropertyMapping.toColumns(propertyName);
    }

    @Override
    public String getName() {
        return this.getRole();
    }

    @Override
    public EntityPersister getElementPersister() {
        if (this.elementPersister == null) {
            throw new AssertionFailure("not an association");
        }
        return this.elementPersister;
    }

    protected EntityPersister getElementPersisterInternal() {
        return this.elementPersister;
    }

    @Override
    public boolean isCollection() {
        return true;
    }

    @Override
    public Serializable[] getCollectionSpaces() {
        return this.spaces;
    }

    protected abstract String generateDeleteString();

    protected abstract String generateDeleteRowString();

    protected abstract String generateUpdateRowString();

    protected abstract String generateInsertRowString();

    @Override
    public void updateRows(PersistentCollection<?> collection, Object id, SharedSessionContractImplementor session) throws HibernateException {
        if (!this.isInverse && collection.isRowUpdatePossible()) {
            LOG.debugf("Updating rows of collection: %s#%s", this.navigableRole.getFullPath(), id);
            int count = this.doUpdateRows(id, collection, session);
            LOG.debugf("Done updating rows: %s updated", count);
        }
    }

    protected abstract int doUpdateRows(Object var1, PersistentCollection<?> var2, SharedSessionContractImplementor var3);

    @Override
    public void processQueuedOps(PersistentCollection<?> collection, Object key, SharedSessionContractImplementor session) {
        if (collection.hasQueuedOperations()) {
            this.doProcessQueuedOps(collection, key, session);
        }
    }

    protected abstract void doProcessQueuedOps(PersistentCollection<?> var1, Object var2, SharedSessionContractImplementor var3) throws HibernateException;

    @Override
    @Deprecated
    public CollectionMetadata getCollectionMetadata() {
        return this;
    }

    @Override
    public SessionFactoryImplementor getFactory() {
        return this.factory;
    }

    protected boolean isInsertCallable() {
        return this.insertCallable;
    }

    protected ExecuteUpdateResultCheckStyle getInsertCheckStyle() {
        return this.insertCheckStyle;
    }

    protected boolean isUpdateCallable() {
        return this.updateCallable;
    }

    protected ExecuteUpdateResultCheckStyle getUpdateCheckStyle() {
        return this.updateCheckStyle;
    }

    protected boolean isDeleteCallable() {
        return this.deleteCallable;
    }

    protected ExecuteUpdateResultCheckStyle getDeleteCheckStyle() {
        return this.deleteCheckStyle;
    }

    protected boolean isDeleteAllCallable() {
        return this.deleteAllCallable;
    }

    protected ExecuteUpdateResultCheckStyle getDeleteAllCheckStyle() {
        return this.deleteAllCheckStyle;
    }

    public String toString() {
        return StringHelper.unqualify(this.getClass().getName()) + "(" + this.navigableRole.getFullPath() + ")";
    }

    @Override
    public boolean isVersioned() {
        return this.isVersioned && this.getOwnerEntityPersister().isVersioned();
    }

    protected SQLExceptionConverter getSQLExceptionConverter() {
        return this.getSQLExceptionHelper().getSqlExceptionConverter();
    }

    protected SqlExceptionHelper getSQLExceptionHelper() {
        return this.sqlExceptionHelper;
    }

    @Override
    public CacheEntryStructure getCacheEntryStructure() {
        return this.cacheEntryStructure;
    }

    @Override
    public boolean isAffectedByEnabledFilters(SharedSessionContractImplementor session) {
        return this.isAffectedByEnabledFilters(session.getLoadQueryInfluencers());
    }

    public boolean isSubselectLoadable() {
        return this.subselectLoadable;
    }

    @Override
    public boolean isMutable() {
        return this.isMutable;
    }

    @Override
    public String[] getCollectionPropertyColumnAliases(String propertyName, String suffix) {
        String[] rawAliases = this.collectionPropertyColumnAliases.get(propertyName);
        if (rawAliases == null) {
            return null;
        }
        String[] result = new String[rawAliases.length];
        Alias alias = new Alias(suffix);
        for (int i = 0; i < rawAliases.length; ++i) {
            result[i] = alias.toUnquotedAliasString(rawAliases[i]);
        }
        return result;
    }

    public void initCollectionPropertyMap() {
        this.initCollectionPropertyMap("key", this.keyType, this.keyColumnAliases);
        this.initCollectionPropertyMap("element", this.elementType, this.elementColumnAliases);
        if (this.hasIndex) {
            this.initCollectionPropertyMap("index", this.indexType, this.indexColumnAliases);
        }
        if (this.hasIdentifier) {
            this.initCollectionPropertyMap("id", this.identifierType, new String[]{this.identifierColumnAlias});
        }
    }

    private void initCollectionPropertyMap(String aliasName, Type type, String[] columnAliases) {
        this.collectionPropertyColumnAliases.put(aliasName, columnAliases);
        if (type.isComponentType()) {
            CompositeType ct = (CompositeType)type;
            String[] propertyNames = ct.getPropertyNames();
            for (int i = 0; i < propertyNames.length; ++i) {
                String name = propertyNames[i];
                this.collectionPropertyColumnAliases.put(aliasName + "." + name, new String[]{columnAliases[i]});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getSize(Object key, SharedSessionContractImplementor session) {
        try {
            JdbcCoordinator jdbcCoordinator = session.getJdbcCoordinator();
            PreparedStatement st = jdbcCoordinator.getStatementPreparer().prepareStatement(this.sqlSelectSizeString);
            try {
                this.getKeyType().nullSafeSet(st, key, 1, session);
                ResultSet rs = jdbcCoordinator.getResultSetReturn().extract(st);
                try {
                    int n = rs.next() ? rs.getInt(1) - this.baseIndex : 0;
                    jdbcCoordinator.getLogicalConnection().getResourceRegistry().release(rs, st);
                    return n;
                }
                catch (Throwable throwable) {
                    jdbcCoordinator.getLogicalConnection().getResourceRegistry().release(rs, st);
                    throw throwable;
                }
            }
            finally {
                jdbcCoordinator.getLogicalConnection().getResourceRegistry().release(st);
                jdbcCoordinator.afterStatementExecution();
            }
        }
        catch (SQLException sqle) {
            throw this.getSQLExceptionHelper().convert(sqle, "could not retrieve collection size: " + MessageHelper.collectionInfoString((CollectionPersister)this, key, this.getFactory()), this.sqlSelectSizeString);
        }
    }

    @Override
    public boolean indexExists(Object key, Object index, SharedSessionContractImplementor session) {
        return this.exists(key, this.incrementIndexByBase(index), this.getIndexType(), this.sqlDetectRowByIndexString, session);
    }

    @Override
    public boolean elementExists(Object key, Object element, SharedSessionContractImplementor session) {
        return this.exists(key, element, this.getElementType(), this.sqlDetectRowByElementString, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean exists(Object key, Object indexOrElement, Type indexOrElementType, String sql, SharedSessionContractImplementor session) {
        JdbcCoordinator jdbcCoordinator = session.getJdbcCoordinator();
        PreparedStatement st = jdbcCoordinator.getStatementPreparer().prepareStatement(sql);
        this.getKeyType().nullSafeSet(st, key, 1, session);
        indexOrElementType.nullSafeSet(st, indexOrElement, this.keyColumnNames.length + 1, session);
        ResultSet rs = jdbcCoordinator.getResultSetReturn().extract(st);
        try {
            boolean bl = rs.next();
            jdbcCoordinator.getLogicalConnection().getResourceRegistry().release(rs, st);
            jdbcCoordinator.getLogicalConnection().getResourceRegistry().release(st);
            jdbcCoordinator.afterStatementExecution();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                try {
                    jdbcCoordinator.getLogicalConnection().getResourceRegistry().release(rs, st);
                    throw throwable;
                }
                catch (TransientObjectException e) {
                    boolean bl = false;
                    jdbcCoordinator.getLogicalConnection().getResourceRegistry().release(st);
                    jdbcCoordinator.afterStatementExecution();
                    return bl;
                }
            }
            catch (Throwable throwable2) {
                try {
                    jdbcCoordinator.getLogicalConnection().getResourceRegistry().release(st);
                    jdbcCoordinator.afterStatementExecution();
                    throw throwable2;
                }
                catch (SQLException sqle) {
                    throw this.getSQLExceptionHelper().convert(sqle, "could not check row existence: " + MessageHelper.collectionInfoString((CollectionPersister)this, key, this.getFactory()), this.sqlSelectSizeString);
                }
            }
        }
    }

    @Override
    public Object getElementByIndex(Object key, Object index, SharedSessionContractImplementor session, Object owner) {
        return this.collectionElementLoaderByIndex.load(key, index, session);
    }

    @Override
    public boolean isExtraLazy() {
        return this.isExtraLazy;
    }

    protected Dialect getDialect() {
        return this.dialect;
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    @Override
    public String getMappedByProperty() {
        return this.mappedByProperty;
    }

    public abstract FilterAliasGenerator getFilterAliasGenerator(String var1);

    public abstract FilterAliasGenerator getFilterAliasGenerator(TableGroup var1);

    @Override
    public void injectAttributeMapping(PluralAttributeMapping attributeMapping) {
        this.attributeMapping = attributeMapping;
    }

    @Override
    public PluralAttributeMapping getAttributeMapping() {
        return this.attributeMapping;
    }

    @Override
    public boolean isAffectedByEnabledFilters(LoadQueryInfluencers influencers) {
        if (influencers.hasEnabledFilters()) {
            java.util.Map<String, Filter> enabledFilters = influencers.getEnabledFilters();
            return this.filterHelper != null && this.filterHelper.isAffectedBy(enabledFilters) || this.manyToManyFilterHelper != null && this.manyToManyFilterHelper.isAffectedBy(enabledFilters);
        }
        return false;
    }

    @Override
    public boolean isAffectedByEntityGraph(LoadQueryInfluencers influencers) {
        return false;
    }

    @Override
    public boolean isAffectedByEnabledFetchProfiles(LoadQueryInfluencers influencers) {
        if (influencers.hasEnabledFetchProfiles()) {
            for (String enabledFetchProfileName : influencers.getEnabledFetchProfileNames()) {
                FetchProfile fetchProfile = this.getFactory().getFetchProfile(enabledFetchProfileName);
                Fetch fetch = fetchProfile.getFetchByRole(this.getRole());
                if (fetch == null || fetch.getStyle() != Fetch.Style.JOIN) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public CollectionSemantics<?, ?> getCollectionSemantics() {
        return this.collectionSemantics;
    }

    protected Insert createInsert() {
        return new Insert(this.getFactory().getJdbcServices().getDialect());
    }

    protected Update createUpdate() {
        return new Update(this.getFactory().getJdbcServices().getDialect());
    }

    protected Delete createDelete() {
        return new Delete();
    }
}

