/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.sql.internal;

import java.util.ArrayList;
import org.hibernate.metamodel.mapping.DiscriminatedAssociationModelPart;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.internal.AnyDiscriminatorPart;
import org.hibernate.metamodel.model.domain.internal.AnyDiscriminatorSqmPath;
import org.hibernate.query.criteria.JpaPath;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.sql.internal.AbstractSqmPathInterpretation;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;

public class DiscriminatedAssociationTypePathInterpretation<T>
extends AbstractSqmPathInterpretation<T> {
    private final Expression expression;

    public static <T> DiscriminatedAssociationTypePathInterpretation<T> from(AnyDiscriminatorSqmPath sqmPath, SqmToSqlAstConverter converter) {
        DiscriminatedAssociationModelPart mapping;
        JpaPath lhs = sqmPath.getLhs();
        TableGroup tableGroup = converter.getFromClauseAccess().findTableGroup(lhs.getLhs().getNavigablePath());
        ModelPart subPart = tableGroup.getModelPart().findSubPart(lhs.getNavigablePath().getLocalName(), null);
        if (subPart instanceof PluralAttributeMapping) {
            PluralAttributeMapping pluralAttributeMapping = (PluralAttributeMapping)subPart;
            mapping = (DiscriminatedAssociationModelPart)((Object)pluralAttributeMapping.getElementDescriptor());
        } else {
            mapping = (DiscriminatedAssociationModelPart)subPart;
        }
        ArrayList tupleExpressions = new ArrayList();
        mapping.forEachSelectable((selectionIndex, selectableMapping) -> {
            if (selectableMapping instanceof AnyDiscriminatorPart) {
                TableReference tableReference = tableGroup.getPrimaryTableReference();
                Expression expression = converter.getSqlExpressionResolver().resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, selectableMapping.getSelectionExpression()), processingState -> new ColumnReference(tableReference, selectableMapping, converter.getCreationContext().getSessionFactory()));
                tupleExpressions.add(expression);
            }
        });
        assert (tupleExpressions.size() == 1);
        return new DiscriminatedAssociationTypePathInterpretation<T>(sqmPath.getNavigablePath(), mapping, tableGroup, (Expression)tupleExpressions.get(0));
    }

    public DiscriminatedAssociationTypePathInterpretation(NavigablePath navigablePath, ModelPart mapping, TableGroup tableGroup, Expression expression) {
        super(navigablePath, mapping, tableGroup);
        this.expression = expression;
    }

    @Override
    public void accept(SqlAstWalker sqlTreeWalker) {
        this.expression.accept(sqlTreeWalker);
    }
}

