/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.jackson;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.hibernate.type.FormatMapper;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;

public final class JacksonJsonFormatMapper
implements FormatMapper {
    public static final String SHORT_NAME = "jackson";
    private final ObjectMapper objectMapper;

    public JacksonJsonFormatMapper() {
        this(new ObjectMapper());
    }

    public JacksonJsonFormatMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public <T> T fromString(CharSequence charSequence, JavaType<T> javaType, WrapperOptions wrapperOptions) {
        try {
            return (T)this.objectMapper.readValue(charSequence.toString(), this.objectMapper.constructType(javaType.getJavaType()));
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Could not deserialize string to java type: " + javaType, e);
        }
    }

    @Override
    public <T> String toString(T value, JavaType<T> javaType, WrapperOptions wrapperOptions) {
        try {
            return this.objectMapper.writerFor(this.objectMapper.constructType(javaType.getJavaType())).writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Could not serialize object of java type: " + javaType, e);
        }
    }
}

