/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.jakartajson;

import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import jakarta.json.bind.JsonbException;
import org.hibernate.type.FormatMapper;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;

public final class JsonBJsonFormatMapper
implements FormatMapper {
    public static final String SHORT_NAME = "jsonb";
    private final Jsonb jsonb;

    public JsonBJsonFormatMapper() {
        this(JsonbBuilder.create());
    }

    public JsonBJsonFormatMapper(Jsonb jsonb) {
        this.jsonb = jsonb;
    }

    @Override
    public <T> T fromString(CharSequence charSequence, JavaType<T> javaType, WrapperOptions wrapperOptions) {
        try {
            return (T)this.jsonb.fromJson(charSequence.toString(), javaType.getJavaType());
        }
        catch (JsonbException e) {
            throw new IllegalArgumentException("Could not deserialize string to java type: " + javaType, e);
        }
    }

    @Override
    public <T> String toString(T value, JavaType<T> javaType, WrapperOptions wrapperOptions) {
        try {
            return this.jsonb.toJson(value, javaType.getJavaType());
        }
        catch (JsonbException e) {
            throw new IllegalArgumentException("Could not serialize object of java type: " + javaType, e);
        }
    }
}

