/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.jaxb;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.JAXBIntrospector;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.annotation.XmlAnyElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.type.FormatMapper;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.BasicPluralJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.spi.UnknownBasicJavaType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class JaxbXmlFormatMapper
implements FormatMapper {
    public static final String SHORT_NAME = "jaxb";

    @Override
    public <T> T fromString(CharSequence charSequence, JavaType<T> javaType, WrapperOptions wrapperOptions) {
        try {
            if (Map.class.isAssignableFrom(javaType.getJavaTypeClass())) {
                JAXBElementTransformer valueTransformer;
                JAXBElementTransformer keyTransformer;
                JAXBContext context;
                Class valueClass;
                Class keyClass;
                if (javaType.getJavaType() instanceof ParameterizedType) {
                    Type[] typeArguments = ((ParameterizedType)javaType.getJavaType()).getActualTypeArguments();
                    keyClass = ReflectHelper.getClass(typeArguments[0]);
                    valueClass = ReflectHelper.getClass(typeArguments[1]);
                    context = JAXBContext.newInstance((Class[])new Class[]{MapWrapper.class, keyClass, valueClass});
                } else {
                    keyClass = Object.class;
                    valueClass = Object.class;
                    context = JAXBContext.newInstance((Class[])new Class[]{MapWrapper.class});
                }
                Unmarshaller unmarshaller = context.createUnmarshaller();
                MapWrapper mapWrapper = (MapWrapper)unmarshaller.unmarshal((Reader)new StringReader(charSequence.toString()));
                Collection<Object> elements = mapWrapper.elements;
                LinkedHashMap<Object, Object> map = CollectionHelper.linkedMapOfSize(elements.size() >> 1);
                JAXBIntrospector jaxbIntrospector = context.createJAXBIntrospector();
                if (javaType instanceof BasicPluralJavaType) {
                    keyTransformer = this.createTransformer(keyClass, "key", null, jaxbIntrospector, wrapperOptions);
                    valueTransformer = this.createTransformer(((BasicPluralJavaType)((Object)javaType)).getElementJavaType(), "value", null, jaxbIntrospector, wrapperOptions);
                } else {
                    keyTransformer = this.createTransformer(keyClass, "key", null, jaxbIntrospector, wrapperOptions);
                    valueTransformer = this.createTransformer(valueClass, "value", null, jaxbIntrospector, wrapperOptions);
                }
                Iterator<Object> iterator = elements.iterator();
                while (iterator.hasNext()) {
                    Object key = keyTransformer.fromJAXBElement(iterator.next(), unmarshaller);
                    Object value = valueTransformer.fromJAXBElement(iterator.next(), unmarshaller);
                    map.put(key, value);
                }
                return javaType.wrap(map, wrapperOptions);
            }
            if (Collection.class.isAssignableFrom(javaType.getJavaTypeClass())) {
                JAXBContext context;
                Class valueClass;
                if (javaType.getJavaType() instanceof ParameterizedType) {
                    Type[] typeArguments = ((ParameterizedType)javaType.getJavaType()).getActualTypeArguments();
                    valueClass = ReflectHelper.getClass(typeArguments[0]);
                    context = JAXBContext.newInstance((Class[])new Class[]{CollectionWrapper.class, valueClass});
                } else {
                    valueClass = Object.class;
                    context = JAXBContext.newInstance((Class[])new Class[]{CollectionWrapper.class});
                }
                Unmarshaller unmarshaller = context.createUnmarshaller();
                CollectionWrapper collectionWrapper = (CollectionWrapper)unmarshaller.unmarshal((Reader)new StringReader(charSequence.toString()));
                Collection<Object> elements = collectionWrapper.elements;
                ArrayList<Object> collection = new ArrayList<Object>(elements.size());
                JAXBIntrospector jaxbIntrospector = context.createJAXBIntrospector();
                JAXBElementTransformer valueTransformer = javaType instanceof BasicPluralJavaType ? this.createTransformer(((BasicPluralJavaType)((Object)javaType)).getElementJavaType(), "value", null, jaxbIntrospector, wrapperOptions) : this.createTransformer(valueClass, "value", null, jaxbIntrospector, wrapperOptions);
                for (Object element : elements) {
                    Object value = valueTransformer.fromJAXBElement(element, unmarshaller);
                    collection.add(value);
                }
                return javaType.wrap(collection, wrapperOptions);
            }
            if (javaType.getJavaTypeClass().isArray()) {
                Class<?> valueClass = javaType.getJavaTypeClass().getComponentType();
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{CollectionWrapper.class, valueClass});
                Unmarshaller unmarshaller = context.createUnmarshaller();
                CollectionWrapper collectionWrapper = (CollectionWrapper)unmarshaller.unmarshal((Reader)new StringReader(charSequence.toString()));
                Collection<Object> elements = collectionWrapper.elements;
                JAXBIntrospector jaxbIntrospector = context.createJAXBIntrospector();
                JAXBElementTransformer valueTransformer = javaType instanceof BasicPluralJavaType ? this.createTransformer(((BasicPluralJavaType)((Object)javaType)).getElementJavaType(), "value", null, jaxbIntrospector, wrapperOptions) : this.createTransformer(valueClass, "value", null, jaxbIntrospector, wrapperOptions);
                int length = elements.size();
                if (Object[].class.isAssignableFrom(javaType.getJavaTypeClass())) {
                    Object[] array = (Object[])Array.newInstance(valueClass, length);
                    int i = 0;
                    for (Object element : elements) {
                        Object value;
                        array[i] = value = valueTransformer.fromJAXBElement(element, unmarshaller);
                        ++i;
                    }
                    return (T)array;
                }
                Object array = Array.newInstance(valueClass, length);
                int i = 0;
                for (Object element : elements) {
                    Object value = valueTransformer.fromJAXBElement(element, unmarshaller);
                    Array.set(array, i, value);
                    ++i;
                }
                return (T)array;
            }
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{javaType.getJavaTypeClass()});
            return (T)context.createUnmarshaller().unmarshal((Reader)new StringReader(charSequence.toString()));
        }
        catch (JAXBException e) {
            throw new IllegalArgumentException("Could not deserialize string to java type: " + javaType, e);
        }
    }

    @Override
    public <T> String toString(T value, JavaType<T> javaType, WrapperOptions wrapperOptions) {
        try {
            StringWriter stringWriter = new StringWriter();
            if (Map.class.isAssignableFrom(javaType.getJavaTypeClass())) {
                JAXBContext context;
                Class valueClass;
                Class keyClass;
                MapWrapper mapWrapper = new MapWrapper();
                Map map = (Map)value;
                if (javaType.getJavaType() instanceof ParameterizedType) {
                    Type[] typeArguments = ((ParameterizedType)javaType.getJavaType()).getActualTypeArguments();
                    keyClass = ReflectHelper.getClass(typeArguments[0]);
                    valueClass = ReflectHelper.getClass(typeArguments[1]);
                    context = JAXBContext.newInstance((Class[])new Class[]{MapWrapper.class, keyClass, valueClass});
                } else if (map.isEmpty()) {
                    keyClass = Object.class;
                    valueClass = Object.class;
                    context = JAXBContext.newInstance((Class[])new Class[]{MapWrapper.class});
                } else {
                    Map.Entry firstEntry = map.entrySet().iterator().next();
                    keyClass = firstEntry.getKey().getClass();
                    valueClass = firstEntry.getValue().getClass();
                    context = JAXBContext.newInstance((Class[])new Class[]{MapWrapper.class, keyClass, valueClass});
                }
                if (!map.isEmpty()) {
                    Object exampleKey = null;
                    Object exampleValue = null;
                    for (Map.Entry entry : map.entrySet()) {
                        Object mapKey = entry.getKey();
                        Object mapValue = entry.getValue();
                        if (exampleKey == null && mapKey != null) {
                            exampleKey = mapKey;
                            if (exampleValue != null) break;
                        }
                        if (exampleValue != null || mapValue == null) continue;
                        exampleValue = mapValue;
                        if (exampleKey == null) continue;
                        break;
                    }
                    JAXBIntrospector jaxbIntrospector = context.createJAXBIntrospector();
                    JAXBElementTransformer keyTransformer = this.createTransformer(keyClass, "key", exampleKey, jaxbIntrospector, wrapperOptions);
                    JAXBElementTransformer valueTransformer = this.createTransformer(valueClass, "value", exampleValue, jaxbIntrospector, wrapperOptions);
                    for (Map.Entry entry : map.entrySet()) {
                        mapWrapper.elements.add(keyTransformer.toJAXBElement(entry.getKey()));
                        mapWrapper.elements.add(valueTransformer.toJAXBElement(entry.getValue()));
                    }
                }
                this.createMarshaller(context).marshal((Object)mapWrapper, (Writer)stringWriter);
            } else if (Collection.class.isAssignableFrom(javaType.getJavaTypeClass())) {
                CollectionWrapper collectionWrapper;
                JAXBContext context;
                Class valueClass;
                Collection collection = (Collection)value;
                if (javaType.getJavaType() instanceof ParameterizedType) {
                    Type[] typeArguments = ((ParameterizedType)javaType.getJavaType()).getActualTypeArguments();
                    valueClass = ReflectHelper.getClass(typeArguments[0]);
                    context = JAXBContext.newInstance((Class[])new Class[]{CollectionWrapper.class, valueClass});
                } else if (collection.isEmpty()) {
                    valueClass = Object.class;
                    context = JAXBContext.newInstance((Class[])new Class[]{CollectionWrapper.class});
                } else {
                    valueClass = collection.iterator().next().getClass();
                    context = JAXBContext.newInstance((Class[])new Class[]{CollectionWrapper.class, valueClass});
                }
                if (collection.isEmpty()) {
                    collectionWrapper = new CollectionWrapper();
                } else {
                    collectionWrapper = new CollectionWrapper(new ArrayList<Object>(collection.size()));
                    Object exampleValue = null;
                    for (Object o : collection) {
                        if (o == null) continue;
                        exampleValue = o;
                        break;
                    }
                    JAXBElementTransformer valueTransformer = javaType instanceof BasicPluralJavaType ? this.createTransformer(((BasicPluralJavaType)((Object)javaType)).getElementJavaType(), "value", exampleValue, context.createJAXBIntrospector(), wrapperOptions) : this.createTransformer(valueClass, "value", exampleValue, context.createJAXBIntrospector(), wrapperOptions);
                    for (Object o : collection) {
                        collectionWrapper.elements.add(valueTransformer.toJAXBElement(o));
                    }
                }
                this.createMarshaller(context).marshal((Object)collectionWrapper, (Writer)stringWriter);
            } else if (javaType.getJavaTypeClass().isArray()) {
                CollectionWrapper collectionWrapper;
                Class<?> valueClass = javaType.getJavaTypeClass().getComponentType();
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{CollectionWrapper.class, valueClass});
                if (Object[].class.isAssignableFrom(javaType.getJavaTypeClass())) {
                    Object[] array = (Object[])value;
                    ArrayList<Object> list = new ArrayList<Object>(array.length);
                    Object exampleElement = null;
                    for (Object o : array) {
                        if (o == null) continue;
                        exampleElement = o;
                        break;
                    }
                    JAXBElementTransformer transformer = javaType instanceof BasicPluralJavaType ? this.createTransformer(((BasicPluralJavaType)((Object)javaType)).getElementJavaType(), "value", exampleElement, context.createJAXBIntrospector(), wrapperOptions) : this.createTransformer(valueClass, "value", exampleElement, context.createJAXBIntrospector(), wrapperOptions);
                    for (Object o : array) {
                        list.add(transformer.toJAXBElement(o));
                    }
                    collectionWrapper = new CollectionWrapper(list);
                } else {
                    int length = Array.getLength(value);
                    ArrayList<Object> list = new ArrayList<Object>(length);
                    JavaTypeJAXBElementTransformer transformer = new JavaTypeJAXBElementTransformer(((BasicPluralJavaType)((Object)javaType)).getElementJavaType(), "value");
                    for (int i = 0; i < length; ++i) {
                        list.add(transformer.toJAXBElement(Array.get(value, i)));
                    }
                    collectionWrapper = new CollectionWrapper(list);
                }
                this.createMarshaller(context).marshal((Object)collectionWrapper, (Writer)stringWriter);
            } else {
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{javaType.getJavaTypeClass()});
                this.createMarshaller(context).marshal(value, (Writer)stringWriter);
            }
            return stringWriter.toString();
        }
        catch (JAXBException e) {
            throw new IllegalArgumentException("Could not serialize object of java type: " + javaType, e);
        }
    }

    private JAXBElementTransformer createTransformer(Class<?> elementClass, String tagName, Object exampleElement, JAXBIntrospector introspector, WrapperOptions wrapperOptions) {
        QName elementName;
        JavaType elementJavaType = wrapperOptions.getSessionFactory().getTypeConfiguration().getJavaTypeRegistry().findDescriptor(elementClass);
        if (exampleElement == null && (elementJavaType == null || elementJavaType instanceof UnknownBasicJavaType)) {
            try {
                Constructor<?> declaredConstructor = elementClass.getDeclaredConstructor(new Class[0]);
                exampleElement = declaredConstructor.newInstance(new Object[0]);
            }
            catch (Exception declaredConstructor) {
                // empty catch block
            }
        }
        QName qName = elementName = exampleElement == null ? null : introspector.getElementName(exampleElement);
        if (elementName == null && elementClass != String.class && elementJavaType != null) {
            return this.createTransformer(elementJavaType, tagName, exampleElement, introspector, wrapperOptions);
        }
        return new SimpleJAXBElementTransformer(elementClass, tagName);
    }

    private JAXBElementTransformer createTransformer(JavaType<?> elementJavaType, String tagName, Object exampleElement, JAXBIntrospector introspector, WrapperOptions wrapperOptions) {
        QName elementName;
        if (exampleElement == null && elementJavaType instanceof UnknownBasicJavaType) {
            try {
                Constructor<?> declaredConstructor = elementJavaType.getJavaTypeClass().getDeclaredConstructor(new Class[0]);
                exampleElement = declaredConstructor.newInstance(new Object[0]);
            }
            catch (Exception declaredConstructor) {
                // empty catch block
            }
        }
        QName qName = elementName = exampleElement == null ? null : introspector.getElementName(exampleElement);
        if (elementName == null && elementJavaType.getJavaTypeClass() != String.class) {
            return new JavaTypeJAXBElementTransformer(elementJavaType, tagName);
        }
        return new SimpleJAXBElementTransformer(elementJavaType.getJavaTypeClass(), tagName);
    }

    private Marshaller createMarshaller(JAXBContext context) throws JAXBException {
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.fragment", (Object)true);
        return marshaller;
    }

    private static class JavaTypeJAXBElementTransformer
    implements JAXBElementTransformer {
        private final JavaType<Object> elementJavaType;
        private final QName tagName;

        public JavaTypeJAXBElementTransformer(JavaType<?> elementJavaType, String tagName) {
            this.elementJavaType = elementJavaType;
            this.tagName = new QName(tagName);
        }

        @Override
        public JAXBElement<?> toJAXBElement(Object o) {
            return new JAXBElement(this.tagName, String.class, o == null ? null : this.elementJavaType.toString(o));
        }

        @Override
        public Object fromJAXBElement(Object element, Unmarshaller unmarshaller) throws JAXBException {
            String value = (String)unmarshaller.unmarshal((Node)element, String.class).getValue();
            return value == null ? null : this.elementJavaType.fromString(value);
        }
    }

    private static class SimpleJAXBElementTransformer
    implements JAXBElementTransformer {
        private final Class<Object> elementClass;
        private final QName tagName;

        public SimpleJAXBElementTransformer(Class<?> elementClass, String tagName) {
            this.elementClass = elementClass;
            this.tagName = new QName(tagName);
        }

        @Override
        public JAXBElement<?> toJAXBElement(Object o) {
            return new JAXBElement(this.tagName, this.elementClass, o);
        }

        @Override
        public Object fromJAXBElement(Object element, Unmarshaller unmarshaller) throws JAXBException {
            Object valueElement = unmarshaller.unmarshal((Node)element, this.elementClass).getValue();
            Object value = valueElement instanceof Element ? ((Element)valueElement).getFirstChild().getTextContent() : valueElement;
            return value;
        }
    }

    private static interface JAXBElementTransformer {
        public JAXBElement<?> toJAXBElement(Object var1);

        public Object fromJAXBElement(Object var1, Unmarshaller var2) throws JAXBException;
    }

    @XmlRootElement(name="Collection")
    public static class CollectionWrapper {
        @XmlAnyElement
        Collection<Object> elements;

        public CollectionWrapper() {
            this.elements = new ArrayList<Object>();
        }

        public CollectionWrapper(Collection<Object> elements) {
            this.elements = elements;
        }
    }

    @XmlRootElement(name="Map")
    public static class MapWrapper {
        @XmlAnyElement
        Collection<Object> elements;

        public MapWrapper() {
            this.elements = new ArrayList<Object>();
        }

        public MapWrapper(Collection<Object> elements) {
            this.elements = elements;
        }
    }
}

