/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import jakarta.persistence.TemporalType;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import org.hibernate.LockOptions;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.RowLockStrategy;
import org.hibernate.dialect.SybaseASESqlAstTranslator;
import org.hibernate.dialect.SybaseDialect;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.TopLimitHandler;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.exception.LockTimeoutException;
import org.hibernate.exception.spi.SQLExceptionConversionDelegate;
import org.hibernate.exception.spi.TemplatedViolatedConstraintNameExtractor;
import org.hibernate.exception.spi.ViolatedConstraintNameExtractor;
import org.hibernate.internal.util.JdbcExceptionHelper;
import org.hibernate.query.sqm.IntervalType;
import org.hibernate.query.sqm.TemporalUnit;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.sql.ForUpdateFragment;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.TimestampJdbcType;
import org.hibernate.type.descriptor.jdbc.TinyIntJdbcType;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;
import org.hibernate.type.descriptor.sql.internal.CapacityDependentDdlType;
import org.hibernate.type.descriptor.sql.spi.DdlTypeRegistry;

public class SybaseASEDialect
extends SybaseDialect {
    private final Dialect.SizeStrategy sizeStrategy = new Dialect.SizeStrategyImpl(){

        @Override
        public Size resolveSize(JdbcType jdbcType, JavaType<?> javaType, Integer precision, Integer scale, Long length) {
            switch (jdbcType.getDefaultSqlTypeCode()) {
                case 6: {
                    if (precision == null) break;
                    return Size.precision(Math.min(Math.max(precision, 1), 48));
                }
            }
            return super.resolveSize(jdbcType, javaType, precision, scale, length);
        }
    };
    private final boolean ansiNull;
    private static final ViolatedConstraintNameExtractor EXTRACTOR = new TemplatedViolatedConstraintNameExtractor(sqle -> {
        int errorCode = JdbcExceptionHelper.extractErrorCode(sqle);
        switch (JdbcExceptionHelper.extractSqlState(sqle)) {
            case "S1000": {
                if (2601 != errorCode) break;
                return TemplatedViolatedConstraintNameExtractor.extractUsingTemplate("with unique index '", "'", sqle.getMessage());
            }
            case "23000": {
                if (546 != errorCode) break;
                return TemplatedViolatedConstraintNameExtractor.extractUsingTemplate("constraint name = '", "'", sqle.getMessage());
            }
            default: {
                return null;
            }
        }
        return null;
    });

    public SybaseASEDialect() {
        this(DatabaseVersion.make(11));
    }

    public SybaseASEDialect(DatabaseVersion version) {
        super(version);
        this.ansiNull = false;
    }

    public SybaseASEDialect(DialectResolutionInfo info) {
        super(info);
        this.ansiNull = SybaseASEDialect.isAnsiNull(info.getDatabaseMetadata());
    }

    @Override
    protected String columnType(int sqlTypeCode) {
        switch (sqlTypeCode) {
            case 16: {
                return "tinyint";
            }
            case -5: {
                return this.getVersion().isBefore(15) ? "numeric(19,0)" : super.columnType(sqlTypeCode);
            }
            case 91: {
                return this.getVersion().isSameOrAfter(12) ? "date" : super.columnType(sqlTypeCode);
            }
            case 92: {
                return this.getVersion().isSameOrAfter(12) ? "time" : super.columnType(sqlTypeCode);
            }
        }
        return super.columnType(sqlTypeCode);
    }

    @Override
    protected void registerColumnTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.registerColumnTypes(typeContributions, serviceRegistry);
        DdlTypeRegistry ddlTypeRegistry = typeContributions.getTypeConfiguration().getDdlTypeRegistry();
        if (this.getVersion().isSameOrAfter(15, 5) && !this.jtdsDriver) {
            ddlTypeRegistry.addDescriptor(CapacityDependentDdlType.builder(91, "bigdatetime", "bigdatetime", this).withTypeCapacity(3L, "datetime").build());
            ddlTypeRegistry.addDescriptor(CapacityDependentDdlType.builder(92, "bigdatetime", "bigdatetime", this).withTypeCapacity(3L, "datetime").build());
            ddlTypeRegistry.addDescriptor(CapacityDependentDdlType.builder(93, "bigdatetime", "bigdatetime", this).withTypeCapacity(3L, "datetime").build());
            ddlTypeRegistry.addDescriptor(CapacityDependentDdlType.builder(2014, "bigdatetime", "bigdatetime", this).withTypeCapacity(3L, "datetime").build());
        }
    }

    @Override
    public int getMaxVarcharLength() {
        return 16384;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isAnsiNull(DatabaseMetaData databaseMetaData) {
        if (databaseMetaData == null) return false;
        try (Statement s = databaseMetaData.getConnection().createStatement();){
            ResultSet rs = s.executeQuery("SELECT @@options");
            if (!rs.next()) return false;
            byte[] optionBytes = rs.getBytes(1);
            boolean bl = (optionBytes[4] & 2) == 2;
            return bl;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean isAnsiNullOn() {
        return this.ansiNull;
    }

    @Override
    public int getFloatPrecision() {
        return 15;
    }

    @Override
    public int getDoublePrecision() {
        return 48;
    }

    @Override
    public Dialect.SizeStrategy getSizeStrategy() {
        return this.sizeStrategy;
    }

    @Override
    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            @Override
            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, org.hibernate.sql.ast.tree.Statement statement) {
                return new SybaseASESqlAstTranslator(sessionFactory, statement);
            }
        };
    }

    @Override
    public boolean supportsBitType() {
        return false;
    }

    @Override
    public boolean supportsDistinctFromPredicate() {
        return this.getVersion().isSameOrAfter(16, 3);
    }

    @Override
    public void contributeTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.contributeTypes(typeContributions, serviceRegistry);
        JdbcTypeRegistry jdbcTypeRegistry = typeContributions.getTypeConfiguration().getJdbcTypeRegistry();
        jdbcTypeRegistry.addDescriptor(16, TinyIntJdbcType.INSTANCE);
        if (this.jtdsDriver) {
            jdbcTypeRegistry.addDescriptor(2014, TimestampJdbcType.INSTANCE);
        }
    }

    @Override
    public int resolveSqlTypeLength(String columnTypeName, int jdbcTypeCode, int precision, int scale, int displaySize) {
        switch (jdbcTypeCode) {
            case 7: 
            case 8: {
                return displaySize;
            }
        }
        return super.resolveSqlTypeLength(columnTypeName, jdbcTypeCode, precision, scale, displaySize);
    }

    @Override
    public String currentDate() {
        return "current_date()";
    }

    @Override
    public String currentTime() {
        return "current_time()";
    }

    @Override
    public String currentTimestamp() {
        return "current_bigdatetime()";
    }

    @Override
    public String timestampaddPattern(TemporalUnit unit, TemporalType temporalType, IntervalType intervalType) {
        switch (unit) {
            case NANOSECOND: 
            case NATIVE: {
                if (this.getVersion().isBefore(15, 5) || this.jtdsDriver) {
                    return "dateadd(millisecond,?2/1000000,?3)";
                }
                return "dateadd(mcs,?2/1000,?3)";
            }
        }
        return "dateadd(?1,?2,?3)";
    }

    @Override
    public long getFractionalSecondPrecisionInNanos() {
        if (this.getVersion().isBefore(15, 5)) {
            return 1000000L;
        }
        return 1000L;
    }

    @Override
    public String timestampdiffPattern(TemporalUnit unit, TemporalType fromTemporalType, TemporalType toTemporalType) {
        switch (unit) {
            case NANOSECOND: 
            case NATIVE: {
                if (this.getVersion().isBefore(15, 5)) {
                    return "cast(datediff(ms,?2,?3) as numeric(21))";
                }
                return "cast(datediff(mcs,cast(?2 as bigdatetime),cast(?3 as bigdatetime)) as numeric(21))";
            }
        }
        return "datediff(?1,?2,?3)";
    }

    @Override
    protected void registerDefaultKeywords() {
        super.registerDefaultKeywords();
        this.registerKeyword("add");
        this.registerKeyword("all");
        this.registerKeyword("alter");
        this.registerKeyword("and");
        this.registerKeyword("any");
        this.registerKeyword("arith_overflow");
        this.registerKeyword("as");
        this.registerKeyword("asc");
        this.registerKeyword("at");
        this.registerKeyword("authorization");
        this.registerKeyword("avg");
        this.registerKeyword("begin");
        this.registerKeyword("between");
        this.registerKeyword("break");
        this.registerKeyword("browse");
        this.registerKeyword("bulk");
        this.registerKeyword("by");
        this.registerKeyword("cascade");
        this.registerKeyword("case");
        this.registerKeyword("char_convert");
        this.registerKeyword("check");
        this.registerKeyword("checkpoint");
        this.registerKeyword("close");
        this.registerKeyword("clustered");
        this.registerKeyword("coalesce");
        this.registerKeyword("commit");
        this.registerKeyword("compute");
        this.registerKeyword("confirm");
        this.registerKeyword("connect");
        this.registerKeyword("constraint");
        this.registerKeyword("continue");
        this.registerKeyword("controlrow");
        this.registerKeyword("convert");
        this.registerKeyword("count");
        this.registerKeyword("count_big");
        this.registerKeyword("create");
        this.registerKeyword("current");
        this.registerKeyword("cursor");
        this.registerKeyword("database");
        this.registerKeyword("dbcc");
        this.registerKeyword("deallocate");
        this.registerKeyword("declare");
        this.registerKeyword("decrypt");
        this.registerKeyword("default");
        this.registerKeyword("delete");
        this.registerKeyword("desc");
        this.registerKeyword("determnistic");
        this.registerKeyword("disk");
        this.registerKeyword("distinct");
        this.registerKeyword("drop");
        this.registerKeyword("dummy");
        this.registerKeyword("dump");
        this.registerKeyword("else");
        this.registerKeyword("encrypt");
        this.registerKeyword("end");
        this.registerKeyword("endtran");
        this.registerKeyword("errlvl");
        this.registerKeyword("errordata");
        this.registerKeyword("errorexit");
        this.registerKeyword("escape");
        this.registerKeyword("except");
        this.registerKeyword("exclusive");
        this.registerKeyword("exec");
        this.registerKeyword("execute");
        this.registerKeyword("exist");
        this.registerKeyword("exit");
        this.registerKeyword("exp_row_size");
        this.registerKeyword("external");
        this.registerKeyword("fetch");
        this.registerKeyword("fillfactor");
        this.registerKeyword("for");
        this.registerKeyword("foreign");
        this.registerKeyword("from");
        this.registerKeyword("goto");
        this.registerKeyword("grant");
        this.registerKeyword("group");
        this.registerKeyword("having");
        this.registerKeyword("holdlock");
        this.registerKeyword("identity");
        this.registerKeyword("identity_gap");
        this.registerKeyword("identity_start");
        this.registerKeyword("if");
        this.registerKeyword("in");
        this.registerKeyword("index");
        this.registerKeyword("inout");
        this.registerKeyword("insensitive");
        this.registerKeyword("insert");
        this.registerKeyword("install");
        this.registerKeyword("intersect");
        this.registerKeyword("into");
        this.registerKeyword("is");
        this.registerKeyword("isolation");
        this.registerKeyword("jar");
        this.registerKeyword("join");
        this.registerKeyword("key");
        this.registerKeyword("kill");
        this.registerKeyword("level");
        this.registerKeyword("like");
        this.registerKeyword("lineno");
        this.registerKeyword("load");
        this.registerKeyword("lock");
        this.registerKeyword("materialized");
        this.registerKeyword("max");
        this.registerKeyword("max_rows_per_page");
        this.registerKeyword("min");
        this.registerKeyword("mirror");
        this.registerKeyword("mirrorexit");
        this.registerKeyword("modify");
        this.registerKeyword("national");
        this.registerKeyword("new");
        this.registerKeyword("noholdlock");
        this.registerKeyword("nonclustered");
        this.registerKeyword("nonscrollable");
        this.registerKeyword("non_sensitive");
        this.registerKeyword("not");
        this.registerKeyword("null");
        this.registerKeyword("nullif");
        this.registerKeyword("numeric_truncation");
        this.registerKeyword("of");
        this.registerKeyword("off");
        this.registerKeyword("offsets");
        this.registerKeyword("on");
        this.registerKeyword("once");
        this.registerKeyword("online");
        this.registerKeyword("only");
        this.registerKeyword("open");
        this.registerKeyword("option");
        this.registerKeyword("or");
        this.registerKeyword("order");
        this.registerKeyword("out");
        this.registerKeyword("output");
        this.registerKeyword("over");
        this.registerKeyword("artition");
        this.registerKeyword("perm");
        this.registerKeyword("permanent");
        this.registerKeyword("plan");
        this.registerKeyword("prepare");
        this.registerKeyword("primary");
        this.registerKeyword("print");
        this.registerKeyword("privileges");
        this.registerKeyword("proc");
        this.registerKeyword("procedure");
        this.registerKeyword("processexit");
        this.registerKeyword("proxy_table");
        this.registerKeyword("public");
        this.registerKeyword("quiesce");
        this.registerKeyword("raiserror");
        this.registerKeyword("read");
        this.registerKeyword("readpast");
        this.registerKeyword("readtext");
        this.registerKeyword("reconfigure");
        this.registerKeyword("references");
        this.registerKeyword("remove");
        this.registerKeyword("reorg");
        this.registerKeyword("replace");
        this.registerKeyword("replication");
        this.registerKeyword("reservepagegap");
        this.registerKeyword("return");
        this.registerKeyword("returns");
        this.registerKeyword("revoke");
        this.registerKeyword("role");
        this.registerKeyword("rollback");
        this.registerKeyword("rowcount");
        this.registerKeyword("rows");
        this.registerKeyword("rule");
        this.registerKeyword("save");
        this.registerKeyword("schema");
        this.registerKeyword("scroll");
        this.registerKeyword("scrollable");
        this.registerKeyword("select");
        this.registerKeyword("semi_sensitive");
        this.registerKeyword("set");
        this.registerKeyword("setuser");
        this.registerKeyword("shared");
        this.registerKeyword("shutdown");
        this.registerKeyword("some");
        this.registerKeyword("statistics");
        this.registerKeyword("stringsize");
        this.registerKeyword("stripe");
        this.registerKeyword("sum");
        this.registerKeyword("syb_identity");
        this.registerKeyword("syb_restree");
        this.registerKeyword("syb_terminate");
        this.registerKeyword("top");
        this.registerKeyword("table");
        this.registerKeyword("temp");
        this.registerKeyword("temporary");
        this.registerKeyword("textsize");
        this.registerKeyword("to");
        this.registerKeyword("tracefile");
        this.registerKeyword("tran");
        this.registerKeyword("transaction");
        this.registerKeyword("trigger");
        this.registerKeyword("truncate");
        this.registerKeyword("tsequal");
        this.registerKeyword("union");
        this.registerKeyword("unique");
        this.registerKeyword("unpartition");
        this.registerKeyword("update");
        this.registerKeyword("use");
        this.registerKeyword("user");
        this.registerKeyword("user_option");
        this.registerKeyword("using");
        this.registerKeyword("values");
        this.registerKeyword("varying");
        this.registerKeyword("view");
        this.registerKeyword("waitfor");
        this.registerKeyword("when");
        this.registerKeyword("where");
        this.registerKeyword("while");
        this.registerKeyword("with");
        this.registerKeyword("work");
        this.registerKeyword("writetext");
        this.registerKeyword("xmlextract");
        this.registerKeyword("xmlparse");
        this.registerKeyword("xmltest");
        this.registerKeyword("xmlvalidate");
    }

    @Override
    public boolean supportsCascadeDelete() {
        return false;
    }

    @Override
    public int getMaxAliasLength() {
        return 30;
    }

    @Override
    public int getMaxIdentifierLength() {
        return 255;
    }

    @Override
    public boolean supportsValuesListForInsert() {
        return false;
    }

    @Override
    public boolean supportsLockTimeouts() {
        return false;
    }

    @Override
    public boolean supportsOrderByInSubquery() {
        return false;
    }

    @Override
    public boolean supportsUnionInSubquery() {
        return false;
    }

    @Override
    public boolean supportsPartitionBy() {
        return false;
    }

    @Override
    public String getTableTypeString() {
        return this.getVersion().isBefore(15, 7) ? super.getTableTypeString() : " lock datarows";
    }

    @Override
    public boolean supportsExpectedLobUsagePattern() {
        return this.getVersion().isSameOrAfter(15, 7);
    }

    @Override
    public boolean supportsLobValueChangePropagation() {
        return false;
    }

    @Override
    public RowLockStrategy getWriteRowLockStrategy() {
        return this.getVersion().isSameOrAfter(15, 7) ? RowLockStrategy.COLUMN : RowLockStrategy.TABLE;
    }

    @Override
    public String getForUpdateString() {
        return this.getVersion().isBefore(15, 7) ? "" : " for update";
    }

    @Override
    public String getForUpdateString(String aliases) {
        return this.getVersion().isBefore(15, 7) ? "" : this.getForUpdateString() + " of " + aliases;
    }

    @Override
    public String appendLockHint(LockOptions mode, String tableName) {
        return this.getVersion().isBefore(15, 7) ? super.appendLockHint(mode, tableName) : tableName;
    }

    @Override
    public String applyLocksToSql(String sql, LockOptions aliasedLockOptions, Map<String, String[]> keyColumnNames) {
        return this.getVersion().isBefore(15, 7) ? super.applyLocksToSql(sql, aliasedLockOptions, keyColumnNames) : sql + new ForUpdateFragment(this, aliasedLockOptions, keyColumnNames).toFragmentString();
    }

    @Override
    public String toQuotedIdentifier(String name) {
        if (name == null || name.isEmpty()) {
            return name;
        }
        if (name.charAt(0) == '#') {
            return name;
        }
        return super.toQuotedIdentifier(name);
    }

    @Override
    public ViolatedConstraintNameExtractor getViolatedConstraintNameExtractor() {
        return EXTRACTOR;
    }

    @Override
    public SQLExceptionConversionDelegate buildSQLExceptionConversionDelegate() {
        if (this.getVersion().isBefore(15, 7)) {
            return null;
        }
        return (sqlException, message, sql) -> {
            String sqlState = JdbcExceptionHelper.extractSqlState(sqlException);
            int errorCode = JdbcExceptionHelper.extractErrorCode(sqlException);
            switch (sqlState) {
                case "JZ0TO": 
                case "JZ006": {
                    throw new LockTimeoutException(message, sqlException, sql);
                }
                case "S1000": {
                    switch (errorCode) {
                        case 515: 
                        case 2601: {
                            String constraintName = this.getViolatedConstraintNameExtractor().extractConstraintName(sqlException);
                            return new ConstraintViolationException(message, sqlException, sql, constraintName);
                        }
                    }
                    break;
                }
                case "ZZZZZ": {
                    if (515 != errorCode) break;
                    String constraintName = this.getViolatedConstraintNameExtractor().extractConstraintName(sqlException);
                    return new ConstraintViolationException(message, sqlException, sql, constraintName);
                }
                case "23000": {
                    if (546 != errorCode) break;
                    String constraintName = this.getViolatedConstraintNameExtractor().extractConstraintName(sqlException);
                    return new ConstraintViolationException(message, sqlException, sql, constraintName);
                }
            }
            return null;
        };
    }

    @Override
    public LimitHandler getLimitHandler() {
        if (this.getVersion().isBefore(12, 5)) {
            return super.getLimitHandler();
        }
        return new TopLimitHandler(false);
    }
}

