/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.loader.ast.internal.MultiNaturalIdLoaderStandard;
import org.hibernate.loader.ast.internal.SimpleNaturalIdLoader;
import org.hibernate.loader.ast.spi.MultiNaturalIdLoader;
import org.hibernate.loader.ast.spi.NaturalIdLoader;
import org.hibernate.mapping.IndexedConsumer;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.SelectableConsumer;
import org.hibernate.metamodel.mapping.SingularAttributeMapping;
import org.hibernate.metamodel.mapping.internal.AbstractNaturalIdMapping;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.spi.TypeConfiguration;

public class SimpleNaturalIdMapping
extends AbstractNaturalIdMapping
implements JavaType.CoercionContext {
    private final SingularAttributeMapping attribute;
    private final TypeConfiguration typeConfiguration;

    public SimpleNaturalIdMapping(SingularAttributeMapping attribute, EntityMappingType declaringType, MappingModelCreationProcess creationProcess) {
        super(declaringType, attribute.getAttributeMetadataAccess().resolveAttributeMetadata(declaringType).isUpdatable());
        this.attribute = attribute;
        this.typeConfiguration = creationProcess.getCreationContext().getSessionFactory().getTypeConfiguration();
    }

    @Override
    public void verifyFlushState(Object id, Object[] currentState, Object[] loadedState, SharedSessionContractImplementor session) {
        Object snapshot;
        if (this.isMutable()) {
            return;
        }
        PersistenceContext persistenceContext = session.getPersistenceContextInternal();
        EntityPersister persister = this.getDeclaringType().getEntityPersister();
        Object naturalId = this.extractNaturalIdFromEntityState(currentState, session);
        Object object = snapshot = loadedState == null ? persistenceContext.getNaturalIdSnapshot(id, persister) : persister.getNaturalIdMapping().extractNaturalIdFromEntityState(loadedState, session);
        if (!this.areEqual(naturalId, snapshot, session)) {
            throw new HibernateException(String.format("An immutable natural identifier of entity %s was altered from `%s` to `%s`", persister.getEntityName(), snapshot, naturalId));
        }
    }

    @Override
    public Object extractNaturalIdFromEntityState(Object[] state, SharedSessionContractImplementor session) {
        if (state == null) {
            return null;
        }
        if (state.length == 1) {
            return state[0];
        }
        return state[this.attribute.getStateArrayPosition()];
    }

    @Override
    public Object extractNaturalIdFromEntity(Object entity, SharedSessionContractImplementor session) {
        return this.attribute.getPropertyAccess().getGetter().get(entity);
    }

    @Override
    public void validateInternalForm(Object naturalIdValue, SharedSessionContractImplementor session) {
        Object[] values;
        if (naturalIdValue == null) {
            return;
        }
        if (naturalIdValue.getClass().isArray() && (values = (Object[])naturalIdValue).length == 1) {
            naturalIdValue = values[0];
        }
        if (!this.getJavaType().getJavaTypeClass().isInstance(naturalIdValue)) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Incoming natural-id value [%s (`%s`)] is not of expected type [`%s`] and could not be coerced", naturalIdValue, naturalIdValue.getClass().getName(), this.getJavaType().getJavaType().getTypeName()));
        }
    }

    @Override
    public int calculateHashCode(Object value, SharedSessionContractImplementor session) {
        return value == null ? 0 : this.getJavaType().extractHashCode(value);
    }

    @Override
    public Object normalizeInput(Object incoming, SharedSessionContractImplementor session) {
        return this.normalizeIncomingValue(incoming);
    }

    public Object normalizeIncomingValue(Object naturalIdToLoad) {
        Object normalizedValue;
        if (naturalIdToLoad instanceof Map) {
            Map valueMap = (Map)naturalIdToLoad;
            assert (valueMap.size() == 1);
            assert (valueMap.containsKey(this.getAttribute().getAttributeName()));
            normalizedValue = valueMap.get(this.getAttribute().getAttributeName());
        } else if (naturalIdToLoad instanceof Object[]) {
            Object[] values = (Object[])naturalIdToLoad;
            assert (values.length == 1);
            normalizedValue = values[0];
        } else {
            normalizedValue = naturalIdToLoad;
        }
        if (this.getTypeConfiguration().getSessionFactory().getJpaMetamodel().getJpaCompliance().isLoadByIdComplianceEnabled()) {
            return normalizedValue;
        }
        return this.getJavaType().coerce(normalizedValue, this);
    }

    public SingularAttributeMapping getAttribute() {
        return this.attribute;
    }

    @Override
    public List<SingularAttributeMapping> getNaturalIdAttributes() {
        return Collections.singletonList(this.attribute);
    }

    @Override
    public MappingType getPartMappingType() {
        return this.attribute.getPartMappingType();
    }

    @Override
    public JavaType<?> getJavaType() {
        return this.attribute.getJavaType();
    }

    @Override
    public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        return this.attribute.createDomainResult(navigablePath, tableGroup, resultVariable, creationState);
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState) {
        this.attribute.applySqlSelections(navigablePath, tableGroup, creationState);
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState, BiConsumer<SqlSelection, JdbcMapping> selectionConsumer) {
        this.attribute.applySqlSelections(navigablePath, tableGroup, creationState, selectionConsumer);
    }

    @Override
    public int forEachSelectable(int offset, SelectableConsumer consumer) {
        return this.attribute.forEachSelectable(offset, consumer);
    }

    @Override
    public int getJdbcTypeCount() {
        return this.attribute.getJdbcTypeCount();
    }

    @Override
    public List<JdbcMapping> getJdbcMappings() {
        return this.attribute.getJdbcMappings();
    }

    @Override
    public int forEachJdbcType(int offset, IndexedConsumer<JdbcMapping> action) {
        return this.attribute.forEachJdbcType(offset, action);
    }

    @Override
    public Object disassemble(Object value, SharedSessionContractImplementor session) {
        return this.attribute.disassemble(value, session);
    }

    @Override
    public void breakDownJdbcValues(Object domainValue, ModelPart.JdbcValueConsumer valueConsumer, SharedSessionContractImplementor session) {
        this.attribute.breakDownJdbcValues(domainValue, valueConsumer, session);
    }

    @Override
    public int forEachDisassembledJdbcValue(Object value, Clause clause, int offset, Bindable.JdbcValuesConsumer valuesConsumer, SharedSessionContractImplementor session) {
        return this.attribute.forEachDisassembledJdbcValue(value, clause, offset, valuesConsumer, session);
    }

    @Override
    public int forEachJdbcValue(Object value, Clause clause, int offset, Bindable.JdbcValuesConsumer valuesConsumer, SharedSessionContractImplementor session) {
        return this.attribute.forEachJdbcValue(value, clause, offset, valuesConsumer, session);
    }

    @Override
    public NaturalIdLoader<?> makeLoader(EntityMappingType entityDescriptor) {
        return new SimpleNaturalIdLoader(this, entityDescriptor);
    }

    @Override
    public MultiNaturalIdLoader<?> makeMultiLoader(EntityMappingType entityDescriptor) {
        return new MultiNaturalIdLoaderStandard(entityDescriptor);
    }

    @Override
    public TypeConfiguration getTypeConfiguration() {
        return this.typeConfiguration;
    }
}

