/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java.spi;

import java.lang.reflect.Type;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractJavaType;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.java.spi.JdbcTypeRecommendationException;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;

public class UnknownBasicJavaType<T>
extends AbstractJavaType<T> {
    public UnknownBasicJavaType(Class<T> type) {
        super(type);
    }

    public UnknownBasicJavaType(Class<T> type, MutabilityPlan<T> mutabilityPlan) {
        super(type, mutabilityPlan);
    }

    public UnknownBasicJavaType(Type type, MutabilityPlan<T> mutabilityPlan) {
        super(type, mutabilityPlan);
    }

    @Override
    public JdbcType getRecommendedJdbcType(JdbcTypeIndicators context) {
        throw new JdbcTypeRecommendationException("Could not determine recommended JdbcType for `" + this.getJavaType().getTypeName() + "`");
    }

    @Override
    public String toString(T value) {
        return value.toString();
    }

    @Override
    public T fromString(CharSequence string) {
        throw new UnsupportedOperationException("Conversion from String strategy not known for this Java type : " + this.getJavaType().getTypeName());
    }

    @Override
    public <X> X unwrap(T value, Class<X> type, WrapperOptions options) {
        if (type.isAssignableFrom(this.getJavaTypeClass())) {
            return (X)value;
        }
        throw new UnsupportedOperationException("Unwrap strategy not known for this Java type : " + this.getJavaType().getTypeName());
    }

    @Override
    public <X> T wrap(X value, WrapperOptions options) {
        if (this.getJavaTypeClass().isInstance(value)) {
            return (T)value;
        }
        throw new UnsupportedOperationException("Wrap strategy not known for this Java type : " + this.getJavaType().getTypeName());
    }

    public String toString() {
        return "BasicJavaType(" + this.getJavaType().getTypeName() + ")";
    }
}

