
package org.hibernate.boot.jaxb.mapping;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for cache-inclusion-type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>
 * &lt;simpleType name="cache-inclusion-type"&gt;
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}token"&gt;
 *     &lt;enumeration value="all"/&gt;
 *     &lt;enumeration value="non-lazy"/&gt;
 *   &lt;/restriction&gt;
 * &lt;/simpleType&gt;
 * </pre>
 * 
 */
@XmlType(name = "cache-inclusion-type", namespace = "http://www.hibernate.org/xsd/orm/mapping")
@XmlEnum
public enum JaxbCacheInclusionType {

    @XmlEnumValue("all")
    ALL("all"),
    @XmlEnumValue("non-lazy")
    NON_LAZY("non-lazy");
    private final String value;

    JaxbCacheInclusionType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static JaxbCacheInclusionType fromValue(String v) {
        for (JaxbCacheInclusionType c: JaxbCacheInclusionType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
