
package org.hibernate.boot.jaxb.mapping;

import java.io.Serializable;
import jakarta.persistence.AccessType;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;


/**
 * 
 *                 See `@org.hibernate.annotations.ManyToAny`
 *             
 * 
 * <p>Java class for hbm-many-to-any complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="hbm-many-to-any"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element name="discriminator" type="{http://www.hibernate.org/xsd/orm/mapping}hbm-any-discriminator"/&gt;
 *         &lt;element name="key" type="{http://www.hibernate.org/xsd/orm/mapping}hbm-any-key"/&gt;
 *         &lt;element name="cascade" type="{http://www.hibernate.org/xsd/orm/mapping}cascade-type" minOccurs="0"/&gt;
 *         &lt;element name="optimistic-lock" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/&gt;
 *       &lt;/sequence&gt;
 *       &lt;attribute name="name" use="required" type="{http://www.w3.org/2001/XMLSchema}string" /&gt;
 *       &lt;attribute name="access" type="{http://www.hibernate.org/xsd/orm/mapping}access-type" /&gt;
 *       &lt;attribute name="attribute-accessor" type="{http://www.w3.org/2001/XMLSchema}string" /&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "hbm-many-to-any", namespace = "http://www.hibernate.org/xsd/orm/mapping", propOrder = {
    "discriminator",
    "key",
    "cascade",
    "optimisticLock"
})
public class JaxbHbmManyToAny
    implements Serializable, DiscriminatedAssociation
{

    @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/mapping", required = true)
    protected JaxbHbmAnyDiscriminator discriminator;
    @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/mapping", required = true)
    protected JaxbHbmAnyKey key;
    @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected JaxbCascadeType cascade;
    @XmlElement(name = "optimistic-lock", namespace = "http://www.hibernate.org/xsd/orm/mapping", defaultValue = "true")
    protected Boolean optimisticLock;
    @XmlAttribute(name = "name", required = true)
    protected String name;
    @XmlAttribute(name = "access")
    @XmlJavaTypeAdapter(Adapter1 .class)
    protected AccessType access;
    @XmlAttribute(name = "attribute-accessor")
    protected String attributeAccessor;

    /**
     * Gets the value of the discriminator property.
     * 
     * @return
     *     possible object is
     *     {@link JaxbHbmAnyDiscriminator }
     *     
     */
    public JaxbHbmAnyDiscriminator getDiscriminator() {
        return discriminator;
    }

    /**
     * Sets the value of the discriminator property.
     * 
     * @param value
     *     allowed object is
     *     {@link JaxbHbmAnyDiscriminator }
     *     
     */
    public void setDiscriminator(JaxbHbmAnyDiscriminator value) {
        this.discriminator = value;
    }

    /**
     * Gets the value of the key property.
     * 
     * @return
     *     possible object is
     *     {@link JaxbHbmAnyKey }
     *     
     */
    public JaxbHbmAnyKey getKey() {
        return key;
    }

    /**
     * Sets the value of the key property.
     * 
     * @param value
     *     allowed object is
     *     {@link JaxbHbmAnyKey }
     *     
     */
    public void setKey(JaxbHbmAnyKey value) {
        this.key = value;
    }

    /**
     * Gets the value of the cascade property.
     * 
     * @return
     *     possible object is
     *     {@link JaxbCascadeType }
     *     
     */
    public JaxbCascadeType getCascade() {
        return cascade;
    }

    /**
     * Sets the value of the cascade property.
     * 
     * @param value
     *     allowed object is
     *     {@link JaxbCascadeType }
     *     
     */
    public void setCascade(JaxbCascadeType value) {
        this.cascade = value;
    }

    /**
     * Gets the value of the optimisticLock property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean isOptimisticLock() {
        return optimisticLock;
    }

    /**
     * Sets the value of the optimisticLock property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setOptimisticLock(Boolean value) {
        this.optimisticLock = value;
    }

    /**
     * Gets the value of the name property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getName() {
        return name;
    }

    /**
     * Sets the value of the name property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setName(String value) {
        this.name = value;
    }

    /**
     * Gets the value of the access property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public AccessType getAccess() {
        return access;
    }

    /**
     * Sets the value of the access property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setAccess(AccessType value) {
        this.access = value;
    }

    /**
     * Gets the value of the attributeAccessor property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getAttributeAccessor() {
        return attributeAccessor;
    }

    /**
     * Sets the value of the attributeAccessor property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setAttributeAccessor(String value) {
        this.attributeAccessor = value;
    }

}
