
package org.hibernate.boot.jaxb.mapping;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import jakarta.persistence.AccessType;
import jakarta.persistence.FetchType;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;


/**
 * 
 * 
 *                 @Target({METHOD, FIELD}) @Retention(RUNTIME)
 *                 public @interface OneToOne {
 *                 Class targetEntity() default void.class;
 *                 CascadeType[] cascade() default {};
 *                 FetchType fetch() default EAGER;
 *                 boolean optional() default true;
 *                 String mappedBy() default "";
 *                 boolean orphanRemoval() default false;
 *                 }
 * 
 *             
 * 
 * <p>Java class for one-to-one complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="one-to-one"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;choice&gt;
 *           &lt;sequence&gt;
 *             &lt;element name="primary-key-join-column" type="{http://www.hibernate.org/xsd/orm/mapping}primary-key-join-column" maxOccurs="unbounded" minOccurs="0"/&gt;
 *             &lt;element name="primary-key-foreign-key" type="{http://www.hibernate.org/xsd/orm/mapping}foreign-key" minOccurs="0"/&gt;
 *           &lt;/sequence&gt;
 *           &lt;sequence&gt;
 *             &lt;element name="join-column" type="{http://www.hibernate.org/xsd/orm/mapping}join-column" maxOccurs="unbounded" minOccurs="0"/&gt;
 *             &lt;element name="foreign-key" type="{http://www.hibernate.org/xsd/orm/mapping}foreign-key" minOccurs="0"/&gt;
 *           &lt;/sequence&gt;
 *           &lt;element name="join-table" type="{http://www.hibernate.org/xsd/orm/mapping}join-table" minOccurs="0"/&gt;
 *         &lt;/choice&gt;
 *         &lt;element name="cascade" type="{http://www.hibernate.org/xsd/orm/mapping}cascade-type" minOccurs="0"/&gt;
 *       &lt;/sequence&gt;
 *       &lt;attribute name="name" use="required" type="{http://www.w3.org/2001/XMLSchema}string" /&gt;
 *       &lt;attribute name="target-entity" type="{http://www.w3.org/2001/XMLSchema}string" /&gt;
 *       &lt;attribute name="fetch" type="{http://www.hibernate.org/xsd/orm/mapping}fetch-type" /&gt;
 *       &lt;attribute name="fetch-mode" type="{http://www.hibernate.org/xsd/orm/mapping}singular-fetch-mode" /&gt;
 *       &lt;attribute name="optional" type="{http://www.w3.org/2001/XMLSchema}boolean" /&gt;
 *       &lt;attribute name="access" type="{http://www.hibernate.org/xsd/orm/mapping}access-type" /&gt;
 *       &lt;attribute name="attribute-accessor" type="{http://www.w3.org/2001/XMLSchema}string" /&gt;
 *       &lt;attribute name="mapped-by" type="{http://www.w3.org/2001/XMLSchema}string" /&gt;
 *       &lt;attribute name="orphan-removal" type="{http://www.w3.org/2001/XMLSchema}boolean" /&gt;
 *       &lt;attribute name="maps-id" type="{http://www.w3.org/2001/XMLSchema}string" /&gt;
 *       &lt;attribute name="id" type="{http://www.w3.org/2001/XMLSchema}boolean" /&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "one-to-one", namespace = "http://www.hibernate.org/xsd/orm/mapping", propOrder = {
    "primaryKeyJoinColumn",
    "primaryKeyForeignKey",
    "joinColumn",
    "foreignKey",
    "joinTable",
    "cascade"
})
public class JaxbOneToOne
    implements Serializable, ToOneAttribute
{

    @XmlElement(name = "primary-key-join-column", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected List<JaxbPrimaryKeyJoinColumn> primaryKeyJoinColumn;
    @XmlElement(name = "primary-key-foreign-key", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected JaxbForeignKey primaryKeyForeignKey;
    @XmlElement(name = "join-column", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected List<JaxbJoinColumn> joinColumn;
    @XmlElement(name = "foreign-key", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected JaxbForeignKey foreignKey;
    @XmlElement(name = "join-table", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected JaxbJoinTable joinTable;
    @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected JaxbCascadeType cascade;
    @XmlAttribute(name = "name", required = true)
    protected String name;
    @XmlAttribute(name = "target-entity")
    protected String targetEntity;
    @XmlAttribute(name = "fetch")
    @XmlJavaTypeAdapter(Adapter8 .class)
    protected FetchType fetch;
    @XmlAttribute(name = "fetch-mode")
    protected JaxbSingularFetchMode fetchMode;
    @XmlAttribute(name = "optional")
    protected Boolean optional;
    @XmlAttribute(name = "access")
    @XmlJavaTypeAdapter(Adapter1 .class)
    protected AccessType access;
    @XmlAttribute(name = "attribute-accessor")
    protected String attributeAccessor;
    @XmlAttribute(name = "mapped-by")
    protected String mappedBy;
    @XmlAttribute(name = "orphan-removal")
    protected Boolean orphanRemoval;
    @XmlAttribute(name = "maps-id")
    protected String mapsId;
    @XmlAttribute(name = "id")
    protected Boolean id;

    /**
     * Gets the value of the primaryKeyJoinColumn property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a <CODE>set</CODE> method for the primaryKeyJoinColumn property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPrimaryKeyJoinColumn().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbPrimaryKeyJoinColumn }
     * 
     * 
     */
    public List<JaxbPrimaryKeyJoinColumn> getPrimaryKeyJoinColumn() {
        if (primaryKeyJoinColumn == null) {
            primaryKeyJoinColumn = new ArrayList<JaxbPrimaryKeyJoinColumn>();
        }
        return this.primaryKeyJoinColumn;
    }

    /**
     * Gets the value of the primaryKeyForeignKey property.
     * 
     * @return
     *     possible object is
     *     {@link JaxbForeignKey }
     *     
     */
    public JaxbForeignKey getPrimaryKeyForeignKey() {
        return primaryKeyForeignKey;
    }

    /**
     * Sets the value of the primaryKeyForeignKey property.
     * 
     * @param value
     *     allowed object is
     *     {@link JaxbForeignKey }
     *     
     */
    public void setPrimaryKeyForeignKey(JaxbForeignKey value) {
        this.primaryKeyForeignKey = value;
    }

    /**
     * Gets the value of the joinColumn property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a <CODE>set</CODE> method for the joinColumn property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getJoinColumn().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbJoinColumn }
     * 
     * 
     */
    public List<JaxbJoinColumn> getJoinColumn() {
        if (joinColumn == null) {
            joinColumn = new ArrayList<JaxbJoinColumn>();
        }
        return this.joinColumn;
    }

    /**
     * Gets the value of the foreignKey property.
     * 
     * @return
     *     possible object is
     *     {@link JaxbForeignKey }
     *     
     */
    public JaxbForeignKey getForeignKey() {
        return foreignKey;
    }

    /**
     * Sets the value of the foreignKey property.
     * 
     * @param value
     *     allowed object is
     *     {@link JaxbForeignKey }
     *     
     */
    public void setForeignKey(JaxbForeignKey value) {
        this.foreignKey = value;
    }

    /**
     * Gets the value of the joinTable property.
     * 
     * @return
     *     possible object is
     *     {@link JaxbJoinTable }
     *     
     */
    public JaxbJoinTable getJoinTable() {
        return joinTable;
    }

    /**
     * Sets the value of the joinTable property.
     * 
     * @param value
     *     allowed object is
     *     {@link JaxbJoinTable }
     *     
     */
    public void setJoinTable(JaxbJoinTable value) {
        this.joinTable = value;
    }

    /**
     * Gets the value of the cascade property.
     * 
     * @return
     *     possible object is
     *     {@link JaxbCascadeType }
     *     
     */
    public JaxbCascadeType getCascade() {
        return cascade;
    }

    /**
     * Sets the value of the cascade property.
     * 
     * @param value
     *     allowed object is
     *     {@link JaxbCascadeType }
     *     
     */
    public void setCascade(JaxbCascadeType value) {
        this.cascade = value;
    }

    /**
     * Gets the value of the name property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getName() {
        return name;
    }

    /**
     * Sets the value of the name property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setName(String value) {
        this.name = value;
    }

    /**
     * Gets the value of the targetEntity property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getTargetEntity() {
        return targetEntity;
    }

    /**
     * Sets the value of the targetEntity property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setTargetEntity(String value) {
        this.targetEntity = value;
    }

    /**
     * Gets the value of the fetch property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public FetchType getFetch() {
        return fetch;
    }

    /**
     * Sets the value of the fetch property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setFetch(FetchType value) {
        this.fetch = value;
    }

    /**
     * Gets the value of the fetchMode property.
     * 
     * @return
     *     possible object is
     *     {@link JaxbSingularFetchMode }
     *     
     */
    public JaxbSingularFetchMode getFetchMode() {
        return fetchMode;
    }

    /**
     * Sets the value of the fetchMode property.
     * 
     * @param value
     *     allowed object is
     *     {@link JaxbSingularFetchMode }
     *     
     */
    public void setFetchMode(JaxbSingularFetchMode value) {
        this.fetchMode = value;
    }

    /**
     * Gets the value of the optional property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean isOptional() {
        return optional;
    }

    /**
     * Sets the value of the optional property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setOptional(Boolean value) {
        this.optional = value;
    }

    /**
     * Gets the value of the access property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public AccessType getAccess() {
        return access;
    }

    /**
     * Sets the value of the access property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setAccess(AccessType value) {
        this.access = value;
    }

    /**
     * Gets the value of the attributeAccessor property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getAttributeAccessor() {
        return attributeAccessor;
    }

    /**
     * Sets the value of the attributeAccessor property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setAttributeAccessor(String value) {
        this.attributeAccessor = value;
    }

    /**
     * Gets the value of the mappedBy property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getMappedBy() {
        return mappedBy;
    }

    /**
     * Sets the value of the mappedBy property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setMappedBy(String value) {
        this.mappedBy = value;
    }

    /**
     * Gets the value of the orphanRemoval property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean isOrphanRemoval() {
        return orphanRemoval;
    }

    /**
     * Sets the value of the orphanRemoval property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setOrphanRemoval(Boolean value) {
        this.orphanRemoval = value;
    }

    /**
     * Gets the value of the mapsId property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getMapsId() {
        return mapsId;
    }

    /**
     * Sets the value of the mapsId property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setMapsId(String value) {
        this.mapsId = value;
    }

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean isId() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setId(Boolean value) {
        this.id = value;
    }

}
