
package org.hibernate.boot.jaxb.mapping;

import java.io.Serializable;
import jakarta.persistence.AccessType;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;


/**
 * 
 * 
 *                 These defaults are applied to the persistence unit as a whole
 *                 unless they are overridden by local annotation or XML
 *                 element settings.
 * 
 *                 schema - Used as the schema for all tables, secondary tables, join
 *                 tables, collection tables, sequence generators, and table
 *                 generators that apply to the persistence unit
 *                 catalog - Used as the catalog for all tables, secondary tables, join
 *                 tables, collection tables, sequence generators, and table
 *                 generators that apply to the persistence unit
 *                 delimited-identifiers - Used to treat database identifiers as
 *                 delimited identifiers.
 *                 access - Used as the access type for all managed classes in
 *                 the persistence unit
 *                 cascade-persist - Adds cascade-persist to the set of cascade options
 *                 in all entity relationships of the persistence unit
 *                 entity-listeners - List of default entity listeners to be invoked
 *                 on each entity in the persistence unit.
 *             
 * 
 * <p>Java class for persistence-unit-defaults complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="persistence-unit-defaults"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element name="description" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/&gt;
 *         &lt;element name="schema" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/&gt;
 *         &lt;element name="catalog" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/&gt;
 *         &lt;element name="delimited-identifiers" type="{http://www.hibernate.org/xsd/orm/mapping}emptyType" minOccurs="0"/&gt;
 *         &lt;choice minOccurs="0"&gt;
 *           &lt;element name="access" type="{http://www.hibernate.org/xsd/orm/mapping}access-type"/&gt;
 *           &lt;element name="default-access" type="{http://www.w3.org/2001/XMLSchema}string"/&gt;
 *         &lt;/choice&gt;
 *         &lt;choice minOccurs="0"&gt;
 *           &lt;element name="cascade-persist" type="{http://www.hibernate.org/xsd/orm/mapping}emptyType" minOccurs="0"/&gt;
 *           &lt;element name="default-cascade" type="{http://www.w3.org/2001/XMLSchema}string"/&gt;
 *         &lt;/choice&gt;
 *         &lt;element name="auto-import" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/&gt;
 *         &lt;element name="default-lazy" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/&gt;
 *         &lt;element name="entity-listeners" type="{http://www.hibernate.org/xsd/orm/mapping}entity-listeners" minOccurs="0"/&gt;
 *       &lt;/sequence&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "persistence-unit-defaults", namespace = "http://www.hibernate.org/xsd/orm/mapping", propOrder = {
    "description",
    "schema",
    "catalog",
    "delimitedIdentifiers",
    "access",
    "defaultAccess",
    "cascadePersist",
    "defaultCascade",
    "autoImport",
    "defaultLazy",
    "entityListeners"
})
public class JaxbPersistenceUnitDefaults
    implements Serializable
{

    @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected String description;
    @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected String schema;
    @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected String catalog;
    @XmlElement(name = "delimited-identifiers", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected JaxbEmptyType delimitedIdentifiers;
    @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/mapping", type = String.class)
    @XmlJavaTypeAdapter(Adapter1 .class)
    @XmlSchemaType(name = "token")
    protected AccessType access;
    @XmlElement(name = "default-access", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected String defaultAccess;
    @XmlElement(name = "cascade-persist", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected JaxbEmptyType cascadePersist;
    @XmlElement(name = "default-cascade", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected String defaultCascade;
    @XmlElement(name = "auto-import", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected Boolean autoImport;
    @XmlElement(name = "default-lazy", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected Boolean defaultLazy;
    @XmlElement(name = "entity-listeners", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected JaxbEntityListeners entityListeners;

    /**
     * Gets the value of the description property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getDescription() {
        return description;
    }

    /**
     * Sets the value of the description property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setDescription(String value) {
        this.description = value;
    }

    /**
     * Gets the value of the schema property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getSchema() {
        return schema;
    }

    /**
     * Sets the value of the schema property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setSchema(String value) {
        this.schema = value;
    }

    /**
     * Gets the value of the catalog property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getCatalog() {
        return catalog;
    }

    /**
     * Sets the value of the catalog property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setCatalog(String value) {
        this.catalog = value;
    }

    /**
     * Gets the value of the delimitedIdentifiers property.
     * 
     * @return
     *     possible object is
     *     {@link JaxbEmptyType }
     *     
     */
    public JaxbEmptyType getDelimitedIdentifiers() {
        return delimitedIdentifiers;
    }

    /**
     * Sets the value of the delimitedIdentifiers property.
     * 
     * @param value
     *     allowed object is
     *     {@link JaxbEmptyType }
     *     
     */
    public void setDelimitedIdentifiers(JaxbEmptyType value) {
        this.delimitedIdentifiers = value;
    }

    /**
     * Gets the value of the access property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public AccessType getAccess() {
        return access;
    }

    /**
     * Sets the value of the access property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setAccess(AccessType value) {
        this.access = value;
    }

    /**
     * Gets the value of the defaultAccess property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getDefaultAccess() {
        return defaultAccess;
    }

    /**
     * Sets the value of the defaultAccess property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setDefaultAccess(String value) {
        this.defaultAccess = value;
    }

    /**
     * Gets the value of the cascadePersist property.
     * 
     * @return
     *     possible object is
     *     {@link JaxbEmptyType }
     *     
     */
    public JaxbEmptyType getCascadePersist() {
        return cascadePersist;
    }

    /**
     * Sets the value of the cascadePersist property.
     * 
     * @param value
     *     allowed object is
     *     {@link JaxbEmptyType }
     *     
     */
    public void setCascadePersist(JaxbEmptyType value) {
        this.cascadePersist = value;
    }

    /**
     * Gets the value of the defaultCascade property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getDefaultCascade() {
        return defaultCascade;
    }

    /**
     * Sets the value of the defaultCascade property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setDefaultCascade(String value) {
        this.defaultCascade = value;
    }

    /**
     * Gets the value of the autoImport property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean isAutoImport() {
        return autoImport;
    }

    /**
     * Sets the value of the autoImport property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setAutoImport(Boolean value) {
        this.autoImport = value;
    }

    /**
     * Gets the value of the defaultLazy property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean isDefaultLazy() {
        return defaultLazy;
    }

    /**
     * Sets the value of the defaultLazy property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setDefaultLazy(Boolean value) {
        this.defaultLazy = value;
    }

    /**
     * Gets the value of the entityListeners property.
     * 
     * @return
     *     possible object is
     *     {@link JaxbEntityListeners }
     *     
     */
    public JaxbEntityListeners getEntityListeners() {
        return entityListeners;
    }

    /**
     * Sets the value of the entityListeners property.
     * 
     * @param value
     *     allowed object is
     *     {@link JaxbEntityListeners }
     *     
     */
    public void setEntityListeners(JaxbEntityListeners value) {
        this.entityListeners = value;
    }

}
