/*
 * Hibernate, Relational Persistence for Idiomatic Java
 *
 * License: GNU Lesser General Public License (LGPL), version 2.1 or later
 * See the lgpl.txt file in the root directory or http://www.gnu.org/licenses/lgpl-2.1.html
 */
package org.hibernate;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import static java.lang.annotation.ElementType.CONSTRUCTOR;
import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.ElementType.PACKAGE;
import static java.lang.annotation.ElementType.TYPE;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

/**
 * Annotation used to identify a package, class, interface or method
 * as "internal", meaning that applications should expect no guarantees
 * with regard to the binary stability from release to release.
 *
 * @author Steve Ebersole
 */
@Target({PACKAGE, TYPE, METHOD, FIELD, CONSTRUCTOR})
@Retention(RUNTIME)
public @interface Internal {
}

