/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal.util.collections;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.function.Function;
import org.hibernate.internal.util.collections.Stack;

public final class StandardStack<T>
implements Stack<T> {
    private ArrayDeque<T> internalStack;
    private static final Object NULL_TOKEN = new Object();

    public StandardStack() {
    }

    public StandardStack(T initial) {
        this.stackInstanceExpected().addFirst(initial);
    }

    @Override
    public void push(T newCurrent) {
        Object toStore = newCurrent;
        if (newCurrent == null) {
            toStore = NULL_TOKEN;
        }
        this.stackInstanceExpected().addFirst(toStore);
    }

    private Deque<T> stackInstanceExpected() {
        if (this.internalStack == null) {
            this.internalStack = new ArrayDeque(7);
        }
        return this.internalStack;
    }

    @Override
    public T pop() {
        return this.convert(this.stackInstanceExpected().removeFirst());
    }

    private T convert(Object internalStoredObject) {
        if (internalStoredObject == NULL_TOKEN) {
            return null;
        }
        return (T)internalStoredObject;
    }

    @Override
    public T getCurrent() {
        if (this.internalStack == null) {
            return null;
        }
        return this.convert(this.internalStack.peek());
    }

    @Override
    public int depth() {
        if (this.internalStack == null) {
            return 0;
        }
        return this.internalStack.size();
    }

    @Override
    public boolean isEmpty() {
        if (this.internalStack == null) {
            return true;
        }
        return this.internalStack.isEmpty();
    }

    @Override
    public void clear() {
        if (this.internalStack != null) {
            this.internalStack.clear();
        }
    }

    @Override
    public void visitRootFirst(Consumer<T> action) {
        if (this.internalStack == null) {
            return;
        }
        Iterator<T> iterator = this.internalStack.descendingIterator();
        while (iterator.hasNext()) {
            action.accept(iterator.next());
        }
    }

    @Override
    public <X> X findCurrentFirst(Function<T, X> function) {
        if (this.internalStack == null) {
            return null;
        }
        for (T t : this.internalStack) {
            X result = function.apply(t);
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

