/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.jackson;

import org.hibernate.type.FormatMapper;
import org.hibernate.type.jackson.JacksonJsonFormatMapper;
import org.hibernate.type.jackson.JacksonXmlFormatMapper;

public final class JacksonIntegration {
    private static final boolean JACKSON_XML_AVAILABLE = JacksonIntegration.ableToLoadJacksonXMLMapper();
    private static final boolean JACKSON_JSON_AVAILABLE = JacksonIntegration.ableToLoadJacksonJSONMapper();
    private static final JacksonXmlFormatMapper XML_FORMAT_MAPPER = JACKSON_XML_AVAILABLE ? new JacksonXmlFormatMapper() : null;
    private static final JacksonJsonFormatMapper JSON_FORMAT_MAPPER = JACKSON_JSON_AVAILABLE ? new JacksonJsonFormatMapper() : null;

    private JacksonIntegration() {
    }

    private static boolean ableToLoadJacksonJSONMapper() {
        return JacksonIntegration.canLoad("com.fasterxml.jackson.databind.ObjectMapper");
    }

    private static boolean ableToLoadJacksonXMLMapper() {
        return JacksonIntegration.canLoad("com.fasterxml.jackson.dataformat.xml.XmlMapper");
    }

    public static FormatMapper getXMLJacksonFormatMapperOrNull() {
        return XML_FORMAT_MAPPER;
    }

    public static FormatMapper getJsonJacksonFormatMapperOrNull() {
        return JSON_FORMAT_MAPPER;
    }

    private static boolean canLoad(String name) {
        try {
            JacksonIntegration.class.getClassLoader().loadClass(name);
            return true;
        }
        catch (ClassNotFoundException | LinkageError e) {
            return false;
        }
    }
}

