
package org.hibernate.boot.jaxb.mapping;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import jakarta.persistence.AccessType;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.hibernate.boot.jaxb.spi.BindableMappingDescriptor;


/**
 * 
 * 
 *                     The entity-mappings element is the root element of a mapping
 *                     file. It contains the following four types of elements:
 * 
 *                     1. The persistence-unit-metadata element contains metadata
 *                     for the entire persistence unit. It is undefined if this element
 *                     occurs in multiple mapping files within the same persistence unit.
 * 
 *                     2. The package, schema, catalog and access elements apply to all of
 *                     the entity, mapped-superclass and embeddable elements defined in
 *                     the same file in which they occur.
 * 
 *                     3. The sequence-generator, table-generator, converter, named-query,
 *                     named-native-query, named-stored-procedure-query, and
 *                     sql-result-set-mapping elements are global to the persistence
 *                     unit. It is undefined to have more than one sequence-generator
 *                     or table-generator of the same name in the same or different
 *                     mapping files in a persistence unit. It is undefined to have
 *                     more than one named-query, named-native-query, sql-result-set-mapping,
 *                     or named-stored-procedure-query of the same name in the same
 *                     or different mapping files in a persistence unit.  It is also
 *                     undefined to have more than one converter for the same target
 *                     type in the same or different mapping files in a persistence unit.
 * 
 *                     4. The entity, mapped-superclass and embeddable elements each define
 *                     the mapping information for a managed persistent class. The mapping
 *                     information contained in these elements may be complete or it may
 *                     be partial.
 * 
 *                 
 * 
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element name="description" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/&gt;
 *         &lt;element name="persistence-unit-metadata" type="{http://www.hibernate.org/xsd/orm/mapping}persistence-unit-metadata" minOccurs="0"/&gt;
 *         &lt;element name="package" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/&gt;
 *         &lt;element name="schema" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/&gt;
 *         &lt;element name="catalog" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/&gt;
 *         &lt;choice minOccurs="0"&gt;
 *           &lt;element name="access" type="{http://www.hibernate.org/xsd/orm/mapping}access-type"/&gt;
 *           &lt;element name="attribute-accessor" type="{http://www.w3.org/2001/XMLSchema}string"/&gt;
 *         &lt;/choice&gt;
 *         &lt;element name="auto-import" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/&gt;
 *         &lt;element name="default-cascade" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/&gt;
 *         &lt;element name="default-lazy" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/&gt;
 *         &lt;element name="filter-def" type="{http://www.hibernate.org/xsd/orm/mapping}filter-def" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element name="fetch-profile" type="{http://www.hibernate.org/xsd/orm/mapping}fetch-profile" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element name="sequence-generator" type="{http://www.hibernate.org/xsd/orm/mapping}sequence-generator" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element name="table-generator" type="{http://www.hibernate.org/xsd/orm/mapping}table-generator" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element name="identifier-generator" type="{http://www.hibernate.org/xsd/orm/mapping}generic-id-generator" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element name="named-query" type="{http://www.hibernate.org/xsd/orm/mapping}named-query" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element name="named-native-query" type="{http://www.hibernate.org/xsd/orm/mapping}named-native-query" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element name="named-stored-procedure-query" type="{http://www.hibernate.org/xsd/orm/mapping}named-stored-procedure-query" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element name="sql-result-set-mapping" type="{http://www.hibernate.org/xsd/orm/mapping}sql-result-set-mapping" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element name="mapped-superclass" type="{http://www.hibernate.org/xsd/orm/mapping}mapped-superclass" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element name="entity" type="{http://www.hibernate.org/xsd/orm/mapping}entity" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element name="embeddable" type="{http://www.hibernate.org/xsd/orm/mapping}embeddable" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element name="converter" type="{http://www.hibernate.org/xsd/orm/mapping}converter" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element name="import" type="{http://www.hibernate.org/xsd/orm/mapping}hql-import" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element name="database-object" type="{http://www.hibernate.org/xsd/orm/mapping}database-object" maxOccurs="unbounded" minOccurs="0"/&gt;
 *       &lt;/sequence&gt;
 *       &lt;attribute name="version" type="{http://www.hibernate.org/xsd/orm/mapping}supportedVersionType" default="3.1" /&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "description",
    "persistenceUnitMetadata",
    "_package",
    "schema",
    "catalog",
    "access",
    "attributeAccessor",
    "autoImport",
    "defaultCascade",
    "defaultLazy",
    "filterDefinitions",
    "fetchProfiles",
    "sequenceGenerator",
    "tableGenerator",
    "genericGenerators",
    "namedQueries",
    "namedNativeQueries",
    "namedProcedureQueries",
    "sqlResultSetMappings",
    "mappedSuperclasses",
    "entities",
    "embeddables",
    "converters",
    "hqlImports",
    "databaseObjects"
})
@XmlRootElement(name = "entity-mappings", namespace = "http://www.hibernate.org/xsd/orm/mapping")
public class JaxbEntityMappings
    implements Serializable, BindableMappingDescriptor
{

    @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected String description;
    @XmlElement(name = "persistence-unit-metadata", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected JaxbPersistenceUnitMetadata persistenceUnitMetadata;
    @XmlElement(name = "package", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected String _package;
    @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected String schema;
    @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected String catalog;
    @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/mapping", type = String.class)
    @XmlJavaTypeAdapter(Adapter1 .class)
    @XmlSchemaType(name = "token")
    protected AccessType access;
    @XmlElement(name = "attribute-accessor", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected String attributeAccessor;
    @XmlElement(name = "auto-import", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected Boolean autoImport;
    @XmlElement(name = "default-cascade", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected String defaultCascade;
    @XmlElement(name = "default-lazy", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected Boolean defaultLazy;
    @XmlElement(name = "filter-def", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected List<JaxbFilterDef> filterDefinitions;
    @XmlElement(name = "fetch-profile", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected List<JaxbFetchProfile> fetchProfiles;
    @XmlElement(name = "sequence-generator", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected List<JaxbSequenceGenerator> sequenceGenerator;
    @XmlElement(name = "table-generator", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected List<JaxbTableGenerator> tableGenerator;
    @XmlElement(name = "identifier-generator", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected List<JaxbGenericIdGenerator> genericGenerators;
    @XmlElement(name = "named-query", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected List<JaxbNamedQuery> namedQueries;
    @XmlElement(name = "named-native-query", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected List<JaxbNamedNativeQuery> namedNativeQueries;
    @XmlElement(name = "named-stored-procedure-query", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected List<JaxbNamedStoredProcedureQuery> namedProcedureQueries;
    @XmlElement(name = "sql-result-set-mapping", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected List<JaxbSqlResultSetMapping> sqlResultSetMappings;
    @XmlElement(name = "mapped-superclass", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected List<JaxbMappedSuperclass> mappedSuperclasses;
    @XmlElement(name = "entity", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected List<JaxbEntity> entities;
    @XmlElement(name = "embeddable", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected List<JaxbEmbeddable> embeddables;
    @XmlElement(name = "converter", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected List<JaxbConverter> converters;
    @XmlElement(name = "import", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected List<JaxbHqlImport> hqlImports;
    @XmlElement(name = "database-object", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected List<JaxbDatabaseObject> databaseObjects;
    @XmlAttribute(name = "version")
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    protected String version;

    /**
     * Gets the value of the description property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getDescription() {
        return description;
    }

    /**
     * Sets the value of the description property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setDescription(String value) {
        this.description = value;
    }

    /**
     * Gets the value of the persistenceUnitMetadata property.
     * 
     * @return
     *     possible object is
     *     {@link JaxbPersistenceUnitMetadata }
     *     
     */
    public JaxbPersistenceUnitMetadata getPersistenceUnitMetadata() {
        return persistenceUnitMetadata;
    }

    /**
     * Sets the value of the persistenceUnitMetadata property.
     * 
     * @param value
     *     allowed object is
     *     {@link JaxbPersistenceUnitMetadata }
     *     
     */
    public void setPersistenceUnitMetadata(JaxbPersistenceUnitMetadata value) {
        this.persistenceUnitMetadata = value;
    }

    /**
     * Gets the value of the package property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getPackage() {
        return _package;
    }

    /**
     * Sets the value of the package property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setPackage(String value) {
        this._package = value;
    }

    /**
     * Gets the value of the schema property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getSchema() {
        return schema;
    }

    /**
     * Sets the value of the schema property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setSchema(String value) {
        this.schema = value;
    }

    /**
     * Gets the value of the catalog property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getCatalog() {
        return catalog;
    }

    /**
     * Sets the value of the catalog property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setCatalog(String value) {
        this.catalog = value;
    }

    /**
     * Gets the value of the access property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public AccessType getAccess() {
        return access;
    }

    /**
     * Sets the value of the access property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setAccess(AccessType value) {
        this.access = value;
    }

    /**
     * Gets the value of the attributeAccessor property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getAttributeAccessor() {
        return attributeAccessor;
    }

    /**
     * Sets the value of the attributeAccessor property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setAttributeAccessor(String value) {
        this.attributeAccessor = value;
    }

    /**
     * Gets the value of the autoImport property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean isAutoImport() {
        return autoImport;
    }

    /**
     * Sets the value of the autoImport property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setAutoImport(Boolean value) {
        this.autoImport = value;
    }

    /**
     * Gets the value of the defaultCascade property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getDefaultCascade() {
        return defaultCascade;
    }

    /**
     * Sets the value of the defaultCascade property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setDefaultCascade(String value) {
        this.defaultCascade = value;
    }

    /**
     * Gets the value of the defaultLazy property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean isDefaultLazy() {
        return defaultLazy;
    }

    /**
     * Sets the value of the defaultLazy property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setDefaultLazy(Boolean value) {
        this.defaultLazy = value;
    }

    /**
     * Gets the value of the filterDefinitions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a <CODE>set</CODE> method for the filterDefinitions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getFilterDefinitions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbFilterDef }
     * 
     * 
     */
    public List<JaxbFilterDef> getFilterDefinitions() {
        if (filterDefinitions == null) {
            filterDefinitions = new ArrayList<JaxbFilterDef>();
        }
        return this.filterDefinitions;
    }

    /**
     * Gets the value of the fetchProfiles property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a <CODE>set</CODE> method for the fetchProfiles property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getFetchProfiles().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbFetchProfile }
     * 
     * 
     */
    public List<JaxbFetchProfile> getFetchProfiles() {
        if (fetchProfiles == null) {
            fetchProfiles = new ArrayList<JaxbFetchProfile>();
        }
        return this.fetchProfiles;
    }

    /**
     * Gets the value of the sequenceGenerator property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a <CODE>set</CODE> method for the sequenceGenerator property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSequenceGenerator().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbSequenceGenerator }
     * 
     * 
     */
    public List<JaxbSequenceGenerator> getSequenceGenerator() {
        if (sequenceGenerator == null) {
            sequenceGenerator = new ArrayList<JaxbSequenceGenerator>();
        }
        return this.sequenceGenerator;
    }

    /**
     * Gets the value of the tableGenerator property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a <CODE>set</CODE> method for the tableGenerator property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getTableGenerator().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbTableGenerator }
     * 
     * 
     */
    public List<JaxbTableGenerator> getTableGenerator() {
        if (tableGenerator == null) {
            tableGenerator = new ArrayList<JaxbTableGenerator>();
        }
        return this.tableGenerator;
    }

    /**
     * Gets the value of the genericGenerators property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a <CODE>set</CODE> method for the genericGenerators property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getGenericGenerators().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbGenericIdGenerator }
     * 
     * 
     */
    public List<JaxbGenericIdGenerator> getGenericGenerators() {
        if (genericGenerators == null) {
            genericGenerators = new ArrayList<JaxbGenericIdGenerator>();
        }
        return this.genericGenerators;
    }

    /**
     * Gets the value of the namedQueries property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a <CODE>set</CODE> method for the namedQueries property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getNamedQueries().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbNamedQuery }
     * 
     * 
     */
    public List<JaxbNamedQuery> getNamedQueries() {
        if (namedQueries == null) {
            namedQueries = new ArrayList<JaxbNamedQuery>();
        }
        return this.namedQueries;
    }

    /**
     * Gets the value of the namedNativeQueries property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a <CODE>set</CODE> method for the namedNativeQueries property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getNamedNativeQueries().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbNamedNativeQuery }
     * 
     * 
     */
    public List<JaxbNamedNativeQuery> getNamedNativeQueries() {
        if (namedNativeQueries == null) {
            namedNativeQueries = new ArrayList<JaxbNamedNativeQuery>();
        }
        return this.namedNativeQueries;
    }

    /**
     * Gets the value of the namedProcedureQueries property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a <CODE>set</CODE> method for the namedProcedureQueries property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getNamedProcedureQueries().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbNamedStoredProcedureQuery }
     * 
     * 
     */
    public List<JaxbNamedStoredProcedureQuery> getNamedProcedureQueries() {
        if (namedProcedureQueries == null) {
            namedProcedureQueries = new ArrayList<JaxbNamedStoredProcedureQuery>();
        }
        return this.namedProcedureQueries;
    }

    /**
     * Gets the value of the sqlResultSetMappings property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a <CODE>set</CODE> method for the sqlResultSetMappings property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSqlResultSetMappings().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbSqlResultSetMapping }
     * 
     * 
     */
    public List<JaxbSqlResultSetMapping> getSqlResultSetMappings() {
        if (sqlResultSetMappings == null) {
            sqlResultSetMappings = new ArrayList<JaxbSqlResultSetMapping>();
        }
        return this.sqlResultSetMappings;
    }

    /**
     * Gets the value of the mappedSuperclasses property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a <CODE>set</CODE> method for the mappedSuperclasses property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getMappedSuperclasses().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbMappedSuperclass }
     * 
     * 
     */
    public List<JaxbMappedSuperclass> getMappedSuperclasses() {
        if (mappedSuperclasses == null) {
            mappedSuperclasses = new ArrayList<JaxbMappedSuperclass>();
        }
        return this.mappedSuperclasses;
    }

    /**
     * Gets the value of the entities property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a <CODE>set</CODE> method for the entities property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getEntities().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbEntity }
     * 
     * 
     */
    public List<JaxbEntity> getEntities() {
        if (entities == null) {
            entities = new ArrayList<JaxbEntity>();
        }
        return this.entities;
    }

    /**
     * Gets the value of the embeddables property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a <CODE>set</CODE> method for the embeddables property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getEmbeddables().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbEmbeddable }
     * 
     * 
     */
    public List<JaxbEmbeddable> getEmbeddables() {
        if (embeddables == null) {
            embeddables = new ArrayList<JaxbEmbeddable>();
        }
        return this.embeddables;
    }

    /**
     * Gets the value of the converters property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a <CODE>set</CODE> method for the converters property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getConverters().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbConverter }
     * 
     * 
     */
    public List<JaxbConverter> getConverters() {
        if (converters == null) {
            converters = new ArrayList<JaxbConverter>();
        }
        return this.converters;
    }

    /**
     * Gets the value of the hqlImports property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a <CODE>set</CODE> method for the hqlImports property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getHqlImports().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbHqlImport }
     * 
     * 
     */
    public List<JaxbHqlImport> getHqlImports() {
        if (hqlImports == null) {
            hqlImports = new ArrayList<JaxbHqlImport>();
        }
        return this.hqlImports;
    }

    /**
     * Gets the value of the databaseObjects property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a <CODE>set</CODE> method for the databaseObjects property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getDatabaseObjects().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbDatabaseObject }
     * 
     * 
     */
    public List<JaxbDatabaseObject> getDatabaseObjects() {
        if (databaseObjects == null) {
            databaseObjects = new ArrayList<JaxbDatabaseObject>();
        }
        return this.databaseObjects;
    }

    /**
     * Gets the value of the version property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getVersion() {
        if (version == null) {
            return "3.1";
        } else {
            return version;
        }
    }

    /**
     * Sets the value of the version property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setVersion(String value) {
        this.version = value;
    }

}
