
package org.hibernate.boot.jaxb.mapping;

import java.io.Serializable;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.XmlValue;


/**
 * 
 *                 Maps a discriminator value to its corresponding entity name. E.g.:
 * 
 *                 <mapping value="e">com.acme.Employee</mapping>
 *             
 * 
 * <p>Java class for hbm-any-discriminator-value-mapping complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="hbm-any-discriminator-value-mapping"&gt;
 *   &lt;simpleContent&gt;
 *     &lt;extension base="&lt;http://www.w3.org/2001/XMLSchema&gt;string"&gt;
 *       &lt;attribute name="value" type="{http://www.w3.org/2001/XMLSchema}string" /&gt;
 *     &lt;/extension&gt;
 *   &lt;/simpleContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "hbm-any-discriminator-value-mapping", namespace = "http://www.hibernate.org/xsd/orm/mapping", propOrder = {
    "correspondingEntityName"
})
public class JaxbHbmAnyDiscriminatorValueMapping
    implements Serializable, DiscriminatorMapping
{

    @XmlValue
    protected String correspondingEntityName;
    @XmlAttribute(name = "value")
    protected String discriminatorValue;

    /**
     * Gets the value of the correspondingEntityName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getCorrespondingEntityName() {
        return correspondingEntityName;
    }

    /**
     * Sets the value of the correspondingEntityName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setCorrespondingEntityName(String value) {
        this.correspondingEntityName = value;
    }

    /**
     * Gets the value of the discriminatorValue property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getDiscriminatorValue() {
        return discriminatorValue;
    }

    /**
     * Sets the value of the discriminatorValue property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setDiscriminatorValue(String value) {
        this.discriminatorValue = value;
    }

}
