
/*
 * Hibernate, Relational Persistence for Idiomatic Java
 *
 * License: GNU Lesser General Public License (LGPL), version 2.1 or later.
 * See the lgpl.txt file in the root directory or <http://www.gnu.org/licenses/lgpl-2.1.html>.
 */
package org.hibernate.grammars.hql;

import org.antlr.v4.runtime.atn.*;
import org.antlr.v4.runtime.dfa.DFA;
import org.antlr.v4.runtime.*;
import org.antlr.v4.runtime.misc.*;
import org.antlr.v4.runtime.tree.*;
import java.util.List;
import java.util.Iterator;
import java.util.ArrayList;

@SuppressWarnings({"all", "warnings", "unchecked", "unused", "cast"})
public class HqlParser extends Parser {
	static { RuntimeMetaData.checkVersion("4.10.1", RuntimeMetaData.VERSION); }

	protected static final DFA[] _decisionToDFA;
	protected static final PredictionContextCache _sharedContextCache =
		new PredictionContextCache();
	public static final int
		WS=1, COMMENT=2, INTEGER_LITERAL=3, LONG_LITERAL=4, FLOAT_LITERAL=5, DOUBLE_LITERAL=6, 
		BIG_INTEGER_LITERAL=7, BIG_DECIMAL_LITERAL=8, HEX_LITERAL=9, STRING_LITERAL=10, 
		JAVA_STRING_LITERAL=11, BINARY_LITERAL=12, TIMESTAMP_ESCAPE_START=13, 
		DATE_ESCAPE_START=14, TIME_ESCAPE_START=15, EQUAL=16, NOT_EQUAL=17, GREATER=18, 
		GREATER_EQUAL=19, LESS=20, LESS_EQUAL=21, COMMA=22, DOT=23, LEFT_PAREN=24, 
		RIGHT_PAREN=25, LEFT_BRACKET=26, RIGHT_BRACKET=27, LEFT_BRACE=28, RIGHT_BRACE=29, 
		PLUS=30, MINUS=31, ASTERISK=32, SLASH=33, PERCENT_OP=34, AMPERSAND=35, 
		SEMICOLON=36, COLON=37, PIPE=38, DOUBLE_PIPE=39, QUESTION_MARK=40, ARROW=41, 
		ID=42, VERSION=43, VERSIONED=44, NATURALID=45, FK=46, ALL=47, AND=48, 
		ANY=49, AS=50, ASC=51, AVG=52, BETWEEN=53, BOTH=54, BY=55, CASE=56, CAST=57, 
		COLLATE=58, COUNT=59, CROSS=60, CUBE=61, CURRENT=62, CURRENT_DATE=63, 
		CURRENT_INSTANT=64, CURRENT_TIME=65, CURRENT_TIMESTAMP=66, DATE=67, DATETIME=68, 
		DAY=69, DELETE=70, DESC=71, DISTINCT=72, ELEMENT=73, ELEMENTS=74, ELSE=75, 
		EMPTY=76, END=77, ENTRY=78, ERROR=79, ESCAPE=80, EVERY=81, EXCEPT=82, 
		EXCLUDE=83, EXISTS=84, EXTRACT=85, FETCH=86, FILTER=87, FIRST=88, FOLLOWING=89, 
		FOR=90, FORMAT=91, FROM=92, FULL=93, FUNCTION=94, GROUP=95, GROUPS=96, 
		HAVING=97, HOUR=98, IGNORE=99, ILIKE=100, IN=101, INDEX=102, INDICES=103, 
		INNER=104, INSERT=105, INSTANT=106, INTERSECT=107, INTO=108, IS=109, JOIN=110, 
		KEY=111, LAST=112, LATERAL=113, LEADING=114, LEFT=115, LIKE=116, LIMIT=117, 
		LIST=118, LISTAGG=119, LOCAL=120, LOCAL_DATE=121, LOCAL_DATETIME=122, 
		LOCAL_TIME=123, MAP=124, MAX=125, MAXELEMENT=126, MAXINDEX=127, MEMBER=128, 
		MICROSECOND=129, MILLISECOND=130, MIN=131, MINELEMENT=132, MININDEX=133, 
		MINUTE=134, MONTH=135, NANOSECOND=136, NEW=137, NEXT=138, NO=139, NOT=140, 
		NULLS=141, OBJECT=142, OF=143, OFFSET=144, OFFSET_DATETIME=145, ON=146, 
		ONLY=147, OR=148, ORDER=149, OTHERS=150, OUTER=151, OVER=152, OVERFLOW=153, 
		OVERLAY=154, PAD=155, PARTITION=156, PERCENT=157, PLACING=158, POSITION=159, 
		PRECEDING=160, QUARTER=161, RANGE=162, RESPECT=163, RIGHT=164, ROLLUP=165, 
		ROW=166, ROWS=167, SECOND=168, SELECT=169, SET=170, SIZE=171, SOME=172, 
		SUBSTRING=173, SUM=174, THEN=175, TIES=176, TIME=177, TIMESTAMP=178, TIMEZONE_HOUR=179, 
		TIMEZONE_MINUTE=180, TRAILING=181, TREAT=182, TRIM=183, TRUNCATE=184, 
		TYPE=185, UNBOUNDED=186, UNION=187, UPDATE=188, VALUE=189, VALUES=190, 
		WEEK=191, WHEN=192, WHERE=193, WITH=194, WITHIN=195, WITHOUT=196, YEAR=197, 
		TRUE=198, FALSE=199, NULL=200, IDENTIFIER=201, QUOTED_IDENTIFIER=202;
	public static final int
		RULE_statement = 0, RULE_selectStatement = 1, RULE_subquery = 2, RULE_targetEntity = 3, 
		RULE_deleteStatement = 4, RULE_updateStatement = 5, RULE_setClause = 6, 
		RULE_assignment = 7, RULE_insertStatement = 8, RULE_targetFields = 9, 
		RULE_valuesList = 10, RULE_values = 11, RULE_queryExpression = 12, RULE_orderedQuery = 13, 
		RULE_setOperator = 14, RULE_queryOrder = 15, RULE_query = 16, RULE_fromClause = 17, 
		RULE_entityWithJoins = 18, RULE_fromRoot = 19, RULE_entityName = 20, RULE_variable = 21, 
		RULE_crossJoin = 22, RULE_jpaCollectionJoin = 23, RULE_join = 24, RULE_joinType = 25, 
		RULE_joinTarget = 26, RULE_joinRestriction = 27, RULE_selectClause = 28, 
		RULE_selectionList = 29, RULE_selection = 30, RULE_selectExpression = 31, 
		RULE_mapEntrySelection = 32, RULE_instantiation = 33, RULE_instantiationTarget = 34, 
		RULE_instantiationArguments = 35, RULE_instantiationArgument = 36, RULE_instantiationArgumentExpression = 37, 
		RULE_jpaSelectObjectSyntax = 38, RULE_simplePath = 39, RULE_simplePathElement = 40, 
		RULE_path = 41, RULE_pathContinuation = 42, RULE_syntacticDomainPath = 43, 
		RULE_generalPathFragment = 44, RULE_indexedPathAccessFragment = 45, RULE_treatedNavigablePath = 46, 
		RULE_collectionValueNavigablePath = 47, RULE_mapKeyNavigablePath = 48, 
		RULE_groupByClause = 49, RULE_groupByExpression = 50, RULE_havingClause = 51, 
		RULE_orderByClause = 52, RULE_orderByFragment = 53, RULE_sortSpecification = 54, 
		RULE_nullsPrecedence = 55, RULE_sortExpression = 56, RULE_sortDirection = 57, 
		RULE_collateFunction = 58, RULE_collation = 59, RULE_limitClause = 60, 
		RULE_offsetClause = 61, RULE_fetchClause = 62, RULE_parameterOrIntegerLiteral = 63, 
		RULE_parameterOrNumberLiteral = 64, RULE_whereClause = 65, RULE_predicate = 66, 
		RULE_comparisonOperator = 67, RULE_inList = 68, RULE_likeEscape = 69, 
		RULE_expression = 70, RULE_primaryExpression = 71, RULE_expressionOrPredicate = 72, 
		RULE_multiplicativeOperator = 73, RULE_additiveOperator = 74, RULE_signOperator = 75, 
		RULE_entityTypeReference = 76, RULE_entityIdReference = 77, RULE_entityVersionReference = 78, 
		RULE_entityNaturalIdReference = 79, RULE_toOneFkReference = 80, RULE_caseList = 81, 
		RULE_simpleCaseList = 82, RULE_simpleCaseWhen = 83, RULE_caseOtherwise = 84, 
		RULE_searchedCaseList = 85, RULE_searchedCaseWhen = 86, RULE_literal = 87, 
		RULE_booleanLiteral = 88, RULE_numericLiteral = 89, RULE_binaryLiteral = 90, 
		RULE_temporalLiteral = 91, RULE_dateTimeLiteral = 92, RULE_dateLiteral = 93, 
		RULE_timeLiteral = 94, RULE_dateTime = 95, RULE_date = 96, RULE_time = 97, 
		RULE_offset = 98, RULE_year = 99, RULE_month = 100, RULE_day = 101, RULE_hour = 102, 
		RULE_minute = 103, RULE_second = 104, RULE_zoneId = 105, RULE_jdbcTimestampLiteral = 106, 
		RULE_jdbcDateLiteral = 107, RULE_jdbcTimeLiteral = 108, RULE_genericTemporalLiteralText = 109, 
		RULE_generalizedLiteral = 110, RULE_generalizedLiteralType = 111, RULE_generalizedLiteralText = 112, 
		RULE_parameter = 113, RULE_function = 114, RULE_jpaNonstandardFunction = 115, 
		RULE_jpaNonstandardFunctionName = 116, RULE_genericFunction = 117, RULE_genericFunctionName = 118, 
		RULE_genericFunctionArguments = 119, RULE_collectionSizeFunction = 120, 
		RULE_indexAggregateFunction = 121, RULE_elementAggregateFunction = 122, 
		RULE_collectionFunctionMisuse = 123, RULE_aggregateFunction = 124, RULE_everyFunction = 125, 
		RULE_anyFunction = 126, RULE_listaggFunction = 127, RULE_onOverflowClause = 128, 
		RULE_withinGroupClause = 129, RULE_filterClause = 130, RULE_nullsClause = 131, 
		RULE_nthSideClause = 132, RULE_overClause = 133, RULE_partitionClause = 134, 
		RULE_frameClause = 135, RULE_frameStart = 136, RULE_frameEnd = 137, RULE_frameExclusion = 138, 
		RULE_standardFunction = 139, RULE_castFunction = 140, RULE_castTarget = 141, 
		RULE_castTargetType = 142, RULE_substringFunction = 143, RULE_substringFunctionStartArgument = 144, 
		RULE_substringFunctionLengthArgument = 145, RULE_trimFunction = 146, RULE_trimSpecification = 147, 
		RULE_trimCharacter = 148, RULE_padFunction = 149, RULE_padSpecification = 150, 
		RULE_padCharacter = 151, RULE_padLength = 152, RULE_overlayFunction = 153, 
		RULE_overlayFunctionStringArgument = 154, RULE_overlayFunctionReplacementArgument = 155, 
		RULE_overlayFunctionStartArgument = 156, RULE_overlayFunctionLengthArgument = 157, 
		RULE_currentDateFunction = 158, RULE_currentTimeFunction = 159, RULE_currentTimestampFunction = 160, 
		RULE_instantFunction = 161, RULE_localDateTimeFunction = 162, RULE_offsetDateTimeFunction = 163, 
		RULE_localDateFunction = 164, RULE_localTimeFunction = 165, RULE_formatFunction = 166, 
		RULE_format = 167, RULE_extractFunction = 168, RULE_extractField = 169, 
		RULE_datetimeField = 170, RULE_dayField = 171, RULE_weekField = 172, RULE_timeZoneField = 173, 
		RULE_dateOrTimeField = 174, RULE_positionFunction = 175, RULE_positionFunctionPatternArgument = 176, 
		RULE_positionFunctionStringArgument = 177, RULE_cube = 178, RULE_rollup = 179, 
		RULE_nakedIdentifier = 180, RULE_identifier = 181;
	private static String[] makeRuleNames() {
		return new String[] {
			"statement", "selectStatement", "subquery", "targetEntity", "deleteStatement", 
			"updateStatement", "setClause", "assignment", "insertStatement", "targetFields", 
			"valuesList", "values", "queryExpression", "orderedQuery", "setOperator", 
			"queryOrder", "query", "fromClause", "entityWithJoins", "fromRoot", "entityName", 
			"variable", "crossJoin", "jpaCollectionJoin", "join", "joinType", "joinTarget", 
			"joinRestriction", "selectClause", "selectionList", "selection", "selectExpression", 
			"mapEntrySelection", "instantiation", "instantiationTarget", "instantiationArguments", 
			"instantiationArgument", "instantiationArgumentExpression", "jpaSelectObjectSyntax", 
			"simplePath", "simplePathElement", "path", "pathContinuation", "syntacticDomainPath", 
			"generalPathFragment", "indexedPathAccessFragment", "treatedNavigablePath", 
			"collectionValueNavigablePath", "mapKeyNavigablePath", "groupByClause", 
			"groupByExpression", "havingClause", "orderByClause", "orderByFragment", 
			"sortSpecification", "nullsPrecedence", "sortExpression", "sortDirection", 
			"collateFunction", "collation", "limitClause", "offsetClause", "fetchClause", 
			"parameterOrIntegerLiteral", "parameterOrNumberLiteral", "whereClause", 
			"predicate", "comparisonOperator", "inList", "likeEscape", "expression", 
			"primaryExpression", "expressionOrPredicate", "multiplicativeOperator", 
			"additiveOperator", "signOperator", "entityTypeReference", "entityIdReference", 
			"entityVersionReference", "entityNaturalIdReference", "toOneFkReference", 
			"caseList", "simpleCaseList", "simpleCaseWhen", "caseOtherwise", "searchedCaseList", 
			"searchedCaseWhen", "literal", "booleanLiteral", "numericLiteral", "binaryLiteral", 
			"temporalLiteral", "dateTimeLiteral", "dateLiteral", "timeLiteral", "dateTime", 
			"date", "time", "offset", "year", "month", "day", "hour", "minute", "second", 
			"zoneId", "jdbcTimestampLiteral", "jdbcDateLiteral", "jdbcTimeLiteral", 
			"genericTemporalLiteralText", "generalizedLiteral", "generalizedLiteralType", 
			"generalizedLiteralText", "parameter", "function", "jpaNonstandardFunction", 
			"jpaNonstandardFunctionName", "genericFunction", "genericFunctionName", 
			"genericFunctionArguments", "collectionSizeFunction", "indexAggregateFunction", 
			"elementAggregateFunction", "collectionFunctionMisuse", "aggregateFunction", 
			"everyFunction", "anyFunction", "listaggFunction", "onOverflowClause", 
			"withinGroupClause", "filterClause", "nullsClause", "nthSideClause", 
			"overClause", "partitionClause", "frameClause", "frameStart", "frameEnd", 
			"frameExclusion", "standardFunction", "castFunction", "castTarget", "castTargetType", 
			"substringFunction", "substringFunctionStartArgument", "substringFunctionLengthArgument", 
			"trimFunction", "trimSpecification", "trimCharacter", "padFunction", 
			"padSpecification", "padCharacter", "padLength", "overlayFunction", "overlayFunctionStringArgument", 
			"overlayFunctionReplacementArgument", "overlayFunctionStartArgument", 
			"overlayFunctionLengthArgument", "currentDateFunction", "currentTimeFunction", 
			"currentTimestampFunction", "instantFunction", "localDateTimeFunction", 
			"offsetDateTimeFunction", "localDateFunction", "localTimeFunction", "formatFunction", 
			"format", "extractFunction", "extractField", "datetimeField", "dayField", 
			"weekField", "timeZoneField", "dateOrTimeField", "positionFunction", 
			"positionFunctionPatternArgument", "positionFunctionStringArgument", 
			"cube", "rollup", "nakedIdentifier", "identifier"
		};
	}
	public static final String[] ruleNames = makeRuleNames();

	private static String[] makeLiteralNames() {
		return new String[] {
			null, null, null, null, null, null, null, null, null, null, null, null, 
			null, "'{ts'", "'{d'", "'{t'", "'='", null, "'>'", "'>='", "'<'", "'<='", 
			"','", "'.'", "'('", "')'", "'['", "']'", "'{'", "'}'", "'+'", "'-'", 
			"'*'", "'/'", "'%'", "'&'", "';'", "':'", "'|'", "'||'", "'?'", "'->'"
		};
	}
	private static final String[] _LITERAL_NAMES = makeLiteralNames();
	private static String[] makeSymbolicNames() {
		return new String[] {
			null, "WS", "COMMENT", "INTEGER_LITERAL", "LONG_LITERAL", "FLOAT_LITERAL", 
			"DOUBLE_LITERAL", "BIG_INTEGER_LITERAL", "BIG_DECIMAL_LITERAL", "HEX_LITERAL", 
			"STRING_LITERAL", "JAVA_STRING_LITERAL", "BINARY_LITERAL", "TIMESTAMP_ESCAPE_START", 
			"DATE_ESCAPE_START", "TIME_ESCAPE_START", "EQUAL", "NOT_EQUAL", "GREATER", 
			"GREATER_EQUAL", "LESS", "LESS_EQUAL", "COMMA", "DOT", "LEFT_PAREN", 
			"RIGHT_PAREN", "LEFT_BRACKET", "RIGHT_BRACKET", "LEFT_BRACE", "RIGHT_BRACE", 
			"PLUS", "MINUS", "ASTERISK", "SLASH", "PERCENT_OP", "AMPERSAND", "SEMICOLON", 
			"COLON", "PIPE", "DOUBLE_PIPE", "QUESTION_MARK", "ARROW", "ID", "VERSION", 
			"VERSIONED", "NATURALID", "FK", "ALL", "AND", "ANY", "AS", "ASC", "AVG", 
			"BETWEEN", "BOTH", "BY", "CASE", "CAST", "COLLATE", "COUNT", "CROSS", 
			"CUBE", "CURRENT", "CURRENT_DATE", "CURRENT_INSTANT", "CURRENT_TIME", 
			"CURRENT_TIMESTAMP", "DATE", "DATETIME", "DAY", "DELETE", "DESC", "DISTINCT", 
			"ELEMENT", "ELEMENTS", "ELSE", "EMPTY", "END", "ENTRY", "ERROR", "ESCAPE", 
			"EVERY", "EXCEPT", "EXCLUDE", "EXISTS", "EXTRACT", "FETCH", "FILTER", 
			"FIRST", "FOLLOWING", "FOR", "FORMAT", "FROM", "FULL", "FUNCTION", "GROUP", 
			"GROUPS", "HAVING", "HOUR", "IGNORE", "ILIKE", "IN", "INDEX", "INDICES", 
			"INNER", "INSERT", "INSTANT", "INTERSECT", "INTO", "IS", "JOIN", "KEY", 
			"LAST", "LATERAL", "LEADING", "LEFT", "LIKE", "LIMIT", "LIST", "LISTAGG", 
			"LOCAL", "LOCAL_DATE", "LOCAL_DATETIME", "LOCAL_TIME", "MAP", "MAX", 
			"MAXELEMENT", "MAXINDEX", "MEMBER", "MICROSECOND", "MILLISECOND", "MIN", 
			"MINELEMENT", "MININDEX", "MINUTE", "MONTH", "NANOSECOND", "NEW", "NEXT", 
			"NO", "NOT", "NULLS", "OBJECT", "OF", "OFFSET", "OFFSET_DATETIME", "ON", 
			"ONLY", "OR", "ORDER", "OTHERS", "OUTER", "OVER", "OVERFLOW", "OVERLAY", 
			"PAD", "PARTITION", "PERCENT", "PLACING", "POSITION", "PRECEDING", "QUARTER", 
			"RANGE", "RESPECT", "RIGHT", "ROLLUP", "ROW", "ROWS", "SECOND", "SELECT", 
			"SET", "SIZE", "SOME", "SUBSTRING", "SUM", "THEN", "TIES", "TIME", "TIMESTAMP", 
			"TIMEZONE_HOUR", "TIMEZONE_MINUTE", "TRAILING", "TREAT", "TRIM", "TRUNCATE", 
			"TYPE", "UNBOUNDED", "UNION", "UPDATE", "VALUE", "VALUES", "WEEK", "WHEN", 
			"WHERE", "WITH", "WITHIN", "WITHOUT", "YEAR", "TRUE", "FALSE", "NULL", 
			"IDENTIFIER", "QUOTED_IDENTIFIER"
		};
	}
	private static final String[] _SYMBOLIC_NAMES = makeSymbolicNames();
	public static final Vocabulary VOCABULARY = new VocabularyImpl(_LITERAL_NAMES, _SYMBOLIC_NAMES);

	/**
	 * @deprecated Use {@link #VOCABULARY} instead.
	 */
	@Deprecated
	public static final String[] tokenNames;
	static {
		tokenNames = new String[_SYMBOLIC_NAMES.length];
		for (int i = 0; i < tokenNames.length; i++) {
			tokenNames[i] = VOCABULARY.getLiteralName(i);
			if (tokenNames[i] == null) {
				tokenNames[i] = VOCABULARY.getSymbolicName(i);
			}

			if (tokenNames[i] == null) {
				tokenNames[i] = "<INVALID>";
			}
		}
	}

	@Override
	@Deprecated
	public String[] getTokenNames() {
		return tokenNames;
	}

	@Override

	public Vocabulary getVocabulary() {
		return VOCABULARY;
	}

	@Override
	public String getGrammarFileName() { return "HqlParser.g4"; }

	@Override
	public String[] getRuleNames() { return ruleNames; }

	@Override
	public String getSerializedATN() { return _serializedATN; }

	@Override
	public ATN getATN() { return _ATN; }


		protected void logUseOfReservedWordAsIdentifier(Token token) {
		}

	public HqlParser(TokenStream input) {
		super(input);
		_interp = new ParserATNSimulator(this,_ATN,_decisionToDFA,_sharedContextCache);
	}

	public static class StatementContext extends ParserRuleContext {
		public TerminalNode EOF() { return getToken(HqlParser.EOF, 0); }
		public SelectStatementContext selectStatement() {
			return getRuleContext(SelectStatementContext.class,0);
		}
		public UpdateStatementContext updateStatement() {
			return getRuleContext(UpdateStatementContext.class,0);
		}
		public DeleteStatementContext deleteStatement() {
			return getRuleContext(DeleteStatementContext.class,0);
		}
		public InsertStatementContext insertStatement() {
			return getRuleContext(InsertStatementContext.class,0);
		}
		public StatementContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_statement; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterStatement(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitStatement(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitStatement(this);
			else return visitor.visitChildren(this);
		}
	}

	public final StatementContext statement() throws RecognitionException {
		StatementContext _localctx = new StatementContext(_ctx, getState());
		enterRule(_localctx, 0, RULE_statement);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(368);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case LEFT_PAREN:
			case FROM:
			case SELECT:
				{
				setState(364);
				selectStatement();
				}
				break;
			case UPDATE:
				{
				setState(365);
				updateStatement();
				}
				break;
			case DELETE:
				{
				setState(366);
				deleteStatement();
				}
				break;
			case INSERT:
				{
				setState(367);
				insertStatement();
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
			setState(370);
			match(EOF);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class SelectStatementContext extends ParserRuleContext {
		public QueryExpressionContext queryExpression() {
			return getRuleContext(QueryExpressionContext.class,0);
		}
		public SelectStatementContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_selectStatement; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSelectStatement(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSelectStatement(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSelectStatement(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SelectStatementContext selectStatement() throws RecognitionException {
		SelectStatementContext _localctx = new SelectStatementContext(_ctx, getState());
		enterRule(_localctx, 2, RULE_selectStatement);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(372);
			queryExpression();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class SubqueryContext extends ParserRuleContext {
		public QueryExpressionContext queryExpression() {
			return getRuleContext(QueryExpressionContext.class,0);
		}
		public SubqueryContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_subquery; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSubquery(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSubquery(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSubquery(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SubqueryContext subquery() throws RecognitionException {
		SubqueryContext _localctx = new SubqueryContext(_ctx, getState());
		enterRule(_localctx, 4, RULE_subquery);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(374);
			queryExpression();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class TargetEntityContext extends ParserRuleContext {
		public EntityNameContext entityName() {
			return getRuleContext(EntityNameContext.class,0);
		}
		public VariableContext variable() {
			return getRuleContext(VariableContext.class,0);
		}
		public TargetEntityContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_targetEntity; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterTargetEntity(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitTargetEntity(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitTargetEntity(this);
			else return visitor.visitChildren(this);
		}
	}

	public final TargetEntityContext targetEntity() throws RecognitionException {
		TargetEntityContext _localctx = new TargetEntityContext(_ctx, getState());
		enterRule(_localctx, 6, RULE_targetEntity);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(376);
			entityName();
			setState(378);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,1,_ctx) ) {
			case 1:
				{
				setState(377);
				variable();
				}
				break;
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class DeleteStatementContext extends ParserRuleContext {
		public TerminalNode DELETE() { return getToken(HqlParser.DELETE, 0); }
		public TargetEntityContext targetEntity() {
			return getRuleContext(TargetEntityContext.class,0);
		}
		public TerminalNode FROM() { return getToken(HqlParser.FROM, 0); }
		public WhereClauseContext whereClause() {
			return getRuleContext(WhereClauseContext.class,0);
		}
		public DeleteStatementContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_deleteStatement; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterDeleteStatement(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitDeleteStatement(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitDeleteStatement(this);
			else return visitor.visitChildren(this);
		}
	}

	public final DeleteStatementContext deleteStatement() throws RecognitionException {
		DeleteStatementContext _localctx = new DeleteStatementContext(_ctx, getState());
		enterRule(_localctx, 8, RULE_deleteStatement);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(380);
			match(DELETE);
			setState(382);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,2,_ctx) ) {
			case 1:
				{
				setState(381);
				match(FROM);
				}
				break;
			}
			setState(384);
			targetEntity();
			setState(386);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==WHERE) {
				{
				setState(385);
				whereClause();
				}
			}

			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class UpdateStatementContext extends ParserRuleContext {
		public TerminalNode UPDATE() { return getToken(HqlParser.UPDATE, 0); }
		public TargetEntityContext targetEntity() {
			return getRuleContext(TargetEntityContext.class,0);
		}
		public SetClauseContext setClause() {
			return getRuleContext(SetClauseContext.class,0);
		}
		public TerminalNode VERSIONED() { return getToken(HqlParser.VERSIONED, 0); }
		public WhereClauseContext whereClause() {
			return getRuleContext(WhereClauseContext.class,0);
		}
		public UpdateStatementContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_updateStatement; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterUpdateStatement(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitUpdateStatement(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitUpdateStatement(this);
			else return visitor.visitChildren(this);
		}
	}

	public final UpdateStatementContext updateStatement() throws RecognitionException {
		UpdateStatementContext _localctx = new UpdateStatementContext(_ctx, getState());
		enterRule(_localctx, 10, RULE_updateStatement);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(388);
			match(UPDATE);
			setState(390);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,4,_ctx) ) {
			case 1:
				{
				setState(389);
				match(VERSIONED);
				}
				break;
			}
			setState(392);
			targetEntity();
			setState(393);
			setClause();
			setState(395);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==WHERE) {
				{
				setState(394);
				whereClause();
				}
			}

			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class SetClauseContext extends ParserRuleContext {
		public TerminalNode SET() { return getToken(HqlParser.SET, 0); }
		public List<AssignmentContext> assignment() {
			return getRuleContexts(AssignmentContext.class);
		}
		public AssignmentContext assignment(int i) {
			return getRuleContext(AssignmentContext.class,i);
		}
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public SetClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_setClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSetClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSetClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSetClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SetClauseContext setClause() throws RecognitionException {
		SetClauseContext _localctx = new SetClauseContext(_ctx, getState());
		enterRule(_localctx, 12, RULE_setClause);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(397);
			match(SET);
			setState(398);
			assignment();
			setState(403);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==COMMA) {
				{
				{
				setState(399);
				match(COMMA);
				setState(400);
				assignment();
				}
				}
				setState(405);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class AssignmentContext extends ParserRuleContext {
		public SimplePathContext simplePath() {
			return getRuleContext(SimplePathContext.class,0);
		}
		public TerminalNode EQUAL() { return getToken(HqlParser.EQUAL, 0); }
		public ExpressionOrPredicateContext expressionOrPredicate() {
			return getRuleContext(ExpressionOrPredicateContext.class,0);
		}
		public AssignmentContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_assignment; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterAssignment(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitAssignment(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitAssignment(this);
			else return visitor.visitChildren(this);
		}
	}

	public final AssignmentContext assignment() throws RecognitionException {
		AssignmentContext _localctx = new AssignmentContext(_ctx, getState());
		enterRule(_localctx, 14, RULE_assignment);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(406);
			simplePath();
			setState(407);
			match(EQUAL);
			setState(408);
			expressionOrPredicate();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class InsertStatementContext extends ParserRuleContext {
		public TerminalNode INSERT() { return getToken(HqlParser.INSERT, 0); }
		public TargetEntityContext targetEntity() {
			return getRuleContext(TargetEntityContext.class,0);
		}
		public TargetFieldsContext targetFields() {
			return getRuleContext(TargetFieldsContext.class,0);
		}
		public QueryExpressionContext queryExpression() {
			return getRuleContext(QueryExpressionContext.class,0);
		}
		public ValuesListContext valuesList() {
			return getRuleContext(ValuesListContext.class,0);
		}
		public TerminalNode INTO() { return getToken(HqlParser.INTO, 0); }
		public InsertStatementContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_insertStatement; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterInsertStatement(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitInsertStatement(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitInsertStatement(this);
			else return visitor.visitChildren(this);
		}
	}

	public final InsertStatementContext insertStatement() throws RecognitionException {
		InsertStatementContext _localctx = new InsertStatementContext(_ctx, getState());
		enterRule(_localctx, 16, RULE_insertStatement);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(410);
			match(INSERT);
			setState(412);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,7,_ctx) ) {
			case 1:
				{
				setState(411);
				match(INTO);
				}
				break;
			}
			setState(414);
			targetEntity();
			setState(415);
			targetFields();
			setState(418);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case LEFT_PAREN:
			case FROM:
			case SELECT:
				{
				setState(416);
				queryExpression();
				}
				break;
			case VALUES:
				{
				setState(417);
				valuesList();
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class TargetFieldsContext extends ParserRuleContext {
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public List<SimplePathContext> simplePath() {
			return getRuleContexts(SimplePathContext.class);
		}
		public SimplePathContext simplePath(int i) {
			return getRuleContext(SimplePathContext.class,i);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public TargetFieldsContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_targetFields; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterTargetFields(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitTargetFields(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitTargetFields(this);
			else return visitor.visitChildren(this);
		}
	}

	public final TargetFieldsContext targetFields() throws RecognitionException {
		TargetFieldsContext _localctx = new TargetFieldsContext(_ctx, getState());
		enterRule(_localctx, 18, RULE_targetFields);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(420);
			match(LEFT_PAREN);
			setState(421);
			simplePath();
			setState(426);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==COMMA) {
				{
				{
				setState(422);
				match(COMMA);
				setState(423);
				simplePath();
				}
				}
				setState(428);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			setState(429);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class ValuesListContext extends ParserRuleContext {
		public TerminalNode VALUES() { return getToken(HqlParser.VALUES, 0); }
		public List<ValuesContext> values() {
			return getRuleContexts(ValuesContext.class);
		}
		public ValuesContext values(int i) {
			return getRuleContext(ValuesContext.class,i);
		}
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public ValuesListContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_valuesList; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterValuesList(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitValuesList(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitValuesList(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ValuesListContext valuesList() throws RecognitionException {
		ValuesListContext _localctx = new ValuesListContext(_ctx, getState());
		enterRule(_localctx, 20, RULE_valuesList);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(431);
			match(VALUES);
			setState(432);
			values();
			setState(437);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==COMMA) {
				{
				{
				setState(433);
				match(COMMA);
				setState(434);
				values();
				}
				}
				setState(439);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class ValuesContext extends ParserRuleContext {
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public List<ExpressionOrPredicateContext> expressionOrPredicate() {
			return getRuleContexts(ExpressionOrPredicateContext.class);
		}
		public ExpressionOrPredicateContext expressionOrPredicate(int i) {
			return getRuleContext(ExpressionOrPredicateContext.class,i);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public ValuesContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_values; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterValues(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitValues(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitValues(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ValuesContext values() throws RecognitionException {
		ValuesContext _localctx = new ValuesContext(_ctx, getState());
		enterRule(_localctx, 22, RULE_values);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(440);
			match(LEFT_PAREN);
			setState(441);
			expressionOrPredicate();
			setState(446);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==COMMA) {
				{
				{
				setState(442);
				match(COMMA);
				setState(443);
				expressionOrPredicate();
				}
				}
				setState(448);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			setState(449);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class QueryExpressionContext extends ParserRuleContext {
		public QueryExpressionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_queryExpression; }
	 
		public QueryExpressionContext() { }
		public void copyFrom(QueryExpressionContext ctx) {
			super.copyFrom(ctx);
		}
	}
	public static class SetQueryGroupContext extends QueryExpressionContext {
		public List<OrderedQueryContext> orderedQuery() {
			return getRuleContexts(OrderedQueryContext.class);
		}
		public OrderedQueryContext orderedQuery(int i) {
			return getRuleContext(OrderedQueryContext.class,i);
		}
		public List<SetOperatorContext> setOperator() {
			return getRuleContexts(SetOperatorContext.class);
		}
		public SetOperatorContext setOperator(int i) {
			return getRuleContext(SetOperatorContext.class,i);
		}
		public SetQueryGroupContext(QueryExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSetQueryGroup(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSetQueryGroup(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSetQueryGroup(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class SimpleQueryGroupContext extends QueryExpressionContext {
		public OrderedQueryContext orderedQuery() {
			return getRuleContext(OrderedQueryContext.class,0);
		}
		public SimpleQueryGroupContext(QueryExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSimpleQueryGroup(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSimpleQueryGroup(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSimpleQueryGroup(this);
			else return visitor.visitChildren(this);
		}
	}

	public final QueryExpressionContext queryExpression() throws RecognitionException {
		QueryExpressionContext _localctx = new QueryExpressionContext(_ctx, getState());
		enterRule(_localctx, 24, RULE_queryExpression);
		int _la;
		try {
			setState(460);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,13,_ctx) ) {
			case 1:
				_localctx = new SimpleQueryGroupContext(_localctx);
				enterOuterAlt(_localctx, 1);
				{
				setState(451);
				orderedQuery();
				}
				break;
			case 2:
				_localctx = new SetQueryGroupContext(_localctx);
				enterOuterAlt(_localctx, 2);
				{
				setState(452);
				orderedQuery();
				setState(456); 
				_errHandler.sync(this);
				_la = _input.LA(1);
				do {
					{
					{
					setState(453);
					setOperator();
					setState(454);
					orderedQuery();
					}
					}
					setState(458); 
					_errHandler.sync(this);
					_la = _input.LA(1);
				} while ( _la==EXCEPT || _la==INTERSECT || _la==UNION );
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class OrderedQueryContext extends ParserRuleContext {
		public OrderedQueryContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_orderedQuery; }
	 
		public OrderedQueryContext() { }
		public void copyFrom(OrderedQueryContext ctx) {
			super.copyFrom(ctx);
		}
	}
	public static class QuerySpecExpressionContext extends OrderedQueryContext {
		public QueryContext query() {
			return getRuleContext(QueryContext.class,0);
		}
		public QueryOrderContext queryOrder() {
			return getRuleContext(QueryOrderContext.class,0);
		}
		public QuerySpecExpressionContext(OrderedQueryContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterQuerySpecExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitQuerySpecExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitQuerySpecExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class NestedQueryExpressionContext extends OrderedQueryContext {
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public QueryExpressionContext queryExpression() {
			return getRuleContext(QueryExpressionContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public QueryOrderContext queryOrder() {
			return getRuleContext(QueryOrderContext.class,0);
		}
		public NestedQueryExpressionContext(OrderedQueryContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterNestedQueryExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitNestedQueryExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitNestedQueryExpression(this);
			else return visitor.visitChildren(this);
		}
	}

	public final OrderedQueryContext orderedQuery() throws RecognitionException {
		OrderedQueryContext _localctx = new OrderedQueryContext(_ctx, getState());
		enterRule(_localctx, 26, RULE_orderedQuery);
		int _la;
		try {
			setState(472);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case FROM:
			case SELECT:
				_localctx = new QuerySpecExpressionContext(_localctx);
				enterOuterAlt(_localctx, 1);
				{
				setState(462);
				query();
				setState(464);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==ORDER) {
					{
					setState(463);
					queryOrder();
					}
				}

				}
				break;
			case LEFT_PAREN:
				_localctx = new NestedQueryExpressionContext(_localctx);
				enterOuterAlt(_localctx, 2);
				{
				setState(466);
				match(LEFT_PAREN);
				setState(467);
				queryExpression();
				setState(468);
				match(RIGHT_PAREN);
				setState(470);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==ORDER) {
					{
					setState(469);
					queryOrder();
					}
				}

				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class SetOperatorContext extends ParserRuleContext {
		public TerminalNode UNION() { return getToken(HqlParser.UNION, 0); }
		public TerminalNode ALL() { return getToken(HqlParser.ALL, 0); }
		public TerminalNode INTERSECT() { return getToken(HqlParser.INTERSECT, 0); }
		public TerminalNode EXCEPT() { return getToken(HqlParser.EXCEPT, 0); }
		public SetOperatorContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_setOperator; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSetOperator(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSetOperator(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSetOperator(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SetOperatorContext setOperator() throws RecognitionException {
		SetOperatorContext _localctx = new SetOperatorContext(_ctx, getState());
		enterRule(_localctx, 28, RULE_setOperator);
		int _la;
		try {
			setState(486);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case UNION:
				enterOuterAlt(_localctx, 1);
				{
				setState(474);
				match(UNION);
				setState(476);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==ALL) {
					{
					setState(475);
					match(ALL);
					}
				}

				}
				break;
			case INTERSECT:
				enterOuterAlt(_localctx, 2);
				{
				setState(478);
				match(INTERSECT);
				setState(480);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==ALL) {
					{
					setState(479);
					match(ALL);
					}
				}

				}
				break;
			case EXCEPT:
				enterOuterAlt(_localctx, 3);
				{
				setState(482);
				match(EXCEPT);
				setState(484);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==ALL) {
					{
					setState(483);
					match(ALL);
					}
				}

				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class QueryOrderContext extends ParserRuleContext {
		public OrderByClauseContext orderByClause() {
			return getRuleContext(OrderByClauseContext.class,0);
		}
		public LimitClauseContext limitClause() {
			return getRuleContext(LimitClauseContext.class,0);
		}
		public OffsetClauseContext offsetClause() {
			return getRuleContext(OffsetClauseContext.class,0);
		}
		public FetchClauseContext fetchClause() {
			return getRuleContext(FetchClauseContext.class,0);
		}
		public QueryOrderContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_queryOrder; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterQueryOrder(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitQueryOrder(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitQueryOrder(this);
			else return visitor.visitChildren(this);
		}
	}

	public final QueryOrderContext queryOrder() throws RecognitionException {
		QueryOrderContext _localctx = new QueryOrderContext(_ctx, getState());
		enterRule(_localctx, 30, RULE_queryOrder);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(488);
			orderByClause();
			setState(490);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==LIMIT) {
				{
				setState(489);
				limitClause();
				}
			}

			setState(493);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==OFFSET) {
				{
				setState(492);
				offsetClause();
				}
			}

			setState(496);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==FETCH) {
				{
				setState(495);
				fetchClause();
				}
			}

			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class QueryContext extends ParserRuleContext {
		public SelectClauseContext selectClause() {
			return getRuleContext(SelectClauseContext.class,0);
		}
		public FromClauseContext fromClause() {
			return getRuleContext(FromClauseContext.class,0);
		}
		public WhereClauseContext whereClause() {
			return getRuleContext(WhereClauseContext.class,0);
		}
		public GroupByClauseContext groupByClause() {
			return getRuleContext(GroupByClauseContext.class,0);
		}
		public HavingClauseContext havingClause() {
			return getRuleContext(HavingClauseContext.class,0);
		}
		public QueryContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_query; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterQuery(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitQuery(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitQuery(this);
			else return visitor.visitChildren(this);
		}
	}

	public final QueryContext query() throws RecognitionException {
		QueryContext _localctx = new QueryContext(_ctx, getState());
		enterRule(_localctx, 32, RULE_query);
		int _la;
		try {
			setState(524);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case SELECT:
				enterOuterAlt(_localctx, 1);
				{
				setState(498);
				selectClause();
				setState(500);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==FROM) {
					{
					setState(499);
					fromClause();
					}
				}

				setState(503);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==WHERE) {
					{
					setState(502);
					whereClause();
					}
				}

				setState(509);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==GROUP) {
					{
					setState(505);
					groupByClause();
					setState(507);
					_errHandler.sync(this);
					_la = _input.LA(1);
					if (_la==HAVING) {
						{
						setState(506);
						havingClause();
						}
					}

					}
				}

				}
				break;
			case FROM:
				enterOuterAlt(_localctx, 2);
				{
				setState(511);
				fromClause();
				setState(513);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==WHERE) {
					{
					setState(512);
					whereClause();
					}
				}

				setState(519);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==GROUP) {
					{
					setState(515);
					groupByClause();
					setState(517);
					_errHandler.sync(this);
					_la = _input.LA(1);
					if (_la==HAVING) {
						{
						setState(516);
						havingClause();
						}
					}

					}
				}

				setState(522);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==SELECT) {
					{
					setState(521);
					selectClause();
					}
				}

				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class FromClauseContext extends ParserRuleContext {
		public TerminalNode FROM() { return getToken(HqlParser.FROM, 0); }
		public List<EntityWithJoinsContext> entityWithJoins() {
			return getRuleContexts(EntityWithJoinsContext.class);
		}
		public EntityWithJoinsContext entityWithJoins(int i) {
			return getRuleContext(EntityWithJoinsContext.class,i);
		}
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public FromClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_fromClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterFromClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitFromClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitFromClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final FromClauseContext fromClause() throws RecognitionException {
		FromClauseContext _localctx = new FromClauseContext(_ctx, getState());
		enterRule(_localctx, 34, RULE_fromClause);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(526);
			match(FROM);
			setState(527);
			entityWithJoins();
			setState(532);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==COMMA) {
				{
				{
				setState(528);
				match(COMMA);
				setState(529);
				entityWithJoins();
				}
				}
				setState(534);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class EntityWithJoinsContext extends ParserRuleContext {
		public FromRootContext fromRoot() {
			return getRuleContext(FromRootContext.class,0);
		}
		public List<JoinContext> join() {
			return getRuleContexts(JoinContext.class);
		}
		public JoinContext join(int i) {
			return getRuleContext(JoinContext.class,i);
		}
		public List<CrossJoinContext> crossJoin() {
			return getRuleContexts(CrossJoinContext.class);
		}
		public CrossJoinContext crossJoin(int i) {
			return getRuleContext(CrossJoinContext.class,i);
		}
		public List<JpaCollectionJoinContext> jpaCollectionJoin() {
			return getRuleContexts(JpaCollectionJoinContext.class);
		}
		public JpaCollectionJoinContext jpaCollectionJoin(int i) {
			return getRuleContext(JpaCollectionJoinContext.class,i);
		}
		public EntityWithJoinsContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_entityWithJoins; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterEntityWithJoins(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitEntityWithJoins(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitEntityWithJoins(this);
			else return visitor.visitChildren(this);
		}
	}

	public final EntityWithJoinsContext entityWithJoins() throws RecognitionException {
		EntityWithJoinsContext _localctx = new EntityWithJoinsContext(_ctx, getState());
		enterRule(_localctx, 36, RULE_entityWithJoins);
		try {
			int _alt;
			enterOuterAlt(_localctx, 1);
			{
			setState(535);
			fromRoot();
			setState(541);
			_errHandler.sync(this);
			_alt = getInterpreter().adaptivePredict(_input,35,_ctx);
			while ( _alt!=2 && _alt!=org.antlr.v4.runtime.atn.ATN.INVALID_ALT_NUMBER ) {
				if ( _alt==1 ) {
					{
					setState(539);
					_errHandler.sync(this);
					switch (_input.LA(1)) {
					case FULL:
					case INNER:
					case JOIN:
					case LEFT:
					case OUTER:
					case RIGHT:
						{
						setState(536);
						join();
						}
						break;
					case CROSS:
						{
						setState(537);
						crossJoin();
						}
						break;
					case COMMA:
						{
						setState(538);
						jpaCollectionJoin();
						}
						break;
					default:
						throw new NoViableAltException(this);
					}
					} 
				}
				setState(543);
				_errHandler.sync(this);
				_alt = getInterpreter().adaptivePredict(_input,35,_ctx);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class FromRootContext extends ParserRuleContext {
		public FromRootContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_fromRoot; }
	 
		public FromRootContext() { }
		public void copyFrom(FromRootContext ctx) {
			super.copyFrom(ctx);
		}
	}
	public static class RootSubqueryContext extends FromRootContext {
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public SubqueryContext subquery() {
			return getRuleContext(SubqueryContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public VariableContext variable() {
			return getRuleContext(VariableContext.class,0);
		}
		public RootSubqueryContext(FromRootContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterRootSubquery(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitRootSubquery(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitRootSubquery(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class RootEntityContext extends FromRootContext {
		public EntityNameContext entityName() {
			return getRuleContext(EntityNameContext.class,0);
		}
		public VariableContext variable() {
			return getRuleContext(VariableContext.class,0);
		}
		public RootEntityContext(FromRootContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterRootEntity(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitRootEntity(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitRootEntity(this);
			else return visitor.visitChildren(this);
		}
	}

	public final FromRootContext fromRoot() throws RecognitionException {
		FromRootContext _localctx = new FromRootContext(_ctx, getState());
		enterRule(_localctx, 38, RULE_fromRoot);
		try {
			setState(554);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case ID:
			case VERSION:
			case VERSIONED:
			case NATURALID:
			case ALL:
			case AND:
			case ANY:
			case AS:
			case ASC:
			case AVG:
			case BETWEEN:
			case BOTH:
			case BY:
			case CASE:
			case CAST:
			case COLLATE:
			case COUNT:
			case CROSS:
			case CUBE:
			case CURRENT:
			case CURRENT_DATE:
			case CURRENT_INSTANT:
			case CURRENT_TIME:
			case CURRENT_TIMESTAMP:
			case DATE:
			case DATETIME:
			case DAY:
			case DELETE:
			case DESC:
			case DISTINCT:
			case ELEMENT:
			case ELEMENTS:
			case ELSE:
			case EMPTY:
			case END:
			case ENTRY:
			case ERROR:
			case ESCAPE:
			case EVERY:
			case EXCEPT:
			case EXCLUDE:
			case EXISTS:
			case EXTRACT:
			case FETCH:
			case FILTER:
			case FIRST:
			case FOLLOWING:
			case FOR:
			case FORMAT:
			case FROM:
			case FULL:
			case FUNCTION:
			case GROUP:
			case GROUPS:
			case HAVING:
			case HOUR:
			case IGNORE:
			case ILIKE:
			case IN:
			case INDEX:
			case INDICES:
			case INNER:
			case INSERT:
			case INSTANT:
			case INTERSECT:
			case INTO:
			case IS:
			case JOIN:
			case KEY:
			case LAST:
			case LEADING:
			case LEFT:
			case LIKE:
			case LIMIT:
			case LIST:
			case LISTAGG:
			case LOCAL:
			case LOCAL_DATE:
			case LOCAL_DATETIME:
			case LOCAL_TIME:
			case MAP:
			case MAX:
			case MAXELEMENT:
			case MAXINDEX:
			case MEMBER:
			case MICROSECOND:
			case MILLISECOND:
			case MIN:
			case MINELEMENT:
			case MININDEX:
			case MINUTE:
			case MONTH:
			case NANOSECOND:
			case NEW:
			case NEXT:
			case NO:
			case NOT:
			case NULLS:
			case OBJECT:
			case OF:
			case OFFSET:
			case OFFSET_DATETIME:
			case ON:
			case ONLY:
			case OR:
			case ORDER:
			case OTHERS:
			case OUTER:
			case OVER:
			case OVERFLOW:
			case OVERLAY:
			case PAD:
			case PARTITION:
			case PERCENT:
			case PLACING:
			case POSITION:
			case PRECEDING:
			case QUARTER:
			case RANGE:
			case RESPECT:
			case RIGHT:
			case ROLLUP:
			case ROW:
			case ROWS:
			case SECOND:
			case SELECT:
			case SET:
			case SIZE:
			case SOME:
			case SUBSTRING:
			case SUM:
			case THEN:
			case TIES:
			case TIME:
			case TIMESTAMP:
			case TIMEZONE_HOUR:
			case TIMEZONE_MINUTE:
			case TRAILING:
			case TREAT:
			case TRIM:
			case TRUNCATE:
			case TYPE:
			case UNBOUNDED:
			case UNION:
			case UPDATE:
			case VALUE:
			case VALUES:
			case WEEK:
			case WHEN:
			case WHERE:
			case WITH:
			case WITHIN:
			case WITHOUT:
			case YEAR:
			case IDENTIFIER:
			case QUOTED_IDENTIFIER:
				_localctx = new RootEntityContext(_localctx);
				enterOuterAlt(_localctx, 1);
				{
				setState(544);
				entityName();
				setState(546);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,36,_ctx) ) {
				case 1:
					{
					setState(545);
					variable();
					}
					break;
				}
				}
				break;
			case LEFT_PAREN:
				_localctx = new RootSubqueryContext(_localctx);
				enterOuterAlt(_localctx, 2);
				{
				setState(548);
				match(LEFT_PAREN);
				setState(549);
				subquery();
				setState(550);
				match(RIGHT_PAREN);
				setState(552);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,37,_ctx) ) {
				case 1:
					{
					setState(551);
					variable();
					}
					break;
				}
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class EntityNameContext extends ParserRuleContext {
		public List<IdentifierContext> identifier() {
			return getRuleContexts(IdentifierContext.class);
		}
		public IdentifierContext identifier(int i) {
			return getRuleContext(IdentifierContext.class,i);
		}
		public List<TerminalNode> DOT() { return getTokens(HqlParser.DOT); }
		public TerminalNode DOT(int i) {
			return getToken(HqlParser.DOT, i);
		}
		public EntityNameContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_entityName; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterEntityName(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitEntityName(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitEntityName(this);
			else return visitor.visitChildren(this);
		}
	}

	public final EntityNameContext entityName() throws RecognitionException {
		EntityNameContext _localctx = new EntityNameContext(_ctx, getState());
		enterRule(_localctx, 40, RULE_entityName);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(556);
			identifier();
			setState(561);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==DOT) {
				{
				{
				setState(557);
				match(DOT);
				setState(558);
				identifier();
				}
				}
				setState(563);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class VariableContext extends ParserRuleContext {
		public TerminalNode AS() { return getToken(HqlParser.AS, 0); }
		public IdentifierContext identifier() {
			return getRuleContext(IdentifierContext.class,0);
		}
		public NakedIdentifierContext nakedIdentifier() {
			return getRuleContext(NakedIdentifierContext.class,0);
		}
		public VariableContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_variable; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterVariable(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitVariable(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitVariable(this);
			else return visitor.visitChildren(this);
		}
	}

	public final VariableContext variable() throws RecognitionException {
		VariableContext _localctx = new VariableContext(_ctx, getState());
		enterRule(_localctx, 42, RULE_variable);
		try {
			setState(567);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,40,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(564);
				match(AS);
				setState(565);
				identifier();
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(566);
				nakedIdentifier();
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class CrossJoinContext extends ParserRuleContext {
		public TerminalNode CROSS() { return getToken(HqlParser.CROSS, 0); }
		public TerminalNode JOIN() { return getToken(HqlParser.JOIN, 0); }
		public EntityNameContext entityName() {
			return getRuleContext(EntityNameContext.class,0);
		}
		public VariableContext variable() {
			return getRuleContext(VariableContext.class,0);
		}
		public CrossJoinContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_crossJoin; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCrossJoin(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCrossJoin(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCrossJoin(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CrossJoinContext crossJoin() throws RecognitionException {
		CrossJoinContext _localctx = new CrossJoinContext(_ctx, getState());
		enterRule(_localctx, 44, RULE_crossJoin);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(569);
			match(CROSS);
			setState(570);
			match(JOIN);
			setState(571);
			entityName();
			setState(573);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,41,_ctx) ) {
			case 1:
				{
				setState(572);
				variable();
				}
				break;
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class JpaCollectionJoinContext extends ParserRuleContext {
		public TerminalNode COMMA() { return getToken(HqlParser.COMMA, 0); }
		public TerminalNode IN() { return getToken(HqlParser.IN, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public VariableContext variable() {
			return getRuleContext(VariableContext.class,0);
		}
		public JpaCollectionJoinContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_jpaCollectionJoin; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterJpaCollectionJoin(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitJpaCollectionJoin(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitJpaCollectionJoin(this);
			else return visitor.visitChildren(this);
		}
	}

	public final JpaCollectionJoinContext jpaCollectionJoin() throws RecognitionException {
		JpaCollectionJoinContext _localctx = new JpaCollectionJoinContext(_ctx, getState());
		enterRule(_localctx, 46, RULE_jpaCollectionJoin);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(575);
			match(COMMA);
			setState(576);
			match(IN);
			setState(577);
			match(LEFT_PAREN);
			setState(578);
			path();
			setState(579);
			match(RIGHT_PAREN);
			setState(581);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,42,_ctx) ) {
			case 1:
				{
				setState(580);
				variable();
				}
				break;
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class JoinContext extends ParserRuleContext {
		public JoinTypeContext joinType() {
			return getRuleContext(JoinTypeContext.class,0);
		}
		public TerminalNode JOIN() { return getToken(HqlParser.JOIN, 0); }
		public JoinTargetContext joinTarget() {
			return getRuleContext(JoinTargetContext.class,0);
		}
		public TerminalNode FETCH() { return getToken(HqlParser.FETCH, 0); }
		public JoinRestrictionContext joinRestriction() {
			return getRuleContext(JoinRestrictionContext.class,0);
		}
		public JoinContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_join; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterJoin(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitJoin(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitJoin(this);
			else return visitor.visitChildren(this);
		}
	}

	public final JoinContext join() throws RecognitionException {
		JoinContext _localctx = new JoinContext(_ctx, getState());
		enterRule(_localctx, 48, RULE_join);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(583);
			joinType();
			setState(584);
			match(JOIN);
			setState(586);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,43,_ctx) ) {
			case 1:
				{
				setState(585);
				match(FETCH);
				}
				break;
			}
			setState(588);
			joinTarget();
			setState(590);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==ON || _la==WITH) {
				{
				setState(589);
				joinRestriction();
				}
			}

			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class JoinTypeContext extends ParserRuleContext {
		public TerminalNode INNER() { return getToken(HqlParser.INNER, 0); }
		public TerminalNode OUTER() { return getToken(HqlParser.OUTER, 0); }
		public TerminalNode LEFT() { return getToken(HqlParser.LEFT, 0); }
		public TerminalNode RIGHT() { return getToken(HqlParser.RIGHT, 0); }
		public TerminalNode FULL() { return getToken(HqlParser.FULL, 0); }
		public JoinTypeContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_joinType; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterJoinType(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitJoinType(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitJoinType(this);
			else return visitor.visitChildren(this);
		}
	}

	public final JoinTypeContext joinType() throws RecognitionException {
		JoinTypeContext _localctx = new JoinTypeContext(_ctx, getState());
		enterRule(_localctx, 50, RULE_joinType);
		int _la;
		try {
			setState(601);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,48,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(593);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==INNER) {
					{
					setState(592);
					match(INNER);
					}
				}

				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(596);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==FULL || _la==LEFT || _la==RIGHT) {
					{
					setState(595);
					_la = _input.LA(1);
					if ( !(_la==FULL || _la==LEFT || _la==RIGHT) ) {
					_errHandler.recoverInline(this);
					}
					else {
						if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
						_errHandler.reportMatch(this);
						consume();
					}
					}
				}

				setState(599);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==OUTER) {
					{
					setState(598);
					match(OUTER);
					}
				}

				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class JoinTargetContext extends ParserRuleContext {
		public JoinTargetContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_joinTarget; }
	 
		public JoinTargetContext() { }
		public void copyFrom(JoinTargetContext ctx) {
			super.copyFrom(ctx);
		}
	}
	public static class JoinPathContext extends JoinTargetContext {
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public VariableContext variable() {
			return getRuleContext(VariableContext.class,0);
		}
		public JoinPathContext(JoinTargetContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterJoinPath(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitJoinPath(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitJoinPath(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class JoinSubqueryContext extends JoinTargetContext {
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public SubqueryContext subquery() {
			return getRuleContext(SubqueryContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode LATERAL() { return getToken(HqlParser.LATERAL, 0); }
		public VariableContext variable() {
			return getRuleContext(VariableContext.class,0);
		}
		public JoinSubqueryContext(JoinTargetContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterJoinSubquery(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitJoinSubquery(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitJoinSubquery(this);
			else return visitor.visitChildren(this);
		}
	}

	public final JoinTargetContext joinTarget() throws RecognitionException {
		JoinTargetContext _localctx = new JoinTargetContext(_ctx, getState());
		enterRule(_localctx, 52, RULE_joinTarget);
		int _la;
		try {
			setState(616);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case ID:
			case VERSION:
			case VERSIONED:
			case NATURALID:
			case ALL:
			case AND:
			case ANY:
			case AS:
			case ASC:
			case AVG:
			case BETWEEN:
			case BOTH:
			case BY:
			case CASE:
			case CAST:
			case COLLATE:
			case COUNT:
			case CROSS:
			case CUBE:
			case CURRENT:
			case CURRENT_DATE:
			case CURRENT_INSTANT:
			case CURRENT_TIME:
			case CURRENT_TIMESTAMP:
			case DATE:
			case DATETIME:
			case DAY:
			case DELETE:
			case DESC:
			case DISTINCT:
			case ELEMENT:
			case ELEMENTS:
			case ELSE:
			case EMPTY:
			case END:
			case ENTRY:
			case ERROR:
			case ESCAPE:
			case EVERY:
			case EXCEPT:
			case EXCLUDE:
			case EXISTS:
			case EXTRACT:
			case FETCH:
			case FILTER:
			case FIRST:
			case FOLLOWING:
			case FOR:
			case FORMAT:
			case FROM:
			case FULL:
			case FUNCTION:
			case GROUP:
			case GROUPS:
			case HAVING:
			case HOUR:
			case IGNORE:
			case ILIKE:
			case IN:
			case INDEX:
			case INDICES:
			case INNER:
			case INSERT:
			case INSTANT:
			case INTERSECT:
			case INTO:
			case IS:
			case JOIN:
			case KEY:
			case LAST:
			case LEADING:
			case LEFT:
			case LIKE:
			case LIMIT:
			case LIST:
			case LISTAGG:
			case LOCAL:
			case LOCAL_DATE:
			case LOCAL_DATETIME:
			case LOCAL_TIME:
			case MAP:
			case MAX:
			case MAXELEMENT:
			case MAXINDEX:
			case MEMBER:
			case MICROSECOND:
			case MILLISECOND:
			case MIN:
			case MINELEMENT:
			case MININDEX:
			case MINUTE:
			case MONTH:
			case NANOSECOND:
			case NEW:
			case NEXT:
			case NO:
			case NOT:
			case NULLS:
			case OBJECT:
			case OF:
			case OFFSET:
			case OFFSET_DATETIME:
			case ON:
			case ONLY:
			case OR:
			case ORDER:
			case OTHERS:
			case OUTER:
			case OVER:
			case OVERFLOW:
			case OVERLAY:
			case PAD:
			case PARTITION:
			case PERCENT:
			case PLACING:
			case POSITION:
			case PRECEDING:
			case QUARTER:
			case RANGE:
			case RESPECT:
			case RIGHT:
			case ROLLUP:
			case ROW:
			case ROWS:
			case SECOND:
			case SELECT:
			case SET:
			case SIZE:
			case SOME:
			case SUBSTRING:
			case SUM:
			case THEN:
			case TIES:
			case TIME:
			case TIMESTAMP:
			case TIMEZONE_HOUR:
			case TIMEZONE_MINUTE:
			case TRAILING:
			case TREAT:
			case TRIM:
			case TRUNCATE:
			case TYPE:
			case UNBOUNDED:
			case UNION:
			case UPDATE:
			case VALUE:
			case VALUES:
			case WEEK:
			case WHEN:
			case WHERE:
			case WITH:
			case WITHIN:
			case WITHOUT:
			case YEAR:
			case IDENTIFIER:
			case QUOTED_IDENTIFIER:
				_localctx = new JoinPathContext(_localctx);
				enterOuterAlt(_localctx, 1);
				{
				setState(603);
				path();
				setState(605);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,49,_ctx) ) {
				case 1:
					{
					setState(604);
					variable();
					}
					break;
				}
				}
				break;
			case LEFT_PAREN:
			case LATERAL:
				_localctx = new JoinSubqueryContext(_localctx);
				enterOuterAlt(_localctx, 2);
				{
				setState(608);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==LATERAL) {
					{
					setState(607);
					match(LATERAL);
					}
				}

				setState(610);
				match(LEFT_PAREN);
				setState(611);
				subquery();
				setState(612);
				match(RIGHT_PAREN);
				setState(614);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,51,_ctx) ) {
				case 1:
					{
					setState(613);
					variable();
					}
					break;
				}
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class JoinRestrictionContext extends ParserRuleContext {
		public PredicateContext predicate() {
			return getRuleContext(PredicateContext.class,0);
		}
		public TerminalNode ON() { return getToken(HqlParser.ON, 0); }
		public TerminalNode WITH() { return getToken(HqlParser.WITH, 0); }
		public JoinRestrictionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_joinRestriction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterJoinRestriction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitJoinRestriction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitJoinRestriction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final JoinRestrictionContext joinRestriction() throws RecognitionException {
		JoinRestrictionContext _localctx = new JoinRestrictionContext(_ctx, getState());
		enterRule(_localctx, 54, RULE_joinRestriction);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(618);
			_la = _input.LA(1);
			if ( !(_la==ON || _la==WITH) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			setState(619);
			predicate(0);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class SelectClauseContext extends ParserRuleContext {
		public TerminalNode SELECT() { return getToken(HqlParser.SELECT, 0); }
		public SelectionListContext selectionList() {
			return getRuleContext(SelectionListContext.class,0);
		}
		public TerminalNode DISTINCT() { return getToken(HqlParser.DISTINCT, 0); }
		public SelectClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_selectClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSelectClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSelectClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSelectClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SelectClauseContext selectClause() throws RecognitionException {
		SelectClauseContext _localctx = new SelectClauseContext(_ctx, getState());
		enterRule(_localctx, 56, RULE_selectClause);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(621);
			match(SELECT);
			setState(623);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,53,_ctx) ) {
			case 1:
				{
				setState(622);
				match(DISTINCT);
				}
				break;
			}
			setState(625);
			selectionList();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class SelectionListContext extends ParserRuleContext {
		public List<SelectionContext> selection() {
			return getRuleContexts(SelectionContext.class);
		}
		public SelectionContext selection(int i) {
			return getRuleContext(SelectionContext.class,i);
		}
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public SelectionListContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_selectionList; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSelectionList(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSelectionList(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSelectionList(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SelectionListContext selectionList() throws RecognitionException {
		SelectionListContext _localctx = new SelectionListContext(_ctx, getState());
		enterRule(_localctx, 58, RULE_selectionList);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(627);
			selection();
			setState(632);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==COMMA) {
				{
				{
				setState(628);
				match(COMMA);
				setState(629);
				selection();
				}
				}
				setState(634);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class SelectionContext extends ParserRuleContext {
		public SelectExpressionContext selectExpression() {
			return getRuleContext(SelectExpressionContext.class,0);
		}
		public VariableContext variable() {
			return getRuleContext(VariableContext.class,0);
		}
		public SelectionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_selection; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSelection(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSelection(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSelection(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SelectionContext selection() throws RecognitionException {
		SelectionContext _localctx = new SelectionContext(_ctx, getState());
		enterRule(_localctx, 60, RULE_selection);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(635);
			selectExpression();
			setState(637);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,55,_ctx) ) {
			case 1:
				{
				setState(636);
				variable();
				}
				break;
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class SelectExpressionContext extends ParserRuleContext {
		public InstantiationContext instantiation() {
			return getRuleContext(InstantiationContext.class,0);
		}
		public MapEntrySelectionContext mapEntrySelection() {
			return getRuleContext(MapEntrySelectionContext.class,0);
		}
		public JpaSelectObjectSyntaxContext jpaSelectObjectSyntax() {
			return getRuleContext(JpaSelectObjectSyntaxContext.class,0);
		}
		public ExpressionOrPredicateContext expressionOrPredicate() {
			return getRuleContext(ExpressionOrPredicateContext.class,0);
		}
		public SelectExpressionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_selectExpression; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSelectExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSelectExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSelectExpression(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SelectExpressionContext selectExpression() throws RecognitionException {
		SelectExpressionContext _localctx = new SelectExpressionContext(_ctx, getState());
		enterRule(_localctx, 62, RULE_selectExpression);
		try {
			setState(643);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,56,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(639);
				instantiation();
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(640);
				mapEntrySelection();
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(641);
				jpaSelectObjectSyntax();
				}
				break;
			case 4:
				enterOuterAlt(_localctx, 4);
				{
				setState(642);
				expressionOrPredicate();
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class MapEntrySelectionContext extends ParserRuleContext {
		public TerminalNode ENTRY() { return getToken(HqlParser.ENTRY, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public MapEntrySelectionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_mapEntrySelection; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterMapEntrySelection(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitMapEntrySelection(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitMapEntrySelection(this);
			else return visitor.visitChildren(this);
		}
	}

	public final MapEntrySelectionContext mapEntrySelection() throws RecognitionException {
		MapEntrySelectionContext _localctx = new MapEntrySelectionContext(_ctx, getState());
		enterRule(_localctx, 64, RULE_mapEntrySelection);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(645);
			match(ENTRY);
			setState(646);
			match(LEFT_PAREN);
			setState(647);
			path();
			setState(648);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class InstantiationContext extends ParserRuleContext {
		public TerminalNode NEW() { return getToken(HqlParser.NEW, 0); }
		public InstantiationTargetContext instantiationTarget() {
			return getRuleContext(InstantiationTargetContext.class,0);
		}
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public InstantiationArgumentsContext instantiationArguments() {
			return getRuleContext(InstantiationArgumentsContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public InstantiationContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_instantiation; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterInstantiation(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitInstantiation(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitInstantiation(this);
			else return visitor.visitChildren(this);
		}
	}

	public final InstantiationContext instantiation() throws RecognitionException {
		InstantiationContext _localctx = new InstantiationContext(_ctx, getState());
		enterRule(_localctx, 66, RULE_instantiation);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(650);
			match(NEW);
			setState(651);
			instantiationTarget();
			setState(652);
			match(LEFT_PAREN);
			setState(653);
			instantiationArguments();
			setState(654);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class InstantiationTargetContext extends ParserRuleContext {
		public TerminalNode LIST() { return getToken(HqlParser.LIST, 0); }
		public TerminalNode MAP() { return getToken(HqlParser.MAP, 0); }
		public SimplePathContext simplePath() {
			return getRuleContext(SimplePathContext.class,0);
		}
		public InstantiationTargetContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_instantiationTarget; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterInstantiationTarget(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitInstantiationTarget(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitInstantiationTarget(this);
			else return visitor.visitChildren(this);
		}
	}

	public final InstantiationTargetContext instantiationTarget() throws RecognitionException {
		InstantiationTargetContext _localctx = new InstantiationTargetContext(_ctx, getState());
		enterRule(_localctx, 68, RULE_instantiationTarget);
		try {
			setState(659);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,57,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(656);
				match(LIST);
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(657);
				match(MAP);
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(658);
				simplePath();
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class InstantiationArgumentsContext extends ParserRuleContext {
		public List<InstantiationArgumentContext> instantiationArgument() {
			return getRuleContexts(InstantiationArgumentContext.class);
		}
		public InstantiationArgumentContext instantiationArgument(int i) {
			return getRuleContext(InstantiationArgumentContext.class,i);
		}
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public InstantiationArgumentsContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_instantiationArguments; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterInstantiationArguments(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitInstantiationArguments(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitInstantiationArguments(this);
			else return visitor.visitChildren(this);
		}
	}

	public final InstantiationArgumentsContext instantiationArguments() throws RecognitionException {
		InstantiationArgumentsContext _localctx = new InstantiationArgumentsContext(_ctx, getState());
		enterRule(_localctx, 70, RULE_instantiationArguments);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(661);
			instantiationArgument();
			setState(666);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==COMMA) {
				{
				{
				setState(662);
				match(COMMA);
				setState(663);
				instantiationArgument();
				}
				}
				setState(668);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class InstantiationArgumentContext extends ParserRuleContext {
		public InstantiationArgumentExpressionContext instantiationArgumentExpression() {
			return getRuleContext(InstantiationArgumentExpressionContext.class,0);
		}
		public VariableContext variable() {
			return getRuleContext(VariableContext.class,0);
		}
		public InstantiationArgumentContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_instantiationArgument; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterInstantiationArgument(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitInstantiationArgument(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitInstantiationArgument(this);
			else return visitor.visitChildren(this);
		}
	}

	public final InstantiationArgumentContext instantiationArgument() throws RecognitionException {
		InstantiationArgumentContext _localctx = new InstantiationArgumentContext(_ctx, getState());
		enterRule(_localctx, 72, RULE_instantiationArgument);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(669);
			instantiationArgumentExpression();
			setState(671);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (((((_la - 42)) & ~0x3f) == 0 && ((1L << (_la - 42)) & ((1L << (ID - 42)) | (1L << (VERSION - 42)) | (1L << (VERSIONED - 42)) | (1L << (NATURALID - 42)) | (1L << (ALL - 42)) | (1L << (AND - 42)) | (1L << (ANY - 42)) | (1L << (AS - 42)) | (1L << (ASC - 42)) | (1L << (AVG - 42)) | (1L << (BETWEEN - 42)) | (1L << (BOTH - 42)) | (1L << (BY - 42)) | (1L << (CASE - 42)) | (1L << (CAST - 42)) | (1L << (COLLATE - 42)) | (1L << (COUNT - 42)) | (1L << (CROSS - 42)) | (1L << (CUBE - 42)) | (1L << (CURRENT - 42)) | (1L << (CURRENT_DATE - 42)) | (1L << (CURRENT_INSTANT - 42)) | (1L << (CURRENT_TIME - 42)) | (1L << (CURRENT_TIMESTAMP - 42)) | (1L << (DATE - 42)) | (1L << (DATETIME - 42)) | (1L << (DAY - 42)) | (1L << (DELETE - 42)) | (1L << (DESC - 42)) | (1L << (DISTINCT - 42)) | (1L << (ELEMENT - 42)) | (1L << (ELEMENTS - 42)) | (1L << (ELSE - 42)) | (1L << (EMPTY - 42)) | (1L << (END - 42)) | (1L << (ENTRY - 42)) | (1L << (ERROR - 42)) | (1L << (ESCAPE - 42)) | (1L << (EVERY - 42)) | (1L << (EXCEPT - 42)) | (1L << (EXCLUDE - 42)) | (1L << (EXISTS - 42)) | (1L << (EXTRACT - 42)) | (1L << (FETCH - 42)) | (1L << (FILTER - 42)) | (1L << (FIRST - 42)) | (1L << (FOLLOWING - 42)) | (1L << (FOR - 42)) | (1L << (FORMAT - 42)) | (1L << (FROM - 42)) | (1L << (FUNCTION - 42)) | (1L << (GROUP - 42)) | (1L << (GROUPS - 42)) | (1L << (HAVING - 42)) | (1L << (HOUR - 42)) | (1L << (IGNORE - 42)) | (1L << (ILIKE - 42)) | (1L << (IN - 42)) | (1L << (INDEX - 42)) | (1L << (INDICES - 42)) | (1L << (INSERT - 42)))) != 0) || ((((_la - 106)) & ~0x3f) == 0 && ((1L << (_la - 106)) & ((1L << (INSTANT - 106)) | (1L << (INTERSECT - 106)) | (1L << (INTO - 106)) | (1L << (IS - 106)) | (1L << (JOIN - 106)) | (1L << (KEY - 106)) | (1L << (LAST - 106)) | (1L << (LEADING - 106)) | (1L << (LIKE - 106)) | (1L << (LIMIT - 106)) | (1L << (LIST - 106)) | (1L << (LISTAGG - 106)) | (1L << (LOCAL - 106)) | (1L << (LOCAL_DATE - 106)) | (1L << (LOCAL_DATETIME - 106)) | (1L << (LOCAL_TIME - 106)) | (1L << (MAP - 106)) | (1L << (MAX - 106)) | (1L << (MAXELEMENT - 106)) | (1L << (MAXINDEX - 106)) | (1L << (MEMBER - 106)) | (1L << (MICROSECOND - 106)) | (1L << (MILLISECOND - 106)) | (1L << (MIN - 106)) | (1L << (MINELEMENT - 106)) | (1L << (MININDEX - 106)) | (1L << (MINUTE - 106)) | (1L << (MONTH - 106)) | (1L << (NANOSECOND - 106)) | (1L << (NEW - 106)) | (1L << (NEXT - 106)) | (1L << (NO - 106)) | (1L << (NOT - 106)) | (1L << (NULLS - 106)) | (1L << (OBJECT - 106)) | (1L << (OF - 106)) | (1L << (OFFSET - 106)) | (1L << (OFFSET_DATETIME - 106)) | (1L << (ON - 106)) | (1L << (ONLY - 106)) | (1L << (OR - 106)) | (1L << (ORDER - 106)) | (1L << (OTHERS - 106)) | (1L << (OVER - 106)) | (1L << (OVERFLOW - 106)) | (1L << (OVERLAY - 106)) | (1L << (PAD - 106)) | (1L << (PARTITION - 106)) | (1L << (PERCENT - 106)) | (1L << (PLACING - 106)) | (1L << (POSITION - 106)) | (1L << (PRECEDING - 106)) | (1L << (QUARTER - 106)) | (1L << (RANGE - 106)) | (1L << (RESPECT - 106)) | (1L << (ROLLUP - 106)) | (1L << (ROW - 106)) | (1L << (ROWS - 106)) | (1L << (SECOND - 106)) | (1L << (SELECT - 106)))) != 0) || ((((_la - 170)) & ~0x3f) == 0 && ((1L << (_la - 170)) & ((1L << (SET - 170)) | (1L << (SIZE - 170)) | (1L << (SOME - 170)) | (1L << (SUBSTRING - 170)) | (1L << (SUM - 170)) | (1L << (THEN - 170)) | (1L << (TIES - 170)) | (1L << (TIME - 170)) | (1L << (TIMESTAMP - 170)) | (1L << (TIMEZONE_HOUR - 170)) | (1L << (TIMEZONE_MINUTE - 170)) | (1L << (TRAILING - 170)) | (1L << (TREAT - 170)) | (1L << (TRIM - 170)) | (1L << (TRUNCATE - 170)) | (1L << (TYPE - 170)) | (1L << (UNBOUNDED - 170)) | (1L << (UNION - 170)) | (1L << (UPDATE - 170)) | (1L << (VALUE - 170)) | (1L << (VALUES - 170)) | (1L << (WEEK - 170)) | (1L << (WHEN - 170)) | (1L << (WHERE - 170)) | (1L << (WITH - 170)) | (1L << (WITHIN - 170)) | (1L << (WITHOUT - 170)) | (1L << (YEAR - 170)) | (1L << (IDENTIFIER - 170)) | (1L << (QUOTED_IDENTIFIER - 170)))) != 0)) {
				{
				setState(670);
				variable();
				}
			}

			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class InstantiationArgumentExpressionContext extends ParserRuleContext {
		public ExpressionOrPredicateContext expressionOrPredicate() {
			return getRuleContext(ExpressionOrPredicateContext.class,0);
		}
		public InstantiationContext instantiation() {
			return getRuleContext(InstantiationContext.class,0);
		}
		public InstantiationArgumentExpressionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_instantiationArgumentExpression; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterInstantiationArgumentExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitInstantiationArgumentExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitInstantiationArgumentExpression(this);
			else return visitor.visitChildren(this);
		}
	}

	public final InstantiationArgumentExpressionContext instantiationArgumentExpression() throws RecognitionException {
		InstantiationArgumentExpressionContext _localctx = new InstantiationArgumentExpressionContext(_ctx, getState());
		enterRule(_localctx, 74, RULE_instantiationArgumentExpression);
		try {
			setState(675);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,60,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(673);
				expressionOrPredicate();
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(674);
				instantiation();
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class JpaSelectObjectSyntaxContext extends ParserRuleContext {
		public TerminalNode OBJECT() { return getToken(HqlParser.OBJECT, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public IdentifierContext identifier() {
			return getRuleContext(IdentifierContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public JpaSelectObjectSyntaxContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_jpaSelectObjectSyntax; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterJpaSelectObjectSyntax(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitJpaSelectObjectSyntax(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitJpaSelectObjectSyntax(this);
			else return visitor.visitChildren(this);
		}
	}

	public final JpaSelectObjectSyntaxContext jpaSelectObjectSyntax() throws RecognitionException {
		JpaSelectObjectSyntaxContext _localctx = new JpaSelectObjectSyntaxContext(_ctx, getState());
		enterRule(_localctx, 76, RULE_jpaSelectObjectSyntax);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(677);
			match(OBJECT);
			setState(678);
			match(LEFT_PAREN);
			setState(679);
			identifier();
			setState(680);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class SimplePathContext extends ParserRuleContext {
		public IdentifierContext identifier() {
			return getRuleContext(IdentifierContext.class,0);
		}
		public List<SimplePathElementContext> simplePathElement() {
			return getRuleContexts(SimplePathElementContext.class);
		}
		public SimplePathElementContext simplePathElement(int i) {
			return getRuleContext(SimplePathElementContext.class,i);
		}
		public SimplePathContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_simplePath; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSimplePath(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSimplePath(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSimplePath(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SimplePathContext simplePath() throws RecognitionException {
		SimplePathContext _localctx = new SimplePathContext(_ctx, getState());
		enterRule(_localctx, 78, RULE_simplePath);
		try {
			int _alt;
			enterOuterAlt(_localctx, 1);
			{
			setState(682);
			identifier();
			setState(686);
			_errHandler.sync(this);
			_alt = getInterpreter().adaptivePredict(_input,61,_ctx);
			while ( _alt!=2 && _alt!=org.antlr.v4.runtime.atn.ATN.INVALID_ALT_NUMBER ) {
				if ( _alt==1 ) {
					{
					{
					setState(683);
					simplePathElement();
					}
					} 
				}
				setState(688);
				_errHandler.sync(this);
				_alt = getInterpreter().adaptivePredict(_input,61,_ctx);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class SimplePathElementContext extends ParserRuleContext {
		public TerminalNode DOT() { return getToken(HqlParser.DOT, 0); }
		public IdentifierContext identifier() {
			return getRuleContext(IdentifierContext.class,0);
		}
		public SimplePathElementContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_simplePathElement; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSimplePathElement(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSimplePathElement(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSimplePathElement(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SimplePathElementContext simplePathElement() throws RecognitionException {
		SimplePathElementContext _localctx = new SimplePathElementContext(_ctx, getState());
		enterRule(_localctx, 80, RULE_simplePathElement);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(689);
			match(DOT);
			setState(690);
			identifier();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class PathContext extends ParserRuleContext {
		public SyntacticDomainPathContext syntacticDomainPath() {
			return getRuleContext(SyntacticDomainPathContext.class,0);
		}
		public PathContinuationContext pathContinuation() {
			return getRuleContext(PathContinuationContext.class,0);
		}
		public GeneralPathFragmentContext generalPathFragment() {
			return getRuleContext(GeneralPathFragmentContext.class,0);
		}
		public PathContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_path; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterPath(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitPath(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitPath(this);
			else return visitor.visitChildren(this);
		}
	}

	public final PathContext path() throws RecognitionException {
		PathContext _localctx = new PathContext(_ctx, getState());
		enterRule(_localctx, 82, RULE_path);
		try {
			setState(697);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,63,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(692);
				syntacticDomainPath();
				setState(694);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,62,_ctx) ) {
				case 1:
					{
					setState(693);
					pathContinuation();
					}
					break;
				}
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(696);
				generalPathFragment();
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class PathContinuationContext extends ParserRuleContext {
		public TerminalNode DOT() { return getToken(HqlParser.DOT, 0); }
		public SimplePathContext simplePath() {
			return getRuleContext(SimplePathContext.class,0);
		}
		public PathContinuationContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_pathContinuation; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterPathContinuation(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitPathContinuation(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitPathContinuation(this);
			else return visitor.visitChildren(this);
		}
	}

	public final PathContinuationContext pathContinuation() throws RecognitionException {
		PathContinuationContext _localctx = new PathContinuationContext(_ctx, getState());
		enterRule(_localctx, 84, RULE_pathContinuation);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(699);
			match(DOT);
			setState(700);
			simplePath();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class SyntacticDomainPathContext extends ParserRuleContext {
		public TreatedNavigablePathContext treatedNavigablePath() {
			return getRuleContext(TreatedNavigablePathContext.class,0);
		}
		public CollectionValueNavigablePathContext collectionValueNavigablePath() {
			return getRuleContext(CollectionValueNavigablePathContext.class,0);
		}
		public MapKeyNavigablePathContext mapKeyNavigablePath() {
			return getRuleContext(MapKeyNavigablePathContext.class,0);
		}
		public SimplePathContext simplePath() {
			return getRuleContext(SimplePathContext.class,0);
		}
		public IndexedPathAccessFragmentContext indexedPathAccessFragment() {
			return getRuleContext(IndexedPathAccessFragmentContext.class,0);
		}
		public SyntacticDomainPathContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_syntacticDomainPath; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSyntacticDomainPath(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSyntacticDomainPath(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSyntacticDomainPath(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SyntacticDomainPathContext syntacticDomainPath() throws RecognitionException {
		SyntacticDomainPathContext _localctx = new SyntacticDomainPathContext(_ctx, getState());
		enterRule(_localctx, 86, RULE_syntacticDomainPath);
		try {
			setState(708);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,64,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(702);
				treatedNavigablePath();
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(703);
				collectionValueNavigablePath();
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(704);
				mapKeyNavigablePath();
				}
				break;
			case 4:
				enterOuterAlt(_localctx, 4);
				{
				setState(705);
				simplePath();
				setState(706);
				indexedPathAccessFragment();
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class GeneralPathFragmentContext extends ParserRuleContext {
		public SimplePathContext simplePath() {
			return getRuleContext(SimplePathContext.class,0);
		}
		public IndexedPathAccessFragmentContext indexedPathAccessFragment() {
			return getRuleContext(IndexedPathAccessFragmentContext.class,0);
		}
		public GeneralPathFragmentContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_generalPathFragment; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterGeneralPathFragment(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitGeneralPathFragment(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitGeneralPathFragment(this);
			else return visitor.visitChildren(this);
		}
	}

	public final GeneralPathFragmentContext generalPathFragment() throws RecognitionException {
		GeneralPathFragmentContext _localctx = new GeneralPathFragmentContext(_ctx, getState());
		enterRule(_localctx, 88, RULE_generalPathFragment);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(710);
			simplePath();
			setState(712);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,65,_ctx) ) {
			case 1:
				{
				setState(711);
				indexedPathAccessFragment();
				}
				break;
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class IndexedPathAccessFragmentContext extends ParserRuleContext {
		public TerminalNode LEFT_BRACKET() { return getToken(HqlParser.LEFT_BRACKET, 0); }
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode RIGHT_BRACKET() { return getToken(HqlParser.RIGHT_BRACKET, 0); }
		public TerminalNode DOT() { return getToken(HqlParser.DOT, 0); }
		public GeneralPathFragmentContext generalPathFragment() {
			return getRuleContext(GeneralPathFragmentContext.class,0);
		}
		public IndexedPathAccessFragmentContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_indexedPathAccessFragment; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterIndexedPathAccessFragment(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitIndexedPathAccessFragment(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitIndexedPathAccessFragment(this);
			else return visitor.visitChildren(this);
		}
	}

	public final IndexedPathAccessFragmentContext indexedPathAccessFragment() throws RecognitionException {
		IndexedPathAccessFragmentContext _localctx = new IndexedPathAccessFragmentContext(_ctx, getState());
		enterRule(_localctx, 90, RULE_indexedPathAccessFragment);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(714);
			match(LEFT_BRACKET);
			setState(715);
			expression(0);
			setState(716);
			match(RIGHT_BRACKET);
			setState(719);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,66,_ctx) ) {
			case 1:
				{
				setState(717);
				match(DOT);
				setState(718);
				generalPathFragment();
				}
				break;
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class TreatedNavigablePathContext extends ParserRuleContext {
		public TerminalNode TREAT() { return getToken(HqlParser.TREAT, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public TerminalNode AS() { return getToken(HqlParser.AS, 0); }
		public SimplePathContext simplePath() {
			return getRuleContext(SimplePathContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public PathContinuationContext pathContinuation() {
			return getRuleContext(PathContinuationContext.class,0);
		}
		public TreatedNavigablePathContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_treatedNavigablePath; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterTreatedNavigablePath(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitTreatedNavigablePath(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitTreatedNavigablePath(this);
			else return visitor.visitChildren(this);
		}
	}

	public final TreatedNavigablePathContext treatedNavigablePath() throws RecognitionException {
		TreatedNavigablePathContext _localctx = new TreatedNavigablePathContext(_ctx, getState());
		enterRule(_localctx, 92, RULE_treatedNavigablePath);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(721);
			match(TREAT);
			setState(722);
			match(LEFT_PAREN);
			setState(723);
			path();
			setState(724);
			match(AS);
			setState(725);
			simplePath();
			setState(726);
			match(RIGHT_PAREN);
			setState(728);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,67,_ctx) ) {
			case 1:
				{
				setState(727);
				pathContinuation();
				}
				break;
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class CollectionValueNavigablePathContext extends ParserRuleContext {
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode VALUE() { return getToken(HqlParser.VALUE, 0); }
		public TerminalNode ELEMENT() { return getToken(HqlParser.ELEMENT, 0); }
		public PathContinuationContext pathContinuation() {
			return getRuleContext(PathContinuationContext.class,0);
		}
		public CollectionValueNavigablePathContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_collectionValueNavigablePath; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCollectionValueNavigablePath(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCollectionValueNavigablePath(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCollectionValueNavigablePath(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CollectionValueNavigablePathContext collectionValueNavigablePath() throws RecognitionException {
		CollectionValueNavigablePathContext _localctx = new CollectionValueNavigablePathContext(_ctx, getState());
		enterRule(_localctx, 94, RULE_collectionValueNavigablePath);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(730);
			_la = _input.LA(1);
			if ( !(_la==ELEMENT || _la==VALUE) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			setState(731);
			match(LEFT_PAREN);
			setState(732);
			path();
			setState(733);
			match(RIGHT_PAREN);
			setState(735);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,68,_ctx) ) {
			case 1:
				{
				setState(734);
				pathContinuation();
				}
				break;
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class MapKeyNavigablePathContext extends ParserRuleContext {
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode KEY() { return getToken(HqlParser.KEY, 0); }
		public TerminalNode INDEX() { return getToken(HqlParser.INDEX, 0); }
		public PathContinuationContext pathContinuation() {
			return getRuleContext(PathContinuationContext.class,0);
		}
		public MapKeyNavigablePathContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_mapKeyNavigablePath; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterMapKeyNavigablePath(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitMapKeyNavigablePath(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitMapKeyNavigablePath(this);
			else return visitor.visitChildren(this);
		}
	}

	public final MapKeyNavigablePathContext mapKeyNavigablePath() throws RecognitionException {
		MapKeyNavigablePathContext _localctx = new MapKeyNavigablePathContext(_ctx, getState());
		enterRule(_localctx, 96, RULE_mapKeyNavigablePath);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(737);
			_la = _input.LA(1);
			if ( !(_la==INDEX || _la==KEY) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			setState(738);
			match(LEFT_PAREN);
			setState(739);
			path();
			setState(740);
			match(RIGHT_PAREN);
			setState(742);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,69,_ctx) ) {
			case 1:
				{
				setState(741);
				pathContinuation();
				}
				break;
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class GroupByClauseContext extends ParserRuleContext {
		public TerminalNode GROUP() { return getToken(HqlParser.GROUP, 0); }
		public TerminalNode BY() { return getToken(HqlParser.BY, 0); }
		public List<GroupByExpressionContext> groupByExpression() {
			return getRuleContexts(GroupByExpressionContext.class);
		}
		public GroupByExpressionContext groupByExpression(int i) {
			return getRuleContext(GroupByExpressionContext.class,i);
		}
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public GroupByClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_groupByClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterGroupByClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitGroupByClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitGroupByClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final GroupByClauseContext groupByClause() throws RecognitionException {
		GroupByClauseContext _localctx = new GroupByClauseContext(_ctx, getState());
		enterRule(_localctx, 98, RULE_groupByClause);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(744);
			match(GROUP);
			setState(745);
			match(BY);
			setState(746);
			groupByExpression();
			setState(751);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==COMMA) {
				{
				{
				setState(747);
				match(COMMA);
				setState(748);
				groupByExpression();
				}
				}
				setState(753);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class GroupByExpressionContext extends ParserRuleContext {
		public IdentifierContext identifier() {
			return getRuleContext(IdentifierContext.class,0);
		}
		public TerminalNode INTEGER_LITERAL() { return getToken(HqlParser.INTEGER_LITERAL, 0); }
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public GroupByExpressionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_groupByExpression; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterGroupByExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitGroupByExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitGroupByExpression(this);
			else return visitor.visitChildren(this);
		}
	}

	public final GroupByExpressionContext groupByExpression() throws RecognitionException {
		GroupByExpressionContext _localctx = new GroupByExpressionContext(_ctx, getState());
		enterRule(_localctx, 100, RULE_groupByExpression);
		try {
			setState(757);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,71,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(754);
				identifier();
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(755);
				match(INTEGER_LITERAL);
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(756);
				expression(0);
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class HavingClauseContext extends ParserRuleContext {
		public TerminalNode HAVING() { return getToken(HqlParser.HAVING, 0); }
		public PredicateContext predicate() {
			return getRuleContext(PredicateContext.class,0);
		}
		public HavingClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_havingClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterHavingClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitHavingClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitHavingClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final HavingClauseContext havingClause() throws RecognitionException {
		HavingClauseContext _localctx = new HavingClauseContext(_ctx, getState());
		enterRule(_localctx, 102, RULE_havingClause);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(759);
			match(HAVING);
			setState(760);
			predicate(0);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class OrderByClauseContext extends ParserRuleContext {
		public TerminalNode ORDER() { return getToken(HqlParser.ORDER, 0); }
		public TerminalNode BY() { return getToken(HqlParser.BY, 0); }
		public List<SortSpecificationContext> sortSpecification() {
			return getRuleContexts(SortSpecificationContext.class);
		}
		public SortSpecificationContext sortSpecification(int i) {
			return getRuleContext(SortSpecificationContext.class,i);
		}
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public OrderByClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_orderByClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterOrderByClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitOrderByClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitOrderByClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final OrderByClauseContext orderByClause() throws RecognitionException {
		OrderByClauseContext _localctx = new OrderByClauseContext(_ctx, getState());
		enterRule(_localctx, 104, RULE_orderByClause);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(762);
			match(ORDER);
			setState(763);
			match(BY);
			setState(764);
			sortSpecification();
			setState(769);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==COMMA) {
				{
				{
				setState(765);
				match(COMMA);
				setState(766);
				sortSpecification();
				}
				}
				setState(771);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class OrderByFragmentContext extends ParserRuleContext {
		public List<SortSpecificationContext> sortSpecification() {
			return getRuleContexts(SortSpecificationContext.class);
		}
		public SortSpecificationContext sortSpecification(int i) {
			return getRuleContext(SortSpecificationContext.class,i);
		}
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public OrderByFragmentContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_orderByFragment; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterOrderByFragment(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitOrderByFragment(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitOrderByFragment(this);
			else return visitor.visitChildren(this);
		}
	}

	public final OrderByFragmentContext orderByFragment() throws RecognitionException {
		OrderByFragmentContext _localctx = new OrderByFragmentContext(_ctx, getState());
		enterRule(_localctx, 106, RULE_orderByFragment);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(772);
			sortSpecification();
			setState(777);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==COMMA) {
				{
				{
				setState(773);
				match(COMMA);
				setState(774);
				sortSpecification();
				}
				}
				setState(779);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class SortSpecificationContext extends ParserRuleContext {
		public SortExpressionContext sortExpression() {
			return getRuleContext(SortExpressionContext.class,0);
		}
		public SortDirectionContext sortDirection() {
			return getRuleContext(SortDirectionContext.class,0);
		}
		public NullsPrecedenceContext nullsPrecedence() {
			return getRuleContext(NullsPrecedenceContext.class,0);
		}
		public SortSpecificationContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_sortSpecification; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSortSpecification(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSortSpecification(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSortSpecification(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SortSpecificationContext sortSpecification() throws RecognitionException {
		SortSpecificationContext _localctx = new SortSpecificationContext(_ctx, getState());
		enterRule(_localctx, 108, RULE_sortSpecification);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(780);
			sortExpression();
			setState(782);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==ASC || _la==DESC) {
				{
				setState(781);
				sortDirection();
				}
			}

			setState(785);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==NULLS) {
				{
				setState(784);
				nullsPrecedence();
				}
			}

			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class NullsPrecedenceContext extends ParserRuleContext {
		public TerminalNode NULLS() { return getToken(HqlParser.NULLS, 0); }
		public TerminalNode FIRST() { return getToken(HqlParser.FIRST, 0); }
		public TerminalNode LAST() { return getToken(HqlParser.LAST, 0); }
		public NullsPrecedenceContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_nullsPrecedence; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterNullsPrecedence(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitNullsPrecedence(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitNullsPrecedence(this);
			else return visitor.visitChildren(this);
		}
	}

	public final NullsPrecedenceContext nullsPrecedence() throws RecognitionException {
		NullsPrecedenceContext _localctx = new NullsPrecedenceContext(_ctx, getState());
		enterRule(_localctx, 110, RULE_nullsPrecedence);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(787);
			match(NULLS);
			setState(788);
			_la = _input.LA(1);
			if ( !(_la==FIRST || _la==LAST) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class SortExpressionContext extends ParserRuleContext {
		public IdentifierContext identifier() {
			return getRuleContext(IdentifierContext.class,0);
		}
		public TerminalNode INTEGER_LITERAL() { return getToken(HqlParser.INTEGER_LITERAL, 0); }
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public SortExpressionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_sortExpression; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSortExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSortExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSortExpression(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SortExpressionContext sortExpression() throws RecognitionException {
		SortExpressionContext _localctx = new SortExpressionContext(_ctx, getState());
		enterRule(_localctx, 112, RULE_sortExpression);
		try {
			setState(793);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,76,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(790);
				identifier();
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(791);
				match(INTEGER_LITERAL);
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(792);
				expression(0);
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class SortDirectionContext extends ParserRuleContext {
		public TerminalNode ASC() { return getToken(HqlParser.ASC, 0); }
		public TerminalNode DESC() { return getToken(HqlParser.DESC, 0); }
		public SortDirectionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_sortDirection; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSortDirection(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSortDirection(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSortDirection(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SortDirectionContext sortDirection() throws RecognitionException {
		SortDirectionContext _localctx = new SortDirectionContext(_ctx, getState());
		enterRule(_localctx, 114, RULE_sortDirection);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(795);
			_la = _input.LA(1);
			if ( !(_la==ASC || _la==DESC) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class CollateFunctionContext extends ParserRuleContext {
		public TerminalNode COLLATE() { return getToken(HqlParser.COLLATE, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode AS() { return getToken(HqlParser.AS, 0); }
		public CollationContext collation() {
			return getRuleContext(CollationContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public CollateFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_collateFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCollateFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCollateFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCollateFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CollateFunctionContext collateFunction() throws RecognitionException {
		CollateFunctionContext _localctx = new CollateFunctionContext(_ctx, getState());
		enterRule(_localctx, 116, RULE_collateFunction);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(797);
			match(COLLATE);
			setState(798);
			match(LEFT_PAREN);
			setState(799);
			expression(0);
			setState(800);
			match(AS);
			setState(801);
			collation();
			setState(802);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class CollationContext extends ParserRuleContext {
		public SimplePathContext simplePath() {
			return getRuleContext(SimplePathContext.class,0);
		}
		public CollationContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_collation; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCollation(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCollation(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCollation(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CollationContext collation() throws RecognitionException {
		CollationContext _localctx = new CollationContext(_ctx, getState());
		enterRule(_localctx, 118, RULE_collation);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(804);
			simplePath();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class LimitClauseContext extends ParserRuleContext {
		public TerminalNode LIMIT() { return getToken(HqlParser.LIMIT, 0); }
		public ParameterOrIntegerLiteralContext parameterOrIntegerLiteral() {
			return getRuleContext(ParameterOrIntegerLiteralContext.class,0);
		}
		public LimitClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_limitClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterLimitClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitLimitClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitLimitClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final LimitClauseContext limitClause() throws RecognitionException {
		LimitClauseContext _localctx = new LimitClauseContext(_ctx, getState());
		enterRule(_localctx, 120, RULE_limitClause);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(806);
			match(LIMIT);
			setState(807);
			parameterOrIntegerLiteral();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class OffsetClauseContext extends ParserRuleContext {
		public TerminalNode OFFSET() { return getToken(HqlParser.OFFSET, 0); }
		public ParameterOrIntegerLiteralContext parameterOrIntegerLiteral() {
			return getRuleContext(ParameterOrIntegerLiteralContext.class,0);
		}
		public TerminalNode ROW() { return getToken(HqlParser.ROW, 0); }
		public TerminalNode ROWS() { return getToken(HqlParser.ROWS, 0); }
		public OffsetClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_offsetClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterOffsetClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitOffsetClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitOffsetClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final OffsetClauseContext offsetClause() throws RecognitionException {
		OffsetClauseContext _localctx = new OffsetClauseContext(_ctx, getState());
		enterRule(_localctx, 122, RULE_offsetClause);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(809);
			match(OFFSET);
			setState(810);
			parameterOrIntegerLiteral();
			setState(812);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==ROW || _la==ROWS) {
				{
				setState(811);
				_la = _input.LA(1);
				if ( !(_la==ROW || _la==ROWS) ) {
				_errHandler.recoverInline(this);
				}
				else {
					if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
					_errHandler.reportMatch(this);
					consume();
				}
				}
			}

			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class FetchClauseContext extends ParserRuleContext {
		public TerminalNode FETCH() { return getToken(HqlParser.FETCH, 0); }
		public TerminalNode FIRST() { return getToken(HqlParser.FIRST, 0); }
		public TerminalNode NEXT() { return getToken(HqlParser.NEXT, 0); }
		public TerminalNode ROW() { return getToken(HqlParser.ROW, 0); }
		public TerminalNode ROWS() { return getToken(HqlParser.ROWS, 0); }
		public ParameterOrIntegerLiteralContext parameterOrIntegerLiteral() {
			return getRuleContext(ParameterOrIntegerLiteralContext.class,0);
		}
		public ParameterOrNumberLiteralContext parameterOrNumberLiteral() {
			return getRuleContext(ParameterOrNumberLiteralContext.class,0);
		}
		public TerminalNode PERCENT() { return getToken(HqlParser.PERCENT, 0); }
		public TerminalNode ONLY() { return getToken(HqlParser.ONLY, 0); }
		public TerminalNode WITH() { return getToken(HqlParser.WITH, 0); }
		public TerminalNode TIES() { return getToken(HqlParser.TIES, 0); }
		public FetchClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_fetchClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterFetchClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitFetchClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitFetchClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final FetchClauseContext fetchClause() throws RecognitionException {
		FetchClauseContext _localctx = new FetchClauseContext(_ctx, getState());
		enterRule(_localctx, 124, RULE_fetchClause);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(814);
			match(FETCH);
			setState(815);
			_la = _input.LA(1);
			if ( !(_la==FIRST || _la==NEXT) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			setState(820);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,78,_ctx) ) {
			case 1:
				{
				setState(816);
				parameterOrIntegerLiteral();
				}
				break;
			case 2:
				{
				setState(817);
				parameterOrNumberLiteral();
				setState(818);
				match(PERCENT);
				}
				break;
			}
			setState(822);
			_la = _input.LA(1);
			if ( !(_la==ROW || _la==ROWS) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			setState(826);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case ONLY:
				{
				setState(823);
				match(ONLY);
				}
				break;
			case WITH:
				{
				setState(824);
				match(WITH);
				setState(825);
				match(TIES);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class ParameterOrIntegerLiteralContext extends ParserRuleContext {
		public ParameterContext parameter() {
			return getRuleContext(ParameterContext.class,0);
		}
		public TerminalNode INTEGER_LITERAL() { return getToken(HqlParser.INTEGER_LITERAL, 0); }
		public ParameterOrIntegerLiteralContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_parameterOrIntegerLiteral; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterParameterOrIntegerLiteral(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitParameterOrIntegerLiteral(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitParameterOrIntegerLiteral(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ParameterOrIntegerLiteralContext parameterOrIntegerLiteral() throws RecognitionException {
		ParameterOrIntegerLiteralContext _localctx = new ParameterOrIntegerLiteralContext(_ctx, getState());
		enterRule(_localctx, 126, RULE_parameterOrIntegerLiteral);
		try {
			setState(830);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case COLON:
			case QUESTION_MARK:
				enterOuterAlt(_localctx, 1);
				{
				setState(828);
				parameter();
				}
				break;
			case INTEGER_LITERAL:
				enterOuterAlt(_localctx, 2);
				{
				setState(829);
				match(INTEGER_LITERAL);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class ParameterOrNumberLiteralContext extends ParserRuleContext {
		public ParameterContext parameter() {
			return getRuleContext(ParameterContext.class,0);
		}
		public TerminalNode INTEGER_LITERAL() { return getToken(HqlParser.INTEGER_LITERAL, 0); }
		public TerminalNode FLOAT_LITERAL() { return getToken(HqlParser.FLOAT_LITERAL, 0); }
		public TerminalNode DOUBLE_LITERAL() { return getToken(HqlParser.DOUBLE_LITERAL, 0); }
		public ParameterOrNumberLiteralContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_parameterOrNumberLiteral; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterParameterOrNumberLiteral(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitParameterOrNumberLiteral(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitParameterOrNumberLiteral(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ParameterOrNumberLiteralContext parameterOrNumberLiteral() throws RecognitionException {
		ParameterOrNumberLiteralContext _localctx = new ParameterOrNumberLiteralContext(_ctx, getState());
		enterRule(_localctx, 128, RULE_parameterOrNumberLiteral);
		try {
			setState(836);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case COLON:
			case QUESTION_MARK:
				enterOuterAlt(_localctx, 1);
				{
				setState(832);
				parameter();
				}
				break;
			case INTEGER_LITERAL:
				enterOuterAlt(_localctx, 2);
				{
				setState(833);
				match(INTEGER_LITERAL);
				}
				break;
			case FLOAT_LITERAL:
				enterOuterAlt(_localctx, 3);
				{
				setState(834);
				match(FLOAT_LITERAL);
				}
				break;
			case DOUBLE_LITERAL:
				enterOuterAlt(_localctx, 4);
				{
				setState(835);
				match(DOUBLE_LITERAL);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class WhereClauseContext extends ParserRuleContext {
		public TerminalNode WHERE() { return getToken(HqlParser.WHERE, 0); }
		public PredicateContext predicate() {
			return getRuleContext(PredicateContext.class,0);
		}
		public WhereClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_whereClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterWhereClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitWhereClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitWhereClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final WhereClauseContext whereClause() throws RecognitionException {
		WhereClauseContext _localctx = new WhereClauseContext(_ctx, getState());
		enterRule(_localctx, 130, RULE_whereClause);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(838);
			match(WHERE);
			setState(839);
			predicate(0);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class PredicateContext extends ParserRuleContext {
		public PredicateContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_predicate; }
	 
		public PredicateContext() { }
		public void copyFrom(PredicateContext ctx) {
			super.copyFrom(ctx);
		}
	}
	public static class BetweenPredicateContext extends PredicateContext {
		public List<ExpressionContext> expression() {
			return getRuleContexts(ExpressionContext.class);
		}
		public ExpressionContext expression(int i) {
			return getRuleContext(ExpressionContext.class,i);
		}
		public TerminalNode BETWEEN() { return getToken(HqlParser.BETWEEN, 0); }
		public TerminalNode AND() { return getToken(HqlParser.AND, 0); }
		public TerminalNode NOT() { return getToken(HqlParser.NOT, 0); }
		public BetweenPredicateContext(PredicateContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterBetweenPredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitBetweenPredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitBetweenPredicate(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class ExistsPredicateContext extends PredicateContext {
		public TerminalNode EXISTS() { return getToken(HqlParser.EXISTS, 0); }
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public ExistsPredicateContext(PredicateContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterExistsPredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitExistsPredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitExistsPredicate(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class AndPredicateContext extends PredicateContext {
		public List<PredicateContext> predicate() {
			return getRuleContexts(PredicateContext.class);
		}
		public PredicateContext predicate(int i) {
			return getRuleContext(PredicateContext.class,i);
		}
		public TerminalNode AND() { return getToken(HqlParser.AND, 0); }
		public AndPredicateContext(PredicateContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterAndPredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitAndPredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitAndPredicate(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class GroupedPredicateContext extends PredicateContext {
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public PredicateContext predicate() {
			return getRuleContext(PredicateContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public GroupedPredicateContext(PredicateContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterGroupedPredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitGroupedPredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitGroupedPredicate(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class LikePredicateContext extends PredicateContext {
		public List<ExpressionContext> expression() {
			return getRuleContexts(ExpressionContext.class);
		}
		public ExpressionContext expression(int i) {
			return getRuleContext(ExpressionContext.class,i);
		}
		public TerminalNode LIKE() { return getToken(HqlParser.LIKE, 0); }
		public TerminalNode ILIKE() { return getToken(HqlParser.ILIKE, 0); }
		public TerminalNode NOT() { return getToken(HqlParser.NOT, 0); }
		public LikeEscapeContext likeEscape() {
			return getRuleContext(LikeEscapeContext.class,0);
		}
		public LikePredicateContext(PredicateContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterLikePredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitLikePredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitLikePredicate(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class InPredicateContext extends PredicateContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode IN() { return getToken(HqlParser.IN, 0); }
		public InListContext inList() {
			return getRuleContext(InListContext.class,0);
		}
		public TerminalNode NOT() { return getToken(HqlParser.NOT, 0); }
		public InPredicateContext(PredicateContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterInPredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitInPredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitInPredicate(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class ComparisonPredicateContext extends PredicateContext {
		public List<ExpressionContext> expression() {
			return getRuleContexts(ExpressionContext.class);
		}
		public ExpressionContext expression(int i) {
			return getRuleContext(ExpressionContext.class,i);
		}
		public ComparisonOperatorContext comparisonOperator() {
			return getRuleContext(ComparisonOperatorContext.class,0);
		}
		public ComparisonPredicateContext(PredicateContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterComparisonPredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitComparisonPredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitComparisonPredicate(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class ExistsCollectionPartPredicateContext extends PredicateContext {
		public TerminalNode EXISTS() { return getToken(HqlParser.EXISTS, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public SimplePathContext simplePath() {
			return getRuleContext(SimplePathContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode ELEMENTS() { return getToken(HqlParser.ELEMENTS, 0); }
		public TerminalNode INDICES() { return getToken(HqlParser.INDICES, 0); }
		public ExistsCollectionPartPredicateContext(PredicateContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterExistsCollectionPartPredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitExistsCollectionPartPredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitExistsCollectionPartPredicate(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class NegatedPredicateContext extends PredicateContext {
		public TerminalNode NOT() { return getToken(HqlParser.NOT, 0); }
		public PredicateContext predicate() {
			return getRuleContext(PredicateContext.class,0);
		}
		public NegatedPredicateContext(PredicateContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterNegatedPredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitNegatedPredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitNegatedPredicate(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class BooleanExpressionPredicateContext extends PredicateContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public BooleanExpressionPredicateContext(PredicateContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterBooleanExpressionPredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitBooleanExpressionPredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitBooleanExpressionPredicate(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class OrPredicateContext extends PredicateContext {
		public List<PredicateContext> predicate() {
			return getRuleContexts(PredicateContext.class);
		}
		public PredicateContext predicate(int i) {
			return getRuleContext(PredicateContext.class,i);
		}
		public TerminalNode OR() { return getToken(HqlParser.OR, 0); }
		public OrPredicateContext(PredicateContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterOrPredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitOrPredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitOrPredicate(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class MemberOfPredicateContext extends PredicateContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode MEMBER() { return getToken(HqlParser.MEMBER, 0); }
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public TerminalNode NOT() { return getToken(HqlParser.NOT, 0); }
		public TerminalNode OF() { return getToken(HqlParser.OF, 0); }
		public MemberOfPredicateContext(PredicateContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterMemberOfPredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitMemberOfPredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitMemberOfPredicate(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class IsEmptyPredicateContext extends PredicateContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode IS() { return getToken(HqlParser.IS, 0); }
		public TerminalNode EMPTY() { return getToken(HqlParser.EMPTY, 0); }
		public TerminalNode NOT() { return getToken(HqlParser.NOT, 0); }
		public IsEmptyPredicateContext(PredicateContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterIsEmptyPredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitIsEmptyPredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitIsEmptyPredicate(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class IsNullPredicateContext extends PredicateContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode IS() { return getToken(HqlParser.IS, 0); }
		public TerminalNode NULL() { return getToken(HqlParser.NULL, 0); }
		public TerminalNode NOT() { return getToken(HqlParser.NOT, 0); }
		public IsNullPredicateContext(PredicateContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterIsNullPredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitIsNullPredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitIsNullPredicate(this);
			else return visitor.visitChildren(this);
		}
	}

	public final PredicateContext predicate() throws RecognitionException {
		return predicate(0);
	}

	private PredicateContext predicate(int _p) throws RecognitionException {
		ParserRuleContext _parentctx = _ctx;
		int _parentState = getState();
		PredicateContext _localctx = new PredicateContext(_ctx, _parentState);
		PredicateContext _prevctx = _localctx;
		int _startState = 132;
		enterRecursionRule(_localctx, 132, RULE_predicate, _p);
		int _la;
		try {
			int _alt;
			enterOuterAlt(_localctx, 1);
			{
			setState(910);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,90,_ctx) ) {
			case 1:
				{
				_localctx = new GroupedPredicateContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;

				setState(842);
				match(LEFT_PAREN);
				setState(843);
				predicate(0);
				setState(844);
				match(RIGHT_PAREN);
				}
				break;
			case 2:
				{
				_localctx = new IsNullPredicateContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(846);
				expression(0);
				setState(847);
				match(IS);
				setState(849);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==NOT) {
					{
					setState(848);
					match(NOT);
					}
				}

				setState(851);
				match(NULL);
				}
				break;
			case 3:
				{
				_localctx = new IsEmptyPredicateContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(853);
				expression(0);
				setState(854);
				match(IS);
				setState(856);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==NOT) {
					{
					setState(855);
					match(NOT);
					}
				}

				setState(858);
				match(EMPTY);
				}
				break;
			case 4:
				{
				_localctx = new InPredicateContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(860);
				expression(0);
				setState(862);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==NOT) {
					{
					setState(861);
					match(NOT);
					}
				}

				setState(864);
				match(IN);
				setState(865);
				inList();
				}
				break;
			case 5:
				{
				_localctx = new BetweenPredicateContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(867);
				expression(0);
				setState(869);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==NOT) {
					{
					setState(868);
					match(NOT);
					}
				}

				setState(871);
				match(BETWEEN);
				setState(872);
				expression(0);
				setState(873);
				match(AND);
				setState(874);
				expression(0);
				}
				break;
			case 6:
				{
				_localctx = new LikePredicateContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(876);
				expression(0);
				setState(878);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==NOT) {
					{
					setState(877);
					match(NOT);
					}
				}

				setState(880);
				_la = _input.LA(1);
				if ( !(_la==ILIKE || _la==LIKE) ) {
				_errHandler.recoverInline(this);
				}
				else {
					if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
					_errHandler.reportMatch(this);
					consume();
				}
				setState(881);
				expression(0);
				setState(883);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,87,_ctx) ) {
				case 1:
					{
					setState(882);
					likeEscape();
					}
					break;
				}
				}
				break;
			case 7:
				{
				_localctx = new ComparisonPredicateContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(885);
				expression(0);
				setState(886);
				comparisonOperator();
				setState(887);
				expression(0);
				}
				break;
			case 8:
				{
				_localctx = new ExistsCollectionPartPredicateContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(889);
				match(EXISTS);
				setState(890);
				_la = _input.LA(1);
				if ( !(_la==ELEMENTS || _la==INDICES) ) {
				_errHandler.recoverInline(this);
				}
				else {
					if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
					_errHandler.reportMatch(this);
					consume();
				}
				setState(891);
				match(LEFT_PAREN);
				setState(892);
				simplePath();
				setState(893);
				match(RIGHT_PAREN);
				}
				break;
			case 9:
				{
				_localctx = new ExistsPredicateContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(895);
				match(EXISTS);
				setState(896);
				expression(0);
				}
				break;
			case 10:
				{
				_localctx = new MemberOfPredicateContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(897);
				expression(0);
				setState(899);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==NOT) {
					{
					setState(898);
					match(NOT);
					}
				}

				setState(901);
				match(MEMBER);
				setState(903);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,89,_ctx) ) {
				case 1:
					{
					setState(902);
					match(OF);
					}
					break;
				}
				setState(905);
				path();
				}
				break;
			case 11:
				{
				_localctx = new NegatedPredicateContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(907);
				match(NOT);
				setState(908);
				predicate(4);
				}
				break;
			case 12:
				{
				_localctx = new BooleanExpressionPredicateContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(909);
				expression(0);
				}
				break;
			}
			_ctx.stop = _input.LT(-1);
			setState(920);
			_errHandler.sync(this);
			_alt = getInterpreter().adaptivePredict(_input,92,_ctx);
			while ( _alt!=2 && _alt!=org.antlr.v4.runtime.atn.ATN.INVALID_ALT_NUMBER ) {
				if ( _alt==1 ) {
					if ( _parseListeners!=null ) triggerExitRuleEvent();
					_prevctx = _localctx;
					{
					setState(918);
					_errHandler.sync(this);
					switch ( getInterpreter().adaptivePredict(_input,91,_ctx) ) {
					case 1:
						{
						_localctx = new AndPredicateContext(new PredicateContext(_parentctx, _parentState));
						pushNewRecursionContext(_localctx, _startState, RULE_predicate);
						setState(912);
						if (!(precpred(_ctx, 3))) throw new FailedPredicateException(this, "precpred(_ctx, 3)");
						setState(913);
						match(AND);
						setState(914);
						predicate(4);
						}
						break;
					case 2:
						{
						_localctx = new OrPredicateContext(new PredicateContext(_parentctx, _parentState));
						pushNewRecursionContext(_localctx, _startState, RULE_predicate);
						setState(915);
						if (!(precpred(_ctx, 2))) throw new FailedPredicateException(this, "precpred(_ctx, 2)");
						setState(916);
						match(OR);
						setState(917);
						predicate(3);
						}
						break;
					}
					} 
				}
				setState(922);
				_errHandler.sync(this);
				_alt = getInterpreter().adaptivePredict(_input,92,_ctx);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			unrollRecursionContexts(_parentctx);
		}
		return _localctx;
	}

	public static class ComparisonOperatorContext extends ParserRuleContext {
		public TerminalNode EQUAL() { return getToken(HqlParser.EQUAL, 0); }
		public TerminalNode NOT_EQUAL() { return getToken(HqlParser.NOT_EQUAL, 0); }
		public TerminalNode GREATER() { return getToken(HqlParser.GREATER, 0); }
		public TerminalNode GREATER_EQUAL() { return getToken(HqlParser.GREATER_EQUAL, 0); }
		public TerminalNode LESS() { return getToken(HqlParser.LESS, 0); }
		public TerminalNode LESS_EQUAL() { return getToken(HqlParser.LESS_EQUAL, 0); }
		public TerminalNode IS() { return getToken(HqlParser.IS, 0); }
		public TerminalNode DISTINCT() { return getToken(HqlParser.DISTINCT, 0); }
		public TerminalNode FROM() { return getToken(HqlParser.FROM, 0); }
		public TerminalNode NOT() { return getToken(HqlParser.NOT, 0); }
		public ComparisonOperatorContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_comparisonOperator; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterComparisonOperator(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitComparisonOperator(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitComparisonOperator(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ComparisonOperatorContext comparisonOperator() throws RecognitionException {
		ComparisonOperatorContext _localctx = new ComparisonOperatorContext(_ctx, getState());
		enterRule(_localctx, 134, RULE_comparisonOperator);
		try {
			setState(936);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,93,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(923);
				match(EQUAL);
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(924);
				match(NOT_EQUAL);
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(925);
				match(GREATER);
				}
				break;
			case 4:
				enterOuterAlt(_localctx, 4);
				{
				setState(926);
				match(GREATER_EQUAL);
				}
				break;
			case 5:
				enterOuterAlt(_localctx, 5);
				{
				setState(927);
				match(LESS);
				}
				break;
			case 6:
				enterOuterAlt(_localctx, 6);
				{
				setState(928);
				match(LESS_EQUAL);
				}
				break;
			case 7:
				enterOuterAlt(_localctx, 7);
				{
				setState(929);
				match(IS);
				setState(930);
				match(DISTINCT);
				setState(931);
				match(FROM);
				}
				break;
			case 8:
				enterOuterAlt(_localctx, 8);
				{
				setState(932);
				match(IS);
				setState(933);
				match(NOT);
				setState(934);
				match(DISTINCT);
				setState(935);
				match(FROM);
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class InListContext extends ParserRuleContext {
		public InListContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_inList; }
	 
		public InListContext() { }
		public void copyFrom(InListContext ctx) {
			super.copyFrom(ctx);
		}
	}
	public static class SubqueryInListContext extends InListContext {
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public SubqueryContext subquery() {
			return getRuleContext(SubqueryContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public SubqueryInListContext(InListContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSubqueryInList(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSubqueryInList(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSubqueryInList(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class PersistentCollectionReferenceInListContext extends InListContext {
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public SimplePathContext simplePath() {
			return getRuleContext(SimplePathContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode ELEMENTS() { return getToken(HqlParser.ELEMENTS, 0); }
		public TerminalNode INDICES() { return getToken(HqlParser.INDICES, 0); }
		public PersistentCollectionReferenceInListContext(InListContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterPersistentCollectionReferenceInList(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitPersistentCollectionReferenceInList(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitPersistentCollectionReferenceInList(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class ParamInListContext extends InListContext {
		public ParameterContext parameter() {
			return getRuleContext(ParameterContext.class,0);
		}
		public ParamInListContext(InListContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterParamInList(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitParamInList(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitParamInList(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class ExplicitTupleInListContext extends InListContext {
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public List<ExpressionOrPredicateContext> expressionOrPredicate() {
			return getRuleContexts(ExpressionOrPredicateContext.class);
		}
		public ExpressionOrPredicateContext expressionOrPredicate(int i) {
			return getRuleContext(ExpressionOrPredicateContext.class,i);
		}
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public ExplicitTupleInListContext(InListContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterExplicitTupleInList(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitExplicitTupleInList(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitExplicitTupleInList(this);
			else return visitor.visitChildren(this);
		}
	}

	public final InListContext inList() throws RecognitionException {
		InListContext _localctx = new InListContext(_ctx, getState());
		enterRule(_localctx, 136, RULE_inList);
		int _la;
		try {
			setState(960);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,96,_ctx) ) {
			case 1:
				_localctx = new PersistentCollectionReferenceInListContext(_localctx);
				enterOuterAlt(_localctx, 1);
				{
				setState(938);
				_la = _input.LA(1);
				if ( !(_la==ELEMENTS || _la==INDICES) ) {
				_errHandler.recoverInline(this);
				}
				else {
					if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
					_errHandler.reportMatch(this);
					consume();
				}
				setState(939);
				match(LEFT_PAREN);
				setState(940);
				simplePath();
				setState(941);
				match(RIGHT_PAREN);
				}
				break;
			case 2:
				_localctx = new ExplicitTupleInListContext(_localctx);
				enterOuterAlt(_localctx, 2);
				{
				setState(943);
				match(LEFT_PAREN);
				setState(952);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if ((((_la) & ~0x3f) == 0 && ((1L << _la) & ((1L << INTEGER_LITERAL) | (1L << LONG_LITERAL) | (1L << FLOAT_LITERAL) | (1L << DOUBLE_LITERAL) | (1L << BIG_INTEGER_LITERAL) | (1L << BIG_DECIMAL_LITERAL) | (1L << HEX_LITERAL) | (1L << STRING_LITERAL) | (1L << JAVA_STRING_LITERAL) | (1L << BINARY_LITERAL) | (1L << TIMESTAMP_ESCAPE_START) | (1L << DATE_ESCAPE_START) | (1L << TIME_ESCAPE_START) | (1L << LEFT_PAREN) | (1L << LEFT_BRACE) | (1L << PLUS) | (1L << MINUS) | (1L << COLON) | (1L << QUESTION_MARK) | (1L << ID) | (1L << VERSION) | (1L << VERSIONED) | (1L << NATURALID) | (1L << FK) | (1L << ALL) | (1L << AND) | (1L << ANY) | (1L << AS) | (1L << ASC) | (1L << AVG) | (1L << BETWEEN) | (1L << BOTH) | (1L << BY) | (1L << CASE) | (1L << CAST) | (1L << COLLATE) | (1L << COUNT) | (1L << CROSS) | (1L << CUBE) | (1L << CURRENT) | (1L << CURRENT_DATE))) != 0) || ((((_la - 64)) & ~0x3f) == 0 && ((1L << (_la - 64)) & ((1L << (CURRENT_INSTANT - 64)) | (1L << (CURRENT_TIME - 64)) | (1L << (CURRENT_TIMESTAMP - 64)) | (1L << (DATE - 64)) | (1L << (DATETIME - 64)) | (1L << (DAY - 64)) | (1L << (DELETE - 64)) | (1L << (DESC - 64)) | (1L << (DISTINCT - 64)) | (1L << (ELEMENT - 64)) | (1L << (ELEMENTS - 64)) | (1L << (ELSE - 64)) | (1L << (EMPTY - 64)) | (1L << (END - 64)) | (1L << (ENTRY - 64)) | (1L << (ERROR - 64)) | (1L << (ESCAPE - 64)) | (1L << (EVERY - 64)) | (1L << (EXCEPT - 64)) | (1L << (EXCLUDE - 64)) | (1L << (EXISTS - 64)) | (1L << (EXTRACT - 64)) | (1L << (FETCH - 64)) | (1L << (FILTER - 64)) | (1L << (FIRST - 64)) | (1L << (FOLLOWING - 64)) | (1L << (FOR - 64)) | (1L << (FORMAT - 64)) | (1L << (FROM - 64)) | (1L << (FULL - 64)) | (1L << (FUNCTION - 64)) | (1L << (GROUP - 64)) | (1L << (GROUPS - 64)) | (1L << (HAVING - 64)) | (1L << (HOUR - 64)) | (1L << (IGNORE - 64)) | (1L << (ILIKE - 64)) | (1L << (IN - 64)) | (1L << (INDEX - 64)) | (1L << (INDICES - 64)) | (1L << (INNER - 64)) | (1L << (INSERT - 64)) | (1L << (INSTANT - 64)) | (1L << (INTERSECT - 64)) | (1L << (INTO - 64)) | (1L << (IS - 64)) | (1L << (JOIN - 64)) | (1L << (KEY - 64)) | (1L << (LAST - 64)) | (1L << (LEADING - 64)) | (1L << (LEFT - 64)) | (1L << (LIKE - 64)) | (1L << (LIMIT - 64)) | (1L << (LIST - 64)) | (1L << (LISTAGG - 64)) | (1L << (LOCAL - 64)) | (1L << (LOCAL_DATE - 64)) | (1L << (LOCAL_DATETIME - 64)) | (1L << (LOCAL_TIME - 64)) | (1L << (MAP - 64)) | (1L << (MAX - 64)) | (1L << (MAXELEMENT - 64)) | (1L << (MAXINDEX - 64)))) != 0) || ((((_la - 128)) & ~0x3f) == 0 && ((1L << (_la - 128)) & ((1L << (MEMBER - 128)) | (1L << (MICROSECOND - 128)) | (1L << (MILLISECOND - 128)) | (1L << (MIN - 128)) | (1L << (MINELEMENT - 128)) | (1L << (MININDEX - 128)) | (1L << (MINUTE - 128)) | (1L << (MONTH - 128)) | (1L << (NANOSECOND - 128)) | (1L << (NEW - 128)) | (1L << (NEXT - 128)) | (1L << (NO - 128)) | (1L << (NOT - 128)) | (1L << (NULLS - 128)) | (1L << (OBJECT - 128)) | (1L << (OF - 128)) | (1L << (OFFSET - 128)) | (1L << (OFFSET_DATETIME - 128)) | (1L << (ON - 128)) | (1L << (ONLY - 128)) | (1L << (OR - 128)) | (1L << (ORDER - 128)) | (1L << (OTHERS - 128)) | (1L << (OUTER - 128)) | (1L << (OVER - 128)) | (1L << (OVERFLOW - 128)) | (1L << (OVERLAY - 128)) | (1L << (PAD - 128)) | (1L << (PARTITION - 128)) | (1L << (PERCENT - 128)) | (1L << (PLACING - 128)) | (1L << (POSITION - 128)) | (1L << (PRECEDING - 128)) | (1L << (QUARTER - 128)) | (1L << (RANGE - 128)) | (1L << (RESPECT - 128)) | (1L << (RIGHT - 128)) | (1L << (ROLLUP - 128)) | (1L << (ROW - 128)) | (1L << (ROWS - 128)) | (1L << (SECOND - 128)) | (1L << (SELECT - 128)) | (1L << (SET - 128)) | (1L << (SIZE - 128)) | (1L << (SOME - 128)) | (1L << (SUBSTRING - 128)) | (1L << (SUM - 128)) | (1L << (THEN - 128)) | (1L << (TIES - 128)) | (1L << (TIME - 128)) | (1L << (TIMESTAMP - 128)) | (1L << (TIMEZONE_HOUR - 128)) | (1L << (TIMEZONE_MINUTE - 128)) | (1L << (TRAILING - 128)) | (1L << (TREAT - 128)) | (1L << (TRIM - 128)) | (1L << (TRUNCATE - 128)) | (1L << (TYPE - 128)) | (1L << (UNBOUNDED - 128)) | (1L << (UNION - 128)) | (1L << (UPDATE - 128)) | (1L << (VALUE - 128)) | (1L << (VALUES - 128)) | (1L << (WEEK - 128)))) != 0) || ((((_la - 192)) & ~0x3f) == 0 && ((1L << (_la - 192)) & ((1L << (WHEN - 192)) | (1L << (WHERE - 192)) | (1L << (WITH - 192)) | (1L << (WITHIN - 192)) | (1L << (WITHOUT - 192)) | (1L << (YEAR - 192)) | (1L << (TRUE - 192)) | (1L << (FALSE - 192)) | (1L << (NULL - 192)) | (1L << (IDENTIFIER - 192)) | (1L << (QUOTED_IDENTIFIER - 192)))) != 0)) {
					{
					setState(944);
					expressionOrPredicate();
					setState(949);
					_errHandler.sync(this);
					_la = _input.LA(1);
					while (_la==COMMA) {
						{
						{
						setState(945);
						match(COMMA);
						setState(946);
						expressionOrPredicate();
						}
						}
						setState(951);
						_errHandler.sync(this);
						_la = _input.LA(1);
					}
					}
				}

				setState(954);
				match(RIGHT_PAREN);
				}
				break;
			case 3:
				_localctx = new SubqueryInListContext(_localctx);
				enterOuterAlt(_localctx, 3);
				{
				setState(955);
				match(LEFT_PAREN);
				setState(956);
				subquery();
				setState(957);
				match(RIGHT_PAREN);
				}
				break;
			case 4:
				_localctx = new ParamInListContext(_localctx);
				enterOuterAlt(_localctx, 4);
				{
				setState(959);
				parameter();
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class LikeEscapeContext extends ParserRuleContext {
		public TerminalNode ESCAPE() { return getToken(HqlParser.ESCAPE, 0); }
		public TerminalNode STRING_LITERAL() { return getToken(HqlParser.STRING_LITERAL, 0); }
		public TerminalNode JAVA_STRING_LITERAL() { return getToken(HqlParser.JAVA_STRING_LITERAL, 0); }
		public ParameterContext parameter() {
			return getRuleContext(ParameterContext.class,0);
		}
		public LikeEscapeContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_likeEscape; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterLikeEscape(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitLikeEscape(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitLikeEscape(this);
			else return visitor.visitChildren(this);
		}
	}

	public final LikeEscapeContext likeEscape() throws RecognitionException {
		LikeEscapeContext _localctx = new LikeEscapeContext(_ctx, getState());
		enterRule(_localctx, 138, RULE_likeEscape);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(962);
			match(ESCAPE);
			setState(966);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case STRING_LITERAL:
				{
				setState(963);
				match(STRING_LITERAL);
				}
				break;
			case JAVA_STRING_LITERAL:
				{
				setState(964);
				match(JAVA_STRING_LITERAL);
				}
				break;
			case COLON:
			case QUESTION_MARK:
				{
				setState(965);
				parameter();
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class ExpressionContext extends ParserRuleContext {
		public ExpressionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_expression; }
	 
		public ExpressionContext() { }
		public void copyFrom(ExpressionContext ctx) {
			super.copyFrom(ctx);
		}
	}
	public static class AdditionExpressionContext extends ExpressionContext {
		public List<ExpressionContext> expression() {
			return getRuleContexts(ExpressionContext.class);
		}
		public ExpressionContext expression(int i) {
			return getRuleContext(ExpressionContext.class,i);
		}
		public AdditiveOperatorContext additiveOperator() {
			return getRuleContext(AdditiveOperatorContext.class,0);
		}
		public AdditionExpressionContext(ExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterAdditionExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitAdditionExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitAdditionExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class FromDurationExpressionContext extends ExpressionContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode BY() { return getToken(HqlParser.BY, 0); }
		public DatetimeFieldContext datetimeField() {
			return getRuleContext(DatetimeFieldContext.class,0);
		}
		public FromDurationExpressionContext(ExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterFromDurationExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitFromDurationExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitFromDurationExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class BarePrimaryExpressionContext extends ExpressionContext {
		public PrimaryExpressionContext primaryExpression() {
			return getRuleContext(PrimaryExpressionContext.class,0);
		}
		public BarePrimaryExpressionContext(ExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterBarePrimaryExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitBarePrimaryExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitBarePrimaryExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class TupleExpressionContext extends ExpressionContext {
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public List<ExpressionOrPredicateContext> expressionOrPredicate() {
			return getRuleContexts(ExpressionOrPredicateContext.class);
		}
		public ExpressionOrPredicateContext expressionOrPredicate(int i) {
			return getRuleContext(ExpressionOrPredicateContext.class,i);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public TupleExpressionContext(ExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterTupleExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitTupleExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitTupleExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class UnaryExpressionContext extends ExpressionContext {
		public SignOperatorContext signOperator() {
			return getRuleContext(SignOperatorContext.class,0);
		}
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public UnaryExpressionContext(ExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterUnaryExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitUnaryExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitUnaryExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class GroupedExpressionContext extends ExpressionContext {
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public GroupedExpressionContext(ExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterGroupedExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitGroupedExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitGroupedExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class ConcatenationExpressionContext extends ExpressionContext {
		public List<ExpressionContext> expression() {
			return getRuleContexts(ExpressionContext.class);
		}
		public ExpressionContext expression(int i) {
			return getRuleContext(ExpressionContext.class,i);
		}
		public TerminalNode DOUBLE_PIPE() { return getToken(HqlParser.DOUBLE_PIPE, 0); }
		public ConcatenationExpressionContext(ExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterConcatenationExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitConcatenationExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitConcatenationExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class MultiplicationExpressionContext extends ExpressionContext {
		public List<ExpressionContext> expression() {
			return getRuleContexts(ExpressionContext.class);
		}
		public ExpressionContext expression(int i) {
			return getRuleContext(ExpressionContext.class,i);
		}
		public MultiplicativeOperatorContext multiplicativeOperator() {
			return getRuleContext(MultiplicativeOperatorContext.class,0);
		}
		public MultiplicationExpressionContext(ExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterMultiplicationExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitMultiplicationExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitMultiplicationExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class ToDurationExpressionContext extends ExpressionContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public DatetimeFieldContext datetimeField() {
			return getRuleContext(DatetimeFieldContext.class,0);
		}
		public ToDurationExpressionContext(ExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterToDurationExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitToDurationExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitToDurationExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class SubqueryExpressionContext extends ExpressionContext {
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public SubqueryContext subquery() {
			return getRuleContext(SubqueryContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public SubqueryExpressionContext(ExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSubqueryExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSubqueryExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSubqueryExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class UnaryNumericLiteralExpressionContext extends ExpressionContext {
		public SignOperatorContext signOperator() {
			return getRuleContext(SignOperatorContext.class,0);
		}
		public NumericLiteralContext numericLiteral() {
			return getRuleContext(NumericLiteralContext.class,0);
		}
		public UnaryNumericLiteralExpressionContext(ExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterUnaryNumericLiteralExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitUnaryNumericLiteralExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitUnaryNumericLiteralExpression(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ExpressionContext expression() throws RecognitionException {
		return expression(0);
	}

	private ExpressionContext expression(int _p) throws RecognitionException {
		ParserRuleContext _parentctx = _ctx;
		int _parentState = getState();
		ExpressionContext _localctx = new ExpressionContext(_ctx, _parentState);
		ExpressionContext _prevctx = _localctx;
		int _startState = 140;
		enterRecursionRule(_localctx, 140, RULE_expression, _p);
		int _la;
		try {
			int _alt;
			enterOuterAlt(_localctx, 1);
			{
			setState(994);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,99,_ctx) ) {
			case 1:
				{
				_localctx = new GroupedExpressionContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;

				setState(969);
				match(LEFT_PAREN);
				setState(970);
				expression(0);
				setState(971);
				match(RIGHT_PAREN);
				}
				break;
			case 2:
				{
				_localctx = new TupleExpressionContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(973);
				match(LEFT_PAREN);
				setState(974);
				expressionOrPredicate();
				setState(977); 
				_errHandler.sync(this);
				_la = _input.LA(1);
				do {
					{
					{
					setState(975);
					match(COMMA);
					setState(976);
					expressionOrPredicate();
					}
					}
					setState(979); 
					_errHandler.sync(this);
					_la = _input.LA(1);
				} while ( _la==COMMA );
				setState(981);
				match(RIGHT_PAREN);
				}
				break;
			case 3:
				{
				_localctx = new SubqueryExpressionContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(983);
				match(LEFT_PAREN);
				setState(984);
				subquery();
				setState(985);
				match(RIGHT_PAREN);
				}
				break;
			case 4:
				{
				_localctx = new BarePrimaryExpressionContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(987);
				primaryExpression();
				}
				break;
			case 5:
				{
				_localctx = new UnaryNumericLiteralExpressionContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(988);
				signOperator();
				setState(989);
				numericLiteral();
				}
				break;
			case 6:
				{
				_localctx = new UnaryExpressionContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(991);
				signOperator();
				setState(992);
				expression(6);
				}
				break;
			}
			_ctx.stop = _input.LT(-1);
			setState(1014);
			_errHandler.sync(this);
			_alt = getInterpreter().adaptivePredict(_input,101,_ctx);
			while ( _alt!=2 && _alt!=org.antlr.v4.runtime.atn.ATN.INVALID_ALT_NUMBER ) {
				if ( _alt==1 ) {
					if ( _parseListeners!=null ) triggerExitRuleEvent();
					_prevctx = _localctx;
					{
					setState(1012);
					_errHandler.sync(this);
					switch ( getInterpreter().adaptivePredict(_input,100,_ctx) ) {
					case 1:
						{
						_localctx = new MultiplicationExpressionContext(new ExpressionContext(_parentctx, _parentState));
						pushNewRecursionContext(_localctx, _startState, RULE_expression);
						setState(996);
						if (!(precpred(_ctx, 3))) throw new FailedPredicateException(this, "precpred(_ctx, 3)");
						setState(997);
						multiplicativeOperator();
						setState(998);
						expression(4);
						}
						break;
					case 2:
						{
						_localctx = new AdditionExpressionContext(new ExpressionContext(_parentctx, _parentState));
						pushNewRecursionContext(_localctx, _startState, RULE_expression);
						setState(1000);
						if (!(precpred(_ctx, 2))) throw new FailedPredicateException(this, "precpred(_ctx, 2)");
						setState(1001);
						additiveOperator();
						setState(1002);
						expression(3);
						}
						break;
					case 3:
						{
						_localctx = new ConcatenationExpressionContext(new ExpressionContext(_parentctx, _parentState));
						pushNewRecursionContext(_localctx, _startState, RULE_expression);
						setState(1004);
						if (!(precpred(_ctx, 1))) throw new FailedPredicateException(this, "precpred(_ctx, 1)");
						setState(1005);
						match(DOUBLE_PIPE);
						setState(1006);
						expression(2);
						}
						break;
					case 4:
						{
						_localctx = new ToDurationExpressionContext(new ExpressionContext(_parentctx, _parentState));
						pushNewRecursionContext(_localctx, _startState, RULE_expression);
						setState(1007);
						if (!(precpred(_ctx, 5))) throw new FailedPredicateException(this, "precpred(_ctx, 5)");
						setState(1008);
						datetimeField();
						}
						break;
					case 5:
						{
						_localctx = new FromDurationExpressionContext(new ExpressionContext(_parentctx, _parentState));
						pushNewRecursionContext(_localctx, _startState, RULE_expression);
						setState(1009);
						if (!(precpred(_ctx, 4))) throw new FailedPredicateException(this, "precpred(_ctx, 4)");
						setState(1010);
						match(BY);
						setState(1011);
						datetimeField();
						}
						break;
					}
					} 
				}
				setState(1016);
				_errHandler.sync(this);
				_alt = getInterpreter().adaptivePredict(_input,101,_ctx);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			unrollRecursionContexts(_parentctx);
		}
		return _localctx;
	}

	public static class PrimaryExpressionContext extends ParserRuleContext {
		public PrimaryExpressionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_primaryExpression; }
	 
		public PrimaryExpressionContext() { }
		public void copyFrom(PrimaryExpressionContext ctx) {
			super.copyFrom(ctx);
		}
	}
	public static class FunctionExpressionContext extends PrimaryExpressionContext {
		public FunctionContext function() {
			return getRuleContext(FunctionContext.class,0);
		}
		public FunctionExpressionContext(PrimaryExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterFunctionExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitFunctionExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitFunctionExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class LiteralExpressionContext extends PrimaryExpressionContext {
		public LiteralContext literal() {
			return getRuleContext(LiteralContext.class,0);
		}
		public LiteralExpressionContext(PrimaryExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterLiteralExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitLiteralExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitLiteralExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class ParameterExpressionContext extends PrimaryExpressionContext {
		public ParameterContext parameter() {
			return getRuleContext(ParameterContext.class,0);
		}
		public ParameterExpressionContext(PrimaryExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterParameterExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitParameterExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitParameterExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class EntityTypeExpressionContext extends PrimaryExpressionContext {
		public EntityTypeReferenceContext entityTypeReference() {
			return getRuleContext(EntityTypeReferenceContext.class,0);
		}
		public EntityTypeExpressionContext(PrimaryExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterEntityTypeExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitEntityTypeExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitEntityTypeExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class EntityIdExpressionContext extends PrimaryExpressionContext {
		public EntityIdReferenceContext entityIdReference() {
			return getRuleContext(EntityIdReferenceContext.class,0);
		}
		public EntityIdExpressionContext(PrimaryExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterEntityIdExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitEntityIdExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitEntityIdExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class EntityVersionExpressionContext extends PrimaryExpressionContext {
		public EntityVersionReferenceContext entityVersionReference() {
			return getRuleContext(EntityVersionReferenceContext.class,0);
		}
		public EntityVersionExpressionContext(PrimaryExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterEntityVersionExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitEntityVersionExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitEntityVersionExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class GeneralPathExpressionContext extends PrimaryExpressionContext {
		public GeneralPathFragmentContext generalPathFragment() {
			return getRuleContext(GeneralPathFragmentContext.class,0);
		}
		public GeneralPathExpressionContext(PrimaryExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterGeneralPathExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitGeneralPathExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitGeneralPathExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class EntityNaturalIdExpressionContext extends PrimaryExpressionContext {
		public EntityNaturalIdReferenceContext entityNaturalIdReference() {
			return getRuleContext(EntityNaturalIdReferenceContext.class,0);
		}
		public EntityNaturalIdExpressionContext(PrimaryExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterEntityNaturalIdExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitEntityNaturalIdExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitEntityNaturalIdExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class CaseExpressionContext extends PrimaryExpressionContext {
		public CaseListContext caseList() {
			return getRuleContext(CaseListContext.class,0);
		}
		public CaseExpressionContext(PrimaryExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCaseExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCaseExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCaseExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class ToOneFkExpressionContext extends PrimaryExpressionContext {
		public ToOneFkReferenceContext toOneFkReference() {
			return getRuleContext(ToOneFkReferenceContext.class,0);
		}
		public ToOneFkExpressionContext(PrimaryExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterToOneFkExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitToOneFkExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitToOneFkExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class SyntacticPathExpressionContext extends PrimaryExpressionContext {
		public SyntacticDomainPathContext syntacticDomainPath() {
			return getRuleContext(SyntacticDomainPathContext.class,0);
		}
		public PathContinuationContext pathContinuation() {
			return getRuleContext(PathContinuationContext.class,0);
		}
		public SyntacticPathExpressionContext(PrimaryExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSyntacticPathExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSyntacticPathExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSyntacticPathExpression(this);
			else return visitor.visitChildren(this);
		}
	}

	public final PrimaryExpressionContext primaryExpression() throws RecognitionException {
		PrimaryExpressionContext _localctx = new PrimaryExpressionContext(_ctx, getState());
		enterRule(_localctx, 142, RULE_primaryExpression);
		try {
			setState(1031);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,103,_ctx) ) {
			case 1:
				_localctx = new CaseExpressionContext(_localctx);
				enterOuterAlt(_localctx, 1);
				{
				setState(1017);
				caseList();
				}
				break;
			case 2:
				_localctx = new LiteralExpressionContext(_localctx);
				enterOuterAlt(_localctx, 2);
				{
				setState(1018);
				literal();
				}
				break;
			case 3:
				_localctx = new ParameterExpressionContext(_localctx);
				enterOuterAlt(_localctx, 3);
				{
				setState(1019);
				parameter();
				}
				break;
			case 4:
				_localctx = new EntityTypeExpressionContext(_localctx);
				enterOuterAlt(_localctx, 4);
				{
				setState(1020);
				entityTypeReference();
				}
				break;
			case 5:
				_localctx = new EntityIdExpressionContext(_localctx);
				enterOuterAlt(_localctx, 5);
				{
				setState(1021);
				entityIdReference();
				}
				break;
			case 6:
				_localctx = new EntityVersionExpressionContext(_localctx);
				enterOuterAlt(_localctx, 6);
				{
				setState(1022);
				entityVersionReference();
				}
				break;
			case 7:
				_localctx = new EntityNaturalIdExpressionContext(_localctx);
				enterOuterAlt(_localctx, 7);
				{
				setState(1023);
				entityNaturalIdReference();
				}
				break;
			case 8:
				_localctx = new ToOneFkExpressionContext(_localctx);
				enterOuterAlt(_localctx, 8);
				{
				setState(1024);
				toOneFkReference();
				}
				break;
			case 9:
				_localctx = new SyntacticPathExpressionContext(_localctx);
				enterOuterAlt(_localctx, 9);
				{
				setState(1025);
				syntacticDomainPath();
				setState(1027);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,102,_ctx) ) {
				case 1:
					{
					setState(1026);
					pathContinuation();
					}
					break;
				}
				}
				break;
			case 10:
				_localctx = new FunctionExpressionContext(_localctx);
				enterOuterAlt(_localctx, 10);
				{
				setState(1029);
				function();
				}
				break;
			case 11:
				_localctx = new GeneralPathExpressionContext(_localctx);
				enterOuterAlt(_localctx, 11);
				{
				setState(1030);
				generalPathFragment();
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class ExpressionOrPredicateContext extends ParserRuleContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public PredicateContext predicate() {
			return getRuleContext(PredicateContext.class,0);
		}
		public ExpressionOrPredicateContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_expressionOrPredicate; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterExpressionOrPredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitExpressionOrPredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitExpressionOrPredicate(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ExpressionOrPredicateContext expressionOrPredicate() throws RecognitionException {
		ExpressionOrPredicateContext _localctx = new ExpressionOrPredicateContext(_ctx, getState());
		enterRule(_localctx, 144, RULE_expressionOrPredicate);
		try {
			setState(1035);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,104,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1033);
				expression(0);
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1034);
				predicate(0);
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class MultiplicativeOperatorContext extends ParserRuleContext {
		public TerminalNode SLASH() { return getToken(HqlParser.SLASH, 0); }
		public TerminalNode PERCENT_OP() { return getToken(HqlParser.PERCENT_OP, 0); }
		public TerminalNode ASTERISK() { return getToken(HqlParser.ASTERISK, 0); }
		public MultiplicativeOperatorContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_multiplicativeOperator; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterMultiplicativeOperator(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitMultiplicativeOperator(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitMultiplicativeOperator(this);
			else return visitor.visitChildren(this);
		}
	}

	public final MultiplicativeOperatorContext multiplicativeOperator() throws RecognitionException {
		MultiplicativeOperatorContext _localctx = new MultiplicativeOperatorContext(_ctx, getState());
		enterRule(_localctx, 146, RULE_multiplicativeOperator);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1037);
			_la = _input.LA(1);
			if ( !((((_la) & ~0x3f) == 0 && ((1L << _la) & ((1L << ASTERISK) | (1L << SLASH) | (1L << PERCENT_OP))) != 0)) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class AdditiveOperatorContext extends ParserRuleContext {
		public TerminalNode PLUS() { return getToken(HqlParser.PLUS, 0); }
		public TerminalNode MINUS() { return getToken(HqlParser.MINUS, 0); }
		public AdditiveOperatorContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_additiveOperator; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterAdditiveOperator(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitAdditiveOperator(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitAdditiveOperator(this);
			else return visitor.visitChildren(this);
		}
	}

	public final AdditiveOperatorContext additiveOperator() throws RecognitionException {
		AdditiveOperatorContext _localctx = new AdditiveOperatorContext(_ctx, getState());
		enterRule(_localctx, 148, RULE_additiveOperator);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1039);
			_la = _input.LA(1);
			if ( !(_la==PLUS || _la==MINUS) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class SignOperatorContext extends ParserRuleContext {
		public TerminalNode PLUS() { return getToken(HqlParser.PLUS, 0); }
		public TerminalNode MINUS() { return getToken(HqlParser.MINUS, 0); }
		public SignOperatorContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_signOperator; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSignOperator(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSignOperator(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSignOperator(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SignOperatorContext signOperator() throws RecognitionException {
		SignOperatorContext _localctx = new SignOperatorContext(_ctx, getState());
		enterRule(_localctx, 150, RULE_signOperator);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1041);
			_la = _input.LA(1);
			if ( !(_la==PLUS || _la==MINUS) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class EntityTypeReferenceContext extends ParserRuleContext {
		public TerminalNode TYPE() { return getToken(HqlParser.TYPE, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public ParameterContext parameter() {
			return getRuleContext(ParameterContext.class,0);
		}
		public EntityTypeReferenceContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_entityTypeReference; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterEntityTypeReference(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitEntityTypeReference(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitEntityTypeReference(this);
			else return visitor.visitChildren(this);
		}
	}

	public final EntityTypeReferenceContext entityTypeReference() throws RecognitionException {
		EntityTypeReferenceContext _localctx = new EntityTypeReferenceContext(_ctx, getState());
		enterRule(_localctx, 152, RULE_entityTypeReference);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1043);
			match(TYPE);
			setState(1044);
			match(LEFT_PAREN);
			setState(1047);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case ID:
			case VERSION:
			case VERSIONED:
			case NATURALID:
			case ALL:
			case AND:
			case ANY:
			case AS:
			case ASC:
			case AVG:
			case BETWEEN:
			case BOTH:
			case BY:
			case CASE:
			case CAST:
			case COLLATE:
			case COUNT:
			case CROSS:
			case CUBE:
			case CURRENT:
			case CURRENT_DATE:
			case CURRENT_INSTANT:
			case CURRENT_TIME:
			case CURRENT_TIMESTAMP:
			case DATE:
			case DATETIME:
			case DAY:
			case DELETE:
			case DESC:
			case DISTINCT:
			case ELEMENT:
			case ELEMENTS:
			case ELSE:
			case EMPTY:
			case END:
			case ENTRY:
			case ERROR:
			case ESCAPE:
			case EVERY:
			case EXCEPT:
			case EXCLUDE:
			case EXISTS:
			case EXTRACT:
			case FETCH:
			case FILTER:
			case FIRST:
			case FOLLOWING:
			case FOR:
			case FORMAT:
			case FROM:
			case FULL:
			case FUNCTION:
			case GROUP:
			case GROUPS:
			case HAVING:
			case HOUR:
			case IGNORE:
			case ILIKE:
			case IN:
			case INDEX:
			case INDICES:
			case INNER:
			case INSERT:
			case INSTANT:
			case INTERSECT:
			case INTO:
			case IS:
			case JOIN:
			case KEY:
			case LAST:
			case LEADING:
			case LEFT:
			case LIKE:
			case LIMIT:
			case LIST:
			case LISTAGG:
			case LOCAL:
			case LOCAL_DATE:
			case LOCAL_DATETIME:
			case LOCAL_TIME:
			case MAP:
			case MAX:
			case MAXELEMENT:
			case MAXINDEX:
			case MEMBER:
			case MICROSECOND:
			case MILLISECOND:
			case MIN:
			case MINELEMENT:
			case MININDEX:
			case MINUTE:
			case MONTH:
			case NANOSECOND:
			case NEW:
			case NEXT:
			case NO:
			case NOT:
			case NULLS:
			case OBJECT:
			case OF:
			case OFFSET:
			case OFFSET_DATETIME:
			case ON:
			case ONLY:
			case OR:
			case ORDER:
			case OTHERS:
			case OUTER:
			case OVER:
			case OVERFLOW:
			case OVERLAY:
			case PAD:
			case PARTITION:
			case PERCENT:
			case PLACING:
			case POSITION:
			case PRECEDING:
			case QUARTER:
			case RANGE:
			case RESPECT:
			case RIGHT:
			case ROLLUP:
			case ROW:
			case ROWS:
			case SECOND:
			case SELECT:
			case SET:
			case SIZE:
			case SOME:
			case SUBSTRING:
			case SUM:
			case THEN:
			case TIES:
			case TIME:
			case TIMESTAMP:
			case TIMEZONE_HOUR:
			case TIMEZONE_MINUTE:
			case TRAILING:
			case TREAT:
			case TRIM:
			case TRUNCATE:
			case TYPE:
			case UNBOUNDED:
			case UNION:
			case UPDATE:
			case VALUE:
			case VALUES:
			case WEEK:
			case WHEN:
			case WHERE:
			case WITH:
			case WITHIN:
			case WITHOUT:
			case YEAR:
			case IDENTIFIER:
			case QUOTED_IDENTIFIER:
				{
				setState(1045);
				path();
				}
				break;
			case COLON:
			case QUESTION_MARK:
				{
				setState(1046);
				parameter();
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
			setState(1049);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class EntityIdReferenceContext extends ParserRuleContext {
		public TerminalNode ID() { return getToken(HqlParser.ID, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public PathContinuationContext pathContinuation() {
			return getRuleContext(PathContinuationContext.class,0);
		}
		public EntityIdReferenceContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_entityIdReference; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterEntityIdReference(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitEntityIdReference(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitEntityIdReference(this);
			else return visitor.visitChildren(this);
		}
	}

	public final EntityIdReferenceContext entityIdReference() throws RecognitionException {
		EntityIdReferenceContext _localctx = new EntityIdReferenceContext(_ctx, getState());
		enterRule(_localctx, 154, RULE_entityIdReference);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1051);
			match(ID);
			setState(1052);
			match(LEFT_PAREN);
			setState(1053);
			path();
			setState(1054);
			match(RIGHT_PAREN);
			setState(1056);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,106,_ctx) ) {
			case 1:
				{
				setState(1055);
				pathContinuation();
				}
				break;
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class EntityVersionReferenceContext extends ParserRuleContext {
		public TerminalNode VERSION() { return getToken(HqlParser.VERSION, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public EntityVersionReferenceContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_entityVersionReference; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterEntityVersionReference(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitEntityVersionReference(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitEntityVersionReference(this);
			else return visitor.visitChildren(this);
		}
	}

	public final EntityVersionReferenceContext entityVersionReference() throws RecognitionException {
		EntityVersionReferenceContext _localctx = new EntityVersionReferenceContext(_ctx, getState());
		enterRule(_localctx, 156, RULE_entityVersionReference);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1058);
			match(VERSION);
			setState(1059);
			match(LEFT_PAREN);
			setState(1060);
			path();
			setState(1061);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class EntityNaturalIdReferenceContext extends ParserRuleContext {
		public TerminalNode NATURALID() { return getToken(HqlParser.NATURALID, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public PathContinuationContext pathContinuation() {
			return getRuleContext(PathContinuationContext.class,0);
		}
		public EntityNaturalIdReferenceContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_entityNaturalIdReference; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterEntityNaturalIdReference(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitEntityNaturalIdReference(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitEntityNaturalIdReference(this);
			else return visitor.visitChildren(this);
		}
	}

	public final EntityNaturalIdReferenceContext entityNaturalIdReference() throws RecognitionException {
		EntityNaturalIdReferenceContext _localctx = new EntityNaturalIdReferenceContext(_ctx, getState());
		enterRule(_localctx, 158, RULE_entityNaturalIdReference);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1063);
			match(NATURALID);
			setState(1064);
			match(LEFT_PAREN);
			setState(1065);
			path();
			setState(1066);
			match(RIGHT_PAREN);
			setState(1068);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,107,_ctx) ) {
			case 1:
				{
				setState(1067);
				pathContinuation();
				}
				break;
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class ToOneFkReferenceContext extends ParserRuleContext {
		public TerminalNode FK() { return getToken(HqlParser.FK, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public ToOneFkReferenceContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_toOneFkReference; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterToOneFkReference(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitToOneFkReference(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitToOneFkReference(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ToOneFkReferenceContext toOneFkReference() throws RecognitionException {
		ToOneFkReferenceContext _localctx = new ToOneFkReferenceContext(_ctx, getState());
		enterRule(_localctx, 160, RULE_toOneFkReference);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1070);
			match(FK);
			setState(1071);
			match(LEFT_PAREN);
			setState(1072);
			path();
			setState(1073);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class CaseListContext extends ParserRuleContext {
		public SimpleCaseListContext simpleCaseList() {
			return getRuleContext(SimpleCaseListContext.class,0);
		}
		public SearchedCaseListContext searchedCaseList() {
			return getRuleContext(SearchedCaseListContext.class,0);
		}
		public CaseListContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_caseList; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCaseList(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCaseList(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCaseList(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CaseListContext caseList() throws RecognitionException {
		CaseListContext _localctx = new CaseListContext(_ctx, getState());
		enterRule(_localctx, 162, RULE_caseList);
		try {
			setState(1077);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,108,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1075);
				simpleCaseList();
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1076);
				searchedCaseList();
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class SimpleCaseListContext extends ParserRuleContext {
		public TerminalNode CASE() { return getToken(HqlParser.CASE, 0); }
		public ExpressionOrPredicateContext expressionOrPredicate() {
			return getRuleContext(ExpressionOrPredicateContext.class,0);
		}
		public TerminalNode END() { return getToken(HqlParser.END, 0); }
		public List<SimpleCaseWhenContext> simpleCaseWhen() {
			return getRuleContexts(SimpleCaseWhenContext.class);
		}
		public SimpleCaseWhenContext simpleCaseWhen(int i) {
			return getRuleContext(SimpleCaseWhenContext.class,i);
		}
		public CaseOtherwiseContext caseOtherwise() {
			return getRuleContext(CaseOtherwiseContext.class,0);
		}
		public SimpleCaseListContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_simpleCaseList; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSimpleCaseList(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSimpleCaseList(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSimpleCaseList(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SimpleCaseListContext simpleCaseList() throws RecognitionException {
		SimpleCaseListContext _localctx = new SimpleCaseListContext(_ctx, getState());
		enterRule(_localctx, 164, RULE_simpleCaseList);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1079);
			match(CASE);
			setState(1080);
			expressionOrPredicate();
			setState(1082); 
			_errHandler.sync(this);
			_la = _input.LA(1);
			do {
				{
				{
				setState(1081);
				simpleCaseWhen();
				}
				}
				setState(1084); 
				_errHandler.sync(this);
				_la = _input.LA(1);
			} while ( _la==WHEN );
			setState(1087);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==ELSE) {
				{
				setState(1086);
				caseOtherwise();
				}
			}

			setState(1089);
			match(END);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class SimpleCaseWhenContext extends ParserRuleContext {
		public TerminalNode WHEN() { return getToken(HqlParser.WHEN, 0); }
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode THEN() { return getToken(HqlParser.THEN, 0); }
		public ExpressionOrPredicateContext expressionOrPredicate() {
			return getRuleContext(ExpressionOrPredicateContext.class,0);
		}
		public SimpleCaseWhenContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_simpleCaseWhen; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSimpleCaseWhen(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSimpleCaseWhen(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSimpleCaseWhen(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SimpleCaseWhenContext simpleCaseWhen() throws RecognitionException {
		SimpleCaseWhenContext _localctx = new SimpleCaseWhenContext(_ctx, getState());
		enterRule(_localctx, 166, RULE_simpleCaseWhen);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1091);
			match(WHEN);
			setState(1092);
			expression(0);
			setState(1093);
			match(THEN);
			setState(1094);
			expressionOrPredicate();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class CaseOtherwiseContext extends ParserRuleContext {
		public TerminalNode ELSE() { return getToken(HqlParser.ELSE, 0); }
		public ExpressionOrPredicateContext expressionOrPredicate() {
			return getRuleContext(ExpressionOrPredicateContext.class,0);
		}
		public CaseOtherwiseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_caseOtherwise; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCaseOtherwise(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCaseOtherwise(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCaseOtherwise(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CaseOtherwiseContext caseOtherwise() throws RecognitionException {
		CaseOtherwiseContext _localctx = new CaseOtherwiseContext(_ctx, getState());
		enterRule(_localctx, 168, RULE_caseOtherwise);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1096);
			match(ELSE);
			setState(1097);
			expressionOrPredicate();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class SearchedCaseListContext extends ParserRuleContext {
		public TerminalNode CASE() { return getToken(HqlParser.CASE, 0); }
		public TerminalNode END() { return getToken(HqlParser.END, 0); }
		public List<SearchedCaseWhenContext> searchedCaseWhen() {
			return getRuleContexts(SearchedCaseWhenContext.class);
		}
		public SearchedCaseWhenContext searchedCaseWhen(int i) {
			return getRuleContext(SearchedCaseWhenContext.class,i);
		}
		public CaseOtherwiseContext caseOtherwise() {
			return getRuleContext(CaseOtherwiseContext.class,0);
		}
		public SearchedCaseListContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_searchedCaseList; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSearchedCaseList(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSearchedCaseList(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSearchedCaseList(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SearchedCaseListContext searchedCaseList() throws RecognitionException {
		SearchedCaseListContext _localctx = new SearchedCaseListContext(_ctx, getState());
		enterRule(_localctx, 170, RULE_searchedCaseList);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1099);
			match(CASE);
			setState(1101); 
			_errHandler.sync(this);
			_la = _input.LA(1);
			do {
				{
				{
				setState(1100);
				searchedCaseWhen();
				}
				}
				setState(1103); 
				_errHandler.sync(this);
				_la = _input.LA(1);
			} while ( _la==WHEN );
			setState(1106);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==ELSE) {
				{
				setState(1105);
				caseOtherwise();
				}
			}

			setState(1108);
			match(END);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class SearchedCaseWhenContext extends ParserRuleContext {
		public TerminalNode WHEN() { return getToken(HqlParser.WHEN, 0); }
		public PredicateContext predicate() {
			return getRuleContext(PredicateContext.class,0);
		}
		public TerminalNode THEN() { return getToken(HqlParser.THEN, 0); }
		public ExpressionOrPredicateContext expressionOrPredicate() {
			return getRuleContext(ExpressionOrPredicateContext.class,0);
		}
		public SearchedCaseWhenContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_searchedCaseWhen; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSearchedCaseWhen(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSearchedCaseWhen(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSearchedCaseWhen(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SearchedCaseWhenContext searchedCaseWhen() throws RecognitionException {
		SearchedCaseWhenContext _localctx = new SearchedCaseWhenContext(_ctx, getState());
		enterRule(_localctx, 172, RULE_searchedCaseWhen);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1110);
			match(WHEN);
			setState(1111);
			predicate(0);
			setState(1112);
			match(THEN);
			setState(1113);
			expressionOrPredicate();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class LiteralContext extends ParserRuleContext {
		public TerminalNode STRING_LITERAL() { return getToken(HqlParser.STRING_LITERAL, 0); }
		public TerminalNode JAVA_STRING_LITERAL() { return getToken(HqlParser.JAVA_STRING_LITERAL, 0); }
		public TerminalNode NULL() { return getToken(HqlParser.NULL, 0); }
		public BooleanLiteralContext booleanLiteral() {
			return getRuleContext(BooleanLiteralContext.class,0);
		}
		public NumericLiteralContext numericLiteral() {
			return getRuleContext(NumericLiteralContext.class,0);
		}
		public BinaryLiteralContext binaryLiteral() {
			return getRuleContext(BinaryLiteralContext.class,0);
		}
		public TemporalLiteralContext temporalLiteral() {
			return getRuleContext(TemporalLiteralContext.class,0);
		}
		public GeneralizedLiteralContext generalizedLiteral() {
			return getRuleContext(GeneralizedLiteralContext.class,0);
		}
		public LiteralContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_literal; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterLiteral(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitLiteral(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitLiteral(this);
			else return visitor.visitChildren(this);
		}
	}

	public final LiteralContext literal() throws RecognitionException {
		LiteralContext _localctx = new LiteralContext(_ctx, getState());
		enterRule(_localctx, 174, RULE_literal);
		try {
			setState(1123);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,113,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1115);
				match(STRING_LITERAL);
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1116);
				match(JAVA_STRING_LITERAL);
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(1117);
				match(NULL);
				}
				break;
			case 4:
				enterOuterAlt(_localctx, 4);
				{
				setState(1118);
				booleanLiteral();
				}
				break;
			case 5:
				enterOuterAlt(_localctx, 5);
				{
				setState(1119);
				numericLiteral();
				}
				break;
			case 6:
				enterOuterAlt(_localctx, 6);
				{
				setState(1120);
				binaryLiteral();
				}
				break;
			case 7:
				enterOuterAlt(_localctx, 7);
				{
				setState(1121);
				temporalLiteral();
				}
				break;
			case 8:
				enterOuterAlt(_localctx, 8);
				{
				setState(1122);
				generalizedLiteral();
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class BooleanLiteralContext extends ParserRuleContext {
		public TerminalNode TRUE() { return getToken(HqlParser.TRUE, 0); }
		public TerminalNode FALSE() { return getToken(HqlParser.FALSE, 0); }
		public BooleanLiteralContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_booleanLiteral; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterBooleanLiteral(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitBooleanLiteral(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitBooleanLiteral(this);
			else return visitor.visitChildren(this);
		}
	}

	public final BooleanLiteralContext booleanLiteral() throws RecognitionException {
		BooleanLiteralContext _localctx = new BooleanLiteralContext(_ctx, getState());
		enterRule(_localctx, 176, RULE_booleanLiteral);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1125);
			_la = _input.LA(1);
			if ( !(_la==TRUE || _la==FALSE) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class NumericLiteralContext extends ParserRuleContext {
		public TerminalNode INTEGER_LITERAL() { return getToken(HqlParser.INTEGER_LITERAL, 0); }
		public TerminalNode LONG_LITERAL() { return getToken(HqlParser.LONG_LITERAL, 0); }
		public TerminalNode BIG_INTEGER_LITERAL() { return getToken(HqlParser.BIG_INTEGER_LITERAL, 0); }
		public TerminalNode FLOAT_LITERAL() { return getToken(HqlParser.FLOAT_LITERAL, 0); }
		public TerminalNode DOUBLE_LITERAL() { return getToken(HqlParser.DOUBLE_LITERAL, 0); }
		public TerminalNode BIG_DECIMAL_LITERAL() { return getToken(HqlParser.BIG_DECIMAL_LITERAL, 0); }
		public TerminalNode HEX_LITERAL() { return getToken(HqlParser.HEX_LITERAL, 0); }
		public NumericLiteralContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_numericLiteral; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterNumericLiteral(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitNumericLiteral(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitNumericLiteral(this);
			else return visitor.visitChildren(this);
		}
	}

	public final NumericLiteralContext numericLiteral() throws RecognitionException {
		NumericLiteralContext _localctx = new NumericLiteralContext(_ctx, getState());
		enterRule(_localctx, 178, RULE_numericLiteral);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1127);
			_la = _input.LA(1);
			if ( !((((_la) & ~0x3f) == 0 && ((1L << _la) & ((1L << INTEGER_LITERAL) | (1L << LONG_LITERAL) | (1L << FLOAT_LITERAL) | (1L << DOUBLE_LITERAL) | (1L << BIG_INTEGER_LITERAL) | (1L << BIG_DECIMAL_LITERAL) | (1L << HEX_LITERAL))) != 0)) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class BinaryLiteralContext extends ParserRuleContext {
		public TerminalNode BINARY_LITERAL() { return getToken(HqlParser.BINARY_LITERAL, 0); }
		public TerminalNode LEFT_BRACE() { return getToken(HqlParser.LEFT_BRACE, 0); }
		public List<TerminalNode> HEX_LITERAL() { return getTokens(HqlParser.HEX_LITERAL); }
		public TerminalNode HEX_LITERAL(int i) {
			return getToken(HqlParser.HEX_LITERAL, i);
		}
		public TerminalNode RIGHT_BRACE() { return getToken(HqlParser.RIGHT_BRACE, 0); }
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public BinaryLiteralContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_binaryLiteral; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterBinaryLiteral(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitBinaryLiteral(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitBinaryLiteral(this);
			else return visitor.visitChildren(this);
		}
	}

	public final BinaryLiteralContext binaryLiteral() throws RecognitionException {
		BinaryLiteralContext _localctx = new BinaryLiteralContext(_ctx, getState());
		enterRule(_localctx, 180, RULE_binaryLiteral);
		int _la;
		try {
			setState(1140);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case BINARY_LITERAL:
				enterOuterAlt(_localctx, 1);
				{
				setState(1129);
				match(BINARY_LITERAL);
				}
				break;
			case LEFT_BRACE:
				enterOuterAlt(_localctx, 2);
				{
				setState(1130);
				match(LEFT_BRACE);
				setState(1131);
				match(HEX_LITERAL);
				setState(1136);
				_errHandler.sync(this);
				_la = _input.LA(1);
				while (_la==COMMA) {
					{
					{
					setState(1132);
					match(COMMA);
					setState(1133);
					match(HEX_LITERAL);
					}
					}
					setState(1138);
					_errHandler.sync(this);
					_la = _input.LA(1);
				}
				setState(1139);
				match(RIGHT_BRACE);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class TemporalLiteralContext extends ParserRuleContext {
		public DateTimeLiteralContext dateTimeLiteral() {
			return getRuleContext(DateTimeLiteralContext.class,0);
		}
		public DateLiteralContext dateLiteral() {
			return getRuleContext(DateLiteralContext.class,0);
		}
		public TimeLiteralContext timeLiteral() {
			return getRuleContext(TimeLiteralContext.class,0);
		}
		public JdbcTimestampLiteralContext jdbcTimestampLiteral() {
			return getRuleContext(JdbcTimestampLiteralContext.class,0);
		}
		public JdbcDateLiteralContext jdbcDateLiteral() {
			return getRuleContext(JdbcDateLiteralContext.class,0);
		}
		public JdbcTimeLiteralContext jdbcTimeLiteral() {
			return getRuleContext(JdbcTimeLiteralContext.class,0);
		}
		public TemporalLiteralContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_temporalLiteral; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterTemporalLiteral(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitTemporalLiteral(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitTemporalLiteral(this);
			else return visitor.visitChildren(this);
		}
	}

	public final TemporalLiteralContext temporalLiteral() throws RecognitionException {
		TemporalLiteralContext _localctx = new TemporalLiteralContext(_ctx, getState());
		enterRule(_localctx, 182, RULE_temporalLiteral);
		try {
			setState(1148);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,116,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1142);
				dateTimeLiteral();
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1143);
				dateLiteral();
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(1144);
				timeLiteral();
				}
				break;
			case 4:
				enterOuterAlt(_localctx, 4);
				{
				setState(1145);
				jdbcTimestampLiteral();
				}
				break;
			case 5:
				enterOuterAlt(_localctx, 5);
				{
				setState(1146);
				jdbcDateLiteral();
				}
				break;
			case 6:
				enterOuterAlt(_localctx, 6);
				{
				setState(1147);
				jdbcTimeLiteral();
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class DateTimeLiteralContext extends ParserRuleContext {
		public TerminalNode LEFT_BRACE() { return getToken(HqlParser.LEFT_BRACE, 0); }
		public DateTimeContext dateTime() {
			return getRuleContext(DateTimeContext.class,0);
		}
		public TerminalNode RIGHT_BRACE() { return getToken(HqlParser.RIGHT_BRACE, 0); }
		public TerminalNode DATETIME() { return getToken(HqlParser.DATETIME, 0); }
		public DateTimeLiteralContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_dateTimeLiteral; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterDateTimeLiteral(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitDateTimeLiteral(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitDateTimeLiteral(this);
			else return visitor.visitChildren(this);
		}
	}

	public final DateTimeLiteralContext dateTimeLiteral() throws RecognitionException {
		DateTimeLiteralContext _localctx = new DateTimeLiteralContext(_ctx, getState());
		enterRule(_localctx, 184, RULE_dateTimeLiteral);
		try {
			setState(1156);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case LEFT_BRACE:
				enterOuterAlt(_localctx, 1);
				{
				setState(1150);
				match(LEFT_BRACE);
				setState(1151);
				dateTime();
				setState(1152);
				match(RIGHT_BRACE);
				}
				break;
			case DATETIME:
				enterOuterAlt(_localctx, 2);
				{
				setState(1154);
				match(DATETIME);
				setState(1155);
				dateTime();
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class DateLiteralContext extends ParserRuleContext {
		public TerminalNode LEFT_BRACE() { return getToken(HqlParser.LEFT_BRACE, 0); }
		public DateContext date() {
			return getRuleContext(DateContext.class,0);
		}
		public TerminalNode RIGHT_BRACE() { return getToken(HqlParser.RIGHT_BRACE, 0); }
		public TerminalNode DATE() { return getToken(HqlParser.DATE, 0); }
		public DateLiteralContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_dateLiteral; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterDateLiteral(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitDateLiteral(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitDateLiteral(this);
			else return visitor.visitChildren(this);
		}
	}

	public final DateLiteralContext dateLiteral() throws RecognitionException {
		DateLiteralContext _localctx = new DateLiteralContext(_ctx, getState());
		enterRule(_localctx, 186, RULE_dateLiteral);
		try {
			setState(1164);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case LEFT_BRACE:
				enterOuterAlt(_localctx, 1);
				{
				setState(1158);
				match(LEFT_BRACE);
				setState(1159);
				date();
				setState(1160);
				match(RIGHT_BRACE);
				}
				break;
			case DATE:
				enterOuterAlt(_localctx, 2);
				{
				setState(1162);
				match(DATE);
				setState(1163);
				date();
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class TimeLiteralContext extends ParserRuleContext {
		public TerminalNode LEFT_BRACE() { return getToken(HqlParser.LEFT_BRACE, 0); }
		public TimeContext time() {
			return getRuleContext(TimeContext.class,0);
		}
		public TerminalNode RIGHT_BRACE() { return getToken(HqlParser.RIGHT_BRACE, 0); }
		public TerminalNode TIME() { return getToken(HqlParser.TIME, 0); }
		public TimeLiteralContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_timeLiteral; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterTimeLiteral(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitTimeLiteral(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitTimeLiteral(this);
			else return visitor.visitChildren(this);
		}
	}

	public final TimeLiteralContext timeLiteral() throws RecognitionException {
		TimeLiteralContext _localctx = new TimeLiteralContext(_ctx, getState());
		enterRule(_localctx, 188, RULE_timeLiteral);
		try {
			setState(1172);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case LEFT_BRACE:
				enterOuterAlt(_localctx, 1);
				{
				setState(1166);
				match(LEFT_BRACE);
				setState(1167);
				time();
				setState(1168);
				match(RIGHT_BRACE);
				}
				break;
			case TIME:
				enterOuterAlt(_localctx, 2);
				{
				setState(1170);
				match(TIME);
				setState(1171);
				time();
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class DateTimeContext extends ParserRuleContext {
		public DateContext date() {
			return getRuleContext(DateContext.class,0);
		}
		public TimeContext time() {
			return getRuleContext(TimeContext.class,0);
		}
		public ZoneIdContext zoneId() {
			return getRuleContext(ZoneIdContext.class,0);
		}
		public OffsetContext offset() {
			return getRuleContext(OffsetContext.class,0);
		}
		public DateTimeContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_dateTime; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterDateTime(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitDateTime(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitDateTime(this);
			else return visitor.visitChildren(this);
		}
	}

	public final DateTimeContext dateTime() throws RecognitionException {
		DateTimeContext _localctx = new DateTimeContext(_ctx, getState());
		enterRule(_localctx, 190, RULE_dateTime);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1174);
			date();
			setState(1175);
			time();
			setState(1178);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,120,_ctx) ) {
			case 1:
				{
				setState(1176);
				zoneId();
				}
				break;
			case 2:
				{
				setState(1177);
				offset();
				}
				break;
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class DateContext extends ParserRuleContext {
		public YearContext year() {
			return getRuleContext(YearContext.class,0);
		}
		public List<TerminalNode> MINUS() { return getTokens(HqlParser.MINUS); }
		public TerminalNode MINUS(int i) {
			return getToken(HqlParser.MINUS, i);
		}
		public MonthContext month() {
			return getRuleContext(MonthContext.class,0);
		}
		public DayContext day() {
			return getRuleContext(DayContext.class,0);
		}
		public DateContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_date; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterDate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitDate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitDate(this);
			else return visitor.visitChildren(this);
		}
	}

	public final DateContext date() throws RecognitionException {
		DateContext _localctx = new DateContext(_ctx, getState());
		enterRule(_localctx, 192, RULE_date);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1180);
			year();
			setState(1181);
			match(MINUS);
			setState(1182);
			month();
			setState(1183);
			match(MINUS);
			setState(1184);
			day();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class TimeContext extends ParserRuleContext {
		public HourContext hour() {
			return getRuleContext(HourContext.class,0);
		}
		public List<TerminalNode> COLON() { return getTokens(HqlParser.COLON); }
		public TerminalNode COLON(int i) {
			return getToken(HqlParser.COLON, i);
		}
		public MinuteContext minute() {
			return getRuleContext(MinuteContext.class,0);
		}
		public SecondContext second() {
			return getRuleContext(SecondContext.class,0);
		}
		public TimeContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_time; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterTime(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitTime(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitTime(this);
			else return visitor.visitChildren(this);
		}
	}

	public final TimeContext time() throws RecognitionException {
		TimeContext _localctx = new TimeContext(_ctx, getState());
		enterRule(_localctx, 194, RULE_time);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1186);
			hour();
			setState(1187);
			match(COLON);
			setState(1188);
			minute();
			setState(1191);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,121,_ctx) ) {
			case 1:
				{
				setState(1189);
				match(COLON);
				setState(1190);
				second();
				}
				break;
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class OffsetContext extends ParserRuleContext {
		public HourContext hour() {
			return getRuleContext(HourContext.class,0);
		}
		public TerminalNode PLUS() { return getToken(HqlParser.PLUS, 0); }
		public TerminalNode MINUS() { return getToken(HqlParser.MINUS, 0); }
		public TerminalNode COLON() { return getToken(HqlParser.COLON, 0); }
		public MinuteContext minute() {
			return getRuleContext(MinuteContext.class,0);
		}
		public OffsetContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_offset; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterOffset(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitOffset(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitOffset(this);
			else return visitor.visitChildren(this);
		}
	}

	public final OffsetContext offset() throws RecognitionException {
		OffsetContext _localctx = new OffsetContext(_ctx, getState());
		enterRule(_localctx, 196, RULE_offset);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1193);
			_la = _input.LA(1);
			if ( !(_la==PLUS || _la==MINUS) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			setState(1194);
			hour();
			setState(1197);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,122,_ctx) ) {
			case 1:
				{
				setState(1195);
				match(COLON);
				setState(1196);
				minute();
				}
				break;
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class YearContext extends ParserRuleContext {
		public TerminalNode INTEGER_LITERAL() { return getToken(HqlParser.INTEGER_LITERAL, 0); }
		public YearContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_year; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterYear(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitYear(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitYear(this);
			else return visitor.visitChildren(this);
		}
	}

	public final YearContext year() throws RecognitionException {
		YearContext _localctx = new YearContext(_ctx, getState());
		enterRule(_localctx, 198, RULE_year);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1199);
			match(INTEGER_LITERAL);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class MonthContext extends ParserRuleContext {
		public TerminalNode INTEGER_LITERAL() { return getToken(HqlParser.INTEGER_LITERAL, 0); }
		public MonthContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_month; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterMonth(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitMonth(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitMonth(this);
			else return visitor.visitChildren(this);
		}
	}

	public final MonthContext month() throws RecognitionException {
		MonthContext _localctx = new MonthContext(_ctx, getState());
		enterRule(_localctx, 200, RULE_month);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1201);
			match(INTEGER_LITERAL);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class DayContext extends ParserRuleContext {
		public TerminalNode INTEGER_LITERAL() { return getToken(HqlParser.INTEGER_LITERAL, 0); }
		public DayContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_day; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterDay(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitDay(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitDay(this);
			else return visitor.visitChildren(this);
		}
	}

	public final DayContext day() throws RecognitionException {
		DayContext _localctx = new DayContext(_ctx, getState());
		enterRule(_localctx, 202, RULE_day);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1203);
			match(INTEGER_LITERAL);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class HourContext extends ParserRuleContext {
		public TerminalNode INTEGER_LITERAL() { return getToken(HqlParser.INTEGER_LITERAL, 0); }
		public HourContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_hour; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterHour(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitHour(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitHour(this);
			else return visitor.visitChildren(this);
		}
	}

	public final HourContext hour() throws RecognitionException {
		HourContext _localctx = new HourContext(_ctx, getState());
		enterRule(_localctx, 204, RULE_hour);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1205);
			match(INTEGER_LITERAL);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class MinuteContext extends ParserRuleContext {
		public TerminalNode INTEGER_LITERAL() { return getToken(HqlParser.INTEGER_LITERAL, 0); }
		public MinuteContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_minute; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterMinute(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitMinute(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitMinute(this);
			else return visitor.visitChildren(this);
		}
	}

	public final MinuteContext minute() throws RecognitionException {
		MinuteContext _localctx = new MinuteContext(_ctx, getState());
		enterRule(_localctx, 206, RULE_minute);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1207);
			match(INTEGER_LITERAL);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class SecondContext extends ParserRuleContext {
		public TerminalNode INTEGER_LITERAL() { return getToken(HqlParser.INTEGER_LITERAL, 0); }
		public TerminalNode FLOAT_LITERAL() { return getToken(HqlParser.FLOAT_LITERAL, 0); }
		public SecondContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_second; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSecond(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSecond(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSecond(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SecondContext second() throws RecognitionException {
		SecondContext _localctx = new SecondContext(_ctx, getState());
		enterRule(_localctx, 208, RULE_second);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1209);
			_la = _input.LA(1);
			if ( !(_la==INTEGER_LITERAL || _la==FLOAT_LITERAL) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class ZoneIdContext extends ParserRuleContext {
		public List<TerminalNode> IDENTIFIER() { return getTokens(HqlParser.IDENTIFIER); }
		public TerminalNode IDENTIFIER(int i) {
			return getToken(HqlParser.IDENTIFIER, i);
		}
		public TerminalNode SLASH() { return getToken(HqlParser.SLASH, 0); }
		public TerminalNode STRING_LITERAL() { return getToken(HqlParser.STRING_LITERAL, 0); }
		public ZoneIdContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_zoneId; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterZoneId(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitZoneId(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitZoneId(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ZoneIdContext zoneId() throws RecognitionException {
		ZoneIdContext _localctx = new ZoneIdContext(_ctx, getState());
		enterRule(_localctx, 210, RULE_zoneId);
		try {
			setState(1217);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case IDENTIFIER:
				enterOuterAlt(_localctx, 1);
				{
				setState(1211);
				match(IDENTIFIER);
				setState(1214);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,123,_ctx) ) {
				case 1:
					{
					setState(1212);
					match(SLASH);
					setState(1213);
					match(IDENTIFIER);
					}
					break;
				}
				}
				break;
			case STRING_LITERAL:
				enterOuterAlt(_localctx, 2);
				{
				setState(1216);
				match(STRING_LITERAL);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class JdbcTimestampLiteralContext extends ParserRuleContext {
		public TerminalNode TIMESTAMP_ESCAPE_START() { return getToken(HqlParser.TIMESTAMP_ESCAPE_START, 0); }
		public TerminalNode RIGHT_BRACE() { return getToken(HqlParser.RIGHT_BRACE, 0); }
		public DateTimeContext dateTime() {
			return getRuleContext(DateTimeContext.class,0);
		}
		public GenericTemporalLiteralTextContext genericTemporalLiteralText() {
			return getRuleContext(GenericTemporalLiteralTextContext.class,0);
		}
		public JdbcTimestampLiteralContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_jdbcTimestampLiteral; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterJdbcTimestampLiteral(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitJdbcTimestampLiteral(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitJdbcTimestampLiteral(this);
			else return visitor.visitChildren(this);
		}
	}

	public final JdbcTimestampLiteralContext jdbcTimestampLiteral() throws RecognitionException {
		JdbcTimestampLiteralContext _localctx = new JdbcTimestampLiteralContext(_ctx, getState());
		enterRule(_localctx, 212, RULE_jdbcTimestampLiteral);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1219);
			match(TIMESTAMP_ESCAPE_START);
			setState(1222);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case INTEGER_LITERAL:
				{
				setState(1220);
				dateTime();
				}
				break;
			case STRING_LITERAL:
				{
				setState(1221);
				genericTemporalLiteralText();
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
			setState(1224);
			match(RIGHT_BRACE);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class JdbcDateLiteralContext extends ParserRuleContext {
		public TerminalNode DATE_ESCAPE_START() { return getToken(HqlParser.DATE_ESCAPE_START, 0); }
		public TerminalNode RIGHT_BRACE() { return getToken(HqlParser.RIGHT_BRACE, 0); }
		public DateContext date() {
			return getRuleContext(DateContext.class,0);
		}
		public GenericTemporalLiteralTextContext genericTemporalLiteralText() {
			return getRuleContext(GenericTemporalLiteralTextContext.class,0);
		}
		public JdbcDateLiteralContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_jdbcDateLiteral; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterJdbcDateLiteral(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitJdbcDateLiteral(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitJdbcDateLiteral(this);
			else return visitor.visitChildren(this);
		}
	}

	public final JdbcDateLiteralContext jdbcDateLiteral() throws RecognitionException {
		JdbcDateLiteralContext _localctx = new JdbcDateLiteralContext(_ctx, getState());
		enterRule(_localctx, 214, RULE_jdbcDateLiteral);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1226);
			match(DATE_ESCAPE_START);
			setState(1229);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case INTEGER_LITERAL:
				{
				setState(1227);
				date();
				}
				break;
			case STRING_LITERAL:
				{
				setState(1228);
				genericTemporalLiteralText();
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
			setState(1231);
			match(RIGHT_BRACE);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class JdbcTimeLiteralContext extends ParserRuleContext {
		public TerminalNode TIME_ESCAPE_START() { return getToken(HqlParser.TIME_ESCAPE_START, 0); }
		public TerminalNode RIGHT_BRACE() { return getToken(HqlParser.RIGHT_BRACE, 0); }
		public TimeContext time() {
			return getRuleContext(TimeContext.class,0);
		}
		public GenericTemporalLiteralTextContext genericTemporalLiteralText() {
			return getRuleContext(GenericTemporalLiteralTextContext.class,0);
		}
		public JdbcTimeLiteralContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_jdbcTimeLiteral; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterJdbcTimeLiteral(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitJdbcTimeLiteral(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitJdbcTimeLiteral(this);
			else return visitor.visitChildren(this);
		}
	}

	public final JdbcTimeLiteralContext jdbcTimeLiteral() throws RecognitionException {
		JdbcTimeLiteralContext _localctx = new JdbcTimeLiteralContext(_ctx, getState());
		enterRule(_localctx, 216, RULE_jdbcTimeLiteral);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1233);
			match(TIME_ESCAPE_START);
			setState(1236);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case INTEGER_LITERAL:
				{
				setState(1234);
				time();
				}
				break;
			case STRING_LITERAL:
				{
				setState(1235);
				genericTemporalLiteralText();
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
			setState(1238);
			match(RIGHT_BRACE);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class GenericTemporalLiteralTextContext extends ParserRuleContext {
		public TerminalNode STRING_LITERAL() { return getToken(HqlParser.STRING_LITERAL, 0); }
		public GenericTemporalLiteralTextContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_genericTemporalLiteralText; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterGenericTemporalLiteralText(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitGenericTemporalLiteralText(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitGenericTemporalLiteralText(this);
			else return visitor.visitChildren(this);
		}
	}

	public final GenericTemporalLiteralTextContext genericTemporalLiteralText() throws RecognitionException {
		GenericTemporalLiteralTextContext _localctx = new GenericTemporalLiteralTextContext(_ctx, getState());
		enterRule(_localctx, 218, RULE_genericTemporalLiteralText);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1240);
			match(STRING_LITERAL);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class GeneralizedLiteralContext extends ParserRuleContext {
		public TerminalNode LEFT_BRACE() { return getToken(HqlParser.LEFT_BRACE, 0); }
		public GeneralizedLiteralTypeContext generalizedLiteralType() {
			return getRuleContext(GeneralizedLiteralTypeContext.class,0);
		}
		public TerminalNode COLON() { return getToken(HqlParser.COLON, 0); }
		public GeneralizedLiteralTextContext generalizedLiteralText() {
			return getRuleContext(GeneralizedLiteralTextContext.class,0);
		}
		public TerminalNode RIGHT_BRACE() { return getToken(HqlParser.RIGHT_BRACE, 0); }
		public GeneralizedLiteralContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_generalizedLiteral; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterGeneralizedLiteral(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitGeneralizedLiteral(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitGeneralizedLiteral(this);
			else return visitor.visitChildren(this);
		}
	}

	public final GeneralizedLiteralContext generalizedLiteral() throws RecognitionException {
		GeneralizedLiteralContext _localctx = new GeneralizedLiteralContext(_ctx, getState());
		enterRule(_localctx, 220, RULE_generalizedLiteral);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1242);
			match(LEFT_BRACE);
			setState(1243);
			generalizedLiteralType();
			setState(1244);
			match(COLON);
			setState(1245);
			generalizedLiteralText();
			setState(1246);
			match(RIGHT_BRACE);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class GeneralizedLiteralTypeContext extends ParserRuleContext {
		public TerminalNode STRING_LITERAL() { return getToken(HqlParser.STRING_LITERAL, 0); }
		public GeneralizedLiteralTypeContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_generalizedLiteralType; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterGeneralizedLiteralType(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitGeneralizedLiteralType(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitGeneralizedLiteralType(this);
			else return visitor.visitChildren(this);
		}
	}

	public final GeneralizedLiteralTypeContext generalizedLiteralType() throws RecognitionException {
		GeneralizedLiteralTypeContext _localctx = new GeneralizedLiteralTypeContext(_ctx, getState());
		enterRule(_localctx, 222, RULE_generalizedLiteralType);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1248);
			match(STRING_LITERAL);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class GeneralizedLiteralTextContext extends ParserRuleContext {
		public TerminalNode STRING_LITERAL() { return getToken(HqlParser.STRING_LITERAL, 0); }
		public GeneralizedLiteralTextContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_generalizedLiteralText; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterGeneralizedLiteralText(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitGeneralizedLiteralText(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitGeneralizedLiteralText(this);
			else return visitor.visitChildren(this);
		}
	}

	public final GeneralizedLiteralTextContext generalizedLiteralText() throws RecognitionException {
		GeneralizedLiteralTextContext _localctx = new GeneralizedLiteralTextContext(_ctx, getState());
		enterRule(_localctx, 224, RULE_generalizedLiteralText);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1250);
			match(STRING_LITERAL);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class ParameterContext extends ParserRuleContext {
		public ParameterContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_parameter; }
	 
		public ParameterContext() { }
		public void copyFrom(ParameterContext ctx) {
			super.copyFrom(ctx);
		}
	}
	public static class NamedParameterContext extends ParameterContext {
		public TerminalNode COLON() { return getToken(HqlParser.COLON, 0); }
		public IdentifierContext identifier() {
			return getRuleContext(IdentifierContext.class,0);
		}
		public NamedParameterContext(ParameterContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterNamedParameter(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitNamedParameter(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitNamedParameter(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class PositionalParameterContext extends ParameterContext {
		public TerminalNode QUESTION_MARK() { return getToken(HqlParser.QUESTION_MARK, 0); }
		public TerminalNode INTEGER_LITERAL() { return getToken(HqlParser.INTEGER_LITERAL, 0); }
		public PositionalParameterContext(ParameterContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterPositionalParameter(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitPositionalParameter(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitPositionalParameter(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ParameterContext parameter() throws RecognitionException {
		ParameterContext _localctx = new ParameterContext(_ctx, getState());
		enterRule(_localctx, 226, RULE_parameter);
		try {
			setState(1258);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case COLON:
				_localctx = new NamedParameterContext(_localctx);
				enterOuterAlt(_localctx, 1);
				{
				setState(1252);
				match(COLON);
				setState(1253);
				identifier();
				}
				break;
			case QUESTION_MARK:
				_localctx = new PositionalParameterContext(_localctx);
				enterOuterAlt(_localctx, 2);
				{
				setState(1254);
				match(QUESTION_MARK);
				setState(1256);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,128,_ctx) ) {
				case 1:
					{
					setState(1255);
					match(INTEGER_LITERAL);
					}
					break;
				}
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class FunctionContext extends ParserRuleContext {
		public StandardFunctionContext standardFunction() {
			return getRuleContext(StandardFunctionContext.class,0);
		}
		public AggregateFunctionContext aggregateFunction() {
			return getRuleContext(AggregateFunctionContext.class,0);
		}
		public CollectionSizeFunctionContext collectionSizeFunction() {
			return getRuleContext(CollectionSizeFunctionContext.class,0);
		}
		public IndexAggregateFunctionContext indexAggregateFunction() {
			return getRuleContext(IndexAggregateFunctionContext.class,0);
		}
		public ElementAggregateFunctionContext elementAggregateFunction() {
			return getRuleContext(ElementAggregateFunctionContext.class,0);
		}
		public CollectionFunctionMisuseContext collectionFunctionMisuse() {
			return getRuleContext(CollectionFunctionMisuseContext.class,0);
		}
		public JpaNonstandardFunctionContext jpaNonstandardFunction() {
			return getRuleContext(JpaNonstandardFunctionContext.class,0);
		}
		public GenericFunctionContext genericFunction() {
			return getRuleContext(GenericFunctionContext.class,0);
		}
		public FunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_function; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final FunctionContext function() throws RecognitionException {
		FunctionContext _localctx = new FunctionContext(_ctx, getState());
		enterRule(_localctx, 228, RULE_function);
		try {
			setState(1268);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,130,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1260);
				standardFunction();
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1261);
				aggregateFunction();
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(1262);
				collectionSizeFunction();
				}
				break;
			case 4:
				enterOuterAlt(_localctx, 4);
				{
				setState(1263);
				indexAggregateFunction();
				}
				break;
			case 5:
				enterOuterAlt(_localctx, 5);
				{
				setState(1264);
				elementAggregateFunction();
				}
				break;
			case 6:
				enterOuterAlt(_localctx, 6);
				{
				setState(1265);
				collectionFunctionMisuse();
				}
				break;
			case 7:
				enterOuterAlt(_localctx, 7);
				{
				setState(1266);
				jpaNonstandardFunction();
				}
				break;
			case 8:
				enterOuterAlt(_localctx, 8);
				{
				setState(1267);
				genericFunction();
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class JpaNonstandardFunctionContext extends ParserRuleContext {
		public TerminalNode FUNCTION() { return getToken(HqlParser.FUNCTION, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public JpaNonstandardFunctionNameContext jpaNonstandardFunctionName() {
			return getRuleContext(JpaNonstandardFunctionNameContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode COMMA() { return getToken(HqlParser.COMMA, 0); }
		public GenericFunctionArgumentsContext genericFunctionArguments() {
			return getRuleContext(GenericFunctionArgumentsContext.class,0);
		}
		public JpaNonstandardFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_jpaNonstandardFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterJpaNonstandardFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitJpaNonstandardFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitJpaNonstandardFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final JpaNonstandardFunctionContext jpaNonstandardFunction() throws RecognitionException {
		JpaNonstandardFunctionContext _localctx = new JpaNonstandardFunctionContext(_ctx, getState());
		enterRule(_localctx, 230, RULE_jpaNonstandardFunction);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1270);
			match(FUNCTION);
			setState(1271);
			match(LEFT_PAREN);
			setState(1272);
			jpaNonstandardFunctionName();
			setState(1275);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==COMMA) {
				{
				setState(1273);
				match(COMMA);
				setState(1274);
				genericFunctionArguments();
				}
			}

			setState(1277);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class JpaNonstandardFunctionNameContext extends ParserRuleContext {
		public TerminalNode STRING_LITERAL() { return getToken(HqlParser.STRING_LITERAL, 0); }
		public JpaNonstandardFunctionNameContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_jpaNonstandardFunctionName; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterJpaNonstandardFunctionName(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitJpaNonstandardFunctionName(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitJpaNonstandardFunctionName(this);
			else return visitor.visitChildren(this);
		}
	}

	public final JpaNonstandardFunctionNameContext jpaNonstandardFunctionName() throws RecognitionException {
		JpaNonstandardFunctionNameContext _localctx = new JpaNonstandardFunctionNameContext(_ctx, getState());
		enterRule(_localctx, 232, RULE_jpaNonstandardFunctionName);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1279);
			match(STRING_LITERAL);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class GenericFunctionContext extends ParserRuleContext {
		public GenericFunctionNameContext genericFunctionName() {
			return getRuleContext(GenericFunctionNameContext.class,0);
		}
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public GenericFunctionArgumentsContext genericFunctionArguments() {
			return getRuleContext(GenericFunctionArgumentsContext.class,0);
		}
		public TerminalNode ASTERISK() { return getToken(HqlParser.ASTERISK, 0); }
		public NthSideClauseContext nthSideClause() {
			return getRuleContext(NthSideClauseContext.class,0);
		}
		public NullsClauseContext nullsClause() {
			return getRuleContext(NullsClauseContext.class,0);
		}
		public WithinGroupClauseContext withinGroupClause() {
			return getRuleContext(WithinGroupClauseContext.class,0);
		}
		public FilterClauseContext filterClause() {
			return getRuleContext(FilterClauseContext.class,0);
		}
		public OverClauseContext overClause() {
			return getRuleContext(OverClauseContext.class,0);
		}
		public GenericFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_genericFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterGenericFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitGenericFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitGenericFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final GenericFunctionContext genericFunction() throws RecognitionException {
		GenericFunctionContext _localctx = new GenericFunctionContext(_ctx, getState());
		enterRule(_localctx, 234, RULE_genericFunction);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1281);
			genericFunctionName();
			setState(1282);
			match(LEFT_PAREN);
			setState(1285);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case INTEGER_LITERAL:
			case LONG_LITERAL:
			case FLOAT_LITERAL:
			case DOUBLE_LITERAL:
			case BIG_INTEGER_LITERAL:
			case BIG_DECIMAL_LITERAL:
			case HEX_LITERAL:
			case STRING_LITERAL:
			case JAVA_STRING_LITERAL:
			case BINARY_LITERAL:
			case TIMESTAMP_ESCAPE_START:
			case DATE_ESCAPE_START:
			case TIME_ESCAPE_START:
			case LEFT_PAREN:
			case LEFT_BRACE:
			case PLUS:
			case MINUS:
			case COLON:
			case QUESTION_MARK:
			case ID:
			case VERSION:
			case VERSIONED:
			case NATURALID:
			case FK:
			case ALL:
			case AND:
			case ANY:
			case AS:
			case ASC:
			case AVG:
			case BETWEEN:
			case BOTH:
			case BY:
			case CASE:
			case CAST:
			case COLLATE:
			case COUNT:
			case CROSS:
			case CUBE:
			case CURRENT:
			case CURRENT_DATE:
			case CURRENT_INSTANT:
			case CURRENT_TIME:
			case CURRENT_TIMESTAMP:
			case DATE:
			case DATETIME:
			case DAY:
			case DELETE:
			case DESC:
			case DISTINCT:
			case ELEMENT:
			case ELEMENTS:
			case ELSE:
			case EMPTY:
			case END:
			case ENTRY:
			case ERROR:
			case ESCAPE:
			case EVERY:
			case EXCEPT:
			case EXCLUDE:
			case EXISTS:
			case EXTRACT:
			case FETCH:
			case FILTER:
			case FIRST:
			case FOLLOWING:
			case FOR:
			case FORMAT:
			case FROM:
			case FULL:
			case FUNCTION:
			case GROUP:
			case GROUPS:
			case HAVING:
			case HOUR:
			case IGNORE:
			case ILIKE:
			case IN:
			case INDEX:
			case INDICES:
			case INNER:
			case INSERT:
			case INSTANT:
			case INTERSECT:
			case INTO:
			case IS:
			case JOIN:
			case KEY:
			case LAST:
			case LEADING:
			case LEFT:
			case LIKE:
			case LIMIT:
			case LIST:
			case LISTAGG:
			case LOCAL:
			case LOCAL_DATE:
			case LOCAL_DATETIME:
			case LOCAL_TIME:
			case MAP:
			case MAX:
			case MAXELEMENT:
			case MAXINDEX:
			case MEMBER:
			case MICROSECOND:
			case MILLISECOND:
			case MIN:
			case MINELEMENT:
			case MININDEX:
			case MINUTE:
			case MONTH:
			case NANOSECOND:
			case NEW:
			case NEXT:
			case NO:
			case NOT:
			case NULLS:
			case OBJECT:
			case OF:
			case OFFSET:
			case OFFSET_DATETIME:
			case ON:
			case ONLY:
			case OR:
			case ORDER:
			case OTHERS:
			case OUTER:
			case OVER:
			case OVERFLOW:
			case OVERLAY:
			case PAD:
			case PARTITION:
			case PERCENT:
			case PLACING:
			case POSITION:
			case PRECEDING:
			case QUARTER:
			case RANGE:
			case RESPECT:
			case RIGHT:
			case ROLLUP:
			case ROW:
			case ROWS:
			case SECOND:
			case SELECT:
			case SET:
			case SIZE:
			case SOME:
			case SUBSTRING:
			case SUM:
			case THEN:
			case TIES:
			case TIME:
			case TIMESTAMP:
			case TIMEZONE_HOUR:
			case TIMEZONE_MINUTE:
			case TRAILING:
			case TREAT:
			case TRIM:
			case TRUNCATE:
			case TYPE:
			case UNBOUNDED:
			case UNION:
			case UPDATE:
			case VALUE:
			case VALUES:
			case WEEK:
			case WHEN:
			case WHERE:
			case WITH:
			case WITHIN:
			case WITHOUT:
			case YEAR:
			case TRUE:
			case FALSE:
			case NULL:
			case IDENTIFIER:
			case QUOTED_IDENTIFIER:
				{
				setState(1283);
				genericFunctionArguments();
				}
				break;
			case ASTERISK:
				{
				setState(1284);
				match(ASTERISK);
				}
				break;
			case RIGHT_PAREN:
				break;
			default:
				break;
			}
			setState(1287);
			match(RIGHT_PAREN);
			setState(1289);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,133,_ctx) ) {
			case 1:
				{
				setState(1288);
				nthSideClause();
				}
				break;
			}
			setState(1292);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,134,_ctx) ) {
			case 1:
				{
				setState(1291);
				nullsClause();
				}
				break;
			}
			setState(1295);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,135,_ctx) ) {
			case 1:
				{
				setState(1294);
				withinGroupClause();
				}
				break;
			}
			setState(1298);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,136,_ctx) ) {
			case 1:
				{
				setState(1297);
				filterClause();
				}
				break;
			}
			setState(1301);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,137,_ctx) ) {
			case 1:
				{
				setState(1300);
				overClause();
				}
				break;
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class GenericFunctionNameContext extends ParserRuleContext {
		public SimplePathContext simplePath() {
			return getRuleContext(SimplePathContext.class,0);
		}
		public GenericFunctionNameContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_genericFunctionName; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterGenericFunctionName(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitGenericFunctionName(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitGenericFunctionName(this);
			else return visitor.visitChildren(this);
		}
	}

	public final GenericFunctionNameContext genericFunctionName() throws RecognitionException {
		GenericFunctionNameContext _localctx = new GenericFunctionNameContext(_ctx, getState());
		enterRule(_localctx, 236, RULE_genericFunctionName);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1303);
			simplePath();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class GenericFunctionArgumentsContext extends ParserRuleContext {
		public List<ExpressionOrPredicateContext> expressionOrPredicate() {
			return getRuleContexts(ExpressionOrPredicateContext.class);
		}
		public ExpressionOrPredicateContext expressionOrPredicate(int i) {
			return getRuleContext(ExpressionOrPredicateContext.class,i);
		}
		public TerminalNode DISTINCT() { return getToken(HqlParser.DISTINCT, 0); }
		public DatetimeFieldContext datetimeField() {
			return getRuleContext(DatetimeFieldContext.class,0);
		}
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public GenericFunctionArgumentsContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_genericFunctionArguments; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterGenericFunctionArguments(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitGenericFunctionArguments(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitGenericFunctionArguments(this);
			else return visitor.visitChildren(this);
		}
	}

	public final GenericFunctionArgumentsContext genericFunctionArguments() throws RecognitionException {
		GenericFunctionArgumentsContext _localctx = new GenericFunctionArgumentsContext(_ctx, getState());
		enterRule(_localctx, 238, RULE_genericFunctionArguments);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1309);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,138,_ctx) ) {
			case 1:
				{
				setState(1305);
				match(DISTINCT);
				}
				break;
			case 2:
				{
				setState(1306);
				datetimeField();
				setState(1307);
				match(COMMA);
				}
				break;
			}
			setState(1311);
			expressionOrPredicate();
			setState(1316);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==COMMA) {
				{
				{
				setState(1312);
				match(COMMA);
				setState(1313);
				expressionOrPredicate();
				}
				}
				setState(1318);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class CollectionSizeFunctionContext extends ParserRuleContext {
		public TerminalNode SIZE() { return getToken(HqlParser.SIZE, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public CollectionSizeFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_collectionSizeFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCollectionSizeFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCollectionSizeFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCollectionSizeFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CollectionSizeFunctionContext collectionSizeFunction() throws RecognitionException {
		CollectionSizeFunctionContext _localctx = new CollectionSizeFunctionContext(_ctx, getState());
		enterRule(_localctx, 240, RULE_collectionSizeFunction);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1319);
			match(SIZE);
			setState(1320);
			match(LEFT_PAREN);
			setState(1321);
			path();
			setState(1322);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class IndexAggregateFunctionContext extends ParserRuleContext {
		public TerminalNode MAXINDEX() { return getToken(HqlParser.MAXINDEX, 0); }
		public List<TerminalNode> LEFT_PAREN() { return getTokens(HqlParser.LEFT_PAREN); }
		public TerminalNode LEFT_PAREN(int i) {
			return getToken(HqlParser.LEFT_PAREN, i);
		}
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public List<TerminalNode> RIGHT_PAREN() { return getTokens(HqlParser.RIGHT_PAREN); }
		public TerminalNode RIGHT_PAREN(int i) {
			return getToken(HqlParser.RIGHT_PAREN, i);
		}
		public TerminalNode MININDEX() { return getToken(HqlParser.MININDEX, 0); }
		public TerminalNode MAX() { return getToken(HqlParser.MAX, 0); }
		public TerminalNode INDICES() { return getToken(HqlParser.INDICES, 0); }
		public TerminalNode MIN() { return getToken(HqlParser.MIN, 0); }
		public TerminalNode SUM() { return getToken(HqlParser.SUM, 0); }
		public TerminalNode AVG() { return getToken(HqlParser.AVG, 0); }
		public IndexAggregateFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_indexAggregateFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterIndexAggregateFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitIndexAggregateFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitIndexAggregateFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final IndexAggregateFunctionContext indexAggregateFunction() throws RecognitionException {
		IndexAggregateFunctionContext _localctx = new IndexAggregateFunctionContext(_ctx, getState());
		enterRule(_localctx, 242, RULE_indexAggregateFunction);
		try {
			setState(1366);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case MAXINDEX:
				enterOuterAlt(_localctx, 1);
				{
				setState(1324);
				match(MAXINDEX);
				setState(1325);
				match(LEFT_PAREN);
				setState(1326);
				path();
				setState(1327);
				match(RIGHT_PAREN);
				}
				break;
			case MININDEX:
				enterOuterAlt(_localctx, 2);
				{
				setState(1329);
				match(MININDEX);
				setState(1330);
				match(LEFT_PAREN);
				setState(1331);
				path();
				setState(1332);
				match(RIGHT_PAREN);
				}
				break;
			case MAX:
				enterOuterAlt(_localctx, 3);
				{
				setState(1334);
				match(MAX);
				setState(1335);
				match(LEFT_PAREN);
				setState(1336);
				match(INDICES);
				setState(1337);
				match(LEFT_PAREN);
				setState(1338);
				path();
				setState(1339);
				match(RIGHT_PAREN);
				setState(1340);
				match(RIGHT_PAREN);
				}
				break;
			case MIN:
				enterOuterAlt(_localctx, 4);
				{
				setState(1342);
				match(MIN);
				setState(1343);
				match(LEFT_PAREN);
				setState(1344);
				match(INDICES);
				setState(1345);
				match(LEFT_PAREN);
				setState(1346);
				path();
				setState(1347);
				match(RIGHT_PAREN);
				setState(1348);
				match(RIGHT_PAREN);
				}
				break;
			case SUM:
				enterOuterAlt(_localctx, 5);
				{
				setState(1350);
				match(SUM);
				setState(1351);
				match(LEFT_PAREN);
				setState(1352);
				match(INDICES);
				setState(1353);
				match(LEFT_PAREN);
				setState(1354);
				path();
				setState(1355);
				match(RIGHT_PAREN);
				setState(1356);
				match(RIGHT_PAREN);
				}
				break;
			case AVG:
				enterOuterAlt(_localctx, 6);
				{
				setState(1358);
				match(AVG);
				setState(1359);
				match(LEFT_PAREN);
				setState(1360);
				match(INDICES);
				setState(1361);
				match(LEFT_PAREN);
				setState(1362);
				path();
				setState(1363);
				match(RIGHT_PAREN);
				setState(1364);
				match(RIGHT_PAREN);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class ElementAggregateFunctionContext extends ParserRuleContext {
		public TerminalNode MAXELEMENT() { return getToken(HqlParser.MAXELEMENT, 0); }
		public List<TerminalNode> LEFT_PAREN() { return getTokens(HqlParser.LEFT_PAREN); }
		public TerminalNode LEFT_PAREN(int i) {
			return getToken(HqlParser.LEFT_PAREN, i);
		}
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public List<TerminalNode> RIGHT_PAREN() { return getTokens(HqlParser.RIGHT_PAREN); }
		public TerminalNode RIGHT_PAREN(int i) {
			return getToken(HqlParser.RIGHT_PAREN, i);
		}
		public TerminalNode MINELEMENT() { return getToken(HqlParser.MINELEMENT, 0); }
		public TerminalNode MAX() { return getToken(HqlParser.MAX, 0); }
		public TerminalNode ELEMENTS() { return getToken(HqlParser.ELEMENTS, 0); }
		public TerminalNode MIN() { return getToken(HqlParser.MIN, 0); }
		public TerminalNode SUM() { return getToken(HqlParser.SUM, 0); }
		public TerminalNode AVG() { return getToken(HqlParser.AVG, 0); }
		public ElementAggregateFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_elementAggregateFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterElementAggregateFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitElementAggregateFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitElementAggregateFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ElementAggregateFunctionContext elementAggregateFunction() throws RecognitionException {
		ElementAggregateFunctionContext _localctx = new ElementAggregateFunctionContext(_ctx, getState());
		enterRule(_localctx, 244, RULE_elementAggregateFunction);
		try {
			setState(1410);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case MAXELEMENT:
				enterOuterAlt(_localctx, 1);
				{
				setState(1368);
				match(MAXELEMENT);
				setState(1369);
				match(LEFT_PAREN);
				setState(1370);
				path();
				setState(1371);
				match(RIGHT_PAREN);
				}
				break;
			case MINELEMENT:
				enterOuterAlt(_localctx, 2);
				{
				setState(1373);
				match(MINELEMENT);
				setState(1374);
				match(LEFT_PAREN);
				setState(1375);
				path();
				setState(1376);
				match(RIGHT_PAREN);
				}
				break;
			case MAX:
				enterOuterAlt(_localctx, 3);
				{
				setState(1378);
				match(MAX);
				setState(1379);
				match(LEFT_PAREN);
				setState(1380);
				match(ELEMENTS);
				setState(1381);
				match(LEFT_PAREN);
				setState(1382);
				path();
				setState(1383);
				match(RIGHT_PAREN);
				setState(1384);
				match(RIGHT_PAREN);
				}
				break;
			case MIN:
				enterOuterAlt(_localctx, 4);
				{
				setState(1386);
				match(MIN);
				setState(1387);
				match(LEFT_PAREN);
				setState(1388);
				match(ELEMENTS);
				setState(1389);
				match(LEFT_PAREN);
				setState(1390);
				path();
				setState(1391);
				match(RIGHT_PAREN);
				setState(1392);
				match(RIGHT_PAREN);
				}
				break;
			case SUM:
				enterOuterAlt(_localctx, 5);
				{
				setState(1394);
				match(SUM);
				setState(1395);
				match(LEFT_PAREN);
				setState(1396);
				match(ELEMENTS);
				setState(1397);
				match(LEFT_PAREN);
				setState(1398);
				path();
				setState(1399);
				match(RIGHT_PAREN);
				setState(1400);
				match(RIGHT_PAREN);
				}
				break;
			case AVG:
				enterOuterAlt(_localctx, 6);
				{
				setState(1402);
				match(AVG);
				setState(1403);
				match(LEFT_PAREN);
				setState(1404);
				match(ELEMENTS);
				setState(1405);
				match(LEFT_PAREN);
				setState(1406);
				path();
				setState(1407);
				match(RIGHT_PAREN);
				setState(1408);
				match(RIGHT_PAREN);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class CollectionFunctionMisuseContext extends ParserRuleContext {
		public TerminalNode ELEMENTS() { return getToken(HqlParser.ELEMENTS, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode INDICES() { return getToken(HqlParser.INDICES, 0); }
		public CollectionFunctionMisuseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_collectionFunctionMisuse; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCollectionFunctionMisuse(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCollectionFunctionMisuse(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCollectionFunctionMisuse(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CollectionFunctionMisuseContext collectionFunctionMisuse() throws RecognitionException {
		CollectionFunctionMisuseContext _localctx = new CollectionFunctionMisuseContext(_ctx, getState());
		enterRule(_localctx, 246, RULE_collectionFunctionMisuse);
		try {
			setState(1422);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case ELEMENTS:
				enterOuterAlt(_localctx, 1);
				{
				setState(1412);
				match(ELEMENTS);
				setState(1413);
				match(LEFT_PAREN);
				setState(1414);
				path();
				setState(1415);
				match(RIGHT_PAREN);
				}
				break;
			case INDICES:
				enterOuterAlt(_localctx, 2);
				{
				setState(1417);
				match(INDICES);
				setState(1418);
				match(LEFT_PAREN);
				setState(1419);
				path();
				setState(1420);
				match(RIGHT_PAREN);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class AggregateFunctionContext extends ParserRuleContext {
		public EveryFunctionContext everyFunction() {
			return getRuleContext(EveryFunctionContext.class,0);
		}
		public AnyFunctionContext anyFunction() {
			return getRuleContext(AnyFunctionContext.class,0);
		}
		public ListaggFunctionContext listaggFunction() {
			return getRuleContext(ListaggFunctionContext.class,0);
		}
		public AggregateFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_aggregateFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterAggregateFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitAggregateFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitAggregateFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final AggregateFunctionContext aggregateFunction() throws RecognitionException {
		AggregateFunctionContext _localctx = new AggregateFunctionContext(_ctx, getState());
		enterRule(_localctx, 248, RULE_aggregateFunction);
		try {
			setState(1427);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case ALL:
			case EVERY:
				enterOuterAlt(_localctx, 1);
				{
				setState(1424);
				everyFunction();
				}
				break;
			case ANY:
			case SOME:
				enterOuterAlt(_localctx, 2);
				{
				setState(1425);
				anyFunction();
				}
				break;
			case LISTAGG:
				enterOuterAlt(_localctx, 3);
				{
				setState(1426);
				listaggFunction();
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class EveryFunctionContext extends ParserRuleContext {
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public PredicateContext predicate() {
			return getRuleContext(PredicateContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode EVERY() { return getToken(HqlParser.EVERY, 0); }
		public TerminalNode ALL() { return getToken(HqlParser.ALL, 0); }
		public FilterClauseContext filterClause() {
			return getRuleContext(FilterClauseContext.class,0);
		}
		public OverClauseContext overClause() {
			return getRuleContext(OverClauseContext.class,0);
		}
		public SubqueryContext subquery() {
			return getRuleContext(SubqueryContext.class,0);
		}
		public SimplePathContext simplePath() {
			return getRuleContext(SimplePathContext.class,0);
		}
		public TerminalNode ELEMENTS() { return getToken(HqlParser.ELEMENTS, 0); }
		public TerminalNode INDICES() { return getToken(HqlParser.INDICES, 0); }
		public EveryFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_everyFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterEveryFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitEveryFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitEveryFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final EveryFunctionContext everyFunction() throws RecognitionException {
		EveryFunctionContext _localctx = new EveryFunctionContext(_ctx, getState());
		enterRule(_localctx, 250, RULE_everyFunction);
		int _la;
		try {
			setState(1450);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,146,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1429);
				_la = _input.LA(1);
				if ( !(_la==ALL || _la==EVERY) ) {
				_errHandler.recoverInline(this);
				}
				else {
					if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
					_errHandler.reportMatch(this);
					consume();
				}
				setState(1430);
				match(LEFT_PAREN);
				setState(1431);
				predicate(0);
				setState(1432);
				match(RIGHT_PAREN);
				setState(1434);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,144,_ctx) ) {
				case 1:
					{
					setState(1433);
					filterClause();
					}
					break;
				}
				setState(1437);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,145,_ctx) ) {
				case 1:
					{
					setState(1436);
					overClause();
					}
					break;
				}
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1439);
				_la = _input.LA(1);
				if ( !(_la==ALL || _la==EVERY) ) {
				_errHandler.recoverInline(this);
				}
				else {
					if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
					_errHandler.reportMatch(this);
					consume();
				}
				setState(1440);
				match(LEFT_PAREN);
				setState(1441);
				subquery();
				setState(1442);
				match(RIGHT_PAREN);
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(1444);
				_la = _input.LA(1);
				if ( !(_la==ALL || _la==EVERY) ) {
				_errHandler.recoverInline(this);
				}
				else {
					if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
					_errHandler.reportMatch(this);
					consume();
				}
				setState(1445);
				_la = _input.LA(1);
				if ( !(_la==ELEMENTS || _la==INDICES) ) {
				_errHandler.recoverInline(this);
				}
				else {
					if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
					_errHandler.reportMatch(this);
					consume();
				}
				setState(1446);
				match(LEFT_PAREN);
				setState(1447);
				simplePath();
				setState(1448);
				match(RIGHT_PAREN);
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class AnyFunctionContext extends ParserRuleContext {
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public PredicateContext predicate() {
			return getRuleContext(PredicateContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode ANY() { return getToken(HqlParser.ANY, 0); }
		public TerminalNode SOME() { return getToken(HqlParser.SOME, 0); }
		public FilterClauseContext filterClause() {
			return getRuleContext(FilterClauseContext.class,0);
		}
		public OverClauseContext overClause() {
			return getRuleContext(OverClauseContext.class,0);
		}
		public SubqueryContext subquery() {
			return getRuleContext(SubqueryContext.class,0);
		}
		public SimplePathContext simplePath() {
			return getRuleContext(SimplePathContext.class,0);
		}
		public TerminalNode ELEMENTS() { return getToken(HqlParser.ELEMENTS, 0); }
		public TerminalNode INDICES() { return getToken(HqlParser.INDICES, 0); }
		public AnyFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_anyFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterAnyFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitAnyFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitAnyFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final AnyFunctionContext anyFunction() throws RecognitionException {
		AnyFunctionContext _localctx = new AnyFunctionContext(_ctx, getState());
		enterRule(_localctx, 252, RULE_anyFunction);
		int _la;
		try {
			setState(1473);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,149,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1452);
				_la = _input.LA(1);
				if ( !(_la==ANY || _la==SOME) ) {
				_errHandler.recoverInline(this);
				}
				else {
					if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
					_errHandler.reportMatch(this);
					consume();
				}
				setState(1453);
				match(LEFT_PAREN);
				setState(1454);
				predicate(0);
				setState(1455);
				match(RIGHT_PAREN);
				setState(1457);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,147,_ctx) ) {
				case 1:
					{
					setState(1456);
					filterClause();
					}
					break;
				}
				setState(1460);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,148,_ctx) ) {
				case 1:
					{
					setState(1459);
					overClause();
					}
					break;
				}
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1462);
				_la = _input.LA(1);
				if ( !(_la==ANY || _la==SOME) ) {
				_errHandler.recoverInline(this);
				}
				else {
					if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
					_errHandler.reportMatch(this);
					consume();
				}
				setState(1463);
				match(LEFT_PAREN);
				setState(1464);
				subquery();
				setState(1465);
				match(RIGHT_PAREN);
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(1467);
				_la = _input.LA(1);
				if ( !(_la==ANY || _la==SOME) ) {
				_errHandler.recoverInline(this);
				}
				else {
					if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
					_errHandler.reportMatch(this);
					consume();
				}
				setState(1468);
				_la = _input.LA(1);
				if ( !(_la==ELEMENTS || _la==INDICES) ) {
				_errHandler.recoverInline(this);
				}
				else {
					if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
					_errHandler.reportMatch(this);
					consume();
				}
				setState(1469);
				match(LEFT_PAREN);
				setState(1470);
				simplePath();
				setState(1471);
				match(RIGHT_PAREN);
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class ListaggFunctionContext extends ParserRuleContext {
		public TerminalNode LISTAGG() { return getToken(HqlParser.LISTAGG, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public List<ExpressionOrPredicateContext> expressionOrPredicate() {
			return getRuleContexts(ExpressionOrPredicateContext.class);
		}
		public ExpressionOrPredicateContext expressionOrPredicate(int i) {
			return getRuleContext(ExpressionOrPredicateContext.class,i);
		}
		public TerminalNode COMMA() { return getToken(HqlParser.COMMA, 0); }
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode DISTINCT() { return getToken(HqlParser.DISTINCT, 0); }
		public OnOverflowClauseContext onOverflowClause() {
			return getRuleContext(OnOverflowClauseContext.class,0);
		}
		public WithinGroupClauseContext withinGroupClause() {
			return getRuleContext(WithinGroupClauseContext.class,0);
		}
		public FilterClauseContext filterClause() {
			return getRuleContext(FilterClauseContext.class,0);
		}
		public OverClauseContext overClause() {
			return getRuleContext(OverClauseContext.class,0);
		}
		public ListaggFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_listaggFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterListaggFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitListaggFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitListaggFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ListaggFunctionContext listaggFunction() throws RecognitionException {
		ListaggFunctionContext _localctx = new ListaggFunctionContext(_ctx, getState());
		enterRule(_localctx, 254, RULE_listaggFunction);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1475);
			match(LISTAGG);
			setState(1476);
			match(LEFT_PAREN);
			setState(1478);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,150,_ctx) ) {
			case 1:
				{
				setState(1477);
				match(DISTINCT);
				}
				break;
			}
			setState(1480);
			expressionOrPredicate();
			setState(1481);
			match(COMMA);
			setState(1482);
			expressionOrPredicate();
			setState(1484);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==ON) {
				{
				setState(1483);
				onOverflowClause();
				}
			}

			setState(1486);
			match(RIGHT_PAREN);
			setState(1488);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,152,_ctx) ) {
			case 1:
				{
				setState(1487);
				withinGroupClause();
				}
				break;
			}
			setState(1491);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,153,_ctx) ) {
			case 1:
				{
				setState(1490);
				filterClause();
				}
				break;
			}
			setState(1494);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,154,_ctx) ) {
			case 1:
				{
				setState(1493);
				overClause();
				}
				break;
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class OnOverflowClauseContext extends ParserRuleContext {
		public TerminalNode ON() { return getToken(HqlParser.ON, 0); }
		public TerminalNode OVERFLOW() { return getToken(HqlParser.OVERFLOW, 0); }
		public TerminalNode ERROR() { return getToken(HqlParser.ERROR, 0); }
		public TerminalNode TRUNCATE() { return getToken(HqlParser.TRUNCATE, 0); }
		public TerminalNode COUNT() { return getToken(HqlParser.COUNT, 0); }
		public TerminalNode WITH() { return getToken(HqlParser.WITH, 0); }
		public TerminalNode WITHOUT() { return getToken(HqlParser.WITHOUT, 0); }
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public OnOverflowClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_onOverflowClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterOnOverflowClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitOnOverflowClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitOnOverflowClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final OnOverflowClauseContext onOverflowClause() throws RecognitionException {
		OnOverflowClauseContext _localctx = new OnOverflowClauseContext(_ctx, getState());
		enterRule(_localctx, 256, RULE_onOverflowClause);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1496);
			match(ON);
			setState(1497);
			match(OVERFLOW);
			setState(1505);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case ERROR:
				{
				setState(1498);
				match(ERROR);
				}
				break;
			case TRUNCATE:
				{
				{
				setState(1499);
				match(TRUNCATE);
				setState(1501);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,155,_ctx) ) {
				case 1:
					{
					setState(1500);
					expression(0);
					}
					break;
				}
				setState(1503);
				_la = _input.LA(1);
				if ( !(_la==WITH || _la==WITHOUT) ) {
				_errHandler.recoverInline(this);
				}
				else {
					if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
					_errHandler.reportMatch(this);
					consume();
				}
				setState(1504);
				match(COUNT);
				}
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class WithinGroupClauseContext extends ParserRuleContext {
		public TerminalNode WITHIN() { return getToken(HqlParser.WITHIN, 0); }
		public TerminalNode GROUP() { return getToken(HqlParser.GROUP, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public OrderByClauseContext orderByClause() {
			return getRuleContext(OrderByClauseContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public WithinGroupClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_withinGroupClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterWithinGroupClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitWithinGroupClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitWithinGroupClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final WithinGroupClauseContext withinGroupClause() throws RecognitionException {
		WithinGroupClauseContext _localctx = new WithinGroupClauseContext(_ctx, getState());
		enterRule(_localctx, 258, RULE_withinGroupClause);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1507);
			match(WITHIN);
			setState(1508);
			match(GROUP);
			setState(1509);
			match(LEFT_PAREN);
			setState(1510);
			orderByClause();
			setState(1511);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class FilterClauseContext extends ParserRuleContext {
		public TerminalNode FILTER() { return getToken(HqlParser.FILTER, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public WhereClauseContext whereClause() {
			return getRuleContext(WhereClauseContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public FilterClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_filterClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterFilterClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitFilterClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitFilterClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final FilterClauseContext filterClause() throws RecognitionException {
		FilterClauseContext _localctx = new FilterClauseContext(_ctx, getState());
		enterRule(_localctx, 260, RULE_filterClause);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1513);
			match(FILTER);
			setState(1514);
			match(LEFT_PAREN);
			setState(1515);
			whereClause();
			setState(1516);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class NullsClauseContext extends ParserRuleContext {
		public TerminalNode RESPECT() { return getToken(HqlParser.RESPECT, 0); }
		public TerminalNode NULLS() { return getToken(HqlParser.NULLS, 0); }
		public TerminalNode IGNORE() { return getToken(HqlParser.IGNORE, 0); }
		public NullsClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_nullsClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterNullsClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitNullsClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitNullsClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final NullsClauseContext nullsClause() throws RecognitionException {
		NullsClauseContext _localctx = new NullsClauseContext(_ctx, getState());
		enterRule(_localctx, 262, RULE_nullsClause);
		try {
			setState(1522);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case RESPECT:
				enterOuterAlt(_localctx, 1);
				{
				setState(1518);
				match(RESPECT);
				setState(1519);
				match(NULLS);
				}
				break;
			case IGNORE:
				enterOuterAlt(_localctx, 2);
				{
				setState(1520);
				match(IGNORE);
				setState(1521);
				match(NULLS);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class NthSideClauseContext extends ParserRuleContext {
		public TerminalNode FROM() { return getToken(HqlParser.FROM, 0); }
		public TerminalNode FIRST() { return getToken(HqlParser.FIRST, 0); }
		public TerminalNode LAST() { return getToken(HqlParser.LAST, 0); }
		public NthSideClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_nthSideClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterNthSideClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitNthSideClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitNthSideClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final NthSideClauseContext nthSideClause() throws RecognitionException {
		NthSideClauseContext _localctx = new NthSideClauseContext(_ctx, getState());
		enterRule(_localctx, 264, RULE_nthSideClause);
		try {
			setState(1528);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,158,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1524);
				match(FROM);
				setState(1525);
				match(FIRST);
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1526);
				match(FROM);
				setState(1527);
				match(LAST);
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class OverClauseContext extends ParserRuleContext {
		public TerminalNode OVER() { return getToken(HqlParser.OVER, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public PartitionClauseContext partitionClause() {
			return getRuleContext(PartitionClauseContext.class,0);
		}
		public OrderByClauseContext orderByClause() {
			return getRuleContext(OrderByClauseContext.class,0);
		}
		public FrameClauseContext frameClause() {
			return getRuleContext(FrameClauseContext.class,0);
		}
		public OverClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_overClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterOverClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitOverClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitOverClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final OverClauseContext overClause() throws RecognitionException {
		OverClauseContext _localctx = new OverClauseContext(_ctx, getState());
		enterRule(_localctx, 266, RULE_overClause);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1530);
			match(OVER);
			setState(1531);
			match(LEFT_PAREN);
			setState(1533);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==PARTITION) {
				{
				setState(1532);
				partitionClause();
				}
			}

			setState(1536);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==ORDER) {
				{
				setState(1535);
				orderByClause();
				}
			}

			setState(1539);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==GROUPS || _la==RANGE || _la==ROWS) {
				{
				setState(1538);
				frameClause();
				}
			}

			setState(1541);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class PartitionClauseContext extends ParserRuleContext {
		public TerminalNode PARTITION() { return getToken(HqlParser.PARTITION, 0); }
		public TerminalNode BY() { return getToken(HqlParser.BY, 0); }
		public List<ExpressionContext> expression() {
			return getRuleContexts(ExpressionContext.class);
		}
		public ExpressionContext expression(int i) {
			return getRuleContext(ExpressionContext.class,i);
		}
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public PartitionClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_partitionClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterPartitionClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitPartitionClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitPartitionClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final PartitionClauseContext partitionClause() throws RecognitionException {
		PartitionClauseContext _localctx = new PartitionClauseContext(_ctx, getState());
		enterRule(_localctx, 268, RULE_partitionClause);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1543);
			match(PARTITION);
			setState(1544);
			match(BY);
			setState(1545);
			expression(0);
			setState(1550);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==COMMA) {
				{
				{
				setState(1546);
				match(COMMA);
				setState(1547);
				expression(0);
				}
				}
				setState(1552);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class FrameClauseContext extends ParserRuleContext {
		public FrameStartContext frameStart() {
			return getRuleContext(FrameStartContext.class,0);
		}
		public TerminalNode RANGE() { return getToken(HqlParser.RANGE, 0); }
		public TerminalNode ROWS() { return getToken(HqlParser.ROWS, 0); }
		public TerminalNode GROUPS() { return getToken(HqlParser.GROUPS, 0); }
		public FrameExclusionContext frameExclusion() {
			return getRuleContext(FrameExclusionContext.class,0);
		}
		public TerminalNode BETWEEN() { return getToken(HqlParser.BETWEEN, 0); }
		public TerminalNode AND() { return getToken(HqlParser.AND, 0); }
		public FrameEndContext frameEnd() {
			return getRuleContext(FrameEndContext.class,0);
		}
		public FrameClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_frameClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterFrameClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitFrameClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitFrameClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final FrameClauseContext frameClause() throws RecognitionException {
		FrameClauseContext _localctx = new FrameClauseContext(_ctx, getState());
		enterRule(_localctx, 270, RULE_frameClause);
		int _la;
		try {
			setState(1566);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,165,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1553);
				_la = _input.LA(1);
				if ( !(_la==GROUPS || _la==RANGE || _la==ROWS) ) {
				_errHandler.recoverInline(this);
				}
				else {
					if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
					_errHandler.reportMatch(this);
					consume();
				}
				setState(1554);
				frameStart();
				setState(1556);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==EXCLUDE) {
					{
					setState(1555);
					frameExclusion();
					}
				}

				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1558);
				_la = _input.LA(1);
				if ( !(_la==GROUPS || _la==RANGE || _la==ROWS) ) {
				_errHandler.recoverInline(this);
				}
				else {
					if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
					_errHandler.reportMatch(this);
					consume();
				}
				setState(1559);
				match(BETWEEN);
				setState(1560);
				frameStart();
				setState(1561);
				match(AND);
				setState(1562);
				frameEnd();
				setState(1564);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==EXCLUDE) {
					{
					setState(1563);
					frameExclusion();
					}
				}

				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class FrameStartContext extends ParserRuleContext {
		public TerminalNode UNBOUNDED() { return getToken(HqlParser.UNBOUNDED, 0); }
		public TerminalNode PRECEDING() { return getToken(HqlParser.PRECEDING, 0); }
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode CURRENT() { return getToken(HqlParser.CURRENT, 0); }
		public TerminalNode ROW() { return getToken(HqlParser.ROW, 0); }
		public TerminalNode FOLLOWING() { return getToken(HqlParser.FOLLOWING, 0); }
		public FrameStartContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_frameStart; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterFrameStart(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitFrameStart(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitFrameStart(this);
			else return visitor.visitChildren(this);
		}
	}

	public final FrameStartContext frameStart() throws RecognitionException {
		FrameStartContext _localctx = new FrameStartContext(_ctx, getState());
		enterRule(_localctx, 272, RULE_frameStart);
		try {
			setState(1578);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,166,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1568);
				match(UNBOUNDED);
				setState(1569);
				match(PRECEDING);
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1570);
				expression(0);
				setState(1571);
				match(PRECEDING);
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(1573);
				match(CURRENT);
				setState(1574);
				match(ROW);
				}
				break;
			case 4:
				enterOuterAlt(_localctx, 4);
				{
				setState(1575);
				expression(0);
				setState(1576);
				match(FOLLOWING);
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class FrameEndContext extends ParserRuleContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode PRECEDING() { return getToken(HqlParser.PRECEDING, 0); }
		public TerminalNode CURRENT() { return getToken(HqlParser.CURRENT, 0); }
		public TerminalNode ROW() { return getToken(HqlParser.ROW, 0); }
		public TerminalNode FOLLOWING() { return getToken(HqlParser.FOLLOWING, 0); }
		public TerminalNode UNBOUNDED() { return getToken(HqlParser.UNBOUNDED, 0); }
		public FrameEndContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_frameEnd; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterFrameEnd(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitFrameEnd(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitFrameEnd(this);
			else return visitor.visitChildren(this);
		}
	}

	public final FrameEndContext frameEnd() throws RecognitionException {
		FrameEndContext _localctx = new FrameEndContext(_ctx, getState());
		enterRule(_localctx, 274, RULE_frameEnd);
		try {
			setState(1590);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,167,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1580);
				expression(0);
				setState(1581);
				match(PRECEDING);
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1583);
				match(CURRENT);
				setState(1584);
				match(ROW);
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(1585);
				expression(0);
				setState(1586);
				match(FOLLOWING);
				}
				break;
			case 4:
				enterOuterAlt(_localctx, 4);
				{
				setState(1588);
				match(UNBOUNDED);
				setState(1589);
				match(FOLLOWING);
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class FrameExclusionContext extends ParserRuleContext {
		public TerminalNode EXCLUDE() { return getToken(HqlParser.EXCLUDE, 0); }
		public TerminalNode CURRENT() { return getToken(HqlParser.CURRENT, 0); }
		public TerminalNode ROW() { return getToken(HqlParser.ROW, 0); }
		public TerminalNode GROUP() { return getToken(HqlParser.GROUP, 0); }
		public TerminalNode TIES() { return getToken(HqlParser.TIES, 0); }
		public TerminalNode NO() { return getToken(HqlParser.NO, 0); }
		public TerminalNode OTHERS() { return getToken(HqlParser.OTHERS, 0); }
		public FrameExclusionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_frameExclusion; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterFrameExclusion(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitFrameExclusion(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitFrameExclusion(this);
			else return visitor.visitChildren(this);
		}
	}

	public final FrameExclusionContext frameExclusion() throws RecognitionException {
		FrameExclusionContext _localctx = new FrameExclusionContext(_ctx, getState());
		enterRule(_localctx, 276, RULE_frameExclusion);
		try {
			setState(1602);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,168,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1592);
				match(EXCLUDE);
				setState(1593);
				match(CURRENT);
				setState(1594);
				match(ROW);
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1595);
				match(EXCLUDE);
				setState(1596);
				match(GROUP);
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(1597);
				match(EXCLUDE);
				setState(1598);
				match(TIES);
				}
				break;
			case 4:
				enterOuterAlt(_localctx, 4);
				{
				setState(1599);
				match(EXCLUDE);
				setState(1600);
				match(NO);
				setState(1601);
				match(OTHERS);
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class StandardFunctionContext extends ParserRuleContext {
		public CastFunctionContext castFunction() {
			return getRuleContext(CastFunctionContext.class,0);
		}
		public ExtractFunctionContext extractFunction() {
			return getRuleContext(ExtractFunctionContext.class,0);
		}
		public FormatFunctionContext formatFunction() {
			return getRuleContext(FormatFunctionContext.class,0);
		}
		public CollateFunctionContext collateFunction() {
			return getRuleContext(CollateFunctionContext.class,0);
		}
		public SubstringFunctionContext substringFunction() {
			return getRuleContext(SubstringFunctionContext.class,0);
		}
		public OverlayFunctionContext overlayFunction() {
			return getRuleContext(OverlayFunctionContext.class,0);
		}
		public TrimFunctionContext trimFunction() {
			return getRuleContext(TrimFunctionContext.class,0);
		}
		public PadFunctionContext padFunction() {
			return getRuleContext(PadFunctionContext.class,0);
		}
		public PositionFunctionContext positionFunction() {
			return getRuleContext(PositionFunctionContext.class,0);
		}
		public CurrentDateFunctionContext currentDateFunction() {
			return getRuleContext(CurrentDateFunctionContext.class,0);
		}
		public CurrentTimeFunctionContext currentTimeFunction() {
			return getRuleContext(CurrentTimeFunctionContext.class,0);
		}
		public CurrentTimestampFunctionContext currentTimestampFunction() {
			return getRuleContext(CurrentTimestampFunctionContext.class,0);
		}
		public InstantFunctionContext instantFunction() {
			return getRuleContext(InstantFunctionContext.class,0);
		}
		public LocalDateFunctionContext localDateFunction() {
			return getRuleContext(LocalDateFunctionContext.class,0);
		}
		public LocalTimeFunctionContext localTimeFunction() {
			return getRuleContext(LocalTimeFunctionContext.class,0);
		}
		public LocalDateTimeFunctionContext localDateTimeFunction() {
			return getRuleContext(LocalDateTimeFunctionContext.class,0);
		}
		public OffsetDateTimeFunctionContext offsetDateTimeFunction() {
			return getRuleContext(OffsetDateTimeFunctionContext.class,0);
		}
		public CubeContext cube() {
			return getRuleContext(CubeContext.class,0);
		}
		public RollupContext rollup() {
			return getRuleContext(RollupContext.class,0);
		}
		public StandardFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_standardFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterStandardFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitStandardFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitStandardFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final StandardFunctionContext standardFunction() throws RecognitionException {
		StandardFunctionContext _localctx = new StandardFunctionContext(_ctx, getState());
		enterRule(_localctx, 278, RULE_standardFunction);
		try {
			setState(1623);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,169,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1604);
				castFunction();
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1605);
				extractFunction();
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(1606);
				formatFunction();
				}
				break;
			case 4:
				enterOuterAlt(_localctx, 4);
				{
				setState(1607);
				collateFunction();
				}
				break;
			case 5:
				enterOuterAlt(_localctx, 5);
				{
				setState(1608);
				substringFunction();
				}
				break;
			case 6:
				enterOuterAlt(_localctx, 6);
				{
				setState(1609);
				overlayFunction();
				}
				break;
			case 7:
				enterOuterAlt(_localctx, 7);
				{
				setState(1610);
				trimFunction();
				}
				break;
			case 8:
				enterOuterAlt(_localctx, 8);
				{
				setState(1611);
				padFunction();
				}
				break;
			case 9:
				enterOuterAlt(_localctx, 9);
				{
				setState(1612);
				positionFunction();
				}
				break;
			case 10:
				enterOuterAlt(_localctx, 10);
				{
				setState(1613);
				currentDateFunction();
				}
				break;
			case 11:
				enterOuterAlt(_localctx, 11);
				{
				setState(1614);
				currentTimeFunction();
				}
				break;
			case 12:
				enterOuterAlt(_localctx, 12);
				{
				setState(1615);
				currentTimestampFunction();
				}
				break;
			case 13:
				enterOuterAlt(_localctx, 13);
				{
				setState(1616);
				instantFunction();
				}
				break;
			case 14:
				enterOuterAlt(_localctx, 14);
				{
				setState(1617);
				localDateFunction();
				}
				break;
			case 15:
				enterOuterAlt(_localctx, 15);
				{
				setState(1618);
				localTimeFunction();
				}
				break;
			case 16:
				enterOuterAlt(_localctx, 16);
				{
				setState(1619);
				localDateTimeFunction();
				}
				break;
			case 17:
				enterOuterAlt(_localctx, 17);
				{
				setState(1620);
				offsetDateTimeFunction();
				}
				break;
			case 18:
				enterOuterAlt(_localctx, 18);
				{
				setState(1621);
				cube();
				}
				break;
			case 19:
				enterOuterAlt(_localctx, 19);
				{
				setState(1622);
				rollup();
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class CastFunctionContext extends ParserRuleContext {
		public TerminalNode CAST() { return getToken(HqlParser.CAST, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode AS() { return getToken(HqlParser.AS, 0); }
		public CastTargetContext castTarget() {
			return getRuleContext(CastTargetContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public CastFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_castFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCastFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCastFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCastFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CastFunctionContext castFunction() throws RecognitionException {
		CastFunctionContext _localctx = new CastFunctionContext(_ctx, getState());
		enterRule(_localctx, 280, RULE_castFunction);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1625);
			match(CAST);
			setState(1626);
			match(LEFT_PAREN);
			setState(1627);
			expression(0);
			setState(1628);
			match(AS);
			setState(1629);
			castTarget();
			setState(1630);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class CastTargetContext extends ParserRuleContext {
		public CastTargetTypeContext castTargetType() {
			return getRuleContext(CastTargetTypeContext.class,0);
		}
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public List<TerminalNode> INTEGER_LITERAL() { return getTokens(HqlParser.INTEGER_LITERAL); }
		public TerminalNode INTEGER_LITERAL(int i) {
			return getToken(HqlParser.INTEGER_LITERAL, i);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode COMMA() { return getToken(HqlParser.COMMA, 0); }
		public CastTargetContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_castTarget; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCastTarget(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCastTarget(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCastTarget(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CastTargetContext castTarget() throws RecognitionException {
		CastTargetContext _localctx = new CastTargetContext(_ctx, getState());
		enterRule(_localctx, 282, RULE_castTarget);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1632);
			castTargetType();
			setState(1640);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==LEFT_PAREN) {
				{
				setState(1633);
				match(LEFT_PAREN);
				setState(1634);
				match(INTEGER_LITERAL);
				setState(1637);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==COMMA) {
					{
					setState(1635);
					match(COMMA);
					setState(1636);
					match(INTEGER_LITERAL);
					}
				}

				setState(1639);
				match(RIGHT_PAREN);
				}
			}

			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class CastTargetTypeContext extends ParserRuleContext {
		public String fullTargetName;
		public IdentifierContext i;
		public IdentifierContext c;
		public List<IdentifierContext> identifier() {
			return getRuleContexts(IdentifierContext.class);
		}
		public IdentifierContext identifier(int i) {
			return getRuleContext(IdentifierContext.class,i);
		}
		public List<TerminalNode> DOT() { return getTokens(HqlParser.DOT); }
		public TerminalNode DOT(int i) {
			return getToken(HqlParser.DOT, i);
		}
		public CastTargetTypeContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_castTargetType; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCastTargetType(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCastTargetType(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCastTargetType(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CastTargetTypeContext castTargetType() throws RecognitionException {
		CastTargetTypeContext _localctx = new CastTargetTypeContext(_ctx, getState());
		enterRule(_localctx, 284, RULE_castTargetType);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			{
			setState(1642);
			((CastTargetTypeContext)_localctx).i = identifier();
			 ((CastTargetTypeContext)_localctx).fullTargetName =  _localctx.i.getText(); 
			}
			setState(1651);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==DOT) {
				{
				{
				setState(1645);
				match(DOT);
				setState(1646);
				((CastTargetTypeContext)_localctx).c = identifier();
				 _localctx.fullTargetName += ("." + _localctx.c.getText() ); 
				}
				}
				setState(1653);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class SubstringFunctionContext extends ParserRuleContext {
		public TerminalNode SUBSTRING() { return getToken(HqlParser.SUBSTRING, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public SubstringFunctionStartArgumentContext substringFunctionStartArgument() {
			return getRuleContext(SubstringFunctionStartArgumentContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public SubstringFunctionLengthArgumentContext substringFunctionLengthArgument() {
			return getRuleContext(SubstringFunctionLengthArgumentContext.class,0);
		}
		public TerminalNode FROM() { return getToken(HqlParser.FROM, 0); }
		public TerminalNode FOR() { return getToken(HqlParser.FOR, 0); }
		public SubstringFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_substringFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSubstringFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSubstringFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSubstringFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SubstringFunctionContext substringFunction() throws RecognitionException {
		SubstringFunctionContext _localctx = new SubstringFunctionContext(_ctx, getState());
		enterRule(_localctx, 286, RULE_substringFunction);
		int _la;
		try {
			setState(1676);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,175,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1654);
				match(SUBSTRING);
				setState(1655);
				match(LEFT_PAREN);
				setState(1656);
				expression(0);
				setState(1657);
				match(COMMA);
				setState(1658);
				substringFunctionStartArgument();
				setState(1661);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==COMMA) {
					{
					setState(1659);
					match(COMMA);
					setState(1660);
					substringFunctionLengthArgument();
					}
				}

				setState(1663);
				match(RIGHT_PAREN);
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1665);
				match(SUBSTRING);
				setState(1666);
				match(LEFT_PAREN);
				setState(1667);
				expression(0);
				setState(1668);
				match(FROM);
				setState(1669);
				substringFunctionStartArgument();
				setState(1672);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==FOR) {
					{
					setState(1670);
					match(FOR);
					setState(1671);
					substringFunctionLengthArgument();
					}
				}

				setState(1674);
				match(RIGHT_PAREN);
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class SubstringFunctionStartArgumentContext extends ParserRuleContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public SubstringFunctionStartArgumentContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_substringFunctionStartArgument; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSubstringFunctionStartArgument(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSubstringFunctionStartArgument(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSubstringFunctionStartArgument(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SubstringFunctionStartArgumentContext substringFunctionStartArgument() throws RecognitionException {
		SubstringFunctionStartArgumentContext _localctx = new SubstringFunctionStartArgumentContext(_ctx, getState());
		enterRule(_localctx, 288, RULE_substringFunctionStartArgument);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1678);
			expression(0);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class SubstringFunctionLengthArgumentContext extends ParserRuleContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public SubstringFunctionLengthArgumentContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_substringFunctionLengthArgument; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSubstringFunctionLengthArgument(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSubstringFunctionLengthArgument(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSubstringFunctionLengthArgument(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SubstringFunctionLengthArgumentContext substringFunctionLengthArgument() throws RecognitionException {
		SubstringFunctionLengthArgumentContext _localctx = new SubstringFunctionLengthArgumentContext(_ctx, getState());
		enterRule(_localctx, 290, RULE_substringFunctionLengthArgument);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1680);
			expression(0);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class TrimFunctionContext extends ParserRuleContext {
		public TerminalNode TRIM() { return getToken(HqlParser.TRIM, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TrimSpecificationContext trimSpecification() {
			return getRuleContext(TrimSpecificationContext.class,0);
		}
		public TrimCharacterContext trimCharacter() {
			return getRuleContext(TrimCharacterContext.class,0);
		}
		public TerminalNode FROM() { return getToken(HqlParser.FROM, 0); }
		public TrimFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_trimFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterTrimFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitTrimFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitTrimFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final TrimFunctionContext trimFunction() throws RecognitionException {
		TrimFunctionContext _localctx = new TrimFunctionContext(_ctx, getState());
		enterRule(_localctx, 292, RULE_trimFunction);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1682);
			match(TRIM);
			setState(1683);
			match(LEFT_PAREN);
			setState(1685);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,176,_ctx) ) {
			case 1:
				{
				setState(1684);
				trimSpecification();
				}
				break;
			}
			setState(1688);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,177,_ctx) ) {
			case 1:
				{
				setState(1687);
				trimCharacter();
				}
				break;
			}
			setState(1691);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,178,_ctx) ) {
			case 1:
				{
				setState(1690);
				match(FROM);
				}
				break;
			}
			setState(1693);
			expression(0);
			setState(1694);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class TrimSpecificationContext extends ParserRuleContext {
		public TerminalNode LEADING() { return getToken(HqlParser.LEADING, 0); }
		public TerminalNode TRAILING() { return getToken(HqlParser.TRAILING, 0); }
		public TerminalNode BOTH() { return getToken(HqlParser.BOTH, 0); }
		public TrimSpecificationContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_trimSpecification; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterTrimSpecification(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitTrimSpecification(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitTrimSpecification(this);
			else return visitor.visitChildren(this);
		}
	}

	public final TrimSpecificationContext trimSpecification() throws RecognitionException {
		TrimSpecificationContext _localctx = new TrimSpecificationContext(_ctx, getState());
		enterRule(_localctx, 294, RULE_trimSpecification);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1696);
			_la = _input.LA(1);
			if ( !(_la==BOTH || _la==LEADING || _la==TRAILING) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class TrimCharacterContext extends ParserRuleContext {
		public TerminalNode STRING_LITERAL() { return getToken(HqlParser.STRING_LITERAL, 0); }
		public TrimCharacterContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_trimCharacter; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterTrimCharacter(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitTrimCharacter(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitTrimCharacter(this);
			else return visitor.visitChildren(this);
		}
	}

	public final TrimCharacterContext trimCharacter() throws RecognitionException {
		TrimCharacterContext _localctx = new TrimCharacterContext(_ctx, getState());
		enterRule(_localctx, 296, RULE_trimCharacter);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1698);
			match(STRING_LITERAL);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class PadFunctionContext extends ParserRuleContext {
		public TerminalNode PAD() { return getToken(HqlParser.PAD, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode WITH() { return getToken(HqlParser.WITH, 0); }
		public PadLengthContext padLength() {
			return getRuleContext(PadLengthContext.class,0);
		}
		public PadSpecificationContext padSpecification() {
			return getRuleContext(PadSpecificationContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public PadCharacterContext padCharacter() {
			return getRuleContext(PadCharacterContext.class,0);
		}
		public PadFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_padFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterPadFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitPadFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitPadFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final PadFunctionContext padFunction() throws RecognitionException {
		PadFunctionContext _localctx = new PadFunctionContext(_ctx, getState());
		enterRule(_localctx, 298, RULE_padFunction);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1700);
			match(PAD);
			setState(1701);
			match(LEFT_PAREN);
			setState(1702);
			expression(0);
			setState(1703);
			match(WITH);
			setState(1704);
			padLength();
			setState(1705);
			padSpecification();
			setState(1707);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==STRING_LITERAL) {
				{
				setState(1706);
				padCharacter();
				}
			}

			setState(1709);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class PadSpecificationContext extends ParserRuleContext {
		public TerminalNode LEADING() { return getToken(HqlParser.LEADING, 0); }
		public TerminalNode TRAILING() { return getToken(HqlParser.TRAILING, 0); }
		public PadSpecificationContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_padSpecification; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterPadSpecification(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitPadSpecification(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitPadSpecification(this);
			else return visitor.visitChildren(this);
		}
	}

	public final PadSpecificationContext padSpecification() throws RecognitionException {
		PadSpecificationContext _localctx = new PadSpecificationContext(_ctx, getState());
		enterRule(_localctx, 300, RULE_padSpecification);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1711);
			_la = _input.LA(1);
			if ( !(_la==LEADING || _la==TRAILING) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class PadCharacterContext extends ParserRuleContext {
		public TerminalNode STRING_LITERAL() { return getToken(HqlParser.STRING_LITERAL, 0); }
		public PadCharacterContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_padCharacter; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterPadCharacter(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitPadCharacter(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitPadCharacter(this);
			else return visitor.visitChildren(this);
		}
	}

	public final PadCharacterContext padCharacter() throws RecognitionException {
		PadCharacterContext _localctx = new PadCharacterContext(_ctx, getState());
		enterRule(_localctx, 302, RULE_padCharacter);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1713);
			match(STRING_LITERAL);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class PadLengthContext extends ParserRuleContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public PadLengthContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_padLength; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterPadLength(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitPadLength(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitPadLength(this);
			else return visitor.visitChildren(this);
		}
	}

	public final PadLengthContext padLength() throws RecognitionException {
		PadLengthContext _localctx = new PadLengthContext(_ctx, getState());
		enterRule(_localctx, 304, RULE_padLength);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1715);
			expression(0);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class OverlayFunctionContext extends ParserRuleContext {
		public TerminalNode OVERLAY() { return getToken(HqlParser.OVERLAY, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public OverlayFunctionStringArgumentContext overlayFunctionStringArgument() {
			return getRuleContext(OverlayFunctionStringArgumentContext.class,0);
		}
		public TerminalNode PLACING() { return getToken(HqlParser.PLACING, 0); }
		public OverlayFunctionReplacementArgumentContext overlayFunctionReplacementArgument() {
			return getRuleContext(OverlayFunctionReplacementArgumentContext.class,0);
		}
		public TerminalNode FROM() { return getToken(HqlParser.FROM, 0); }
		public OverlayFunctionStartArgumentContext overlayFunctionStartArgument() {
			return getRuleContext(OverlayFunctionStartArgumentContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode FOR() { return getToken(HqlParser.FOR, 0); }
		public OverlayFunctionLengthArgumentContext overlayFunctionLengthArgument() {
			return getRuleContext(OverlayFunctionLengthArgumentContext.class,0);
		}
		public OverlayFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_overlayFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterOverlayFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitOverlayFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitOverlayFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final OverlayFunctionContext overlayFunction() throws RecognitionException {
		OverlayFunctionContext _localctx = new OverlayFunctionContext(_ctx, getState());
		enterRule(_localctx, 306, RULE_overlayFunction);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1717);
			match(OVERLAY);
			setState(1718);
			match(LEFT_PAREN);
			setState(1719);
			overlayFunctionStringArgument();
			setState(1720);
			match(PLACING);
			setState(1721);
			overlayFunctionReplacementArgument();
			setState(1722);
			match(FROM);
			setState(1723);
			overlayFunctionStartArgument();
			setState(1726);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==FOR) {
				{
				setState(1724);
				match(FOR);
				setState(1725);
				overlayFunctionLengthArgument();
				}
			}

			setState(1728);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class OverlayFunctionStringArgumentContext extends ParserRuleContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public OverlayFunctionStringArgumentContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_overlayFunctionStringArgument; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterOverlayFunctionStringArgument(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitOverlayFunctionStringArgument(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitOverlayFunctionStringArgument(this);
			else return visitor.visitChildren(this);
		}
	}

	public final OverlayFunctionStringArgumentContext overlayFunctionStringArgument() throws RecognitionException {
		OverlayFunctionStringArgumentContext _localctx = new OverlayFunctionStringArgumentContext(_ctx, getState());
		enterRule(_localctx, 308, RULE_overlayFunctionStringArgument);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1730);
			expression(0);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class OverlayFunctionReplacementArgumentContext extends ParserRuleContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public OverlayFunctionReplacementArgumentContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_overlayFunctionReplacementArgument; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterOverlayFunctionReplacementArgument(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitOverlayFunctionReplacementArgument(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitOverlayFunctionReplacementArgument(this);
			else return visitor.visitChildren(this);
		}
	}

	public final OverlayFunctionReplacementArgumentContext overlayFunctionReplacementArgument() throws RecognitionException {
		OverlayFunctionReplacementArgumentContext _localctx = new OverlayFunctionReplacementArgumentContext(_ctx, getState());
		enterRule(_localctx, 310, RULE_overlayFunctionReplacementArgument);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1732);
			expression(0);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class OverlayFunctionStartArgumentContext extends ParserRuleContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public OverlayFunctionStartArgumentContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_overlayFunctionStartArgument; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterOverlayFunctionStartArgument(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitOverlayFunctionStartArgument(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitOverlayFunctionStartArgument(this);
			else return visitor.visitChildren(this);
		}
	}

	public final OverlayFunctionStartArgumentContext overlayFunctionStartArgument() throws RecognitionException {
		OverlayFunctionStartArgumentContext _localctx = new OverlayFunctionStartArgumentContext(_ctx, getState());
		enterRule(_localctx, 312, RULE_overlayFunctionStartArgument);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1734);
			expression(0);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class OverlayFunctionLengthArgumentContext extends ParserRuleContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public OverlayFunctionLengthArgumentContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_overlayFunctionLengthArgument; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterOverlayFunctionLengthArgument(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitOverlayFunctionLengthArgument(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitOverlayFunctionLengthArgument(this);
			else return visitor.visitChildren(this);
		}
	}

	public final OverlayFunctionLengthArgumentContext overlayFunctionLengthArgument() throws RecognitionException {
		OverlayFunctionLengthArgumentContext _localctx = new OverlayFunctionLengthArgumentContext(_ctx, getState());
		enterRule(_localctx, 314, RULE_overlayFunctionLengthArgument);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1736);
			expression(0);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class CurrentDateFunctionContext extends ParserRuleContext {
		public TerminalNode CURRENT_DATE() { return getToken(HqlParser.CURRENT_DATE, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode CURRENT() { return getToken(HqlParser.CURRENT, 0); }
		public TerminalNode DATE() { return getToken(HqlParser.DATE, 0); }
		public CurrentDateFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_currentDateFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCurrentDateFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCurrentDateFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCurrentDateFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CurrentDateFunctionContext currentDateFunction() throws RecognitionException {
		CurrentDateFunctionContext _localctx = new CurrentDateFunctionContext(_ctx, getState());
		enterRule(_localctx, 316, RULE_currentDateFunction);
		try {
			setState(1745);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case CURRENT_DATE:
				enterOuterAlt(_localctx, 1);
				{
				setState(1738);
				match(CURRENT_DATE);
				setState(1741);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,181,_ctx) ) {
				case 1:
					{
					setState(1739);
					match(LEFT_PAREN);
					setState(1740);
					match(RIGHT_PAREN);
					}
					break;
				}
				}
				break;
			case CURRENT:
				enterOuterAlt(_localctx, 2);
				{
				setState(1743);
				match(CURRENT);
				setState(1744);
				match(DATE);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class CurrentTimeFunctionContext extends ParserRuleContext {
		public TerminalNode CURRENT_TIME() { return getToken(HqlParser.CURRENT_TIME, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode CURRENT() { return getToken(HqlParser.CURRENT, 0); }
		public TerminalNode TIME() { return getToken(HqlParser.TIME, 0); }
		public CurrentTimeFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_currentTimeFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCurrentTimeFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCurrentTimeFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCurrentTimeFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CurrentTimeFunctionContext currentTimeFunction() throws RecognitionException {
		CurrentTimeFunctionContext _localctx = new CurrentTimeFunctionContext(_ctx, getState());
		enterRule(_localctx, 318, RULE_currentTimeFunction);
		try {
			setState(1754);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case CURRENT_TIME:
				enterOuterAlt(_localctx, 1);
				{
				setState(1747);
				match(CURRENT_TIME);
				setState(1750);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,183,_ctx) ) {
				case 1:
					{
					setState(1748);
					match(LEFT_PAREN);
					setState(1749);
					match(RIGHT_PAREN);
					}
					break;
				}
				}
				break;
			case CURRENT:
				enterOuterAlt(_localctx, 2);
				{
				setState(1752);
				match(CURRENT);
				setState(1753);
				match(TIME);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class CurrentTimestampFunctionContext extends ParserRuleContext {
		public TerminalNode CURRENT_TIMESTAMP() { return getToken(HqlParser.CURRENT_TIMESTAMP, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode CURRENT() { return getToken(HqlParser.CURRENT, 0); }
		public TerminalNode TIMESTAMP() { return getToken(HqlParser.TIMESTAMP, 0); }
		public CurrentTimestampFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_currentTimestampFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCurrentTimestampFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCurrentTimestampFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCurrentTimestampFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CurrentTimestampFunctionContext currentTimestampFunction() throws RecognitionException {
		CurrentTimestampFunctionContext _localctx = new CurrentTimestampFunctionContext(_ctx, getState());
		enterRule(_localctx, 320, RULE_currentTimestampFunction);
		try {
			setState(1763);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case CURRENT_TIMESTAMP:
				enterOuterAlt(_localctx, 1);
				{
				setState(1756);
				match(CURRENT_TIMESTAMP);
				setState(1759);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,185,_ctx) ) {
				case 1:
					{
					setState(1757);
					match(LEFT_PAREN);
					setState(1758);
					match(RIGHT_PAREN);
					}
					break;
				}
				}
				break;
			case CURRENT:
				enterOuterAlt(_localctx, 2);
				{
				setState(1761);
				match(CURRENT);
				setState(1762);
				match(TIMESTAMP);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class InstantFunctionContext extends ParserRuleContext {
		public TerminalNode CURRENT_INSTANT() { return getToken(HqlParser.CURRENT_INSTANT, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode INSTANT() { return getToken(HqlParser.INSTANT, 0); }
		public InstantFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_instantFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterInstantFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitInstantFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitInstantFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final InstantFunctionContext instantFunction() throws RecognitionException {
		InstantFunctionContext _localctx = new InstantFunctionContext(_ctx, getState());
		enterRule(_localctx, 322, RULE_instantFunction);
		try {
			setState(1771);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case CURRENT_INSTANT:
				enterOuterAlt(_localctx, 1);
				{
				setState(1765);
				match(CURRENT_INSTANT);
				setState(1768);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,187,_ctx) ) {
				case 1:
					{
					setState(1766);
					match(LEFT_PAREN);
					setState(1767);
					match(RIGHT_PAREN);
					}
					break;
				}
				}
				break;
			case INSTANT:
				enterOuterAlt(_localctx, 2);
				{
				setState(1770);
				match(INSTANT);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class LocalDateTimeFunctionContext extends ParserRuleContext {
		public TerminalNode LOCAL_DATETIME() { return getToken(HqlParser.LOCAL_DATETIME, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode LOCAL() { return getToken(HqlParser.LOCAL, 0); }
		public TerminalNode DATETIME() { return getToken(HqlParser.DATETIME, 0); }
		public LocalDateTimeFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_localDateTimeFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterLocalDateTimeFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitLocalDateTimeFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitLocalDateTimeFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final LocalDateTimeFunctionContext localDateTimeFunction() throws RecognitionException {
		LocalDateTimeFunctionContext _localctx = new LocalDateTimeFunctionContext(_ctx, getState());
		enterRule(_localctx, 324, RULE_localDateTimeFunction);
		try {
			setState(1780);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case LOCAL_DATETIME:
				enterOuterAlt(_localctx, 1);
				{
				setState(1773);
				match(LOCAL_DATETIME);
				setState(1776);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,189,_ctx) ) {
				case 1:
					{
					setState(1774);
					match(LEFT_PAREN);
					setState(1775);
					match(RIGHT_PAREN);
					}
					break;
				}
				}
				break;
			case LOCAL:
				enterOuterAlt(_localctx, 2);
				{
				setState(1778);
				match(LOCAL);
				setState(1779);
				match(DATETIME);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class OffsetDateTimeFunctionContext extends ParserRuleContext {
		public TerminalNode OFFSET_DATETIME() { return getToken(HqlParser.OFFSET_DATETIME, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode OFFSET() { return getToken(HqlParser.OFFSET, 0); }
		public TerminalNode DATETIME() { return getToken(HqlParser.DATETIME, 0); }
		public OffsetDateTimeFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_offsetDateTimeFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterOffsetDateTimeFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitOffsetDateTimeFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitOffsetDateTimeFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final OffsetDateTimeFunctionContext offsetDateTimeFunction() throws RecognitionException {
		OffsetDateTimeFunctionContext _localctx = new OffsetDateTimeFunctionContext(_ctx, getState());
		enterRule(_localctx, 326, RULE_offsetDateTimeFunction);
		try {
			setState(1789);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case OFFSET_DATETIME:
				enterOuterAlt(_localctx, 1);
				{
				setState(1782);
				match(OFFSET_DATETIME);
				setState(1785);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,191,_ctx) ) {
				case 1:
					{
					setState(1783);
					match(LEFT_PAREN);
					setState(1784);
					match(RIGHT_PAREN);
					}
					break;
				}
				}
				break;
			case OFFSET:
				enterOuterAlt(_localctx, 2);
				{
				setState(1787);
				match(OFFSET);
				setState(1788);
				match(DATETIME);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class LocalDateFunctionContext extends ParserRuleContext {
		public TerminalNode LOCAL_DATE() { return getToken(HqlParser.LOCAL_DATE, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode LOCAL() { return getToken(HqlParser.LOCAL, 0); }
		public TerminalNode DATE() { return getToken(HqlParser.DATE, 0); }
		public LocalDateFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_localDateFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterLocalDateFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitLocalDateFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitLocalDateFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final LocalDateFunctionContext localDateFunction() throws RecognitionException {
		LocalDateFunctionContext _localctx = new LocalDateFunctionContext(_ctx, getState());
		enterRule(_localctx, 328, RULE_localDateFunction);
		try {
			setState(1798);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case LOCAL_DATE:
				enterOuterAlt(_localctx, 1);
				{
				setState(1791);
				match(LOCAL_DATE);
				setState(1794);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,193,_ctx) ) {
				case 1:
					{
					setState(1792);
					match(LEFT_PAREN);
					setState(1793);
					match(RIGHT_PAREN);
					}
					break;
				}
				}
				break;
			case LOCAL:
				enterOuterAlt(_localctx, 2);
				{
				setState(1796);
				match(LOCAL);
				setState(1797);
				match(DATE);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class LocalTimeFunctionContext extends ParserRuleContext {
		public TerminalNode LOCAL_TIME() { return getToken(HqlParser.LOCAL_TIME, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode LOCAL() { return getToken(HqlParser.LOCAL, 0); }
		public TerminalNode TIME() { return getToken(HqlParser.TIME, 0); }
		public LocalTimeFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_localTimeFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterLocalTimeFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitLocalTimeFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitLocalTimeFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final LocalTimeFunctionContext localTimeFunction() throws RecognitionException {
		LocalTimeFunctionContext _localctx = new LocalTimeFunctionContext(_ctx, getState());
		enterRule(_localctx, 330, RULE_localTimeFunction);
		try {
			setState(1807);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case LOCAL_TIME:
				enterOuterAlt(_localctx, 1);
				{
				setState(1800);
				match(LOCAL_TIME);
				setState(1803);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,195,_ctx) ) {
				case 1:
					{
					setState(1801);
					match(LEFT_PAREN);
					setState(1802);
					match(RIGHT_PAREN);
					}
					break;
				}
				}
				break;
			case LOCAL:
				enterOuterAlt(_localctx, 2);
				{
				setState(1805);
				match(LOCAL);
				setState(1806);
				match(TIME);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class FormatFunctionContext extends ParserRuleContext {
		public TerminalNode FORMAT() { return getToken(HqlParser.FORMAT, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode AS() { return getToken(HqlParser.AS, 0); }
		public FormatContext format() {
			return getRuleContext(FormatContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public FormatFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_formatFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterFormatFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitFormatFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitFormatFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final FormatFunctionContext formatFunction() throws RecognitionException {
		FormatFunctionContext _localctx = new FormatFunctionContext(_ctx, getState());
		enterRule(_localctx, 332, RULE_formatFunction);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1809);
			match(FORMAT);
			setState(1810);
			match(LEFT_PAREN);
			setState(1811);
			expression(0);
			setState(1812);
			match(AS);
			setState(1813);
			format();
			setState(1814);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class FormatContext extends ParserRuleContext {
		public TerminalNode STRING_LITERAL() { return getToken(HqlParser.STRING_LITERAL, 0); }
		public FormatContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_format; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterFormat(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitFormat(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitFormat(this);
			else return visitor.visitChildren(this);
		}
	}

	public final FormatContext format() throws RecognitionException {
		FormatContext _localctx = new FormatContext(_ctx, getState());
		enterRule(_localctx, 334, RULE_format);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1816);
			match(STRING_LITERAL);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class ExtractFunctionContext extends ParserRuleContext {
		public TerminalNode EXTRACT() { return getToken(HqlParser.EXTRACT, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public ExtractFieldContext extractField() {
			return getRuleContext(ExtractFieldContext.class,0);
		}
		public TerminalNode FROM() { return getToken(HqlParser.FROM, 0); }
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public DatetimeFieldContext datetimeField() {
			return getRuleContext(DatetimeFieldContext.class,0);
		}
		public ExtractFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_extractFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterExtractFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitExtractFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitExtractFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ExtractFunctionContext extractFunction() throws RecognitionException {
		ExtractFunctionContext _localctx = new ExtractFunctionContext(_ctx, getState());
		enterRule(_localctx, 336, RULE_extractFunction);
		try {
			setState(1830);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case EXTRACT:
				enterOuterAlt(_localctx, 1);
				{
				setState(1818);
				match(EXTRACT);
				setState(1819);
				match(LEFT_PAREN);
				setState(1820);
				extractField();
				setState(1821);
				match(FROM);
				setState(1822);
				expression(0);
				setState(1823);
				match(RIGHT_PAREN);
				}
				break;
			case DAY:
			case HOUR:
			case MINUTE:
			case MONTH:
			case NANOSECOND:
			case QUARTER:
			case SECOND:
			case WEEK:
			case YEAR:
				enterOuterAlt(_localctx, 2);
				{
				setState(1825);
				datetimeField();
				setState(1826);
				match(LEFT_PAREN);
				setState(1827);
				expression(0);
				setState(1828);
				match(RIGHT_PAREN);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class ExtractFieldContext extends ParserRuleContext {
		public DatetimeFieldContext datetimeField() {
			return getRuleContext(DatetimeFieldContext.class,0);
		}
		public DayFieldContext dayField() {
			return getRuleContext(DayFieldContext.class,0);
		}
		public WeekFieldContext weekField() {
			return getRuleContext(WeekFieldContext.class,0);
		}
		public TimeZoneFieldContext timeZoneField() {
			return getRuleContext(TimeZoneFieldContext.class,0);
		}
		public DateOrTimeFieldContext dateOrTimeField() {
			return getRuleContext(DateOrTimeFieldContext.class,0);
		}
		public ExtractFieldContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_extractField; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterExtractField(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitExtractField(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitExtractField(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ExtractFieldContext extractField() throws RecognitionException {
		ExtractFieldContext _localctx = new ExtractFieldContext(_ctx, getState());
		enterRule(_localctx, 338, RULE_extractField);
		try {
			setState(1837);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,198,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1832);
				datetimeField();
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1833);
				dayField();
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(1834);
				weekField();
				}
				break;
			case 4:
				enterOuterAlt(_localctx, 4);
				{
				setState(1835);
				timeZoneField();
				}
				break;
			case 5:
				enterOuterAlt(_localctx, 5);
				{
				setState(1836);
				dateOrTimeField();
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class DatetimeFieldContext extends ParserRuleContext {
		public TerminalNode YEAR() { return getToken(HqlParser.YEAR, 0); }
		public TerminalNode MONTH() { return getToken(HqlParser.MONTH, 0); }
		public TerminalNode DAY() { return getToken(HqlParser.DAY, 0); }
		public TerminalNode WEEK() { return getToken(HqlParser.WEEK, 0); }
		public TerminalNode QUARTER() { return getToken(HqlParser.QUARTER, 0); }
		public TerminalNode HOUR() { return getToken(HqlParser.HOUR, 0); }
		public TerminalNode MINUTE() { return getToken(HqlParser.MINUTE, 0); }
		public TerminalNode SECOND() { return getToken(HqlParser.SECOND, 0); }
		public TerminalNode NANOSECOND() { return getToken(HqlParser.NANOSECOND, 0); }
		public DatetimeFieldContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_datetimeField; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterDatetimeField(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitDatetimeField(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitDatetimeField(this);
			else return visitor.visitChildren(this);
		}
	}

	public final DatetimeFieldContext datetimeField() throws RecognitionException {
		DatetimeFieldContext _localctx = new DatetimeFieldContext(_ctx, getState());
		enterRule(_localctx, 340, RULE_datetimeField);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1839);
			_la = _input.LA(1);
			if ( !(_la==DAY || _la==HOUR || ((((_la - 134)) & ~0x3f) == 0 && ((1L << (_la - 134)) & ((1L << (MINUTE - 134)) | (1L << (MONTH - 134)) | (1L << (NANOSECOND - 134)) | (1L << (QUARTER - 134)) | (1L << (SECOND - 134)) | (1L << (WEEK - 134)) | (1L << (YEAR - 134)))) != 0)) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class DayFieldContext extends ParserRuleContext {
		public TerminalNode DAY() { return getToken(HqlParser.DAY, 0); }
		public TerminalNode OF() { return getToken(HqlParser.OF, 0); }
		public TerminalNode MONTH() { return getToken(HqlParser.MONTH, 0); }
		public TerminalNode WEEK() { return getToken(HqlParser.WEEK, 0); }
		public TerminalNode YEAR() { return getToken(HqlParser.YEAR, 0); }
		public DayFieldContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_dayField; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterDayField(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitDayField(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitDayField(this);
			else return visitor.visitChildren(this);
		}
	}

	public final DayFieldContext dayField() throws RecognitionException {
		DayFieldContext _localctx = new DayFieldContext(_ctx, getState());
		enterRule(_localctx, 342, RULE_dayField);
		try {
			setState(1850);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,199,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1841);
				match(DAY);
				setState(1842);
				match(OF);
				setState(1843);
				match(MONTH);
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1844);
				match(DAY);
				setState(1845);
				match(OF);
				setState(1846);
				match(WEEK);
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(1847);
				match(DAY);
				setState(1848);
				match(OF);
				setState(1849);
				match(YEAR);
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class WeekFieldContext extends ParserRuleContext {
		public TerminalNode WEEK() { return getToken(HqlParser.WEEK, 0); }
		public TerminalNode OF() { return getToken(HqlParser.OF, 0); }
		public TerminalNode MONTH() { return getToken(HqlParser.MONTH, 0); }
		public TerminalNode YEAR() { return getToken(HqlParser.YEAR, 0); }
		public WeekFieldContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_weekField; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterWeekField(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitWeekField(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitWeekField(this);
			else return visitor.visitChildren(this);
		}
	}

	public final WeekFieldContext weekField() throws RecognitionException {
		WeekFieldContext _localctx = new WeekFieldContext(_ctx, getState());
		enterRule(_localctx, 344, RULE_weekField);
		try {
			setState(1858);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,200,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1852);
				match(WEEK);
				setState(1853);
				match(OF);
				setState(1854);
				match(MONTH);
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1855);
				match(WEEK);
				setState(1856);
				match(OF);
				setState(1857);
				match(YEAR);
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class TimeZoneFieldContext extends ParserRuleContext {
		public TerminalNode OFFSET() { return getToken(HqlParser.OFFSET, 0); }
		public TerminalNode HOUR() { return getToken(HqlParser.HOUR, 0); }
		public TerminalNode MINUTE() { return getToken(HqlParser.MINUTE, 0); }
		public TerminalNode TIMEZONE_HOUR() { return getToken(HqlParser.TIMEZONE_HOUR, 0); }
		public TerminalNode TIMEZONE_MINUTE() { return getToken(HqlParser.TIMEZONE_MINUTE, 0); }
		public TimeZoneFieldContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_timeZoneField; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterTimeZoneField(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitTimeZoneField(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitTimeZoneField(this);
			else return visitor.visitChildren(this);
		}
	}

	public final TimeZoneFieldContext timeZoneField() throws RecognitionException {
		TimeZoneFieldContext _localctx = new TimeZoneFieldContext(_ctx, getState());
		enterRule(_localctx, 346, RULE_timeZoneField);
		int _la;
		try {
			setState(1866);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case OFFSET:
				enterOuterAlt(_localctx, 1);
				{
				setState(1860);
				match(OFFSET);
				setState(1862);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==HOUR || _la==MINUTE) {
					{
					setState(1861);
					_la = _input.LA(1);
					if ( !(_la==HOUR || _la==MINUTE) ) {
					_errHandler.recoverInline(this);
					}
					else {
						if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
						_errHandler.reportMatch(this);
						consume();
					}
					}
				}

				}
				break;
			case TIMEZONE_HOUR:
				enterOuterAlt(_localctx, 2);
				{
				setState(1864);
				match(TIMEZONE_HOUR);
				}
				break;
			case TIMEZONE_MINUTE:
				enterOuterAlt(_localctx, 3);
				{
				setState(1865);
				match(TIMEZONE_MINUTE);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class DateOrTimeFieldContext extends ParserRuleContext {
		public TerminalNode DATE() { return getToken(HqlParser.DATE, 0); }
		public TerminalNode TIME() { return getToken(HqlParser.TIME, 0); }
		public DateOrTimeFieldContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_dateOrTimeField; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterDateOrTimeField(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitDateOrTimeField(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitDateOrTimeField(this);
			else return visitor.visitChildren(this);
		}
	}

	public final DateOrTimeFieldContext dateOrTimeField() throws RecognitionException {
		DateOrTimeFieldContext _localctx = new DateOrTimeFieldContext(_ctx, getState());
		enterRule(_localctx, 348, RULE_dateOrTimeField);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1868);
			_la = _input.LA(1);
			if ( !(_la==DATE || _la==TIME) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class PositionFunctionContext extends ParserRuleContext {
		public TerminalNode POSITION() { return getToken(HqlParser.POSITION, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public PositionFunctionPatternArgumentContext positionFunctionPatternArgument() {
			return getRuleContext(PositionFunctionPatternArgumentContext.class,0);
		}
		public TerminalNode IN() { return getToken(HqlParser.IN, 0); }
		public PositionFunctionStringArgumentContext positionFunctionStringArgument() {
			return getRuleContext(PositionFunctionStringArgumentContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public PositionFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_positionFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterPositionFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitPositionFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitPositionFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final PositionFunctionContext positionFunction() throws RecognitionException {
		PositionFunctionContext _localctx = new PositionFunctionContext(_ctx, getState());
		enterRule(_localctx, 350, RULE_positionFunction);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1870);
			match(POSITION);
			setState(1871);
			match(LEFT_PAREN);
			setState(1872);
			positionFunctionPatternArgument();
			setState(1873);
			match(IN);
			setState(1874);
			positionFunctionStringArgument();
			setState(1875);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class PositionFunctionPatternArgumentContext extends ParserRuleContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public PositionFunctionPatternArgumentContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_positionFunctionPatternArgument; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterPositionFunctionPatternArgument(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitPositionFunctionPatternArgument(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitPositionFunctionPatternArgument(this);
			else return visitor.visitChildren(this);
		}
	}

	public final PositionFunctionPatternArgumentContext positionFunctionPatternArgument() throws RecognitionException {
		PositionFunctionPatternArgumentContext _localctx = new PositionFunctionPatternArgumentContext(_ctx, getState());
		enterRule(_localctx, 352, RULE_positionFunctionPatternArgument);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1877);
			expression(0);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class PositionFunctionStringArgumentContext extends ParserRuleContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public PositionFunctionStringArgumentContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_positionFunctionStringArgument; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterPositionFunctionStringArgument(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitPositionFunctionStringArgument(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitPositionFunctionStringArgument(this);
			else return visitor.visitChildren(this);
		}
	}

	public final PositionFunctionStringArgumentContext positionFunctionStringArgument() throws RecognitionException {
		PositionFunctionStringArgumentContext _localctx = new PositionFunctionStringArgumentContext(_ctx, getState());
		enterRule(_localctx, 354, RULE_positionFunctionStringArgument);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1879);
			expression(0);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class CubeContext extends ParserRuleContext {
		public TerminalNode CUBE() { return getToken(HqlParser.CUBE, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public List<ExpressionOrPredicateContext> expressionOrPredicate() {
			return getRuleContexts(ExpressionOrPredicateContext.class);
		}
		public ExpressionOrPredicateContext expressionOrPredicate(int i) {
			return getRuleContext(ExpressionOrPredicateContext.class,i);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public CubeContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_cube; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCube(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCube(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCube(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CubeContext cube() throws RecognitionException {
		CubeContext _localctx = new CubeContext(_ctx, getState());
		enterRule(_localctx, 356, RULE_cube);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1881);
			match(CUBE);
			setState(1882);
			match(LEFT_PAREN);
			setState(1883);
			expressionOrPredicate();
			setState(1888);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==COMMA) {
				{
				{
				setState(1884);
				match(COMMA);
				setState(1885);
				expressionOrPredicate();
				}
				}
				setState(1890);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			setState(1891);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class RollupContext extends ParserRuleContext {
		public TerminalNode ROLLUP() { return getToken(HqlParser.ROLLUP, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public List<ExpressionOrPredicateContext> expressionOrPredicate() {
			return getRuleContexts(ExpressionOrPredicateContext.class);
		}
		public ExpressionOrPredicateContext expressionOrPredicate(int i) {
			return getRuleContext(ExpressionOrPredicateContext.class,i);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public RollupContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_rollup; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterRollup(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitRollup(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitRollup(this);
			else return visitor.visitChildren(this);
		}
	}

	public final RollupContext rollup() throws RecognitionException {
		RollupContext _localctx = new RollupContext(_ctx, getState());
		enterRule(_localctx, 358, RULE_rollup);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1893);
			match(ROLLUP);
			setState(1894);
			match(LEFT_PAREN);
			setState(1895);
			expressionOrPredicate();
			setState(1900);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==COMMA) {
				{
				{
				setState(1896);
				match(COMMA);
				setState(1897);
				expressionOrPredicate();
				}
				}
				setState(1902);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			setState(1903);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class NakedIdentifierContext extends ParserRuleContext {
		public TerminalNode IDENTIFIER() { return getToken(HqlParser.IDENTIFIER, 0); }
		public TerminalNode QUOTED_IDENTIFIER() { return getToken(HqlParser.QUOTED_IDENTIFIER, 0); }
		public TerminalNode ALL() { return getToken(HqlParser.ALL, 0); }
		public TerminalNode AND() { return getToken(HqlParser.AND, 0); }
		public TerminalNode ANY() { return getToken(HqlParser.ANY, 0); }
		public TerminalNode AS() { return getToken(HqlParser.AS, 0); }
		public TerminalNode ASC() { return getToken(HqlParser.ASC, 0); }
		public TerminalNode AVG() { return getToken(HqlParser.AVG, 0); }
		public TerminalNode BETWEEN() { return getToken(HqlParser.BETWEEN, 0); }
		public TerminalNode BOTH() { return getToken(HqlParser.BOTH, 0); }
		public TerminalNode BY() { return getToken(HqlParser.BY, 0); }
		public TerminalNode CASE() { return getToken(HqlParser.CASE, 0); }
		public TerminalNode CAST() { return getToken(HqlParser.CAST, 0); }
		public TerminalNode COLLATE() { return getToken(HqlParser.COLLATE, 0); }
		public TerminalNode COUNT() { return getToken(HqlParser.COUNT, 0); }
		public TerminalNode CROSS() { return getToken(HqlParser.CROSS, 0); }
		public TerminalNode CUBE() { return getToken(HqlParser.CUBE, 0); }
		public TerminalNode CURRENT() { return getToken(HqlParser.CURRENT, 0); }
		public TerminalNode CURRENT_DATE() { return getToken(HqlParser.CURRENT_DATE, 0); }
		public TerminalNode CURRENT_INSTANT() { return getToken(HqlParser.CURRENT_INSTANT, 0); }
		public TerminalNode CURRENT_TIME() { return getToken(HqlParser.CURRENT_TIME, 0); }
		public TerminalNode CURRENT_TIMESTAMP() { return getToken(HqlParser.CURRENT_TIMESTAMP, 0); }
		public TerminalNode DATE() { return getToken(HqlParser.DATE, 0); }
		public TerminalNode DATETIME() { return getToken(HqlParser.DATETIME, 0); }
		public TerminalNode DAY() { return getToken(HqlParser.DAY, 0); }
		public TerminalNode DELETE() { return getToken(HqlParser.DELETE, 0); }
		public TerminalNode DESC() { return getToken(HqlParser.DESC, 0); }
		public TerminalNode DISTINCT() { return getToken(HqlParser.DISTINCT, 0); }
		public TerminalNode ELEMENT() { return getToken(HqlParser.ELEMENT, 0); }
		public TerminalNode ELEMENTS() { return getToken(HqlParser.ELEMENTS, 0); }
		public TerminalNode ELSE() { return getToken(HqlParser.ELSE, 0); }
		public TerminalNode EMPTY() { return getToken(HqlParser.EMPTY, 0); }
		public TerminalNode END() { return getToken(HqlParser.END, 0); }
		public TerminalNode ENTRY() { return getToken(HqlParser.ENTRY, 0); }
		public TerminalNode ERROR() { return getToken(HqlParser.ERROR, 0); }
		public TerminalNode ESCAPE() { return getToken(HqlParser.ESCAPE, 0); }
		public TerminalNode EVERY() { return getToken(HqlParser.EVERY, 0); }
		public TerminalNode EXCEPT() { return getToken(HqlParser.EXCEPT, 0); }
		public TerminalNode EXCLUDE() { return getToken(HqlParser.EXCLUDE, 0); }
		public TerminalNode EXISTS() { return getToken(HqlParser.EXISTS, 0); }
		public TerminalNode EXTRACT() { return getToken(HqlParser.EXTRACT, 0); }
		public TerminalNode FETCH() { return getToken(HqlParser.FETCH, 0); }
		public TerminalNode FILTER() { return getToken(HqlParser.FILTER, 0); }
		public TerminalNode FIRST() { return getToken(HqlParser.FIRST, 0); }
		public TerminalNode FOLLOWING() { return getToken(HqlParser.FOLLOWING, 0); }
		public TerminalNode FOR() { return getToken(HqlParser.FOR, 0); }
		public TerminalNode FORMAT() { return getToken(HqlParser.FORMAT, 0); }
		public TerminalNode FROM() { return getToken(HqlParser.FROM, 0); }
		public TerminalNode FUNCTION() { return getToken(HqlParser.FUNCTION, 0); }
		public TerminalNode GROUP() { return getToken(HqlParser.GROUP, 0); }
		public TerminalNode GROUPS() { return getToken(HqlParser.GROUPS, 0); }
		public TerminalNode HAVING() { return getToken(HqlParser.HAVING, 0); }
		public TerminalNode HOUR() { return getToken(HqlParser.HOUR, 0); }
		public TerminalNode ID() { return getToken(HqlParser.ID, 0); }
		public TerminalNode IGNORE() { return getToken(HqlParser.IGNORE, 0); }
		public TerminalNode ILIKE() { return getToken(HqlParser.ILIKE, 0); }
		public TerminalNode IN() { return getToken(HqlParser.IN, 0); }
		public TerminalNode INDEX() { return getToken(HqlParser.INDEX, 0); }
		public TerminalNode INDICES() { return getToken(HqlParser.INDICES, 0); }
		public TerminalNode INSERT() { return getToken(HqlParser.INSERT, 0); }
		public TerminalNode INSTANT() { return getToken(HqlParser.INSTANT, 0); }
		public TerminalNode INTERSECT() { return getToken(HqlParser.INTERSECT, 0); }
		public TerminalNode INTO() { return getToken(HqlParser.INTO, 0); }
		public TerminalNode IS() { return getToken(HqlParser.IS, 0); }
		public TerminalNode JOIN() { return getToken(HqlParser.JOIN, 0); }
		public TerminalNode KEY() { return getToken(HqlParser.KEY, 0); }
		public TerminalNode LAST() { return getToken(HqlParser.LAST, 0); }
		public TerminalNode LEADING() { return getToken(HqlParser.LEADING, 0); }
		public TerminalNode LIKE() { return getToken(HqlParser.LIKE, 0); }
		public TerminalNode LIMIT() { return getToken(HqlParser.LIMIT, 0); }
		public TerminalNode LIST() { return getToken(HqlParser.LIST, 0); }
		public TerminalNode LISTAGG() { return getToken(HqlParser.LISTAGG, 0); }
		public TerminalNode LOCAL() { return getToken(HqlParser.LOCAL, 0); }
		public TerminalNode LOCAL_DATE() { return getToken(HqlParser.LOCAL_DATE, 0); }
		public TerminalNode LOCAL_DATETIME() { return getToken(HqlParser.LOCAL_DATETIME, 0); }
		public TerminalNode LOCAL_TIME() { return getToken(HqlParser.LOCAL_TIME, 0); }
		public TerminalNode MAP() { return getToken(HqlParser.MAP, 0); }
		public TerminalNode MAX() { return getToken(HqlParser.MAX, 0); }
		public TerminalNode MAXELEMENT() { return getToken(HqlParser.MAXELEMENT, 0); }
		public TerminalNode MAXINDEX() { return getToken(HqlParser.MAXINDEX, 0); }
		public TerminalNode MEMBER() { return getToken(HqlParser.MEMBER, 0); }
		public TerminalNode MICROSECOND() { return getToken(HqlParser.MICROSECOND, 0); }
		public TerminalNode MILLISECOND() { return getToken(HqlParser.MILLISECOND, 0); }
		public TerminalNode MIN() { return getToken(HqlParser.MIN, 0); }
		public TerminalNode MINELEMENT() { return getToken(HqlParser.MINELEMENT, 0); }
		public TerminalNode MININDEX() { return getToken(HqlParser.MININDEX, 0); }
		public TerminalNode MINUTE() { return getToken(HqlParser.MINUTE, 0); }
		public TerminalNode MONTH() { return getToken(HqlParser.MONTH, 0); }
		public TerminalNode NANOSECOND() { return getToken(HqlParser.NANOSECOND, 0); }
		public TerminalNode NATURALID() { return getToken(HqlParser.NATURALID, 0); }
		public TerminalNode NEW() { return getToken(HqlParser.NEW, 0); }
		public TerminalNode NEXT() { return getToken(HqlParser.NEXT, 0); }
		public TerminalNode NO() { return getToken(HqlParser.NO, 0); }
		public TerminalNode NOT() { return getToken(HqlParser.NOT, 0); }
		public TerminalNode NULLS() { return getToken(HqlParser.NULLS, 0); }
		public TerminalNode OBJECT() { return getToken(HqlParser.OBJECT, 0); }
		public TerminalNode OF() { return getToken(HqlParser.OF, 0); }
		public TerminalNode OFFSET() { return getToken(HqlParser.OFFSET, 0); }
		public TerminalNode OFFSET_DATETIME() { return getToken(HqlParser.OFFSET_DATETIME, 0); }
		public TerminalNode ON() { return getToken(HqlParser.ON, 0); }
		public TerminalNode ONLY() { return getToken(HqlParser.ONLY, 0); }
		public TerminalNode OR() { return getToken(HqlParser.OR, 0); }
		public TerminalNode ORDER() { return getToken(HqlParser.ORDER, 0); }
		public TerminalNode OTHERS() { return getToken(HqlParser.OTHERS, 0); }
		public TerminalNode OVER() { return getToken(HqlParser.OVER, 0); }
		public TerminalNode OVERFLOW() { return getToken(HqlParser.OVERFLOW, 0); }
		public TerminalNode OVERLAY() { return getToken(HqlParser.OVERLAY, 0); }
		public TerminalNode PAD() { return getToken(HqlParser.PAD, 0); }
		public TerminalNode PARTITION() { return getToken(HqlParser.PARTITION, 0); }
		public TerminalNode PERCENT() { return getToken(HqlParser.PERCENT, 0); }
		public TerminalNode PLACING() { return getToken(HqlParser.PLACING, 0); }
		public TerminalNode POSITION() { return getToken(HqlParser.POSITION, 0); }
		public TerminalNode PRECEDING() { return getToken(HqlParser.PRECEDING, 0); }
		public TerminalNode QUARTER() { return getToken(HqlParser.QUARTER, 0); }
		public TerminalNode RANGE() { return getToken(HqlParser.RANGE, 0); }
		public TerminalNode RESPECT() { return getToken(HqlParser.RESPECT, 0); }
		public TerminalNode ROLLUP() { return getToken(HqlParser.ROLLUP, 0); }
		public TerminalNode ROW() { return getToken(HqlParser.ROW, 0); }
		public TerminalNode ROWS() { return getToken(HqlParser.ROWS, 0); }
		public TerminalNode SECOND() { return getToken(HqlParser.SECOND, 0); }
		public TerminalNode SELECT() { return getToken(HqlParser.SELECT, 0); }
		public TerminalNode SET() { return getToken(HqlParser.SET, 0); }
		public TerminalNode SIZE() { return getToken(HqlParser.SIZE, 0); }
		public TerminalNode SOME() { return getToken(HqlParser.SOME, 0); }
		public TerminalNode SUBSTRING() { return getToken(HqlParser.SUBSTRING, 0); }
		public TerminalNode SUM() { return getToken(HqlParser.SUM, 0); }
		public TerminalNode THEN() { return getToken(HqlParser.THEN, 0); }
		public TerminalNode TIES() { return getToken(HqlParser.TIES, 0); }
		public TerminalNode TIME() { return getToken(HqlParser.TIME, 0); }
		public TerminalNode TIMESTAMP() { return getToken(HqlParser.TIMESTAMP, 0); }
		public TerminalNode TIMEZONE_HOUR() { return getToken(HqlParser.TIMEZONE_HOUR, 0); }
		public TerminalNode TIMEZONE_MINUTE() { return getToken(HqlParser.TIMEZONE_MINUTE, 0); }
		public TerminalNode TRAILING() { return getToken(HqlParser.TRAILING, 0); }
		public TerminalNode TREAT() { return getToken(HqlParser.TREAT, 0); }
		public TerminalNode TRIM() { return getToken(HqlParser.TRIM, 0); }
		public TerminalNode TRUNCATE() { return getToken(HqlParser.TRUNCATE, 0); }
		public TerminalNode TYPE() { return getToken(HqlParser.TYPE, 0); }
		public TerminalNode UNBOUNDED() { return getToken(HqlParser.UNBOUNDED, 0); }
		public TerminalNode UNION() { return getToken(HqlParser.UNION, 0); }
		public TerminalNode UPDATE() { return getToken(HqlParser.UPDATE, 0); }
		public TerminalNode VALUE() { return getToken(HqlParser.VALUE, 0); }
		public TerminalNode VALUES() { return getToken(HqlParser.VALUES, 0); }
		public TerminalNode VERSION() { return getToken(HqlParser.VERSION, 0); }
		public TerminalNode VERSIONED() { return getToken(HqlParser.VERSIONED, 0); }
		public TerminalNode WEEK() { return getToken(HqlParser.WEEK, 0); }
		public TerminalNode WHEN() { return getToken(HqlParser.WHEN, 0); }
		public TerminalNode WHERE() { return getToken(HqlParser.WHERE, 0); }
		public TerminalNode WITH() { return getToken(HqlParser.WITH, 0); }
		public TerminalNode WITHIN() { return getToken(HqlParser.WITHIN, 0); }
		public TerminalNode WITHOUT() { return getToken(HqlParser.WITHOUT, 0); }
		public TerminalNode YEAR() { return getToken(HqlParser.YEAR, 0); }
		public NakedIdentifierContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_nakedIdentifier; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterNakedIdentifier(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitNakedIdentifier(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitNakedIdentifier(this);
			else return visitor.visitChildren(this);
		}
	}

	public final NakedIdentifierContext nakedIdentifier() throws RecognitionException {
		NakedIdentifierContext _localctx = new NakedIdentifierContext(_ctx, getState());
		enterRule(_localctx, 360, RULE_nakedIdentifier);
		int _la;
		try {
			setState(1909);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case IDENTIFIER:
				enterOuterAlt(_localctx, 1);
				{
				setState(1905);
				match(IDENTIFIER);
				}
				break;
			case QUOTED_IDENTIFIER:
				enterOuterAlt(_localctx, 2);
				{
				setState(1906);
				match(QUOTED_IDENTIFIER);
				}
				break;
			case ID:
			case VERSION:
			case VERSIONED:
			case NATURALID:
			case ALL:
			case AND:
			case ANY:
			case AS:
			case ASC:
			case AVG:
			case BETWEEN:
			case BOTH:
			case BY:
			case CASE:
			case CAST:
			case COLLATE:
			case COUNT:
			case CROSS:
			case CUBE:
			case CURRENT:
			case CURRENT_DATE:
			case CURRENT_INSTANT:
			case CURRENT_TIME:
			case CURRENT_TIMESTAMP:
			case DATE:
			case DATETIME:
			case DAY:
			case DELETE:
			case DESC:
			case DISTINCT:
			case ELEMENT:
			case ELEMENTS:
			case ELSE:
			case EMPTY:
			case END:
			case ENTRY:
			case ERROR:
			case ESCAPE:
			case EVERY:
			case EXCEPT:
			case EXCLUDE:
			case EXISTS:
			case EXTRACT:
			case FETCH:
			case FILTER:
			case FIRST:
			case FOLLOWING:
			case FOR:
			case FORMAT:
			case FROM:
			case FUNCTION:
			case GROUP:
			case GROUPS:
			case HAVING:
			case HOUR:
			case IGNORE:
			case ILIKE:
			case IN:
			case INDEX:
			case INDICES:
			case INSERT:
			case INSTANT:
			case INTERSECT:
			case INTO:
			case IS:
			case JOIN:
			case KEY:
			case LAST:
			case LEADING:
			case LIKE:
			case LIMIT:
			case LIST:
			case LISTAGG:
			case LOCAL:
			case LOCAL_DATE:
			case LOCAL_DATETIME:
			case LOCAL_TIME:
			case MAP:
			case MAX:
			case MAXELEMENT:
			case MAXINDEX:
			case MEMBER:
			case MICROSECOND:
			case MILLISECOND:
			case MIN:
			case MINELEMENT:
			case MININDEX:
			case MINUTE:
			case MONTH:
			case NANOSECOND:
			case NEW:
			case NEXT:
			case NO:
			case NOT:
			case NULLS:
			case OBJECT:
			case OF:
			case OFFSET:
			case OFFSET_DATETIME:
			case ON:
			case ONLY:
			case OR:
			case ORDER:
			case OTHERS:
			case OVER:
			case OVERFLOW:
			case OVERLAY:
			case PAD:
			case PARTITION:
			case PERCENT:
			case PLACING:
			case POSITION:
			case PRECEDING:
			case QUARTER:
			case RANGE:
			case RESPECT:
			case ROLLUP:
			case ROW:
			case ROWS:
			case SECOND:
			case SELECT:
			case SET:
			case SIZE:
			case SOME:
			case SUBSTRING:
			case SUM:
			case THEN:
			case TIES:
			case TIME:
			case TIMESTAMP:
			case TIMEZONE_HOUR:
			case TIMEZONE_MINUTE:
			case TRAILING:
			case TREAT:
			case TRIM:
			case TRUNCATE:
			case TYPE:
			case UNBOUNDED:
			case UNION:
			case UPDATE:
			case VALUE:
			case VALUES:
			case WEEK:
			case WHEN:
			case WHERE:
			case WITH:
			case WITHIN:
			case WITHOUT:
			case YEAR:
				enterOuterAlt(_localctx, 3);
				{
				setState(1907);
				_la = _input.LA(1);
				if ( !(((((_la - 42)) & ~0x3f) == 0 && ((1L << (_la - 42)) & ((1L << (ID - 42)) | (1L << (VERSION - 42)) | (1L << (VERSIONED - 42)) | (1L << (NATURALID - 42)) | (1L << (ALL - 42)) | (1L << (AND - 42)) | (1L << (ANY - 42)) | (1L << (AS - 42)) | (1L << (ASC - 42)) | (1L << (AVG - 42)) | (1L << (BETWEEN - 42)) | (1L << (BOTH - 42)) | (1L << (BY - 42)) | (1L << (CASE - 42)) | (1L << (CAST - 42)) | (1L << (COLLATE - 42)) | (1L << (COUNT - 42)) | (1L << (CROSS - 42)) | (1L << (CUBE - 42)) | (1L << (CURRENT - 42)) | (1L << (CURRENT_DATE - 42)) | (1L << (CURRENT_INSTANT - 42)) | (1L << (CURRENT_TIME - 42)) | (1L << (CURRENT_TIMESTAMP - 42)) | (1L << (DATE - 42)) | (1L << (DATETIME - 42)) | (1L << (DAY - 42)) | (1L << (DELETE - 42)) | (1L << (DESC - 42)) | (1L << (DISTINCT - 42)) | (1L << (ELEMENT - 42)) | (1L << (ELEMENTS - 42)) | (1L << (ELSE - 42)) | (1L << (EMPTY - 42)) | (1L << (END - 42)) | (1L << (ENTRY - 42)) | (1L << (ERROR - 42)) | (1L << (ESCAPE - 42)) | (1L << (EVERY - 42)) | (1L << (EXCEPT - 42)) | (1L << (EXCLUDE - 42)) | (1L << (EXISTS - 42)) | (1L << (EXTRACT - 42)) | (1L << (FETCH - 42)) | (1L << (FILTER - 42)) | (1L << (FIRST - 42)) | (1L << (FOLLOWING - 42)) | (1L << (FOR - 42)) | (1L << (FORMAT - 42)) | (1L << (FROM - 42)) | (1L << (FUNCTION - 42)) | (1L << (GROUP - 42)) | (1L << (GROUPS - 42)) | (1L << (HAVING - 42)) | (1L << (HOUR - 42)) | (1L << (IGNORE - 42)) | (1L << (ILIKE - 42)) | (1L << (IN - 42)) | (1L << (INDEX - 42)) | (1L << (INDICES - 42)) | (1L << (INSERT - 42)))) != 0) || ((((_la - 106)) & ~0x3f) == 0 && ((1L << (_la - 106)) & ((1L << (INSTANT - 106)) | (1L << (INTERSECT - 106)) | (1L << (INTO - 106)) | (1L << (IS - 106)) | (1L << (JOIN - 106)) | (1L << (KEY - 106)) | (1L << (LAST - 106)) | (1L << (LEADING - 106)) | (1L << (LIKE - 106)) | (1L << (LIMIT - 106)) | (1L << (LIST - 106)) | (1L << (LISTAGG - 106)) | (1L << (LOCAL - 106)) | (1L << (LOCAL_DATE - 106)) | (1L << (LOCAL_DATETIME - 106)) | (1L << (LOCAL_TIME - 106)) | (1L << (MAP - 106)) | (1L << (MAX - 106)) | (1L << (MAXELEMENT - 106)) | (1L << (MAXINDEX - 106)) | (1L << (MEMBER - 106)) | (1L << (MICROSECOND - 106)) | (1L << (MILLISECOND - 106)) | (1L << (MIN - 106)) | (1L << (MINELEMENT - 106)) | (1L << (MININDEX - 106)) | (1L << (MINUTE - 106)) | (1L << (MONTH - 106)) | (1L << (NANOSECOND - 106)) | (1L << (NEW - 106)) | (1L << (NEXT - 106)) | (1L << (NO - 106)) | (1L << (NOT - 106)) | (1L << (NULLS - 106)) | (1L << (OBJECT - 106)) | (1L << (OF - 106)) | (1L << (OFFSET - 106)) | (1L << (OFFSET_DATETIME - 106)) | (1L << (ON - 106)) | (1L << (ONLY - 106)) | (1L << (OR - 106)) | (1L << (ORDER - 106)) | (1L << (OTHERS - 106)) | (1L << (OVER - 106)) | (1L << (OVERFLOW - 106)) | (1L << (OVERLAY - 106)) | (1L << (PAD - 106)) | (1L << (PARTITION - 106)) | (1L << (PERCENT - 106)) | (1L << (PLACING - 106)) | (1L << (POSITION - 106)) | (1L << (PRECEDING - 106)) | (1L << (QUARTER - 106)) | (1L << (RANGE - 106)) | (1L << (RESPECT - 106)) | (1L << (ROLLUP - 106)) | (1L << (ROW - 106)) | (1L << (ROWS - 106)) | (1L << (SECOND - 106)) | (1L << (SELECT - 106)))) != 0) || ((((_la - 170)) & ~0x3f) == 0 && ((1L << (_la - 170)) & ((1L << (SET - 170)) | (1L << (SIZE - 170)) | (1L << (SOME - 170)) | (1L << (SUBSTRING - 170)) | (1L << (SUM - 170)) | (1L << (THEN - 170)) | (1L << (TIES - 170)) | (1L << (TIME - 170)) | (1L << (TIMESTAMP - 170)) | (1L << (TIMEZONE_HOUR - 170)) | (1L << (TIMEZONE_MINUTE - 170)) | (1L << (TRAILING - 170)) | (1L << (TREAT - 170)) | (1L << (TRIM - 170)) | (1L << (TRUNCATE - 170)) | (1L << (TYPE - 170)) | (1L << (UNBOUNDED - 170)) | (1L << (UNION - 170)) | (1L << (UPDATE - 170)) | (1L << (VALUE - 170)) | (1L << (VALUES - 170)) | (1L << (WEEK - 170)) | (1L << (WHEN - 170)) | (1L << (WHERE - 170)) | (1L << (WITH - 170)) | (1L << (WITHIN - 170)) | (1L << (WITHOUT - 170)) | (1L << (YEAR - 170)))) != 0)) ) {
				_errHandler.recoverInline(this);
				}
				else {
					if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
					_errHandler.reportMatch(this);
					consume();
				}

						logUseOfReservedWordAsIdentifier( getCurrentToken() );
					
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class IdentifierContext extends ParserRuleContext {
		public NakedIdentifierContext nakedIdentifier() {
			return getRuleContext(NakedIdentifierContext.class,0);
		}
		public TerminalNode FULL() { return getToken(HqlParser.FULL, 0); }
		public TerminalNode INNER() { return getToken(HqlParser.INNER, 0); }
		public TerminalNode LEFT() { return getToken(HqlParser.LEFT, 0); }
		public TerminalNode OUTER() { return getToken(HqlParser.OUTER, 0); }
		public TerminalNode RIGHT() { return getToken(HqlParser.RIGHT, 0); }
		public IdentifierContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_identifier; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterIdentifier(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitIdentifier(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitIdentifier(this);
			else return visitor.visitChildren(this);
		}
	}

	public final IdentifierContext identifier() throws RecognitionException {
		IdentifierContext _localctx = new IdentifierContext(_ctx, getState());
		enterRule(_localctx, 362, RULE_identifier);
		int _la;
		try {
			setState(1914);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case ID:
			case VERSION:
			case VERSIONED:
			case NATURALID:
			case ALL:
			case AND:
			case ANY:
			case AS:
			case ASC:
			case AVG:
			case BETWEEN:
			case BOTH:
			case BY:
			case CASE:
			case CAST:
			case COLLATE:
			case COUNT:
			case CROSS:
			case CUBE:
			case CURRENT:
			case CURRENT_DATE:
			case CURRENT_INSTANT:
			case CURRENT_TIME:
			case CURRENT_TIMESTAMP:
			case DATE:
			case DATETIME:
			case DAY:
			case DELETE:
			case DESC:
			case DISTINCT:
			case ELEMENT:
			case ELEMENTS:
			case ELSE:
			case EMPTY:
			case END:
			case ENTRY:
			case ERROR:
			case ESCAPE:
			case EVERY:
			case EXCEPT:
			case EXCLUDE:
			case EXISTS:
			case EXTRACT:
			case FETCH:
			case FILTER:
			case FIRST:
			case FOLLOWING:
			case FOR:
			case FORMAT:
			case FROM:
			case FUNCTION:
			case GROUP:
			case GROUPS:
			case HAVING:
			case HOUR:
			case IGNORE:
			case ILIKE:
			case IN:
			case INDEX:
			case INDICES:
			case INSERT:
			case INSTANT:
			case INTERSECT:
			case INTO:
			case IS:
			case JOIN:
			case KEY:
			case LAST:
			case LEADING:
			case LIKE:
			case LIMIT:
			case LIST:
			case LISTAGG:
			case LOCAL:
			case LOCAL_DATE:
			case LOCAL_DATETIME:
			case LOCAL_TIME:
			case MAP:
			case MAX:
			case MAXELEMENT:
			case MAXINDEX:
			case MEMBER:
			case MICROSECOND:
			case MILLISECOND:
			case MIN:
			case MINELEMENT:
			case MININDEX:
			case MINUTE:
			case MONTH:
			case NANOSECOND:
			case NEW:
			case NEXT:
			case NO:
			case NOT:
			case NULLS:
			case OBJECT:
			case OF:
			case OFFSET:
			case OFFSET_DATETIME:
			case ON:
			case ONLY:
			case OR:
			case ORDER:
			case OTHERS:
			case OVER:
			case OVERFLOW:
			case OVERLAY:
			case PAD:
			case PARTITION:
			case PERCENT:
			case PLACING:
			case POSITION:
			case PRECEDING:
			case QUARTER:
			case RANGE:
			case RESPECT:
			case ROLLUP:
			case ROW:
			case ROWS:
			case SECOND:
			case SELECT:
			case SET:
			case SIZE:
			case SOME:
			case SUBSTRING:
			case SUM:
			case THEN:
			case TIES:
			case TIME:
			case TIMESTAMP:
			case TIMEZONE_HOUR:
			case TIMEZONE_MINUTE:
			case TRAILING:
			case TREAT:
			case TRIM:
			case TRUNCATE:
			case TYPE:
			case UNBOUNDED:
			case UNION:
			case UPDATE:
			case VALUE:
			case VALUES:
			case WEEK:
			case WHEN:
			case WHERE:
			case WITH:
			case WITHIN:
			case WITHOUT:
			case YEAR:
			case IDENTIFIER:
			case QUOTED_IDENTIFIER:
				enterOuterAlt(_localctx, 1);
				{
				setState(1911);
				nakedIdentifier();
				}
				break;
			case FULL:
			case INNER:
			case LEFT:
			case OUTER:
			case RIGHT:
				enterOuterAlt(_localctx, 2);
				{
				setState(1912);
				_la = _input.LA(1);
				if ( !(((((_la - 93)) & ~0x3f) == 0 && ((1L << (_la - 93)) & ((1L << (FULL - 93)) | (1L << (INNER - 93)) | (1L << (LEFT - 93)) | (1L << (OUTER - 93)))) != 0) || _la==RIGHT) ) {
				_errHandler.recoverInline(this);
				}
				else {
					if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
					_errHandler.reportMatch(this);
					consume();
				}

						logUseOfReservedWordAsIdentifier( getCurrentToken() );
					
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public boolean sempred(RuleContext _localctx, int ruleIndex, int predIndex) {
		switch (ruleIndex) {
		case 66:
			return predicate_sempred((PredicateContext)_localctx, predIndex);
		case 70:
			return expression_sempred((ExpressionContext)_localctx, predIndex);
		}
		return true;
	}
	private boolean predicate_sempred(PredicateContext _localctx, int predIndex) {
		switch (predIndex) {
		case 0:
			return precpred(_ctx, 3);
		case 1:
			return precpred(_ctx, 2);
		}
		return true;
	}
	private boolean expression_sempred(ExpressionContext _localctx, int predIndex) {
		switch (predIndex) {
		case 2:
			return precpred(_ctx, 3);
		case 3:
			return precpred(_ctx, 2);
		case 4:
			return precpred(_ctx, 1);
		case 5:
			return precpred(_ctx, 5);
		case 6:
			return precpred(_ctx, 4);
		}
		return true;
	}

	public static final String _serializedATN =
		"\u0004\u0001\u00ca\u077d\u0002\u0000\u0007\u0000\u0002\u0001\u0007\u0001"+
		"\u0002\u0002\u0007\u0002\u0002\u0003\u0007\u0003\u0002\u0004\u0007\u0004"+
		"\u0002\u0005\u0007\u0005\u0002\u0006\u0007\u0006\u0002\u0007\u0007\u0007"+
		"\u0002\b\u0007\b\u0002\t\u0007\t\u0002\n\u0007\n\u0002\u000b\u0007\u000b"+
		"\u0002\f\u0007\f\u0002\r\u0007\r\u0002\u000e\u0007\u000e\u0002\u000f\u0007"+
		"\u000f\u0002\u0010\u0007\u0010\u0002\u0011\u0007\u0011\u0002\u0012\u0007"+
		"\u0012\u0002\u0013\u0007\u0013\u0002\u0014\u0007\u0014\u0002\u0015\u0007"+
		"\u0015\u0002\u0016\u0007\u0016\u0002\u0017\u0007\u0017\u0002\u0018\u0007"+
		"\u0018\u0002\u0019\u0007\u0019\u0002\u001a\u0007\u001a\u0002\u001b\u0007"+
		"\u001b\u0002\u001c\u0007\u001c\u0002\u001d\u0007\u001d\u0002\u001e\u0007"+
		"\u001e\u0002\u001f\u0007\u001f\u0002 \u0007 \u0002!\u0007!\u0002\"\u0007"+
		"\"\u0002#\u0007#\u0002$\u0007$\u0002%\u0007%\u0002&\u0007&\u0002\'\u0007"+
		"\'\u0002(\u0007(\u0002)\u0007)\u0002*\u0007*\u0002+\u0007+\u0002,\u0007"+
		",\u0002-\u0007-\u0002.\u0007.\u0002/\u0007/\u00020\u00070\u00021\u0007"+
		"1\u00022\u00072\u00023\u00073\u00024\u00074\u00025\u00075\u00026\u0007"+
		"6\u00027\u00077\u00028\u00078\u00029\u00079\u0002:\u0007:\u0002;\u0007"+
		";\u0002<\u0007<\u0002=\u0007=\u0002>\u0007>\u0002?\u0007?\u0002@\u0007"+
		"@\u0002A\u0007A\u0002B\u0007B\u0002C\u0007C\u0002D\u0007D\u0002E\u0007"+
		"E\u0002F\u0007F\u0002G\u0007G\u0002H\u0007H\u0002I\u0007I\u0002J\u0007"+
		"J\u0002K\u0007K\u0002L\u0007L\u0002M\u0007M\u0002N\u0007N\u0002O\u0007"+
		"O\u0002P\u0007P\u0002Q\u0007Q\u0002R\u0007R\u0002S\u0007S\u0002T\u0007"+
		"T\u0002U\u0007U\u0002V\u0007V\u0002W\u0007W\u0002X\u0007X\u0002Y\u0007"+
		"Y\u0002Z\u0007Z\u0002[\u0007[\u0002\\\u0007\\\u0002]\u0007]\u0002^\u0007"+
		"^\u0002_\u0007_\u0002`\u0007`\u0002a\u0007a\u0002b\u0007b\u0002c\u0007"+
		"c\u0002d\u0007d\u0002e\u0007e\u0002f\u0007f\u0002g\u0007g\u0002h\u0007"+
		"h\u0002i\u0007i\u0002j\u0007j\u0002k\u0007k\u0002l\u0007l\u0002m\u0007"+
		"m\u0002n\u0007n\u0002o\u0007o\u0002p\u0007p\u0002q\u0007q\u0002r\u0007"+
		"r\u0002s\u0007s\u0002t\u0007t\u0002u\u0007u\u0002v\u0007v\u0002w\u0007"+
		"w\u0002x\u0007x\u0002y\u0007y\u0002z\u0007z\u0002{\u0007{\u0002|\u0007"+
		"|\u0002}\u0007}\u0002~\u0007~\u0002\u007f\u0007\u007f\u0002\u0080\u0007"+
		"\u0080\u0002\u0081\u0007\u0081\u0002\u0082\u0007\u0082\u0002\u0083\u0007"+
		"\u0083\u0002\u0084\u0007\u0084\u0002\u0085\u0007\u0085\u0002\u0086\u0007"+
		"\u0086\u0002\u0087\u0007\u0087\u0002\u0088\u0007\u0088\u0002\u0089\u0007"+
		"\u0089\u0002\u008a\u0007\u008a\u0002\u008b\u0007\u008b\u0002\u008c\u0007"+
		"\u008c\u0002\u008d\u0007\u008d\u0002\u008e\u0007\u008e\u0002\u008f\u0007"+
		"\u008f\u0002\u0090\u0007\u0090\u0002\u0091\u0007\u0091\u0002\u0092\u0007"+
		"\u0092\u0002\u0093\u0007\u0093\u0002\u0094\u0007\u0094\u0002\u0095\u0007"+
		"\u0095\u0002\u0096\u0007\u0096\u0002\u0097\u0007\u0097\u0002\u0098\u0007"+
		"\u0098\u0002\u0099\u0007\u0099\u0002\u009a\u0007\u009a\u0002\u009b\u0007"+
		"\u009b\u0002\u009c\u0007\u009c\u0002\u009d\u0007\u009d\u0002\u009e\u0007"+
		"\u009e\u0002\u009f\u0007\u009f\u0002\u00a0\u0007\u00a0\u0002\u00a1\u0007"+
		"\u00a1\u0002\u00a2\u0007\u00a2\u0002\u00a3\u0007\u00a3\u0002\u00a4\u0007"+
		"\u00a4\u0002\u00a5\u0007\u00a5\u0002\u00a6\u0007\u00a6\u0002\u00a7\u0007"+
		"\u00a7\u0002\u00a8\u0007\u00a8\u0002\u00a9\u0007\u00a9\u0002\u00aa\u0007"+
		"\u00aa\u0002\u00ab\u0007\u00ab\u0002\u00ac\u0007\u00ac\u0002\u00ad\u0007"+
		"\u00ad\u0002\u00ae\u0007\u00ae\u0002\u00af\u0007\u00af\u0002\u00b0\u0007"+
		"\u00b0\u0002\u00b1\u0007\u00b1\u0002\u00b2\u0007\u00b2\u0002\u00b3\u0007"+
		"\u00b3\u0002\u00b4\u0007\u00b4\u0002\u00b5\u0007\u00b5\u0001\u0000\u0001"+
		"\u0000\u0001\u0000\u0001\u0000\u0003\u0000\u0171\b\u0000\u0001\u0000\u0001"+
		"\u0000\u0001\u0001\u0001\u0001\u0001\u0002\u0001\u0002\u0001\u0003\u0001"+
		"\u0003\u0003\u0003\u017b\b\u0003\u0001\u0004\u0001\u0004\u0003\u0004\u017f"+
		"\b\u0004\u0001\u0004\u0001\u0004\u0003\u0004\u0183\b\u0004\u0001\u0005"+
		"\u0001\u0005\u0003\u0005\u0187\b\u0005\u0001\u0005\u0001\u0005\u0001\u0005"+
		"\u0003\u0005\u018c\b\u0005\u0001\u0006\u0001\u0006\u0001\u0006\u0001\u0006"+
		"\u0005\u0006\u0192\b\u0006\n\u0006\f\u0006\u0195\t\u0006\u0001\u0007\u0001"+
		"\u0007\u0001\u0007\u0001\u0007\u0001\b\u0001\b\u0003\b\u019d\b\b\u0001"+
		"\b\u0001\b\u0001\b\u0001\b\u0003\b\u01a3\b\b\u0001\t\u0001\t\u0001\t\u0001"+
		"\t\u0005\t\u01a9\b\t\n\t\f\t\u01ac\t\t\u0001\t\u0001\t\u0001\n\u0001\n"+
		"\u0001\n\u0001\n\u0005\n\u01b4\b\n\n\n\f\n\u01b7\t\n\u0001\u000b\u0001"+
		"\u000b\u0001\u000b\u0001\u000b\u0005\u000b\u01bd\b\u000b\n\u000b\f\u000b"+
		"\u01c0\t\u000b\u0001\u000b\u0001\u000b\u0001\f\u0001\f\u0001\f\u0001\f"+
		"\u0001\f\u0004\f\u01c9\b\f\u000b\f\f\f\u01ca\u0003\f\u01cd\b\f\u0001\r"+
		"\u0001\r\u0003\r\u01d1\b\r\u0001\r\u0001\r\u0001\r\u0001\r\u0003\r\u01d7"+
		"\b\r\u0003\r\u01d9\b\r\u0001\u000e\u0001\u000e\u0003\u000e\u01dd\b\u000e"+
		"\u0001\u000e\u0001\u000e\u0003\u000e\u01e1\b\u000e\u0001\u000e\u0001\u000e"+
		"\u0003\u000e\u01e5\b\u000e\u0003\u000e\u01e7\b\u000e\u0001\u000f\u0001"+
		"\u000f\u0003\u000f\u01eb\b\u000f\u0001\u000f\u0003\u000f\u01ee\b\u000f"+
		"\u0001\u000f\u0003\u000f\u01f1\b\u000f\u0001\u0010\u0001\u0010\u0003\u0010"+
		"\u01f5\b\u0010\u0001\u0010\u0003\u0010\u01f8\b\u0010\u0001\u0010\u0001"+
		"\u0010\u0003\u0010\u01fc\b\u0010\u0003\u0010\u01fe\b\u0010\u0001\u0010"+
		"\u0001\u0010\u0003\u0010\u0202\b\u0010\u0001\u0010\u0001\u0010\u0003\u0010"+
		"\u0206\b\u0010\u0003\u0010\u0208\b\u0010\u0001\u0010\u0003\u0010\u020b"+
		"\b\u0010\u0003\u0010\u020d\b\u0010\u0001\u0011\u0001\u0011\u0001\u0011"+
		"\u0001\u0011\u0005\u0011\u0213\b\u0011\n\u0011\f\u0011\u0216\t\u0011\u0001"+
		"\u0012\u0001\u0012\u0001\u0012\u0001\u0012\u0005\u0012\u021c\b\u0012\n"+
		"\u0012\f\u0012\u021f\t\u0012\u0001\u0013\u0001\u0013\u0003\u0013\u0223"+
		"\b\u0013\u0001\u0013\u0001\u0013\u0001\u0013\u0001\u0013\u0003\u0013\u0229"+
		"\b\u0013\u0003\u0013\u022b\b\u0013\u0001\u0014\u0001\u0014\u0001\u0014"+
		"\u0005\u0014\u0230\b\u0014\n\u0014\f\u0014\u0233\t\u0014\u0001\u0015\u0001"+
		"\u0015\u0001\u0015\u0003\u0015\u0238\b\u0015\u0001\u0016\u0001\u0016\u0001"+
		"\u0016\u0001\u0016\u0003\u0016\u023e\b\u0016\u0001\u0017\u0001\u0017\u0001"+
		"\u0017\u0001\u0017\u0001\u0017\u0001\u0017\u0003\u0017\u0246\b\u0017\u0001"+
		"\u0018\u0001\u0018\u0001\u0018\u0003\u0018\u024b\b\u0018\u0001\u0018\u0001"+
		"\u0018\u0003\u0018\u024f\b\u0018\u0001\u0019\u0003\u0019\u0252\b\u0019"+
		"\u0001\u0019\u0003\u0019\u0255\b\u0019\u0001\u0019\u0003\u0019\u0258\b"+
		"\u0019\u0003\u0019\u025a\b\u0019\u0001\u001a\u0001\u001a\u0003\u001a\u025e"+
		"\b\u001a\u0001\u001a\u0003\u001a\u0261\b\u001a\u0001\u001a\u0001\u001a"+
		"\u0001\u001a\u0001\u001a\u0003\u001a\u0267\b\u001a\u0003\u001a\u0269\b"+
		"\u001a\u0001\u001b\u0001\u001b\u0001\u001b\u0001\u001c\u0001\u001c\u0003"+
		"\u001c\u0270\b\u001c\u0001\u001c\u0001\u001c\u0001\u001d\u0001\u001d\u0001"+
		"\u001d\u0005\u001d\u0277\b\u001d\n\u001d\f\u001d\u027a\t\u001d\u0001\u001e"+
		"\u0001\u001e\u0003\u001e\u027e\b\u001e\u0001\u001f\u0001\u001f\u0001\u001f"+
		"\u0001\u001f\u0003\u001f\u0284\b\u001f\u0001 \u0001 \u0001 \u0001 \u0001"+
		" \u0001!\u0001!\u0001!\u0001!\u0001!\u0001!\u0001\"\u0001\"\u0001\"\u0003"+
		"\"\u0294\b\"\u0001#\u0001#\u0001#\u0005#\u0299\b#\n#\f#\u029c\t#\u0001"+
		"$\u0001$\u0003$\u02a0\b$\u0001%\u0001%\u0003%\u02a4\b%\u0001&\u0001&\u0001"+
		"&\u0001&\u0001&\u0001\'\u0001\'\u0005\'\u02ad\b\'\n\'\f\'\u02b0\t\'\u0001"+
		"(\u0001(\u0001(\u0001)\u0001)\u0003)\u02b7\b)\u0001)\u0003)\u02ba\b)\u0001"+
		"*\u0001*\u0001*\u0001+\u0001+\u0001+\u0001+\u0001+\u0001+\u0003+\u02c5"+
		"\b+\u0001,\u0001,\u0003,\u02c9\b,\u0001-\u0001-\u0001-\u0001-\u0001-\u0003"+
		"-\u02d0\b-\u0001.\u0001.\u0001.\u0001.\u0001.\u0001.\u0001.\u0003.\u02d9"+
		"\b.\u0001/\u0001/\u0001/\u0001/\u0001/\u0003/\u02e0\b/\u00010\u00010\u0001"+
		"0\u00010\u00010\u00030\u02e7\b0\u00011\u00011\u00011\u00011\u00011\u0005"+
		"1\u02ee\b1\n1\f1\u02f1\t1\u00012\u00012\u00012\u00032\u02f6\b2\u00013"+
		"\u00013\u00013\u00014\u00014\u00014\u00014\u00014\u00054\u0300\b4\n4\f"+
		"4\u0303\t4\u00015\u00015\u00015\u00055\u0308\b5\n5\f5\u030b\t5\u00016"+
		"\u00016\u00036\u030f\b6\u00016\u00036\u0312\b6\u00017\u00017\u00017\u0001"+
		"8\u00018\u00018\u00038\u031a\b8\u00019\u00019\u0001:\u0001:\u0001:\u0001"+
		":\u0001:\u0001:\u0001:\u0001;\u0001;\u0001<\u0001<\u0001<\u0001=\u0001"+
		"=\u0001=\u0003=\u032d\b=\u0001>\u0001>\u0001>\u0001>\u0001>\u0001>\u0003"+
		">\u0335\b>\u0001>\u0001>\u0001>\u0001>\u0003>\u033b\b>\u0001?\u0001?\u0003"+
		"?\u033f\b?\u0001@\u0001@\u0001@\u0001@\u0003@\u0345\b@\u0001A\u0001A\u0001"+
		"A\u0001B\u0001B\u0001B\u0001B\u0001B\u0001B\u0001B\u0001B\u0003B\u0352"+
		"\bB\u0001B\u0001B\u0001B\u0001B\u0001B\u0003B\u0359\bB\u0001B\u0001B\u0001"+
		"B\u0001B\u0003B\u035f\bB\u0001B\u0001B\u0001B\u0001B\u0001B\u0003B\u0366"+
		"\bB\u0001B\u0001B\u0001B\u0001B\u0001B\u0001B\u0001B\u0003B\u036f\bB\u0001"+
		"B\u0001B\u0001B\u0003B\u0374\bB\u0001B\u0001B\u0001B\u0001B\u0001B\u0001"+
		"B\u0001B\u0001B\u0001B\u0001B\u0001B\u0001B\u0001B\u0001B\u0003B\u0384"+
		"\bB\u0001B\u0001B\u0003B\u0388\bB\u0001B\u0001B\u0001B\u0001B\u0001B\u0003"+
		"B\u038f\bB\u0001B\u0001B\u0001B\u0001B\u0001B\u0001B\u0005B\u0397\bB\n"+
		"B\fB\u039a\tB\u0001C\u0001C\u0001C\u0001C\u0001C\u0001C\u0001C\u0001C"+
		"\u0001C\u0001C\u0001C\u0001C\u0001C\u0003C\u03a9\bC\u0001D\u0001D\u0001"+
		"D\u0001D\u0001D\u0001D\u0001D\u0001D\u0001D\u0005D\u03b4\bD\nD\fD\u03b7"+
		"\tD\u0003D\u03b9\bD\u0001D\u0001D\u0001D\u0001D\u0001D\u0001D\u0003D\u03c1"+
		"\bD\u0001E\u0001E\u0001E\u0001E\u0003E\u03c7\bE\u0001F\u0001F\u0001F\u0001"+
		"F\u0001F\u0001F\u0001F\u0001F\u0001F\u0004F\u03d2\bF\u000bF\fF\u03d3\u0001"+
		"F\u0001F\u0001F\u0001F\u0001F\u0001F\u0001F\u0001F\u0001F\u0001F\u0001"+
		"F\u0001F\u0001F\u0003F\u03e3\bF\u0001F\u0001F\u0001F\u0001F\u0001F\u0001"+
		"F\u0001F\u0001F\u0001F\u0001F\u0001F\u0001F\u0001F\u0001F\u0001F\u0001"+
		"F\u0005F\u03f5\bF\nF\fF\u03f8\tF\u0001G\u0001G\u0001G\u0001G\u0001G\u0001"+
		"G\u0001G\u0001G\u0001G\u0001G\u0003G\u0404\bG\u0001G\u0001G\u0003G\u0408"+
		"\bG\u0001H\u0001H\u0003H\u040c\bH\u0001I\u0001I\u0001J\u0001J\u0001K\u0001"+
		"K\u0001L\u0001L\u0001L\u0001L\u0003L\u0418\bL\u0001L\u0001L\u0001M\u0001"+
		"M\u0001M\u0001M\u0001M\u0003M\u0421\bM\u0001N\u0001N\u0001N\u0001N\u0001"+
		"N\u0001O\u0001O\u0001O\u0001O\u0001O\u0003O\u042d\bO\u0001P\u0001P\u0001"+
		"P\u0001P\u0001P\u0001Q\u0001Q\u0003Q\u0436\bQ\u0001R\u0001R\u0001R\u0004"+
		"R\u043b\bR\u000bR\fR\u043c\u0001R\u0003R\u0440\bR\u0001R\u0001R\u0001"+
		"S\u0001S\u0001S\u0001S\u0001S\u0001T\u0001T\u0001T\u0001U\u0001U\u0004"+
		"U\u044e\bU\u000bU\fU\u044f\u0001U\u0003U\u0453\bU\u0001U\u0001U\u0001"+
		"V\u0001V\u0001V\u0001V\u0001V\u0001W\u0001W\u0001W\u0001W\u0001W\u0001"+
		"W\u0001W\u0001W\u0003W\u0464\bW\u0001X\u0001X\u0001Y\u0001Y\u0001Z\u0001"+
		"Z\u0001Z\u0001Z\u0001Z\u0005Z\u046f\bZ\nZ\fZ\u0472\tZ\u0001Z\u0003Z\u0475"+
		"\bZ\u0001[\u0001[\u0001[\u0001[\u0001[\u0001[\u0003[\u047d\b[\u0001\\"+
		"\u0001\\\u0001\\\u0001\\\u0001\\\u0001\\\u0003\\\u0485\b\\\u0001]\u0001"+
		"]\u0001]\u0001]\u0001]\u0001]\u0003]\u048d\b]\u0001^\u0001^\u0001^\u0001"+
		"^\u0001^\u0001^\u0003^\u0495\b^\u0001_\u0001_\u0001_\u0001_\u0003_\u049b"+
		"\b_\u0001`\u0001`\u0001`\u0001`\u0001`\u0001`\u0001a\u0001a\u0001a\u0001"+
		"a\u0001a\u0003a\u04a8\ba\u0001b\u0001b\u0001b\u0001b\u0003b\u04ae\bb\u0001"+
		"c\u0001c\u0001d\u0001d\u0001e\u0001e\u0001f\u0001f\u0001g\u0001g\u0001"+
		"h\u0001h\u0001i\u0001i\u0001i\u0003i\u04bf\bi\u0001i\u0003i\u04c2\bi\u0001"+
		"j\u0001j\u0001j\u0003j\u04c7\bj\u0001j\u0001j\u0001k\u0001k\u0001k\u0003"+
		"k\u04ce\bk\u0001k\u0001k\u0001l\u0001l\u0001l\u0003l\u04d5\bl\u0001l\u0001"+
		"l\u0001m\u0001m\u0001n\u0001n\u0001n\u0001n\u0001n\u0001n\u0001o\u0001"+
		"o\u0001p\u0001p\u0001q\u0001q\u0001q\u0001q\u0003q\u04e9\bq\u0003q\u04eb"+
		"\bq\u0001r\u0001r\u0001r\u0001r\u0001r\u0001r\u0001r\u0001r\u0003r\u04f5"+
		"\br\u0001s\u0001s\u0001s\u0001s\u0001s\u0003s\u04fc\bs\u0001s\u0001s\u0001"+
		"t\u0001t\u0001u\u0001u\u0001u\u0001u\u0003u\u0506\bu\u0001u\u0001u\u0003"+
		"u\u050a\bu\u0001u\u0003u\u050d\bu\u0001u\u0003u\u0510\bu\u0001u\u0003"+
		"u\u0513\bu\u0001u\u0003u\u0516\bu\u0001v\u0001v\u0001w\u0001w\u0001w\u0001"+
		"w\u0003w\u051e\bw\u0001w\u0001w\u0001w\u0005w\u0523\bw\nw\fw\u0526\tw"+
		"\u0001x\u0001x\u0001x\u0001x\u0001x\u0001y\u0001y\u0001y\u0001y\u0001"+
		"y\u0001y\u0001y\u0001y\u0001y\u0001y\u0001y\u0001y\u0001y\u0001y\u0001"+
		"y\u0001y\u0001y\u0001y\u0001y\u0001y\u0001y\u0001y\u0001y\u0001y\u0001"+
		"y\u0001y\u0001y\u0001y\u0001y\u0001y\u0001y\u0001y\u0001y\u0001y\u0001"+
		"y\u0001y\u0001y\u0001y\u0001y\u0001y\u0001y\u0001y\u0003y\u0557\by\u0001"+
		"z\u0001z\u0001z\u0001z\u0001z\u0001z\u0001z\u0001z\u0001z\u0001z\u0001"+
		"z\u0001z\u0001z\u0001z\u0001z\u0001z\u0001z\u0001z\u0001z\u0001z\u0001"+
		"z\u0001z\u0001z\u0001z\u0001z\u0001z\u0001z\u0001z\u0001z\u0001z\u0001"+
		"z\u0001z\u0001z\u0001z\u0001z\u0001z\u0001z\u0001z\u0001z\u0001z\u0001"+
		"z\u0001z\u0003z\u0583\bz\u0001{\u0001{\u0001{\u0001{\u0001{\u0001{\u0001"+
		"{\u0001{\u0001{\u0001{\u0003{\u058f\b{\u0001|\u0001|\u0001|\u0003|\u0594"+
		"\b|\u0001}\u0001}\u0001}\u0001}\u0001}\u0003}\u059b\b}\u0001}\u0003}\u059e"+
		"\b}\u0001}\u0001}\u0001}\u0001}\u0001}\u0001}\u0001}\u0001}\u0001}\u0001"+
		"}\u0001}\u0003}\u05ab\b}\u0001~\u0001~\u0001~\u0001~\u0001~\u0003~\u05b2"+
		"\b~\u0001~\u0003~\u05b5\b~\u0001~\u0001~\u0001~\u0001~\u0001~\u0001~\u0001"+
		"~\u0001~\u0001~\u0001~\u0001~\u0003~\u05c2\b~\u0001\u007f\u0001\u007f"+
		"\u0001\u007f\u0003\u007f\u05c7\b\u007f\u0001\u007f\u0001\u007f\u0001\u007f"+
		"\u0001\u007f\u0003\u007f\u05cd\b\u007f\u0001\u007f\u0001\u007f\u0003\u007f"+
		"\u05d1\b\u007f\u0001\u007f\u0003\u007f\u05d4\b\u007f\u0001\u007f\u0003"+
		"\u007f\u05d7\b\u007f\u0001\u0080\u0001\u0080\u0001\u0080\u0001\u0080\u0001"+
		"\u0080\u0003\u0080\u05de\b\u0080\u0001\u0080\u0001\u0080\u0003\u0080\u05e2"+
		"\b\u0080\u0001\u0081\u0001\u0081\u0001\u0081\u0001\u0081\u0001\u0081\u0001"+
		"\u0081\u0001\u0082\u0001\u0082\u0001\u0082\u0001\u0082\u0001\u0082\u0001"+
		"\u0083\u0001\u0083\u0001\u0083\u0001\u0083\u0003\u0083\u05f3\b\u0083\u0001"+
		"\u0084\u0001\u0084\u0001\u0084\u0001\u0084\u0003\u0084\u05f9\b\u0084\u0001"+
		"\u0085\u0001\u0085\u0001\u0085\u0003\u0085\u05fe\b\u0085\u0001\u0085\u0003"+
		"\u0085\u0601\b\u0085\u0001\u0085\u0003\u0085\u0604\b\u0085\u0001\u0085"+
		"\u0001\u0085\u0001\u0086\u0001\u0086\u0001\u0086\u0001\u0086\u0001\u0086"+
		"\u0005\u0086\u060d\b\u0086\n\u0086\f\u0086\u0610\t\u0086\u0001\u0087\u0001"+
		"\u0087\u0001\u0087\u0003\u0087\u0615\b\u0087\u0001\u0087\u0001\u0087\u0001"+
		"\u0087\u0001\u0087\u0001\u0087\u0001\u0087\u0003\u0087\u061d\b\u0087\u0003"+
		"\u0087\u061f\b\u0087\u0001\u0088\u0001\u0088\u0001\u0088\u0001\u0088\u0001"+
		"\u0088\u0001\u0088\u0001\u0088\u0001\u0088\u0001\u0088\u0001\u0088\u0003"+
		"\u0088\u062b\b\u0088\u0001\u0089\u0001\u0089\u0001\u0089\u0001\u0089\u0001"+
		"\u0089\u0001\u0089\u0001\u0089\u0001\u0089\u0001\u0089\u0001\u0089\u0003"+
		"\u0089\u0637\b\u0089\u0001\u008a\u0001\u008a\u0001\u008a\u0001\u008a\u0001"+
		"\u008a\u0001\u008a\u0001\u008a\u0001\u008a\u0001\u008a\u0001\u008a\u0003"+
		"\u008a\u0643\b\u008a\u0001\u008b\u0001\u008b\u0001\u008b\u0001\u008b\u0001"+
		"\u008b\u0001\u008b\u0001\u008b\u0001\u008b\u0001\u008b\u0001\u008b\u0001"+
		"\u008b\u0001\u008b\u0001\u008b\u0001\u008b\u0001\u008b\u0001\u008b\u0001"+
		"\u008b\u0001\u008b\u0001\u008b\u0003\u008b\u0658\b\u008b\u0001\u008c\u0001"+
		"\u008c\u0001\u008c\u0001\u008c\u0001\u008c\u0001\u008c\u0001\u008c\u0001"+
		"\u008d\u0001\u008d\u0001\u008d\u0001\u008d\u0001\u008d\u0003\u008d\u0666"+
		"\b\u008d\u0001\u008d\u0003\u008d\u0669\b\u008d\u0001\u008e\u0001\u008e"+
		"\u0001\u008e\u0001\u008e\u0001\u008e\u0001\u008e\u0001\u008e\u0005\u008e"+
		"\u0672\b\u008e\n\u008e\f\u008e\u0675\t\u008e\u0001\u008f\u0001\u008f\u0001"+
		"\u008f\u0001\u008f\u0001\u008f\u0001\u008f\u0001\u008f\u0003\u008f\u067e"+
		"\b\u008f\u0001\u008f\u0001\u008f\u0001\u008f\u0001\u008f\u0001\u008f\u0001"+
		"\u008f\u0001\u008f\u0001\u008f\u0001\u008f\u0003\u008f\u0689\b\u008f\u0001"+
		"\u008f\u0001\u008f\u0003\u008f\u068d\b\u008f\u0001\u0090\u0001\u0090\u0001"+
		"\u0091\u0001\u0091\u0001\u0092\u0001\u0092\u0001\u0092\u0003\u0092\u0696"+
		"\b\u0092\u0001\u0092\u0003\u0092\u0699\b\u0092\u0001\u0092\u0003\u0092"+
		"\u069c\b\u0092\u0001\u0092\u0001\u0092\u0001\u0092\u0001\u0093\u0001\u0093"+
		"\u0001\u0094\u0001\u0094\u0001\u0095\u0001\u0095\u0001\u0095\u0001\u0095"+
		"\u0001\u0095\u0001\u0095\u0001\u0095\u0003\u0095\u06ac\b\u0095\u0001\u0095"+
		"\u0001\u0095\u0001\u0096\u0001\u0096\u0001\u0097\u0001\u0097\u0001\u0098"+
		"\u0001\u0098\u0001\u0099\u0001\u0099\u0001\u0099\u0001\u0099\u0001\u0099"+
		"\u0001\u0099\u0001\u0099\u0001\u0099\u0001\u0099\u0003\u0099\u06bf\b\u0099"+
		"\u0001\u0099\u0001\u0099\u0001\u009a\u0001\u009a\u0001\u009b\u0001\u009b"+
		"\u0001\u009c\u0001\u009c\u0001\u009d\u0001\u009d\u0001\u009e\u0001\u009e"+
		"\u0001\u009e\u0003\u009e\u06ce\b\u009e\u0001\u009e\u0001\u009e\u0003\u009e"+
		"\u06d2\b\u009e\u0001\u009f\u0001\u009f\u0001\u009f\u0003\u009f\u06d7\b"+
		"\u009f\u0001\u009f\u0001\u009f\u0003\u009f\u06db\b\u009f\u0001\u00a0\u0001"+
		"\u00a0\u0001\u00a0\u0003\u00a0\u06e0\b\u00a0\u0001\u00a0\u0001\u00a0\u0003"+
		"\u00a0\u06e4\b\u00a0\u0001\u00a1\u0001\u00a1\u0001\u00a1\u0003\u00a1\u06e9"+
		"\b\u00a1\u0001\u00a1\u0003\u00a1\u06ec\b\u00a1\u0001\u00a2\u0001\u00a2"+
		"\u0001\u00a2\u0003\u00a2\u06f1\b\u00a2\u0001\u00a2\u0001\u00a2\u0003\u00a2"+
		"\u06f5\b\u00a2\u0001\u00a3\u0001\u00a3\u0001\u00a3\u0003\u00a3\u06fa\b"+
		"\u00a3\u0001\u00a3\u0001\u00a3\u0003\u00a3\u06fe\b\u00a3\u0001\u00a4\u0001"+
		"\u00a4\u0001\u00a4\u0003\u00a4\u0703\b\u00a4\u0001\u00a4\u0001\u00a4\u0003"+
		"\u00a4\u0707\b\u00a4\u0001\u00a5\u0001\u00a5\u0001\u00a5\u0003\u00a5\u070c"+
		"\b\u00a5\u0001\u00a5\u0001\u00a5\u0003\u00a5\u0710\b\u00a5\u0001\u00a6"+
		"\u0001\u00a6\u0001\u00a6\u0001\u00a6\u0001\u00a6\u0001\u00a6\u0001\u00a6"+
		"\u0001\u00a7\u0001\u00a7\u0001\u00a8\u0001\u00a8\u0001\u00a8\u0001\u00a8"+
		"\u0001\u00a8\u0001\u00a8\u0001\u00a8\u0001\u00a8\u0001\u00a8\u0001\u00a8"+
		"\u0001\u00a8\u0001\u00a8\u0003\u00a8\u0727\b\u00a8\u0001\u00a9\u0001\u00a9"+
		"\u0001\u00a9\u0001\u00a9\u0001\u00a9\u0003\u00a9\u072e\b\u00a9\u0001\u00aa"+
		"\u0001\u00aa\u0001\u00ab\u0001\u00ab\u0001\u00ab\u0001\u00ab\u0001\u00ab"+
		"\u0001\u00ab\u0001\u00ab\u0001\u00ab\u0001\u00ab\u0003\u00ab\u073b\b\u00ab"+
		"\u0001\u00ac\u0001\u00ac\u0001\u00ac\u0001\u00ac\u0001\u00ac\u0001\u00ac"+
		"\u0003\u00ac\u0743\b\u00ac\u0001\u00ad\u0001\u00ad\u0003\u00ad\u0747\b"+
		"\u00ad\u0001\u00ad\u0001\u00ad\u0003\u00ad\u074b\b\u00ad\u0001\u00ae\u0001"+
		"\u00ae\u0001\u00af\u0001\u00af\u0001\u00af\u0001\u00af\u0001\u00af\u0001"+
		"\u00af\u0001\u00af\u0001\u00b0\u0001\u00b0\u0001\u00b1\u0001\u00b1\u0001"+
		"\u00b2\u0001\u00b2\u0001\u00b2\u0001\u00b2\u0001\u00b2\u0005\u00b2\u075f"+
		"\b\u00b2\n\u00b2\f\u00b2\u0762\t\u00b2\u0001\u00b2\u0001\u00b2\u0001\u00b3"+
		"\u0001\u00b3\u0001\u00b3\u0001\u00b3\u0001\u00b3\u0005\u00b3\u076b\b\u00b3"+
		"\n\u00b3\f\u00b3\u076e\t\u00b3\u0001\u00b3\u0001\u00b3\u0001\u00b4\u0001"+
		"\u00b4\u0001\u00b4\u0001\u00b4\u0003\u00b4\u0776\b\u00b4\u0001\u00b5\u0001"+
		"\u00b5\u0001\u00b5\u0003\u00b5\u077b\b\u00b5\u0001\u00b5\u0000\u0002\u0084"+
		"\u008c\u00b6\u0000\u0002\u0004\u0006\b\n\f\u000e\u0010\u0012\u0014\u0016"+
		"\u0018\u001a\u001c\u001e \"$&(*,.02468:<>@BDFHJLNPRTVXZ\\^`bdfhjlnprt"+
		"vxz|~\u0080\u0082\u0084\u0086\u0088\u008a\u008c\u008e\u0090\u0092\u0094"+
		"\u0096\u0098\u009a\u009c\u009e\u00a0\u00a2\u00a4\u00a6\u00a8\u00aa\u00ac"+
		"\u00ae\u00b0\u00b2\u00b4\u00b6\u00b8\u00ba\u00bc\u00be\u00c0\u00c2\u00c4"+
		"\u00c6\u00c8\u00ca\u00cc\u00ce\u00d0\u00d2\u00d4\u00d6\u00d8\u00da\u00dc"+
		"\u00de\u00e0\u00e2\u00e4\u00e6\u00e8\u00ea\u00ec\u00ee\u00f0\u00f2\u00f4"+
		"\u00f6\u00f8\u00fa\u00fc\u00fe\u0100\u0102\u0104\u0106\u0108\u010a\u010c"+
		"\u010e\u0110\u0112\u0114\u0116\u0118\u011a\u011c\u011e\u0120\u0122\u0124"+
		"\u0126\u0128\u012a\u012c\u012e\u0130\u0132\u0134\u0136\u0138\u013a\u013c"+
		"\u013e\u0140\u0142\u0144\u0146\u0148\u014a\u014c\u014e\u0150\u0152\u0154"+
		"\u0156\u0158\u015a\u015c\u015e\u0160\u0162\u0164\u0166\u0168\u016a\u0000"+
		"\u001a\u0003\u0000]]ss\u00a4\u00a4\u0002\u0000\u0092\u0092\u00c2\u00c2"+
		"\u0002\u0000II\u00bd\u00bd\u0002\u0000ffoo\u0002\u0000XXpp\u0002\u0000"+
		"33GG\u0001\u0000\u00a6\u00a7\u0002\u0000XX\u008a\u008a\u0002\u0000ddt"+
		"t\u0002\u0000JJgg\u0001\u0000 \"\u0001\u0000\u001e\u001f\u0001\u0000\u00c6"+
		"\u00c7\u0001\u0000\u0003\t\u0002\u0000\u0003\u0003\u0005\u0005\u0002\u0000"+
		"//QQ\u0002\u000011\u00ac\u00ac\u0002\u0000\u00c2\u00c2\u00c4\u00c4\u0003"+
		"\u0000``\u00a2\u00a2\u00a7\u00a7\u0003\u000066rr\u00b5\u00b5\u0002\u0000"+
		"rr\u00b5\u00b5\u0007\u0000EEbb\u0086\u0088\u00a1\u00a1\u00a8\u00a8\u00bf"+
		"\u00bf\u00c5\u00c5\u0002\u0000bb\u0086\u0086\u0002\u0000CC\u00b1\u00b1"+
		"\b\u0000*-/\\^giprrt\u0096\u0098\u00a3\u00a5\u00c5\u0005\u0000]]hhss\u0097"+
		"\u0097\u00a4\u00a4\u0800\u0000\u0170\u0001\u0000\u0000\u0000\u0002\u0174"+
		"\u0001\u0000\u0000\u0000\u0004\u0176\u0001\u0000\u0000\u0000\u0006\u0178"+
		"\u0001\u0000\u0000\u0000\b\u017c\u0001\u0000\u0000\u0000\n\u0184\u0001"+
		"\u0000\u0000\u0000\f\u018d\u0001\u0000\u0000\u0000\u000e\u0196\u0001\u0000"+
		"\u0000\u0000\u0010\u019a\u0001\u0000\u0000\u0000\u0012\u01a4\u0001\u0000"+
		"\u0000\u0000\u0014\u01af\u0001\u0000\u0000\u0000\u0016\u01b8\u0001\u0000"+
		"\u0000\u0000\u0018\u01cc\u0001\u0000\u0000\u0000\u001a\u01d8\u0001\u0000"+
		"\u0000\u0000\u001c\u01e6\u0001\u0000\u0000\u0000\u001e\u01e8\u0001\u0000"+
		"\u0000\u0000 \u020c\u0001\u0000\u0000\u0000\"\u020e\u0001\u0000\u0000"+
		"\u0000$\u0217\u0001\u0000\u0000\u0000&\u022a\u0001\u0000\u0000\u0000("+
		"\u022c\u0001\u0000\u0000\u0000*\u0237\u0001\u0000\u0000\u0000,\u0239\u0001"+
		"\u0000\u0000\u0000.\u023f\u0001\u0000\u0000\u00000\u0247\u0001\u0000\u0000"+
		"\u00002\u0259\u0001\u0000\u0000\u00004\u0268\u0001\u0000\u0000\u00006"+
		"\u026a\u0001\u0000\u0000\u00008\u026d\u0001\u0000\u0000\u0000:\u0273\u0001"+
		"\u0000\u0000\u0000<\u027b\u0001\u0000\u0000\u0000>\u0283\u0001\u0000\u0000"+
		"\u0000@\u0285\u0001\u0000\u0000\u0000B\u028a\u0001\u0000\u0000\u0000D"+
		"\u0293\u0001\u0000\u0000\u0000F\u0295\u0001\u0000\u0000\u0000H\u029d\u0001"+
		"\u0000\u0000\u0000J\u02a3\u0001\u0000\u0000\u0000L\u02a5\u0001\u0000\u0000"+
		"\u0000N\u02aa\u0001\u0000\u0000\u0000P\u02b1\u0001\u0000\u0000\u0000R"+
		"\u02b9\u0001\u0000\u0000\u0000T\u02bb\u0001\u0000\u0000\u0000V\u02c4\u0001"+
		"\u0000\u0000\u0000X\u02c6\u0001\u0000\u0000\u0000Z\u02ca\u0001\u0000\u0000"+
		"\u0000\\\u02d1\u0001\u0000\u0000\u0000^\u02da\u0001\u0000\u0000\u0000"+
		"`\u02e1\u0001\u0000\u0000\u0000b\u02e8\u0001\u0000\u0000\u0000d\u02f5"+
		"\u0001\u0000\u0000\u0000f\u02f7\u0001\u0000\u0000\u0000h\u02fa\u0001\u0000"+
		"\u0000\u0000j\u0304\u0001\u0000\u0000\u0000l\u030c\u0001\u0000\u0000\u0000"+
		"n\u0313\u0001\u0000\u0000\u0000p\u0319\u0001\u0000\u0000\u0000r\u031b"+
		"\u0001\u0000\u0000\u0000t\u031d\u0001\u0000\u0000\u0000v\u0324\u0001\u0000"+
		"\u0000\u0000x\u0326\u0001\u0000\u0000\u0000z\u0329\u0001\u0000\u0000\u0000"+
		"|\u032e\u0001\u0000\u0000\u0000~\u033e\u0001\u0000\u0000\u0000\u0080\u0344"+
		"\u0001\u0000\u0000\u0000\u0082\u0346\u0001\u0000\u0000\u0000\u0084\u038e"+
		"\u0001\u0000\u0000\u0000\u0086\u03a8\u0001\u0000\u0000\u0000\u0088\u03c0"+
		"\u0001\u0000\u0000\u0000\u008a\u03c2\u0001\u0000\u0000\u0000\u008c\u03e2"+
		"\u0001\u0000\u0000\u0000\u008e\u0407\u0001\u0000\u0000\u0000\u0090\u040b"+
		"\u0001\u0000\u0000\u0000\u0092\u040d\u0001\u0000\u0000\u0000\u0094\u040f"+
		"\u0001\u0000\u0000\u0000\u0096\u0411\u0001\u0000\u0000\u0000\u0098\u0413"+
		"\u0001\u0000\u0000\u0000\u009a\u041b\u0001\u0000\u0000\u0000\u009c\u0422"+
		"\u0001\u0000\u0000\u0000\u009e\u0427\u0001\u0000\u0000\u0000\u00a0\u042e"+
		"\u0001\u0000\u0000\u0000\u00a2\u0435\u0001\u0000\u0000\u0000\u00a4\u0437"+
		"\u0001\u0000\u0000\u0000\u00a6\u0443\u0001\u0000\u0000\u0000\u00a8\u0448"+
		"\u0001\u0000\u0000\u0000\u00aa\u044b\u0001\u0000\u0000\u0000\u00ac\u0456"+
		"\u0001\u0000\u0000\u0000\u00ae\u0463\u0001\u0000\u0000\u0000\u00b0\u0465"+
		"\u0001\u0000\u0000\u0000\u00b2\u0467\u0001\u0000\u0000\u0000\u00b4\u0474"+
		"\u0001\u0000\u0000\u0000\u00b6\u047c\u0001\u0000\u0000\u0000\u00b8\u0484"+
		"\u0001\u0000\u0000\u0000\u00ba\u048c\u0001\u0000\u0000\u0000\u00bc\u0494"+
		"\u0001\u0000\u0000\u0000\u00be\u0496\u0001\u0000\u0000\u0000\u00c0\u049c"+
		"\u0001\u0000\u0000\u0000\u00c2\u04a2\u0001\u0000\u0000\u0000\u00c4\u04a9"+
		"\u0001\u0000\u0000\u0000\u00c6\u04af\u0001\u0000\u0000\u0000\u00c8\u04b1"+
		"\u0001\u0000\u0000\u0000\u00ca\u04b3\u0001\u0000\u0000\u0000\u00cc\u04b5"+
		"\u0001\u0000\u0000\u0000\u00ce\u04b7\u0001\u0000\u0000\u0000\u00d0\u04b9"+
		"\u0001\u0000\u0000\u0000\u00d2\u04c1\u0001\u0000\u0000\u0000\u00d4\u04c3"+
		"\u0001\u0000\u0000\u0000\u00d6\u04ca\u0001\u0000\u0000\u0000\u00d8\u04d1"+
		"\u0001\u0000\u0000\u0000\u00da\u04d8\u0001\u0000\u0000\u0000\u00dc\u04da"+
		"\u0001\u0000\u0000\u0000\u00de\u04e0\u0001\u0000\u0000\u0000\u00e0\u04e2"+
		"\u0001\u0000\u0000\u0000\u00e2\u04ea\u0001\u0000\u0000\u0000\u00e4\u04f4"+
		"\u0001\u0000\u0000\u0000\u00e6\u04f6\u0001\u0000\u0000\u0000\u00e8\u04ff"+
		"\u0001\u0000\u0000\u0000\u00ea\u0501\u0001\u0000\u0000\u0000\u00ec\u0517"+
		"\u0001\u0000\u0000\u0000\u00ee\u051d\u0001\u0000\u0000\u0000\u00f0\u0527"+
		"\u0001\u0000\u0000\u0000\u00f2\u0556\u0001\u0000\u0000\u0000\u00f4\u0582"+
		"\u0001\u0000\u0000\u0000\u00f6\u058e\u0001\u0000\u0000\u0000\u00f8\u0593"+
		"\u0001\u0000\u0000\u0000\u00fa\u05aa\u0001\u0000\u0000\u0000\u00fc\u05c1"+
		"\u0001\u0000\u0000\u0000\u00fe\u05c3\u0001\u0000\u0000\u0000\u0100\u05d8"+
		"\u0001\u0000\u0000\u0000\u0102\u05e3\u0001\u0000\u0000\u0000\u0104\u05e9"+
		"\u0001\u0000\u0000\u0000\u0106\u05f2\u0001\u0000\u0000\u0000\u0108\u05f8"+
		"\u0001\u0000\u0000\u0000\u010a\u05fa\u0001\u0000\u0000\u0000\u010c\u0607"+
		"\u0001\u0000\u0000\u0000\u010e\u061e\u0001\u0000\u0000\u0000\u0110\u062a"+
		"\u0001\u0000\u0000\u0000\u0112\u0636\u0001\u0000\u0000\u0000\u0114\u0642"+
		"\u0001\u0000\u0000\u0000\u0116\u0657\u0001\u0000\u0000\u0000\u0118\u0659"+
		"\u0001\u0000\u0000\u0000\u011a\u0660\u0001\u0000\u0000\u0000\u011c\u066a"+
		"\u0001\u0000\u0000\u0000\u011e\u068c\u0001\u0000\u0000\u0000\u0120\u068e"+
		"\u0001\u0000\u0000\u0000\u0122\u0690\u0001\u0000\u0000\u0000\u0124\u0692"+
		"\u0001\u0000\u0000\u0000\u0126\u06a0\u0001\u0000\u0000\u0000\u0128\u06a2"+
		"\u0001\u0000\u0000\u0000\u012a\u06a4\u0001\u0000\u0000\u0000\u012c\u06af"+
		"\u0001\u0000\u0000\u0000\u012e\u06b1\u0001\u0000\u0000\u0000\u0130\u06b3"+
		"\u0001\u0000\u0000\u0000\u0132\u06b5\u0001\u0000\u0000\u0000\u0134\u06c2"+
		"\u0001\u0000\u0000\u0000\u0136\u06c4\u0001\u0000\u0000\u0000\u0138\u06c6"+
		"\u0001\u0000\u0000\u0000\u013a\u06c8\u0001\u0000\u0000\u0000\u013c\u06d1"+
		"\u0001\u0000\u0000\u0000\u013e\u06da\u0001\u0000\u0000\u0000\u0140\u06e3"+
		"\u0001\u0000\u0000\u0000\u0142\u06eb\u0001\u0000\u0000\u0000\u0144\u06f4"+
		"\u0001\u0000\u0000\u0000\u0146\u06fd\u0001\u0000\u0000\u0000\u0148\u0706"+
		"\u0001\u0000\u0000\u0000\u014a\u070f\u0001\u0000\u0000\u0000\u014c\u0711"+
		"\u0001\u0000\u0000\u0000\u014e\u0718\u0001\u0000\u0000\u0000\u0150\u0726"+
		"\u0001\u0000\u0000\u0000\u0152\u072d\u0001\u0000\u0000\u0000\u0154\u072f"+
		"\u0001\u0000\u0000\u0000\u0156\u073a\u0001\u0000\u0000\u0000\u0158\u0742"+
		"\u0001\u0000\u0000\u0000\u015a\u074a\u0001\u0000\u0000\u0000\u015c\u074c"+
		"\u0001\u0000\u0000\u0000\u015e\u074e\u0001\u0000\u0000\u0000\u0160\u0755"+
		"\u0001\u0000\u0000\u0000\u0162\u0757\u0001\u0000\u0000\u0000\u0164\u0759"+
		"\u0001\u0000\u0000\u0000\u0166\u0765\u0001\u0000\u0000\u0000\u0168\u0775"+
		"\u0001\u0000\u0000\u0000\u016a\u077a\u0001\u0000\u0000\u0000\u016c\u0171"+
		"\u0003\u0002\u0001\u0000\u016d\u0171\u0003\n\u0005\u0000\u016e\u0171\u0003"+
		"\b\u0004\u0000\u016f\u0171\u0003\u0010\b\u0000\u0170\u016c\u0001\u0000"+
		"\u0000\u0000\u0170\u016d\u0001\u0000\u0000\u0000\u0170\u016e\u0001\u0000"+
		"\u0000\u0000\u0170\u016f\u0001\u0000\u0000\u0000\u0171\u0172\u0001\u0000"+
		"\u0000\u0000\u0172\u0173\u0005\u0000\u0000\u0001\u0173\u0001\u0001\u0000"+
		"\u0000\u0000\u0174\u0175\u0003\u0018\f\u0000\u0175\u0003\u0001\u0000\u0000"+
		"\u0000\u0176\u0177\u0003\u0018\f\u0000\u0177\u0005\u0001\u0000\u0000\u0000"+
		"\u0178\u017a\u0003(\u0014\u0000\u0179\u017b\u0003*\u0015\u0000\u017a\u0179"+
		"\u0001\u0000\u0000\u0000\u017a\u017b\u0001\u0000\u0000\u0000\u017b\u0007"+
		"\u0001\u0000\u0000\u0000\u017c\u017e\u0005F\u0000\u0000\u017d\u017f\u0005"+
		"\\\u0000\u0000\u017e\u017d\u0001\u0000\u0000\u0000\u017e\u017f\u0001\u0000"+
		"\u0000\u0000\u017f\u0180\u0001\u0000\u0000\u0000\u0180\u0182\u0003\u0006"+
		"\u0003\u0000\u0181\u0183\u0003\u0082A\u0000\u0182\u0181\u0001\u0000\u0000"+
		"\u0000\u0182\u0183\u0001\u0000\u0000\u0000\u0183\t\u0001\u0000\u0000\u0000"+
		"\u0184\u0186\u0005\u00bc\u0000\u0000\u0185\u0187\u0005,\u0000\u0000\u0186"+
		"\u0185\u0001\u0000\u0000\u0000\u0186\u0187\u0001\u0000\u0000\u0000\u0187"+
		"\u0188\u0001\u0000\u0000\u0000\u0188\u0189\u0003\u0006\u0003\u0000\u0189"+
		"\u018b\u0003\f\u0006\u0000\u018a\u018c\u0003\u0082A\u0000\u018b\u018a"+
		"\u0001\u0000\u0000\u0000\u018b\u018c\u0001\u0000\u0000\u0000\u018c\u000b"+
		"\u0001\u0000\u0000\u0000\u018d\u018e\u0005\u00aa\u0000\u0000\u018e\u0193"+
		"\u0003\u000e\u0007\u0000\u018f\u0190\u0005\u0016\u0000\u0000\u0190\u0192"+
		"\u0003\u000e\u0007\u0000\u0191\u018f\u0001\u0000\u0000\u0000\u0192\u0195"+
		"\u0001\u0000\u0000\u0000\u0193\u0191\u0001\u0000\u0000\u0000\u0193\u0194"+
		"\u0001\u0000\u0000\u0000\u0194\r\u0001\u0000\u0000\u0000\u0195\u0193\u0001"+
		"\u0000\u0000\u0000\u0196\u0197\u0003N\'\u0000\u0197\u0198\u0005\u0010"+
		"\u0000\u0000\u0198\u0199\u0003\u0090H\u0000\u0199\u000f\u0001\u0000\u0000"+
		"\u0000\u019a\u019c\u0005i\u0000\u0000\u019b\u019d\u0005l\u0000\u0000\u019c"+
		"\u019b\u0001\u0000\u0000\u0000\u019c\u019d\u0001\u0000\u0000\u0000\u019d"+
		"\u019e\u0001\u0000\u0000\u0000\u019e\u019f\u0003\u0006\u0003\u0000\u019f"+
		"\u01a2\u0003\u0012\t\u0000\u01a0\u01a3\u0003\u0018\f\u0000\u01a1\u01a3"+
		"\u0003\u0014\n\u0000\u01a2\u01a0\u0001\u0000\u0000\u0000\u01a2\u01a1\u0001"+
		"\u0000\u0000\u0000\u01a3\u0011\u0001\u0000\u0000\u0000\u01a4\u01a5\u0005"+
		"\u0018\u0000\u0000\u01a5\u01aa\u0003N\'\u0000\u01a6\u01a7\u0005\u0016"+
		"\u0000\u0000\u01a7\u01a9\u0003N\'\u0000\u01a8\u01a6\u0001\u0000\u0000"+
		"\u0000\u01a9\u01ac\u0001\u0000\u0000\u0000\u01aa\u01a8\u0001\u0000\u0000"+
		"\u0000\u01aa\u01ab\u0001\u0000\u0000\u0000\u01ab\u01ad\u0001\u0000\u0000"+
		"\u0000\u01ac\u01aa\u0001\u0000\u0000\u0000\u01ad\u01ae\u0005\u0019\u0000"+
		"\u0000\u01ae\u0013\u0001\u0000\u0000\u0000\u01af\u01b0\u0005\u00be\u0000"+
		"\u0000\u01b0\u01b5\u0003\u0016\u000b\u0000\u01b1\u01b2\u0005\u0016\u0000"+
		"\u0000\u01b2\u01b4\u0003\u0016\u000b\u0000\u01b3\u01b1\u0001\u0000\u0000"+
		"\u0000\u01b4\u01b7\u0001\u0000\u0000\u0000\u01b5\u01b3\u0001\u0000\u0000"+
		"\u0000\u01b5\u01b6\u0001\u0000\u0000\u0000\u01b6\u0015\u0001\u0000\u0000"+
		"\u0000\u01b7\u01b5\u0001\u0000\u0000\u0000\u01b8\u01b9\u0005\u0018\u0000"+
		"\u0000\u01b9\u01be\u0003\u0090H\u0000\u01ba\u01bb\u0005\u0016\u0000\u0000"+
		"\u01bb\u01bd\u0003\u0090H\u0000\u01bc\u01ba\u0001\u0000\u0000\u0000\u01bd"+
		"\u01c0\u0001\u0000\u0000\u0000\u01be\u01bc\u0001\u0000\u0000\u0000\u01be"+
		"\u01bf\u0001\u0000\u0000\u0000\u01bf\u01c1\u0001\u0000\u0000\u0000\u01c0"+
		"\u01be\u0001\u0000\u0000\u0000\u01c1\u01c2\u0005\u0019\u0000\u0000\u01c2"+
		"\u0017\u0001\u0000\u0000\u0000\u01c3\u01cd\u0003\u001a\r\u0000\u01c4\u01c8"+
		"\u0003\u001a\r\u0000\u01c5\u01c6\u0003\u001c\u000e\u0000\u01c6\u01c7\u0003"+
		"\u001a\r\u0000\u01c7\u01c9\u0001\u0000\u0000\u0000\u01c8\u01c5\u0001\u0000"+
		"\u0000\u0000\u01c9\u01ca\u0001\u0000\u0000\u0000\u01ca\u01c8\u0001\u0000"+
		"\u0000\u0000\u01ca\u01cb\u0001\u0000\u0000\u0000\u01cb\u01cd\u0001\u0000"+
		"\u0000\u0000\u01cc\u01c3\u0001\u0000\u0000\u0000\u01cc\u01c4\u0001\u0000"+
		"\u0000\u0000\u01cd\u0019\u0001\u0000\u0000\u0000\u01ce\u01d0\u0003 \u0010"+
		"\u0000\u01cf\u01d1\u0003\u001e\u000f\u0000\u01d0\u01cf\u0001\u0000\u0000"+
		"\u0000\u01d0\u01d1\u0001\u0000\u0000\u0000\u01d1\u01d9\u0001\u0000\u0000"+
		"\u0000\u01d2\u01d3\u0005\u0018\u0000\u0000\u01d3\u01d4\u0003\u0018\f\u0000"+
		"\u01d4\u01d6\u0005\u0019\u0000\u0000\u01d5\u01d7\u0003\u001e\u000f\u0000"+
		"\u01d6\u01d5\u0001\u0000\u0000\u0000\u01d6\u01d7\u0001\u0000\u0000\u0000"+
		"\u01d7\u01d9\u0001\u0000\u0000\u0000\u01d8\u01ce\u0001\u0000\u0000\u0000"+
		"\u01d8\u01d2\u0001\u0000\u0000\u0000\u01d9\u001b\u0001\u0000\u0000\u0000"+
		"\u01da\u01dc\u0005\u00bb\u0000\u0000\u01db\u01dd\u0005/\u0000\u0000\u01dc"+
		"\u01db\u0001\u0000\u0000\u0000\u01dc\u01dd\u0001\u0000\u0000\u0000\u01dd"+
		"\u01e7\u0001\u0000\u0000\u0000\u01de\u01e0\u0005k\u0000\u0000\u01df\u01e1"+
		"\u0005/\u0000\u0000\u01e0\u01df\u0001\u0000\u0000\u0000\u01e0\u01e1\u0001"+
		"\u0000\u0000\u0000\u01e1\u01e7\u0001\u0000\u0000\u0000\u01e2\u01e4\u0005"+
		"R\u0000\u0000\u01e3\u01e5\u0005/\u0000\u0000\u01e4\u01e3\u0001\u0000\u0000"+
		"\u0000\u01e4\u01e5\u0001\u0000\u0000\u0000\u01e5\u01e7\u0001\u0000\u0000"+
		"\u0000\u01e6\u01da\u0001\u0000\u0000\u0000\u01e6\u01de\u0001\u0000\u0000"+
		"\u0000\u01e6\u01e2\u0001\u0000\u0000\u0000\u01e7\u001d\u0001\u0000\u0000"+
		"\u0000\u01e8\u01ea\u0003h4\u0000\u01e9\u01eb\u0003x<\u0000\u01ea\u01e9"+
		"\u0001\u0000\u0000\u0000\u01ea\u01eb\u0001\u0000\u0000\u0000\u01eb\u01ed"+
		"\u0001\u0000\u0000\u0000\u01ec\u01ee\u0003z=\u0000\u01ed\u01ec\u0001\u0000"+
		"\u0000\u0000\u01ed\u01ee\u0001\u0000\u0000\u0000\u01ee\u01f0\u0001\u0000"+
		"\u0000\u0000\u01ef\u01f1\u0003|>\u0000\u01f0\u01ef\u0001\u0000\u0000\u0000"+
		"\u01f0\u01f1\u0001\u0000\u0000\u0000\u01f1\u001f\u0001\u0000\u0000\u0000"+
		"\u01f2\u01f4\u00038\u001c\u0000\u01f3\u01f5\u0003\"\u0011\u0000\u01f4"+
		"\u01f3\u0001\u0000\u0000\u0000\u01f4\u01f5\u0001\u0000\u0000\u0000\u01f5"+
		"\u01f7\u0001\u0000\u0000\u0000\u01f6\u01f8\u0003\u0082A\u0000\u01f7\u01f6"+
		"\u0001\u0000\u0000\u0000\u01f7\u01f8\u0001\u0000\u0000\u0000\u01f8\u01fd"+
		"\u0001\u0000\u0000\u0000\u01f9\u01fb\u0003b1\u0000\u01fa\u01fc\u0003f"+
		"3\u0000\u01fb\u01fa\u0001\u0000\u0000\u0000\u01fb\u01fc\u0001\u0000\u0000"+
		"\u0000\u01fc\u01fe\u0001\u0000\u0000\u0000\u01fd\u01f9\u0001\u0000\u0000"+
		"\u0000\u01fd\u01fe\u0001\u0000\u0000\u0000\u01fe\u020d\u0001\u0000\u0000"+
		"\u0000\u01ff\u0201\u0003\"\u0011\u0000\u0200\u0202\u0003\u0082A\u0000"+
		"\u0201\u0200\u0001\u0000\u0000\u0000\u0201\u0202\u0001\u0000\u0000\u0000"+
		"\u0202\u0207\u0001\u0000\u0000\u0000\u0203\u0205\u0003b1\u0000\u0204\u0206"+
		"\u0003f3\u0000\u0205\u0204\u0001\u0000\u0000\u0000\u0205\u0206\u0001\u0000"+
		"\u0000\u0000\u0206\u0208\u0001\u0000\u0000\u0000\u0207\u0203\u0001\u0000"+
		"\u0000\u0000\u0207\u0208\u0001\u0000\u0000\u0000\u0208\u020a\u0001\u0000"+
		"\u0000\u0000\u0209\u020b\u00038\u001c\u0000\u020a\u0209\u0001\u0000\u0000"+
		"\u0000\u020a\u020b\u0001\u0000\u0000\u0000\u020b\u020d\u0001\u0000\u0000"+
		"\u0000\u020c\u01f2\u0001\u0000\u0000\u0000\u020c\u01ff\u0001\u0000\u0000"+
		"\u0000\u020d!\u0001\u0000\u0000\u0000\u020e\u020f\u0005\\\u0000\u0000"+
		"\u020f\u0214\u0003$\u0012\u0000\u0210\u0211\u0005\u0016\u0000\u0000\u0211"+
		"\u0213\u0003$\u0012\u0000\u0212\u0210\u0001\u0000\u0000\u0000\u0213\u0216"+
		"\u0001\u0000\u0000\u0000\u0214\u0212\u0001\u0000\u0000\u0000\u0214\u0215"+
		"\u0001\u0000\u0000\u0000\u0215#\u0001\u0000\u0000\u0000\u0216\u0214\u0001"+
		"\u0000\u0000\u0000\u0217\u021d\u0003&\u0013\u0000\u0218\u021c\u00030\u0018"+
		"\u0000\u0219\u021c\u0003,\u0016\u0000\u021a\u021c\u0003.\u0017\u0000\u021b"+
		"\u0218\u0001\u0000\u0000\u0000\u021b\u0219\u0001\u0000\u0000\u0000\u021b"+
		"\u021a\u0001\u0000\u0000\u0000\u021c\u021f\u0001\u0000\u0000\u0000\u021d"+
		"\u021b\u0001\u0000\u0000\u0000\u021d\u021e\u0001\u0000\u0000\u0000\u021e"+
		"%\u0001\u0000\u0000\u0000\u021f\u021d\u0001\u0000\u0000\u0000\u0220\u0222"+
		"\u0003(\u0014\u0000\u0221\u0223\u0003*\u0015\u0000\u0222\u0221\u0001\u0000"+
		"\u0000\u0000\u0222\u0223\u0001\u0000\u0000\u0000\u0223\u022b\u0001\u0000"+
		"\u0000\u0000\u0224\u0225\u0005\u0018\u0000\u0000\u0225\u0226\u0003\u0004"+
		"\u0002\u0000\u0226\u0228\u0005\u0019\u0000\u0000\u0227\u0229\u0003*\u0015"+
		"\u0000\u0228\u0227\u0001\u0000\u0000\u0000\u0228\u0229\u0001\u0000\u0000"+
		"\u0000\u0229\u022b\u0001\u0000\u0000\u0000\u022a\u0220\u0001\u0000\u0000"+
		"\u0000\u022a\u0224\u0001\u0000\u0000\u0000\u022b\'\u0001\u0000\u0000\u0000"+
		"\u022c\u0231\u0003\u016a\u00b5\u0000\u022d\u022e\u0005\u0017\u0000\u0000"+
		"\u022e\u0230\u0003\u016a\u00b5\u0000\u022f\u022d\u0001\u0000\u0000\u0000"+
		"\u0230\u0233\u0001\u0000\u0000\u0000\u0231\u022f\u0001\u0000\u0000\u0000"+
		"\u0231\u0232\u0001\u0000\u0000\u0000\u0232)\u0001\u0000\u0000\u0000\u0233"+
		"\u0231\u0001\u0000\u0000\u0000\u0234\u0235\u00052\u0000\u0000\u0235\u0238"+
		"\u0003\u016a\u00b5\u0000\u0236\u0238\u0003\u0168\u00b4\u0000\u0237\u0234"+
		"\u0001\u0000\u0000\u0000\u0237\u0236\u0001\u0000\u0000\u0000\u0238+\u0001"+
		"\u0000\u0000\u0000\u0239\u023a\u0005<\u0000\u0000\u023a\u023b\u0005n\u0000"+
		"\u0000\u023b\u023d\u0003(\u0014\u0000\u023c\u023e\u0003*\u0015\u0000\u023d"+
		"\u023c\u0001\u0000\u0000\u0000\u023d\u023e\u0001\u0000\u0000\u0000\u023e"+
		"-\u0001\u0000\u0000\u0000\u023f\u0240\u0005\u0016\u0000\u0000\u0240\u0241"+
		"\u0005e\u0000\u0000\u0241\u0242\u0005\u0018\u0000\u0000\u0242\u0243\u0003"+
		"R)\u0000\u0243\u0245\u0005\u0019\u0000\u0000\u0244\u0246\u0003*\u0015"+
		"\u0000\u0245\u0244\u0001\u0000\u0000\u0000\u0245\u0246\u0001\u0000\u0000"+
		"\u0000\u0246/\u0001\u0000\u0000\u0000\u0247\u0248\u00032\u0019\u0000\u0248"+
		"\u024a\u0005n\u0000\u0000\u0249\u024b\u0005V\u0000\u0000\u024a\u0249\u0001"+
		"\u0000\u0000\u0000\u024a\u024b\u0001\u0000\u0000\u0000\u024b\u024c\u0001"+
		"\u0000\u0000\u0000\u024c\u024e\u00034\u001a\u0000\u024d\u024f\u00036\u001b"+
		"\u0000\u024e\u024d\u0001\u0000\u0000\u0000\u024e\u024f\u0001\u0000\u0000"+
		"\u0000\u024f1\u0001\u0000\u0000\u0000\u0250\u0252\u0005h\u0000\u0000\u0251"+
		"\u0250\u0001\u0000\u0000\u0000\u0251\u0252\u0001\u0000\u0000\u0000\u0252"+
		"\u025a\u0001\u0000\u0000\u0000\u0253\u0255\u0007\u0000\u0000\u0000\u0254"+
		"\u0253\u0001\u0000\u0000\u0000\u0254\u0255\u0001\u0000\u0000\u0000\u0255"+
		"\u0257\u0001\u0000\u0000\u0000\u0256\u0258\u0005\u0097\u0000\u0000\u0257"+
		"\u0256\u0001\u0000\u0000\u0000\u0257\u0258\u0001\u0000\u0000\u0000\u0258"+
		"\u025a\u0001\u0000\u0000\u0000\u0259\u0251\u0001\u0000\u0000\u0000\u0259"+
		"\u0254\u0001\u0000\u0000\u0000\u025a3\u0001\u0000\u0000\u0000\u025b\u025d"+
		"\u0003R)\u0000\u025c\u025e\u0003*\u0015\u0000\u025d\u025c\u0001\u0000"+
		"\u0000\u0000\u025d\u025e\u0001\u0000\u0000\u0000\u025e\u0269\u0001\u0000"+
		"\u0000\u0000\u025f\u0261\u0005q\u0000\u0000\u0260\u025f\u0001\u0000\u0000"+
		"\u0000\u0260\u0261\u0001\u0000\u0000\u0000\u0261\u0262\u0001\u0000\u0000"+
		"\u0000\u0262\u0263\u0005\u0018\u0000\u0000\u0263\u0264\u0003\u0004\u0002"+
		"\u0000\u0264\u0266\u0005\u0019\u0000\u0000\u0265\u0267\u0003*\u0015\u0000"+
		"\u0266\u0265\u0001\u0000\u0000\u0000\u0266\u0267\u0001\u0000\u0000\u0000"+
		"\u0267\u0269\u0001\u0000\u0000\u0000\u0268\u025b\u0001\u0000\u0000\u0000"+
		"\u0268\u0260\u0001\u0000\u0000\u0000\u02695\u0001\u0000\u0000\u0000\u026a"+
		"\u026b\u0007\u0001\u0000\u0000\u026b\u026c\u0003\u0084B\u0000\u026c7\u0001"+
		"\u0000\u0000\u0000\u026d\u026f\u0005\u00a9\u0000\u0000\u026e\u0270\u0005"+
		"H\u0000\u0000\u026f\u026e\u0001\u0000\u0000\u0000\u026f\u0270\u0001\u0000"+
		"\u0000\u0000\u0270\u0271\u0001\u0000\u0000\u0000\u0271\u0272\u0003:\u001d"+
		"\u0000\u02729\u0001\u0000\u0000\u0000\u0273\u0278\u0003<\u001e\u0000\u0274"+
		"\u0275\u0005\u0016\u0000\u0000\u0275\u0277\u0003<\u001e\u0000\u0276\u0274"+
		"\u0001\u0000\u0000\u0000\u0277\u027a\u0001\u0000\u0000\u0000\u0278\u0276"+
		"\u0001\u0000\u0000\u0000\u0278\u0279\u0001\u0000\u0000\u0000\u0279;\u0001"+
		"\u0000\u0000\u0000\u027a\u0278\u0001\u0000\u0000\u0000\u027b\u027d\u0003"+
		">\u001f\u0000\u027c\u027e\u0003*\u0015\u0000\u027d\u027c\u0001\u0000\u0000"+
		"\u0000\u027d\u027e\u0001\u0000\u0000\u0000\u027e=\u0001\u0000\u0000\u0000"+
		"\u027f\u0284\u0003B!\u0000\u0280\u0284\u0003@ \u0000\u0281\u0284\u0003"+
		"L&\u0000\u0282\u0284\u0003\u0090H\u0000\u0283\u027f\u0001\u0000\u0000"+
		"\u0000\u0283\u0280\u0001\u0000\u0000\u0000\u0283\u0281\u0001\u0000\u0000"+
		"\u0000\u0283\u0282\u0001\u0000\u0000\u0000\u0284?\u0001\u0000\u0000\u0000"+
		"\u0285\u0286\u0005N\u0000\u0000\u0286\u0287\u0005\u0018\u0000\u0000\u0287"+
		"\u0288\u0003R)\u0000\u0288\u0289\u0005\u0019\u0000\u0000\u0289A\u0001"+
		"\u0000\u0000\u0000\u028a\u028b\u0005\u0089\u0000\u0000\u028b\u028c\u0003"+
		"D\"\u0000\u028c\u028d\u0005\u0018\u0000\u0000\u028d\u028e\u0003F#\u0000"+
		"\u028e\u028f\u0005\u0019\u0000\u0000\u028fC\u0001\u0000\u0000\u0000\u0290"+
		"\u0294\u0005v\u0000\u0000\u0291\u0294\u0005|\u0000\u0000\u0292\u0294\u0003"+
		"N\'\u0000\u0293\u0290\u0001\u0000\u0000\u0000\u0293\u0291\u0001\u0000"+
		"\u0000\u0000\u0293\u0292\u0001\u0000\u0000\u0000\u0294E\u0001\u0000\u0000"+
		"\u0000\u0295\u029a\u0003H$\u0000\u0296\u0297\u0005\u0016\u0000\u0000\u0297"+
		"\u0299\u0003H$\u0000\u0298\u0296\u0001\u0000\u0000\u0000\u0299\u029c\u0001"+
		"\u0000\u0000\u0000\u029a\u0298\u0001\u0000\u0000\u0000\u029a\u029b\u0001"+
		"\u0000\u0000\u0000\u029bG\u0001\u0000\u0000\u0000\u029c\u029a\u0001\u0000"+
		"\u0000\u0000\u029d\u029f\u0003J%\u0000\u029e\u02a0\u0003*\u0015\u0000"+
		"\u029f\u029e\u0001\u0000\u0000\u0000\u029f\u02a0\u0001\u0000\u0000\u0000"+
		"\u02a0I\u0001\u0000\u0000\u0000\u02a1\u02a4\u0003\u0090H\u0000\u02a2\u02a4"+
		"\u0003B!\u0000\u02a3\u02a1\u0001\u0000\u0000\u0000\u02a3\u02a2\u0001\u0000"+
		"\u0000\u0000\u02a4K\u0001\u0000\u0000\u0000\u02a5\u02a6\u0005\u008e\u0000"+
		"\u0000\u02a6\u02a7\u0005\u0018\u0000\u0000\u02a7\u02a8\u0003\u016a\u00b5"+
		"\u0000\u02a8\u02a9\u0005\u0019\u0000\u0000\u02a9M\u0001\u0000\u0000\u0000"+
		"\u02aa\u02ae\u0003\u016a\u00b5\u0000\u02ab\u02ad\u0003P(\u0000\u02ac\u02ab"+
		"\u0001\u0000\u0000\u0000\u02ad\u02b0\u0001\u0000\u0000\u0000\u02ae\u02ac"+
		"\u0001\u0000\u0000\u0000\u02ae\u02af\u0001\u0000\u0000\u0000\u02afO\u0001"+
		"\u0000\u0000\u0000\u02b0\u02ae\u0001\u0000\u0000\u0000\u02b1\u02b2\u0005"+
		"\u0017\u0000\u0000\u02b2\u02b3\u0003\u016a\u00b5\u0000\u02b3Q\u0001\u0000"+
		"\u0000\u0000\u02b4\u02b6\u0003V+\u0000\u02b5\u02b7\u0003T*\u0000\u02b6"+
		"\u02b5\u0001\u0000\u0000\u0000\u02b6\u02b7\u0001\u0000\u0000\u0000\u02b7"+
		"\u02ba\u0001\u0000\u0000\u0000\u02b8\u02ba\u0003X,\u0000\u02b9\u02b4\u0001"+
		"\u0000\u0000\u0000\u02b9\u02b8\u0001\u0000\u0000\u0000\u02baS\u0001\u0000"+
		"\u0000\u0000\u02bb\u02bc\u0005\u0017\u0000\u0000\u02bc\u02bd\u0003N\'"+
		"\u0000\u02bdU\u0001\u0000\u0000\u0000\u02be\u02c5\u0003\\.\u0000\u02bf"+
		"\u02c5\u0003^/\u0000\u02c0\u02c5\u0003`0\u0000\u02c1\u02c2\u0003N\'\u0000"+
		"\u02c2\u02c3\u0003Z-\u0000\u02c3\u02c5\u0001\u0000\u0000\u0000\u02c4\u02be"+
		"\u0001\u0000\u0000\u0000\u02c4\u02bf\u0001\u0000\u0000\u0000\u02c4\u02c0"+
		"\u0001\u0000\u0000\u0000\u02c4\u02c1\u0001\u0000\u0000\u0000\u02c5W\u0001"+
		"\u0000\u0000\u0000\u02c6\u02c8\u0003N\'\u0000\u02c7\u02c9\u0003Z-\u0000"+
		"\u02c8\u02c7\u0001\u0000\u0000\u0000\u02c8\u02c9\u0001\u0000\u0000\u0000"+
		"\u02c9Y\u0001\u0000\u0000\u0000\u02ca\u02cb\u0005\u001a\u0000\u0000\u02cb"+
		"\u02cc\u0003\u008cF\u0000\u02cc\u02cf\u0005\u001b\u0000\u0000\u02cd\u02ce"+
		"\u0005\u0017\u0000\u0000\u02ce\u02d0\u0003X,\u0000\u02cf\u02cd\u0001\u0000"+
		"\u0000\u0000\u02cf\u02d0\u0001\u0000\u0000\u0000\u02d0[\u0001\u0000\u0000"+
		"\u0000\u02d1\u02d2\u0005\u00b6\u0000\u0000\u02d2\u02d3\u0005\u0018\u0000"+
		"\u0000\u02d3\u02d4\u0003R)\u0000\u02d4\u02d5\u00052\u0000\u0000\u02d5"+
		"\u02d6\u0003N\'\u0000\u02d6\u02d8\u0005\u0019\u0000\u0000\u02d7\u02d9"+
		"\u0003T*\u0000\u02d8\u02d7\u0001\u0000\u0000\u0000\u02d8\u02d9\u0001\u0000"+
		"\u0000\u0000\u02d9]\u0001\u0000\u0000\u0000\u02da\u02db\u0007\u0002\u0000"+
		"\u0000\u02db\u02dc\u0005\u0018\u0000\u0000\u02dc\u02dd\u0003R)\u0000\u02dd"+
		"\u02df\u0005\u0019\u0000\u0000\u02de\u02e0\u0003T*\u0000\u02df\u02de\u0001"+
		"\u0000\u0000\u0000\u02df\u02e0\u0001\u0000\u0000\u0000\u02e0_\u0001\u0000"+
		"\u0000\u0000\u02e1\u02e2\u0007\u0003\u0000\u0000\u02e2\u02e3\u0005\u0018"+
		"\u0000\u0000\u02e3\u02e4\u0003R)\u0000\u02e4\u02e6\u0005\u0019\u0000\u0000"+
		"\u02e5\u02e7\u0003T*\u0000\u02e6\u02e5\u0001\u0000\u0000\u0000\u02e6\u02e7"+
		"\u0001\u0000\u0000\u0000\u02e7a\u0001\u0000\u0000\u0000\u02e8\u02e9\u0005"+
		"_\u0000\u0000\u02e9\u02ea\u00057\u0000\u0000\u02ea\u02ef\u0003d2\u0000"+
		"\u02eb\u02ec\u0005\u0016\u0000\u0000\u02ec\u02ee\u0003d2\u0000\u02ed\u02eb"+
		"\u0001\u0000\u0000\u0000\u02ee\u02f1\u0001\u0000\u0000\u0000\u02ef\u02ed"+
		"\u0001\u0000\u0000\u0000\u02ef\u02f0\u0001\u0000\u0000\u0000\u02f0c\u0001"+
		"\u0000\u0000\u0000\u02f1\u02ef\u0001\u0000\u0000\u0000\u02f2\u02f6\u0003"+
		"\u016a\u00b5\u0000\u02f3\u02f6\u0005\u0003\u0000\u0000\u02f4\u02f6\u0003"+
		"\u008cF\u0000\u02f5\u02f2\u0001\u0000\u0000\u0000\u02f5\u02f3\u0001\u0000"+
		"\u0000\u0000\u02f5\u02f4\u0001\u0000\u0000\u0000\u02f6e\u0001\u0000\u0000"+
		"\u0000\u02f7\u02f8\u0005a\u0000\u0000\u02f8\u02f9\u0003\u0084B\u0000\u02f9"+
		"g\u0001\u0000\u0000\u0000\u02fa\u02fb\u0005\u0095\u0000\u0000\u02fb\u02fc"+
		"\u00057\u0000\u0000\u02fc\u0301\u0003l6\u0000\u02fd\u02fe\u0005\u0016"+
		"\u0000\u0000\u02fe\u0300\u0003l6\u0000\u02ff\u02fd\u0001\u0000\u0000\u0000"+
		"\u0300\u0303\u0001\u0000\u0000\u0000\u0301\u02ff\u0001\u0000\u0000\u0000"+
		"\u0301\u0302\u0001\u0000\u0000\u0000\u0302i\u0001\u0000\u0000\u0000\u0303"+
		"\u0301\u0001\u0000\u0000\u0000\u0304\u0309\u0003l6\u0000\u0305\u0306\u0005"+
		"\u0016\u0000\u0000\u0306\u0308\u0003l6\u0000\u0307\u0305\u0001\u0000\u0000"+
		"\u0000\u0308\u030b\u0001\u0000\u0000\u0000\u0309\u0307\u0001\u0000\u0000"+
		"\u0000\u0309\u030a\u0001\u0000\u0000\u0000\u030ak\u0001\u0000\u0000\u0000"+
		"\u030b\u0309\u0001\u0000\u0000\u0000\u030c\u030e\u0003p8\u0000\u030d\u030f"+
		"\u0003r9\u0000\u030e\u030d\u0001\u0000\u0000\u0000\u030e\u030f\u0001\u0000"+
		"\u0000\u0000\u030f\u0311\u0001\u0000\u0000\u0000\u0310\u0312\u0003n7\u0000"+
		"\u0311\u0310\u0001\u0000\u0000\u0000\u0311\u0312\u0001\u0000\u0000\u0000"+
		"\u0312m\u0001\u0000\u0000\u0000\u0313\u0314\u0005\u008d\u0000\u0000\u0314"+
		"\u0315\u0007\u0004\u0000\u0000\u0315o\u0001\u0000\u0000\u0000\u0316\u031a"+
		"\u0003\u016a\u00b5\u0000\u0317\u031a\u0005\u0003\u0000\u0000\u0318\u031a"+
		"\u0003\u008cF\u0000\u0319\u0316\u0001\u0000\u0000\u0000\u0319\u0317\u0001"+
		"\u0000\u0000\u0000\u0319\u0318\u0001\u0000\u0000\u0000\u031aq\u0001\u0000"+
		"\u0000\u0000\u031b\u031c\u0007\u0005\u0000\u0000\u031cs\u0001\u0000\u0000"+
		"\u0000\u031d\u031e\u0005:\u0000\u0000\u031e\u031f\u0005\u0018\u0000\u0000"+
		"\u031f\u0320\u0003\u008cF\u0000\u0320\u0321\u00052\u0000\u0000\u0321\u0322"+
		"\u0003v;\u0000\u0322\u0323\u0005\u0019\u0000\u0000\u0323u\u0001\u0000"+
		"\u0000\u0000\u0324\u0325\u0003N\'\u0000\u0325w\u0001\u0000\u0000\u0000"+
		"\u0326\u0327\u0005u\u0000\u0000\u0327\u0328\u0003~?\u0000\u0328y\u0001"+
		"\u0000\u0000\u0000\u0329\u032a\u0005\u0090\u0000\u0000\u032a\u032c\u0003"+
		"~?\u0000\u032b\u032d\u0007\u0006\u0000\u0000\u032c\u032b\u0001\u0000\u0000"+
		"\u0000\u032c\u032d\u0001\u0000\u0000\u0000\u032d{\u0001\u0000\u0000\u0000"+
		"\u032e\u032f\u0005V\u0000\u0000\u032f\u0334\u0007\u0007\u0000\u0000\u0330"+
		"\u0335\u0003~?\u0000\u0331\u0332\u0003\u0080@\u0000\u0332\u0333\u0005"+
		"\u009d\u0000\u0000\u0333\u0335\u0001\u0000\u0000\u0000\u0334\u0330\u0001"+
		"\u0000\u0000\u0000\u0334\u0331\u0001\u0000\u0000\u0000\u0335\u0336\u0001"+
		"\u0000\u0000\u0000\u0336\u033a\u0007\u0006\u0000\u0000\u0337\u033b\u0005"+
		"\u0093\u0000\u0000\u0338\u0339\u0005\u00c2\u0000\u0000\u0339\u033b\u0005"+
		"\u00b0\u0000\u0000\u033a\u0337\u0001\u0000\u0000\u0000\u033a\u0338\u0001"+
		"\u0000\u0000\u0000\u033b}\u0001\u0000\u0000\u0000\u033c\u033f\u0003\u00e2"+
		"q\u0000\u033d\u033f\u0005\u0003\u0000\u0000\u033e\u033c\u0001\u0000\u0000"+
		"\u0000\u033e\u033d\u0001\u0000\u0000\u0000\u033f\u007f\u0001\u0000\u0000"+
		"\u0000\u0340\u0345\u0003\u00e2q\u0000\u0341\u0345\u0005\u0003\u0000\u0000"+
		"\u0342\u0345\u0005\u0005\u0000\u0000\u0343\u0345\u0005\u0006\u0000\u0000"+
		"\u0344\u0340\u0001\u0000\u0000\u0000\u0344\u0341\u0001\u0000\u0000\u0000"+
		"\u0344\u0342\u0001\u0000\u0000\u0000\u0344\u0343\u0001\u0000\u0000\u0000"+
		"\u0345\u0081\u0001\u0000\u0000\u0000\u0346\u0347\u0005\u00c1\u0000\u0000"+
		"\u0347\u0348\u0003\u0084B\u0000\u0348\u0083\u0001\u0000\u0000\u0000\u0349"+
		"\u034a\u0006B\uffff\uffff\u0000\u034a\u034b\u0005\u0018\u0000\u0000\u034b"+
		"\u034c\u0003\u0084B\u0000\u034c\u034d\u0005\u0019\u0000\u0000\u034d\u038f"+
		"\u0001\u0000\u0000\u0000\u034e\u034f\u0003\u008cF\u0000\u034f\u0351\u0005"+
		"m\u0000\u0000\u0350\u0352\u0005\u008c\u0000\u0000\u0351\u0350\u0001\u0000"+
		"\u0000\u0000\u0351\u0352\u0001\u0000\u0000\u0000\u0352\u0353\u0001\u0000"+
		"\u0000\u0000\u0353\u0354\u0005\u00c8\u0000\u0000\u0354\u038f\u0001\u0000"+
		"\u0000\u0000\u0355\u0356\u0003\u008cF\u0000\u0356\u0358\u0005m\u0000\u0000"+
		"\u0357\u0359\u0005\u008c\u0000\u0000\u0358\u0357\u0001\u0000\u0000\u0000"+
		"\u0358\u0359\u0001\u0000\u0000\u0000\u0359\u035a\u0001\u0000\u0000\u0000"+
		"\u035a\u035b\u0005L\u0000\u0000\u035b\u038f\u0001\u0000\u0000\u0000\u035c"+
		"\u035e\u0003\u008cF\u0000\u035d\u035f\u0005\u008c\u0000\u0000\u035e\u035d"+
		"\u0001\u0000\u0000\u0000\u035e\u035f\u0001\u0000\u0000\u0000\u035f\u0360"+
		"\u0001\u0000\u0000\u0000\u0360\u0361\u0005e\u0000\u0000\u0361\u0362\u0003"+
		"\u0088D\u0000\u0362\u038f\u0001\u0000\u0000\u0000\u0363\u0365\u0003\u008c"+
		"F\u0000\u0364\u0366\u0005\u008c\u0000\u0000\u0365\u0364\u0001\u0000\u0000"+
		"\u0000\u0365\u0366\u0001\u0000\u0000\u0000\u0366\u0367\u0001\u0000\u0000"+
		"\u0000\u0367\u0368\u00055\u0000\u0000\u0368\u0369\u0003\u008cF\u0000\u0369"+
		"\u036a\u00050\u0000\u0000\u036a\u036b\u0003\u008cF\u0000\u036b\u038f\u0001"+
		"\u0000\u0000\u0000\u036c\u036e\u0003\u008cF\u0000\u036d\u036f\u0005\u008c"+
		"\u0000\u0000\u036e\u036d\u0001\u0000\u0000\u0000\u036e\u036f\u0001\u0000"+
		"\u0000\u0000\u036f\u0370\u0001\u0000\u0000\u0000\u0370\u0371\u0007\b\u0000"+
		"\u0000\u0371\u0373\u0003\u008cF\u0000\u0372\u0374\u0003\u008aE\u0000\u0373"+
		"\u0372\u0001\u0000\u0000\u0000\u0373\u0374\u0001\u0000\u0000\u0000\u0374"+
		"\u038f\u0001\u0000\u0000\u0000\u0375\u0376\u0003\u008cF\u0000\u0376\u0377"+
		"\u0003\u0086C\u0000\u0377\u0378\u0003\u008cF\u0000\u0378\u038f\u0001\u0000"+
		"\u0000\u0000\u0379\u037a\u0005T\u0000\u0000\u037a\u037b\u0007\t\u0000"+
		"\u0000\u037b\u037c\u0005\u0018\u0000\u0000\u037c\u037d\u0003N\'\u0000"+
		"\u037d\u037e\u0005\u0019\u0000\u0000\u037e\u038f\u0001\u0000\u0000\u0000"+
		"\u037f\u0380\u0005T\u0000\u0000\u0380\u038f\u0003\u008cF\u0000\u0381\u0383"+
		"\u0003\u008cF\u0000\u0382\u0384\u0005\u008c\u0000\u0000\u0383\u0382\u0001"+
		"\u0000\u0000\u0000\u0383\u0384\u0001\u0000\u0000\u0000\u0384\u0385\u0001"+
		"\u0000\u0000\u0000\u0385\u0387\u0005\u0080\u0000\u0000\u0386\u0388\u0005"+
		"\u008f\u0000\u0000\u0387\u0386\u0001\u0000\u0000\u0000\u0387\u0388\u0001"+
		"\u0000\u0000\u0000\u0388\u0389\u0001\u0000\u0000\u0000\u0389\u038a\u0003"+
		"R)\u0000\u038a\u038f\u0001\u0000\u0000\u0000\u038b\u038c\u0005\u008c\u0000"+
		"\u0000\u038c\u038f\u0003\u0084B\u0004\u038d\u038f\u0003\u008cF\u0000\u038e"+
		"\u0349\u0001\u0000\u0000\u0000\u038e\u034e\u0001\u0000\u0000\u0000\u038e"+
		"\u0355\u0001\u0000\u0000\u0000\u038e\u035c\u0001\u0000\u0000\u0000\u038e"+
		"\u0363\u0001\u0000\u0000\u0000\u038e\u036c\u0001\u0000\u0000\u0000\u038e"+
		"\u0375\u0001\u0000\u0000\u0000\u038e\u0379\u0001\u0000\u0000\u0000\u038e"+
		"\u037f\u0001\u0000\u0000\u0000\u038e\u0381\u0001\u0000\u0000\u0000\u038e"+
		"\u038b\u0001\u0000\u0000\u0000\u038e\u038d\u0001\u0000\u0000\u0000\u038f"+
		"\u0398\u0001\u0000\u0000\u0000\u0390\u0391\n\u0003\u0000\u0000\u0391\u0392"+
		"\u00050\u0000\u0000\u0392\u0397\u0003\u0084B\u0004\u0393\u0394\n\u0002"+
		"\u0000\u0000\u0394\u0395\u0005\u0094\u0000\u0000\u0395\u0397\u0003\u0084"+
		"B\u0003\u0396\u0390\u0001\u0000\u0000\u0000\u0396\u0393\u0001\u0000\u0000"+
		"\u0000\u0397\u039a\u0001\u0000\u0000\u0000\u0398\u0396\u0001\u0000\u0000"+
		"\u0000\u0398\u0399\u0001\u0000\u0000\u0000\u0399\u0085\u0001\u0000\u0000"+
		"\u0000\u039a\u0398\u0001\u0000\u0000\u0000\u039b\u03a9\u0005\u0010\u0000"+
		"\u0000\u039c\u03a9\u0005\u0011\u0000\u0000\u039d\u03a9\u0005\u0012\u0000"+
		"\u0000\u039e\u03a9\u0005\u0013\u0000\u0000\u039f\u03a9\u0005\u0014\u0000"+
		"\u0000\u03a0\u03a9\u0005\u0015\u0000\u0000\u03a1\u03a2\u0005m\u0000\u0000"+
		"\u03a2\u03a3\u0005H\u0000\u0000\u03a3\u03a9\u0005\\\u0000\u0000\u03a4"+
		"\u03a5\u0005m\u0000\u0000\u03a5\u03a6\u0005\u008c\u0000\u0000\u03a6\u03a7"+
		"\u0005H\u0000\u0000\u03a7\u03a9\u0005\\\u0000\u0000\u03a8\u039b\u0001"+
		"\u0000\u0000\u0000\u03a8\u039c\u0001\u0000\u0000\u0000\u03a8\u039d\u0001"+
		"\u0000\u0000\u0000\u03a8\u039e\u0001\u0000\u0000\u0000\u03a8\u039f\u0001"+
		"\u0000\u0000\u0000\u03a8\u03a0\u0001\u0000\u0000\u0000\u03a8\u03a1\u0001"+
		"\u0000\u0000\u0000\u03a8\u03a4\u0001\u0000\u0000\u0000\u03a9\u0087\u0001"+
		"\u0000\u0000\u0000\u03aa\u03ab\u0007\t\u0000\u0000\u03ab\u03ac\u0005\u0018"+
		"\u0000\u0000\u03ac\u03ad\u0003N\'\u0000\u03ad\u03ae\u0005\u0019\u0000"+
		"\u0000\u03ae\u03c1\u0001\u0000\u0000\u0000\u03af\u03b8\u0005\u0018\u0000"+
		"\u0000\u03b0\u03b5\u0003\u0090H\u0000\u03b1\u03b2\u0005\u0016\u0000\u0000"+
		"\u03b2\u03b4\u0003\u0090H\u0000\u03b3\u03b1\u0001\u0000\u0000\u0000\u03b4"+
		"\u03b7\u0001\u0000\u0000\u0000\u03b5\u03b3\u0001\u0000\u0000\u0000\u03b5"+
		"\u03b6\u0001\u0000\u0000\u0000\u03b6\u03b9\u0001\u0000\u0000\u0000\u03b7"+
		"\u03b5\u0001\u0000\u0000\u0000\u03b8\u03b0\u0001\u0000\u0000\u0000\u03b8"+
		"\u03b9\u0001\u0000\u0000\u0000\u03b9\u03ba\u0001\u0000\u0000\u0000\u03ba"+
		"\u03c1\u0005\u0019\u0000\u0000\u03bb\u03bc\u0005\u0018\u0000\u0000\u03bc"+
		"\u03bd\u0003\u0004\u0002\u0000\u03bd\u03be\u0005\u0019\u0000\u0000\u03be"+
		"\u03c1\u0001\u0000\u0000\u0000\u03bf\u03c1\u0003\u00e2q\u0000\u03c0\u03aa"+
		"\u0001\u0000\u0000\u0000\u03c0\u03af\u0001\u0000\u0000\u0000\u03c0\u03bb"+
		"\u0001\u0000\u0000\u0000\u03c0\u03bf\u0001\u0000\u0000\u0000\u03c1\u0089"+
		"\u0001\u0000\u0000\u0000\u03c2\u03c6\u0005P\u0000\u0000\u03c3\u03c7\u0005"+
		"\n\u0000\u0000\u03c4\u03c7\u0005\u000b\u0000\u0000\u03c5\u03c7\u0003\u00e2"+
		"q\u0000\u03c6\u03c3\u0001\u0000\u0000\u0000\u03c6\u03c4\u0001\u0000\u0000"+
		"\u0000\u03c6\u03c5\u0001\u0000\u0000\u0000\u03c7\u008b\u0001\u0000\u0000"+
		"\u0000\u03c8\u03c9\u0006F\uffff\uffff\u0000\u03c9\u03ca\u0005\u0018\u0000"+
		"\u0000\u03ca\u03cb\u0003\u008cF\u0000\u03cb\u03cc\u0005\u0019\u0000\u0000"+
		"\u03cc\u03e3\u0001\u0000\u0000\u0000\u03cd\u03ce\u0005\u0018\u0000\u0000"+
		"\u03ce\u03d1\u0003\u0090H\u0000\u03cf\u03d0\u0005\u0016\u0000\u0000\u03d0"+
		"\u03d2\u0003\u0090H\u0000\u03d1\u03cf\u0001\u0000\u0000\u0000\u03d2\u03d3"+
		"\u0001\u0000\u0000\u0000\u03d3\u03d1\u0001\u0000\u0000\u0000\u03d3\u03d4"+
		"\u0001\u0000\u0000\u0000\u03d4\u03d5\u0001\u0000\u0000\u0000\u03d5\u03d6"+
		"\u0005\u0019\u0000\u0000\u03d6\u03e3\u0001\u0000\u0000\u0000\u03d7\u03d8"+
		"\u0005\u0018\u0000\u0000\u03d8\u03d9\u0003\u0004\u0002\u0000\u03d9\u03da"+
		"\u0005\u0019\u0000\u0000\u03da\u03e3\u0001\u0000\u0000\u0000\u03db\u03e3"+
		"\u0003\u008eG\u0000\u03dc\u03dd\u0003\u0096K\u0000\u03dd\u03de\u0003\u00b2"+
		"Y\u0000\u03de\u03e3\u0001\u0000\u0000\u0000\u03df\u03e0\u0003\u0096K\u0000"+
		"\u03e0\u03e1\u0003\u008cF\u0006\u03e1\u03e3\u0001\u0000\u0000\u0000\u03e2"+
		"\u03c8\u0001\u0000\u0000\u0000\u03e2\u03cd\u0001\u0000\u0000\u0000\u03e2"+
		"\u03d7\u0001\u0000\u0000\u0000\u03e2\u03db\u0001\u0000\u0000\u0000\u03e2"+
		"\u03dc\u0001\u0000\u0000\u0000\u03e2\u03df\u0001\u0000\u0000\u0000\u03e3"+
		"\u03f6\u0001\u0000\u0000\u0000\u03e4\u03e5\n\u0003\u0000\u0000\u03e5\u03e6"+
		"\u0003\u0092I\u0000\u03e6\u03e7\u0003\u008cF\u0004\u03e7\u03f5\u0001\u0000"+
		"\u0000\u0000\u03e8\u03e9\n\u0002\u0000\u0000\u03e9\u03ea\u0003\u0094J"+
		"\u0000\u03ea\u03eb\u0003\u008cF\u0003\u03eb\u03f5\u0001\u0000\u0000\u0000"+
		"\u03ec\u03ed\n\u0001\u0000\u0000\u03ed\u03ee\u0005\'\u0000\u0000\u03ee"+
		"\u03f5\u0003\u008cF\u0002\u03ef\u03f0\n\u0005\u0000\u0000\u03f0\u03f5"+
		"\u0003\u0154\u00aa\u0000\u03f1\u03f2\n\u0004\u0000\u0000\u03f2\u03f3\u0005"+
		"7\u0000\u0000\u03f3\u03f5\u0003\u0154\u00aa\u0000\u03f4\u03e4\u0001\u0000"+
		"\u0000\u0000\u03f4\u03e8\u0001\u0000\u0000\u0000\u03f4\u03ec\u0001\u0000"+
		"\u0000\u0000\u03f4\u03ef\u0001\u0000\u0000\u0000\u03f4\u03f1\u0001\u0000"+
		"\u0000\u0000\u03f5\u03f8\u0001\u0000\u0000\u0000\u03f6\u03f4\u0001\u0000"+
		"\u0000\u0000\u03f6\u03f7\u0001\u0000\u0000\u0000\u03f7\u008d\u0001\u0000"+
		"\u0000\u0000\u03f8\u03f6\u0001\u0000\u0000\u0000\u03f9\u0408\u0003\u00a2"+
		"Q\u0000\u03fa\u0408\u0003\u00aeW\u0000\u03fb\u0408\u0003\u00e2q\u0000"+
		"\u03fc\u0408\u0003\u0098L\u0000\u03fd\u0408\u0003\u009aM\u0000\u03fe\u0408"+
		"\u0003\u009cN\u0000\u03ff\u0408\u0003\u009eO\u0000\u0400\u0408\u0003\u00a0"+
		"P\u0000\u0401\u0403\u0003V+\u0000\u0402\u0404\u0003T*\u0000\u0403\u0402"+
		"\u0001\u0000\u0000\u0000\u0403\u0404\u0001\u0000\u0000\u0000\u0404\u0408"+
		"\u0001\u0000\u0000\u0000\u0405\u0408\u0003\u00e4r\u0000\u0406\u0408\u0003"+
		"X,\u0000\u0407\u03f9\u0001\u0000\u0000\u0000\u0407\u03fa\u0001\u0000\u0000"+
		"\u0000\u0407\u03fb\u0001\u0000\u0000\u0000\u0407\u03fc\u0001\u0000\u0000"+
		"\u0000\u0407\u03fd\u0001\u0000\u0000\u0000\u0407\u03fe\u0001\u0000\u0000"+
		"\u0000\u0407\u03ff\u0001\u0000\u0000\u0000\u0407\u0400\u0001\u0000\u0000"+
		"\u0000\u0407\u0401\u0001\u0000\u0000\u0000\u0407\u0405\u0001\u0000\u0000"+
		"\u0000\u0407\u0406\u0001\u0000\u0000\u0000\u0408\u008f\u0001\u0000\u0000"+
		"\u0000\u0409\u040c\u0003\u008cF\u0000\u040a\u040c\u0003\u0084B\u0000\u040b"+
		"\u0409\u0001\u0000\u0000\u0000\u040b\u040a\u0001\u0000\u0000\u0000\u040c"+
		"\u0091\u0001\u0000\u0000\u0000\u040d\u040e\u0007\n\u0000\u0000\u040e\u0093"+
		"\u0001\u0000\u0000\u0000\u040f\u0410\u0007\u000b\u0000\u0000\u0410\u0095"+
		"\u0001\u0000\u0000\u0000\u0411\u0412\u0007\u000b\u0000\u0000\u0412\u0097"+
		"\u0001\u0000\u0000\u0000\u0413\u0414\u0005\u00b9\u0000\u0000\u0414\u0417"+
		"\u0005\u0018\u0000\u0000\u0415\u0418\u0003R)\u0000\u0416\u0418\u0003\u00e2"+
		"q\u0000\u0417\u0415\u0001\u0000\u0000\u0000\u0417\u0416\u0001\u0000\u0000"+
		"\u0000\u0418\u0419\u0001\u0000\u0000\u0000\u0419\u041a\u0005\u0019\u0000"+
		"\u0000\u041a\u0099\u0001\u0000\u0000\u0000\u041b\u041c\u0005*\u0000\u0000"+
		"\u041c\u041d\u0005\u0018\u0000\u0000\u041d\u041e\u0003R)\u0000\u041e\u0420"+
		"\u0005\u0019\u0000\u0000\u041f\u0421\u0003T*\u0000\u0420\u041f\u0001\u0000"+
		"\u0000\u0000\u0420\u0421\u0001\u0000\u0000\u0000\u0421\u009b\u0001\u0000"+
		"\u0000\u0000\u0422\u0423\u0005+\u0000\u0000\u0423\u0424\u0005\u0018\u0000"+
		"\u0000\u0424\u0425\u0003R)\u0000\u0425\u0426\u0005\u0019\u0000\u0000\u0426"+
		"\u009d\u0001\u0000\u0000\u0000\u0427\u0428\u0005-\u0000\u0000\u0428\u0429"+
		"\u0005\u0018\u0000\u0000\u0429\u042a\u0003R)\u0000\u042a\u042c\u0005\u0019"+
		"\u0000\u0000\u042b\u042d\u0003T*\u0000\u042c\u042b\u0001\u0000\u0000\u0000"+
		"\u042c\u042d\u0001\u0000\u0000\u0000\u042d\u009f\u0001\u0000\u0000\u0000"+
		"\u042e\u042f\u0005.\u0000\u0000\u042f\u0430\u0005\u0018\u0000\u0000\u0430"+
		"\u0431\u0003R)\u0000\u0431\u0432\u0005\u0019\u0000\u0000\u0432\u00a1\u0001"+
		"\u0000\u0000\u0000\u0433\u0436\u0003\u00a4R\u0000\u0434\u0436\u0003\u00aa"+
		"U\u0000\u0435\u0433\u0001\u0000\u0000\u0000\u0435\u0434\u0001\u0000\u0000"+
		"\u0000\u0436\u00a3\u0001\u0000\u0000\u0000\u0437\u0438\u00058\u0000\u0000"+
		"\u0438\u043a\u0003\u0090H\u0000\u0439\u043b\u0003\u00a6S\u0000\u043a\u0439"+
		"\u0001\u0000\u0000\u0000\u043b\u043c\u0001\u0000\u0000\u0000\u043c\u043a"+
		"\u0001\u0000\u0000\u0000\u043c\u043d\u0001\u0000\u0000\u0000\u043d\u043f"+
		"\u0001\u0000\u0000\u0000\u043e\u0440\u0003\u00a8T\u0000\u043f\u043e\u0001"+
		"\u0000\u0000\u0000\u043f\u0440\u0001\u0000\u0000\u0000\u0440\u0441\u0001"+
		"\u0000\u0000\u0000\u0441\u0442\u0005M\u0000\u0000\u0442\u00a5\u0001\u0000"+
		"\u0000\u0000\u0443\u0444\u0005\u00c0\u0000\u0000\u0444\u0445\u0003\u008c"+
		"F\u0000\u0445\u0446\u0005\u00af\u0000\u0000\u0446\u0447\u0003\u0090H\u0000"+
		"\u0447\u00a7\u0001\u0000\u0000\u0000\u0448\u0449\u0005K\u0000\u0000\u0449"+
		"\u044a\u0003\u0090H\u0000\u044a\u00a9\u0001\u0000\u0000\u0000\u044b\u044d"+
		"\u00058\u0000\u0000\u044c\u044e\u0003\u00acV\u0000\u044d\u044c\u0001\u0000"+
		"\u0000\u0000\u044e\u044f\u0001\u0000\u0000\u0000\u044f\u044d\u0001\u0000"+
		"\u0000\u0000\u044f\u0450\u0001\u0000\u0000\u0000\u0450\u0452\u0001\u0000"+
		"\u0000\u0000\u0451\u0453\u0003\u00a8T\u0000\u0452\u0451\u0001\u0000\u0000"+
		"\u0000\u0452\u0453\u0001\u0000\u0000\u0000\u0453\u0454\u0001\u0000\u0000"+
		"\u0000\u0454\u0455\u0005M\u0000\u0000\u0455\u00ab\u0001\u0000\u0000\u0000"+
		"\u0456\u0457\u0005\u00c0\u0000\u0000\u0457\u0458\u0003\u0084B\u0000\u0458"+
		"\u0459\u0005\u00af\u0000\u0000\u0459\u045a\u0003\u0090H\u0000\u045a\u00ad"+
		"\u0001\u0000\u0000\u0000\u045b\u0464\u0005\n\u0000\u0000\u045c\u0464\u0005"+
		"\u000b\u0000\u0000\u045d\u0464\u0005\u00c8\u0000\u0000\u045e\u0464\u0003"+
		"\u00b0X\u0000\u045f\u0464\u0003\u00b2Y\u0000\u0460\u0464\u0003\u00b4Z"+
		"\u0000\u0461\u0464\u0003\u00b6[\u0000\u0462\u0464\u0003\u00dcn\u0000\u0463"+
		"\u045b\u0001\u0000\u0000\u0000\u0463\u045c\u0001\u0000\u0000\u0000\u0463"+
		"\u045d\u0001\u0000\u0000\u0000\u0463\u045e\u0001\u0000\u0000\u0000\u0463"+
		"\u045f\u0001\u0000\u0000\u0000\u0463\u0460\u0001\u0000\u0000\u0000\u0463"+
		"\u0461\u0001\u0000\u0000\u0000\u0463\u0462\u0001\u0000\u0000\u0000\u0464"+
		"\u00af\u0001\u0000\u0000\u0000\u0465\u0466\u0007\f\u0000\u0000\u0466\u00b1"+
		"\u0001\u0000\u0000\u0000\u0467\u0468\u0007\r\u0000\u0000\u0468\u00b3\u0001"+
		"\u0000\u0000\u0000\u0469\u0475\u0005\f\u0000\u0000\u046a\u046b\u0005\u001c"+
		"\u0000\u0000\u046b\u0470\u0005\t\u0000\u0000\u046c\u046d\u0005\u0016\u0000"+
		"\u0000\u046d\u046f\u0005\t\u0000\u0000\u046e\u046c\u0001\u0000\u0000\u0000"+
		"\u046f\u0472\u0001\u0000\u0000\u0000\u0470\u046e\u0001\u0000\u0000\u0000"+
		"\u0470\u0471\u0001\u0000\u0000\u0000\u0471\u0473\u0001\u0000\u0000\u0000"+
		"\u0472\u0470\u0001\u0000\u0000\u0000\u0473\u0475\u0005\u001d\u0000\u0000"+
		"\u0474\u0469\u0001\u0000\u0000\u0000\u0474\u046a\u0001\u0000\u0000\u0000"+
		"\u0475\u00b5\u0001\u0000\u0000\u0000\u0476\u047d\u0003\u00b8\\\u0000\u0477"+
		"\u047d\u0003\u00ba]\u0000\u0478\u047d\u0003\u00bc^\u0000\u0479\u047d\u0003"+
		"\u00d4j\u0000\u047a\u047d\u0003\u00d6k\u0000\u047b\u047d\u0003\u00d8l"+
		"\u0000\u047c\u0476\u0001\u0000\u0000\u0000\u047c\u0477\u0001\u0000\u0000"+
		"\u0000\u047c\u0478\u0001\u0000\u0000\u0000\u047c\u0479\u0001\u0000\u0000"+
		"\u0000\u047c\u047a\u0001\u0000\u0000\u0000\u047c\u047b\u0001\u0000\u0000"+
		"\u0000\u047d\u00b7\u0001\u0000\u0000\u0000\u047e\u047f\u0005\u001c\u0000"+
		"\u0000\u047f\u0480\u0003\u00be_\u0000\u0480\u0481\u0005\u001d\u0000\u0000"+
		"\u0481\u0485\u0001\u0000\u0000\u0000\u0482\u0483\u0005D\u0000\u0000\u0483"+
		"\u0485\u0003\u00be_\u0000\u0484\u047e\u0001\u0000\u0000\u0000\u0484\u0482"+
		"\u0001\u0000\u0000\u0000\u0485\u00b9\u0001\u0000\u0000\u0000\u0486\u0487"+
		"\u0005\u001c\u0000\u0000\u0487\u0488\u0003\u00c0`\u0000\u0488\u0489\u0005"+
		"\u001d\u0000\u0000\u0489\u048d\u0001\u0000\u0000\u0000\u048a\u048b\u0005"+
		"C\u0000\u0000\u048b\u048d\u0003\u00c0`\u0000\u048c\u0486\u0001\u0000\u0000"+
		"\u0000\u048c\u048a\u0001\u0000\u0000\u0000\u048d\u00bb\u0001\u0000\u0000"+
		"\u0000\u048e\u048f\u0005\u001c\u0000\u0000\u048f\u0490\u0003\u00c2a\u0000"+
		"\u0490\u0491\u0005\u001d\u0000\u0000\u0491\u0495\u0001\u0000\u0000\u0000"+
		"\u0492\u0493\u0005\u00b1\u0000\u0000\u0493\u0495\u0003\u00c2a\u0000\u0494"+
		"\u048e\u0001\u0000\u0000\u0000\u0494\u0492\u0001\u0000\u0000\u0000\u0495"+
		"\u00bd\u0001\u0000\u0000\u0000\u0496\u0497\u0003\u00c0`\u0000\u0497\u049a"+
		"\u0003\u00c2a\u0000\u0498\u049b\u0003\u00d2i\u0000\u0499\u049b\u0003\u00c4"+
		"b\u0000\u049a\u0498\u0001\u0000\u0000\u0000\u049a\u0499\u0001\u0000\u0000"+
		"\u0000\u049a\u049b\u0001\u0000\u0000\u0000\u049b\u00bf\u0001\u0000\u0000"+
		"\u0000\u049c\u049d\u0003\u00c6c\u0000\u049d\u049e\u0005\u001f\u0000\u0000"+
		"\u049e\u049f\u0003\u00c8d\u0000\u049f\u04a0\u0005\u001f\u0000\u0000\u04a0"+
		"\u04a1\u0003\u00cae\u0000\u04a1\u00c1\u0001\u0000\u0000\u0000\u04a2\u04a3"+
		"\u0003\u00ccf\u0000\u04a3\u04a4\u0005%\u0000\u0000\u04a4\u04a7\u0003\u00ce"+
		"g\u0000\u04a5\u04a6\u0005%\u0000\u0000\u04a6\u04a8\u0003\u00d0h\u0000"+
		"\u04a7\u04a5\u0001\u0000\u0000\u0000\u04a7\u04a8\u0001\u0000\u0000\u0000"+
		"\u04a8\u00c3\u0001\u0000\u0000\u0000\u04a9\u04aa\u0007\u000b\u0000\u0000"+
		"\u04aa\u04ad\u0003\u00ccf\u0000\u04ab\u04ac\u0005%\u0000\u0000\u04ac\u04ae"+
		"\u0003\u00ceg\u0000\u04ad\u04ab\u0001\u0000\u0000\u0000\u04ad\u04ae\u0001"+
		"\u0000\u0000\u0000\u04ae\u00c5\u0001\u0000\u0000\u0000\u04af\u04b0\u0005"+
		"\u0003\u0000\u0000\u04b0\u00c7\u0001\u0000\u0000\u0000\u04b1\u04b2\u0005"+
		"\u0003\u0000\u0000\u04b2\u00c9\u0001\u0000\u0000\u0000\u04b3\u04b4\u0005"+
		"\u0003\u0000\u0000\u04b4\u00cb\u0001\u0000\u0000\u0000\u04b5\u04b6\u0005"+
		"\u0003\u0000\u0000\u04b6\u00cd\u0001\u0000\u0000\u0000\u04b7\u04b8\u0005"+
		"\u0003\u0000\u0000\u04b8\u00cf\u0001\u0000\u0000\u0000\u04b9\u04ba\u0007"+
		"\u000e\u0000\u0000\u04ba\u00d1\u0001\u0000\u0000\u0000\u04bb\u04be\u0005"+
		"\u00c9\u0000\u0000\u04bc\u04bd\u0005!\u0000\u0000\u04bd\u04bf\u0005\u00c9"+
		"\u0000\u0000\u04be\u04bc\u0001\u0000\u0000\u0000\u04be\u04bf\u0001\u0000"+
		"\u0000\u0000\u04bf\u04c2\u0001\u0000\u0000\u0000\u04c0\u04c2\u0005\n\u0000"+
		"\u0000\u04c1\u04bb\u0001\u0000\u0000\u0000\u04c1\u04c0\u0001\u0000\u0000"+
		"\u0000\u04c2\u00d3\u0001\u0000\u0000\u0000\u04c3\u04c6\u0005\r\u0000\u0000"+
		"\u04c4\u04c7\u0003\u00be_\u0000\u04c5\u04c7\u0003\u00dam\u0000\u04c6\u04c4"+
		"\u0001\u0000\u0000\u0000\u04c6\u04c5\u0001\u0000\u0000\u0000\u04c7\u04c8"+
		"\u0001\u0000\u0000\u0000\u04c8\u04c9\u0005\u001d\u0000\u0000\u04c9\u00d5"+
		"\u0001\u0000\u0000\u0000\u04ca\u04cd\u0005\u000e\u0000\u0000\u04cb\u04ce"+
		"\u0003\u00c0`\u0000\u04cc\u04ce\u0003\u00dam\u0000\u04cd\u04cb\u0001\u0000"+
		"\u0000\u0000\u04cd\u04cc\u0001\u0000\u0000\u0000\u04ce\u04cf\u0001\u0000"+
		"\u0000\u0000\u04cf\u04d0\u0005\u001d\u0000\u0000\u04d0\u00d7\u0001\u0000"+
		"\u0000\u0000\u04d1\u04d4\u0005\u000f\u0000\u0000\u04d2\u04d5\u0003\u00c2"+
		"a\u0000\u04d3\u04d5\u0003\u00dam\u0000\u04d4\u04d2\u0001\u0000\u0000\u0000"+
		"\u04d4\u04d3\u0001\u0000\u0000\u0000\u04d5\u04d6\u0001\u0000\u0000\u0000"+
		"\u04d6\u04d7\u0005\u001d\u0000\u0000\u04d7\u00d9\u0001\u0000\u0000\u0000"+
		"\u04d8\u04d9\u0005\n\u0000\u0000\u04d9\u00db\u0001\u0000\u0000\u0000\u04da"+
		"\u04db\u0005\u001c\u0000\u0000\u04db\u04dc\u0003\u00deo\u0000\u04dc\u04dd"+
		"\u0005%\u0000\u0000\u04dd\u04de\u0003\u00e0p\u0000\u04de\u04df\u0005\u001d"+
		"\u0000\u0000\u04df\u00dd\u0001\u0000\u0000\u0000\u04e0\u04e1\u0005\n\u0000"+
		"\u0000\u04e1\u00df\u0001\u0000\u0000\u0000\u04e2\u04e3\u0005\n\u0000\u0000"+
		"\u04e3\u00e1\u0001\u0000\u0000\u0000\u04e4\u04e5\u0005%\u0000\u0000\u04e5"+
		"\u04eb\u0003\u016a\u00b5\u0000\u04e6\u04e8\u0005(\u0000\u0000\u04e7\u04e9"+
		"\u0005\u0003\u0000\u0000\u04e8\u04e7\u0001\u0000\u0000\u0000\u04e8\u04e9"+
		"\u0001\u0000\u0000\u0000\u04e9\u04eb\u0001\u0000\u0000\u0000\u04ea\u04e4"+
		"\u0001\u0000\u0000\u0000\u04ea\u04e6\u0001\u0000\u0000\u0000\u04eb\u00e3"+
		"\u0001\u0000\u0000\u0000\u04ec\u04f5\u0003\u0116\u008b\u0000\u04ed\u04f5"+
		"\u0003\u00f8|\u0000\u04ee\u04f5\u0003\u00f0x\u0000\u04ef\u04f5\u0003\u00f2"+
		"y\u0000\u04f0\u04f5\u0003\u00f4z\u0000\u04f1\u04f5\u0003\u00f6{\u0000"+
		"\u04f2\u04f5\u0003\u00e6s\u0000\u04f3\u04f5\u0003\u00eau\u0000\u04f4\u04ec"+
		"\u0001\u0000\u0000\u0000\u04f4\u04ed\u0001\u0000\u0000\u0000\u04f4\u04ee"+
		"\u0001\u0000\u0000\u0000\u04f4\u04ef\u0001\u0000\u0000\u0000\u04f4\u04f0"+
		"\u0001\u0000\u0000\u0000\u04f4\u04f1\u0001\u0000\u0000\u0000\u04f4\u04f2"+
		"\u0001\u0000\u0000\u0000\u04f4\u04f3\u0001\u0000\u0000\u0000\u04f5\u00e5"+
		"\u0001\u0000\u0000\u0000\u04f6\u04f7\u0005^\u0000\u0000\u04f7\u04f8\u0005"+
		"\u0018\u0000\u0000\u04f8\u04fb\u0003\u00e8t\u0000\u04f9\u04fa\u0005\u0016"+
		"\u0000\u0000\u04fa\u04fc\u0003\u00eew\u0000\u04fb\u04f9\u0001\u0000\u0000"+
		"\u0000\u04fb\u04fc\u0001\u0000\u0000\u0000\u04fc\u04fd\u0001\u0000\u0000"+
		"\u0000\u04fd\u04fe\u0005\u0019\u0000\u0000\u04fe\u00e7\u0001\u0000\u0000"+
		"\u0000\u04ff\u0500\u0005\n\u0000\u0000\u0500\u00e9\u0001\u0000\u0000\u0000"+
		"\u0501\u0502\u0003\u00ecv\u0000\u0502\u0505\u0005\u0018\u0000\u0000\u0503"+
		"\u0506\u0003\u00eew\u0000\u0504\u0506\u0005 \u0000\u0000\u0505\u0503\u0001"+
		"\u0000\u0000\u0000\u0505\u0504\u0001\u0000\u0000\u0000\u0505\u0506\u0001"+
		"\u0000\u0000\u0000\u0506\u0507\u0001\u0000\u0000\u0000\u0507\u0509\u0005"+
		"\u0019\u0000\u0000\u0508\u050a\u0003\u0108\u0084\u0000\u0509\u0508\u0001"+
		"\u0000\u0000\u0000\u0509\u050a\u0001\u0000\u0000\u0000\u050a\u050c\u0001"+
		"\u0000\u0000\u0000\u050b\u050d\u0003\u0106\u0083\u0000\u050c\u050b\u0001"+
		"\u0000\u0000\u0000\u050c\u050d\u0001\u0000\u0000\u0000\u050d\u050f\u0001"+
		"\u0000\u0000\u0000\u050e\u0510\u0003\u0102\u0081\u0000\u050f\u050e\u0001"+
		"\u0000\u0000\u0000\u050f\u0510\u0001\u0000\u0000\u0000\u0510\u0512\u0001"+
		"\u0000\u0000\u0000\u0511\u0513\u0003\u0104\u0082\u0000\u0512\u0511\u0001"+
		"\u0000\u0000\u0000\u0512\u0513\u0001\u0000\u0000\u0000\u0513\u0515\u0001"+
		"\u0000\u0000\u0000\u0514\u0516\u0003\u010a\u0085\u0000\u0515\u0514\u0001"+
		"\u0000\u0000\u0000\u0515\u0516\u0001\u0000\u0000\u0000\u0516\u00eb\u0001"+
		"\u0000\u0000\u0000\u0517\u0518\u0003N\'\u0000\u0518\u00ed\u0001\u0000"+
		"\u0000\u0000\u0519\u051e\u0005H\u0000\u0000\u051a\u051b\u0003\u0154\u00aa"+
		"\u0000\u051b\u051c\u0005\u0016\u0000\u0000\u051c\u051e\u0001\u0000\u0000"+
		"\u0000\u051d\u0519\u0001\u0000\u0000\u0000\u051d\u051a\u0001\u0000\u0000"+
		"\u0000\u051d\u051e\u0001\u0000\u0000\u0000\u051e\u051f\u0001\u0000\u0000"+
		"\u0000\u051f\u0524\u0003\u0090H\u0000\u0520\u0521\u0005\u0016\u0000\u0000"+
		"\u0521\u0523\u0003\u0090H\u0000\u0522\u0520\u0001\u0000\u0000\u0000\u0523"+
		"\u0526\u0001\u0000\u0000\u0000\u0524\u0522\u0001\u0000\u0000\u0000\u0524"+
		"\u0525\u0001\u0000\u0000\u0000\u0525\u00ef\u0001\u0000\u0000\u0000\u0526"+
		"\u0524\u0001\u0000\u0000\u0000\u0527\u0528\u0005\u00ab\u0000\u0000\u0528"+
		"\u0529\u0005\u0018\u0000\u0000\u0529\u052a\u0003R)\u0000\u052a\u052b\u0005"+
		"\u0019\u0000\u0000\u052b\u00f1\u0001\u0000\u0000\u0000\u052c\u052d\u0005"+
		"\u007f\u0000\u0000\u052d\u052e\u0005\u0018\u0000\u0000\u052e\u052f\u0003"+
		"R)\u0000\u052f\u0530\u0005\u0019\u0000\u0000\u0530\u0557\u0001\u0000\u0000"+
		"\u0000\u0531\u0532\u0005\u0085\u0000\u0000\u0532\u0533\u0005\u0018\u0000"+
		"\u0000\u0533\u0534\u0003R)\u0000\u0534\u0535\u0005\u0019\u0000\u0000\u0535"+
		"\u0557\u0001\u0000\u0000\u0000\u0536\u0537\u0005}\u0000\u0000\u0537\u0538"+
		"\u0005\u0018\u0000\u0000\u0538\u0539\u0005g\u0000\u0000\u0539\u053a\u0005"+
		"\u0018\u0000\u0000\u053a\u053b\u0003R)\u0000\u053b\u053c\u0005\u0019\u0000"+
		"\u0000\u053c\u053d\u0005\u0019\u0000\u0000\u053d\u0557\u0001\u0000\u0000"+
		"\u0000\u053e\u053f\u0005\u0083\u0000\u0000\u053f\u0540\u0005\u0018\u0000"+
		"\u0000\u0540\u0541\u0005g\u0000\u0000\u0541\u0542\u0005\u0018\u0000\u0000"+
		"\u0542\u0543\u0003R)\u0000\u0543\u0544\u0005\u0019\u0000\u0000\u0544\u0545"+
		"\u0005\u0019\u0000\u0000\u0545\u0557\u0001\u0000\u0000\u0000\u0546\u0547"+
		"\u0005\u00ae\u0000\u0000\u0547\u0548\u0005\u0018\u0000\u0000\u0548\u0549"+
		"\u0005g\u0000\u0000\u0549\u054a\u0005\u0018\u0000\u0000\u054a\u054b\u0003"+
		"R)\u0000\u054b\u054c\u0005\u0019\u0000\u0000\u054c\u054d\u0005\u0019\u0000"+
		"\u0000\u054d\u0557\u0001\u0000\u0000\u0000\u054e\u054f\u00054\u0000\u0000"+
		"\u054f\u0550\u0005\u0018\u0000\u0000\u0550\u0551\u0005g\u0000\u0000\u0551"+
		"\u0552\u0005\u0018\u0000\u0000\u0552\u0553\u0003R)\u0000\u0553\u0554\u0005"+
		"\u0019\u0000\u0000\u0554\u0555\u0005\u0019\u0000\u0000\u0555\u0557\u0001"+
		"\u0000\u0000\u0000\u0556\u052c\u0001\u0000\u0000\u0000\u0556\u0531\u0001"+
		"\u0000\u0000\u0000\u0556\u0536\u0001\u0000\u0000\u0000\u0556\u053e\u0001"+
		"\u0000\u0000\u0000\u0556\u0546\u0001\u0000\u0000\u0000\u0556\u054e\u0001"+
		"\u0000\u0000\u0000\u0557\u00f3\u0001\u0000\u0000\u0000\u0558\u0559\u0005"+
		"~\u0000\u0000\u0559\u055a\u0005\u0018\u0000\u0000\u055a\u055b\u0003R)"+
		"\u0000\u055b\u055c\u0005\u0019\u0000\u0000\u055c\u0583\u0001\u0000\u0000"+
		"\u0000\u055d\u055e\u0005\u0084\u0000\u0000\u055e\u055f\u0005\u0018\u0000"+
		"\u0000\u055f\u0560\u0003R)\u0000\u0560\u0561\u0005\u0019\u0000\u0000\u0561"+
		"\u0583\u0001\u0000\u0000\u0000\u0562\u0563\u0005}\u0000\u0000\u0563\u0564"+
		"\u0005\u0018\u0000\u0000\u0564\u0565\u0005J\u0000\u0000\u0565\u0566\u0005"+
		"\u0018\u0000\u0000\u0566\u0567\u0003R)\u0000\u0567\u0568\u0005\u0019\u0000"+
		"\u0000\u0568\u0569\u0005\u0019\u0000\u0000\u0569\u0583\u0001\u0000\u0000"+
		"\u0000\u056a\u056b\u0005\u0083\u0000\u0000\u056b\u056c\u0005\u0018\u0000"+
		"\u0000\u056c\u056d\u0005J\u0000\u0000\u056d\u056e\u0005\u0018\u0000\u0000"+
		"\u056e\u056f\u0003R)\u0000\u056f\u0570\u0005\u0019\u0000\u0000\u0570\u0571"+
		"\u0005\u0019\u0000\u0000\u0571\u0583\u0001\u0000\u0000\u0000\u0572\u0573"+
		"\u0005\u00ae\u0000\u0000\u0573\u0574\u0005\u0018\u0000\u0000\u0574\u0575"+
		"\u0005J\u0000\u0000\u0575\u0576\u0005\u0018\u0000\u0000\u0576\u0577\u0003"+
		"R)\u0000\u0577\u0578\u0005\u0019\u0000\u0000\u0578\u0579\u0005\u0019\u0000"+
		"\u0000\u0579\u0583\u0001\u0000\u0000\u0000\u057a\u057b\u00054\u0000\u0000"+
		"\u057b\u057c\u0005\u0018\u0000\u0000\u057c\u057d\u0005J\u0000\u0000\u057d"+
		"\u057e\u0005\u0018\u0000\u0000\u057e\u057f\u0003R)\u0000\u057f\u0580\u0005"+
		"\u0019\u0000\u0000\u0580\u0581\u0005\u0019\u0000\u0000\u0581\u0583\u0001"+
		"\u0000\u0000\u0000\u0582\u0558\u0001\u0000\u0000\u0000\u0582\u055d\u0001"+
		"\u0000\u0000\u0000\u0582\u0562\u0001\u0000\u0000\u0000\u0582\u056a\u0001"+
		"\u0000\u0000\u0000\u0582\u0572\u0001\u0000\u0000\u0000\u0582\u057a\u0001"+
		"\u0000\u0000\u0000\u0583\u00f5\u0001\u0000\u0000\u0000\u0584\u0585\u0005"+
		"J\u0000\u0000\u0585\u0586\u0005\u0018\u0000\u0000\u0586\u0587\u0003R)"+
		"\u0000\u0587\u0588\u0005\u0019\u0000\u0000\u0588\u058f\u0001\u0000\u0000"+
		"\u0000\u0589\u058a\u0005g\u0000\u0000\u058a\u058b\u0005\u0018\u0000\u0000"+
		"\u058b\u058c\u0003R)\u0000\u058c\u058d\u0005\u0019\u0000\u0000\u058d\u058f"+
		"\u0001\u0000\u0000\u0000\u058e\u0584\u0001\u0000\u0000\u0000\u058e\u0589"+
		"\u0001\u0000\u0000\u0000\u058f\u00f7\u0001\u0000\u0000\u0000\u0590\u0594"+
		"\u0003\u00fa}\u0000\u0591\u0594\u0003\u00fc~\u0000\u0592\u0594\u0003\u00fe"+
		"\u007f\u0000\u0593\u0590\u0001\u0000\u0000\u0000\u0593\u0591\u0001\u0000"+
		"\u0000\u0000\u0593\u0592\u0001\u0000\u0000\u0000\u0594\u00f9\u0001\u0000"+
		"\u0000\u0000\u0595\u0596\u0007\u000f\u0000\u0000\u0596\u0597\u0005\u0018"+
		"\u0000\u0000\u0597\u0598\u0003\u0084B\u0000\u0598\u059a\u0005\u0019\u0000"+
		"\u0000\u0599\u059b\u0003\u0104\u0082\u0000\u059a\u0599\u0001\u0000\u0000"+
		"\u0000\u059a\u059b\u0001\u0000\u0000\u0000\u059b\u059d\u0001\u0000\u0000"+
		"\u0000\u059c\u059e\u0003\u010a\u0085\u0000\u059d\u059c\u0001\u0000\u0000"+
		"\u0000\u059d\u059e\u0001\u0000\u0000\u0000\u059e\u05ab\u0001\u0000\u0000"+
		"\u0000\u059f\u05a0\u0007\u000f\u0000\u0000\u05a0\u05a1\u0005\u0018\u0000"+
		"\u0000\u05a1\u05a2\u0003\u0004\u0002\u0000\u05a2\u05a3\u0005\u0019\u0000"+
		"\u0000\u05a3\u05ab\u0001\u0000\u0000\u0000\u05a4\u05a5\u0007\u000f\u0000"+
		"\u0000\u05a5\u05a6\u0007\t\u0000\u0000\u05a6\u05a7\u0005\u0018\u0000\u0000"+
		"\u05a7\u05a8\u0003N\'\u0000\u05a8\u05a9\u0005\u0019\u0000\u0000\u05a9"+
		"\u05ab\u0001\u0000\u0000\u0000\u05aa\u0595\u0001\u0000\u0000\u0000\u05aa"+
		"\u059f\u0001\u0000\u0000\u0000\u05aa\u05a4\u0001\u0000\u0000\u0000\u05ab"+
		"\u00fb\u0001\u0000\u0000\u0000\u05ac\u05ad\u0007\u0010\u0000\u0000\u05ad"+
		"\u05ae\u0005\u0018\u0000\u0000\u05ae\u05af\u0003\u0084B\u0000\u05af\u05b1"+
		"\u0005\u0019\u0000\u0000\u05b0\u05b2\u0003\u0104\u0082\u0000\u05b1\u05b0"+
		"\u0001\u0000\u0000\u0000\u05b1\u05b2\u0001\u0000\u0000\u0000\u05b2\u05b4"+
		"\u0001\u0000\u0000\u0000\u05b3\u05b5\u0003\u010a\u0085\u0000\u05b4\u05b3"+
		"\u0001\u0000\u0000\u0000\u05b4\u05b5\u0001\u0000\u0000\u0000\u05b5\u05c2"+
		"\u0001\u0000\u0000\u0000\u05b6\u05b7\u0007\u0010\u0000\u0000\u05b7\u05b8"+
		"\u0005\u0018\u0000\u0000\u05b8\u05b9\u0003\u0004\u0002\u0000\u05b9\u05ba"+
		"\u0005\u0019\u0000\u0000\u05ba\u05c2\u0001\u0000\u0000\u0000\u05bb\u05bc"+
		"\u0007\u0010\u0000\u0000\u05bc\u05bd\u0007\t\u0000\u0000\u05bd\u05be\u0005"+
		"\u0018\u0000\u0000\u05be\u05bf\u0003N\'\u0000\u05bf\u05c0\u0005\u0019"+
		"\u0000\u0000\u05c0\u05c2\u0001\u0000\u0000\u0000\u05c1\u05ac\u0001\u0000"+
		"\u0000\u0000\u05c1\u05b6\u0001\u0000\u0000\u0000\u05c1\u05bb\u0001\u0000"+
		"\u0000\u0000\u05c2\u00fd\u0001\u0000\u0000\u0000\u05c3\u05c4\u0005w\u0000"+
		"\u0000\u05c4\u05c6\u0005\u0018\u0000\u0000\u05c5\u05c7\u0005H\u0000\u0000"+
		"\u05c6\u05c5\u0001\u0000\u0000\u0000\u05c6\u05c7\u0001\u0000\u0000\u0000"+
		"\u05c7\u05c8\u0001\u0000\u0000\u0000\u05c8\u05c9\u0003\u0090H\u0000\u05c9"+
		"\u05ca\u0005\u0016\u0000\u0000\u05ca\u05cc\u0003\u0090H\u0000\u05cb\u05cd"+
		"\u0003\u0100\u0080\u0000\u05cc\u05cb\u0001\u0000\u0000\u0000\u05cc\u05cd"+
		"\u0001\u0000\u0000\u0000\u05cd\u05ce\u0001\u0000\u0000\u0000\u05ce\u05d0"+
		"\u0005\u0019\u0000\u0000\u05cf\u05d1\u0003\u0102\u0081\u0000\u05d0\u05cf"+
		"\u0001\u0000\u0000\u0000\u05d0\u05d1\u0001\u0000\u0000\u0000\u05d1\u05d3"+
		"\u0001\u0000\u0000\u0000\u05d2\u05d4\u0003\u0104\u0082\u0000\u05d3\u05d2"+
		"\u0001\u0000\u0000\u0000\u05d3\u05d4\u0001\u0000\u0000\u0000\u05d4\u05d6"+
		"\u0001\u0000\u0000\u0000\u05d5\u05d7\u0003\u010a\u0085\u0000\u05d6\u05d5"+
		"\u0001\u0000\u0000\u0000\u05d6\u05d7\u0001\u0000\u0000\u0000\u05d7\u00ff"+
		"\u0001\u0000\u0000\u0000\u05d8\u05d9\u0005\u0092\u0000\u0000\u05d9\u05e1"+
		"\u0005\u0099\u0000\u0000\u05da\u05e2\u0005O\u0000\u0000\u05db\u05dd\u0005"+
		"\u00b8\u0000\u0000\u05dc\u05de\u0003\u008cF\u0000\u05dd\u05dc\u0001\u0000"+
		"\u0000\u0000\u05dd\u05de\u0001\u0000\u0000\u0000\u05de\u05df\u0001\u0000"+
		"\u0000\u0000\u05df\u05e0\u0007\u0011\u0000\u0000\u05e0\u05e2\u0005;\u0000"+
		"\u0000\u05e1\u05da\u0001\u0000\u0000\u0000\u05e1\u05db\u0001\u0000\u0000"+
		"\u0000\u05e2\u0101\u0001\u0000\u0000\u0000\u05e3\u05e4\u0005\u00c3\u0000"+
		"\u0000\u05e4\u05e5\u0005_\u0000\u0000\u05e5\u05e6\u0005\u0018\u0000\u0000"+
		"\u05e6\u05e7\u0003h4\u0000\u05e7\u05e8\u0005\u0019\u0000\u0000\u05e8\u0103"+
		"\u0001\u0000\u0000\u0000\u05e9\u05ea\u0005W\u0000\u0000\u05ea\u05eb\u0005"+
		"\u0018\u0000\u0000\u05eb\u05ec\u0003\u0082A\u0000\u05ec\u05ed\u0005\u0019"+
		"\u0000\u0000\u05ed\u0105\u0001\u0000\u0000\u0000\u05ee\u05ef\u0005\u00a3"+
		"\u0000\u0000\u05ef\u05f3\u0005\u008d\u0000\u0000\u05f0\u05f1\u0005c\u0000"+
		"\u0000\u05f1\u05f3\u0005\u008d\u0000\u0000\u05f2\u05ee\u0001\u0000\u0000"+
		"\u0000\u05f2\u05f0\u0001\u0000\u0000\u0000\u05f3\u0107\u0001\u0000\u0000"+
		"\u0000\u05f4\u05f5\u0005\\\u0000\u0000\u05f5\u05f9\u0005X\u0000\u0000"+
		"\u05f6\u05f7\u0005\\\u0000\u0000\u05f7\u05f9\u0005p\u0000\u0000\u05f8"+
		"\u05f4\u0001\u0000\u0000\u0000\u05f8\u05f6\u0001\u0000\u0000\u0000\u05f9"+
		"\u0109\u0001\u0000\u0000\u0000\u05fa\u05fb\u0005\u0098\u0000\u0000\u05fb"+
		"\u05fd\u0005\u0018\u0000\u0000\u05fc\u05fe\u0003\u010c\u0086\u0000\u05fd"+
		"\u05fc\u0001\u0000\u0000\u0000\u05fd\u05fe\u0001\u0000\u0000\u0000\u05fe"+
		"\u0600\u0001\u0000\u0000\u0000\u05ff\u0601\u0003h4\u0000\u0600\u05ff\u0001"+
		"\u0000\u0000\u0000\u0600\u0601\u0001\u0000\u0000\u0000\u0601\u0603\u0001"+
		"\u0000\u0000\u0000\u0602\u0604\u0003\u010e\u0087\u0000\u0603\u0602\u0001"+
		"\u0000\u0000\u0000\u0603\u0604\u0001\u0000\u0000\u0000\u0604\u0605\u0001"+
		"\u0000\u0000\u0000\u0605\u0606\u0005\u0019\u0000\u0000\u0606\u010b\u0001"+
		"\u0000\u0000\u0000\u0607\u0608\u0005\u009c\u0000\u0000\u0608\u0609\u0005"+
		"7\u0000\u0000\u0609\u060e\u0003\u008cF\u0000\u060a\u060b\u0005\u0016\u0000"+
		"\u0000\u060b\u060d\u0003\u008cF\u0000\u060c\u060a\u0001\u0000\u0000\u0000"+
		"\u060d\u0610\u0001\u0000\u0000\u0000\u060e\u060c\u0001\u0000\u0000\u0000"+
		"\u060e\u060f\u0001\u0000\u0000\u0000\u060f\u010d\u0001\u0000\u0000\u0000"+
		"\u0610\u060e\u0001\u0000\u0000\u0000\u0611\u0612\u0007\u0012\u0000\u0000"+
		"\u0612\u0614\u0003\u0110\u0088\u0000\u0613\u0615\u0003\u0114\u008a\u0000"+
		"\u0614\u0613\u0001\u0000\u0000\u0000\u0614\u0615\u0001\u0000\u0000\u0000"+
		"\u0615\u061f\u0001\u0000\u0000\u0000\u0616\u0617\u0007\u0012\u0000\u0000"+
		"\u0617\u0618\u00055\u0000\u0000\u0618\u0619\u0003\u0110\u0088\u0000\u0619"+
		"\u061a\u00050\u0000\u0000\u061a\u061c\u0003\u0112\u0089\u0000\u061b\u061d"+
		"\u0003\u0114\u008a\u0000\u061c\u061b\u0001\u0000\u0000\u0000\u061c\u061d"+
		"\u0001\u0000\u0000\u0000\u061d\u061f\u0001\u0000\u0000\u0000\u061e\u0611"+
		"\u0001\u0000\u0000\u0000\u061e\u0616\u0001\u0000\u0000\u0000\u061f\u010f"+
		"\u0001\u0000\u0000\u0000\u0620\u0621\u0005\u00ba\u0000\u0000\u0621\u062b"+
		"\u0005\u00a0\u0000\u0000\u0622\u0623\u0003\u008cF\u0000\u0623\u0624\u0005"+
		"\u00a0\u0000\u0000\u0624\u062b\u0001\u0000\u0000\u0000\u0625\u0626\u0005"+
		">\u0000\u0000\u0626\u062b\u0005\u00a6\u0000\u0000\u0627\u0628\u0003\u008c"+
		"F\u0000\u0628\u0629\u0005Y\u0000\u0000\u0629\u062b\u0001\u0000\u0000\u0000"+
		"\u062a\u0620\u0001\u0000\u0000\u0000\u062a\u0622\u0001\u0000\u0000\u0000"+
		"\u062a\u0625\u0001\u0000\u0000\u0000\u062a\u0627\u0001\u0000\u0000\u0000"+
		"\u062b\u0111\u0001\u0000\u0000\u0000\u062c\u062d\u0003\u008cF\u0000\u062d"+
		"\u062e\u0005\u00a0\u0000\u0000\u062e\u0637\u0001\u0000\u0000\u0000\u062f"+
		"\u0630\u0005>\u0000\u0000\u0630\u0637\u0005\u00a6\u0000\u0000\u0631\u0632"+
		"\u0003\u008cF\u0000\u0632\u0633\u0005Y\u0000\u0000\u0633\u0637\u0001\u0000"+
		"\u0000\u0000\u0634\u0635\u0005\u00ba\u0000\u0000\u0635\u0637\u0005Y\u0000"+
		"\u0000\u0636\u062c\u0001\u0000\u0000\u0000\u0636\u062f\u0001\u0000\u0000"+
		"\u0000\u0636\u0631\u0001\u0000\u0000\u0000\u0636\u0634\u0001\u0000\u0000"+
		"\u0000\u0637\u0113\u0001\u0000\u0000\u0000\u0638\u0639\u0005S\u0000\u0000"+
		"\u0639\u063a\u0005>\u0000\u0000\u063a\u0643\u0005\u00a6\u0000\u0000\u063b"+
		"\u063c\u0005S\u0000\u0000\u063c\u0643\u0005_\u0000\u0000\u063d\u063e\u0005"+
		"S\u0000\u0000\u063e\u0643\u0005\u00b0\u0000\u0000\u063f\u0640\u0005S\u0000"+
		"\u0000\u0640\u0641\u0005\u008b\u0000\u0000\u0641\u0643\u0005\u0096\u0000"+
		"\u0000\u0642\u0638\u0001\u0000\u0000\u0000\u0642\u063b\u0001\u0000\u0000"+
		"\u0000\u0642\u063d\u0001\u0000\u0000\u0000\u0642\u063f\u0001\u0000\u0000"+
		"\u0000\u0643\u0115\u0001\u0000\u0000\u0000\u0644\u0658\u0003\u0118\u008c"+
		"\u0000\u0645\u0658\u0003\u0150\u00a8\u0000\u0646\u0658\u0003\u014c\u00a6"+
		"\u0000\u0647\u0658\u0003t:\u0000\u0648\u0658\u0003\u011e\u008f\u0000\u0649"+
		"\u0658\u0003\u0132\u0099\u0000\u064a\u0658\u0003\u0124\u0092\u0000\u064b"+
		"\u0658\u0003\u012a\u0095\u0000\u064c\u0658\u0003\u015e\u00af\u0000\u064d"+
		"\u0658\u0003\u013c\u009e\u0000\u064e\u0658\u0003\u013e\u009f\u0000\u064f"+
		"\u0658\u0003\u0140\u00a0\u0000\u0650\u0658\u0003\u0142\u00a1\u0000\u0651"+
		"\u0658\u0003\u0148\u00a4\u0000\u0652\u0658\u0003\u014a\u00a5\u0000\u0653"+
		"\u0658\u0003\u0144\u00a2\u0000\u0654\u0658\u0003\u0146\u00a3\u0000\u0655"+
		"\u0658\u0003\u0164\u00b2\u0000\u0656\u0658\u0003\u0166\u00b3\u0000\u0657"+
		"\u0644\u0001\u0000\u0000\u0000\u0657\u0645\u0001\u0000\u0000\u0000\u0657"+
		"\u0646\u0001\u0000\u0000\u0000\u0657\u0647\u0001\u0000\u0000\u0000\u0657"+
		"\u0648\u0001\u0000\u0000\u0000\u0657\u0649\u0001\u0000\u0000\u0000\u0657"+
		"\u064a\u0001\u0000\u0000\u0000\u0657\u064b\u0001\u0000\u0000\u0000\u0657"+
		"\u064c\u0001\u0000\u0000\u0000\u0657\u064d\u0001\u0000\u0000\u0000\u0657"+
		"\u064e\u0001\u0000\u0000\u0000\u0657\u064f\u0001\u0000\u0000\u0000\u0657"+
		"\u0650\u0001\u0000\u0000\u0000\u0657\u0651\u0001\u0000\u0000\u0000\u0657"+
		"\u0652\u0001\u0000\u0000\u0000\u0657\u0653\u0001\u0000\u0000\u0000\u0657"+
		"\u0654\u0001\u0000\u0000\u0000\u0657\u0655\u0001\u0000\u0000\u0000\u0657"+
		"\u0656\u0001\u0000\u0000\u0000\u0658\u0117\u0001\u0000\u0000\u0000\u0659"+
		"\u065a\u00059\u0000\u0000\u065a\u065b\u0005\u0018\u0000\u0000\u065b\u065c"+
		"\u0003\u008cF\u0000\u065c\u065d\u00052\u0000\u0000\u065d\u065e\u0003\u011a"+
		"\u008d\u0000\u065e\u065f\u0005\u0019\u0000\u0000\u065f\u0119\u0001\u0000"+
		"\u0000\u0000\u0660\u0668\u0003\u011c\u008e\u0000\u0661\u0662\u0005\u0018"+
		"\u0000\u0000\u0662\u0665\u0005\u0003\u0000\u0000\u0663\u0664\u0005\u0016"+
		"\u0000\u0000\u0664\u0666\u0005\u0003\u0000\u0000\u0665\u0663\u0001\u0000"+
		"\u0000\u0000\u0665\u0666\u0001\u0000\u0000\u0000\u0666\u0667\u0001\u0000"+
		"\u0000\u0000\u0667\u0669\u0005\u0019\u0000\u0000\u0668\u0661\u0001\u0000"+
		"\u0000\u0000\u0668\u0669\u0001\u0000\u0000\u0000\u0669\u011b\u0001\u0000"+
		"\u0000\u0000\u066a\u066b\u0003\u016a\u00b5\u0000\u066b\u066c\u0006\u008e"+
		"\uffff\uffff\u0000\u066c\u0673\u0001\u0000\u0000\u0000\u066d\u066e\u0005"+
		"\u0017\u0000\u0000\u066e\u066f\u0003\u016a\u00b5\u0000\u066f\u0670\u0006"+
		"\u008e\uffff\uffff\u0000\u0670\u0672\u0001\u0000\u0000\u0000\u0671\u066d"+
		"\u0001\u0000\u0000\u0000\u0672\u0675\u0001\u0000\u0000\u0000\u0673\u0671"+
		"\u0001\u0000\u0000\u0000\u0673\u0674\u0001\u0000\u0000\u0000\u0674\u011d"+
		"\u0001\u0000\u0000\u0000\u0675\u0673\u0001\u0000\u0000\u0000\u0676\u0677"+
		"\u0005\u00ad\u0000\u0000\u0677\u0678\u0005\u0018\u0000\u0000\u0678\u0679"+
		"\u0003\u008cF\u0000\u0679\u067a\u0005\u0016\u0000\u0000\u067a\u067d\u0003"+
		"\u0120\u0090\u0000\u067b\u067c\u0005\u0016\u0000\u0000\u067c\u067e\u0003"+
		"\u0122\u0091\u0000\u067d\u067b\u0001\u0000\u0000\u0000\u067d\u067e\u0001"+
		"\u0000\u0000\u0000\u067e\u067f\u0001\u0000\u0000\u0000\u067f\u0680\u0005"+
		"\u0019\u0000\u0000\u0680\u068d\u0001\u0000\u0000\u0000\u0681\u0682\u0005"+
		"\u00ad\u0000\u0000\u0682\u0683\u0005\u0018\u0000\u0000\u0683\u0684\u0003"+
		"\u008cF\u0000\u0684\u0685\u0005\\\u0000\u0000\u0685\u0688\u0003\u0120"+
		"\u0090\u0000\u0686\u0687\u0005Z\u0000\u0000\u0687\u0689\u0003\u0122\u0091"+
		"\u0000\u0688\u0686\u0001\u0000\u0000\u0000\u0688\u0689\u0001\u0000\u0000"+
		"\u0000\u0689\u068a\u0001\u0000\u0000\u0000\u068a\u068b\u0005\u0019\u0000"+
		"\u0000\u068b\u068d\u0001\u0000\u0000\u0000\u068c\u0676\u0001\u0000\u0000"+
		"\u0000\u068c\u0681\u0001\u0000\u0000\u0000\u068d\u011f\u0001\u0000\u0000"+
		"\u0000\u068e\u068f\u0003\u008cF\u0000\u068f\u0121\u0001\u0000\u0000\u0000"+
		"\u0690\u0691\u0003\u008cF\u0000\u0691\u0123\u0001\u0000\u0000\u0000\u0692"+
		"\u0693\u0005\u00b7\u0000\u0000\u0693\u0695\u0005\u0018\u0000\u0000\u0694"+
		"\u0696\u0003\u0126\u0093\u0000\u0695\u0694\u0001\u0000\u0000\u0000\u0695"+
		"\u0696\u0001\u0000\u0000\u0000\u0696\u0698\u0001\u0000\u0000\u0000\u0697"+
		"\u0699\u0003\u0128\u0094\u0000\u0698\u0697\u0001\u0000\u0000\u0000\u0698"+
		"\u0699\u0001\u0000\u0000\u0000\u0699\u069b\u0001\u0000\u0000\u0000\u069a"+
		"\u069c\u0005\\\u0000\u0000\u069b\u069a\u0001\u0000\u0000\u0000\u069b\u069c"+
		"\u0001\u0000\u0000\u0000\u069c\u069d\u0001\u0000\u0000\u0000\u069d\u069e"+
		"\u0003\u008cF\u0000\u069e\u069f\u0005\u0019\u0000\u0000\u069f\u0125\u0001"+
		"\u0000\u0000\u0000\u06a0\u06a1\u0007\u0013\u0000\u0000\u06a1\u0127\u0001"+
		"\u0000\u0000\u0000\u06a2\u06a3\u0005\n\u0000\u0000\u06a3\u0129\u0001\u0000"+
		"\u0000\u0000\u06a4\u06a5\u0005\u009b\u0000\u0000\u06a5\u06a6\u0005\u0018"+
		"\u0000\u0000\u06a6\u06a7\u0003\u008cF\u0000\u06a7\u06a8\u0005\u00c2\u0000"+
		"\u0000\u06a8\u06a9\u0003\u0130\u0098\u0000\u06a9\u06ab\u0003\u012c\u0096"+
		"\u0000\u06aa\u06ac\u0003\u012e\u0097\u0000\u06ab\u06aa\u0001\u0000\u0000"+
		"\u0000\u06ab\u06ac\u0001\u0000\u0000\u0000\u06ac\u06ad\u0001\u0000\u0000"+
		"\u0000\u06ad\u06ae\u0005\u0019\u0000\u0000\u06ae\u012b\u0001\u0000\u0000"+
		"\u0000\u06af\u06b0\u0007\u0014\u0000\u0000\u06b0\u012d\u0001\u0000\u0000"+
		"\u0000\u06b1\u06b2\u0005\n\u0000\u0000\u06b2\u012f\u0001\u0000\u0000\u0000"+
		"\u06b3\u06b4\u0003\u008cF\u0000\u06b4\u0131\u0001\u0000\u0000\u0000\u06b5"+
		"\u06b6\u0005\u009a\u0000\u0000\u06b6\u06b7\u0005\u0018\u0000\u0000\u06b7"+
		"\u06b8\u0003\u0134\u009a\u0000\u06b8\u06b9\u0005\u009e\u0000\u0000\u06b9"+
		"\u06ba\u0003\u0136\u009b\u0000\u06ba\u06bb\u0005\\\u0000\u0000\u06bb\u06be"+
		"\u0003\u0138\u009c\u0000\u06bc\u06bd\u0005Z\u0000\u0000\u06bd\u06bf\u0003"+
		"\u013a\u009d\u0000\u06be\u06bc\u0001\u0000\u0000\u0000\u06be\u06bf\u0001"+
		"\u0000\u0000\u0000\u06bf\u06c0\u0001\u0000\u0000\u0000\u06c0\u06c1\u0005"+
		"\u0019\u0000\u0000\u06c1\u0133\u0001\u0000\u0000\u0000\u06c2\u06c3\u0003"+
		"\u008cF\u0000\u06c3\u0135\u0001\u0000\u0000\u0000\u06c4\u06c5\u0003\u008c"+
		"F\u0000\u06c5\u0137\u0001\u0000\u0000\u0000\u06c6\u06c7\u0003\u008cF\u0000"+
		"\u06c7\u0139\u0001\u0000\u0000\u0000\u06c8\u06c9\u0003\u008cF\u0000\u06c9"+
		"\u013b\u0001\u0000\u0000\u0000\u06ca\u06cd\u0005?\u0000\u0000\u06cb\u06cc"+
		"\u0005\u0018\u0000\u0000\u06cc\u06ce\u0005\u0019\u0000\u0000\u06cd\u06cb"+
		"\u0001\u0000\u0000\u0000\u06cd\u06ce\u0001\u0000\u0000\u0000\u06ce\u06d2"+
		"\u0001\u0000\u0000\u0000\u06cf\u06d0\u0005>\u0000\u0000\u06d0\u06d2\u0005"+
		"C\u0000\u0000\u06d1\u06ca\u0001\u0000\u0000\u0000\u06d1\u06cf\u0001\u0000"+
		"\u0000\u0000\u06d2\u013d\u0001\u0000\u0000\u0000\u06d3\u06d6\u0005A\u0000"+
		"\u0000\u06d4\u06d5\u0005\u0018\u0000\u0000\u06d5\u06d7\u0005\u0019\u0000"+
		"\u0000\u06d6\u06d4\u0001\u0000\u0000\u0000\u06d6\u06d7\u0001\u0000\u0000"+
		"\u0000\u06d7\u06db\u0001\u0000\u0000\u0000\u06d8\u06d9\u0005>\u0000\u0000"+
		"\u06d9\u06db\u0005\u00b1\u0000\u0000\u06da\u06d3\u0001\u0000\u0000\u0000"+
		"\u06da\u06d8\u0001\u0000\u0000\u0000\u06db\u013f\u0001\u0000\u0000\u0000"+
		"\u06dc\u06df\u0005B\u0000\u0000\u06dd\u06de\u0005\u0018\u0000\u0000\u06de"+
		"\u06e0\u0005\u0019\u0000\u0000\u06df\u06dd\u0001\u0000\u0000\u0000\u06df"+
		"\u06e0\u0001\u0000\u0000\u0000\u06e0\u06e4\u0001\u0000\u0000\u0000\u06e1"+
		"\u06e2\u0005>\u0000\u0000\u06e2\u06e4\u0005\u00b2\u0000\u0000\u06e3\u06dc"+
		"\u0001\u0000\u0000\u0000\u06e3\u06e1\u0001\u0000\u0000\u0000\u06e4\u0141"+
		"\u0001\u0000\u0000\u0000\u06e5\u06e8\u0005@\u0000\u0000\u06e6\u06e7\u0005"+
		"\u0018\u0000\u0000\u06e7\u06e9\u0005\u0019\u0000\u0000\u06e8\u06e6\u0001"+
		"\u0000\u0000\u0000\u06e8\u06e9\u0001\u0000\u0000\u0000\u06e9\u06ec\u0001"+
		"\u0000\u0000\u0000\u06ea\u06ec\u0005j\u0000\u0000\u06eb\u06e5\u0001\u0000"+
		"\u0000\u0000\u06eb\u06ea\u0001\u0000\u0000\u0000\u06ec\u0143\u0001\u0000"+
		"\u0000\u0000\u06ed\u06f0\u0005z\u0000\u0000\u06ee\u06ef\u0005\u0018\u0000"+
		"\u0000\u06ef\u06f1\u0005\u0019\u0000\u0000\u06f0\u06ee\u0001\u0000\u0000"+
		"\u0000\u06f0\u06f1\u0001\u0000\u0000\u0000\u06f1\u06f5\u0001\u0000\u0000"+
		"\u0000\u06f2\u06f3\u0005x\u0000\u0000\u06f3\u06f5\u0005D\u0000\u0000\u06f4"+
		"\u06ed\u0001\u0000\u0000\u0000\u06f4\u06f2\u0001\u0000\u0000\u0000\u06f5"+
		"\u0145\u0001\u0000\u0000\u0000\u06f6\u06f9\u0005\u0091\u0000\u0000\u06f7"+
		"\u06f8\u0005\u0018\u0000\u0000\u06f8\u06fa\u0005\u0019\u0000\u0000\u06f9"+
		"\u06f7\u0001\u0000\u0000\u0000\u06f9\u06fa\u0001\u0000\u0000\u0000\u06fa"+
		"\u06fe\u0001\u0000\u0000\u0000\u06fb\u06fc\u0005\u0090\u0000\u0000\u06fc"+
		"\u06fe\u0005D\u0000\u0000\u06fd\u06f6\u0001\u0000\u0000\u0000\u06fd\u06fb"+
		"\u0001\u0000\u0000\u0000\u06fe\u0147\u0001\u0000\u0000\u0000\u06ff\u0702"+
		"\u0005y\u0000\u0000\u0700\u0701\u0005\u0018\u0000\u0000\u0701\u0703\u0005"+
		"\u0019\u0000\u0000\u0702\u0700\u0001\u0000\u0000\u0000\u0702\u0703\u0001"+
		"\u0000\u0000\u0000\u0703\u0707\u0001\u0000\u0000\u0000\u0704\u0705\u0005"+
		"x\u0000\u0000\u0705\u0707\u0005C\u0000\u0000\u0706\u06ff\u0001\u0000\u0000"+
		"\u0000\u0706\u0704\u0001\u0000\u0000\u0000\u0707\u0149\u0001\u0000\u0000"+
		"\u0000\u0708\u070b\u0005{\u0000\u0000\u0709\u070a\u0005\u0018\u0000\u0000"+
		"\u070a\u070c\u0005\u0019\u0000\u0000\u070b\u0709\u0001\u0000\u0000\u0000"+
		"\u070b\u070c\u0001\u0000\u0000\u0000\u070c\u0710\u0001\u0000\u0000\u0000"+
		"\u070d\u070e\u0005x\u0000\u0000\u070e\u0710\u0005\u00b1\u0000\u0000\u070f"+
		"\u0708\u0001\u0000\u0000\u0000\u070f\u070d\u0001\u0000\u0000\u0000\u0710"+
		"\u014b\u0001\u0000\u0000\u0000\u0711\u0712\u0005[\u0000\u0000\u0712\u0713"+
		"\u0005\u0018\u0000\u0000\u0713\u0714\u0003\u008cF\u0000\u0714\u0715\u0005"+
		"2\u0000\u0000\u0715\u0716\u0003\u014e\u00a7\u0000\u0716\u0717\u0005\u0019"+
		"\u0000\u0000\u0717\u014d\u0001\u0000\u0000\u0000\u0718\u0719\u0005\n\u0000"+
		"\u0000\u0719\u014f\u0001\u0000\u0000\u0000\u071a\u071b\u0005U\u0000\u0000"+
		"\u071b\u071c\u0005\u0018\u0000\u0000\u071c\u071d\u0003\u0152\u00a9\u0000"+
		"\u071d\u071e\u0005\\\u0000\u0000\u071e\u071f\u0003\u008cF\u0000\u071f"+
		"\u0720\u0005\u0019\u0000\u0000\u0720\u0727\u0001\u0000\u0000\u0000\u0721"+
		"\u0722\u0003\u0154\u00aa\u0000\u0722\u0723\u0005\u0018\u0000\u0000\u0723"+
		"\u0724\u0003\u008cF\u0000\u0724\u0725\u0005\u0019\u0000\u0000\u0725\u0727"+
		"\u0001\u0000\u0000\u0000\u0726\u071a\u0001\u0000\u0000\u0000\u0726\u0721"+
		"\u0001\u0000\u0000\u0000\u0727\u0151\u0001\u0000\u0000\u0000\u0728\u072e"+
		"\u0003\u0154\u00aa\u0000\u0729\u072e\u0003\u0156\u00ab\u0000\u072a\u072e"+
		"\u0003\u0158\u00ac\u0000\u072b\u072e\u0003\u015a\u00ad\u0000\u072c\u072e"+
		"\u0003\u015c\u00ae\u0000\u072d\u0728\u0001\u0000\u0000\u0000\u072d\u0729"+
		"\u0001\u0000\u0000\u0000\u072d\u072a\u0001\u0000\u0000\u0000\u072d\u072b"+
		"\u0001\u0000\u0000\u0000\u072d\u072c\u0001\u0000\u0000\u0000\u072e\u0153"+
		"\u0001\u0000\u0000\u0000\u072f\u0730\u0007\u0015\u0000\u0000\u0730\u0155"+
		"\u0001\u0000\u0000\u0000\u0731\u0732\u0005E\u0000\u0000\u0732\u0733\u0005"+
		"\u008f\u0000\u0000\u0733\u073b\u0005\u0087\u0000\u0000\u0734\u0735\u0005"+
		"E\u0000\u0000\u0735\u0736\u0005\u008f\u0000\u0000\u0736\u073b\u0005\u00bf"+
		"\u0000\u0000\u0737\u0738\u0005E\u0000\u0000\u0738\u0739\u0005\u008f\u0000"+
		"\u0000\u0739\u073b\u0005\u00c5\u0000\u0000\u073a\u0731\u0001\u0000\u0000"+
		"\u0000\u073a\u0734\u0001\u0000\u0000\u0000\u073a\u0737\u0001\u0000\u0000"+
		"\u0000\u073b\u0157\u0001\u0000\u0000\u0000\u073c\u073d\u0005\u00bf\u0000"+
		"\u0000\u073d\u073e\u0005\u008f\u0000\u0000\u073e\u0743\u0005\u0087\u0000"+
		"\u0000\u073f\u0740\u0005\u00bf\u0000\u0000\u0740\u0741\u0005\u008f\u0000"+
		"\u0000\u0741\u0743\u0005\u00c5\u0000\u0000\u0742\u073c\u0001\u0000\u0000"+
		"\u0000\u0742\u073f\u0001\u0000\u0000\u0000\u0743\u0159\u0001\u0000\u0000"+
		"\u0000\u0744\u0746\u0005\u0090\u0000\u0000\u0745\u0747\u0007\u0016\u0000"+
		"\u0000\u0746\u0745\u0001\u0000\u0000\u0000\u0746\u0747\u0001\u0000\u0000"+
		"\u0000\u0747\u074b\u0001\u0000\u0000\u0000\u0748\u074b\u0005\u00b3\u0000"+
		"\u0000\u0749\u074b\u0005\u00b4\u0000\u0000\u074a\u0744\u0001\u0000\u0000"+
		"\u0000\u074a\u0748\u0001\u0000\u0000\u0000\u074a\u0749\u0001\u0000\u0000"+
		"\u0000\u074b\u015b\u0001\u0000\u0000\u0000\u074c\u074d\u0007\u0017\u0000"+
		"\u0000\u074d\u015d\u0001\u0000\u0000\u0000\u074e\u074f\u0005\u009f\u0000"+
		"\u0000\u074f\u0750\u0005\u0018\u0000\u0000\u0750\u0751\u0003\u0160\u00b0"+
		"\u0000\u0751\u0752\u0005e\u0000\u0000\u0752\u0753\u0003\u0162\u00b1\u0000"+
		"\u0753\u0754\u0005\u0019\u0000\u0000\u0754\u015f\u0001\u0000\u0000\u0000"+
		"\u0755\u0756\u0003\u008cF\u0000\u0756\u0161\u0001\u0000\u0000\u0000\u0757"+
		"\u0758\u0003\u008cF\u0000\u0758\u0163\u0001\u0000\u0000\u0000\u0759\u075a"+
		"\u0005=\u0000\u0000\u075a\u075b\u0005\u0018\u0000\u0000\u075b\u0760\u0003"+
		"\u0090H\u0000\u075c\u075d\u0005\u0016\u0000\u0000\u075d\u075f\u0003\u0090"+
		"H\u0000\u075e\u075c\u0001\u0000\u0000\u0000\u075f\u0762\u0001\u0000\u0000"+
		"\u0000\u0760\u075e\u0001\u0000\u0000\u0000\u0760\u0761\u0001\u0000\u0000"+
		"\u0000\u0761\u0763\u0001\u0000\u0000\u0000\u0762\u0760\u0001\u0000\u0000"+
		"\u0000\u0763\u0764\u0005\u0019\u0000\u0000\u0764\u0165\u0001\u0000\u0000"+
		"\u0000\u0765\u0766\u0005\u00a5\u0000\u0000\u0766\u0767\u0005\u0018\u0000"+
		"\u0000\u0767\u076c\u0003\u0090H\u0000\u0768\u0769\u0005\u0016\u0000\u0000"+
		"\u0769\u076b\u0003\u0090H\u0000\u076a\u0768\u0001\u0000\u0000\u0000\u076b"+
		"\u076e\u0001\u0000\u0000\u0000\u076c\u076a\u0001\u0000\u0000\u0000\u076c"+
		"\u076d\u0001\u0000\u0000\u0000\u076d\u076f\u0001\u0000\u0000\u0000\u076e"+
		"\u076c\u0001\u0000\u0000\u0000\u076f\u0770\u0005\u0019\u0000\u0000\u0770"+
		"\u0167\u0001\u0000\u0000\u0000\u0771\u0776\u0005\u00c9\u0000\u0000\u0772"+
		"\u0776\u0005\u00ca\u0000\u0000\u0773\u0774\u0007\u0018\u0000\u0000\u0774"+
		"\u0776\u0006\u00b4\uffff\uffff\u0000\u0775\u0771\u0001\u0000\u0000\u0000"+
		"\u0775\u0772\u0001\u0000\u0000\u0000\u0775\u0773\u0001\u0000\u0000\u0000"+
		"\u0776\u0169\u0001\u0000\u0000\u0000\u0777\u077b\u0003\u0168\u00b4\u0000"+
		"\u0778\u0779\u0007\u0019\u0000\u0000\u0779\u077b\u0006\u00b5\uffff\uffff"+
		"\u0000\u077a\u0777\u0001\u0000\u0000\u0000\u077a\u0778\u0001\u0000\u0000"+
		"\u0000\u077b\u016b\u0001\u0000\u0000\u0000\u00cf\u0170\u017a\u017e\u0182"+
		"\u0186\u018b\u0193\u019c\u01a2\u01aa\u01b5\u01be\u01ca\u01cc\u01d0\u01d6"+
		"\u01d8\u01dc\u01e0\u01e4\u01e6\u01ea\u01ed\u01f0\u01f4\u01f7\u01fb\u01fd"+
		"\u0201\u0205\u0207\u020a\u020c\u0214\u021b\u021d\u0222\u0228\u022a\u0231"+
		"\u0237\u023d\u0245\u024a\u024e\u0251\u0254\u0257\u0259\u025d\u0260\u0266"+
		"\u0268\u026f\u0278\u027d\u0283\u0293\u029a\u029f\u02a3\u02ae\u02b6\u02b9"+
		"\u02c4\u02c8\u02cf\u02d8\u02df\u02e6\u02ef\u02f5\u0301\u0309\u030e\u0311"+
		"\u0319\u032c\u0334\u033a\u033e\u0344\u0351\u0358\u035e\u0365\u036e\u0373"+
		"\u0383\u0387\u038e\u0396\u0398\u03a8\u03b5\u03b8\u03c0\u03c6\u03d3\u03e2"+
		"\u03f4\u03f6\u0403\u0407\u040b\u0417\u0420\u042c\u0435\u043c\u043f\u044f"+
		"\u0452\u0463\u0470\u0474\u047c\u0484\u048c\u0494\u049a\u04a7\u04ad\u04be"+
		"\u04c1\u04c6\u04cd\u04d4\u04e8\u04ea\u04f4\u04fb\u0505\u0509\u050c\u050f"+
		"\u0512\u0515\u051d\u0524\u0556\u0582\u058e\u0593\u059a\u059d\u05aa\u05b1"+
		"\u05b4\u05c1\u05c6\u05cc\u05d0\u05d3\u05d6\u05dd\u05e1\u05f2\u05f8\u05fd"+
		"\u0600\u0603\u060e\u0614\u061c\u061e\u062a\u0636\u0642\u0657\u0665\u0668"+
		"\u0673\u067d\u0688\u068c\u0695\u0698\u069b\u06ab\u06be\u06cd\u06d1\u06d6"+
		"\u06da\u06df\u06e3\u06e8\u06eb\u06f0\u06f4\u06f9\u06fd\u0702\u0706\u070b"+
		"\u070f\u0726\u072d\u073a\u0742\u0746\u074a\u0760\u076c\u0775\u077a";
	public static final ATN _ATN =
		new ATNDeserializer().deserialize(_serializedATN.toCharArray());
	static {
		_decisionToDFA = new DFA[_ATN.getNumberOfDecisions()];
		for (int i = 0; i < _ATN.getNumberOfDecisions(); i++) {
			_decisionToDFA[i] = new DFA(_ATN.getDecisionState(i), i);
		}
	}
}
