/*
 * Hibernate, Relational Persistence for Idiomatic Java
 *
 * License: GNU Lesser General Public License (LGPL), version 2.1 or later
 * See the lgpl.txt file in the root directory or http://www.gnu.org/licenses/lgpl-2.1.html
 */
package org.hibernate.query.named;

import java.util.Map;

import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.spi.QueryImplementor;
import org.hibernate.query.spi.QueryParameterImplementor;

/**
 * The runtime representation of named queries.  They are stored in and
 * available through the QueryEngine's {@link NamedObjectRepository}.
 *
 * This is the base contract for all specific types of named query mementos
 *
 * @author Steve Ebersole
 */
public interface NamedQueryMemento {
	/**
	 * The name under which the query is registered
	 */
	String getRegistrationName();

	Boolean getCacheable();

	String getCacheRegion();

	CacheMode getCacheMode();

	FlushMode getFlushMode();

	Boolean getReadOnly();

	Integer getTimeout();

	Integer getFetchSize();

	String getComment();

	Map<String, Object> getHints();

	void validate(QueryEngine queryEngine);

	/**
	 * Makes a copy of the memento using the specified registration name
	 */
	NamedQueryMemento makeCopy(String name);

	<T> QueryImplementor<T> toQuery(SharedSessionContractImplementor session);
	<T> QueryImplementor<T> toQuery(SharedSessionContractImplementor session, Class<T> javaType);

	interface ParameterMemento {
		QueryParameterImplementor resolve(SharedSessionContractImplementor session);
	}
}
