/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.spi;

import jakarta.persistence.FlushModeType;
import jakarta.persistence.LockModeType;
import jakarta.persistence.Parameter;
import jakarta.persistence.TemporalType;
import java.io.Serializable;
import java.time.Instant;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.TypeMismatchException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.EntityManagerMessageLogger;
import org.hibernate.internal.HEMLogging;
import org.hibernate.jpa.AvailableHints;
import org.hibernate.jpa.internal.util.FlushModeTypeHelper;
import org.hibernate.jpa.internal.util.LockModeTypeHelper;
import org.hibernate.query.BindableType;
import org.hibernate.query.IllegalQueryOperationException;
import org.hibernate.query.QueryParameter;
import org.hibernate.query.ResultListTransformer;
import org.hibernate.query.TupleTransformer;
import org.hibernate.query.named.NamedQueryMemento;
import org.hibernate.query.spi.AbstractSelectionQuery;
import org.hibernate.query.spi.MutableQueryOptions;
import org.hibernate.query.spi.QueryImplementor;
import org.hibernate.query.sqm.SqmExpressible;

public abstract class AbstractQuery<R>
extends AbstractSelectionQuery<R>
implements QueryImplementor<R> {
    protected static final EntityManagerMessageLogger log = HEMLogging.messageLogger(AbstractQuery.class);

    public AbstractQuery(SharedSessionContractImplementor session) {
        super(session);
    }

    @Override
    protected void applyOptions(NamedQueryMemento memento) {
        if (memento.getHints() != null) {
            memento.getHints().forEach((string, object) -> this.setHint((String)string, object));
        }
        if (memento.getCacheable() != null) {
            this.setCacheable(memento.getCacheable());
        }
        if (memento.getCacheRegion() != null) {
            this.setCacheRegion(memento.getCacheRegion());
        }
        if (memento.getCacheMode() != null) {
            this.setCacheMode(memento.getCacheMode());
        }
        if (memento.getFlushMode() != null) {
            this.setHibernateFlushMode(memento.getFlushMode());
        }
        if (memento.getReadOnly() != null) {
            this.setReadOnly(memento.getReadOnly());
        }
        if (memento.getTimeout() != null) {
            this.setTimeout(memento.getTimeout());
        }
        if (memento.getFetchSize() != null) {
            this.setFetchSize(memento.getFetchSize());
        }
        if (memento.getComment() != null) {
            this.setComment(memento.getComment());
        }
    }

    @Override
    public QueryImplementor<R> setHint(String hintName, Object value) {
        super.setHint(hintName, value);
        return this;
    }

    @Override
    public MutableQueryOptions getQueryOptions() {
        return super.getQueryOptions();
    }

    @Override
    public int getMaxResults() {
        this.getSession().checkOpen();
        return this.getQueryOptions().getLimit().getMaxRowsJpa();
    }

    @Override
    public QueryImplementor<R> setMaxResults(int maxResult) {
        if (maxResult < 0) {
            throw new IllegalArgumentException("max-results cannot be negative");
        }
        this.getSession().checkOpen();
        this.getQueryOptions().getLimit().setMaxRows(maxResult);
        return this;
    }

    @Override
    public int getFirstResult() {
        this.getSession().checkOpen();
        return this.getQueryOptions().getLimit().getFirstRowJpa();
    }

    @Override
    public QueryImplementor<R> setFirstResult(int startPosition) {
        this.getSession().checkOpen();
        if (startPosition < 0) {
            throw new IllegalArgumentException("first-result value cannot be negative : " + startPosition);
        }
        this.getQueryOptions().getLimit().setFirstRow(startPosition);
        return this;
    }

    @Override
    public <T> QueryImplementor<T> setTupleTransformer(TupleTransformer<T> transformer) {
        this.getQueryOptions().setTupleTransformer(transformer);
        return this;
    }

    @Override
    public QueryImplementor<R> setResultListTransformer(ResultListTransformer<R> transformer) {
        this.getQueryOptions().setResultListTransformer(transformer);
        return this;
    }

    @Override
    public QueryImplementor<R> setHibernateFlushMode(FlushMode flushMode) {
        super.setHibernateFlushMode(flushMode);
        return this;
    }

    @Override
    public FlushModeType getFlushMode() {
        this.getSession().checkOpen();
        FlushMode flushMode = this.getQueryOptions().getFlushMode() == null ? this.getSession().getHibernateFlushMode() : this.getQueryOptions().getFlushMode();
        return FlushModeTypeHelper.getFlushModeType(flushMode);
    }

    @Override
    public QueryImplementor<R> setFlushMode(FlushModeType flushModeType) {
        this.getSession().checkOpen();
        this.setHibernateFlushMode(FlushModeTypeHelper.getFlushMode(flushModeType));
        return this;
    }

    @Override
    public QueryImplementor<R> setCacheMode(CacheMode cacheMode) {
        super.setCacheMode(cacheMode);
        return this;
    }

    @Override
    public boolean isCacheable() {
        return super.isCacheable();
    }

    @Override
    public QueryImplementor<R> setCacheable(boolean cacheable) {
        super.setCacheable(cacheable);
        return this;
    }

    @Override
    public QueryImplementor<R> setCacheRegion(String cacheRegion) {
        super.setCacheRegion(cacheRegion);
        return this;
    }

    @Override
    public QueryImplementor<R> setTimeout(int timeout) {
        super.setTimeout(timeout);
        return this;
    }

    @Override
    public QueryImplementor<R> setFetchSize(int fetchSize) {
        super.setFetchSize(fetchSize);
        return this;
    }

    @Override
    public QueryImplementor<R> setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        return this;
    }

    @Override
    public LockOptions getLockOptions() {
        return this.getQueryOptions().getLockOptions();
    }

    public LockModeType getLockMode() {
        this.getSession().checkOpen(false);
        return LockModeTypeHelper.getLockModeType(this.getQueryOptions().getLockOptions().getLockMode());
    }

    @Override
    public QueryImplementor<R> setLockOptions(LockOptions lockOptions) {
        this.getQueryOptions().getLockOptions().setLockMode(lockOptions.getLockMode());
        this.getQueryOptions().getLockOptions().setScope(lockOptions.getScope());
        this.getQueryOptions().getLockOptions().setTimeOut(lockOptions.getTimeOut());
        this.getQueryOptions().getLockOptions().setFollowOnLocking(lockOptions.getFollowOnLocking());
        return this;
    }

    @Override
    public QueryImplementor<R> setLockMode(String alias, LockMode lockMode) {
        this.getQueryOptions().getLockOptions().setAliasSpecificLockMode(alias, lockMode);
        return this;
    }

    @Override
    public QueryImplementor<R> setLockMode(LockModeType lockModeType) {
        this.getSession().checkOpen();
        this.getQueryOptions().getLockOptions().setLockMode(LockModeTypeHelper.getLockMode(lockModeType));
        return this;
    }

    @Override
    public String getComment() {
        return this.getQueryOptions().getComment();
    }

    @Override
    public QueryImplementor<R> setComment(String comment) {
        this.getQueryOptions().setComment(comment);
        return this;
    }

    @Override
    public QueryImplementor<R> addQueryHint(String hint) {
        this.getQueryOptions().addDatabaseHint(hint);
        return this;
    }

    public Set<String> getSupportedHints() {
        return AvailableHints.getDefinedHints();
    }

    @Override
    protected void collectHints(Map<String, Object> hints) {
        if (this.getQueryOptions().getTimeout() != null) {
            hints.put("org.hibernate.timeout", this.getQueryOptions().getTimeout());
            hints.put("jakarta.persistence.query.timeout", this.getQueryOptions().getTimeout() * 1000);
            hints.put("javax.persistence.query.timeout", this.getQueryOptions().getTimeout() * 1000);
        }
        if (this.getLockOptions().getTimeOut() != -1) {
            hints.put("jakarta.persistence.lock.timeout", this.getLockOptions().getTimeOut());
            hints.put("javax.persistence.lock.timeout", this.getLockOptions().getTimeOut());
        }
        if (this.getLockOptions().getScope()) {
            hints.put("jakarta.persistence.lock.scope", this.getLockOptions().getScope());
            hints.put("javax.persistence.lock.scope", this.getLockOptions().getScope());
        }
        if (this.getLockOptions().hasAliasSpecificLockModes()) {
            for (Map.Entry<String, LockMode> entry : this.getLockOptions().getAliasSpecificLocks()) {
                hints.put("org.hibernate.lockMode." + entry.getKey(), entry.getValue().name());
            }
        }
        this.putIfNotNull(hints, "org.hibernate.comment", this.getComment());
        this.putIfNotNull(hints, "org.hibernate.fetchSize", this.getQueryOptions().getFetchSize());
        this.putIfNotNull(hints, "org.hibernate.flushMode", this.getHibernateFlushMode());
        if (this.getCacheMode() != null) {
            this.putIfNotNull(hints, "org.hibernate.cacheMode", this.getCacheMode());
            this.putIfNotNull(hints, "jakarta.persistence.cache.retrieveMode", (Enum<?>)this.getQueryOptions().getCacheRetrieveMode());
            this.putIfNotNull(hints, "jakarta.persistence.cache.storeMode", (Enum<?>)this.getQueryOptions().getCacheStoreMode());
            this.putIfNotNull(hints, "javax.persistence.cache.retrieveMode", (Enum<?>)this.getQueryOptions().getCacheRetrieveMode());
            this.putIfNotNull(hints, "javax.persistence.cache.storeMode", (Enum<?>)this.getQueryOptions().getCacheStoreMode());
        }
        if (this.isCacheable()) {
            hints.put("org.hibernate.cacheable", true);
            this.putIfNotNull(hints, "org.hibernate.cacheRegion", this.getCacheRegion());
        }
        if (this.isReadOnly()) {
            hints.put("org.hibernate.readOnly", true);
        }
    }

    @Override
    protected boolean resolveJdbcParameterTypeIfNecessary() {
        return true;
    }

    @Override
    public Set<Parameter<?>> getParameters() {
        this.getSession().checkOpen(false);
        return this.getParameterMetadata().getRegistrations();
    }

    @Override
    public QueryImplementor<R> setParameter(String name, Object value) {
        super.setParameter(name, value);
        return this;
    }

    private boolean isInstance(BindableType<?> parameterType, Object value) {
        SqmExpressible<?> sqmExpressible = parameterType.resolveExpressible(this.getSession().getFactory());
        assert (sqmExpressible != null);
        return sqmExpressible.getExpressibleJavaType().isInstance(value);
    }

    @Override
    public <P> QueryImplementor<R> setParameter(String name, P value, Class<P> javaTypeClass) {
        super.setParameter(name, (Object)value, (Class)javaTypeClass);
        return this;
    }

    @Override
    public <P> QueryImplementor<R> setParameter(String name, P value, BindableType<P> type) {
        super.setParameter(name, (Object)value, (BindableType)type);
        return this;
    }

    @Override
    public QueryImplementor<R> setParameter(String name, Instant value, TemporalType temporalType) {
        super.setParameter(name, value, temporalType);
        return this;
    }

    @Override
    public QueryImplementor<R> setParameter(int position, Object value) {
        super.setParameter(position, value);
        return this;
    }

    @Override
    public <P> QueryImplementor<R> setParameter(int position, P value, Class<P> javaTypeClass) {
        super.setParameter(position, (Object)value, (Class)javaTypeClass);
        return this;
    }

    @Override
    public <P> QueryImplementor<R> setParameter(int position, P value, BindableType<P> type) {
        super.setParameter(position, (Object)value, (BindableType)type);
        return this;
    }

    @Override
    public QueryImplementor<R> setParameter(int position, Instant value, TemporalType temporalType) {
        super.setParameter(position, value, temporalType);
        return this;
    }

    @Override
    public <P> QueryImplementor<R> setParameter(QueryParameter<P> parameter, P value) {
        super.setParameter((QueryParameter)parameter, (Object)value);
        return this;
    }

    @Override
    public <P> QueryImplementor<R> setParameter(QueryParameter<P> parameter, P value, Class<P> javaTypeClass) {
        super.setParameter((QueryParameter)parameter, (Object)value, (Class)javaTypeClass);
        return this;
    }

    @Override
    public <P> QueryImplementor<R> setParameter(QueryParameter<P> parameter, P value, BindableType<P> type) {
        super.setParameter((QueryParameter)parameter, (Object)value, (BindableType)type);
        return this;
    }

    @Override
    public <P> QueryImplementor<R> setParameter(Parameter<P> parameter, P value) {
        super.setParameter((Parameter)parameter, (Object)value);
        return this;
    }

    private <P> void setParameter(Parameter<P> parameter, P value, BindableType<P> type) {
        if (parameter instanceof QueryParameter) {
            this.setParameter((QueryParameter)parameter, (Object)value, (BindableType)type);
        } else if (value == null) {
            this.locateBinding(parameter).setBindValue(null, type);
        } else if (value instanceof Collection) {
            this.locateBinding(parameter).setBindValues((Collection)value);
        } else {
            this.locateBinding(parameter).setBindValue(value, type);
        }
    }

    @Override
    public QueryImplementor<R> setParameterList(String name, Collection values) {
        super.setParameterList(name, values);
        return this;
    }

    @Override
    public <P> QueryImplementor<R> setParameterList(String name, Collection<? extends P> values, Class<P> javaTypeClass) {
        super.setParameterList(name, (Collection)values, (Class)javaTypeClass);
        return this;
    }

    @Override
    public <P> QueryImplementor<R> setParameterList(String name, Collection<? extends P> values, BindableType<P> type) {
        super.setParameterList(name, (Collection)values, (BindableType)type);
        return this;
    }

    @Override
    public QueryImplementor<R> setParameterList(String name, Object[] values) {
        super.setParameterList(name, values);
        return this;
    }

    @Override
    public <P> QueryImplementor<R> setParameterList(String name, P[] values, Class<P> javaTypeClass) {
        super.setParameterList(name, (Object[])values, (Class)javaTypeClass);
        return this;
    }

    @Override
    public <P> QueryImplementor<R> setParameterList(String name, P[] values, BindableType<P> type) {
        super.setParameterList(name, (Object[])values, (BindableType)type);
        return this;
    }

    @Override
    public QueryImplementor<R> setParameterList(int position, Collection values) {
        super.setParameterList(position, values);
        return this;
    }

    @Override
    public <P> QueryImplementor<R> setParameterList(int position, Collection<? extends P> values, Class<P> javaTypeClass) {
        super.setParameterList(position, (Collection)values, (Class)javaTypeClass);
        return this;
    }

    @Override
    public <P> QueryImplementor<R> setParameterList(int position, Collection<? extends P> values, BindableType<P> type) {
        super.setParameterList(position, (Collection)values, (BindableType)type);
        return this;
    }

    @Override
    public QueryImplementor<R> setParameterList(int position, Object[] values) {
        super.setParameterList(position, values);
        return this;
    }

    @Override
    public <P> QueryImplementor<R> setParameterList(int position, P[] values, Class<P> javaTypeClass) {
        super.setParameterList(position, (Object[])values, (Class)javaTypeClass);
        return this;
    }

    @Override
    public <P> QueryImplementor<R> setParameterList(int position, P[] values, BindableType<P> type) {
        super.setParameterList(position, (Object[])values, (BindableType)type);
        return this;
    }

    @Override
    public <P> QueryImplementor<R> setParameterList(QueryParameter<P> parameter, Collection<? extends P> values) {
        super.setParameterList((QueryParameter)parameter, (Collection)values);
        return this;
    }

    @Override
    public <P> QueryImplementor<R> setParameterList(QueryParameter<P> parameter, Collection<? extends P> values, Class<P> javaTypeClass) {
        super.setParameterList((QueryParameter)parameter, (Collection)values, (Class)javaTypeClass);
        return this;
    }

    @Override
    public <P> QueryImplementor<R> setParameterList(QueryParameter<P> parameter, Collection<? extends P> values, BindableType<P> type) {
        super.setParameterList((QueryParameter)parameter, (Collection)values, (BindableType)type);
        return this;
    }

    @Override
    public <P> QueryImplementor<R> setParameterList(QueryParameter<P> parameter, P[] values) {
        super.setParameterList((QueryParameter)parameter, (Object[])values);
        return this;
    }

    @Override
    public <P> QueryImplementor<R> setParameterList(QueryParameter<P> parameter, P[] values, Class<P> javaTypeClass) {
        super.setParameterList((QueryParameter)parameter, (Object[])values, (Class)javaTypeClass);
        return this;
    }

    @Override
    public <P> QueryImplementor<R> setParameterList(QueryParameter<P> parameter, P[] values, BindableType<P> type) {
        super.setParameterList((QueryParameter)parameter, (Object[])values, (BindableType)type);
        return this;
    }

    @Override
    public QueryImplementor<R> setParameter(Parameter<Calendar> param, Calendar value, TemporalType temporalType) {
        super.setParameter((Parameter)param, value, temporalType);
        return this;
    }

    @Override
    public QueryImplementor<R> setParameter(Parameter<Date> param, Date value, TemporalType temporalType) {
        super.setParameter((Parameter)param, value, temporalType);
        return this;
    }

    @Override
    public QueryImplementor<R> setParameter(String name, Calendar value, TemporalType temporalType) {
        super.setParameter(name, value, temporalType);
        return this;
    }

    @Override
    public QueryImplementor<R> setParameter(String name, Date value, TemporalType temporalType) {
        super.setParameter(name, value, temporalType);
        return this;
    }

    @Override
    public QueryImplementor<R> setParameter(int position, Calendar value, TemporalType temporalType) {
        super.setParameter(position, value, temporalType);
        return this;
    }

    @Override
    public QueryImplementor<R> setParameter(int position, Date value, TemporalType temporalType) {
        super.setParameter(position, value, temporalType);
        return this;
    }

    @Override
    public QueryImplementor<R> setProperties(Object bean) {
        super.setProperties(bean);
        return this;
    }

    @Override
    public QueryImplementor<R> setProperties(Map map) {
        super.setProperties(map);
        return this;
    }

    @Override
    protected void prepareForExecution() {
    }

    @Override
    public int executeUpdate() throws HibernateException {
        this.getSession().checkTransactionNeededForUpdateOperation("Executing an update/delete query");
        this.beforeQuery();
        boolean success = false;
        try {
            int result = this.doExecuteUpdate();
            success = true;
            int n = result;
            return n;
        }
        catch (IllegalQueryOperationException e) {
            throw new IllegalStateException((Throwable)((Object)e));
        }
        catch (TypeMismatchException e) {
            throw new IllegalArgumentException((Throwable)((Object)e));
        }
        catch (HibernateException e) {
            throw this.getSession().getExceptionConverter().convert(e);
        }
        finally {
            this.afterQuery(success);
        }
    }

    protected abstract int doExecuteUpdate();

    @Override
    public void setOptionalId(Serializable id) {
        throw new UnsupportedOperationException("Not sure yet how to handle this in SQM based queries, but for sure it will be different");
    }

    @Override
    public void setOptionalEntityName(String entityName) {
        throw new UnsupportedOperationException("Not sure yet how to handle this in SQM based queries, but for sure it will be different");
    }

    @Override
    public void setOptionalObject(Object optionalObject) {
        throw new UnsupportedOperationException("Not sure yet how to handle this in SQM based queries, but for sure it will be different");
    }
}

