/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.entity;

import java.io.Serializable;
import java.util.Collection;
import java.util.function.Consumer;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.StaleObjectStateException;
import org.hibernate.WrongClassException;
import org.hibernate.bytecode.enhance.spi.LazyPropertyInitializer;
import org.hibernate.bytecode.enhance.spi.interceptor.EnhancementAsProxyLazinessInterceptor;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.cache.spi.entry.CacheEntry;
import org.hibernate.engine.internal.ManagedTypeHelper;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.EntityUniqueKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.engine.spi.SessionEventListenerManager;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.service.spi.EventListenerGroup;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.PreLoadEvent;
import org.hibernate.event.spi.PreLoadEventListener;
import org.hibernate.internal.log.LoggingHelper;
import org.hibernate.internal.util.NullnessHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.loader.entity.CacheEntityLoaderHelper;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.AttributeMetadata;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.EntityValuedModelPart;
import org.hibernate.metamodel.mapping.EntityVersionMapping;
import org.hibernate.metamodel.mapping.ManagedMappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.UniqueKeyLoadable;
import org.hibernate.property.access.internal.PropertyAccessStrategyBackRefImpl;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.proxy.map.MapProxy;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.graph.AbstractFetchParentAccess;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.basic.BasicResultAssembler;
import org.hibernate.sql.results.graph.entity.EntityInitializer;
import org.hibernate.sql.results.graph.entity.EntityLoadingLogging;
import org.hibernate.sql.results.graph.entity.EntityResultGraphNode;
import org.hibernate.sql.results.graph.entity.LoadingEntityEntry;
import org.hibernate.sql.results.graph.entity.internal.EntityResultInitializer;
import org.hibernate.sql.results.internal.NullValueAssembler;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingOptions;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingState;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;
import org.hibernate.stat.spi.StatisticsImplementor;
import org.hibernate.type.AssociationType;
import org.hibernate.type.BasicType;
import org.hibernate.type.Type;

public abstract class AbstractEntityInitializer
extends AbstractFetchParentAccess
implements EntityInitializer {
    private final EntityValuedModelPart referencedModelPart;
    private final EntityPersister entityDescriptor;
    private final EntityPersister rootEntityDescriptor;
    private final NavigablePath navigablePath;
    private final LockMode lockMode;
    private final DomainResultAssembler identifierAssembler;
    private final BasicResultAssembler discriminatorAssembler;
    private final DomainResultAssembler versionAssembler;
    private final DomainResultAssembler<Object> rowIdAssembler;
    private final DomainResultAssembler[][] assemblers;
    private EntityPersister concreteDescriptor;
    private EntityKey entityKey;
    private Object entityInstance;
    private Object entityInstanceForNotify;
    private boolean missing;
    boolean isInitialized;
    private boolean isOwningInitializer;
    private Object[] resolvedEntityState;

    protected AbstractEntityInitializer(EntityResultGraphNode resultDescriptor, NavigablePath navigablePath, LockMode lockMode, Fetch identifierFetch, Fetch discriminatorFetch, DomainResult<Object> rowIdResult, AssemblerCreationState creationState) {
        this.referencedModelPart = resultDescriptor.getEntityValuedModelPart();
        this.entityDescriptor = (EntityPersister)this.referencedModelPart.getEntityMappingType();
        String rootEntityName = this.entityDescriptor.getRootEntityName();
        this.rootEntityDescriptor = rootEntityName == null || rootEntityName.equals(this.entityDescriptor.getEntityName()) ? this.entityDescriptor : this.entityDescriptor.getRootEntityDescriptor().getEntityPersister();
        this.navigablePath = navigablePath;
        this.lockMode = lockMode;
        assert (lockMode != null);
        this.identifierAssembler = identifierFetch != null ? identifierFetch.createAssembler(this, creationState) : null;
        this.discriminatorAssembler = discriminatorFetch != null ? (BasicResultAssembler)discriminatorFetch.createAssembler(this, creationState) : null;
        EntityVersionMapping versionMapping = this.entityDescriptor.getVersionMapping();
        if (versionMapping != null) {
            Fetch versionFetch = resultDescriptor.findFetch(versionMapping);
            assert (versionFetch != null);
            this.versionAssembler = versionFetch.createAssembler(this, creationState);
        } else {
            this.versionAssembler = null;
        }
        this.rowIdAssembler = rowIdResult != null ? rowIdResult.createResultAssembler(this, creationState) : null;
        Collection<EntityMappingType> subMappingTypes = this.rootEntityDescriptor.getSubMappingTypes();
        this.assemblers = new DomainResultAssembler[subMappingTypes.size() + 1][];
        this.assemblers[this.rootEntityDescriptor.getSubclassId()] = new DomainResultAssembler[this.rootEntityDescriptor.getNumberOfFetchables()];
        for (EntityMappingType subMappingType : subMappingTypes) {
            this.assemblers[subMappingType.getSubclassId()] = new DomainResultAssembler[subMappingType.getNumberOfFetchables()];
        }
        int size = this.entityDescriptor.getNumberOfFetchables();
        for (int i = 0; i < size; ++i) {
            Fetchable fetchable = this.entityDescriptor.getFetchable(i);
            AttributeMapping attributeMapping = fetchable.asAttributeMapping();
            Fetch fetch = resultDescriptor.findFetch(attributeMapping);
            DomainResultAssembler<?> stateAssembler = fetch == null ? new NullValueAssembler(attributeMapping.getMappedType().getMappedJavaType()) : fetch.createAssembler(this, creationState);
            int stateArrayPosition = attributeMapping.getStateArrayPosition();
            EntityMappingType declaringType = (EntityMappingType)attributeMapping.getDeclaringType();
            this.assemblers[declaringType.getSubclassId()][stateArrayPosition] = stateAssembler;
            for (EntityMappingType subMappingType : declaringType.getSubMappingTypes()) {
                this.assemblers[subMappingType.getSubclassId()][stateArrayPosition] = stateAssembler;
            }
        }
    }

    private static void deepCopy(ManagedMappingType containerDescriptor, Object[] source, Object[] target, EntityPersister concreteDescriptor) {
        int numberOfAttributeMappings = containerDescriptor.getNumberOfAttributeMappings();
        for (int i = 0; i < numberOfAttributeMappings; ++i) {
            AttributeMapping attributeMapping = containerDescriptor.getAttributeMapping(i);
            AttributeMetadata attributeMetadata = attributeMapping.getAttributeMetadataAccess().resolveAttributeMetadata(concreteDescriptor);
            if (!attributeMetadata.isUpdatable()) continue;
            int position = attributeMapping.getStateArrayPosition();
            Object result = source[position] == LazyPropertyInitializer.UNFETCHED_PROPERTY || source[position] == PropertyAccessStrategyBackRefImpl.UNKNOWN ? source[position] : attributeMetadata.getMutabilityPlan().deepCopy(source[position]);
            target[position] = result;
        }
    }

    @Override
    public ModelPart getInitializedPart() {
        return this.referencedModelPart;
    }

    protected abstract String getSimpleConcreteImplName();

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    protected boolean isMissing() {
        return this.missing;
    }

    protected abstract boolean isEntityReturn();

    @Override
    public EntityPersister getEntityDescriptor() {
        return this.entityDescriptor;
    }

    @Override
    public Object getEntityInstance() {
        return this.entityInstance;
    }

    public Object getKeyValue() {
        if (this.entityKey == null) {
            return null;
        }
        return this.entityKey.getIdentifier();
    }

    @Override
    public EntityKey getEntityKey() {
        return this.entityKey;
    }

    @Override
    public Object getParentKey() {
        return this.getKeyValue();
    }

    @Override
    public void registerResolutionListener(Consumer<Object> listener) {
        if (this.entityInstanceForNotify != null) {
            listener.accept(this.entityInstanceForNotify);
            return;
        }
        super.registerResolutionListener(listener);
    }

    @Override
    public void resolveKey(RowProcessingState rowProcessingState) {
        if (this.entityKey != null) {
            return;
        }
        if (EntityLoadingLogging.TRACE_ENABLED) {
            EntityLoadingLogging.ENTITY_LOADING_LOGGER.tracef("(%s) Beginning Initializer#resolveKey process for entity : %s", (Object)StringHelper.collapse(this.getClass().getName()), (Object)this.getNavigablePath());
        }
        SharedSessionContractImplementor session = rowProcessingState.getJdbcValuesSourceProcessingState().getSession();
        this.concreteDescriptor = this.determineConcreteEntityDescriptor(rowProcessingState, session);
        if (this.concreteDescriptor == null) {
            this.missing = true;
            return;
        }
        this.resolveEntityKey(rowProcessingState);
        if (this.entityKey == null) {
            EntityLoadingLogging.ENTITY_LOADING_LOGGER.debugf("(%s) EntityKey (%s) is null", (Object)this.getSimpleConcreteImplName(), (Object)this.getNavigablePath());
            assert (this.missing);
            return;
        }
        if (EntityLoadingLogging.DEBUG_ENABLED) {
            EntityLoadingLogging.ENTITY_LOADING_LOGGER.debugf("(%s) Hydrated EntityKey (%s): %s", (Object)this.getSimpleConcreteImplName(), (Object)this.getNavigablePath(), this.entityKey.getIdentifier());
        }
    }

    private EntityPersister determineConcreteEntityDescriptor(RowProcessingState rowProcessingState, SharedSessionContractImplementor session) throws WrongClassException {
        if (this.discriminatorAssembler == null) {
            return this.entityDescriptor;
        }
        Object discriminatorDomainValue = this.discriminatorAssembler.extractRawValue(rowProcessingState);
        String concreteEntityName = this.entityDescriptor.getDiscriminatorMapping().getConcreteEntityNameForDiscriminatorValue(discriminatorDomainValue);
        if (concreteEntityName == null) {
            return this.entityDescriptor;
        }
        EntityPersister concreteType = session.getFactory().getRuntimeMetamodels().getMappingMetamodel().findEntityDescriptor(concreteEntityName);
        if (concreteType == null || !concreteType.isTypeOrSuperType(this.entityDescriptor)) {
            throw new WrongClassException(concreteEntityName, null, this.entityDescriptor.getEntityName(), discriminatorDomainValue);
        }
        assert (concreteType.isTypeOrSuperType(this.entityDescriptor));
        return concreteType;
    }

    protected void resolveEntityKey(RowProcessingState rowProcessingState) {
        if (this.entityKey != null) {
            return;
        }
        JdbcValuesSourceProcessingState jdbcValuesSourceProcessingState = rowProcessingState.getJdbcValuesSourceProcessingState();
        SharedSessionContractImplementor session = jdbcValuesSourceProcessingState.getSession();
        Object id = this.initializeIdentifier(rowProcessingState, jdbcValuesSourceProcessingState);
        if (id == null) {
            this.missing = true;
            return;
        }
        this.entityKey = new EntityKey(id, this.concreteDescriptor);
        if (jdbcValuesSourceProcessingState.findInitializer(this.entityKey) == null) {
            jdbcValuesSourceProcessingState.registerInitilaizer(this.entityKey, (Initializer)this);
        }
        if (this.concreteDescriptor.isBatchLoadable() && !session.getPersistenceContext().containsEntity(this.entityKey)) {
            session.getPersistenceContext().getBatchFetchQueue().addBatchLoadableEntityKey(this.entityKey);
        }
    }

    private Object initializeIdentifier(RowProcessingState rowProcessingState, JdbcValuesSourceProcessingState jdbcValuesSourceProcessingState) {
        boolean useEmbeddedIdentifierInstanceAsEntity;
        Object id = jdbcValuesSourceProcessingState.getProcessingOptions().getEffectiveOptionalId();
        boolean bl = useEmbeddedIdentifierInstanceAsEntity = id != null && id.getClass().equals(this.concreteDescriptor.getJavaType().getJavaType());
        if (useEmbeddedIdentifierInstanceAsEntity) {
            this.entityInstance = id;
            return id;
        }
        if (this.identifierAssembler == null) {
            return id;
        }
        return this.identifierAssembler.assemble(rowProcessingState, jdbcValuesSourceProcessingState.getProcessingOptions());
    }

    @Override
    public void resolveInstance(RowProcessingState rowProcessingState) {
        if (!this.missing && !this.isInitialized) {
            if (this.shouldSkipResolveInstance(rowProcessingState)) {
                this.missing = true;
                return;
            }
            LoadingEntityEntry existingLoadingEntry = rowProcessingState.getSession().getPersistenceContextInternal().getLoadContexts().findLoadingEntityEntry(this.entityKey);
            this.setIsOwningInitializer(this.entityKey.getIdentifier(), existingLoadingEntry);
            if (this.entityInstance == null) {
                this.resolveEntityInstance(rowProcessingState, existingLoadingEntry, this.entityKey.getIdentifier());
            } else if (existingLoadingEntry != null && existingLoadingEntry.getEntityInitializer() != this) {
                this.isInitialized = true;
            }
        }
    }

    private boolean shouldSkipResolveInstance(RowProcessingState rowProcessingState) {
        Initializer parentInitializer;
        NavigablePath parent = this.navigablePath.getParent();
        return parent != null && (parentInitializer = rowProcessingState.resolveInitializer(parent)) != null && parentInitializer.isEntityInitializer() && this.isReferencedModelPartAssignableToConcreteParent(parentInitializer);
    }

    private boolean isReferencedModelPartAssignableToConcreteParent(Initializer parentInitializer) {
        ModelPart concreteModelPart;
        EntityPersister parentConcreteDescriptor = parentInitializer.asEntityInitializer().getConcreteDescriptor();
        return parentConcreteDescriptor != null && parentConcreteDescriptor.getEntityMetamodel().isPolymorphic() && ((concreteModelPart = parentConcreteDescriptor.findByPath(this.navigablePath.getLocalName())) == null || !this.referencedModelPart.getJavaType().getJavaTypeClass().isAssignableFrom(concreteModelPart.getJavaType().getJavaTypeClass()));
    }

    private void resolveEntityInstance(RowProcessingState rowProcessingState, LoadingEntityEntry existingLoadingEntry, Object entityIdentifier) {
        if (EntityLoadingLogging.TRACE_ENABLED) {
            EntityLoadingLogging.ENTITY_LOADING_LOGGER.tracef("(%s) Beginning Initializer#resolveInstance process for entity (%s) : %s", (Object)StringHelper.collapse(this.getClass().getName()), (Object)this.getNavigablePath(), entityIdentifier);
        }
        PersistenceContext persistenceContext = rowProcessingState.getSession().getPersistenceContextInternal();
        Object proxy = this.getProxy(persistenceContext);
        Object entityInstanceFromExecutionContext = rowProcessingState.getJdbcValuesSourceProcessingState().getExecutionContext().getEntityInstance();
        if (this.isProxyInstance(proxy)) {
            if (this.useEntityInstanceFromExecutionContext(entityInstanceFromExecutionContext, persistenceContext.getSession())) {
                this.entityInstance = entityInstanceFromExecutionContext;
                this.registerLoadingEntity(rowProcessingState, this.entityInstance);
            } else {
                this.entityInstance = proxy;
            }
        } else {
            Object existingEntity = persistenceContext.getEntity(this.entityKey);
            if (existingEntity != null) {
                this.entityInstance = existingEntity;
                if (existingLoadingEntry == null && this.isExistingEntityInitialized(existingEntity)) {
                    this.notifyResolutionListeners(this.entityInstance);
                    this.isInitialized = true;
                }
            } else if (this.useEntityInstanceFromExecutionContext(entityInstanceFromExecutionContext, persistenceContext.getSession())) {
                this.entityInstance = entityInstanceFromExecutionContext;
                this.registerLoadingEntity(rowProcessingState, this.entityInstance);
            } else {
                this.entityInstance = this.resolveInstance(entityIdentifier, existingLoadingEntry, rowProcessingState);
            }
            this.upgradeLockMode(rowProcessingState);
        }
    }

    private void upgradeLockMode(RowProcessingState rowProcessingState) {
        EntityEntry entry;
        if (this.lockMode != LockMode.NONE && (entry = rowProcessingState.getSession().getPersistenceContextInternal().getEntry(this.entityInstance)) != null && entry.getLockMode().lessThan(this.lockMode)) {
            if (this.versionAssembler != null && entry.getLockMode() != LockMode.NONE) {
                this.checkVersion(entry, rowProcessingState);
            }
            entry.setLockMode(this.lockMode);
        }
    }

    private boolean isProxyInstance(Object proxy) {
        return proxy != null && (proxy instanceof MapProxy || this.entityDescriptor.getJavaType().getJavaTypeClass().isInstance(proxy));
    }

    private boolean isExistingEntityInitialized(Object existingEntity) {
        LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(this.entityInstance);
        if (lazyInitializer != null) {
            return !lazyInitializer.isUninitialized();
        }
        if (ManagedTypeHelper.isPersistentAttributeInterceptable(existingEntity)) {
            PersistentAttributeInterceptor persistentAttributeInterceptor = ManagedTypeHelper.asPersistentAttributeInterceptable(this.entityInstance).$$_hibernate_getInterceptor();
            return persistentAttributeInterceptor != null && !(persistentAttributeInterceptor instanceof EnhancementAsProxyLazinessInterceptor);
        }
        return true;
    }

    private boolean useEntityInstanceFromExecutionContext(Object entityInstanceFromExecutionContext, SharedSessionContractImplementor session) {
        return this instanceof EntityResultInitializer && entityInstanceFromExecutionContext != null && this.entityKey.getIdentifier().equals(this.entityDescriptor.getIdentifier(entityInstanceFromExecutionContext, session));
    }

    private void checkVersion(EntityEntry entry, RowProcessingState rowProcessingState) throws HibernateException {
        Object currentVersion;
        BasicType<?> versionType;
        Object version = entry.getVersion();
        if (version != null && !(versionType = this.concreteDescriptor.getVersionType()).isEqual(version, currentVersion = this.versionAssembler.assemble(rowProcessingState))) {
            StatisticsImplementor statistics = rowProcessingState.getSession().getFactory().getStatistics();
            if (statistics.isStatisticsEnabled()) {
                statistics.optimisticFailure(this.concreteDescriptor.getEntityName());
            }
            throw new StaleObjectStateException(this.concreteDescriptor.getEntityName(), entry.getId());
        }
    }

    protected Object getProxy(PersistenceContext persistenceContext) {
        return persistenceContext.getProxy(this.entityKey);
    }

    private void setIsOwningInitializer(Object entityIdentifier, LoadingEntityEntry existingLoadingEntry) {
        if (existingLoadingEntry != null) {
            if (EntityLoadingLogging.DEBUG_ENABLED) {
                EntityLoadingLogging.ENTITY_LOADING_LOGGER.debugf("(%s) Found existing loading entry [%s] - using loading instance", (Object)this.getSimpleConcreteImplName(), (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), entityIdentifier));
            }
            if (existingLoadingEntry.getEntityInitializer() == this) {
                this.isOwningInitializer = true;
            }
        } else {
            this.isOwningInitializer = true;
        }
    }

    private Object resolveInstance(Object entityIdentifier, LoadingEntityEntry existingLoadingEntry, RowProcessingState rowProcessingState) {
        if (this.isOwningInitializer) {
            assert (existingLoadingEntry == null || existingLoadingEntry.getEntityInstance() == null);
            return this.resolveEntityInstance(entityIdentifier, rowProcessingState);
        }
        if (EntityLoadingLogging.DEBUG_ENABLED) {
            EntityLoadingLogging.ENTITY_LOADING_LOGGER.debugf("(%s) Entity [%s] being loaded by another initializer [%s] - skipping processing", (Object)this.getSimpleConcreteImplName(), (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), entityIdentifier), (Object)existingLoadingEntry.getEntityInitializer());
        }
        return existingLoadingEntry.getEntityInstance();
    }

    private Object resolveEntityInstance(Object entityIdentifier, RowProcessingState rowProcessingState) {
        Object cached;
        Object resolved = this.resolveToOptionalInstance(rowProcessingState);
        if (resolved != null) {
            this.registerLoadingEntity(rowProcessingState, resolved);
            return resolved;
        }
        if (this.entityDescriptor.canUseReferenceCacheEntries() && (cached = this.resolveInstanceFromCache(rowProcessingState)) != null) {
            this.isInitialized = true;
            return cached;
        }
        Object instance = this.instantiateEntity(entityIdentifier, rowProcessingState.getSession());
        this.registerLoadingEntity(rowProcessingState, instance);
        return instance;
    }

    private Object instantiateEntity(Object entityIdentifier, SharedSessionContractImplementor session) {
        Object instance = session.instantiate(this.concreteDescriptor.getEntityName(), this.entityKey.getIdentifier());
        if (EntityLoadingLogging.DEBUG_ENABLED) {
            EntityLoadingLogging.ENTITY_LOADING_LOGGER.debugf("(%s) Created new entity instance [%s] : %s", (Object)this.getSimpleConcreteImplName(), (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), entityIdentifier), instance);
        }
        return instance;
    }

    private Object resolveToOptionalInstance(RowProcessingState rowProcessingState) {
        if (this.isEntityReturn()) {
            JdbcValuesSourceProcessingOptions processingOptions = rowProcessingState.getJdbcValuesSourceProcessingState().getProcessingOptions();
            return this.matchesOptionalInstance(processingOptions) ? processingOptions.getEffectiveOptionalObject() : null;
        }
        return null;
    }

    private boolean matchesOptionalInstance(JdbcValuesSourceProcessingOptions processingOptions) {
        Object optionalEntityInstance = processingOptions.getEffectiveOptionalObject();
        Object requestedEntityId = processingOptions.getEffectiveOptionalId();
        return requestedEntityId != null && optionalEntityInstance != null && requestedEntityId.equals(this.entityKey.getIdentifier());
    }

    private Object resolveInstanceFromCache(RowProcessingState rowProcessingState) {
        return CacheEntityLoaderHelper.INSTANCE.loadFromSecondLevelCache((EventSource)rowProcessingState.getSession(), null, this.lockMode, this.entityDescriptor, this.entityKey);
    }

    private void registerLoadingEntity(RowProcessingState rowProcessingState, Object instance) {
        LoadingEntityEntry loadingEntry = new LoadingEntityEntry(this, this.entityKey, this.concreteDescriptor, instance);
        rowProcessingState.getJdbcValuesSourceProcessingState().registerLoadingEntity(this.entityKey, loadingEntry);
    }

    @Override
    public void initializeInstance(RowProcessingState rowProcessingState) {
        if (this.missing || this.isInitialized) {
            return;
        }
        this.preLoad(rowProcessingState);
        SharedSessionContractImplementor session = rowProcessingState.getJdbcValuesSourceProcessingState().getSession();
        PersistenceContext persistenceContext = session.getPersistenceContext();
        LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(this.entityInstance);
        if (lazyInitializer != null) {
            Object instance = persistenceContext.getEntity(this.entityKey);
            if (instance == null) {
                instance = this.resolveInstance(this.entityKey.getIdentifier(), persistenceContext.getLoadContexts().findLoadingEntityEntry(this.entityKey), rowProcessingState);
                this.initializeEntity(instance, rowProcessingState, session, persistenceContext);
            }
            lazyInitializer.setImplementation(instance);
            this.entityInstanceForNotify = instance;
        } else {
            this.initializeEntity(this.entityInstance, rowProcessingState, session, persistenceContext);
            this.entityInstanceForNotify = this.entityInstance;
        }
        this.notifyResolutionListeners(this.entityInstanceForNotify);
        this.isInitialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeEntity(Object toInitialize, RowProcessingState rowProcessingState, SharedSessionContractImplementor session, PersistenceContext persistenceContext) {
        Type[] persistentAttributeInterceptor;
        Status status;
        EntityEntry entry = persistenceContext.getEntry(toInitialize);
        if (entry != null && this.skipInitialization(toInitialize, rowProcessingState, entry)) {
            return;
        }
        assert (NullnessHelper.coalesce(persistenceContext.getEntity(this.entityKey), toInitialize) == toInitialize);
        Object entityIdentifier = this.entityKey.getIdentifier();
        if (EntityLoadingLogging.TRACE_ENABLED) {
            EntityLoadingLogging.ENTITY_LOADING_LOGGER.tracef("(%s) Beginning Initializer#initializeInstance process for entity %s", (Object)this.getSimpleConcreteImplName(), (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), entityIdentifier));
        }
        if (entry != null && ((status = entry.getStatus()) == Status.DELETED || status == Status.GONE)) {
            return;
        }
        this.entityDescriptor.setIdentifier(toInitialize, entityIdentifier, session);
        this.resolvedEntityState = this.extractConcreteTypeStateValues(rowProcessingState);
        if (ManagedTypeHelper.isPersistentAttributeInterceptable(toInitialize) && ((persistentAttributeInterceptor = ManagedTypeHelper.asPersistentAttributeInterceptable(toInitialize).$$_hibernate_getInterceptor()) == null || persistentAttributeInterceptor instanceof EnhancementAsProxyLazinessInterceptor)) {
            this.concreteDescriptor.getBytecodeEnhancementMetadata().injectInterceptor(toInitialize, entityIdentifier, session);
        }
        this.concreteDescriptor.setPropertyValues(toInitialize, this.resolvedEntityState);
        persistenceContext.addEntity(this.entityKey, toInitialize);
        for (Type propertyType : this.concreteDescriptor.getPropertyTypes()) {
            AssociationType associationType;
            String ukName;
            if (!(propertyType instanceof AssociationType) || (ukName = (associationType = (AssociationType)propertyType).getLHSPropertyName()) == null) continue;
            int index = ((UniqueKeyLoadable)this.concreteDescriptor).getPropertyIndex(ukName);
            Type type = this.concreteDescriptor.getPropertyTypes()[index];
            if (this.resolvedEntityState[index] == null) continue;
            EntityUniqueKey euk = new EntityUniqueKey(this.concreteDescriptor.getRootEntityDescriptor().getEntityName(), ukName, this.resolvedEntityState[index], type, session.getFactory());
            session.getPersistenceContextInternal().addEntity(euk, toInitialize);
        }
        Object version = this.versionAssembler != null ? this.versionAssembler.assemble(rowProcessingState) : null;
        Object rowId = this.rowIdAssembler != null ? this.rowIdAssembler.assemble(rowProcessingState) : null;
        LockMode lockModeToAcquire = this.lockMode == LockMode.NONE ? LockMode.READ : this.lockMode;
        EntityEntry entityEntry = persistenceContext.addEntry(toInitialize, Status.LOADING, this.resolvedEntityState, rowId, this.entityKey.getIdentifier(), version, lockModeToAcquire, true, this.concreteDescriptor, false);
        SessionFactoryImplementor factory = session.getFactory();
        EntityDataAccess cacheAccess = this.concreteDescriptor.getCacheAccessStrategy();
        StatisticsImplementor statistics = factory.getStatistics();
        if (!rowProcessingState.isQueryCacheHit() && cacheAccess != null && session.getCacheMode().isPutEnabled()) {
            if (EntityLoadingLogging.DEBUG_ENABLED) {
                EntityLoadingLogging.ENTITY_LOADING_LOGGER.debugf("(%S) Adding entityInstance to second-level cache: %s", (Object)this.getSimpleConcreteImplName(), (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), entityIdentifier));
            }
            CacheEntry cacheEntry = this.concreteDescriptor.buildCacheEntry(toInitialize, this.resolvedEntityState, version, session);
            Object cacheKey = cacheAccess.generateCacheKey(entityIdentifier, this.rootEntityDescriptor, factory, session.getTenantIdentifier());
            if (persistenceContext.wasInsertedDuringTransaction(this.concreteDescriptor, entityIdentifier)) {
                cacheAccess.update(session, cacheKey, this.rootEntityDescriptor.getCacheEntryStructure().structure(cacheEntry), version, version);
            } else {
                SessionEventListenerManager eventListenerManager = session.getEventListenerManager();
                try {
                    eventListenerManager.cachePutStart();
                    boolean put = cacheAccess.putFromLoad(session, cacheKey, this.rootEntityDescriptor.getCacheEntryStructure().structure(cacheEntry), version, false);
                    if (put && statistics.isStatisticsEnabled()) {
                        statistics.entityCachePut(this.rootEntityDescriptor.getNavigableRole(), cacheAccess.getRegion().getName());
                    }
                }
                finally {
                    eventListenerManager.cachePutEnd();
                }
            }
        }
        if (this.entityDescriptor.getNaturalIdMapping() != null) {
            persistenceContext.getNaturalIdResolutions().cacheResolutionFromLoad(entityIdentifier, this.entityDescriptor.getNaturalIdMapping().extractNaturalIdFromEntityState(this.resolvedEntityState, session), this.entityDescriptor);
        }
        boolean isReallyReadOnly = this.isReadOnly(rowProcessingState, session);
        if (!this.concreteDescriptor.isMutable()) {
            isReallyReadOnly = true;
        } else {
            LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(this.entityInstance);
            if (lazyInitializer != null) {
                isReallyReadOnly = lazyInitializer.isReadOnly();
            }
        }
        if (isReallyReadOnly) {
            persistenceContext.setEntryStatus(entityEntry, Status.READ_ONLY);
        } else {
            AbstractEntityInitializer.deepCopy(this.concreteDescriptor, this.resolvedEntityState, this.resolvedEntityState, this.concreteDescriptor);
            persistenceContext.setEntryStatus(entityEntry, Status.MANAGED);
        }
        this.concreteDescriptor.afterInitialize(toInitialize, session);
        if (EntityLoadingLogging.DEBUG_ENABLED) {
            EntityLoadingLogging.ENTITY_LOADING_LOGGER.debugf("(%s) Done materializing entityInstance : %s", (Object)this.getSimpleConcreteImplName(), (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), entityIdentifier));
        }
        if (statistics.isStatisticsEnabled() && !rowProcessingState.isQueryCacheHit()) {
            statistics.loadEntity(this.concreteDescriptor.getEntityName());
        }
    }

    private Object[] extractConcreteTypeStateValues(RowProcessingState rowProcessingState) {
        Object[] values = new Object[this.concreteDescriptor.getNumberOfAttributeMappings()];
        DomainResultAssembler[] concreteAssemblers = this.assemblers[this.concreteDescriptor.getSubclassId()];
        for (int i = 0; i < values.length; ++i) {
            DomainResultAssembler assembler = concreteAssemblers[i];
            Serializable value = assembler == null ? LazyPropertyInitializer.UNFETCHED_PROPERTY : assembler.assemble(rowProcessingState);
            values[i] = value;
        }
        return values;
    }

    private boolean skipInitialization(Object toInitialize, RowProcessingState rowProcessingState, EntityEntry entry) {
        PersistentAttributeInterceptor interceptor;
        if (!this.isOwningInitializer) {
            return true;
        }
        if (ManagedTypeHelper.isPersistentAttributeInterceptable(toInitialize) && (interceptor = ManagedTypeHelper.asPersistentAttributeInterceptable(toInitialize).$$_hibernate_getInterceptor()) instanceof EnhancementAsProxyLazinessInterceptor) {
            return entry.getStatus() == Status.LOADING;
        }
        if (entry.getStatus() != Status.LOADING) {
            Object optionalEntityInstance = rowProcessingState.getJdbcValuesSourceProcessingState().getProcessingOptions().getEffectiveOptionalObject();
            if (!this.isEntityReturn() || toInitialize != optionalEntityInstance) {
                return true;
            }
        }
        return false;
    }

    private boolean isReadOnly(RowProcessingState rowProcessingState, SharedSessionContractImplementor persistenceContext) {
        Boolean readOnly = rowProcessingState.getQueryOptions().isReadOnly();
        return readOnly == null ? persistenceContext.isDefaultReadOnly() : readOnly.booleanValue();
    }

    private void preLoad(RowProcessingState rowProcessingState) {
        SharedSessionContractImplementor session = rowProcessingState.getJdbcValuesSourceProcessingState().getSession();
        if (session instanceof EventSource) {
            PreLoadEvent preLoadEvent = rowProcessingState.getJdbcValuesSourceProcessingState().getPreLoadEvent();
            assert (preLoadEvent != null);
            preLoadEvent.reset();
            preLoadEvent.setEntity(this.entityInstance).setId(this.entityKey.getIdentifier()).setPersister(this.concreteDescriptor);
            EventListenerGroup<PreLoadEventListener> listenerGroup = session.getFactory().getFastSessionServices().eventListenerGroup_PRE_LOAD;
            for (PreLoadEventListener listener : listenerGroup.listeners()) {
                listener.onPreLoad(preLoadEvent);
            }
        }
    }

    @Override
    public boolean isInitialized() {
        return this.isInitialized;
    }

    @Override
    public EntityPersister getConcreteDescriptor() {
        return this.concreteDescriptor;
    }

    @Override
    public void finishUpRow(RowProcessingState rowProcessingState) {
        this.isOwningInitializer = false;
        this.concreteDescriptor = null;
        this.entityKey = null;
        this.entityInstance = null;
        this.entityInstanceForNotify = null;
        this.missing = false;
        this.resolvedEntityState = null;
        this.isInitialized = false;
        this.clearResolutionListeners();
    }
}

