/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.action.internal;

import java.io.Serializable;
import org.hibernate.AssertionFailure;
import org.hibernate.action.internal.ComparableEntityAction;
import org.hibernate.action.internal.DelayedPostInsertIdentifier;
import org.hibernate.action.spi.AfterTransactionCompletionProcess;
import org.hibernate.action.spi.BeforeTransactionCompletionProcess;
import org.hibernate.action.spi.Executable;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.event.spi.EventSource;
import org.hibernate.internal.FastSessionServices;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;

public abstract class EntityAction
implements ComparableEntityAction,
Executable,
Serializable,
AfterTransactionCompletionProcess {
    private final String entityName;
    private final Object id;
    private transient Object instance;
    private transient EventSource session;
    private transient EntityPersister persister;
    private transient boolean veto;

    protected EntityAction(EventSource session, Object id, Object instance, EntityPersister persister) {
        this.entityName = persister.getEntityName();
        this.id = id;
        this.instance = instance;
        this.session = session;
        this.persister = persister;
    }

    public boolean isVeto() {
        return this.veto;
    }

    public void setVeto(boolean veto) {
        this.veto = veto;
    }

    @Override
    public BeforeTransactionCompletionProcess getBeforeTransactionCompletionProcess() {
        return null;
    }

    @Override
    public AfterTransactionCompletionProcess getAfterTransactionCompletionProcess() {
        return this.needsAfterTransactionCompletion() ? this : null;
    }

    protected abstract boolean hasPostCommitEventListeners();

    protected boolean needsAfterTransactionCompletion() {
        return this.persister.canWriteToCache() || this.hasPostCommitEventListeners();
    }

    @Override
    public String getEntityName() {
        return this.entityName;
    }

    @Override
    public final Object getId() {
        if (this.id instanceof DelayedPostInsertIdentifier) {
            EntityEntry entry = this.session.getPersistenceContextInternal().getEntry(this.instance);
            Object eeId = entry == null ? null : entry.getId();
            return eeId instanceof DelayedPostInsertIdentifier ? null : eeId;
        }
        return this.id;
    }

    public final DelayedPostInsertIdentifier getDelayedId() {
        return this.id instanceof DelayedPostInsertIdentifier ? (DelayedPostInsertIdentifier)this.id : null;
    }

    public final Object getInstance() {
        return this.instance;
    }

    public final EventSource getSession() {
        return this.session;
    }

    public final EntityPersister getPersister() {
        return this.persister;
    }

    @Override
    public final Serializable[] getPropertySpaces() {
        return this.persister.getPropertySpaces();
    }

    @Override
    public void beforeExecutions() {
        throw new AssertionFailure("beforeExecutions() called for non-collection action");
    }

    public String toString() {
        return StringHelper.unqualify(this.getClass().getName()) + MessageHelper.infoString(this.entityName, this.id);
    }

    @Override
    public int compareTo(ComparableEntityAction action) {
        int roleComparison = this.entityName.compareTo(action.getEntityName());
        return roleComparison != 0 ? roleComparison : this.persister.getIdentifierType().compare(this.id, action.getId());
    }

    @Override
    public void afterDeserialize(EventSource session) {
        if (this.session != null || this.persister != null) {
            throw new IllegalStateException("already attached to a session.");
        }
        if (session != null) {
            this.session = session;
            this.persister = session.getFactory().getMappingMetamodel().getEntityDescriptor(this.entityName);
            this.instance = session.getPersistenceContext().getEntity(session.generateEntityKey(this.id, this.persister));
        }
    }

    protected EventSource eventSource() {
        return this.getSession();
    }

    protected FastSessionServices getFastSessionServices() {
        return this.session.getFactory().getFastSessionServices();
    }
}

