/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.action.internal;

import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.action.internal.EntityAction;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.cache.spi.entry.CacheEntry;
import org.hibernate.engine.internal.Versioning;
import org.hibernate.engine.spi.CachedNaturalIdValueSource;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.SessionEventListenerManager;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.service.spi.EventListenerGroup;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.PostCommitUpdateEventListener;
import org.hibernate.event.spi.PostUpdateEvent;
import org.hibernate.event.spi.PostUpdateEventListener;
import org.hibernate.event.spi.PreUpdateEvent;
import org.hibernate.event.spi.PreUpdateEventListener;
import org.hibernate.metamodel.mapping.NaturalIdMapping;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.stat.internal.StatsHelper;
import org.hibernate.stat.spi.StatisticsImplementor;
import org.hibernate.tuple.entity.EntityMetamodel;
import org.hibernate.type.TypeHelper;

public class EntityUpdateAction
extends EntityAction {
    private final Object[] state;
    private final Object[] previousState;
    private final Object previousVersion;
    private final int[] dirtyFields;
    private final boolean hasDirtyCollection;
    private final Object rowId;
    private final NaturalIdMapping naturalIdMapping;
    private final Object previousNaturalIdValues;
    private Object nextVersion;
    private Object cacheEntry;
    private SoftLock lock;

    public EntityUpdateAction(Object id, Object[] state, int[] dirtyProperties, boolean hasDirtyCollection, Object[] previousState, Object previousVersion, Object nextVersion, Object instance, Object rowId, EntityPersister persister, EventSource session) {
        super(session, id, instance, persister);
        this.state = state;
        this.previousState = previousState;
        this.previousVersion = previousVersion;
        this.nextVersion = nextVersion;
        this.dirtyFields = dirtyProperties;
        this.hasDirtyCollection = hasDirtyCollection;
        this.rowId = rowId;
        this.naturalIdMapping = persister.getNaturalIdMapping();
        if (this.naturalIdMapping == null) {
            this.previousNaturalIdValues = null;
        } else {
            this.previousNaturalIdValues = EntityUpdateAction.determinePreviousNaturalIdValues(persister, this.naturalIdMapping, id, previousState, session);
            session.getPersistenceContextInternal().getNaturalIdResolutions().manageLocalResolution(id, this.naturalIdMapping.extractNaturalIdFromEntityState(state, session), persister, CachedNaturalIdValueSource.UPDATE);
        }
    }

    private static Object determinePreviousNaturalIdValues(EntityPersister persister, NaturalIdMapping naturalIdMapping, Object id, Object[] previousState, SharedSessionContractImplementor session) {
        return previousState == null ? session.getPersistenceContextInternal().getNaturalIdSnapshot(id, persister) : naturalIdMapping.extractNaturalIdFromEntityState(previousState, session);
    }

    protected Object[] getState() {
        return this.state;
    }

    protected Object[] getPreviousState() {
        return this.previousState;
    }

    protected Object getNextVersion() {
        return this.nextVersion;
    }

    protected int[] getDirtyFields() {
        return this.dirtyFields;
    }

    protected boolean hasDirtyCollection() {
        return this.hasDirtyCollection;
    }

    protected NaturalIdMapping getNaturalIdMapping() {
        return this.naturalIdMapping;
    }

    protected Object getPreviousNaturalIdValues() {
        return this.previousNaturalIdValues;
    }

    public Object getRowId() {
        return this.rowId;
    }

    protected void setLock(SoftLock lock) {
        this.lock = lock;
    }

    protected void setCacheEntry(Object cacheEntry) {
        this.cacheEntry = cacheEntry;
    }

    @Override
    public void execute() throws HibernateException {
        if (!this.preUpdate()) {
            EntityPersister persister = this.getPersister();
            EventSource session = this.getSession();
            Object id = this.getId();
            Object instance = this.getInstance();
            Object previousVersion = this.getPreviousVersion();
            Object ck = this.lockCacheItem(previousVersion);
            persister.update(id, this.state, this.dirtyFields, this.hasDirtyCollection, this.previousState, previousVersion, instance, this.rowId, session);
            EntityEntry entry = session.getPersistenceContextInternal().getEntry(instance);
            if (entry == null) {
                throw new AssertionFailure("possible non thread safe access to session");
            }
            this.handleGeneratedProperties(entry);
            this.updateCacheItem(previousVersion, ck, entry);
            this.handleNaturalIdResolutions(persister, session, id);
            this.postUpdate();
            StatisticsImplementor statistics = session.getFactory().getStatistics();
            if (statistics.isStatisticsEnabled()) {
                statistics.updateEntity(this.getPersister().getEntityName());
            }
        }
    }

    private void handleNaturalIdResolutions(EntityPersister persister, SharedSessionContractImplementor session, Object id) {
        if (this.naturalIdMapping != null) {
            session.getPersistenceContextInternal().getNaturalIdResolutions().manageSharedResolution(id, this.naturalIdMapping.extractNaturalIdFromEntityState(this.state, session), this.previousNaturalIdValues, persister, CachedNaturalIdValueSource.UPDATE);
        }
    }

    private void updateCacheItem(Object previousVersion, Object ck, EntityEntry entry) {
        EntityPersister persister = this.getPersister();
        if (persister.canWriteToCache()) {
            EventSource session = this.getSession();
            if (persister.isCacheInvalidationRequired() || entry.getStatus() != Status.MANAGED) {
                persister.getCacheAccessStrategy().remove(session, ck);
            } else if (session.getCacheMode().isPutEnabled()) {
                CacheEntry ce = persister.buildCacheEntry(this.getInstance(), this.state, this.nextVersion, this.getSession());
                this.cacheEntry = persister.getCacheEntryStructure().structure(ce);
                boolean put = this.updateCache(persister, previousVersion, ck);
                StatisticsImplementor statistics = session.getFactory().getStatistics();
                if (put && statistics.isStatisticsEnabled()) {
                    statistics.entityCachePut(StatsHelper.INSTANCE.getRootEntityRole(persister), this.getPersister().getCacheAccessStrategy().getRegion().getName());
                }
            }
        }
    }

    private void handleGeneratedProperties(EntityEntry entry) {
        EntityPersister persister = this.getPersister();
        Object instance = this.getInstance();
        if (entry.getStatus() == Status.MANAGED || persister.isVersionPropertyGenerated()) {
            EventSource session = this.getSession();
            Object id = this.getId();
            TypeHelper.deepCopy(this.state, persister.getPropertyTypes(), persister.getPropertyCheckability(), this.state, session);
            if (persister.hasUpdateGeneratedProperties()) {
                persister.processUpdateGeneratedProperties(id, instance, this.state, session);
            }
            if (persister.isVersionPropertyGenerated()) {
                this.nextVersion = Versioning.getVersion(this.state, persister);
            }
            entry.postUpdate(instance, this.state, this.nextVersion);
        }
        if (entry.getStatus() == Status.DELETED) {
            boolean isImpliedOptimisticLocking;
            EntityMetamodel entityMetamodel = persister.getEntityMetamodel();
            boolean bl = isImpliedOptimisticLocking = !entityMetamodel.isVersioned() && entityMetamodel.getOptimisticLockStyle().isAllOrDirty();
            if (isImpliedOptimisticLocking && entry.getLoadedState() != null) {
                entry.postUpdate(instance, this.state, this.nextVersion);
            }
        }
    }

    protected Object getPreviousVersion() {
        EntityPersister persister = this.getPersister();
        if (persister.isVersionPropertyGenerated()) {
            return persister.getVersion(this.getInstance());
        }
        return this.previousVersion;
    }

    private Object lockCacheItem(Object previousVersion) {
        EntityPersister persister = this.getPersister();
        if (persister.canWriteToCache()) {
            EventSource session = this.getSession();
            EntityDataAccess cache = persister.getCacheAccessStrategy();
            Object ck = cache.generateCacheKey(this.getId(), persister, session.getFactory(), session.getTenantIdentifier());
            this.lock = cache.lockItem(session, ck, previousVersion);
            return ck;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean updateCache(EntityPersister persister, Object previousVersion, Object ck) {
        EventSource session = this.getSession();
        try {
            session.getEventListenerManager().cachePutStart();
            boolean bl = persister.getCacheAccessStrategy().update(session, ck, this.cacheEntry, this.nextVersion, previousVersion);
            return bl;
        }
        finally {
            session.getEventListenerManager().cachePutEnd();
        }
    }

    protected boolean preUpdate() {
        EventListenerGroup<PreUpdateEventListener> listenerGroup = this.getFastSessionServices().eventListenerGroup_PRE_UPDATE;
        if (listenerGroup.isEmpty()) {
            return false;
        }
        PreUpdateEvent event = new PreUpdateEvent(this.getInstance(), this.getId(), this.state, this.previousState, this.getPersister(), this.eventSource());
        boolean veto = false;
        for (PreUpdateEventListener listener : listenerGroup.listeners()) {
            veto |= listener.onPreUpdate(event);
        }
        return veto;
    }

    protected void postUpdate() {
        this.getFastSessionServices().eventListenerGroup_POST_UPDATE.fireLazyEventOnEachListener(this::newPostUpdateEvent, PostUpdateEventListener::onPostUpdate);
    }

    private PostUpdateEvent newPostUpdateEvent() {
        return new PostUpdateEvent(this.getInstance(), this.getId(), this.state, this.previousState, this.dirtyFields, this.getPersister(), this.eventSource());
    }

    protected void postCommitUpdate(boolean success) {
        this.getFastSessionServices().eventListenerGroup_POST_COMMIT_UPDATE.fireLazyEventOnEachListener(this::newPostUpdateEvent, success ? PostUpdateEventListener::onPostUpdate : this::onPostCommitFailure);
    }

    private void onPostCommitFailure(PostUpdateEventListener listener, PostUpdateEvent event) {
        if (listener instanceof PostCommitUpdateEventListener) {
            ((PostCommitUpdateEventListener)listener).onPostUpdateCommitFailed(event);
        } else {
            listener.onPostUpdate(event);
        }
    }

    @Override
    protected boolean hasPostCommitEventListeners() {
        EventListenerGroup<PostUpdateEventListener> group = this.getFastSessionServices().eventListenerGroup_POST_COMMIT_UPDATE;
        for (PostUpdateEventListener listener : group.listeners()) {
            if (!listener.requiresPostCommitHandling(this.getPersister())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void doAfterTransactionCompletion(boolean success, SharedSessionContractImplementor session) throws CacheException {
        this.updateCacheIfNecessary(success, session);
        this.postCommitUpdate(success);
    }

    private void updateCacheIfNecessary(boolean success, SharedSessionContractImplementor session) {
        EntityPersister persister = this.getPersister();
        if (persister.canWriteToCache()) {
            EntityDataAccess cache = persister.getCacheAccessStrategy();
            SessionFactoryImplementor factory = session.getFactory();
            Object ck = cache.generateCacheKey(this.getId(), persister, factory, session.getTenantIdentifier());
            if (this.cacheUpdateRequired(success, persister, session)) {
                this.cacheAfterUpdate(cache, ck, session);
            } else {
                cache.unlockItem(session, ck, this.lock);
            }
        }
    }

    private boolean cacheUpdateRequired(boolean success, EntityPersister persister, SharedSessionContractImplementor session) {
        return success && this.cacheEntry != null && !persister.isCacheInvalidationRequired() && session.getCacheMode().isPutEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cacheAfterUpdate(EntityDataAccess cache, Object ck, SharedSessionContractImplementor session) {
        SessionEventListenerManager eventListenerManager = session.getEventListenerManager();
        try {
            eventListenerManager.cachePutStart();
            boolean put = cache.afterUpdate(session, ck, this.cacheEntry, this.nextVersion, this.previousVersion, this.lock);
            StatisticsImplementor statistics = session.getFactory().getStatistics();
            if (put && statistics.isStatisticsEnabled()) {
                statistics.entityCachePut(StatsHelper.INSTANCE.getRootEntityRole(this.getPersister()), cache.getRegion().getName());
            }
        }
        finally {
            eventListenerManager.cachePutEnd();
        }
    }
}

