/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.convert.spi;

import com.fasterxml.classmate.ResolvedType;
import jakarta.persistence.AttributeConverter;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import org.hibernate.boot.model.convert.internal.AutoApplicableConverterDescriptorBypassedImpl;
import org.hibernate.boot.model.convert.internal.AutoApplicableConverterDescriptorStandardImpl;
import org.hibernate.boot.model.convert.internal.ConverterHelper;
import org.hibernate.boot.model.convert.spi.AutoApplicableConverterDescriptor;
import org.hibernate.boot.model.convert.spi.ConverterDescriptor;
import org.hibernate.boot.model.convert.spi.JpaAttributeConverterCreationContext;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.metamodel.model.convert.internal.JpaAttributeConverterImpl;
import org.hibernate.metamodel.model.convert.spi.JpaAttributeConverter;
import org.hibernate.resource.beans.spi.ManagedBean;
import org.hibernate.type.descriptor.java.spi.JavaTypeRegistry;
import org.hibernate.type.spi.TypeConfiguration;

public class RegisteredConversion {
    private final Class<?> explicitDomainType;
    private final Class<? extends AttributeConverter<?, ?>> converterType;
    private final boolean autoApply;
    private final ConverterDescriptor converterDescriptor;

    public RegisteredConversion(Class<?> explicitDomainType, Class<? extends AttributeConverter<?, ?>> converterType, boolean autoApply, MetadataBuildingContext context) {
        assert (converterType != null);
        this.explicitDomainType = explicitDomainType;
        this.converterType = converterType;
        this.autoApply = autoApply;
        this.converterDescriptor = RegisteredConversion.determineConverterDescriptor(explicitDomainType, converterType, autoApply, context);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegisteredConversion that = (RegisteredConversion)o;
        return this.autoApply == that.autoApply && Objects.equals(this.explicitDomainType, that.explicitDomainType) && this.converterType.equals(that.converterType);
    }

    public int hashCode() {
        return Objects.hash(this.explicitDomainType, this.converterType);
    }

    private static ConverterDescriptor determineConverterDescriptor(Class<?> explicitDomainType, Class<? extends AttributeConverter<?, ?>> converterType, boolean autoApply, MetadataBuildingContext context) {
        List<ResolvedType> resolvedParamTypes = ConverterHelper.resolveConverterClassParamTypes(converterType, context.getBootstrapContext().getClassmateContext());
        ResolvedType relationalType = resolvedParamTypes.get(1);
        ResolvedType domainTypeToMatch = !Void.TYPE.equals(explicitDomainType) ? context.getBootstrapContext().getClassmateContext().getTypeResolver().resolve(explicitDomainType, new Type[0]) : resolvedParamTypes.get(0);
        return new ConverterDescriptorImpl(converterType, domainTypeToMatch, relationalType, autoApply);
    }

    public Class<?> getExplicitDomainType() {
        return this.explicitDomainType;
    }

    public Class<? extends AttributeConverter<?, ?>> getConverterType() {
        return this.converterType;
    }

    public boolean isAutoApply() {
        return this.autoApply;
    }

    public ConverterDescriptor getConverterDescriptor() {
        return this.converterDescriptor;
    }

    private static class ConverterDescriptorImpl
    implements ConverterDescriptor {
        private final Class<? extends AttributeConverter<?, ?>> converterType;
        private final ResolvedType domainTypeToMatch;
        private final ResolvedType relationalType;
        private final boolean autoApply;
        private final AutoApplicableConverterDescriptor autoApplyDescriptor;

        public ConverterDescriptorImpl(Class<? extends AttributeConverter<?, ?>> converterType, ResolvedType domainTypeToMatch, ResolvedType relationalType, boolean autoApply) {
            this.converterType = converterType;
            this.domainTypeToMatch = domainTypeToMatch;
            this.relationalType = relationalType;
            this.autoApply = autoApply;
            this.autoApplyDescriptor = autoApply ? new AutoApplicableConverterDescriptorStandardImpl(this) : AutoApplicableConverterDescriptorBypassedImpl.INSTANCE;
        }

        @Override
        public Class<? extends AttributeConverter<?, ?>> getAttributeConverterClass() {
            return this.converterType;
        }

        @Override
        public ResolvedType getDomainValueResolvedType() {
            return this.domainTypeToMatch;
        }

        @Override
        public ResolvedType getRelationalValueResolvedType() {
            return this.relationalType;
        }

        @Override
        public AutoApplicableConverterDescriptor getAutoApplyDescriptor() {
            return this.autoApplyDescriptor;
        }

        @Override
        public JpaAttributeConverter<?, ?> createJpaAttributeConverter(JpaAttributeConverterCreationContext context) {
            ManagedBean<AttributeConverter<?, ?>> converterBean = context.getManagedBeanRegistry().getBean(this.converterType);
            TypeConfiguration typeConfiguration = context.getTypeConfiguration();
            JavaTypeRegistry javaTypeRegistry = typeConfiguration.getJavaTypeRegistry();
            javaTypeRegistry.resolveDescriptor(this.domainTypeToMatch.getErasedType());
            return new JpaAttributeConverterImpl(converterBean, javaTypeRegistry.getDescriptor(converterBean.getBeanClass()), javaTypeRegistry.resolveDescriptor(this.domainTypeToMatch.getErasedType()), javaTypeRegistry.resolveDescriptor(this.relationalType.getErasedType()));
        }
    }
}

