/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.DiscriminatorColumn;
import jakarta.persistence.DiscriminatorType;
import org.hibernate.AssertionFailure;
import org.hibernate.annotations.DiscriminatorFormula;
import org.hibernate.boot.model.internal.AnnotatedColumn;
import org.hibernate.boot.model.internal.AnnotatedColumns;
import org.hibernate.boot.spi.MetadataBuildingContext;

public class AnnotatedDiscriminatorColumn
extends AnnotatedColumn {
    public static final String DEFAULT_DISCRIMINATOR_COLUMN_NAME = "DTYPE";
    public static final String DEFAULT_DISCRIMINATOR_TYPE = "string";
    private static final long DEFAULT_DISCRIMINATOR_LENGTH = 31L;
    private String discriminatorTypeName;

    public AnnotatedDiscriminatorColumn() {
        this.setLogicalColumnName(DEFAULT_DISCRIMINATOR_COLUMN_NAME);
        this.setNullable(false);
        this.setDiscriminatorTypeName(DEFAULT_DISCRIMINATOR_TYPE);
        this.setLength(31L);
    }

    public String getDiscriminatorTypeName() {
        return this.discriminatorTypeName;
    }

    public void setDiscriminatorTypeName(String discriminatorTypeName) {
        this.discriminatorTypeName = discriminatorTypeName;
    }

    public static AnnotatedDiscriminatorColumn buildDiscriminatorColumn(DiscriminatorType type, DiscriminatorColumn discriminatorColumn, DiscriminatorFormula discriminatorFormula, MetadataBuildingContext context) {
        AnnotatedColumns parent = new AnnotatedColumns();
        parent.setBuildingContext(context);
        AnnotatedDiscriminatorColumn column = new AnnotatedDiscriminatorColumn();
        if (discriminatorFormula != null) {
            column.setImplicit(false);
            column.setFormula(discriminatorFormula.value());
        } else if (discriminatorColumn != null) {
            column.setImplicit(false);
            if (!discriminatorColumn.columnDefinition().isEmpty()) {
                column.setSqlType(discriminatorColumn.columnDefinition());
            }
            if (!discriminatorColumn.name().isEmpty()) {
                column.setLogicalColumnName(discriminatorColumn.name());
            }
            column.setNullable(false);
        } else {
            column.setImplicit(true);
        }
        AnnotatedDiscriminatorColumn.setDiscriminatorType(type, discriminatorColumn, column);
        column.setParent(parent);
        column.bind();
        return column;
    }

    private static void setDiscriminatorType(DiscriminatorType type, DiscriminatorColumn discriminatorColumn, AnnotatedDiscriminatorColumn column) {
        if (type == null) {
            column.setDiscriminatorTypeName(DEFAULT_DISCRIMINATOR_TYPE);
        } else {
            switch (type) {
                case CHAR: {
                    column.setDiscriminatorTypeName("character");
                    column.setImplicit(false);
                    break;
                }
                case INTEGER: {
                    column.setDiscriminatorTypeName("integer");
                    column.setImplicit(false);
                    break;
                }
                case STRING: {
                    column.setDiscriminatorTypeName(DEFAULT_DISCRIMINATOR_TYPE);
                    if (discriminatorColumn == null) break;
                    column.setLength(Long.valueOf(discriminatorColumn.length()));
                    break;
                }
                default: {
                    throw new AssertionFailure("Unknown discriminator type: " + type);
                }
            }
        }
    }
}

