/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.AttributeConverter;
import jakarta.persistence.Basic;
import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Embeddable;
import jakarta.persistence.Embedded;
import jakarta.persistence.EmbeddedId;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinColumns;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MapsId;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.NamedStoredProcedureQueries;
import jakarta.persistence.NamedStoredProcedureQuery;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.SequenceGenerators;
import jakarta.persistence.SqlResultSetMapping;
import jakarta.persistence.SqlResultSetMappings;
import jakarta.persistence.TableGenerator;
import jakarta.persistence.TableGenerators;
import jakarta.persistence.Version;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.MappingException;
import org.hibernate.TimeZoneStorageStrategy;
import org.hibernate.annotations.Any;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CollectionTypeRegistration;
import org.hibernate.annotations.CollectionTypeRegistrations;
import org.hibernate.annotations.Columns;
import org.hibernate.annotations.CompositeType;
import org.hibernate.annotations.CompositeTypeRegistration;
import org.hibernate.annotations.CompositeTypeRegistrations;
import org.hibernate.annotations.ConverterRegistration;
import org.hibernate.annotations.ConverterRegistrations;
import org.hibernate.annotations.EmbeddableInstantiator;
import org.hibernate.annotations.EmbeddableInstantiatorRegistration;
import org.hibernate.annotations.EmbeddableInstantiatorRegistrations;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.FetchProfile;
import org.hibernate.annotations.FetchProfiles;
import org.hibernate.annotations.FilterDef;
import org.hibernate.annotations.FilterDefs;
import org.hibernate.annotations.Formula;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.GenericGenerators;
import org.hibernate.annotations.IdGeneratorType;
import org.hibernate.annotations.Imported;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Instantiator;
import org.hibernate.annotations.JavaTypeRegistration;
import org.hibernate.annotations.JavaTypeRegistrations;
import org.hibernate.annotations.JdbcTypeRegistration;
import org.hibernate.annotations.JdbcTypeRegistrations;
import org.hibernate.annotations.LazyGroup;
import org.hibernate.annotations.ManyToAny;
import org.hibernate.annotations.NamedNativeQueries;
import org.hibernate.annotations.NamedNativeQuery;
import org.hibernate.annotations.NamedQueries;
import org.hibernate.annotations.NaturalId;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.annotations.OnDelete;
import org.hibernate.annotations.OnDeleteAction;
import org.hibernate.annotations.ParamDef;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Parent;
import org.hibernate.annotations.TimeZoneStorage;
import org.hibernate.annotations.TypeRegistration;
import org.hibernate.annotations.TypeRegistrations;
import org.hibernate.annotations.ValueGenerationType;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XAnnotatedElement;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XMethod;
import org.hibernate.annotations.common.reflection.XPackage;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.boot.model.IdGeneratorStrategyInterpreter;
import org.hibernate.boot.model.IdentifierGeneratorDefinition;
import org.hibernate.boot.model.convert.spi.RegisteredConversion;
import org.hibernate.boot.model.internal.AggregateComponentBinder;
import org.hibernate.boot.model.internal.AnnotatedColumn;
import org.hibernate.boot.model.internal.AnnotatedColumns;
import org.hibernate.boot.model.internal.AnnotatedJoinColumn;
import org.hibernate.boot.model.internal.AnnotatedJoinColumns;
import org.hibernate.boot.model.internal.BinderHelper;
import org.hibernate.boot.model.internal.CannotForceNonNullableException;
import org.hibernate.boot.model.internal.CollectionBinder;
import org.hibernate.boot.model.internal.ColumnsBuilder;
import org.hibernate.boot.model.internal.CopyIdentifierComponentSecondPass;
import org.hibernate.boot.model.internal.EntityBinder;
import org.hibernate.boot.model.internal.HCANNHelper;
import org.hibernate.boot.model.internal.IdGeneratorResolverSecondPass;
import org.hibernate.boot.model.internal.InheritanceState;
import org.hibernate.boot.model.internal.Nullability;
import org.hibernate.boot.model.internal.PropertyBinder;
import org.hibernate.boot.model.internal.PropertyContainer;
import org.hibernate.boot.model.internal.PropertyHolder;
import org.hibernate.boot.model.internal.PropertyHolderBuilder;
import org.hibernate.boot.model.internal.PropertyInferredData;
import org.hibernate.boot.model.internal.QueryBinder;
import org.hibernate.boot.model.internal.ToOneBinder;
import org.hibernate.boot.model.internal.VerifyFetchProfileReferenceSecondPass;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.spi.AccessType;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.PropertyData;
import org.hibernate.dialect.TimeZoneSupport;
import org.hibernate.engine.OptimisticLockStyle;
import org.hibernate.engine.spi.FilterDefinition;
import org.hibernate.generator.Generator;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.GenericsHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Constraint;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.MappedSuperclass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.model.convert.internal.JpaAttributeConverterImpl;
import org.hibernate.property.access.internal.PropertyAccessStrategyCompositeUserTypeImpl;
import org.hibernate.property.access.internal.PropertyAccessStrategyMixedImpl;
import org.hibernate.resource.beans.spi.ManagedBean;
import org.hibernate.resource.beans.spi.ManagedBeanRegistry;
import org.hibernate.type.BasicType;
import org.hibernate.type.CustomType;
import org.hibernate.type.descriptor.java.BasicJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.spi.JavaTypeRegistry;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.hibernate.type.internal.ConvertedBasicTypeImpl;
import org.hibernate.type.spi.TypeConfiguration;
import org.hibernate.usertype.CompositeUserType;
import org.hibernate.usertype.UserType;
import org.hibernate.usertype.internal.OffsetDateTimeCompositeUserType;
import org.hibernate.usertype.internal.ZonedDateTimeCompositeUserType;

public final class AnnotationBinder {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(AnnotationBinder.class);
    private static final String OFFSET_DATETIME_CLASS = OffsetDateTime.class.getName();
    private static final String ZONED_DATETIME_CLASS = ZonedDateTime.class.getName();

    private AnnotationBinder() {
    }

    public static void bindDefaults(MetadataBuildingContext context) {
        List storedProcedureQueries;
        List mappings;
        List nativeQueries;
        List queries;
        IdentifierGeneratorDefinition idGen;
        Map defaults = context.getBootstrapContext().getReflectionManager().getDefaults();
        List generators = (List)defaults.get(SequenceGenerator.class);
        if (generators != null) {
            for (SequenceGenerator sequenceGenerator : generators) {
                idGen = AnnotationBinder.buildIdGenerator((Annotation)sequenceGenerator, context);
                if (idGen == null) continue;
                context.getMetadataCollector().addDefaultIdentifierGenerator(idGen);
            }
        }
        if ((generators = (List)defaults.get(TableGenerator.class)) != null) {
            for (TableGenerator tableGenerator : generators) {
                idGen = AnnotationBinder.buildIdGenerator((Annotation)tableGenerator, context);
                if (idGen == null) continue;
                context.getMetadataCollector().addDefaultIdentifierGenerator(idGen);
            }
        }
        if ((generators = (List)defaults.get(TableGenerators.class)) != null) {
            generators.forEach(tableGenerators -> {
                for (TableGenerator tableGenerator : tableGenerators.value()) {
                    IdentifierGeneratorDefinition idGen = AnnotationBinder.buildIdGenerator((Annotation)tableGenerator, context);
                    if (idGen == null) continue;
                    context.getMetadataCollector().addDefaultIdentifierGenerator(idGen);
                }
            });
        }
        if ((generators = (List)defaults.get(SequenceGenerators.class)) != null) {
            generators.forEach(sequenceGenerators -> {
                for (SequenceGenerator sequenceGenerator : sequenceGenerators.value()) {
                    IdentifierGeneratorDefinition idGen = AnnotationBinder.buildIdGenerator((Annotation)sequenceGenerator, context);
                    if (idGen == null) continue;
                    context.getMetadataCollector().addDefaultIdentifierGenerator(idGen);
                }
            });
        }
        if ((queries = (List)defaults.get(NamedQuery.class)) != null) {
            for (NamedQuery ann : queries) {
                QueryBinder.bindQuery(ann, context, true);
            }
        }
        if ((nativeQueries = (List)defaults.get(jakarta.persistence.NamedNativeQuery.class)) != null) {
            for (NamedQuery ann : nativeQueries) {
                QueryBinder.bindNativeQuery((jakarta.persistence.NamedNativeQuery)ann, context, true);
            }
        }
        if ((mappings = (List)defaults.get(SqlResultSetMapping.class)) != null) {
            for (NamedQuery ann : mappings) {
                QueryBinder.bindSqlResultSetMapping((SqlResultSetMapping)ann, context, true);
            }
        }
        if ((storedProcedureQueries = (List)defaults.get(NamedStoredProcedureQuery.class)) != null) {
            for (NamedStoredProcedureQuery annotation : storedProcedureQueries) {
                AnnotationBinder.bindNamedStoredProcedureQuery(annotation, context, true);
            }
        }
        if ((storedProcedureQueries = (List)defaults.get(NamedStoredProcedureQueries.class)) != null) {
            for (NamedStoredProcedureQuery annotation : storedProcedureQueries) {
                AnnotationBinder.bindNamedStoredProcedureQueries((NamedStoredProcedureQueries)annotation, context, true);
            }
        }
    }

    public static void bindPackage(ClassLoaderService cls, String packageName, MetadataBuildingContext context) {
        Package pack = cls.packageForNameOrNull(packageName);
        if (pack == null) {
            return;
        }
        XPackage annotatedPackage = context.getBootstrapContext().getReflectionManager().toXPackage(pack);
        AnnotationBinder.handleIdGenerators(annotatedPackage, context);
        AnnotationBinder.handleTypeDescriptorRegistrations((XAnnotatedElement)annotatedPackage, context);
        AnnotationBinder.bindEmbeddableInstantiatorRegistrations((XAnnotatedElement)annotatedPackage, context);
        AnnotationBinder.bindUserTypeRegistrations((XAnnotatedElement)annotatedPackage, context);
        AnnotationBinder.bindCompositeUserTypeRegistrations((XAnnotatedElement)annotatedPackage, context);
        AnnotationBinder.handleConverterRegistrations((XAnnotatedElement)annotatedPackage, context);
        AnnotationBinder.bindGenericGenerators((XAnnotatedElement)annotatedPackage, context);
        AnnotationBinder.bindQueries((XAnnotatedElement)annotatedPackage, context);
        AnnotationBinder.bindFilterDefs((XAnnotatedElement)annotatedPackage, context);
    }

    private static void handleIdGenerators(XPackage annotatedPackage, MetadataBuildingContext context) {
        Object idGen;
        if (annotatedPackage.isAnnotationPresent(SequenceGenerator.class)) {
            SequenceGenerator sequenceGenerator = (SequenceGenerator)annotatedPackage.getAnnotation(SequenceGenerator.class);
            idGen = AnnotationBinder.buildIdGenerator((Annotation)sequenceGenerator, context);
            context.getMetadataCollector().addIdentifierGenerator((IdentifierGeneratorDefinition)idGen);
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Add sequence generator with name: {0}", ((IdentifierGeneratorDefinition)idGen).getName());
            }
        }
        if (annotatedPackage.isAnnotationPresent(SequenceGenerators.class)) {
            SequenceGenerators sequenceGenerators = (SequenceGenerators)annotatedPackage.getAnnotation(SequenceGenerators.class);
            for (SequenceGenerator sequenceGenerator : sequenceGenerators.value()) {
                context.getMetadataCollector().addIdentifierGenerator(AnnotationBinder.buildIdGenerator((Annotation)sequenceGenerator, context));
            }
        }
        if (annotatedPackage.isAnnotationPresent(TableGenerator.class)) {
            TableGenerator tableGenerator = (TableGenerator)annotatedPackage.getAnnotation(TableGenerator.class);
            idGen = AnnotationBinder.buildIdGenerator((Annotation)tableGenerator, context);
            context.getMetadataCollector().addIdentifierGenerator((IdentifierGeneratorDefinition)idGen);
        }
        if (annotatedPackage.isAnnotationPresent(TableGenerators.class)) {
            TableGenerators tableGenerators = (TableGenerators)annotatedPackage.getAnnotation(TableGenerators.class);
            for (TableGenerator tableGenerator : tableGenerators.value()) {
                context.getMetadataCollector().addIdentifierGenerator(AnnotationBinder.buildIdGenerator((Annotation)tableGenerator, context));
            }
        }
    }

    private static void bindGenericGenerators(XAnnotatedElement annotatedElement, MetadataBuildingContext context) {
        GenericGenerator genericGenerator = (GenericGenerator)annotatedElement.getAnnotation(GenericGenerator.class);
        GenericGenerators genericGenerators = (GenericGenerators)annotatedElement.getAnnotation(GenericGenerators.class);
        if (genericGenerator != null) {
            AnnotationBinder.bindGenericGenerator(genericGenerator, context);
        }
        if (genericGenerators != null) {
            for (GenericGenerator generator : genericGenerators.value()) {
                AnnotationBinder.bindGenericGenerator(generator, context);
            }
        }
    }

    private static void bindGenericGenerator(GenericGenerator def, MetadataBuildingContext context) {
        context.getMetadataCollector().addIdentifierGenerator(AnnotationBinder.buildIdGenerator(def, context));
    }

    private static void bindNamedJpaQueries(XAnnotatedElement annotatedElement, MetadataBuildingContext context) {
        QueryBinder.bindSqlResultSetMapping((SqlResultSetMapping)annotatedElement.getAnnotation(SqlResultSetMapping.class), context, false);
        SqlResultSetMappings ann = (SqlResultSetMappings)annotatedElement.getAnnotation(SqlResultSetMappings.class);
        if (ann != null) {
            for (SqlResultSetMapping current : ann.value()) {
                QueryBinder.bindSqlResultSetMapping(current, context, false);
            }
        }
        QueryBinder.bindQuery((NamedQuery)annotatedElement.getAnnotation(NamedQuery.class), context, false);
        QueryBinder.bindQueries((jakarta.persistence.NamedQueries)annotatedElement.getAnnotation(jakarta.persistence.NamedQueries.class), context, false);
        QueryBinder.bindNativeQuery((jakarta.persistence.NamedNativeQuery)annotatedElement.getAnnotation(jakarta.persistence.NamedNativeQuery.class), context, false);
        QueryBinder.bindNativeQueries((jakarta.persistence.NamedNativeQueries)annotatedElement.getAnnotation(jakarta.persistence.NamedNativeQueries.class), context, false);
    }

    public static void bindQueries(XAnnotatedElement annotatedElement, MetadataBuildingContext context) {
        AnnotationBinder.bindNamedJpaQueries(annotatedElement, context);
        QueryBinder.bindQuery((org.hibernate.annotations.NamedQuery)annotatedElement.getAnnotation(org.hibernate.annotations.NamedQuery.class), context);
        QueryBinder.bindQueries((NamedQueries)annotatedElement.getAnnotation(NamedQueries.class), context);
        QueryBinder.bindNativeQuery((NamedNativeQuery)annotatedElement.getAnnotation(NamedNativeQuery.class), context);
        QueryBinder.bindNativeQueries((NamedNativeQueries)annotatedElement.getAnnotation(NamedNativeQueries.class), context);
        AnnotationBinder.bindNamedStoredProcedureQuery((NamedStoredProcedureQuery)annotatedElement.getAnnotation(NamedStoredProcedureQuery.class), context, false);
        AnnotationBinder.bindNamedStoredProcedureQueries((NamedStoredProcedureQueries)annotatedElement.getAnnotation(NamedStoredProcedureQueries.class), context, false);
    }

    private static void bindNamedStoredProcedureQueries(NamedStoredProcedureQueries annotation, MetadataBuildingContext context, boolean isDefault) {
        if (annotation != null) {
            for (NamedStoredProcedureQuery queryAnnotation : annotation.value()) {
                AnnotationBinder.bindNamedStoredProcedureQuery(queryAnnotation, context, isDefault);
            }
        }
    }

    private static void bindNamedStoredProcedureQuery(NamedStoredProcedureQuery annotation, MetadataBuildingContext context, boolean isDefault) {
        if (annotation != null) {
            QueryBinder.bindNamedStoredProcedureQuery(annotation, context, isDefault);
        }
    }

    private static IdentifierGeneratorDefinition buildIdGenerator(Annotation generatorAnnotation, MetadataBuildingContext context) {
        if (generatorAnnotation == null) {
            return null;
        }
        IdentifierGeneratorDefinition.Builder definitionBuilder = new IdentifierGeneratorDefinition.Builder();
        if (generatorAnnotation instanceof TableGenerator) {
            context.getBuildingOptions().getIdGenerationTypeInterpreter().interpretTableGenerator((TableGenerator)generatorAnnotation, definitionBuilder);
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Add table generator with name: {0}", definitionBuilder.getName());
            }
        } else if (generatorAnnotation instanceof SequenceGenerator) {
            context.getBuildingOptions().getIdGenerationTypeInterpreter().interpretSequenceGenerator((SequenceGenerator)generatorAnnotation, definitionBuilder);
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Add sequence generator with name: {0}", definitionBuilder.getName());
            }
        } else if (generatorAnnotation instanceof GenericGenerator) {
            GenericGenerator genericGenerator = (GenericGenerator)generatorAnnotation;
            definitionBuilder.setName(genericGenerator.name());
            String strategy = genericGenerator.type().equals(Generator.class) ? genericGenerator.strategy() : genericGenerator.type().getName();
            definitionBuilder.setStrategy(strategy);
            for (Parameter parameter : genericGenerator.parameters()) {
                definitionBuilder.addParam(parameter.name(), parameter.value());
            }
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Add generic generator with name: {0}", definitionBuilder.getName());
            }
        } else {
            throw new AssertionFailure("Unknown Generator annotation: " + generatorAnnotation);
        }
        return definitionBuilder.build();
    }

    public static void bindClass(XClass annotatedClass, Map<XClass, InheritanceState> inheritanceStatePerClass, MetadataBuildingContext context) throws MappingException {
        AnnotationBinder.detectMappedSuperclassProblems(annotatedClass);
        switch (context.getMetadataCollector().getClassType(annotatedClass)) {
            case MAPPED_SUPERCLASS: {
                AnnotationBinder.bindQueries((XAnnotatedElement)annotatedClass, context);
                AnnotationBinder.bindFilterDefs((XAnnotatedElement)annotatedClass, context);
            }
            case IMPORTED: {
                AnnotationBinder.handleImport(annotatedClass, context);
            }
            case EMBEDDABLE: 
            case NONE: {
                return;
            }
        }
        Map<String, IdentifierGeneratorDefinition> generators = AnnotationBinder.buildGenerators((XAnnotatedElement)annotatedClass, context);
        AnnotationBinder.handleTypeDescriptorRegistrations((XAnnotatedElement)annotatedClass, context);
        AnnotationBinder.bindEmbeddableInstantiatorRegistrations((XAnnotatedElement)annotatedClass, context);
        AnnotationBinder.bindUserTypeRegistrations((XAnnotatedElement)annotatedClass, context);
        AnnotationBinder.bindCompositeUserTypeRegistrations((XAnnotatedElement)annotatedClass, context);
        AnnotationBinder.handleConverterRegistrations((XAnnotatedElement)annotatedClass, context);
        AnnotationBinder.bindQueries((XAnnotatedElement)annotatedClass, context);
        AnnotationBinder.bindFilterDefs((XAnnotatedElement)annotatedClass, context);
        EntityBinder.bindEntityClass(annotatedClass, inheritanceStatePerClass, generators, context);
    }

    private static void handleImport(XClass annotatedClass, MetadataBuildingContext context) {
        if (annotatedClass.isAnnotationPresent(Imported.class)) {
            String qualifiedName = annotatedClass.getName();
            String name = StringHelper.unqualify(qualifiedName);
            String rename = ((Imported)annotatedClass.getAnnotation(Imported.class)).rename();
            context.getMetadataCollector().addImport(rename.isEmpty() ? name : rename, qualifiedName);
        }
    }

    private static void detectMappedSuperclassProblems(XClass annotatedClass) {
        if (annotatedClass.isAnnotationPresent(Entity.class) && annotatedClass.isAnnotationPresent(jakarta.persistence.MappedSuperclass.class)) {
            throw new AnnotationException("Type '" + annotatedClass.getName() + "' is annotated both '@Entity' and '@MappedSuperclass'");
        }
        if (annotatedClass.isAnnotationPresent(Inheritance.class) && annotatedClass.isAnnotationPresent(jakarta.persistence.MappedSuperclass.class)) {
            LOG.unsupportedMappedSuperclassWithEntityInheritance(annotatedClass.getName());
        }
    }

    private static void handleTypeDescriptorRegistrations(XAnnotatedElement annotatedElement, MetadataBuildingContext context) {
        CollectionTypeRegistrations collectionTypeRegistrations;
        ManagedBeanRegistry managedBeanRegistry = context.getBootstrapContext().getServiceRegistry().getService(ManagedBeanRegistry.class);
        JavaTypeRegistration javaTypeRegistration = (JavaTypeRegistration)annotatedElement.getAnnotation(JavaTypeRegistration.class);
        if (javaTypeRegistration != null) {
            AnnotationBinder.handleJavaTypeRegistration(context, managedBeanRegistry, javaTypeRegistration);
        } else {
            JavaTypeRegistrations javaTypeRegistrations = (JavaTypeRegistrations)annotatedElement.getAnnotation(JavaTypeRegistrations.class);
            if (javaTypeRegistrations != null) {
                JavaTypeRegistration[] registrations;
                for (JavaTypeRegistration registration : registrations = javaTypeRegistrations.value()) {
                    AnnotationBinder.handleJavaTypeRegistration(context, managedBeanRegistry, registration);
                }
            }
        }
        JdbcTypeRegistration jdbcTypeRegistration = (JdbcTypeRegistration)annotatedElement.getAnnotation(JdbcTypeRegistration.class);
        if (jdbcTypeRegistration != null) {
            AnnotationBinder.handleJdbcTypeRegistration(context, managedBeanRegistry, jdbcTypeRegistration);
        } else {
            JdbcTypeRegistrations jdbcTypeRegistrations = (JdbcTypeRegistrations)annotatedElement.getAnnotation(JdbcTypeRegistrations.class);
            if (jdbcTypeRegistrations != null) {
                JdbcTypeRegistration[] registrations;
                for (JdbcTypeRegistration jdbcTypeRegistration2 : registrations = jdbcTypeRegistrations.value()) {
                    AnnotationBinder.handleJdbcTypeRegistration(context, managedBeanRegistry, jdbcTypeRegistration2);
                }
            }
        }
        CollectionTypeRegistration collectionTypeRegistration = (CollectionTypeRegistration)annotatedElement.getAnnotation(CollectionTypeRegistration.class);
        if (collectionTypeRegistration != null) {
            context.getMetadataCollector().addCollectionTypeRegistration(collectionTypeRegistration);
        }
        if ((collectionTypeRegistrations = (CollectionTypeRegistrations)annotatedElement.getAnnotation(CollectionTypeRegistrations.class)) != null) {
            for (CollectionTypeRegistration collectionTypeRegistration2 : collectionTypeRegistrations.value()) {
                context.getMetadataCollector().addCollectionTypeRegistration(collectionTypeRegistration2);
            }
        }
    }

    private static void handleJdbcTypeRegistration(MetadataBuildingContext context, ManagedBeanRegistry managedBeanRegistry, JdbcTypeRegistration annotation) {
        Class<? extends JdbcType> jdbcTypeClass = annotation.value();
        JdbcType jdbcType = managedBeanRegistry.getBean(jdbcTypeClass).getBeanInstance();
        int typeCode = annotation.registrationCode() == Integer.MIN_VALUE ? jdbcType.getDefaultSqlTypeCode() : annotation.registrationCode();
        context.getMetadataCollector().addJdbcTypeRegistration(typeCode, jdbcType);
    }

    private static void handleJavaTypeRegistration(MetadataBuildingContext context, ManagedBeanRegistry managedBeanRegistry, JavaTypeRegistration annotation) {
        Class<? extends BasicJavaType<?>> jtdClass = annotation.descriptorClass();
        BasicJavaType<?> jtd = managedBeanRegistry.getBean(jtdClass).getBeanInstance();
        context.getMetadataCollector().addJavaTypeRegistration(annotation.javaType(), jtd);
    }

    private static void bindEmbeddableInstantiatorRegistrations(XAnnotatedElement annotatedElement, MetadataBuildingContext context) {
        EmbeddableInstantiatorRegistration embeddableInstantiatorRegistration = (EmbeddableInstantiatorRegistration)annotatedElement.getAnnotation(EmbeddableInstantiatorRegistration.class);
        if (embeddableInstantiatorRegistration != null) {
            AnnotationBinder.handleEmbeddableInstantiatorRegistration(context, embeddableInstantiatorRegistration);
        } else {
            EmbeddableInstantiatorRegistrations embeddableInstantiatorRegistrations = (EmbeddableInstantiatorRegistrations)annotatedElement.getAnnotation(EmbeddableInstantiatorRegistrations.class);
            if (embeddableInstantiatorRegistrations != null) {
                EmbeddableInstantiatorRegistration[] registrations;
                for (EmbeddableInstantiatorRegistration registration : registrations = embeddableInstantiatorRegistrations.value()) {
                    AnnotationBinder.handleEmbeddableInstantiatorRegistration(context, registration);
                }
            }
        }
    }

    private static void handleEmbeddableInstantiatorRegistration(MetadataBuildingContext context, EmbeddableInstantiatorRegistration annotation) {
        context.getMetadataCollector().registerEmbeddableInstantiator(annotation.embeddableClass(), annotation.instantiator());
    }

    private static void bindCompositeUserTypeRegistrations(XAnnotatedElement annotatedElement, MetadataBuildingContext context) {
        CompositeTypeRegistration compositeTypeRegistration = (CompositeTypeRegistration)annotatedElement.getAnnotation(CompositeTypeRegistration.class);
        if (compositeTypeRegistration != null) {
            AnnotationBinder.handleCompositeUserTypeRegistration(context, compositeTypeRegistration);
        } else {
            CompositeTypeRegistrations compositeTypeRegistrations = (CompositeTypeRegistrations)annotatedElement.getAnnotation(CompositeTypeRegistrations.class);
            if (compositeTypeRegistrations != null) {
                CompositeTypeRegistration[] registrations;
                for (CompositeTypeRegistration registration : registrations = compositeTypeRegistrations.value()) {
                    AnnotationBinder.handleCompositeUserTypeRegistration(context, registration);
                }
            }
        }
    }

    private static void bindUserTypeRegistrations(XAnnotatedElement annotatedElement, MetadataBuildingContext context) {
        TypeRegistration typeRegistration = (TypeRegistration)annotatedElement.getAnnotation(TypeRegistration.class);
        if (typeRegistration != null) {
            AnnotationBinder.handleUserTypeRegistration(context, typeRegistration);
        } else {
            TypeRegistrations typeRegistrations = (TypeRegistrations)annotatedElement.getAnnotation(TypeRegistrations.class);
            if (typeRegistrations != null) {
                TypeRegistration[] registrations;
                for (TypeRegistration registration : registrations = typeRegistrations.value()) {
                    AnnotationBinder.handleUserTypeRegistration(context, registration);
                }
            }
        }
    }

    private static void handleUserTypeRegistration(MetadataBuildingContext context, TypeRegistration compositeTypeRegistration) {
        context.getMetadataCollector().registerUserType(compositeTypeRegistration.basicClass(), compositeTypeRegistration.userType());
    }

    private static void handleCompositeUserTypeRegistration(MetadataBuildingContext context, CompositeTypeRegistration compositeTypeRegistration) {
        context.getMetadataCollector().registerCompositeUserType(compositeTypeRegistration.embeddableClass(), compositeTypeRegistration.userType());
    }

    private static void handleConverterRegistrations(XAnnotatedElement container, MetadataBuildingContext context) {
        ConverterRegistration converterRegistration = (ConverterRegistration)container.getAnnotation(ConverterRegistration.class);
        if (converterRegistration != null) {
            AnnotationBinder.handleConverterRegistration(converterRegistration, context);
            return;
        }
        ConverterRegistrations converterRegistrations = (ConverterRegistrations)container.getAnnotation(ConverterRegistrations.class);
        if (converterRegistrations != null) {
            ConverterRegistration[] registrations;
            for (ConverterRegistration registration : registrations = converterRegistrations.value()) {
                AnnotationBinder.handleConverterRegistration(registration, context);
            }
        }
    }

    private static void handleConverterRegistration(ConverterRegistration registration, MetadataBuildingContext context) {
        InFlightMetadataCollector metadataCollector = context.getMetadataCollector();
        metadataCollector.getConverterRegistry().addRegisteredConversion(new RegisteredConversion(registration.domainType(), registration.converter(), registration.autoApply(), context));
    }

    public static void bindFilterDefs(XAnnotatedElement annotatedElement, MetadataBuildingContext context) {
        FilterDef filterDef = (FilterDef)annotatedElement.getAnnotation(FilterDef.class);
        FilterDefs filterDefs = BinderHelper.getOverridableAnnotation(annotatedElement, FilterDefs.class, context);
        if (filterDef != null) {
            AnnotationBinder.bindFilterDef(filterDef, context);
        }
        if (filterDefs != null) {
            for (FilterDef def : filterDefs.value()) {
                AnnotationBinder.bindFilterDef(def, context);
            }
        }
    }

    private static void bindFilterDef(FilterDef filterDef, MetadataBuildingContext context) {
        HashMap<String, JdbcMapping> explicitParamJaMappings = filterDef.parameters().length == 0 ? null : new HashMap<String, JdbcMapping>();
        for (ParamDef paramDef : filterDef.parameters()) {
            JdbcMapping jdbcMapping = AnnotationBinder.resolveFilterParamType(paramDef.type(), context);
            if (jdbcMapping == null) {
                throw new MappingException(String.format(Locale.ROOT, "Unable to resolve type specified for parameter (%s) defined for @FilterDef (%s)", paramDef.name(), filterDef.name()));
            }
            explicitParamJaMappings.put(paramDef.name(), jdbcMapping);
        }
        FilterDefinition filterDefinition = new FilterDefinition(filterDef.name(), filterDef.defaultCondition(), explicitParamJaMappings);
        LOG.debugf("Binding filter definition: %s", filterDefinition.getFilterName());
        context.getMetadataCollector().addFilterDefinition(filterDefinition);
    }

    private static JdbcMapping resolveFilterParamType(Class<?> type, MetadataBuildingContext context) {
        if (UserType.class.isAssignableFrom(type)) {
            return AnnotationBinder.resolveUserType(type, context);
        }
        if (AttributeConverter.class.isAssignableFrom(type)) {
            return AnnotationBinder.resolveAttributeConverter(type, context);
        }
        if (JavaType.class.isAssignableFrom(type)) {
            return AnnotationBinder.resolveJavaType(type, context);
        }
        return AnnotationBinder.resolveBasicType(type, context);
    }

    private static BasicType<Object> resolveBasicType(Class<?> type, final MetadataBuildingContext context) {
        final TypeConfiguration typeConfiguration = context.getBootstrapContext().getTypeConfiguration();
        JavaType jtd = typeConfiguration.getJavaTypeRegistry().findDescriptor(type);
        if (jtd != null) {
            JdbcType jdbcType = jtd.getRecommendedJdbcType(new JdbcTypeIndicators(){

                @Override
                public TypeConfiguration getTypeConfiguration() {
                    return typeConfiguration;
                }

                @Override
                public int getPreferredSqlTypeCodeForBoolean() {
                    return context.getPreferredSqlTypeCodeForBoolean();
                }

                @Override
                public int getPreferredSqlTypeCodeForDuration() {
                    return context.getPreferredSqlTypeCodeForDuration();
                }

                @Override
                public int getPreferredSqlTypeCodeForUuid() {
                    return context.getPreferredSqlTypeCodeForUuid();
                }

                @Override
                public int getPreferredSqlTypeCodeForInstant() {
                    return context.getPreferredSqlTypeCodeForInstant();
                }

                @Override
                public int getPreferredSqlTypeCodeForArray() {
                    return context.getPreferredSqlTypeCodeForArray();
                }
            });
            return typeConfiguration.getBasicTypeRegistry().resolve(jtd, jdbcType);
        }
        return null;
    }

    private static JdbcMapping resolveUserType(Class<UserType<?>> type, MetadataBuildingContext context) {
        StandardServiceRegistry serviceRegistry = context.getBootstrapContext().getServiceRegistry();
        ManagedBeanRegistry beanRegistry = serviceRegistry.getService(ManagedBeanRegistry.class);
        ManagedBean<UserType<?>> bean = beanRegistry.getBean(type);
        return new CustomType(bean.getBeanInstance(), context.getBootstrapContext().getTypeConfiguration());
    }

    private static JdbcMapping resolveAttributeConverter(Class<AttributeConverter<?, ?>> type, MetadataBuildingContext context) {
        StandardServiceRegistry serviceRegistry = context.getBootstrapContext().getServiceRegistry();
        ManagedBeanRegistry beanRegistry = serviceRegistry.getService(ManagedBeanRegistry.class);
        ManagedBean<AttributeConverter<?, ?>> bean = beanRegistry.getBean(type);
        TypeConfiguration typeConfiguration = context.getBootstrapContext().getTypeConfiguration();
        JavaTypeRegistry jtdRegistry = typeConfiguration.getJavaTypeRegistry();
        JavaType converterJtd = jtdRegistry.resolveDescriptor(bean.getBeanClass());
        ParameterizedType converterParameterizedType = GenericsHelper.extractParameterizedType(bean.getBeanClass());
        Class<?> domainJavaClass = GenericsHelper.extractClass(converterParameterizedType.getActualTypeArguments()[0]);
        Class<?> relationalJavaClass = GenericsHelper.extractClass(converterParameterizedType.getActualTypeArguments()[1]);
        JavaType domainJtd = jtdRegistry.resolveDescriptor(domainJavaClass);
        JavaType relationalJtd = jtdRegistry.resolveDescriptor(relationalJavaClass);
        JpaAttributeConverterImpl valueConverter = new JpaAttributeConverterImpl(bean, converterJtd, domainJtd, relationalJtd);
        return new ConvertedBasicTypeImpl("converted::" + valueConverter.getConverterJavaType().getJavaType().getTypeName(), String.format("BasicType adapter for AttributeConverter<%s,%s>", domainJtd.getJavaType().getTypeName(), relationalJtd.getJavaType().getTypeName()), relationalJtd.getRecommendedJdbcType(typeConfiguration.getCurrentBaseSqlTypeIndicators()), valueConverter);
    }

    private static JdbcMapping resolveJavaType(Class<JavaType<?>> type, MetadataBuildingContext context) {
        TypeConfiguration typeConfiguration = context.getBootstrapContext().getTypeConfiguration();
        JavaType<?> jtd = AnnotationBinder.getJavaType(type, context, typeConfiguration);
        JdbcType jdbcType = jtd.getRecommendedJdbcType(typeConfiguration.getCurrentBaseSqlTypeIndicators());
        return typeConfiguration.getBasicTypeRegistry().resolve(jtd, jdbcType);
    }

    private static JavaType<?> getJavaType(Class<JavaType<?>> type, MetadataBuildingContext context, TypeConfiguration typeConfiguration) {
        JavaType registeredJtd = typeConfiguration.getJavaTypeRegistry().findDescriptor(type);
        if (registeredJtd != null) {
            return registeredJtd;
        }
        StandardServiceRegistry serviceRegistry = context.getBootstrapContext().getServiceRegistry();
        ManagedBeanRegistry beanRegistry = serviceRegistry.getService(ManagedBeanRegistry.class);
        return beanRegistry.getBean(type).getBeanInstance();
    }

    public static void bindFetchProfilesForClass(XClass annotatedClass, MetadataBuildingContext context) {
        AnnotationBinder.bindFetchProfiles((XAnnotatedElement)annotatedClass, context);
    }

    public static void bindFetchProfilesForPackage(ClassLoaderService cls, String packageName, MetadataBuildingContext context) {
        Package pack = cls.packageForNameOrNull(packageName);
        if (pack != null) {
            ReflectionManager reflectionManager = context.getBootstrapContext().getReflectionManager();
            AnnotationBinder.bindFetchProfiles((XAnnotatedElement)reflectionManager.toXPackage(pack), context);
        }
    }

    private static void bindFetchProfiles(XAnnotatedElement annotatedElement, MetadataBuildingContext context) {
        FetchProfile fetchProfileAnnotation = (FetchProfile)annotatedElement.getAnnotation(FetchProfile.class);
        FetchProfiles fetchProfileAnnotations = (FetchProfiles)annotatedElement.getAnnotation(FetchProfiles.class);
        if (fetchProfileAnnotation != null) {
            AnnotationBinder.bindFetchProfile(fetchProfileAnnotation, context);
        }
        if (fetchProfileAnnotations != null) {
            for (FetchProfile profile : fetchProfileAnnotations.value()) {
                AnnotationBinder.bindFetchProfile(profile, context);
            }
        }
    }

    private static void bindFetchProfile(FetchProfile fetchProfileAnnotation, MetadataBuildingContext context) {
        for (FetchProfile.FetchOverride fetch : fetchProfileAnnotation.fetchOverrides()) {
            FetchMode mode = fetch.mode();
            if (!mode.equals((Object)FetchMode.JOIN)) {
                throw new MappingException("Only FetchMode.JOIN is currently supported");
            }
            context.getMetadataCollector().addSecondPass(new VerifyFetchProfileReferenceSecondPass(fetchProfileAnnotation.name(), fetch, context));
        }
    }

    static int addElementsOfClass(List<PropertyData> elements, PropertyContainer propertyContainer, MetadataBuildingContext context) {
        int idPropertyCounter = 0;
        for (XProperty property : propertyContainer.propertyIterator()) {
            idPropertyCounter += AnnotationBinder.addProperty(propertyContainer, property, elements, context);
        }
        return idPropertyCounter;
    }

    private static int addProperty(PropertyContainer propertyContainer, XProperty property, List<PropertyData> inFlightPropertyDataList, MetadataBuildingContext context) {
        for (PropertyData propertyData : inFlightPropertyDataList) {
            if (!propertyData.getPropertyName().equals(property.getName())) continue;
            AnnotationBinder.checkIdProperty(property, propertyData);
            return 0;
        }
        XClass declaringClass = propertyContainer.getDeclaringClass();
        XClass entity = propertyContainer.getEntityAtStake();
        int idPropertyCounter = 0;
        PropertyInferredData propertyAnnotatedElement = new PropertyInferredData(declaringClass, property, propertyContainer.getClassLevelAccessType().getType(), context.getBootstrapContext().getReflectionManager());
        XProperty element = propertyAnnotatedElement.getProperty();
        if (AnnotationBinder.hasIdAnnotation((XAnnotatedElement)element)) {
            inFlightPropertyDataList.add(0, propertyAnnotatedElement);
            AnnotationBinder.handleIdProperty(propertyContainer, context, declaringClass, entity, (XAnnotatedElement)element);
            if (BinderHelper.hasToOneAnnotation((XAnnotatedElement)element)) {
                context.getMetadataCollector().addToOneAndIdProperty(entity, propertyAnnotatedElement);
            }
            ++idPropertyCounter;
        } else {
            inFlightPropertyDataList.add(propertyAnnotatedElement);
        }
        if (element.isAnnotationPresent(MapsId.class)) {
            context.getMetadataCollector().addPropertyAnnotatedWithMapsId(entity, propertyAnnotatedElement);
        }
        return idPropertyCounter;
    }

    private static void checkIdProperty(XProperty property, PropertyData propertyData) {
        Id incomingIdProperty = (Id)property.getAnnotation(Id.class);
        Id existingIdProperty = (Id)propertyData.getProperty().getAnnotation(Id.class);
        if (incomingIdProperty != null && existingIdProperty == null) {
            throw new MappingException(String.format("You cannot override the [%s] non-identifier property from the [%s] base class or @MappedSuperclass and make it an identifier in the [%s] subclass", propertyData.getProperty().getName(), propertyData.getProperty().getDeclaringClass().getName(), property.getDeclaringClass().getName()));
        }
    }

    private static void handleIdProperty(PropertyContainer propertyContainer, MetadataBuildingContext context, XClass declaringClass, XClass entity, XAnnotatedElement element) {
        if (context.getBuildingOptions().isSpecjProprietarySyntaxEnabled() && element.isAnnotationPresent(Id.class) && element.isAnnotationPresent(Column.class)) {
            String columnName = ((Column)element.getAnnotation(Column.class)).name();
            for (XProperty property : declaringClass.getDeclaredProperties(AccessType.FIELD.getType())) {
                if (property.isAnnotationPresent(MapsId.class) || !AnnotationBinder.isJoinColumnPresent(columnName, property)) continue;
                context.getMetadataCollector().addPropertyAnnotatedWithMapsIdSpecj(entity, new PropertyInferredData(declaringClass, property, propertyContainer.getClassLevelAccessType().getType(), context.getBootstrapContext().getReflectionManager()), element.toString());
            }
        }
    }

    private static boolean isJoinColumnPresent(String columnName, XProperty property) {
        if (property.isAnnotationPresent(JoinColumn.class) && ((JoinColumn)property.getAnnotation(JoinColumn.class)).name().equals(columnName)) {
            return true;
        }
        if (property.isAnnotationPresent(JoinColumns.class)) {
            for (JoinColumn columnAnnotation : ((JoinColumns)property.getAnnotation(JoinColumns.class)).value()) {
                if (!columnName.equals(columnAnnotation.name())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean hasIdAnnotation(XAnnotatedElement element) {
        return element.isAnnotationPresent(Id.class) || element.isAnnotationPresent(EmbeddedId.class);
    }

    public static void processElementAnnotations(PropertyHolder propertyHolder, Nullability nullability, PropertyData inferredData, Map<String, IdentifierGeneratorDefinition> classGenerators, EntityBinder entityBinder, boolean isIdentifierMapper, boolean isComponentEmbedded, boolean inSecondPass, MetadataBuildingContext context, Map<XClass, InheritanceState> inheritanceStatePerClass) throws MappingException {
        if (AnnotationBinder.alreadyProcessedBySuper(propertyHolder, inferredData, entityBinder)) {
            LOG.debugf("Skipping attribute [%s : %s] as it was already processed as part of super hierarchy", inferredData.getClassOrElementName(), inferredData.getPropertyName());
        } else {
            XProperty property;
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Processing annotations of {0}.{1}", propertyHolder.getEntityName(), inferredData.getPropertyName());
            }
            if ((property = inferredData.getProperty()).isAnnotationPresent(Parent.class)) {
                AnnotationBinder.handleParentProperty(propertyHolder, inferredData, property);
            } else {
                AnnotationBinder.buildProperty(propertyHolder, nullability, inferredData, classGenerators, entityBinder, isIdentifierMapper, isComponentEmbedded, inSecondPass, context, inheritanceStatePerClass, property, inferredData.getClassOrElement());
            }
        }
    }

    private static boolean alreadyProcessedBySuper(PropertyHolder propertyHolder, PropertyData inferredData, EntityBinder entityBinder) {
        return !propertyHolder.isComponent() && entityBinder.isPropertyDefinedInSuperHierarchy(inferredData.getPropertyName());
    }

    private static void handleParentProperty(PropertyHolder propertyHolder, PropertyData inferredData, XProperty property) {
        if (!propertyHolder.isComponent()) {
            throw new AnnotationException("Property '" + BinderHelper.getPath(propertyHolder, inferredData) + "' is annotated '@Parent' but is not a member of an embeddable class");
        }
        propertyHolder.setParentProperty(property.getName());
    }

    private static void buildProperty(PropertyHolder propertyHolder, Nullability nullability, PropertyData inferredData, Map<String, IdentifierGeneratorDefinition> classGenerators, EntityBinder entityBinder, boolean isIdentifierMapper, boolean isComponentEmbedded, boolean inSecondPass, MetadataBuildingContext context, Map<XClass, InheritanceState> inheritanceStatePerClass, XProperty property, XClass returnedClass) {
        ColumnsBuilder columnsBuilder = new ColumnsBuilder(propertyHolder, nullability, property, inferredData, entityBinder, context).extractMetadata();
        PropertyBinder propertyBinder = new PropertyBinder();
        propertyBinder.setName(inferredData.getPropertyName());
        propertyBinder.setReturnedClassName(inferredData.getTypeName());
        propertyBinder.setAccessType(inferredData.getDefaultAccess());
        propertyBinder.setHolder(propertyHolder);
        propertyBinder.setProperty(property);
        propertyBinder.setReturnedClass(inferredData.getPropertyClass());
        propertyBinder.setBuildingContext(context);
        if (isIdentifierMapper) {
            propertyBinder.setInsertable(false);
            propertyBinder.setUpdatable(false);
        }
        propertyBinder.setDeclaringClass(inferredData.getDeclaringClass());
        propertyBinder.setEntityBinder(entityBinder);
        propertyBinder.setInheritanceStatePerClass(inheritanceStatePerClass);
        propertyBinder.setId(!entityBinder.isIgnoreIdAnnotations() && AnnotationBinder.hasIdAnnotation((XAnnotatedElement)property));
        LazyGroup lazyGroupAnnotation = (LazyGroup)property.getAnnotation(LazyGroup.class);
        if (lazyGroupAnnotation != null) {
            propertyBinder.setLazyGroup(lazyGroupAnnotation.value());
        }
        AnnotatedJoinColumns joinColumns = columnsBuilder.getJoinColumns();
        AnnotatedColumns columns = AnnotationBinder.bindProperty(propertyHolder, nullability, inferredData, classGenerators, entityBinder, isIdentifierMapper, isComponentEmbedded, inSecondPass, context, inheritanceStatePerClass, property, returnedClass, columnsBuilder, propertyBinder);
        AnnotationBinder.addIndexes(inSecondPass, property, columns, joinColumns);
        AnnotationBinder.addNaturalIds(inSecondPass, property, columns, joinColumns);
    }

    private static AnnotatedColumns bindProperty(PropertyHolder propertyHolder, Nullability nullability, PropertyData inferredData, Map<String, IdentifierGeneratorDefinition> classGenerators, EntityBinder entityBinder, boolean isIdentifierMapper, boolean isComponentEmbedded, boolean inSecondPass, MetadataBuildingContext context, Map<XClass, InheritanceState> inheritanceStatePerClass, XProperty property, XClass returnedClass, ColumnsBuilder columnsBuilder, PropertyBinder propertyBinder) {
        if (property.isAnnotationPresent(Version.class)) {
            AnnotationBinder.bindVersionProperty(propertyHolder, inferredData, isIdentifierMapper, context, inheritanceStatePerClass, property, columnsBuilder.getColumns(), propertyBinder);
        } else if (property.isAnnotationPresent(ManyToOne.class)) {
            ToOneBinder.bindManyToOne(propertyHolder, inferredData, isIdentifierMapper, inSecondPass, context, property, columnsBuilder.getJoinColumns(), propertyBinder, AnnotationBinder.isForcePersist(property));
        } else if (property.isAnnotationPresent(OneToOne.class)) {
            ToOneBinder.bindOneToOne(propertyHolder, inferredData, isIdentifierMapper, inSecondPass, context, property, columnsBuilder.getJoinColumns(), propertyBinder, AnnotationBinder.isForcePersist(property));
        } else if (property.isAnnotationPresent(Any.class)) {
            AnnotationBinder.bindAny(propertyHolder, nullability, inferredData, entityBinder, isIdentifierMapper, context, property, columnsBuilder.getJoinColumns(), AnnotationBinder.isForcePersist(property));
        } else if (property.isAnnotationPresent(OneToMany.class) || property.isAnnotationPresent(ManyToMany.class) || property.isAnnotationPresent(ElementCollection.class) || property.isAnnotationPresent(ManyToAny.class)) {
            CollectionBinder.bindCollection(propertyHolder, nullability, inferredData, classGenerators, entityBinder, isIdentifierMapper, context, inheritanceStatePerClass, property, columnsBuilder.getJoinColumns());
        } else if (!propertyBinder.isId() || !entityBinder.isIgnoreIdAnnotations()) {
            return AnnotationBinder.bindBasic(propertyHolder, nullability, inferredData, classGenerators, entityBinder, isIdentifierMapper, isComponentEmbedded, context, inheritanceStatePerClass, property, columnsBuilder, columnsBuilder.getColumns(), returnedClass, propertyBinder);
        }
        return columnsBuilder.getColumns();
    }

    private static boolean isForcePersist(XProperty property) {
        return property.isAnnotationPresent(MapsId.class) || property.isAnnotationPresent(Id.class);
    }

    private static void bindVersionProperty(PropertyHolder propertyHolder, PropertyData inferredData, boolean isIdentifierMapper, MetadataBuildingContext context, Map<XClass, InheritanceState> inheritanceStatePerClass, XProperty annotatedProperty, AnnotatedColumns columns, PropertyBinder propertyBinder) {
        AnnotationBinder.checkVersionProperty(propertyHolder, isIdentifierMapper);
        if (LOG.isTraceEnabled()) {
            LOG.tracev("{0} is a version property", inferredData.getPropertyName());
        }
        RootClass rootClass = (RootClass)propertyHolder.getPersistentClass();
        propertyBinder.setColumns(columns);
        Property property = propertyBinder.makePropertyValueAndBind();
        propertyBinder.getBasicValueBinder().setVersion(true);
        rootClass.setVersion(property);
        MappedSuperclass superclass = BinderHelper.getMappedSuperclassOrNull(inferredData.getDeclaringClass(), inheritanceStatePerClass, context);
        if (superclass != null) {
            superclass.setDeclaredVersion(property);
        } else {
            rootClass.setDeclaredVersion(property);
        }
        ((SimpleValue)property.getValue()).setNullValue("undefined");
        rootClass.setOptimisticLockStyle(OptimisticLockStyle.VERSION);
        if (LOG.isTraceEnabled()) {
            LOG.tracev("Version name: {0}, unsavedValue: {1}", rootClass.getVersion().getName(), ((SimpleValue)rootClass.getVersion().getValue()).getNullValue());
        }
    }

    private static void checkVersionProperty(PropertyHolder propertyHolder, boolean isIdentifierMapper) {
        if (isIdentifierMapper) {
            throw new AnnotationException("Class '" + propertyHolder.getEntityName() + "' is annotated '@IdClass' and may not have a property annotated '@Version'");
        }
        if (!(propertyHolder.getPersistentClass() instanceof RootClass)) {
            throw new AnnotationException("Entity '" + propertyHolder.getEntityName() + "' is a subclass in an entity class hierarchy and may not have a property annotated '@Version'");
        }
        if (!propertyHolder.isEntity()) {
            throw new AnnotationException("Embedded class '" + propertyHolder.getEntityName() + "' may not have a property annotated '@Version'");
        }
    }

    private static AnnotatedColumns bindBasic(PropertyHolder propertyHolder, Nullability nullability, PropertyData inferredData, Map<String, IdentifierGeneratorDefinition> classGenerators, EntityBinder entityBinder, boolean isIdentifierMapper, boolean isComponentEmbedded, MetadataBuildingContext context, Map<XClass, InheritanceState> inheritanceStatePerClass, XProperty property, ColumnsBuilder columnsBuilder, AnnotatedColumns columns, XClass returnedClass, PropertyBinder propertyBinder) {
        AnnotatedColumns actualColumns;
        boolean isComposite;
        boolean isOverridden;
        if (propertyBinder.isId() || propertyHolder.isOrWithinEmbeddedId() || propertyHolder.isInIdClass()) {
            PropertyData overridingProperty = BinderHelper.getPropertyOverriddenByMapperOrMapsId(propertyBinder.isId(), propertyHolder, property.getName(), context);
            if (overridingProperty != null) {
                isOverridden = true;
                InheritanceState state = inheritanceStatePerClass.get(overridingProperty.getClassOrElement());
                isComposite = state != null ? state.hasIdClassOrEmbeddedId() : AnnotationBinder.isEmbedded(property, returnedClass);
                actualColumns = columnsBuilder.overrideColumnFromMapperOrMapsIdProperty(propertyBinder.isId());
            } else {
                isOverridden = false;
                isComposite = AnnotationBinder.isEmbedded(property, returnedClass);
                actualColumns = columns;
            }
        } else {
            isOverridden = false;
            isComposite = AnnotationBinder.isEmbedded(property, returnedClass);
            actualColumns = columns;
        }
        Class<? extends CompositeUserType<?>> compositeUserType = AnnotationBinder.resolveCompositeUserType(inferredData, context);
        if (isComposite || compositeUserType != null) {
            propertyBinder = AnnotationBinder.createCompositeBinder(propertyHolder, inferredData, entityBinder, isIdentifierMapper, isComponentEmbedded, context, inheritanceStatePerClass, property, actualColumns, returnedClass, propertyBinder, isOverridden, compositeUserType);
        } else {
            if (property.isCollection() && property.getElementClass() != null && AnnotationBinder.isEmbedded(property, property.getElementClass())) {
                throw new AnnotationException("Property '" + BinderHelper.getPath(propertyHolder, inferredData) + "' is mapped as basic aggregate component array, but this is not yet supported.");
            }
            AnnotationBinder.createBasicBinder(propertyHolder, inferredData, nullability, context, property, actualColumns, propertyBinder, isOverridden);
        }
        if (isOverridden) {
            AnnotationBinder.handleGeneratorsForOverriddenId(propertyHolder, classGenerators, context, property, propertyBinder);
        } else if (propertyBinder.isId()) {
            AnnotationBinder.processId(propertyHolder, inferredData, (SimpleValue)propertyBinder.getValue(), classGenerators, isIdentifierMapper, context);
        }
        return actualColumns;
    }

    private static void handleGeneratorsForOverriddenId(PropertyHolder propertyHolder, Map<String, IdentifierGeneratorDefinition> classGenerators, MetadataBuildingContext context, XProperty property, PropertyBinder propertyBinder) {
        PropertyData mapsIdProperty = BinderHelper.getPropertyOverriddenByMapperOrMapsId(propertyBinder.isId(), propertyHolder, property.getName(), context);
        IdentifierGeneratorDefinition foreignGenerator = AnnotationBinder.createForeignGenerator(mapsIdProperty);
        if (AnnotationBinder.isGlobalGeneratorNameGlobal(context)) {
            context.getMetadataCollector().addSecondPass(new IdGeneratorResolverSecondPass((SimpleValue)propertyBinder.getValue(), property, foreignGenerator.getStrategy(), foreignGenerator.getName(), context, foreignGenerator));
        } else {
            HashMap<String, IdentifierGeneratorDefinition> generators = new HashMap<String, IdentifierGeneratorDefinition>(classGenerators);
            generators.put(foreignGenerator.getName(), foreignGenerator);
            BinderHelper.makeIdGenerator((SimpleValue)propertyBinder.getValue(), property, foreignGenerator.getStrategy(), foreignGenerator.getName(), context, generators);
        }
    }

    private static IdentifierGeneratorDefinition createForeignGenerator(PropertyData mapsIdProperty) {
        IdentifierGeneratorDefinition.Builder foreignGeneratorBuilder = new IdentifierGeneratorDefinition.Builder();
        foreignGeneratorBuilder.setName("Hibernate-local--foreign generator");
        foreignGeneratorBuilder.setStrategy("foreign");
        foreignGeneratorBuilder.addParam("property", mapsIdProperty.getPropertyName());
        return foreignGeneratorBuilder.build();
    }

    private static void createBasicBinder(PropertyHolder propertyHolder, PropertyData inferredData, Nullability nullability, MetadataBuildingContext context, XProperty property, AnnotatedColumns columns, PropertyBinder propertyBinder, boolean isOverridden) {
        boolean lazy;
        boolean optional;
        if (property.isAnnotationPresent(Basic.class)) {
            Basic basic = (Basic)property.getAnnotation(Basic.class);
            optional = basic.optional();
            lazy = basic.fetch() == FetchType.LAZY;
        } else {
            optional = true;
            lazy = false;
        }
        if (propertyBinder.isId() || !optional && nullability != Nullability.FORCED_NULL) {
            for (AnnotatedColumn column : columns.getColumns()) {
                if (propertyBinder.isId() && column.isFormula()) {
                    throw new CannotForceNonNullableException("Identifier property '" + BinderHelper.getPath(propertyHolder, inferredData) + "' cannot map to a '@Formula'");
                }
                column.forceNotNull();
            }
        }
        propertyBinder.setLazy(lazy);
        propertyBinder.setColumns(columns);
        if (isOverridden) {
            PropertyData mapsIdProperty = BinderHelper.getPropertyOverriddenByMapperOrMapsId(propertyBinder.isId(), propertyHolder, property.getName(), context);
            propertyBinder.setReferencedEntityName(mapsIdProperty.getClassOrElementName());
        }
        propertyBinder.makePropertyValueAndBind();
    }

    private static PropertyBinder createCompositeBinder(PropertyHolder propertyHolder, PropertyData inferredData, EntityBinder entityBinder, boolean isIdentifierMapper, boolean isComponentEmbedded, MetadataBuildingContext context, Map<XClass, InheritanceState> inheritanceStatePerClass, XProperty property, AnnotatedColumns columns, XClass returnedClass, PropertyBinder propertyBinder, boolean isOverridden, Class<? extends CompositeUserType<?>> compositeUserType) {
        AnnotatedJoinColumns actualColumns;
        String propertyName;
        String referencedEntityName;
        if (isOverridden) {
            PropertyData mapsIdProperty = BinderHelper.getPropertyOverriddenByMapperOrMapsId(propertyBinder.isId(), propertyHolder, property.getName(), context);
            referencedEntityName = mapsIdProperty.getClassOrElementName();
            propertyName = mapsIdProperty.getPropertyName();
            AnnotatedJoinColumns parent = new AnnotatedJoinColumns();
            parent.setBuildingContext(context);
            parent.setPropertyHolder(propertyHolder);
            parent.setPropertyName(BinderHelper.getRelativePath(propertyHolder, propertyName));
            for (AnnotatedColumn column : columns.getColumns()) {
                column.setParent(parent);
            }
            actualColumns = parent;
        } else {
            referencedEntityName = null;
            propertyName = null;
            actualColumns = null;
        }
        return AnnotationBinder.bindComponent(inferredData, propertyHolder, entityBinder.getPropertyAccessor((XAnnotatedElement)property), entityBinder, isIdentifierMapper, context, isComponentEmbedded, propertyBinder.isId(), inheritanceStatePerClass, referencedEntityName, propertyName, AnnotationBinder.determineCustomInstantiator(property, returnedClass, context), compositeUserType, actualColumns, columns);
    }

    private static boolean isEmbedded(XProperty property, XClass returnedClass) {
        return property.isAnnotationPresent(Embedded.class) || property.isAnnotationPresent(EmbeddedId.class) || returnedClass.isAnnotationPresent(Embeddable.class);
    }

    private static void bindAny(PropertyHolder propertyHolder, Nullability nullability, PropertyData inferredData, EntityBinder entityBinder, boolean isIdentifierMapper, MetadataBuildingContext context, XProperty property, AnnotatedJoinColumns joinColumns, boolean forcePersist) {
        if (property.isAnnotationPresent(Columns.class)) {
            throw new AnnotationException(String.format(Locale.ROOT, "Property '%s' is annotated '@Any' and may not have a '@Columns' annotation (a single '@Column' or '@Formula' must be used to map the discriminator, and '@JoinColumn's must be used to map the foreign key) ", BinderHelper.getPath(propertyHolder, inferredData)));
        }
        Cascade hibernateCascade = (Cascade)property.getAnnotation(Cascade.class);
        OnDelete onDeleteAnn = (OnDelete)property.getAnnotation(OnDelete.class);
        JoinTable assocTable = propertyHolder.getJoinTable(property);
        if (assocTable != null) {
            Join join = propertyHolder.addJoin(assocTable, false);
            for (AnnotatedJoinColumn joinColumn : joinColumns.getJoinColumns()) {
                joinColumn.setExplicitTableName(join.getTable().getName());
            }
        }
        AnnotationBinder.bindAny(BinderHelper.getCascadeStrategy(null, hibernateCascade, false, forcePersist), joinColumns, onDeleteAnn == null ? null : onDeleteAnn.action(), nullability, propertyHolder, inferredData, entityBinder, isIdentifierMapper, context);
    }

    private static void addIndexes(boolean inSecondPass, XProperty property, AnnotatedColumns columns, AnnotatedJoinColumns joinColumns) {
        block2: {
            Index index;
            block3: {
                index = (Index)property.getAnnotation(Index.class);
                if (index == null) break block2;
                if (joinColumns == null) break block3;
                for (AnnotatedColumn column : joinColumns.getColumns()) {
                    column.addIndex(index, inSecondPass);
                }
                break block2;
            }
            if (columns == null) break block2;
            for (AnnotatedColumn column : columns.getColumns()) {
                column.addIndex(index, inSecondPass);
            }
        }
    }

    private static void addNaturalIds(boolean inSecondPass, XProperty property, AnnotatedColumns columns, AnnotatedJoinColumns joinColumns) {
        block4: {
            NaturalId naturalId = (NaturalId)property.getAnnotation(NaturalId.class);
            if (naturalId == null) break block4;
            if (joinColumns != null) {
                String keyName = "UK_" + Constraint.hashedName(joinColumns.getTable().getName() + "_NaturalID");
                for (AnnotatedColumn column : joinColumns.getColumns()) {
                    column.addUniqueKey(keyName, inSecondPass);
                }
            } else {
                String keyName = "UK_" + Constraint.hashedName(columns.getTable().getName() + "_NaturalID");
                for (AnnotatedColumn column : columns.getColumns()) {
                    column.addUniqueKey(keyName, inSecondPass);
                }
            }
        }
    }

    private static Class<? extends org.hibernate.metamodel.spi.EmbeddableInstantiator> determineCustomInstantiator(XProperty property, XClass returnedClass, MetadataBuildingContext context) {
        if (property.isAnnotationPresent(EmbeddedId.class)) {
            return null;
        }
        EmbeddableInstantiator propertyAnnotation = (EmbeddableInstantiator)property.getAnnotation(EmbeddableInstantiator.class);
        if (propertyAnnotation != null) {
            return propertyAnnotation.value();
        }
        EmbeddableInstantiator classAnnotation = (EmbeddableInstantiator)returnedClass.getAnnotation(EmbeddableInstantiator.class);
        if (classAnnotation != null) {
            return classAnnotation.value();
        }
        Class embeddableClass = context.getBootstrapContext().getReflectionManager().toClass(returnedClass);
        if (embeddableClass != null) {
            return context.getMetadataCollector().findRegisteredEmbeddableInstantiator(embeddableClass);
        }
        return null;
    }

    private static Class<? extends CompositeUserType<?>> resolveCompositeUserType(PropertyData inferredData, MetadataBuildingContext context) {
        Class embeddableClass;
        XProperty property = inferredData.getProperty();
        XClass returnedClass = inferredData.getClassOrElement();
        if (property != null) {
            CompositeType compositeType = HCANNHelper.findAnnotation((XAnnotatedElement)property, CompositeType.class);
            if (compositeType != null) {
                return compositeType.value();
            }
            Class<? extends CompositeUserType<?>> compositeUserType = AnnotationBinder.resolveTimeZoneStorageCompositeUserType(property, returnedClass, context);
            if (compositeUserType != null) {
                return compositeUserType;
            }
        }
        if (returnedClass != null && (embeddableClass = context.getBootstrapContext().getReflectionManager().toClass(returnedClass)) != null) {
            return context.getMetadataCollector().findRegisteredCompositeUserType(embeddableClass);
        }
        return null;
    }

    private static boolean isGlobalGeneratorNameGlobal(MetadataBuildingContext context) {
        return context.getBootstrapContext().getJpaCompliance().isGlobalGeneratorScopeEnabled();
    }

    private static void processId(PropertyHolder propertyHolder, PropertyData inferredData, SimpleValue idValue, Map<String, IdentifierGeneratorDefinition> classGenerators, boolean isIdentifierMapper, MetadataBuildingContext context) {
        if (isIdentifierMapper) {
            throw new AnnotationException("Property '" + BinderHelper.getPath(propertyHolder, inferredData) + "' belongs to an '@IdClass' and may not be annotated '@Id' or '@EmbeddedId'");
        }
        XProperty idProperty = inferredData.getProperty();
        Object idGeneratorAnnotation = HCANNHelper.findContainingAnnotation((XAnnotatedElement)idProperty, IdGeneratorType.class);
        Object generatorAnnotation = HCANNHelper.findContainingAnnotation((XAnnotatedElement)idProperty, ValueGenerationType.class);
        if (idGeneratorAnnotation != null) {
            idValue.setCustomIdGeneratorCreator(PropertyBinder.identifierGeneratorCreator(idProperty, idGeneratorAnnotation));
        } else {
            if (generatorAnnotation != null) {
                throw new AnnotationException("Property '" + BinderHelper.getPath(propertyHolder, inferredData) + "' is annotated '" + generatorAnnotation.annotationType() + "' which is not an '@IdGeneratorType'");
            }
            XClass entityClass = inferredData.getClassOrElement();
            AnnotationBinder.createIdGenerator(idValue, classGenerators, context, entityClass, idProperty);
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Bind {0} on {1}", AnnotationBinder.isCompositeId(entityClass, idProperty) ? "@EmbeddedId" : "@Id", inferredData.getPropertyName());
            }
        }
    }

    private static void createIdGenerator(SimpleValue idValue, Map<String, IdentifierGeneratorDefinition> classGenerators, MetadataBuildingContext context, XClass entityClass, XProperty idProperty) {
        String generatorName;
        GeneratedValue generatedValue = (GeneratedValue)idProperty.getAnnotation(GeneratedValue.class);
        String generatorType = AnnotationBinder.generatorType(context, entityClass, AnnotationBinder.isCompositeId(entityClass, idProperty), generatedValue);
        String string = generatorName = generatedValue == null ? "" : generatedValue.generator();
        if (AnnotationBinder.isGlobalGeneratorNameGlobal(context)) {
            AnnotationBinder.buildGenerators((XAnnotatedElement)idProperty, context);
            context.getMetadataCollector().addSecondPass(new IdGeneratorResolverSecondPass(idValue, idProperty, generatorType, generatorName, context));
        } else {
            HashMap<String, IdentifierGeneratorDefinition> generators = new HashMap<String, IdentifierGeneratorDefinition>(classGenerators);
            generators.putAll(AnnotationBinder.buildGenerators((XAnnotatedElement)idProperty, context));
            BinderHelper.makeIdGenerator(idValue, idProperty, generatorType, generatorName, context, generators);
        }
    }

    private static boolean isCompositeId(XClass entityClass, XProperty idProperty) {
        return entityClass.isAnnotationPresent(Embeddable.class) || idProperty.isAnnotationPresent(EmbeddedId.class);
    }

    private static String generatorType(MetadataBuildingContext context, XClass entityXClass, boolean isComponent, GeneratedValue generatedValue) {
        if (isComponent) {
            return "assigned";
        }
        return generatedValue == null ? "assigned" : AnnotationBinder.generatorType(generatedValue, entityXClass, context);
    }

    public static String generatorType(final GeneratedValue generatedValue, final XClass javaClass, final MetadataBuildingContext context) {
        return context.getBuildingOptions().getIdGenerationTypeInterpreter().determineGeneratorName(generatedValue.strategy(), new IdGeneratorStrategyInterpreter.GeneratorNameDeterminationContext(){
            Class<?> javaType = null;

            @Override
            public Class<?> getIdType() {
                if (this.javaType == null) {
                    this.javaType = context.getBootstrapContext().getReflectionManager().toClass(javaClass);
                }
                return this.javaType;
            }

            @Override
            public String getGeneratedValueGeneratorName() {
                return generatedValue.generator();
            }
        });
    }

    private static PropertyBinder bindComponent(PropertyData inferredData, PropertyHolder propertyHolder, AccessType propertyAccessor, EntityBinder entityBinder, boolean isIdentifierMapper, MetadataBuildingContext context, boolean isComponentEmbedded, boolean isId, Map<XClass, InheritanceState> inheritanceStatePerClass, String referencedEntityName, String propertyName, Class<? extends org.hibernate.metamodel.spi.EmbeddableInstantiator> customInstantiatorImpl, Class<? extends CompositeUserType<?>> compositeUserTypeClass, AnnotatedJoinColumns columns, AnnotatedColumns annotatedColumns) {
        Component component;
        if (referencedEntityName != null) {
            component = AnnotationBinder.createComponent(propertyHolder, inferredData, isComponentEmbedded, isIdentifierMapper, customInstantiatorImpl, context);
            context.getMetadataCollector().addSecondPass(new CopyIdentifierComponentSecondPass(component, referencedEntityName, propertyName, columns, context));
        } else {
            component = AnnotationBinder.fillComponent(propertyHolder, inferredData, propertyAccessor, !isId, entityBinder, isComponentEmbedded, isIdentifierMapper, false, customInstantiatorImpl, compositeUserTypeClass, annotatedColumns, context, inheritanceStatePerClass);
        }
        if (isId) {
            component.setKey(true);
            AnnotationBinder.checkEmbeddedId(inferredData, propertyHolder, referencedEntityName, component);
        }
        PropertyBinder binder = new PropertyBinder();
        binder.setDeclaringClass(inferredData.getDeclaringClass());
        binder.setName(inferredData.getPropertyName());
        binder.setValue(component);
        binder.setProperty(inferredData.getProperty());
        binder.setAccessType(inferredData.getDefaultAccess());
        binder.setEmbedded(isComponentEmbedded);
        binder.setHolder(propertyHolder);
        binder.setId(isId);
        binder.setEntityBinder(entityBinder);
        binder.setInheritanceStatePerClass(inheritanceStatePerClass);
        binder.setBuildingContext(context);
        binder.makePropertyAndBind();
        return binder;
    }

    private static void checkEmbeddedId(PropertyData inferredData, PropertyHolder propertyHolder, String referencedEntityName, Component component) {
        if (propertyHolder.getPersistentClass().getIdentifier() != null) {
            throw new AnnotationException("Embeddable class '" + component.getComponentClassName() + "' may not have a property annotated '@Id' since it is used by '" + BinderHelper.getPath(propertyHolder, inferredData) + "' as an '@EmbeddedId'");
        }
        if (referencedEntityName == null && component.getPropertySpan() == 0) {
            throw new AnnotationException("Embeddable class '" + component.getComponentClassName() + "' may not be used as an '@EmbeddedId' by '" + BinderHelper.getPath(propertyHolder, inferredData) + "' because it has no properties");
        }
    }

    public static Component fillComponent(PropertyHolder propertyHolder, PropertyData inferredData, AccessType propertyAccessor, boolean isNullable, EntityBinder entityBinder, boolean isComponentEmbedded, boolean isIdentifierMapper, boolean inSecondPass, Class<? extends org.hibernate.metamodel.spi.EmbeddableInstantiator> customInstantiatorImpl, Class<? extends CompositeUserType<?>> compositeUserTypeClass, AnnotatedColumns columns, MetadataBuildingContext context, Map<XClass, InheritanceState> inheritanceStatePerClass) {
        return AnnotationBinder.fillComponent(propertyHolder, inferredData, null, propertyAccessor, isNullable, entityBinder, isComponentEmbedded, isIdentifierMapper, inSecondPass, customInstantiatorImpl, compositeUserTypeClass, columns, context, inheritanceStatePerClass);
    }

    public static Component fillComponent(PropertyHolder propertyHolder, PropertyData inferredData, PropertyData baseInferredData, AccessType propertyAccessor, boolean isNullable, EntityBinder entityBinder, boolean isComponentEmbedded, boolean isIdentifierMapper, boolean inSecondPass, Class<? extends org.hibernate.metamodel.spi.EmbeddableInstantiator> customInstantiatorImpl, Class<? extends CompositeUserType<?>> compositeUserTypeClass, AnnotatedColumns columns, MetadataBuildingContext context, Map<XClass, InheritanceState> inheritanceStatePerClass) {
        XClass returnedClassOrElement;
        CompositeUserType<?> compositeUserType;
        Component component = AnnotationBinder.createComponent(propertyHolder, inferredData, isComponentEmbedded, isIdentifierMapper, customInstantiatorImpl, context);
        String subpath = BinderHelper.getPath(propertyHolder, inferredData);
        LOG.tracev("Binding component with path: {0}", subpath);
        PropertyHolder subholder = PropertyHolderBuilder.buildPropertyHolder(component, subpath, inferredData, propertyHolder, context);
        propertyHolder.startingProperty(inferredData.getProperty());
        if (compositeUserTypeClass == null) {
            compositeUserType = null;
            returnedClassOrElement = inferredData.getClassOrElement();
        } else {
            compositeUserType = AnnotationBinder.compositeUserType(compositeUserTypeClass, context);
            component.setTypeName(compositeUserTypeClass.getName());
            returnedClassOrElement = context.getBootstrapContext().getReflectionManager().toXClass(compositeUserType.embeddable());
        }
        XClass annotatedClass = inferredData.getPropertyClass();
        List<PropertyData> classElements = AnnotationBinder.collectClassElements(propertyAccessor, context, returnedClassOrElement, annotatedClass);
        List<PropertyData> baseClassElements = AnnotationBinder.collectBaseClassElements(baseInferredData, propertyAccessor, context, annotatedClass);
        if (baseClassElements != null && !AnnotationBinder.hasAnnotationsOnIdClass(annotatedClass)) {
            AnnotationBinder.processIdClassElememts(propertyHolder, baseInferredData, classElements, baseClassElements);
        }
        for (PropertyData propertyAnnotatedElement : classElements) {
            AnnotationBinder.processElementAnnotations(subholder, isNullable ? Nullability.NO_CONSTRAINT : Nullability.FORCED_NOT_NULL, propertyAnnotatedElement, new HashMap<String, IdentifierGeneratorDefinition>(), entityBinder, isIdentifierMapper, isComponentEmbedded, inSecondPass, context, inheritanceStatePerClass);
            XProperty property = propertyAnnotatedElement.getProperty();
            if (!AnnotationBinder.isGeneratedId(property)) continue;
            AnnotationBinder.processGeneratedId(context, component, property);
        }
        if (compositeUserType != null) {
            AnnotationBinder.processCompositeUserType(component, compositeUserType);
        }
        AggregateComponentBinder.processAggregate(component, propertyHolder, inferredData, returnedClassOrElement, columns, context);
        return component;
    }

    private static CompositeUserType<?> compositeUserType(Class<? extends CompositeUserType<?>> compositeUserTypeClass, MetadataBuildingContext context) {
        return context.getBootstrapContext().getServiceRegistry().getService(ManagedBeanRegistry.class).getBean(compositeUserTypeClass).getBeanInstance();
    }

    private static List<PropertyData> collectClassElements(AccessType propertyAccessor, MetadataBuildingContext context, XClass returnedClassOrElement, XClass annotatedClass) {
        ArrayList<PropertyData> classElements = new ArrayList<PropertyData>();
        PropertyContainer container = new PropertyContainer(returnedClassOrElement, annotatedClass, propertyAccessor);
        AnnotationBinder.addElementsOfClass(classElements, container, context);
        for (XClass superClass = annotatedClass.getSuperclass(); superClass != null && superClass.isAnnotationPresent(jakarta.persistence.MappedSuperclass.class); superClass = superClass.getSuperclass()) {
            PropertyContainer superContainer = new PropertyContainer(superClass, annotatedClass, propertyAccessor);
            AnnotationBinder.addElementsOfClass(classElements, superContainer, context);
        }
        return classElements;
    }

    private static List<PropertyData> collectBaseClassElements(PropertyData baseInferredData, AccessType propertyAccessor, MetadataBuildingContext context, XClass annotatedClass) {
        if (baseInferredData != null) {
            ArrayList<PropertyData> baseClassElements = new ArrayList<PropertyData>();
            XClass baseReturnedClassOrElement = baseInferredData.getClassOrElement();
            while (!Object.class.getName().equals(baseReturnedClassOrElement.getName())) {
                PropertyContainer container = new PropertyContainer(baseReturnedClassOrElement, annotatedClass, propertyAccessor);
                AnnotationBinder.addElementsOfClass(baseClassElements, container, context);
                baseReturnedClassOrElement = baseReturnedClassOrElement.getSuperclass();
            }
            return baseClassElements;
        }
        return null;
    }

    private static boolean isGeneratedId(XProperty property) {
        return property.isAnnotationPresent(GeneratedValue.class) && property.isAnnotationPresent(Id.class);
    }

    private static void processCompositeUserType(Component component, CompositeUserType<?> compositeUserType) {
        component.sortProperties();
        ArrayList<String> sortedPropertyNames = new ArrayList<String>(component.getPropertySpan());
        ArrayList<Type> sortedPropertyTypes = new ArrayList<Type>(component.getPropertySpan());
        PropertyAccessStrategyCompositeUserTypeImpl strategy = new PropertyAccessStrategyCompositeUserTypeImpl(compositeUserType, sortedPropertyNames, sortedPropertyTypes);
        for (Property property : component.getProperties()) {
            sortedPropertyNames.add(property.getName());
            sortedPropertyTypes.add(PropertyAccessStrategyMixedImpl.INSTANCE.buildPropertyAccess(compositeUserType.embeddable(), property.getName(), false).getGetter().getReturnType());
            property.setPropertyAccessStrategy(strategy);
        }
    }

    private static void processGeneratedId(MetadataBuildingContext context, Component component, XProperty property) {
        String generator;
        GeneratedValue generatedValue = (GeneratedValue)property.getAnnotation(GeneratedValue.class);
        String generatorType = generatedValue != null ? AnnotationBinder.generatorType(generatedValue, property.getType(), context) : "assigned";
        String string = generator = generatedValue != null ? generatedValue.generator() : "";
        if (AnnotationBinder.isGlobalGeneratorNameGlobal(context)) {
            AnnotationBinder.buildGenerators((XAnnotatedElement)property, context);
            context.getMetadataCollector().addSecondPass(new IdGeneratorResolverSecondPass((SimpleValue)component.getProperty(property.getName()).getValue(), property, generatorType, generator, context));
        } else {
            BinderHelper.makeIdGenerator((SimpleValue)component.getProperty(property.getName()).getValue(), property, generatorType, generator, context, new HashMap<String, IdentifierGeneratorDefinition>(AnnotationBinder.buildGenerators((XAnnotatedElement)property, context)));
        }
    }

    private static void processIdClassElememts(PropertyHolder propertyHolder, PropertyData baseInferredData, List<PropertyData> classElements, List<PropertyData> baseClassElements) {
        HashMap<String, PropertyData> baseClassElementsByName = new HashMap<String, PropertyData>();
        for (PropertyData element : baseClassElements) {
            baseClassElementsByName.put(element.getPropertyName(), element);
        }
        for (int i = 0; i < classElements.size(); ++i) {
            PropertyData idClassPropertyData = classElements.get(i);
            PropertyData entityPropertyData = (PropertyData)baseClassElementsByName.get(idClassPropertyData.getPropertyName());
            if (propertyHolder.isInIdClass()) {
                if (entityPropertyData == null) {
                    throw new AnnotationException("Property '" + BinderHelper.getPath(propertyHolder, idClassPropertyData) + "' belongs to an '@IdClass' but has no matching property in entity class '" + baseInferredData.getPropertyClass().getName() + "' (every property of the '@IdClass' must have a corresponding persistent property in the '@Entity' class)");
                }
                if (BinderHelper.hasToOneAnnotation((XAnnotatedElement)entityPropertyData.getProperty()) && !entityPropertyData.getClassOrElement().equals(idClassPropertyData.getClassOrElement())) continue;
            }
            classElements.set(i, entityPropertyData);
        }
    }

    public static Component createComponent(PropertyHolder propertyHolder, PropertyData inferredData, boolean isComponentEmbedded, boolean isIdentifierMapper, Class<? extends org.hibernate.metamodel.spi.EmbeddableInstantiator> customInstantiatorImpl, MetadataBuildingContext context) {
        Component component = new Component(context, propertyHolder.getPersistentClass());
        component.setEmbedded(isComponentEmbedded);
        component.setTable(propertyHolder.getTable());
        if (isIdentifierMapper || isComponentEmbedded && inferredData.getPropertyName() == null) {
            component.setComponentClassName(component.getOwner().getClassName());
        } else {
            component.setComponentClassName(inferredData.getClassOrElementName());
        }
        component.setCustomInstantiator(customInstantiatorImpl);
        Constructor<?> constructor = AnnotationBinder.resolveInstantiator(inferredData.getClassOrElement(), context);
        if (constructor != null) {
            component.setInstantiator(constructor, constructor.getAnnotation(Instantiator.class).value());
        }
        return component;
    }

    public static PropertyData getUniqueIdPropertyFromBaseClass(PropertyData inferredData, PropertyData baseInferredData, AccessType propertyAccessor, MetadataBuildingContext context) {
        ArrayList<PropertyData> baseClassElements = new ArrayList<PropertyData>();
        PropertyContainer propContainer = new PropertyContainer(baseInferredData.getClassOrElement(), inferredData.getPropertyClass(), propertyAccessor);
        AnnotationBinder.addElementsOfClass(baseClassElements, propContainer, context);
        return (PropertyData)baseClassElements.get(0);
    }

    private static void bindAny(String cascadeStrategy, AnnotatedJoinColumns columns, OnDeleteAction onDeleteAction, Nullability nullability, PropertyHolder propertyHolder, PropertyData inferredData, EntityBinder entityBinder, boolean isIdentifierMapper, MetadataBuildingContext context) {
        XProperty property = inferredData.getProperty();
        Any any = (Any)property.getAnnotation(Any.class);
        if (any == null) {
            throw new AssertionFailure("Missing @Any annotation: " + BinderHelper.getPath(propertyHolder, inferredData));
        }
        boolean lazy = any.fetch() == FetchType.LAZY;
        org.hibernate.mapping.Any value = BinderHelper.buildAnyValue((Column)property.getAnnotation(Column.class), BinderHelper.getOverridableAnnotation((XAnnotatedElement)property, Formula.class, context), columns, inferredData, onDeleteAction, lazy, nullability, propertyHolder, entityBinder, any.optional(), context);
        PropertyBinder binder = new PropertyBinder();
        binder.setName(inferredData.getPropertyName());
        binder.setValue(value);
        binder.setLazy(lazy);
        if (isIdentifierMapper) {
            binder.setInsertable(false);
            binder.setUpdatable(false);
        }
        binder.setAccessType(inferredData.getDefaultAccess());
        binder.setCascade(cascadeStrategy);
        Property prop = binder.makeProperty();
        propertyHolder.addProperty(prop, columns, inferredData.getDeclaringClass());
    }

    public static Map<String, IdentifierGeneratorDefinition> buildGenerators(XAnnotatedElement annotatedElement, MetadataBuildingContext context) {
        GenericGenerator genericGenerator;
        SequenceGenerator sequenceGenerator;
        TableGenerator tableGenerator;
        SequenceGenerators sequenceGenerators;
        IdentifierGeneratorDefinition idGenerator;
        InFlightMetadataCollector metadataCollector = context.getMetadataCollector();
        HashMap<String, IdentifierGeneratorDefinition> generators = new HashMap<String, IdentifierGeneratorDefinition>();
        TableGenerators tableGenerators = (TableGenerators)annotatedElement.getAnnotation(TableGenerators.class);
        if (tableGenerators != null) {
            for (TableGenerator tableGenerator2 : tableGenerators.value()) {
                idGenerator = AnnotationBinder.buildIdGenerator((Annotation)tableGenerator2, context);
                generators.put(idGenerator.getName(), idGenerator);
                metadataCollector.addIdentifierGenerator(idGenerator);
            }
        }
        if ((sequenceGenerators = (SequenceGenerators)annotatedElement.getAnnotation(SequenceGenerators.class)) != null) {
            for (SequenceGenerator sequenceGenerator2 : sequenceGenerators.value()) {
                IdentifierGeneratorDefinition idGenerator2 = AnnotationBinder.buildIdGenerator((Annotation)sequenceGenerator2, context);
                generators.put(idGenerator2.getName(), idGenerator2);
                metadataCollector.addIdentifierGenerator(idGenerator2);
            }
        }
        if ((tableGenerator = (TableGenerator)annotatedElement.getAnnotation(TableGenerator.class)) != null) {
            IdentifierGeneratorDefinition idGenerator3 = AnnotationBinder.buildIdGenerator((Annotation)tableGenerator, context);
            generators.put(idGenerator3.getName(), idGenerator3);
            metadataCollector.addIdentifierGenerator(idGenerator3);
        }
        if ((sequenceGenerator = (SequenceGenerator)annotatedElement.getAnnotation(SequenceGenerator.class)) != null) {
            IdentifierGeneratorDefinition idGenerator4 = AnnotationBinder.buildIdGenerator((Annotation)sequenceGenerator, context);
            generators.put(idGenerator4.getName(), idGenerator4);
            metadataCollector.addIdentifierGenerator(idGenerator4);
        }
        if ((genericGenerator = (GenericGenerator)annotatedElement.getAnnotation(GenericGenerator.class)) != null) {
            idGenerator = AnnotationBinder.buildIdGenerator(genericGenerator, context);
            generators.put(idGenerator.getName(), idGenerator);
            metadataCollector.addIdentifierGenerator(idGenerator);
        }
        return generators;
    }

    public static boolean isDefault(XClass clazz, MetadataBuildingContext context) {
        return context.getBootstrapContext().getReflectionManager().equals(clazz, Void.TYPE);
    }

    public static Map<XClass, InheritanceState> buildInheritanceStates(List<XClass> orderedClasses, MetadataBuildingContext buildingContext) {
        HashMap<XClass, InheritanceState> inheritanceStatePerClass = new HashMap<XClass, InheritanceState>(orderedClasses.size());
        for (XClass clazz : orderedClasses) {
            InheritanceState superclassState = InheritanceState.getSuperclassInheritanceState(clazz, inheritanceStatePerClass);
            InheritanceState state = new InheritanceState(clazz, inheritanceStatePerClass, buildingContext);
            if (superclassState != null) {
                superclassState.setHasSiblings(true);
                InheritanceState superEntityState = InheritanceState.getInheritanceStateOfSuperEntity(clazz, inheritanceStatePerClass);
                state.setHasParents(superEntityState != null);
                AnnotationBinder.logMixedInheritance(clazz, superclassState, state);
                if (superclassState.getType() != null) {
                    state.setType(superclassState.getType());
                }
            }
            inheritanceStatePerClass.put(clazz, state);
        }
        return inheritanceStatePerClass;
    }

    private static void logMixedInheritance(XClass clazz, InheritanceState superclassState, InheritanceState state) {
        if (state.getType() != null && superclassState.getType() != null) {
            boolean mixingStrategy;
            boolean nonDefault = InheritanceType.SINGLE_TABLE != state.getType();
            boolean bl = mixingStrategy = state.getType() != superclassState.getType();
            if (nonDefault && mixingStrategy) {
                LOG.invalidSubStrategy(clazz.getName());
            }
        }
    }

    private static boolean hasAnnotationsOnIdClass(XClass idClass) {
        for (XProperty property : idClass.getDeclaredProperties("field")) {
            if (!AnnotationBinder.hasTriggeringAnnotation((XAnnotatedElement)property)) continue;
            return true;
        }
        for (XMethod method : idClass.getDeclaredMethods()) {
            if (!AnnotationBinder.hasTriggeringAnnotation((XAnnotatedElement)method)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasTriggeringAnnotation(XAnnotatedElement property) {
        return property.isAnnotationPresent(Column.class) || property.isAnnotationPresent(OneToMany.class) || property.isAnnotationPresent(ManyToOne.class) || property.isAnnotationPresent(Id.class) || property.isAnnotationPresent(GeneratedValue.class) || property.isAnnotationPresent(OneToOne.class) || property.isAnnotationPresent(ManyToMany.class);
    }

    static void matchIgnoreNotFoundWithFetchType(String entity, String association, NotFoundAction notFoundAction, FetchType fetchType) {
        if (notFoundAction != null && fetchType == FetchType.LAZY) {
            LOG.ignoreNotFoundWithFetchTypeLazy(entity, association);
        }
    }

    private static Class<? extends CompositeUserType<?>> resolveTimeZoneStorageCompositeUserType(XProperty property, XClass returnedClass, MetadataBuildingContext context) {
        if (AnnotationBinder.useColumnForTimeZoneStorage((XAnnotatedElement)property, context)) {
            String returnedClassName = returnedClass.getName();
            if (OFFSET_DATETIME_CLASS.equals(returnedClassName)) {
                return OffsetDateTimeCompositeUserType.class;
            }
            if (ZONED_DATETIME_CLASS.equals(returnedClassName)) {
                return ZonedDateTimeCompositeUserType.class;
            }
        }
        return null;
    }

    private static boolean isZonedDateTimeClass(String returnedClassName) {
        return OFFSET_DATETIME_CLASS.equals(returnedClassName) || ZONED_DATETIME_CLASS.equals(returnedClassName);
    }

    static boolean useColumnForTimeZoneStorage(XAnnotatedElement element, MetadataBuildingContext context) {
        TimeZoneStorage timeZoneStorage = (TimeZoneStorage)element.getAnnotation(TimeZoneStorage.class);
        if (timeZoneStorage == null) {
            if (element instanceof XProperty) {
                XProperty property = (XProperty)element;
                return AnnotationBinder.isZonedDateTimeClass(property.getType().getName()) && context.getBuildingOptions().getDefaultTimeZoneStorage() == TimeZoneStorageStrategy.COLUMN;
            }
            return false;
        }
        switch (timeZoneStorage.value()) {
            case COLUMN: {
                return true;
            }
            case AUTO: {
                return context.getBuildingOptions().getTimeZoneSupport() != TimeZoneSupport.NATIVE;
            }
        }
        return false;
    }

    public static Constructor<?> resolveInstantiator(XClass embeddableClass, MetadataBuildingContext buildingContext) {
        if (embeddableClass != null) {
            Constructor<?>[] declaredConstructors = buildingContext.getBootstrapContext().getReflectionManager().toClass(embeddableClass).getDeclaredConstructors();
            Constructor<?> constructor = null;
            for (Constructor<?> declaredConstructor : declaredConstructors) {
                if (!declaredConstructor.isAnnotationPresent(Instantiator.class)) continue;
                if (constructor != null) {
                    throw new MappingException("Multiple constructors annotated with @Instantiator but only one constructor can be the canonical constructor in class: " + embeddableClass.getName());
                }
                constructor = declaredConstructor;
            }
            return constructor;
        }
        return null;
    }
}

