/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.Column;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToOne;
import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.FetchMode;
import org.hibernate.MappingException;
import org.hibernate.annotations.AnyDiscriminatorValue;
import org.hibernate.annotations.AnyDiscriminatorValues;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.DialectOverride;
import org.hibernate.annotations.Formula;
import org.hibernate.annotations.OnDeleteAction;
import org.hibernate.annotations.SqlFragmentAlias;
import org.hibernate.annotations.common.reflection.XAnnotatedElement;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.boot.model.IdentifierGeneratorDefinition;
import org.hibernate.boot.model.internal.AnnotatedColumn;
import org.hibernate.boot.model.internal.AnnotatedColumns;
import org.hibernate.boot.model.internal.AnnotatedJoinColumn;
import org.hibernate.boot.model.internal.AnnotatedJoinColumns;
import org.hibernate.boot.model.internal.BasicValueBinder;
import org.hibernate.boot.model.internal.EntityBinder;
import org.hibernate.boot.model.internal.ForeignKeyType;
import org.hibernate.boot.model.internal.InheritanceState;
import org.hibernate.boot.model.internal.Nullability;
import org.hibernate.boot.model.internal.PropertyHolder;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.PropertyData;
import org.hibernate.dialect.Dialect;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Any;
import org.hibernate.mapping.BasicValue;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.MappedSuperclass;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.SyntheticProperty;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.Value;
import org.hibernate.property.access.spi.BuiltInPropertyAccessStrategies;
import org.hibernate.type.descriptor.java.JavaType;
import org.jboss.logging.Logger;

public class BinderHelper {
    private static final Logger log = CoreLogging.logger(BinderHelper.class);
    public static final Set<String> PRIMITIVE_NAMES = Set.of(Byte.TYPE.getName(), Short.TYPE.getName(), Integer.TYPE.getName(), Long.TYPE.getName(), Float.TYPE.getName(), Double.TYPE.getName(), Character.TYPE.getName(), Boolean.TYPE.getName());

    private BinderHelper() {
    }

    public static boolean isPrimitive(String elementTypeName) {
        return PRIMITIVE_NAMES.contains(elementTypeName);
    }

    public static void createSyntheticPropertyReference(AnnotatedJoinColumns joinColumns, PersistentClass targetEntity, PersistentClass associatedEntity, Value value, String propertyName, boolean inverse, MetadataBuildingContext context) {
        if (joinColumns.getReferencedColumnsType(targetEntity) == ForeignKeyType.NON_PRIMARY_KEY_REFERENCE) {
            Object columnOwner = BinderHelper.findReferencedColumnOwner(targetEntity, joinColumns.getJoinColumns().get(0), context);
            BinderHelper.checkColumnInSameTable(joinColumns, targetEntity, associatedEntity, context, columnOwner);
            List<Property> properties = BinderHelper.findPropertiesByColumns(columnOwner, joinColumns, associatedEntity, context);
            Property property = BinderHelper.referencedProperty(targetEntity, associatedEntity, propertyName, inverse, columnOwner, properties, context);
            BinderHelper.registerSyntheticProperty(targetEntity, value, inverse, associatedEntity, propertyName, property.getName(), context);
        }
    }

    private static void checkColumnInSameTable(AnnotatedJoinColumns joinColumns, PersistentClass targetEntity, PersistentClass associatedEntity, MetadataBuildingContext context, Object columnOwner) {
        if (joinColumns.hasMappedBy()) {
            throw new AssertionFailure("no need to create synthetic properties for unowned collections");
        }
        for (AnnotatedJoinColumn column : joinColumns.getJoinColumns()) {
            Object owner = BinderHelper.findReferencedColumnOwner(targetEntity, column, context);
            if (owner == null) {
                throw new AnnotationException("A '@JoinColumn' for association " + BinderHelper.associationMessage(associatedEntity, joinColumns) + " references a column named '" + column.getReferencedColumn() + "' which is not mapped by the target entity '" + targetEntity.getEntityName() + "'");
            }
            if (owner == columnOwner) continue;
            AnnotatedJoinColumn firstColumn = joinColumns.getJoinColumns().get(0);
            throw new AnnotationException("The '@JoinColumn's for association " + BinderHelper.associationMessage(associatedEntity, joinColumns) + " reference columns of different tables mapped by the target entity '" + targetEntity.getEntityName() + "' ('" + column.getReferencedColumn() + "' belongs to a different table to '" + firstColumn.getReferencedColumn() + "'");
        }
    }

    private static Property referencedProperty(PersistentClass ownerEntity, PersistentClass associatedEntity, String propertyName, boolean inverse, Object columnOwner, List<Property> properties, MetadataBuildingContext context) {
        if (properties.size() == 1 && ownerEntity == columnOwner && !(properties.get(0).getValue() instanceof ToOne)) {
            return properties.get(0);
        }
        String syntheticPropertyName = BinderHelper.syntheticPropertyName(propertyName, inverse, associatedEntity);
        return BinderHelper.makeSyntheticComponentProperty(ownerEntity, columnOwner, context, syntheticPropertyName, properties);
    }

    private static void registerSyntheticProperty(PersistentClass ownerEntity, Value value, boolean inverse, PersistentClass associatedClass, String propertyName, String syntheticPropertyName, MetadataBuildingContext context) {
        if (value instanceof ToOne) {
            ((ToOne)value).setReferencedPropertyName(syntheticPropertyName);
            ((ToOne)value).setReferenceToPrimaryKey(false);
            context.getMetadataCollector().addUniquePropertyReference(ownerEntity.getEntityName(), syntheticPropertyName);
        } else if (value instanceof Collection) {
            ((Collection)value).setReferencedPropertyName(syntheticPropertyName);
            context.getMetadataCollector().addPropertyReference(ownerEntity.getEntityName(), syntheticPropertyName);
        } else {
            throw new AssertionFailure("Do a property ref on an unexpected Value type: " + value.getClass().getName());
        }
        context.getMetadataCollector().addPropertyReferencedAssociation((inverse ? "inverse__" : "") + associatedClass.getEntityName(), propertyName, syntheticPropertyName);
    }

    private static String syntheticPropertyName(String propertyName, boolean inverse, PersistentClass associatedClass) {
        String syntheticPropertyName = ("_" + associatedClass.getEntityName() + "_" + propertyName).replace('.', '_');
        return inverse ? syntheticPropertyName + "_inverse" : syntheticPropertyName;
    }

    private static String associationMessage(PersistentClass associatedEntity, AnnotatedJoinColumns joinColumns) {
        if (associatedEntity != null) {
            return "'" + associatedEntity.getEntityName() + "." + joinColumns.getPropertyName() + "'";
        }
        if (joinColumns.getPropertyHolder() != null) {
            return "'" + joinColumns.getPropertyHolder().getEntityName() + "." + joinColumns.getPropertyName() + "'";
        }
        return "";
    }

    private static Property makeSyntheticComponentProperty(PersistentClass ownerEntity, Object persistentClassOrJoin, MetadataBuildingContext context, String syntheticPropertyName, List<Property> properties) {
        Component embeddedComponent = persistentClassOrJoin instanceof PersistentClass ? new Component(context, (PersistentClass)persistentClassOrJoin) : new Component(context, (Join)persistentClassOrJoin);
        embeddedComponent.setComponentClassName(embeddedComponent.getOwner().getClassName());
        embeddedComponent.setEmbedded(true);
        for (Property property : properties) {
            embeddedComponent.addProperty(BinderHelper.cloneProperty(ownerEntity, context, property));
        }
        embeddedComponent.sortProperties();
        SyntheticProperty result = new SyntheticProperty();
        result.setName(syntheticPropertyName);
        result.setPersistentClass(ownerEntity);
        result.setUpdateable(false);
        result.setInsertable(false);
        result.setValue(embeddedComponent);
        result.setPropertyAccessorName("embedded");
        ownerEntity.addProperty(result);
        embeddedComponent.createUniqueKey();
        return result;
    }

    private static Property cloneProperty(PersistentClass ownerEntity, MetadataBuildingContext context, Property property) {
        if (property.isComposite()) {
            Component component = (Component)property.getValue();
            Component copy = new Component(context, component);
            copy.setComponentClassName(component.getComponentClassName());
            copy.setEmbedded(component.isEmbedded());
            for (Property subproperty : component.getProperties()) {
                copy.addProperty(BinderHelper.cloneProperty(ownerEntity, context, subproperty));
            }
            copy.sortProperties();
            SyntheticProperty result = new SyntheticProperty();
            result.setName(property.getName());
            result.setPersistentClass(ownerEntity);
            result.setUpdateable(false);
            result.setInsertable(false);
            result.setValue(copy);
            result.setPropertyAccessorName(property.getPropertyAccessorName());
            return result;
        }
        Property clone = BinderHelper.shallowCopy(property);
        clone.setInsertable(false);
        clone.setUpdateable(false);
        clone.setNaturalIdentifier(false);
        clone.setValueGeneratorCreator(property.getValueGeneratorCreator());
        return clone;
    }

    public static Property shallowCopy(Property property) {
        SyntheticProperty clone = new SyntheticProperty();
        clone.setCascade(property.getCascade());
        clone.setInsertable(property.isInsertable());
        clone.setLazy(property.isLazy());
        clone.setName(property.getName());
        clone.setNaturalIdentifier(property.isNaturalIdentifier());
        clone.setOptimisticLocked(property.isOptimisticLocked());
        clone.setOptional(property.isOptional());
        clone.setPersistentClass(property.getPersistentClass());
        clone.setPropertyAccessorName(property.getPropertyAccessorName());
        clone.setSelectable(property.isSelectable());
        clone.setUpdateable(property.isUpdateable());
        clone.setValue(property.getValue());
        return clone;
    }

    /*
     * WARNING - void declaration
     */
    private static List<Property> findPropertiesByColumns(Object columnOwner, AnnotatedJoinColumns columns, PersistentClass associatedEntity, MetadataBuildingContext context) {
        Table referencedTable;
        if (columnOwner instanceof PersistentClass) {
            referencedTable = ((PersistentClass)columnOwner).getTable();
        } else if (columnOwner instanceof Join) {
            referencedTable = ((Join)columnOwner).getTable();
        } else {
            throw new AssertionFailure((String)(columnOwner == null ? "columnOwner is null" : "columnOwner neither PersistentClass nor Join: " + columnOwner.getClass()));
        }
        ArrayList<org.hibernate.mapping.Column> orderedColumns = new ArrayList<org.hibernate.mapping.Column>(columns.getJoinColumns().size());
        HashMap<org.hibernate.mapping.Column, Set<Property>> columnsToProperty = new HashMap<org.hibernate.mapping.Column, Set<Property>>();
        InFlightMetadataCollector collector = context.getMetadataCollector();
        for (AnnotatedJoinColumn annotatedJoinColumn : columns.getJoinColumns()) {
            if (annotatedJoinColumn.isReferenceImplicit()) {
                throw new AnnotationException("Association " + BinderHelper.associationMessage(associatedEntity, columns) + " has a '@JoinColumn' which does not specify the 'referencedColumnName' (when an association has multiple '@JoinColumn's, they must each specify their 'referencedColumnName')");
            }
            String string = collector.getPhysicalColumnName(referencedTable, annotatedJoinColumn.getReferencedColumn());
            org.hibernate.mapping.Column column = new org.hibernate.mapping.Column(string);
            orderedColumns.add(column);
            columnsToProperty.put(column, new HashSet());
        }
        if (columnOwner instanceof PersistentClass) {
            PersistentClass persistentClass = (PersistentClass)columnOwner;
            for (Property property : persistentClass.getProperties()) {
                BinderHelper.matchColumnsByProperty(property, columnsToProperty);
            }
            if (persistentClass.hasIdentifierProperty()) {
                BinderHelper.matchColumnsByProperty(persistentClass.getIdentifierProperty(), columnsToProperty);
            } else {
                Component component = persistentClass.getIdentifierMapper();
                for (Property p : component.getProperties()) {
                    BinderHelper.matchColumnsByProperty(p, columnsToProperty);
                }
            }
        } else {
            for (Property property : ((Join)columnOwner).getProperties()) {
                BinderHelper.matchColumnsByProperty(property, columnsToProperty);
            }
        }
        ArrayList<Property> orderedProperties = new ArrayList<Property>();
        boolean bl = false;
        Object var10_23 = null;
        for (org.hibernate.mapping.Column column : orderedColumns) {
            boolean bl2;
            void var10_24;
            Set properties = (Set)columnsToProperty.get(column);
            if (properties.isEmpty()) {
                throw new AnnotationException("Referenced column '" + column.getName() + "' in '@JoinColumn' for " + BinderHelper.associationMessage(associatedEntity, columns) + " is not mapped by any property of the target entity");
            }
            Iterator iterator = properties.iterator();
            if (!iterator.hasNext()) continue;
            Property property = (Property)iterator.next();
            if (property == var10_24) {
                if (!property.getColumns().get(bl2 ? 1 : 0).equals(column)) {
                    throw new AnnotationException("Referenced column '" + column.getName() + "' mapped by target property '" + property.getName() + "' occurs out of order in the list of '@JoinColumn's for association " + BinderHelper.associationMessage(associatedEntity, columns));
                }
                if ((bl2 += 1) != var10_24.getColumnSpan()) continue;
                Object var10_25 = null;
                bl2 = false;
                continue;
            }
            if (var10_24 != null) {
                throw new AnnotationException("Target property '" + property.getName() + "' has " + property.getColumnSpan() + " columns which must be referenced by a '@JoinColumn' for " + BinderHelper.associationMessage(associatedEntity, columns) + " (every column mapped by '" + property.getName() + "' must occur exactly once as a 'referencedColumnName', and in the correct order)");
            }
            if (orderedProperties.contains(property)) {
                throw new AnnotationException("Target property '" + property.getName() + "' has only " + property.getColumnSpan() + " columns which may be referenced by a '@JoinColumn' for " + BinderHelper.associationMessage(associatedEntity, columns) + " (each column mapped by '" + property.getName() + "' may only occur once as a 'referencedColumnName')");
            }
            orderedProperties.add(property);
            if (property.getColumnSpan() <= 1) continue;
            if (!property.getColumns().get(0).equals(column)) {
                throw new AnnotationException("Referenced column '" + column.getName() + "' mapped by target property '" + property.getName() + "' occurs out of order in the list of '@JoinColumn's");
            }
            Property property2 = property;
            bl2 = true;
        }
        return orderedProperties;
    }

    private static void matchColumnsByProperty(Property property, Map<org.hibernate.mapping.Column, Set<Property>> columnsToProperty) {
        if (property != null && BuiltInPropertyAccessStrategies.NOOP != BuiltInPropertyAccessStrategies.interpret(property.getPropertyAccessorName()) && BuiltInPropertyAccessStrategies.EMBEDDED != BuiltInPropertyAccessStrategies.interpret(property.getPropertyAccessorName())) {
            for (Selectable selectable : property.getSelectables()) {
                if (!columnsToProperty.containsKey(selectable)) continue;
                columnsToProperty.get(selectable).add(property);
            }
        }
    }

    public static Property findPropertyByName(PersistentClass associatedClass, String propertyName) {
        Property property = null;
        Property idProperty = associatedClass.getIdentifierProperty();
        String idName = idProperty == null ? null : idProperty.getName();
        try {
            if (StringHelper.isEmpty(propertyName) || propertyName.equals(idName)) {
                property = idProperty;
            } else {
                if (propertyName.indexOf(idName + ".") == 0) {
                    property = idProperty;
                    propertyName = propertyName.substring(idName.length() + 1);
                }
                StringTokenizer st = new StringTokenizer(propertyName, ".", false);
                while (st.hasMoreElements()) {
                    String element = (String)st.nextElement();
                    if (property == null) {
                        property = associatedClass.getProperty(element);
                        continue;
                    }
                    if (!property.isComposite()) {
                        return null;
                    }
                    property = ((Component)property.getValue()).getProperty(element);
                }
            }
        }
        catch (MappingException e) {
            try {
                if (associatedClass.getIdentifierMapper() == null) {
                    return null;
                }
                StringTokenizer st = new StringTokenizer(propertyName, ".", false);
                while (st.hasMoreElements()) {
                    String element = (String)st.nextElement();
                    if (property == null) {
                        property = associatedClass.getIdentifierMapper().getProperty(element);
                        continue;
                    }
                    if (!property.isComposite()) {
                        return null;
                    }
                    property = ((Component)property.getValue()).getProperty(element);
                }
            }
            catch (MappingException ee) {
                return null;
            }
        }
        return property;
    }

    public static Property findPropertyByName(Component component, String propertyName) {
        Property property = null;
        try {
            if (propertyName == null || propertyName.length() == 0) {
                return null;
            }
            StringTokenizer st = new StringTokenizer(propertyName, ".", false);
            while (st.hasMoreElements()) {
                String element = (String)st.nextElement();
                if (property == null) {
                    property = component.getProperty(element);
                    continue;
                }
                if (!property.isComposite()) {
                    return null;
                }
                property = ((Component)property.getValue()).getProperty(element);
            }
        }
        catch (MappingException e) {
            try {
                if (component.getOwner().getIdentifierMapper() == null) {
                    return null;
                }
                StringTokenizer st = new StringTokenizer(propertyName, ".", false);
                while (st.hasMoreElements()) {
                    String element = (String)st.nextElement();
                    if (property == null) {
                        property = component.getOwner().getIdentifierMapper().getProperty(element);
                        continue;
                    }
                    if (!property.isComposite()) {
                        return null;
                    }
                    property = ((Component)property.getValue()).getProperty(element);
                }
            }
            catch (MappingException ee) {
                return null;
            }
        }
        return property;
    }

    public static String getRelativePath(PropertyHolder propertyHolder, String propertyName) {
        if (propertyHolder == null) {
            return propertyName;
        }
        String path = propertyHolder.getPath();
        String entityName = propertyHolder.getPersistentClass().getEntityName();
        return path.length() == entityName.length() ? propertyName : StringHelper.qualify(path.substring(entityName.length() + 1), propertyName);
    }

    public static Object findReferencedColumnOwner(PersistentClass persistentClass, AnnotatedJoinColumn joinColumn, MetadataBuildingContext context) {
        return joinColumn.isImplicit() || joinColumn.isReferenceImplicit() ? persistentClass : BinderHelper.findColumnOwner(persistentClass, joinColumn.getReferencedColumn(), context);
    }

    public static Object findColumnOwner(PersistentClass persistentClass, String columnName, MetadataBuildingContext context) {
        for (PersistentClass current = persistentClass; current != null; current = current.getSuperclass()) {
            try {
                context.getMetadataCollector().getPhysicalColumnName(current.getTable(), columnName);
                return current;
            }
            catch (MappingException mappingException) {
                for (Join join : current.getJoins()) {
                    try {
                        context.getMetadataCollector().getPhysicalColumnName(join.getTable(), columnName);
                        return join;
                    }
                    catch (MappingException mappingException2) {
                    }
                }
                continue;
            }
        }
        return null;
    }

    public static void makeIdGenerator(SimpleValue id, XProperty property, String generatorType, String generatorName, MetadataBuildingContext buildingContext, Map<String, IdentifierGeneratorDefinition> localGenerators) {
        log.debugf("#makeIdGenerator(%s, %s, %s, %s, ...)", new Object[]{id, property, generatorType, generatorName});
        Table table = id.getTable();
        table.setIdentifierValue(id);
        id.setIdentifierGeneratorStrategy(generatorType);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("target_table", table.getName());
        if (id.getColumnSpan() == 1) {
            parameters.put("target_column", id.getColumns().get(0).getName());
        }
        parameters.put("identifier_normalizer", buildingContext.getObjectNameNormalizer());
        parameters.put("GENERATOR_NAME", generatorName);
        if (!generatorName.isEmpty()) {
            boolean avoidOverriding;
            IdentifierGeneratorDefinition definition = BinderHelper.makeIdentifierGeneratorDefinition(generatorName, property, localGenerators, buildingContext);
            if (definition == null) {
                throw new AnnotationException("No id generator was declared with the name '" + generatorName + "' specified by '@GeneratedValue' (define a named generator using '@SequenceGenerator', '@TableGenerator', or '@GenericGenerator')");
            }
            String identifierGeneratorStrategy = definition.getStrategy();
            boolean bl = avoidOverriding = identifierGeneratorStrategy.equals("identity") || identifierGeneratorStrategy.equals("seqhilo");
            if (generatorType == null || !avoidOverriding) {
                id.setIdentifierGeneratorStrategy(identifierGeneratorStrategy);
                if (identifierGeneratorStrategy.equals("assigned")) {
                    id.setNullValue("undefined");
                }
            }
            parameters.putAll(definition.getParameters());
        }
        if ("assigned".equals(generatorType)) {
            id.setNullValue("undefined");
        }
        id.setIdentifierGeneratorParameters(parameters);
    }

    public static void makeIdGenerator(SimpleValue id, XProperty idXProperty, String generatorType, String generatorName, MetadataBuildingContext buildingContext, IdentifierGeneratorDefinition foreignKGeneratorDefinition) {
        HashMap<String, IdentifierGeneratorDefinition> localIdentifiers = null;
        if (foreignKGeneratorDefinition != null) {
            localIdentifiers = new HashMap<String, IdentifierGeneratorDefinition>();
            localIdentifiers.put(foreignKGeneratorDefinition.getName(), foreignKGeneratorDefinition);
        }
        BinderHelper.makeIdGenerator(id, idXProperty, generatorType, generatorName, buildingContext, localIdentifiers);
    }

    private static IdentifierGeneratorDefinition makeIdentifierGeneratorDefinition(String name, XProperty idXProperty, Map<String, IdentifierGeneratorDefinition> localGenerators, MetadataBuildingContext buildingContext) {
        IdentifierGeneratorDefinition result;
        if (localGenerators != null && (result = localGenerators.get(name)) != null) {
            return result;
        }
        IdentifierGeneratorDefinition globalDefinition = buildingContext.getMetadataCollector().getIdentifierGenerator(name);
        if (globalDefinition != null) {
            return globalDefinition;
        }
        log.debugf("Could not resolve explicit IdentifierGeneratorDefinition - using implicit interpretation (%s)", (Object)name);
        GeneratedValue generatedValue = (GeneratedValue)idXProperty.getAnnotation(GeneratedValue.class);
        if (generatedValue == null) {
            return new IdentifierGeneratorDefinition("assigned", "assigned");
        }
        return IdentifierGeneratorDefinition.createImplicit(name, buildingContext.getBootstrapContext().getReflectionManager().toClass(idXProperty.getType()), generatedValue.generator(), buildingContext.getBuildingOptions().getIdGenerationTypeInterpreter(), BinderHelper.interpretGenerationType(generatedValue));
    }

    private static GenerationType interpretGenerationType(GeneratedValue generatedValueAnn) {
        return generatedValueAnn.strategy() == null ? GenerationType.AUTO : generatedValueAnn.strategy();
    }

    public static Any buildAnyValue(Column discriminatorColumn, Formula discriminatorFormula, AnnotatedJoinColumns keyColumns, PropertyData inferredData, OnDeleteAction onDeleteAction, boolean lazy, Nullability nullability, PropertyHolder propertyHolder, EntityBinder entityBinder, boolean optional, MetadataBuildingContext context) {
        XProperty property = inferredData.getProperty();
        Any value = new Any(context, keyColumns.getTable(), true);
        value.setLazy(lazy);
        value.setOnDeleteAction(onDeleteAction);
        BasicValueBinder discriminatorValueBinder = new BasicValueBinder(BasicValueBinder.Kind.ANY_DISCRIMINATOR, context);
        AnnotatedColumns discriminatorColumns = AnnotatedColumn.buildColumnOrFormulaFromAnnotation(discriminatorColumn, discriminatorFormula, null, nullability, propertyHolder, inferredData, entityBinder.getSecondaryTables(), context);
        assert (discriminatorColumns.getColumns().size() == 1);
        discriminatorColumns.setTable(value.getTable());
        discriminatorValueBinder.setColumns(discriminatorColumns);
        discriminatorValueBinder.setReturnedClassName(inferredData.getTypeName());
        discriminatorValueBinder.setType(property, property.getType(), null, null);
        BasicValue discriminatorDescriptor = discriminatorValueBinder.make();
        value.setDiscriminator(discriminatorDescriptor);
        discriminatorValueBinder.fillSimpleValue();
        AnnotatedColumn firstDiscriminatorColumn = discriminatorColumns.getColumns().get(0);
        firstDiscriminatorColumn.linkWithValue(discriminatorDescriptor);
        JavaType<?> discriminatorJavaType = discriminatorDescriptor.resolve().getRelationalJavaType();
        HashMap discriminatorValueMappings = new HashMap();
        BinderHelper.processAnyDiscriminatorValues(inferredData.getProperty(), valueMapping -> discriminatorValueMappings.put(discriminatorJavaType.wrap(valueMapping.discriminator(), null), valueMapping.entity()));
        value.setDiscriminatorValueMappings(discriminatorValueMappings);
        BasicValueBinder keyValueBinder = new BasicValueBinder(BasicValueBinder.Kind.ANY_KEY, context);
        List<AnnotatedJoinColumn> columns = keyColumns.getJoinColumns();
        assert (columns.size() == 1);
        keyColumns.setTable(value.getTable());
        keyValueBinder.setColumns(keyColumns);
        if (!optional) {
            for (AnnotatedJoinColumn column : columns) {
                column.setNullable(false);
            }
        }
        keyValueBinder.setType(property, property.getType(), null, null);
        BasicValue keyDescriptor = keyValueBinder.make();
        value.setKey(keyDescriptor);
        keyValueBinder.fillSimpleValue();
        keyColumns.checkPropertyConsistency();
        columns.get(0).linkWithValue(keyDescriptor);
        return value;
    }

    private static void processAnyDiscriminatorValues(XProperty property, Consumer<AnyDiscriminatorValue> consumer) {
        AnyDiscriminatorValue[] valueAnns;
        AnyDiscriminatorValue valueAnn = (AnyDiscriminatorValue)property.getAnnotation(AnyDiscriminatorValue.class);
        if (valueAnn != null) {
            consumer.accept(valueAnn);
            return;
        }
        AnyDiscriminatorValues valuesAnn = (AnyDiscriminatorValues)property.getAnnotation(AnyDiscriminatorValues.class);
        if (valuesAnn != null && (valueAnns = valuesAnn.value()) != null && valueAnns.length > 0) {
            for (AnyDiscriminatorValue ann : valueAnns) {
                consumer.accept(ann);
            }
        }
    }

    public static MappedSuperclass getMappedSuperclassOrNull(XClass declaringClass, Map<XClass, InheritanceState> inheritanceStatePerClass, MetadataBuildingContext context) {
        boolean retrieve = false;
        if (declaringClass != null) {
            InheritanceState inheritanceState = inheritanceStatePerClass.get(declaringClass);
            if (inheritanceState == null) {
                throw new AssertionFailure("Declaring class is not found in the inheritance state hierarchy: " + declaringClass);
            }
            if (inheritanceState.isEmbeddableSuperclass()) {
                retrieve = true;
            }
        }
        if (retrieve) {
            return context.getMetadataCollector().getMappedSuperclass(context.getBootstrapContext().getReflectionManager().toClass(declaringClass));
        }
        return null;
    }

    public static String getPath(PropertyHolder holder, PropertyData property) {
        return StringHelper.qualify(holder.getPath(), property.getPropertyName());
    }

    static PropertyData getPropertyOverriddenByMapperOrMapsId(boolean isId, PropertyHolder propertyHolder, String propertyName, MetadataBuildingContext buildingContext) {
        XClass mappedClass = buildingContext.getBootstrapContext().getReflectionManager().toXClass(propertyHolder.getPersistentClass().getMappedClass());
        InFlightMetadataCollector metadataCollector = buildingContext.getMetadataCollector();
        if (propertyHolder.isInIdClass()) {
            PropertyData propertyData = metadataCollector.getPropertyAnnotatedWithIdAndToOne(mappedClass, propertyName);
            return propertyData == null && buildingContext.getBuildingOptions().isSpecjProprietarySyntaxEnabled() ? metadataCollector.getPropertyAnnotatedWithMapsId(mappedClass, propertyName) : propertyData;
        }
        return metadataCollector.getPropertyAnnotatedWithMapsId(mappedClass, isId ? "" : propertyName);
    }

    public static Map<String, String> toAliasTableMap(SqlFragmentAlias[] aliases) {
        HashMap<String, String> ret = new HashMap<String, String>();
        for (SqlFragmentAlias aliase : aliases) {
            if (!StringHelper.isNotEmpty(aliase.table())) continue;
            ret.put(aliase.alias(), aliase.table());
        }
        return ret;
    }

    public static Map<String, String> toAliasEntityMap(SqlFragmentAlias[] aliases) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (SqlFragmentAlias aliase : aliases) {
            if (aliase.entity() == Void.TYPE) continue;
            result.put(aliase.alias(), aliase.entity().getName());
        }
        return result;
    }

    public static boolean hasToOneAnnotation(XAnnotatedElement property) {
        return property.isAnnotationPresent(ManyToOne.class) || property.isAnnotationPresent(OneToOne.class);
    }

    public static <T extends Annotation> T getOverridableAnnotation(XAnnotatedElement element, Class<T> annotationType, MetadataBuildingContext context) {
        Dialect dialect = context.getMetadataCollector().getDatabase().getDialect();
        Iterator annotations = Arrays.stream(element.getAnnotations()).flatMap(annotation -> {
            try {
                Method value = annotation.annotationType().getDeclaredMethod("value", new Class[0]);
                Class<?> returnType = value.getReturnType();
                if (returnType.isArray() && returnType.getComponentType().isAnnotationPresent(Repeatable.class) && returnType.getComponentType().isAnnotationPresent(DialectOverride.OverridesAnnotation.class)) {
                    return Stream.of((Annotation[])value.invoke(annotation, new Object[0]));
                }
            }
            catch (NoSuchMethodException value) {
            }
            catch (Exception e) {
                throw new AssertionFailure("could not read @DialectOverride annotation", e);
            }
            return Stream.of(annotation);
        }).iterator();
        while (annotations.hasNext()) {
            Annotation annotation2 = (Annotation)annotations.next();
            Class<? extends Annotation> type = annotation2.annotationType();
            DialectOverride.OverridesAnnotation overridesAnnotation = type.getAnnotation(DialectOverride.OverridesAnnotation.class);
            if (overridesAnnotation == null || !overridesAnnotation.value().equals(annotationType)) continue;
            try {
                Class overrideDialect = (Class)type.getDeclaredMethod("dialect", new Class[0]).invoke((Object)annotation2, new Object[0]);
                if (!overrideDialect.isAssignableFrom(dialect.getClass())) continue;
                DialectOverride.Version before = (DialectOverride.Version)type.getDeclaredMethod("before", new Class[0]).invoke((Object)annotation2, new Object[0]);
                DialectOverride.Version sameOrAfter = (DialectOverride.Version)type.getDeclaredMethod("sameOrAfter", new Class[0]).invoke((Object)annotation2, new Object[0]);
                if (!dialect.getVersion().isBefore(before.major(), before.minor()) || !dialect.getVersion().isSameOrAfter(sameOrAfter.major(), sameOrAfter.minor())) continue;
                return (T)((Annotation)type.getDeclaredMethod("override", new Class[0]).invoke((Object)annotation2, new Object[0]));
            }
            catch (Exception e) {
                throw new AssertionFailure("could not read @DialectOverride annotation", e);
            }
        }
        return (T)element.getAnnotation(annotationType);
    }

    public static FetchMode getFetchMode(FetchType fetch) {
        switch (fetch) {
            case EAGER: {
                return FetchMode.JOIN;
            }
            case LAZY: {
                return FetchMode.SELECT;
            }
        }
        throw new AssertionFailure("unknown fetch type: " + fetch);
    }

    private static CascadeType convertCascadeType(jakarta.persistence.CascadeType cascade) {
        switch (cascade) {
            case ALL: {
                return CascadeType.ALL;
            }
            case PERSIST: {
                return CascadeType.PERSIST;
            }
            case MERGE: {
                return CascadeType.MERGE;
            }
            case REMOVE: {
                return CascadeType.REMOVE;
            }
            case REFRESH: {
                return CascadeType.REFRESH;
            }
            case DETACH: {
                return CascadeType.DETACH;
            }
        }
        throw new AssertionFailure("unknown cascade type: " + cascade);
    }

    private static EnumSet<CascadeType> convertToHibernateCascadeType(jakarta.persistence.CascadeType[] ejbCascades) {
        EnumSet<CascadeType> cascadeTypes = EnumSet.noneOf(CascadeType.class);
        if (ejbCascades != null && ejbCascades.length > 0) {
            for (jakarta.persistence.CascadeType cascade : ejbCascades) {
                cascadeTypes.add(BinderHelper.convertCascadeType(cascade));
            }
        }
        return cascadeTypes;
    }

    public static String getCascadeStrategy(jakarta.persistence.CascadeType[] ejbCascades, Cascade hibernateCascadeAnnotation, boolean orphanRemoval, boolean forcePersist) {
        CascadeType[] hibernateCascades;
        EnumSet<CascadeType> cascadeTypes = BinderHelper.convertToHibernateCascadeType(ejbCascades);
        CascadeType[] cascadeTypeArray = hibernateCascades = hibernateCascadeAnnotation == null ? null : hibernateCascadeAnnotation.value();
        if (hibernateCascades != null && hibernateCascades.length > 0) {
            cascadeTypes.addAll(Arrays.asList(hibernateCascades));
        }
        if (orphanRemoval) {
            cascadeTypes.add(CascadeType.DELETE_ORPHAN);
            cascadeTypes.add(CascadeType.REMOVE);
        }
        if (forcePersist) {
            cascadeTypes.add(CascadeType.PERSIST);
        }
        return BinderHelper.renderCascadeTypeList(cascadeTypes);
    }

    private static String renderCascadeTypeList(EnumSet<CascadeType> cascadeTypes) {
        StringBuilder cascade = new StringBuilder();
        for (CascadeType cascadeType : cascadeTypes) {
            switch (cascadeType) {
                case ALL: {
                    cascade.append(",").append("all");
                    break;
                }
                case SAVE_UPDATE: {
                    cascade.append(",").append("save-update");
                    break;
                }
                case PERSIST: {
                    cascade.append(",").append("persist");
                    break;
                }
                case MERGE: {
                    cascade.append(",").append("merge");
                    break;
                }
                case LOCK: {
                    cascade.append(",").append("lock");
                    break;
                }
                case REFRESH: {
                    cascade.append(",").append("refresh");
                    break;
                }
                case REPLICATE: {
                    cascade.append(",").append("replicate");
                    break;
                }
                case DETACH: {
                    cascade.append(",").append("evict");
                    break;
                }
                case DELETE: 
                case REMOVE: {
                    cascade.append(",").append("delete");
                    break;
                }
                case DELETE_ORPHAN: {
                    cascade.append(",").append("delete-orphan");
                }
            }
        }
        return cascade.length() > 0 ? cascade.substring(1) : "none";
    }
}

