/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import org.hibernate.HibernateException;
import org.hibernate.Internal;
import org.hibernate.annotations.common.reflection.XAnnotatedElement;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.annotations.common.reflection.java.JavaXMember;

@Internal
public final class HCANNHelper {
    public static boolean hasAnnotation(AnnotatedElement element, Class<? extends Annotation> annotationToCheck) {
        if (element == null) {
            return false;
        }
        return element.isAnnotationPresent(annotationToCheck);
    }

    public static boolean hasAnnotation(AnnotatedElement element, Class<? extends Annotation> annotationToCheck, Class<? extends Annotation> annotationToCheck2) {
        if (element == null) {
            return false;
        }
        return element.isAnnotationPresent(annotationToCheck) || element.isAnnotationPresent(annotationToCheck2);
    }

    public static boolean hasAnnotation(XAnnotatedElement element, Class<? extends Annotation> annotationToCheck) {
        if (element == null) {
            return false;
        }
        return element.isAnnotationPresent(annotationToCheck);
    }

    public static boolean hasAnnotation(XAnnotatedElement element, Class<? extends Annotation> annotationToCheck, Class<? extends Annotation> annotationToCheck2) {
        if (element == null) {
            return false;
        }
        return element.isAnnotationPresent(annotationToCheck) || element.isAnnotationPresent(annotationToCheck2);
    }

    public static boolean hasAnnotation(XAnnotatedElement element, Class<? extends Annotation> ... annotationsToCheck) {
        assert (annotationsToCheck != null && annotationsToCheck.length > 0);
        if (element == null) {
            return false;
        }
        for (int i = 0; i < annotationsToCheck.length; ++i) {
            if (!element.isAnnotationPresent(annotationsToCheck[i])) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static String annotatedElementSignature(XProperty xProperty) {
        return HCANNHelper.getUnderlyingMember(xProperty).toString();
    }

    public static String annotatedElementSignature(JavaXMember jxProperty) {
        return HCANNHelper.getUnderlyingMember(jxProperty).toString();
    }

    @Deprecated
    public static Member getUnderlyingMember(XProperty xProperty) {
        if (xProperty instanceof JavaXMember) {
            JavaXMember jx = (JavaXMember)xProperty;
            return jx.getMember();
        }
        throw new HibernateException("Can only extract Member from a XProperty which is a JavaXMember");
    }

    public static Member getUnderlyingMember(JavaXMember jxProperty) {
        return jxProperty.getMember();
    }

    public static <T extends Annotation> T findAnnotation(XAnnotatedElement xAnnotatedElement, Class<T> annotationType) {
        Annotation direct = xAnnotatedElement.getAnnotation(annotationType);
        if (direct != null) {
            return (T)direct;
        }
        for (int i = 0; i < xAnnotatedElement.getAnnotations().length; ++i) {
            T metaAnn;
            Annotation annotation = xAnnotatedElement.getAnnotations()[i];
            if (annotationType.equals(annotation.getClass()) || (metaAnn = annotation.annotationType().getAnnotation(annotationType)) == null) continue;
            return metaAnn;
        }
        return null;
    }

    public static <A extends Annotation, T extends Annotation> A findContainingAnnotation(XAnnotatedElement xAnnotatedElement, Class<T> annotationType) {
        for (int i = 0; i < xAnnotatedElement.getAnnotations().length; ++i) {
            Annotation annotation = xAnnotatedElement.getAnnotations()[i];
            T metaAnn = annotation.annotationType().getAnnotation(annotationType);
            if (metaAnn == null) continue;
            return (A)annotation;
        }
        return null;
    }
}

