/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import java.util.Map;
import org.hibernate.MappingException;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.boot.model.IdentifierGeneratorDefinition;
import org.hibernate.boot.model.internal.BinderHelper;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.SecondPass;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.SimpleValue;

public class IdGeneratorResolverSecondPass
implements SecondPass {
    private final SimpleValue id;
    private final XProperty idXProperty;
    private final String generatorType;
    private final String generatorName;
    private final MetadataBuildingContext buildingContext;
    private IdentifierGeneratorDefinition localIdentifierGeneratorDefinition;

    public IdGeneratorResolverSecondPass(SimpleValue id, XProperty idXProperty, String generatorType, String generatorName, MetadataBuildingContext buildingContext) {
        this.id = id;
        this.idXProperty = idXProperty;
        this.generatorType = generatorType;
        this.generatorName = generatorName;
        this.buildingContext = buildingContext;
    }

    public IdGeneratorResolverSecondPass(SimpleValue id, XProperty idXProperty, String generatorType, String generatorName, MetadataBuildingContext buildingContext, IdentifierGeneratorDefinition localIdentifierGeneratorDefinition) {
        this(id, idXProperty, generatorType, generatorName, buildingContext);
        this.localIdentifierGeneratorDefinition = localIdentifierGeneratorDefinition;
    }

    @Override
    public void doSecondPass(Map<String, PersistentClass> idGeneratorDefinitionMap) throws MappingException {
        BinderHelper.makeIdGenerator(this.id, this.idXProperty, this.generatorType, this.generatorName, this.buildingContext, this.localIdentifierGeneratorDefinition);
    }
}

