/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.ForeignKey;
import java.util.Map;
import org.hibernate.AnnotationException;
import org.hibernate.MappingException;
import org.hibernate.annotations.LazyGroup;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.annotations.OnDeleteAction;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.boot.model.internal.AnnotatedJoinColumns;
import org.hibernate.boot.model.internal.BinderHelper;
import org.hibernate.boot.model.internal.PropertyBinder;
import org.hibernate.boot.model.internal.PropertyHolder;
import org.hibernate.boot.model.internal.ToOneBinder;
import org.hibernate.boot.model.internal.ToOneFkSecondPass;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.PropertyData;
import org.hibernate.boot.spi.SecondPass;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.DependantValue;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.OneToOne;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.SortableValue;
import org.hibernate.type.ForeignKeyDirection;

public class OneToOneSecondPass
implements SecondPass {
    private final MetadataBuildingContext buildingContext;
    private final String mappedBy;
    private final String ownerEntity;
    private final PropertyHolder propertyHolder;
    private final NotFoundAction notFoundAction;
    private final PropertyData inferredData;
    private final XClass targetEntity;
    private final OnDeleteAction onDeleteAction;
    private final boolean optional;
    private final String cascadeStrategy;
    private final AnnotatedJoinColumns joinColumns;

    public OneToOneSecondPass(String mappedBy, String ownerEntity, String ownerProperty, PropertyHolder propertyHolder, PropertyData inferredData, XClass targetEntity, NotFoundAction notFoundAction, OnDeleteAction onDeleteAction, boolean optional, String cascadeStrategy, AnnotatedJoinColumns columns, MetadataBuildingContext buildingContext) {
        this.ownerEntity = ownerEntity;
        this.mappedBy = mappedBy;
        this.propertyHolder = propertyHolder;
        this.buildingContext = buildingContext;
        this.notFoundAction = notFoundAction;
        this.inferredData = inferredData;
        this.targetEntity = targetEntity;
        this.onDeleteAction = onDeleteAction;
        this.optional = optional;
        this.cascadeStrategy = cascadeStrategy;
        this.joinColumns = columns;
    }

    @Override
    public void doSecondPass(Map<String, PersistentClass> persistentClasses) throws MappingException {
        OneToOne value = new OneToOne(this.buildingContext, this.propertyHolder.getTable(), this.propertyHolder.getPersistentClass());
        String propertyName = this.inferredData.getPropertyName();
        value.setPropertyName(propertyName);
        String referencedEntityName = ToOneBinder.getReferenceEntityName(this.inferredData, this.targetEntity, this.buildingContext);
        value.setReferencedEntityName(referencedEntityName);
        XProperty property = this.inferredData.getProperty();
        ToOneBinder.defineFetchingStrategy(value, property, this.inferredData, this.propertyHolder);
        value.setOnDeleteAction(this.onDeleteAction);
        value.setConstrained(!this.optional);
        value.setForeignKeyType(this.getForeignKeyDirection());
        ToOneBinder.bindForeignKeyNameAndDefinition(value, property, (ForeignKey)property.getAnnotation(ForeignKey.class), this.buildingContext);
        PropertyBinder binder = new PropertyBinder();
        binder.setName(propertyName);
        binder.setProperty(property);
        binder.setValue(value);
        binder.setCascade(this.cascadeStrategy);
        binder.setAccessType(this.inferredData.getDefaultAccess());
        LazyGroup lazyGroupAnnotation = (LazyGroup)property.getAnnotation(LazyGroup.class);
        if (lazyGroupAnnotation != null) {
            binder.setLazyGroup(lazyGroupAnnotation.value());
        }
        Property result = binder.makeProperty();
        result.setOptional(this.optional);
        if (this.mappedBy == null) {
            this.bindOwned(persistentClasses, value, propertyName, result);
        } else {
            this.bindUnowned(persistentClasses, value, result);
        }
        value.sortProperties();
    }

    private ForeignKeyDirection getForeignKeyDirection() {
        return this.mappedBy == null ? ForeignKeyDirection.FROM_PARENT : ForeignKeyDirection.TO_PARENT;
    }

    private void bindUnowned(Map<String, PersistentClass> persistentClasses, OneToOne oneToOne, Property property) {
        oneToOne.setMappedByProperty(this.mappedBy);
        PersistentClass targetEntity = persistentClasses.get(oneToOne.getReferencedEntityName());
        if (targetEntity == null) {
            throw new MappingException("Association '" + BinderHelper.getPath(this.propertyHolder, this.inferredData) + "' targets unknown entity type '" + oneToOne.getReferencedEntityName() + "'");
        }
        Property targetProperty = this.targetProperty(oneToOne, targetEntity);
        if (targetProperty.getValue() instanceof OneToOne) {
            this.propertyHolder.addProperty(property, this.inferredData.getDeclaringClass());
        } else if (targetProperty.getValue() instanceof ManyToOne) {
            this.bindTargetManyToOne(persistentClasses, oneToOne, property, targetEntity, targetProperty);
        } else {
            throw new AnnotationException("Association '" + BinderHelper.getPath(this.propertyHolder, this.inferredData) + "' is 'mappedBy' a property named '" + this.mappedBy + "' of the target entity type '" + oneToOne.getReferencedEntityName() + "' which is not a '@OneToOne' or '@ManyToOne' association");
        }
    }

    private void bindTargetManyToOne(Map<String, PersistentClass> persistentClasses, OneToOne oneToOne, Property property, PersistentClass targetEntity, Property targetProperty) {
        Join otherSideJoin = null;
        for (Join otherSideJoinValue : targetEntity.getJoins()) {
            if (!otherSideJoinValue.containsProperty(targetProperty)) continue;
            otherSideJoin = otherSideJoinValue;
            break;
        }
        if (otherSideJoin != null) {
            Join mappedByJoin = this.buildJoinFromMappedBySide(persistentClasses.get(this.ownerEntity), targetProperty, otherSideJoin);
            ManyToOne manyToOne = new ManyToOne(this.buildingContext, mappedByJoin.getTable());
            manyToOne.setNotFoundAction(this.notFoundAction);
            manyToOne.setOnDeleteAction(oneToOne.getOnDeleteAction());
            manyToOne.setFetchMode(oneToOne.getFetchMode());
            manyToOne.setLazy(oneToOne.isLazy());
            manyToOne.setReferencedEntityName(oneToOne.getReferencedEntityName());
            manyToOne.setUnwrapProxy(oneToOne.isUnwrapProxy());
            manyToOne.markAsLogicalOneToOne();
            property.setValue(manyToOne);
            for (Column column : otherSideJoin.getKey().getColumns()) {
                Column copy = new Column();
                copy.setLength(column.getLength());
                copy.setScale(column.getScale());
                copy.setValue(manyToOne);
                copy.setName(column.getQuotedName());
                copy.setNullable(column.isNullable());
                copy.setPrecision(column.getPrecision());
                copy.setUnique(column.isUnique());
                copy.setSqlType(column.getSqlType());
                copy.setCheckConstraint(column.getCheckConstraint());
                copy.setComment(column.getComment());
                copy.setDefaultValue(column.getDefaultValue());
                copy.setGeneratedAs(column.getGeneratedAs());
                manyToOne.addColumn(copy);
            }
            mappedByJoin.addProperty(property);
        } else {
            this.propertyHolder.addProperty(property, this.inferredData.getDeclaringClass());
        }
        oneToOne.setReferencedPropertyName(this.mappedBy);
        KeyValue targetEntityIdentifier = targetEntity.getIdentifier();
        boolean referenceToPrimaryKey = this.mappedBy == null || targetEntityIdentifier instanceof Component && !((Component)targetEntityIdentifier).hasProperty(this.mappedBy);
        oneToOne.setReferenceToPrimaryKey(referenceToPrimaryKey);
        String propertyRef = oneToOne.getReferencedPropertyName();
        if (propertyRef != null) {
            this.buildingContext.getMetadataCollector().addUniquePropertyReference(oneToOne.getReferencedEntityName(), propertyRef);
        }
    }

    private Property targetProperty(OneToOne oneToOne, PersistentClass targetEntity) {
        try {
            Property targetProperty = BinderHelper.findPropertyByName(targetEntity, this.mappedBy);
            if (targetProperty != null) {
                return targetProperty;
            }
        }
        catch (MappingException mappingException) {
            // empty catch block
        }
        throw new AnnotationException("Association '" + BinderHelper.getPath(this.propertyHolder, this.inferredData) + "' is 'mappedBy' a property named '" + this.mappedBy + "' which does not exist in the target entity type '" + oneToOne.getReferencedEntityName() + "'");
    }

    private void bindOwned(Map<String, PersistentClass> persistentClasses, OneToOne oneToOne, String propertyName, Property property) {
        ToOneFkSecondPass secondPass = new ToOneFkSecondPass(oneToOne, this.joinColumns, true, this.propertyHolder.getPersistentClass(), StringHelper.qualify(this.propertyHolder.getPath(), propertyName), this.buildingContext);
        secondPass.doSecondPass(persistentClasses);
        this.propertyHolder.addProperty(property, this.inferredData.getDeclaringClass());
    }

    private Join buildJoinFromMappedBySide(PersistentClass persistentClass, Property otherSideProperty, Join originalJoin) {
        Join join = new Join();
        join.setPersistentClass(persistentClass);
        join.setTable(originalJoin.getTable());
        join.setInverse(true);
        DependantValue key = new DependantValue(this.buildingContext, join.getTable(), persistentClass.getIdentifier());
        if (this.notFoundAction != null) {
            join.disableForeignKeyCreation();
        }
        join.setKey(key);
        join.setOptional(true);
        key.setOnDeleteAction(null);
        for (Column column : otherSideProperty.getValue().getColumns()) {
            Column copy = new Column();
            copy.setLength(column.getLength());
            copy.setScale(column.getScale());
            copy.setValue(key);
            copy.setName(column.getQuotedName());
            copy.setNullable(column.isNullable());
            copy.setPrecision(column.getPrecision());
            copy.setUnique(column.isUnique());
            copy.setSqlType(column.getSqlType());
            copy.setCheckConstraint(column.getCheckConstraint());
            copy.setComment(column.getComment());
            copy.setDefaultValue(column.getDefaultValue());
            column.setGeneratedAs(column.getGeneratedAs());
            key.addColumn(copy);
        }
        if (otherSideProperty.getValue() instanceof SortableValue && !((SortableValue)((Object)otherSideProperty.getValue())).isSorted()) {
            key.sortProperties();
        }
        persistentClass.addJoin(join);
        return join;
    }
}

